import React from "react";

export const IntegrationsIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width="40"
    height="40"
    viewBox="0 0 40 40"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="text-white dark:text-refine-pink/10"
    />
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="text-refine-pink"
      fillOpacity="0.1"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M18.7918 12.7507C19.7927 11.7498 21.4155 11.7498 22.4164 12.7507L23.6247 13.9589C23.9583 14.2925 23.9583 14.8335 23.6247 15.1671L23.0205 15.7712C22.6869 16.1049 22.6869 16.6458 23.0205 16.9795C23.3542 17.3131 23.8951 17.3131 24.2288 16.9795L24.8329 16.3753C25.1665 16.0417 25.7074 16.0417 26.0411 16.3753L27.2493 17.5836C28.2502 18.5845 28.2502 20.2073 27.2493 21.2082L26.0411 22.4164C27.042 23.4174 27.042 25.0402 26.0411 26.0411C25.0402 27.042 23.4174 27.042 22.4164 26.0411L21.2082 27.2493C20.2073 28.2502 18.5845 28.2502 17.5836 27.2493L16.3753 26.0411C16.0417 25.7074 16.0417 25.1665 16.3753 24.8329L16.9795 24.2288C17.3131 23.8951 17.3131 23.3542 16.9795 23.0205C16.6458 22.6869 16.1049 22.6869 15.7712 23.0205L15.1671 23.6247C14.8335 23.9583 14.2925 23.9583 13.9589 23.6247L12.7507 22.4164C11.7498 21.4155 11.7498 19.7927 12.7507 18.7918L13.9589 17.5836C12.958 16.5826 12.958 14.9598 13.9589 13.9589C14.9598 12.958 16.5826 12.958 17.5836 13.9589L18.7918 12.7507ZM21.2082 13.9589C20.8746 13.6253 20.3336 13.6253 20 13.9589L18.1877 15.7712C18.0275 15.9315 17.8101 16.0215 17.5836 16.0215C17.357 16.0215 17.1397 15.9315 16.9795 15.7712L16.3753 15.1671C16.0417 14.8335 15.5008 14.8335 15.1671 15.1671C14.8335 15.5008 14.8335 16.0417 15.1671 16.3753L15.7712 16.9795C15.9315 17.1397 16.0215 17.357 16.0215 17.5836C16.0215 17.8101 15.9315 18.0275 15.7712 18.1877L13.9589 20C13.6253 20.3336 13.6253 20.8746 13.9589 21.2082L14.563 21.8123C15.5639 20.8114 17.1868 20.8114 18.1877 21.8123C19.1886 22.8132 19.1886 24.4361 18.1877 25.437L18.7918 26.0411C19.1254 26.3747 19.6664 26.3747 20 26.0411L21.8123 24.2288C22.146 23.8951 22.6869 23.8951 23.0205 24.2288L23.6247 24.8329C23.9583 25.1665 24.4992 25.1665 24.8329 24.8329C25.1665 24.4992 25.1665 23.9583 24.8329 23.6247L24.2288 23.0205C23.8951 22.6869 23.8951 22.146 24.2288 21.8123L26.0411 20C26.3747 19.6664 26.3747 19.1254 26.0411 18.7918L25.437 18.1877C24.4361 19.1886 22.8132 19.1886 21.8123 18.1877C20.8114 17.1868 20.8114 15.5639 21.8123 14.563L21.2082 13.9589Z"
      fill="currentColor"
      className="text-refine-pink"
    />
  </svg>
);
