import React, { type SVGProps } from "react";

export const LandingTileListIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    width={272}
    height={164}
    viewBox="0 0 272 164"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <g filter="url(#filter0_b_736_20174)">
      <rect
        x={128}
        width={144}
        height={32}
        rx={4}
        fill="url(#paint0_linear_736_20174)"
        fillOpacity={0.75}
      />
      <g filter="url(#filter1_d_736_20174)">
        <path
          d="M145.4 13.6C145.4 13.2686 145.669 13 146 13C146.331 13 146.6 13.2686 146.6 13.6V15.4H148.4C148.731 15.4 149 15.6686 149 16C149 16.3314 148.731 16.6 148.4 16.6H146.6V18.4C146.6 18.7314 146.331 19 146 19C145.669 19 145.4 18.7314 145.4 18.4V16.6H143.6C143.269 16.6 143 16.3314 143 16C143 15.6686 143.269 15.4 143.6 15.4H145.4V13.6Z"
          fill="#1FAD66"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M140 16C140 12.6863 142.686 10 146 10C149.314 10 152 12.6863 152 16C152 19.3137 149.314 22 146 22C142.686 22 140 19.3137 140 16ZM146 11.2C143.349 11.2 141.2 13.349 141.2 16C141.2 18.651 143.349 20.8 146 20.8C148.651 20.8 150.8 18.651 150.8 16C150.8 13.349 148.651 11.2 146 11.2Z"
          fill="#1FAD66"
        />
      </g>
      <path
        d="M160.731 20L164.139 11.672H164.955L168.351 20H167.127L164.331 12.956H164.751L161.931 20H160.731ZM162.351 18.116V17.132H166.731V18.116H162.351ZM171.556 20.12C171.028 20.12 170.556 19.992 170.14 19.736C169.724 19.472 169.392 19.116 169.144 18.668C168.904 18.22 168.784 17.716 168.784 17.156C168.784 16.596 168.904 16.092 169.144 15.644C169.392 15.196 169.724 14.84 170.14 14.576C170.556 14.312 171.028 14.18 171.556 14.18C171.98 14.18 172.364 14.272 172.708 14.456C173.052 14.632 173.328 14.88 173.536 15.2C173.752 15.512 173.872 15.876 173.896 16.292V18.008C173.872 18.416 173.756 18.78 173.548 19.1C173.34 19.42 173.064 19.672 172.72 19.856C172.376 20.032 171.988 20.12 171.556 20.12ZM171.736 19.1C172.096 19.1 172.408 19.016 172.672 18.848C172.944 18.68 173.156 18.452 173.308 18.164C173.46 17.868 173.536 17.532 173.536 17.156C173.536 16.764 173.456 16.424 173.296 16.136C173.144 15.848 172.932 15.62 172.66 15.452C172.396 15.284 172.084 15.2 171.724 15.2C171.364 15.2 171.048 15.284 170.776 15.452C170.504 15.62 170.288 15.852 170.128 16.148C169.976 16.436 169.9 16.768 169.9 17.144C169.9 17.528 169.976 17.868 170.128 18.164C170.288 18.452 170.504 18.68 170.776 18.848C171.056 19.016 171.376 19.1 171.736 19.1ZM174.556 20H173.464V18.464L173.668 17.072L173.464 15.692V11.432H174.556V20ZM178.54 20.12C178.012 20.12 177.54 19.992 177.124 19.736C176.708 19.472 176.376 19.116 176.128 18.668C175.888 18.22 175.768 17.716 175.768 17.156C175.768 16.596 175.888 16.092 176.128 15.644C176.376 15.196 176.708 14.84 177.124 14.576C177.54 14.312 178.012 14.18 178.54 14.18C178.964 14.18 179.348 14.272 179.692 14.456C180.036 14.632 180.312 14.88 180.52 15.2C180.736 15.512 180.856 15.876 180.88 16.292V18.008C180.856 18.416 180.74 18.78 180.532 19.1C180.324 19.42 180.048 19.672 179.704 19.856C179.36 20.032 178.972 20.12 178.54 20.12ZM178.72 19.1C179.08 19.1 179.392 19.016 179.656 18.848C179.928 18.68 180.14 18.452 180.292 18.164C180.444 17.868 180.52 17.532 180.52 17.156C180.52 16.764 180.44 16.424 180.28 16.136C180.128 15.848 179.916 15.62 179.644 15.452C179.38 15.284 179.068 15.2 178.708 15.2C178.348 15.2 178.032 15.284 177.76 15.452C177.488 15.62 177.272 15.852 177.112 16.148C176.96 16.436 176.884 16.768 176.884 17.144C176.884 17.528 176.96 17.868 177.112 18.164C177.272 18.452 177.488 18.68 177.76 18.848C178.04 19.016 178.36 19.1 178.72 19.1ZM181.54 20H180.448V18.464L180.652 17.072L180.448 15.692V11.432H181.54V20ZM185.8 20V11.672H186.592L186.928 12.98V20H185.8ZM191.56 20L186.448 13.172L186.592 11.672L191.716 18.488L191.56 20ZM191.56 20L191.224 18.764V11.672H192.352V20H191.56ZM196.768 20.12C196.2 20.12 195.688 19.992 195.232 19.736C194.776 19.472 194.416 19.116 194.152 18.668C193.888 18.22 193.756 17.712 193.756 17.144C193.756 16.584 193.884 16.08 194.14 15.632C194.404 15.184 194.756 14.832 195.196 14.576C195.644 14.312 196.144 14.18 196.696 14.18C197.224 14.18 197.688 14.3 198.088 14.54C198.496 14.78 198.812 15.112 199.036 15.536C199.268 15.96 199.384 16.44 199.384 16.976C199.384 17.056 199.38 17.144 199.372 17.24C199.364 17.328 199.348 17.432 199.324 17.552H194.512V16.652H198.748L198.352 17C198.352 16.616 198.284 16.292 198.148 16.028C198.012 15.756 197.82 15.548 197.572 15.404C197.324 15.252 197.024 15.176 196.672 15.176C196.304 15.176 195.98 15.256 195.7 15.416C195.42 15.576 195.204 15.8 195.052 16.088C194.9 16.376 194.824 16.716 194.824 17.108C194.824 17.508 194.904 17.86 195.064 18.164C195.224 18.46 195.452 18.692 195.748 18.86C196.044 19.02 196.384 19.1 196.768 19.1C197.088 19.1 197.38 19.044 197.644 18.932C197.916 18.82 198.148 18.652 198.34 18.428L199.036 19.136C198.764 19.456 198.428 19.7 198.028 19.868C197.636 20.036 197.216 20.12 196.768 20.12ZM202.123 20L199.867 14.3H200.995L202.627 18.74H202.267L203.887 14.3H204.511L206.131 18.74H205.771L207.403 14.3H208.531L206.287 20H205.651L204.007 15.692H204.403L202.747 20H202.123ZM212.935 16.376V15.428H215.191C215.679 15.428 216.055 15.304 216.319 15.056C216.583 14.808 216.715 14.472 216.715 14.048C216.715 13.648 216.583 13.316 216.319 13.052C216.063 12.788 215.691 12.656 215.203 12.656H212.935V11.672H215.239C215.767 11.672 216.227 11.776 216.619 11.984C217.011 12.184 217.311 12.46 217.519 12.812C217.735 13.164 217.843 13.568 217.843 14.024C217.843 14.496 217.735 14.908 217.519 15.26C217.311 15.612 217.011 15.888 216.619 16.088C216.227 16.28 215.767 16.376 215.239 16.376H212.935ZM212.179 20V11.672H213.307V20H212.179ZM216.979 20L213.955 16.268L215.023 15.896L218.407 20H216.979ZM221.834 20.12C221.266 20.12 220.754 19.992 220.298 19.736C219.842 19.472 219.482 19.116 219.218 18.668C218.954 18.22 218.822 17.712 218.822 17.144C218.822 16.584 218.95 16.08 219.206 15.632C219.47 15.184 219.822 14.832 220.262 14.576C220.71 14.312 221.21 14.18 221.762 14.18C222.29 14.18 222.754 14.3 223.154 14.54C223.562 14.78 223.878 15.112 224.102 15.536C224.334 15.96 224.45 16.44 224.45 16.976C224.45 17.056 224.446 17.144 224.438 17.24C224.43 17.328 224.414 17.432 224.39 17.552H219.578V16.652H223.814L223.418 17C223.418 16.616 223.35 16.292 223.214 16.028C223.078 15.756 222.886 15.548 222.638 15.404C222.39 15.252 222.09 15.176 221.738 15.176C221.37 15.176 221.046 15.256 220.766 15.416C220.486 15.576 220.27 15.8 220.118 16.088C219.966 16.376 219.89 16.716 219.89 17.108C219.89 17.508 219.97 17.86 220.13 18.164C220.29 18.46 220.518 18.692 220.814 18.86C221.11 19.02 221.45 19.1 221.834 19.1C222.154 19.1 222.446 19.044 222.71 18.932C222.982 18.82 223.214 18.652 223.406 18.428L224.102 19.136C223.83 19.456 223.494 19.7 223.094 19.868C222.702 20.036 222.282 20.12 221.834 20.12ZM228.232 20.12C227.672 20.12 227.164 19.988 226.708 19.724C226.26 19.46 225.904 19.104 225.64 18.656C225.384 18.2 225.256 17.696 225.256 17.144C225.256 16.584 225.384 16.08 225.64 15.632C225.904 15.184 226.26 14.832 226.708 14.576C227.164 14.312 227.672 14.18 228.232 14.18C228.672 14.18 229.08 14.264 229.456 14.432C229.832 14.592 230.156 14.828 230.428 15.14L229.708 15.86C229.532 15.652 229.316 15.496 229.06 15.392C228.812 15.28 228.536 15.224 228.232 15.224C227.872 15.224 227.552 15.308 227.272 15.476C226.992 15.636 226.772 15.86 226.612 16.148C226.452 16.436 226.372 16.768 226.372 17.144C226.372 17.52 226.452 17.852 226.612 18.14C226.772 18.428 226.992 18.656 227.272 18.824C227.552 18.992 227.872 19.076 228.232 19.076C228.536 19.076 228.812 19.024 229.06 18.92C229.316 18.808 229.536 18.648 229.72 18.44L230.428 19.16C230.164 19.464 229.84 19.7 229.456 19.868C229.08 20.036 228.672 20.12 228.232 20.12ZM233.986 20.12C233.426 20.12 232.922 19.988 232.474 19.724C232.026 19.46 231.67 19.104 231.406 18.656C231.142 18.2 231.01 17.692 231.01 17.132C231.01 16.58 231.142 16.084 231.406 15.644C231.67 15.196 232.026 14.84 232.474 14.576C232.922 14.312 233.426 14.18 233.986 14.18C234.538 14.18 235.038 14.312 235.486 14.576C235.942 14.832 236.302 15.184 236.566 15.632C236.83 16.08 236.962 16.58 236.962 17.132C236.962 17.692 236.83 18.2 236.566 18.656C236.302 19.104 235.942 19.46 235.486 19.724C235.038 19.988 234.538 20.12 233.986 20.12ZM233.986 19.076C234.346 19.076 234.666 18.992 234.946 18.824C235.226 18.656 235.446 18.428 235.606 18.14C235.766 17.844 235.846 17.508 235.846 17.132C235.846 16.764 235.762 16.436 235.594 16.148C235.434 15.86 235.214 15.636 234.934 15.476C234.662 15.308 234.346 15.224 233.986 15.224C233.626 15.224 233.306 15.308 233.026 15.476C232.746 15.636 232.526 15.86 232.366 16.148C232.206 16.436 232.126 16.764 232.126 17.132C232.126 17.508 232.206 17.844 232.366 18.14C232.526 18.428 232.746 18.656 233.026 18.824C233.306 18.992 233.626 19.076 233.986 19.076ZM238.179 20V14.3H239.259V20H238.179ZM239.259 16.748L238.851 16.568C238.851 15.84 239.019 15.26 239.355 14.828C239.691 14.396 240.175 14.18 240.807 14.18C241.095 14.18 241.355 14.232 241.587 14.336C241.819 14.432 242.035 14.596 242.235 14.828L241.527 15.56C241.407 15.432 241.275 15.34 241.131 15.284C240.987 15.228 240.819 15.2 240.627 15.2C240.227 15.2 239.899 15.328 239.643 15.584C239.387 15.84 239.259 16.228 239.259 16.748ZM245.22 20.12C244.692 20.12 244.22 19.992 243.804 19.736C243.388 19.472 243.056 19.116 242.808 18.668C242.568 18.22 242.448 17.716 242.448 17.156C242.448 16.596 242.568 16.092 242.808 15.644C243.056 15.196 243.388 14.84 243.804 14.576C244.22 14.312 244.692 14.18 245.22 14.18C245.644 14.18 246.028 14.272 246.372 14.456C246.716 14.632 246.992 14.88 247.2 15.2C247.416 15.512 247.536 15.876 247.56 16.292V18.008C247.536 18.416 247.42 18.78 247.212 19.1C247.004 19.42 246.728 19.672 246.384 19.856C246.04 20.032 245.652 20.12 245.22 20.12ZM245.4 19.1C245.76 19.1 246.072 19.016 246.336 18.848C246.608 18.68 246.82 18.452 246.972 18.164C247.124 17.868 247.2 17.532 247.2 17.156C247.2 16.764 247.12 16.424 246.96 16.136C246.808 15.848 246.596 15.62 246.324 15.452C246.06 15.284 245.748 15.2 245.388 15.2C245.028 15.2 244.712 15.284 244.44 15.452C244.168 15.62 243.952 15.852 243.792 16.148C243.64 16.436 243.564 16.768 243.564 17.144C243.564 17.528 243.64 17.868 243.792 18.164C243.952 18.452 244.168 18.68 244.44 18.848C244.72 19.016 245.04 19.1 245.4 19.1ZM248.22 20H247.128V18.464L247.332 17.072L247.128 15.692V11.432H248.22V20Z"
        fill="#ACACD2"
      />
    </g>
    <path
      d="M0 44H272V84H0V44Z"
      fill="url(#paint1_linear_736_20174)"
      fillOpacity={0.75}
    />
    <path
      d="M1.74 64.376V63.428H3.996C4.484 63.428 4.86 63.304 5.124 63.056C5.388 62.808 5.52 62.472 5.52 62.048C5.52 61.648 5.388 61.316 5.124 61.052C4.868 60.788 4.496 60.656 4.008 60.656H1.74V59.672H4.044C4.572 59.672 5.032 59.776 5.424 59.984C5.816 60.184 6.116 60.46 6.324 60.812C6.54 61.164 6.648 61.568 6.648 62.024C6.648 62.496 6.54 62.908 6.324 63.26C6.116 63.612 5.816 63.888 5.424 64.088C5.032 64.28 4.572 64.376 4.044 64.376H1.74ZM0.984 68V59.672H2.112V68H0.984ZM5.784 68L2.76 64.268L3.828 63.896L7.212 68H5.784ZM10.639 68.12C10.071 68.12 9.55903 67.992 9.10303 67.736C8.64703 67.472 8.28703 67.116 8.02303 66.668C7.75903 66.22 7.62703 65.712 7.62703 65.144C7.62703 64.584 7.75503 64.08 8.01103 63.632C8.27503 63.184 8.62703 62.832 9.06703 62.576C9.51503 62.312 10.015 62.18 10.567 62.18C11.095 62.18 11.559 62.3 11.959 62.54C12.367 62.78 12.683 63.112 12.907 63.536C13.139 63.96 13.255 64.44 13.255 64.976C13.255 65.056 13.251 65.144 13.243 65.24C13.235 65.328 13.219 65.432 13.195 65.552H8.38303V64.652H12.619L12.223 65C12.223 64.616 12.155 64.292 12.019 64.028C11.883 63.756 11.691 63.548 11.443 63.404C11.195 63.252 10.895 63.176 10.543 63.176C10.175 63.176 9.85103 63.256 9.57103 63.416C9.29103 63.576 9.07503 63.8 8.92303 64.088C8.77103 64.376 8.69503 64.716 8.69503 65.108C8.69503 65.508 8.77503 65.86 8.93503 66.164C9.09503 66.46 9.32303 66.692 9.61903 66.86C9.91503 67.02 10.255 67.1 10.639 67.1C10.959 67.1 11.251 67.044 11.515 66.932C11.787 66.82 12.019 66.652 12.211 66.428L12.907 67.136C12.635 67.456 12.299 67.7 11.899 67.868C11.507 68.036 11.087 68.12 10.639 68.12ZM17.0366 68.12C16.4766 68.12 15.9686 67.988 15.5126 67.724C15.0646 67.46 14.7086 67.104 14.4446 66.656C14.1886 66.2 14.0606 65.696 14.0606 65.144C14.0606 64.584 14.1886 64.08 14.4446 63.632C14.7086 63.184 15.0646 62.832 15.5126 62.576C15.9686 62.312 16.4766 62.18 17.0366 62.18C17.4766 62.18 17.8846 62.264 18.2606 62.432C18.6366 62.592 18.9606 62.828 19.2326 63.14L18.5126 63.86C18.3366 63.652 18.1206 63.496 17.8646 63.392C17.6166 63.28 17.3406 63.224 17.0366 63.224C16.6766 63.224 16.3566 63.308 16.0766 63.476C15.7966 63.636 15.5766 63.86 15.4166 64.148C15.2566 64.436 15.1766 64.768 15.1766 65.144C15.1766 65.52 15.2566 65.852 15.4166 66.14C15.5766 66.428 15.7966 66.656 16.0766 66.824C16.3566 66.992 16.6766 67.076 17.0366 67.076C17.3406 67.076 17.6166 67.024 17.8646 66.92C18.1206 66.808 18.3406 66.648 18.5246 66.44L19.2326 67.16C18.9686 67.464 18.6446 67.7 18.2606 67.868C17.8846 68.036 17.4766 68.12 17.0366 68.12ZM22.7905 68.12C22.2305 68.12 21.7265 67.988 21.2785 67.724C20.8305 67.46 20.4745 67.104 20.2105 66.656C19.9465 66.2 19.8145 65.692 19.8145 65.132C19.8145 64.58 19.9465 64.084 20.2105 63.644C20.4745 63.196 20.8305 62.84 21.2785 62.576C21.7265 62.312 22.2305 62.18 22.7905 62.18C23.3425 62.18 23.8425 62.312 24.2905 62.576C24.7465 62.832 25.1065 63.184 25.3705 63.632C25.6345 64.08 25.7665 64.58 25.7665 65.132C25.7665 65.692 25.6345 66.2 25.3705 66.656C25.1065 67.104 24.7465 67.46 24.2905 67.724C23.8425 67.988 23.3425 68.12 22.7905 68.12ZM22.7905 67.076C23.1505 67.076 23.4705 66.992 23.7505 66.824C24.0305 66.656 24.2505 66.428 24.4105 66.14C24.5705 65.844 24.6505 65.508 24.6505 65.132C24.6505 64.764 24.5665 64.436 24.3985 64.148C24.2385 63.86 24.0185 63.636 23.7385 63.476C23.4665 63.308 23.1505 63.224 22.7905 63.224C22.4305 63.224 22.1105 63.308 21.8305 63.476C21.5505 63.636 21.3305 63.86 21.1705 64.148C21.0105 64.436 20.9305 64.764 20.9305 65.132C20.9305 65.508 21.0105 65.844 21.1705 66.14C21.3305 66.428 21.5505 66.656 21.8305 66.824C22.1105 66.992 22.4305 67.076 22.7905 67.076ZM26.9834 68V62.3H28.0634V68H26.9834ZM28.0634 64.748L27.6554 64.568C27.6554 63.84 27.8234 63.26 28.1594 62.828C28.4954 62.396 28.9794 62.18 29.6114 62.18C29.8994 62.18 30.1594 62.232 30.3914 62.336C30.6234 62.432 30.8394 62.596 31.0394 62.828L30.3314 63.56C30.2114 63.432 30.0794 63.34 29.9354 63.284C29.7914 63.228 29.6234 63.2 29.4314 63.2C29.0314 63.2 28.7034 63.328 28.4474 63.584C28.1914 63.84 28.0634 64.228 28.0634 64.748ZM34.0243 68.12C33.4963 68.12 33.0243 67.992 32.6083 67.736C32.1923 67.472 31.8603 67.116 31.6123 66.668C31.3723 66.22 31.2523 65.716 31.2523 65.156C31.2523 64.596 31.3723 64.092 31.6123 63.644C31.8603 63.196 32.1923 62.84 32.6083 62.576C33.0243 62.312 33.4963 62.18 34.0243 62.18C34.4483 62.18 34.8323 62.272 35.1763 62.456C35.5203 62.632 35.7963 62.88 36.0043 63.2C36.2203 63.512 36.3403 63.876 36.3643 64.292V66.008C36.3403 66.416 36.2243 66.78 36.0163 67.1C35.8083 67.42 35.5323 67.672 35.1883 67.856C34.8443 68.032 34.4563 68.12 34.0243 68.12ZM34.2043 67.1C34.5643 67.1 34.8763 67.016 35.1403 66.848C35.4123 66.68 35.6243 66.452 35.7763 66.164C35.9283 65.868 36.0043 65.532 36.0043 65.156C36.0043 64.764 35.9243 64.424 35.7643 64.136C35.6123 63.848 35.4003 63.62 35.1283 63.452C34.8643 63.284 34.5523 63.2 34.1923 63.2C33.8323 63.2 33.5163 63.284 33.2443 63.452C32.9723 63.62 32.7563 63.852 32.5963 64.148C32.4443 64.436 32.3683 64.768 32.3683 65.144C32.3683 65.528 32.4443 65.868 32.5963 66.164C32.7563 66.452 32.9723 66.68 33.2443 66.848C33.5243 67.016 33.8443 67.1 34.2043 67.1ZM37.0243 68H35.9323V66.464L36.1363 65.072L35.9323 63.692V59.432H37.0243V68ZM44.2848 68L45.5568 59.672H46.4808L45.2088 68H44.2848ZM40.8768 65.432V64.556H47.0208V65.432H40.8768ZM41.7168 68L42.9888 59.672H43.9128L42.6408 68H41.7168ZM41.2488 62.948V62.072H47.3928V62.948H41.2488ZM50.0526 68V59.672H51.1686V68H50.0526ZM48.3486 60.68V59.672H51.0486V60.68H48.3486Z"
      fill="#ACACD2"
    />
    <g filter="url(#filter2_b_736_20174)">
      <rect
        x={248}
        y={52}
        width={24}
        height={24}
        rx={12}
        fill="url(#paint2_linear_736_20174)"
        fillOpacity={0.33}
      />
      <path
        d="M264.5 65.5C263.672 65.5 263 64.8284 263 64C263 63.1716 263.672 62.5 264.5 62.5C265.328 62.5 266 63.1716 266 64C266 64.8284 265.328 65.5 264.5 65.5Z"
        fill="#ACACD2"
      />
      <path
        d="M260 65.5C259.172 65.5 258.5 64.8284 258.5 64C258.5 63.1716 259.172 62.5 260 62.5C260.828 62.5 261.5 63.1716 261.5 64C261.5 64.8284 260.828 65.5 260 65.5Z"
        fill="#ACACD2"
      />
      <path
        d="M254 64C254 64.8284 254.672 65.5 255.5 65.5C256.328 65.5 257 64.8284 257 64C257 63.1716 256.328 62.5 255.5 62.5C254.672 62.5 254 63.1716 254 64Z"
        fill="#ACACD2"
      />
      <rect
        x={248.5}
        y={52.5}
        width={23}
        height={23}
        rx={11.5}
        stroke="#4D4DB3"
      />
    </g>
    <path d="M0 44.5H272V43.5H0V44.5Z" fill="#4D4DB3" fillOpacity={0.25} />
    <g opacity={0.5}>
      <path
        d="M1.74 104.376V103.428H3.996C4.484 103.428 4.86 103.304 5.124 103.056C5.388 102.808 5.52 102.472 5.52 102.048C5.52 101.648 5.388 101.316 5.124 101.052C4.868 100.788 4.496 100.656 4.008 100.656H1.74V99.672H4.044C4.572 99.672 5.032 99.776 5.424 99.984C5.816 100.184 6.116 100.46 6.324 100.812C6.54 101.164 6.648 101.568 6.648 102.024C6.648 102.496 6.54 102.908 6.324 103.26C6.116 103.612 5.816 103.888 5.424 104.088C5.032 104.28 4.572 104.376 4.044 104.376H1.74ZM0.984 108V99.672H2.112V108H0.984ZM5.784 108L2.76 104.268L3.828 103.896L7.212 108H5.784ZM10.639 108.12C10.071 108.12 9.55903 107.992 9.10303 107.736C8.64703 107.472 8.28703 107.116 8.02303 106.668C7.75903 106.22 7.62703 105.712 7.62703 105.144C7.62703 104.584 7.75503 104.08 8.01103 103.632C8.27503 103.184 8.62703 102.832 9.06703 102.576C9.51503 102.312 10.015 102.18 10.567 102.18C11.095 102.18 11.559 102.3 11.959 102.54C12.367 102.78 12.683 103.112 12.907 103.536C13.139 103.96 13.255 104.44 13.255 104.976C13.255 105.056 13.251 105.144 13.243 105.24C13.235 105.328 13.219 105.432 13.195 105.552H8.38303V104.652H12.619L12.223 105C12.223 104.616 12.155 104.292 12.019 104.028C11.883 103.756 11.691 103.548 11.443 103.404C11.195 103.252 10.895 103.176 10.543 103.176C10.175 103.176 9.85103 103.256 9.57103 103.416C9.29103 103.576 9.07503 103.8 8.92303 104.088C8.77103 104.376 8.69503 104.716 8.69503 105.108C8.69503 105.508 8.77503 105.86 8.93503 106.164C9.09503 106.46 9.32303 106.692 9.61903 106.86C9.91503 107.02 10.255 107.1 10.639 107.1C10.959 107.1 11.251 107.044 11.515 106.932C11.787 106.82 12.019 106.652 12.211 106.428L12.907 107.136C12.635 107.456 12.299 107.7 11.899 107.868C11.507 108.036 11.087 108.12 10.639 108.12ZM17.0366 108.12C16.4766 108.12 15.9686 107.988 15.5126 107.724C15.0646 107.46 14.7086 107.104 14.4446 106.656C14.1886 106.2 14.0606 105.696 14.0606 105.144C14.0606 104.584 14.1886 104.08 14.4446 103.632C14.7086 103.184 15.0646 102.832 15.5126 102.576C15.9686 102.312 16.4766 102.18 17.0366 102.18C17.4766 102.18 17.8846 102.264 18.2606 102.432C18.6366 102.592 18.9606 102.828 19.2326 103.14L18.5126 103.86C18.3366 103.652 18.1206 103.496 17.8646 103.392C17.6166 103.28 17.3406 103.224 17.0366 103.224C16.6766 103.224 16.3566 103.308 16.0766 103.476C15.7966 103.636 15.5766 103.86 15.4166 104.148C15.2566 104.436 15.1766 104.768 15.1766 105.144C15.1766 105.52 15.2566 105.852 15.4166 106.14C15.5766 106.428 15.7966 106.656 16.0766 106.824C16.3566 106.992 16.6766 107.076 17.0366 107.076C17.3406 107.076 17.6166 107.024 17.8646 106.92C18.1206 106.808 18.3406 106.648 18.5246 106.44L19.2326 107.16C18.9686 107.464 18.6446 107.7 18.2606 107.868C17.8846 108.036 17.4766 108.12 17.0366 108.12ZM22.7905 108.12C22.2305 108.12 21.7265 107.988 21.2785 107.724C20.8305 107.46 20.4745 107.104 20.2105 106.656C19.9465 106.2 19.8145 105.692 19.8145 105.132C19.8145 104.58 19.9465 104.084 20.2105 103.644C20.4745 103.196 20.8305 102.84 21.2785 102.576C21.7265 102.312 22.2305 102.18 22.7905 102.18C23.3425 102.18 23.8425 102.312 24.2905 102.576C24.7465 102.832 25.1065 103.184 25.3705 103.632C25.6345 104.08 25.7665 104.58 25.7665 105.132C25.7665 105.692 25.6345 106.2 25.3705 106.656C25.1065 107.104 24.7465 107.46 24.2905 107.724C23.8425 107.988 23.3425 108.12 22.7905 108.12ZM22.7905 107.076C23.1505 107.076 23.4705 106.992 23.7505 106.824C24.0305 106.656 24.2505 106.428 24.4105 106.14C24.5705 105.844 24.6505 105.508 24.6505 105.132C24.6505 104.764 24.5665 104.436 24.3985 104.148C24.2385 103.86 24.0185 103.636 23.7385 103.476C23.4665 103.308 23.1505 103.224 22.7905 103.224C22.4305 103.224 22.1105 103.308 21.8305 103.476C21.5505 103.636 21.3305 103.86 21.1705 104.148C21.0105 104.436 20.9305 104.764 20.9305 105.132C20.9305 105.508 21.0105 105.844 21.1705 106.14C21.3305 106.428 21.5505 106.656 21.8305 106.824C22.1105 106.992 22.4305 107.076 22.7905 107.076ZM26.9834 108V102.3H28.0634V108H26.9834ZM28.0634 104.748L27.6554 104.568C27.6554 103.84 27.8234 103.26 28.1594 102.828C28.4954 102.396 28.9794 102.18 29.6114 102.18C29.8994 102.18 30.1594 102.232 30.3914 102.336C30.6234 102.432 30.8394 102.596 31.0394 102.828L30.3314 103.56C30.2114 103.432 30.0794 103.34 29.9354 103.284C29.7914 103.228 29.6234 103.2 29.4314 103.2C29.0314 103.2 28.7034 103.328 28.4474 103.584C28.1914 103.84 28.0634 104.228 28.0634 104.748ZM34.0243 108.12C33.4963 108.12 33.0243 107.992 32.6083 107.736C32.1923 107.472 31.8603 107.116 31.6123 106.668C31.3723 106.22 31.2523 105.716 31.2523 105.156C31.2523 104.596 31.3723 104.092 31.6123 103.644C31.8603 103.196 32.1923 102.84 32.6083 102.576C33.0243 102.312 33.4963 102.18 34.0243 102.18C34.4483 102.18 34.8323 102.272 35.1763 102.456C35.5203 102.632 35.7963 102.88 36.0043 103.2C36.2203 103.512 36.3403 103.876 36.3643 104.292V106.008C36.3403 106.416 36.2243 106.78 36.0163 107.1C35.8083 107.42 35.5323 107.672 35.1883 107.856C34.8443 108.032 34.4563 108.12 34.0243 108.12ZM34.2043 107.1C34.5643 107.1 34.8763 107.016 35.1403 106.848C35.4123 106.68 35.6243 106.452 35.7763 106.164C35.9283 105.868 36.0043 105.532 36.0043 105.156C36.0043 104.764 35.9243 104.424 35.7643 104.136C35.6123 103.848 35.4003 103.62 35.1283 103.452C34.8643 103.284 34.5523 103.2 34.1923 103.2C33.8323 103.2 33.5163 103.284 33.2443 103.452C32.9723 103.62 32.7563 103.852 32.5963 104.148C32.4443 104.436 32.3683 104.768 32.3683 105.144C32.3683 105.528 32.4443 105.868 32.5963 106.164C32.7563 106.452 32.9723 106.68 33.2443 106.848C33.5243 107.016 33.8443 107.1 34.2043 107.1ZM37.0243 108H35.9323V106.464L36.1363 105.072L35.9323 103.692V99.432H37.0243V108ZM44.2848 108L45.5568 99.672H46.4808L45.2088 108H44.2848ZM40.8768 105.432V104.556H47.0208V105.432H40.8768ZM41.7168 108L42.9888 99.672H43.9128L42.6408 108H41.7168ZM41.2488 102.948V102.072H47.3928V102.948H41.2488ZM48.3726 107.316L51.4446 104.076C51.7566 103.756 52.0006 103.48 52.1766 103.248C52.3526 103.008 52.4766 102.788 52.5486 102.588C52.6286 102.388 52.6686 102.18 52.6686 101.964C52.6686 101.54 52.5326 101.208 52.2606 100.968C51.9886 100.728 51.6366 100.608 51.2046 100.608C50.7806 100.608 50.4086 100.712 50.0886 100.92C49.7686 101.12 49.4846 101.432 49.2366 101.856L48.4446 101.196C48.7726 100.652 49.1686 100.244 49.6326 99.972C50.0966 99.692 50.6326 99.552 51.2406 99.552C51.7526 99.552 52.1966 99.652 52.5726 99.852C52.9566 100.052 53.2526 100.332 53.4606 100.692C53.6686 101.052 53.7726 101.472 53.7726 101.952C53.7726 102.296 53.7286 102.604 53.6406 102.876C53.5606 103.148 53.4126 103.428 53.1966 103.716C52.9886 103.996 52.6966 104.332 52.3206 104.724L49.8366 107.28L48.3726 107.316ZM48.3726 108V107.316L49.3326 106.992H53.9646V108H48.3726Z"
        fill="#ACACD2"
      />
      <g filter="url(#filter3_b_736_20174)">
        <rect
          x={248}
          y={92}
          width={24}
          height={24}
          rx={12}
          fill="url(#paint3_linear_736_20174)"
          fillOpacity={0.33}
        />
        <path
          d="M264.5 105.5C263.672 105.5 263 104.828 263 104C263 103.172 263.672 102.5 264.5 102.5C265.328 102.5 266 103.172 266 104C266 104.828 265.328 105.5 264.5 105.5Z"
          fill="#ACACD2"
        />
        <path
          d="M260 105.5C259.172 105.5 258.5 104.828 258.5 104C258.5 103.172 259.172 102.5 260 102.5C260.828 102.5 261.5 103.172 261.5 104C261.5 104.828 260.828 105.5 260 105.5Z"
          fill="#ACACD2"
        />
        <path
          d="M254 104C254 104.828 254.672 105.5 255.5 105.5C256.328 105.5 257 104.828 257 104C257 103.172 256.328 102.5 255.5 102.5C254.672 102.5 254 103.172 254 104Z"
          fill="#ACACD2"
        />
        <rect
          x={248.5}
          y={92.5}
          width={23}
          height={23}
          rx={11.5}
          stroke="#4D4DB2"
        />
      </g>
      <path d="M0 84.5H272V83.5H0V84.5Z" fill="#4D4DB2" fillOpacity={0.25} />
    </g>
    <g opacity={0.25}>
      <path
        d="M1.74 144.376V143.428H3.996C4.484 143.428 4.86 143.304 5.124 143.056C5.388 142.808 5.52 142.472 5.52 142.048C5.52 141.648 5.388 141.316 5.124 141.052C4.868 140.788 4.496 140.656 4.008 140.656H1.74V139.672H4.044C4.572 139.672 5.032 139.776 5.424 139.984C5.816 140.184 6.116 140.46 6.324 140.812C6.54 141.164 6.648 141.568 6.648 142.024C6.648 142.496 6.54 142.908 6.324 143.26C6.116 143.612 5.816 143.888 5.424 144.088C5.032 144.28 4.572 144.376 4.044 144.376H1.74ZM0.984 148V139.672H2.112V148H0.984ZM5.784 148L2.76 144.268L3.828 143.896L7.212 148H5.784ZM10.639 148.12C10.071 148.12 9.55903 147.992 9.10303 147.736C8.64703 147.472 8.28703 147.116 8.02303 146.668C7.75903 146.22 7.62703 145.712 7.62703 145.144C7.62703 144.584 7.75503 144.08 8.01103 143.632C8.27503 143.184 8.62703 142.832 9.06703 142.576C9.51503 142.312 10.015 142.18 10.567 142.18C11.095 142.18 11.559 142.3 11.959 142.54C12.367 142.78 12.683 143.112 12.907 143.536C13.139 143.96 13.255 144.44 13.255 144.976C13.255 145.056 13.251 145.144 13.243 145.24C13.235 145.328 13.219 145.432 13.195 145.552H8.38303V144.652H12.619L12.223 145C12.223 144.616 12.155 144.292 12.019 144.028C11.883 143.756 11.691 143.548 11.443 143.404C11.195 143.252 10.895 143.176 10.543 143.176C10.175 143.176 9.85103 143.256 9.57103 143.416C9.29103 143.576 9.07503 143.8 8.92303 144.088C8.77103 144.376 8.69503 144.716 8.69503 145.108C8.69503 145.508 8.77503 145.86 8.93503 146.164C9.09503 146.46 9.32303 146.692 9.61903 146.86C9.91503 147.02 10.255 147.1 10.639 147.1C10.959 147.1 11.251 147.044 11.515 146.932C11.787 146.82 12.019 146.652 12.211 146.428L12.907 147.136C12.635 147.456 12.299 147.7 11.899 147.868C11.507 148.036 11.087 148.12 10.639 148.12ZM17.0366 148.12C16.4766 148.12 15.9686 147.988 15.5126 147.724C15.0646 147.46 14.7086 147.104 14.4446 146.656C14.1886 146.2 14.0606 145.696 14.0606 145.144C14.0606 144.584 14.1886 144.08 14.4446 143.632C14.7086 143.184 15.0646 142.832 15.5126 142.576C15.9686 142.312 16.4766 142.18 17.0366 142.18C17.4766 142.18 17.8846 142.264 18.2606 142.432C18.6366 142.592 18.9606 142.828 19.2326 143.14L18.5126 143.86C18.3366 143.652 18.1206 143.496 17.8646 143.392C17.6166 143.28 17.3406 143.224 17.0366 143.224C16.6766 143.224 16.3566 143.308 16.0766 143.476C15.7966 143.636 15.5766 143.86 15.4166 144.148C15.2566 144.436 15.1766 144.768 15.1766 145.144C15.1766 145.52 15.2566 145.852 15.4166 146.14C15.5766 146.428 15.7966 146.656 16.0766 146.824C16.3566 146.992 16.6766 147.076 17.0366 147.076C17.3406 147.076 17.6166 147.024 17.8646 146.92C18.1206 146.808 18.3406 146.648 18.5246 146.44L19.2326 147.16C18.9686 147.464 18.6446 147.7 18.2606 147.868C17.8846 148.036 17.4766 148.12 17.0366 148.12ZM22.7905 148.12C22.2305 148.12 21.7265 147.988 21.2785 147.724C20.8305 147.46 20.4745 147.104 20.2105 146.656C19.9465 146.2 19.8145 145.692 19.8145 145.132C19.8145 144.58 19.9465 144.084 20.2105 143.644C20.4745 143.196 20.8305 142.84 21.2785 142.576C21.7265 142.312 22.2305 142.18 22.7905 142.18C23.3425 142.18 23.8425 142.312 24.2905 142.576C24.7465 142.832 25.1065 143.184 25.3705 143.632C25.6345 144.08 25.7665 144.58 25.7665 145.132C25.7665 145.692 25.6345 146.2 25.3705 146.656C25.1065 147.104 24.7465 147.46 24.2905 147.724C23.8425 147.988 23.3425 148.12 22.7905 148.12ZM22.7905 147.076C23.1505 147.076 23.4705 146.992 23.7505 146.824C24.0305 146.656 24.2505 146.428 24.4105 146.14C24.5705 145.844 24.6505 145.508 24.6505 145.132C24.6505 144.764 24.5665 144.436 24.3985 144.148C24.2385 143.86 24.0185 143.636 23.7385 143.476C23.4665 143.308 23.1505 143.224 22.7905 143.224C22.4305 143.224 22.1105 143.308 21.8305 143.476C21.5505 143.636 21.3305 143.86 21.1705 144.148C21.0105 144.436 20.9305 144.764 20.9305 145.132C20.9305 145.508 21.0105 145.844 21.1705 146.14C21.3305 146.428 21.5505 146.656 21.8305 146.824C22.1105 146.992 22.4305 147.076 22.7905 147.076ZM26.9834 148V142.3H28.0634V148H26.9834ZM28.0634 144.748L27.6554 144.568C27.6554 143.84 27.8234 143.26 28.1594 142.828C28.4954 142.396 28.9794 142.18 29.6114 142.18C29.8994 142.18 30.1594 142.232 30.3914 142.336C30.6234 142.432 30.8394 142.596 31.0394 142.828L30.3314 143.56C30.2114 143.432 30.0794 143.34 29.9354 143.284C29.7914 143.228 29.6234 143.2 29.4314 143.2C29.0314 143.2 28.7034 143.328 28.4474 143.584C28.1914 143.84 28.0634 144.228 28.0634 144.748ZM34.0243 148.12C33.4963 148.12 33.0243 147.992 32.6083 147.736C32.1923 147.472 31.8603 147.116 31.6123 146.668C31.3723 146.22 31.2523 145.716 31.2523 145.156C31.2523 144.596 31.3723 144.092 31.6123 143.644C31.8603 143.196 32.1923 142.84 32.6083 142.576C33.0243 142.312 33.4963 142.18 34.0243 142.18C34.4483 142.18 34.8323 142.272 35.1763 142.456C35.5203 142.632 35.7963 142.88 36.0043 143.2C36.2203 143.512 36.3403 143.876 36.3643 144.292V146.008C36.3403 146.416 36.2243 146.78 36.0163 147.1C35.8083 147.42 35.5323 147.672 35.1883 147.856C34.8443 148.032 34.4563 148.12 34.0243 148.12ZM34.2043 147.1C34.5643 147.1 34.8763 147.016 35.1403 146.848C35.4123 146.68 35.6243 146.452 35.7763 146.164C35.9283 145.868 36.0043 145.532 36.0043 145.156C36.0043 144.764 35.9243 144.424 35.7643 144.136C35.6123 143.848 35.4003 143.62 35.1283 143.452C34.8643 143.284 34.5523 143.2 34.1923 143.2C33.8323 143.2 33.5163 143.284 33.2443 143.452C32.9723 143.62 32.7563 143.852 32.5963 144.148C32.4443 144.436 32.3683 144.768 32.3683 145.144C32.3683 145.528 32.4443 145.868 32.5963 146.164C32.7563 146.452 32.9723 146.68 33.2443 146.848C33.5243 147.016 33.8443 147.1 34.2043 147.1ZM37.0243 148H35.9323V146.464L36.1363 145.072L35.9323 143.692V139.432H37.0243V148ZM44.2848 148L45.5568 139.672H46.4808L45.2088 148H44.2848ZM40.8768 145.432V144.556H47.0208V145.432H40.8768ZM41.7168 148L42.9888 139.672H43.9128L42.6408 148H41.7168ZM41.2488 142.948V142.072H47.3928V142.948H41.2488ZM50.9406 148.12C50.3966 148.12 49.9006 148.02 49.4526 147.82C49.0126 147.612 48.6406 147.312 48.3366 146.92L49.1046 146.152C49.2886 146.432 49.5406 146.656 49.8606 146.824C50.1806 146.984 50.5366 147.064 50.9286 147.064C51.2966 147.064 51.6126 146.996 51.8766 146.86C52.1486 146.716 52.3606 146.516 52.5126 146.26C52.6726 146.004 52.7526 145.708 52.7526 145.372C52.7526 145.028 52.6726 144.732 52.5126 144.484C52.3606 144.228 52.1446 144.032 51.8646 143.896C51.5846 143.76 51.2526 143.692 50.8686 143.692C50.7246 143.692 50.5806 143.704 50.4366 143.728C50.2926 143.744 50.1526 143.772 50.0166 143.812L50.4966 143.164C50.6486 143.092 50.8126 143.036 50.9886 142.996C51.1646 142.956 51.3406 142.936 51.5166 142.936C51.9646 142.936 52.3646 143.04 52.7166 143.248C53.0766 143.456 53.3606 143.748 53.5686 144.124C53.7846 144.5 53.8926 144.936 53.8926 145.432C53.8926 145.96 53.7646 146.428 53.5086 146.836C53.2606 147.236 52.9166 147.552 52.4766 147.784C52.0366 148.008 51.5246 148.12 50.9406 148.12ZM50.0166 143.812V143.128L52.4526 140.356L53.7966 140.344L51.2886 143.188L50.0166 143.812ZM48.7326 140.68V139.672H53.7966V140.344L52.8126 140.68H48.7326Z"
        fill="#ACACD2"
      />
      <g filter="url(#filter4_b_736_20174)">
        <rect
          x={248}
          y={132}
          width={24}
          height={24}
          rx={12}
          fill="url(#paint4_linear_736_20174)"
          fillOpacity={0.33}
        />
        <path
          d="M264.5 145.5C263.672 145.5 263 144.828 263 144C263 143.172 263.672 142.5 264.5 142.5C265.328 142.5 266 143.172 266 144C266 144.828 265.328 145.5 264.5 145.5Z"
          fill="#ACACD2"
        />
        <path
          d="M260 145.5C259.172 145.5 258.5 144.828 258.5 144C258.5 143.172 259.172 142.5 260 142.5C260.828 142.5 261.5 143.172 261.5 144C261.5 144.828 260.828 145.5 260 145.5Z"
          fill="#ACACD2"
        />
        <path
          d="M254 144C254 144.828 254.672 145.5 255.5 145.5C256.328 145.5 257 144.828 257 144C257 143.172 256.328 142.5 255.5 142.5C254.672 142.5 254 143.172 254 144Z"
          fill="#ACACD2"
        />
        <rect
          x={248.5}
          y={132.5}
          width={23}
          height={23}
          rx={11.5}
          stroke="#4D4DB2"
        />
      </g>
      <path d="M0 124.5H272V123.5H0V124.5Z" fill="#4D4DB2" fillOpacity={0.25} />
    </g>
    <g filter="url(#filter5_b_736_20174)">
      <path
        d="M243.109 65.6641C243.666 65.2932 244 64.6687 244 64C244 63.3313 243.666 62.7068 243.109 62.3359L239.781 60.1171C238.668 59.3752 238 58.1263 238 56.7889V44C238 41.7909 236.209 40 234 40H132C129.791 40 128 41.7909 128 44L128 136C128 138.209 129.791 140 132 140H234C236.209 140 238 138.209 238 136V71.2111C238 69.8737 238.668 68.6248 239.781 67.8829L243.109 65.6641Z"
        fill="url(#paint5_linear_736_20174)"
        fillOpacity={0.05}
      />
      <path
        d="M243.109 65.6641C243.666 65.2932 244 64.6687 244 64C244 63.3313 243.666 62.7068 243.109 62.3359L239.781 60.1171C238.668 59.3752 238 58.1263 238 56.7889V44C238 41.7909 236.209 40 234 40H132C129.791 40 128 41.7909 128 44L128 136C128 138.209 129.791 140 132 140H234C236.209 140 238 138.209 238 136V71.2111C238 69.8737 238.668 68.6248 239.781 67.8829L243.109 65.6641Z"
        fill="url(#paint6_linear_736_20174)"
        fillOpacity={0.75}
      />
    </g>
    <g filter="url(#filter6_b_736_20174)">
      <g filter="url(#filter7_d_736_20174)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M149.497 84C149.036 84 148.576 84.1757 148.224 84.5272L140.776 91.9757C140.692 92.0595 140.635 92.1662 140.612 92.2823L140.012 95.2823C139.972 95.4791 140.034 95.6824 140.176 95.8243C140.318 95.9661 140.521 96.0277 140.718 95.9884L143.718 95.3884C143.834 95.3651 143.941 95.308 144.024 95.2243L151.473 87.7757C151.824 87.4243 152 86.9636 152 86.5029C152 86.0423 151.824 85.5816 151.473 85.2301L150.77 84.5272C150.418 84.1757 149.958 84 149.497 84ZM149.073 85.3757C149.307 85.1414 149.687 85.1414 149.921 85.3757L150.624 86.0787C150.859 86.313 150.859 86.6929 150.624 86.9272L149.497 88.0544L147.946 86.5029L149.073 85.3757ZM147.097 87.3515L148.649 88.9029L143.304 94.2473L141.365 94.6351L141.753 92.6958L147.097 87.3515Z"
          fill="#0080FF"
        />
        <path
          d="M146.9 94.8C146.569 94.8 146.3 95.0686 146.3 95.4C146.3 95.7314 146.569 96 146.9 96H151.4C151.731 96 152 95.7314 152 95.4C152 95.0686 151.731 94.8 151.4 94.8H146.9Z"
          fill="#0080FF"
        />
      </g>
      <path
        d="M161.925 94V85.672H163.053V94H161.925ZM162.693 94V92.968H167.469V94H162.693ZM162.693 90.232V89.248H167.073V90.232H162.693ZM162.693 86.704V85.672H167.409V86.704H162.693ZM171.118 94.12C170.59 94.12 170.118 93.992 169.702 93.736C169.286 93.472 168.954 93.116 168.706 92.668C168.466 92.22 168.346 91.716 168.346 91.156C168.346 90.596 168.466 90.092 168.706 89.644C168.954 89.196 169.286 88.84 169.702 88.576C170.118 88.312 170.59 88.18 171.118 88.18C171.542 88.18 171.926 88.272 172.27 88.456C172.614 88.632 172.89 88.88 173.098 89.2C173.314 89.512 173.434 89.876 173.458 90.292V92.008C173.434 92.416 173.318 92.78 173.11 93.1C172.902 93.42 172.626 93.672 172.282 93.856C171.938 94.032 171.55 94.12 171.118 94.12ZM171.298 93.1C171.658 93.1 171.97 93.016 172.234 92.848C172.506 92.68 172.718 92.452 172.87 92.164C173.022 91.868 173.098 91.532 173.098 91.156C173.098 90.764 173.018 90.424 172.858 90.136C172.706 89.848 172.494 89.62 172.222 89.452C171.958 89.284 171.646 89.2 171.286 89.2C170.926 89.2 170.61 89.284 170.338 89.452C170.066 89.62 169.85 89.852 169.69 90.148C169.538 90.436 169.462 90.768 169.462 91.144C169.462 91.528 169.538 91.868 169.69 92.164C169.85 92.452 170.066 92.68 170.338 92.848C170.618 93.016 170.938 93.1 171.298 93.1ZM174.118 94H173.026V92.464L173.23 91.072L173.026 89.692V85.432H174.118V94ZM175.702 94V88.3H176.782V94H175.702ZM176.242 87.16C176.042 87.16 175.878 87.096 175.75 86.968C175.622 86.832 175.558 86.664 175.558 86.464C175.558 86.272 175.622 86.112 175.75 85.984C175.878 85.848 176.042 85.78 176.242 85.78C176.442 85.78 176.606 85.848 176.734 85.984C176.862 86.112 176.926 86.272 176.926 86.464C176.926 86.664 176.862 86.832 176.734 86.968C176.606 87.096 176.442 87.16 176.242 87.16ZM179.25 94V85.912H180.33V94H179.25ZM177.846 89.284V88.3H181.734V89.284H177.846Z"
        fill="#ACACD2"
      />
    </g>
    <g filter="url(#filter8_b_736_20174)">
      <g filter="url(#filter9_d_736_20174)">
        <path
          d="M146 63.2C146.663 63.2 147.2 62.6627 147.2 62C147.2 61.3372 146.663 60.8 146 60.8C145.337 60.8 144.8 61.3372 144.8 62C144.8 62.6627 145.337 63.2 146 63.2Z"
          fill="#FF9933"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M151.822 61.5731L151.825 61.5764C152.058 61.8105 152.058 62.1895 151.825 62.4236L151.822 62.4269L151.814 62.4347L151.786 62.4627C151.761 62.4866 151.726 62.5209 151.68 62.564C151.649 62.5934 151.614 62.627 151.573 62.6643C151.496 62.7362 151.402 62.822 151.293 62.9181C150.965 63.209 150.499 63.5979 149.954 63.9881C148.897 64.7442 147.411 65.6001 146 65.6001C144.589 65.6001 143.103 64.7442 142.046 63.9881C141.501 63.5979 141.036 63.209 140.707 62.9181C140.542 62.7723 140.411 62.6503 140.32 62.564C140.293 62.5383 140.269 62.5157 140.249 62.4966C140.236 62.4837 140.224 62.4723 140.215 62.4627L140.186 62.4347L140.178 62.4269L140.176 62.4246L140.175 62.4239C140.175 62.4238 140.175 62.4236 140.3 62.2988L140.175 62.4234C139.942 62.1893 139.942 61.8105 140.175 61.5764L140.176 61.5754L140.178 61.5731L140.186 61.5653L140.215 61.5373L140.246 61.5068C140.266 61.487 140.291 61.4632 140.32 61.4359C140.411 61.3497 140.542 61.2277 140.707 61.0819C141.036 60.791 141.501 60.4021 142.046 60.0119C143.103 59.2558 144.589 58.3999 146 58.3999C147.411 58.3999 148.897 59.2558 149.954 60.0119C150.499 60.4021 150.965 60.791 151.293 61.0819C151.402 61.1779 151.496 61.2636 151.573 61.3355C151.613 61.3728 151.649 61.4065 151.68 61.4359C151.726 61.4791 151.761 61.5134 151.786 61.5373L151.814 61.5653L151.822 61.5731ZM141.502 62.0194L141.48 62L141.502 61.9805C141.809 61.709 142.241 61.3478 142.744 60.988C143.784 60.2441 144.999 59.5999 146 59.5999C147.002 59.5999 148.216 60.2441 149.256 60.988C149.759 61.3478 150.191 61.709 150.498 61.9805L150.52 62L150.498 62.0194C150.191 62.291 149.759 62.6522 149.256 63.012C148.216 63.7559 147.002 64.4 146 64.4C144.999 64.4 143.784 63.7559 142.744 63.012C142.241 62.6522 141.809 62.291 141.502 62.0194Z"
          fill="#FF9933"
        />
      </g>
      <path
        d="M164.399 66L161.063 57.672H162.287L165.035 64.716H164.591L167.363 57.672H168.575L165.215 66H164.399ZM169.757 66V60.3H170.837V66H169.757ZM170.297 59.16C170.097 59.16 169.933 59.096 169.805 58.968C169.677 58.832 169.613 58.664 169.613 58.464C169.613 58.272 169.677 58.112 169.805 57.984C169.933 57.848 170.097 57.78 170.297 57.78C170.497 57.78 170.661 57.848 170.789 57.984C170.917 58.112 170.981 58.272 170.981 58.464C170.981 58.664 170.917 58.832 170.789 58.968C170.661 59.096 170.497 59.16 170.297 59.16ZM175.069 66.12C174.501 66.12 173.989 65.992 173.533 65.736C173.077 65.472 172.717 65.116 172.453 64.668C172.189 64.22 172.057 63.712 172.057 63.144C172.057 62.584 172.185 62.08 172.441 61.632C172.705 61.184 173.057 60.832 173.497 60.576C173.945 60.312 174.445 60.18 174.997 60.18C175.525 60.18 175.989 60.3 176.389 60.54C176.797 60.78 177.113 61.112 177.337 61.536C177.569 61.96 177.685 62.44 177.685 62.976C177.685 63.056 177.681 63.144 177.673 63.24C177.665 63.328 177.649 63.432 177.625 63.552H172.813V62.652H177.049L176.653 63C176.653 62.616 176.585 62.292 176.449 62.028C176.313 61.756 176.121 61.548 175.873 61.404C175.625 61.252 175.325 61.176 174.973 61.176C174.605 61.176 174.281 61.256 174.001 61.416C173.721 61.576 173.505 61.8 173.353 62.088C173.201 62.376 173.125 62.716 173.125 63.108C173.125 63.508 173.205 63.86 173.365 64.164C173.525 64.46 173.753 64.692 174.049 64.86C174.345 65.02 174.685 65.1 175.069 65.1C175.389 65.1 175.681 65.044 175.945 64.932C176.217 64.82 176.449 64.652 176.641 64.428L177.337 65.136C177.065 65.456 176.729 65.7 176.329 65.868C175.937 66.036 175.517 66.12 175.069 66.12ZM180.424 66L178.168 60.3H179.296L180.928 64.74H180.568L182.188 60.3H182.812L184.432 64.74H184.072L185.704 60.3H186.832L184.588 66H183.952L182.308 61.692H182.704L181.048 66H180.424Z"
        fill="#ACACD2"
      />
    </g>
    <g filter="url(#filter10_b_736_20174)">
      <g filter="url(#filter11_d_736_20174)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M143.6 113.2C143.6 112.537 144.137 112 144.8 112H147.2C147.863 112 148.4 112.537 148.4 113.2V114.4H151.4C151.731 114.4 152 114.669 152 115C152 115.331 151.731 115.6 151.4 115.6H150.72L149.668 122.97C149.583 123.561 149.077 124 148.48 124H143.52C142.923 124 142.417 123.561 142.332 122.97L141.28 115.6H140.6C140.269 115.6 140 115.331 140 115C140 114.669 140.269 114.4 140.6 114.4H143.6V113.2ZM144.8 114.4H147.2V113.2H144.8V114.4ZM142.492 115.6L143.52 122.8H148.48L149.508 115.6H142.492Z"
          fill="#FF4C4D"
        />
      </g>
      <path
        d="M161.818 122V120.968H164.134C164.75 120.968 165.29 120.836 165.754 120.572C166.218 120.3 166.578 119.928 166.834 119.456C167.098 118.984 167.23 118.44 167.23 117.824C167.23 117.216 167.098 116.676 166.834 116.204C166.57 115.732 166.206 115.364 165.742 115.1C165.278 114.836 164.742 114.704 164.134 114.704H161.83V113.672H164.158C164.766 113.672 165.326 113.776 165.838 113.984C166.358 114.192 166.806 114.484 167.182 114.86C167.566 115.236 167.862 115.676 168.07 116.18C168.286 116.684 168.394 117.236 168.394 117.836C168.394 118.428 168.286 118.98 168.07 119.492C167.862 119.996 167.57 120.436 167.194 120.812C166.818 121.188 166.37 121.48 165.85 121.688C165.338 121.896 164.782 122 164.182 122H161.818ZM161.074 122V113.672H162.202V122H161.074ZM172.405 122.12C171.837 122.12 171.325 121.992 170.869 121.736C170.413 121.472 170.053 121.116 169.789 120.668C169.525 120.22 169.393 119.712 169.393 119.144C169.393 118.584 169.521 118.08 169.777 117.632C170.041 117.184 170.393 116.832 170.833 116.576C171.281 116.312 171.781 116.18 172.333 116.18C172.861 116.18 173.325 116.3 173.725 116.54C174.133 116.78 174.449 117.112 174.673 117.536C174.905 117.96 175.021 118.44 175.021 118.976C175.021 119.056 175.017 119.144 175.009 119.24C175.001 119.328 174.985 119.432 174.961 119.552H170.149V118.652H174.385L173.989 119C173.989 118.616 173.921 118.292 173.785 118.028C173.649 117.756 173.457 117.548 173.209 117.404C172.961 117.252 172.661 117.176 172.309 117.176C171.941 117.176 171.617 117.256 171.337 117.416C171.057 117.576 170.841 117.8 170.689 118.088C170.537 118.376 170.461 118.716 170.461 119.108C170.461 119.508 170.541 119.86 170.701 120.164C170.861 120.46 171.089 120.692 171.385 120.86C171.681 121.02 172.021 121.1 172.405 121.1C172.725 121.1 173.017 121.044 173.281 120.932C173.553 120.82 173.785 120.652 173.977 120.428L174.673 121.136C174.401 121.456 174.065 121.7 173.665 121.868C173.273 122.036 172.853 122.12 172.405 122.12ZM176.198 122V113.432H177.278V122H176.198ZM181.498 122.12C180.93 122.12 180.418 121.992 179.962 121.736C179.506 121.472 179.146 121.116 178.882 120.668C178.618 120.22 178.486 119.712 178.486 119.144C178.486 118.584 178.614 118.08 178.87 117.632C179.134 117.184 179.486 116.832 179.926 116.576C180.374 116.312 180.874 116.18 181.426 116.18C181.954 116.18 182.418 116.3 182.818 116.54C183.226 116.78 183.542 117.112 183.766 117.536C183.998 117.96 184.114 118.44 184.114 118.976C184.114 119.056 184.11 119.144 184.102 119.24C184.094 119.328 184.078 119.432 184.054 119.552H179.242V118.652H183.478L183.082 119C183.082 118.616 183.014 118.292 182.878 118.028C182.742 117.756 182.55 117.548 182.302 117.404C182.054 117.252 181.754 117.176 181.402 117.176C181.034 117.176 180.71 117.256 180.43 117.416C180.15 117.576 179.934 117.8 179.782 118.088C179.63 118.376 179.554 118.716 179.554 119.108C179.554 119.508 179.634 119.86 179.794 120.164C179.954 120.46 180.182 120.692 180.478 120.86C180.774 121.02 181.114 121.1 181.498 121.1C181.818 121.1 182.11 121.044 182.374 120.932C182.646 120.82 182.878 120.652 183.07 120.428L183.766 121.136C183.494 121.456 183.158 121.7 182.758 121.868C182.366 122.036 181.946 122.12 181.498 122.12ZM185.992 122V113.912H187.072V122H185.992ZM184.588 117.284V116.3H188.476V117.284H184.588ZM191.998 122.12C191.43 122.12 190.918 121.992 190.462 121.736C190.006 121.472 189.646 121.116 189.382 120.668C189.118 120.22 188.986 119.712 188.986 119.144C188.986 118.584 189.114 118.08 189.37 117.632C189.634 117.184 189.986 116.832 190.426 116.576C190.874 116.312 191.374 116.18 191.926 116.18C192.454 116.18 192.918 116.3 193.318 116.54C193.726 116.78 194.042 117.112 194.266 117.536C194.498 117.96 194.614 118.44 194.614 118.976C194.614 119.056 194.61 119.144 194.602 119.24C194.594 119.328 194.578 119.432 194.554 119.552H189.742V118.652H193.978L193.582 119C193.582 118.616 193.514 118.292 193.378 118.028C193.242 117.756 193.05 117.548 192.802 117.404C192.554 117.252 192.254 117.176 191.902 117.176C191.534 117.176 191.21 117.256 190.93 117.416C190.65 117.576 190.434 117.8 190.282 118.088C190.13 118.376 190.054 118.716 190.054 119.108C190.054 119.508 190.134 119.86 190.294 120.164C190.454 120.46 190.682 120.692 190.978 120.86C191.274 121.02 191.614 121.1 191.998 121.1C192.318 121.1 192.61 121.044 192.874 120.932C193.146 120.82 193.378 120.652 193.57 120.428L194.266 121.136C193.994 121.456 193.658 121.7 193.258 121.868C192.866 122.036 192.446 122.12 191.998 122.12Z"
        fill="#ACACD2"
      />
    </g>
    <defs>
      <filter
        id="filter0_b_736_20174"
        x={120}
        y={-8}
        width={160}
        height={48}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter1_d_736_20174"
        x={132}
        y={2}
        width={28}
        height={28}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.121569 0 0 0 0 0.678431 0 0 0 0 0.4 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter2_b_736_20174"
        x={200}
        y={4}
        width={120}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter3_b_736_20174"
        x={200}
        y={44}
        width={120}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter4_b_736_20174"
        x={200}
        y={84}
        width={120}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter5_b_736_20174"
        x={120}
        y={32}
        width={132}
        height={116}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={4} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter6_b_736_20174"
        x={88}
        y={30}
        width={190}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter7_d_736_20174"
        x={132}
        y={76}
        width={28}
        height={28}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0.5 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter8_b_736_20174"
        x={88}
        y={2}
        width={190}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter9_d_736_20174"
        x={132}
        y={50.3999}
        width={28}
        height={23.2002}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 0.6 0 0 0 0 0.2 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter10_b_736_20174"
        x={88}
        y={58}
        width={190}
        height={120}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feGaussianBlur in="BackgroundImageFix" stdDeviation={24} />
        <feComposite
          in2="SourceAlpha"
          operator="in"
          result="effect1_backgroundBlur_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_backgroundBlur_736_20174"
          result="shape"
        />
      </filter>
      <filter
        id="filter11_d_736_20174"
        x={132}
        y={104}
        width={28}
        height={28}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation={4} />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 0.3 0 0 0 0 0.3 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_736_20174"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_736_20174"
          result="shape"
        />
      </filter>
      <linearGradient
        id="paint0_linear_736_20174"
        x1={200}
        y1={0}
        x2={200}
        y2={32}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#384F94" />
        <stop offset={1} stopColor="#17174F" stopOpacity={0} />
      </linearGradient>
      <linearGradient
        id="paint1_linear_736_20174"
        x1={272}
        y1={64}
        x2={0.0000021312}
        y2={64.0001}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#17174F" stopOpacity={0} />
        <stop offset={0.125} stopColor="#17174F" />
        <stop offset={0.875} stopColor="#17174F" />
        <stop offset={1} stopColor="#17174F" stopOpacity={0} />
      </linearGradient>
      <linearGradient
        id="paint2_linear_736_20174"
        x1={260}
        y1={52}
        x2={260}
        y2={76}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint3_linear_736_20174"
        x1={260}
        y1={92}
        x2={260}
        y2={116}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint4_linear_736_20174"
        x1={260}
        y1={132}
        x2={260}
        y2={156}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint5_linear_736_20174"
        x1={186}
        y1={44}
        x2={186}
        y2={84}
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset={1} stopOpacity={0.5} />
      </linearGradient>
      <linearGradient
        id="paint6_linear_736_20174"
        x1={128}
        y1={36}
        x2={200.176}
        y2={154.951}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#384F94" />
        <stop offset={1} stopColor="#17174F" stopOpacity={0} />
      </linearGradient>
    </defs>
  </svg>
);
