import React from "react";

export const LandingHeroNestjsIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width={64}
    height={64}
    viewBox="0 0 64 64"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <g
      opacity={0.5}
      className="hidden dark:block"
      filter="url(#filter0_f_1305_2754)"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M34.1315 20C33.9579 20 33.7968 20.0373 33.648 20.0871C33.9641 20.2987 34.1377 20.5787 34.2244 20.896C34.2307 20.9396 34.243 20.9707 34.2492 21.0143C34.2555 21.0516 34.2616 21.0889 34.2616 21.1263C34.2864 21.6738 34.1191 21.7423 34.0013 22.0658C33.8216 22.4828 33.8712 22.9308 34.0881 23.2917C34.1067 23.3352 34.1315 23.385 34.1625 23.4286C33.9269 21.8543 35.2347 21.6178 35.4764 21.1263C35.495 20.6969 35.1418 20.4107 34.8628 20.2116C34.5963 20.0498 34.3546 20 34.1315 20ZM36.1025 20.3547C36.0777 20.4978 36.0962 20.4605 36.0901 20.5351C36.0839 20.5849 36.0839 20.6471 36.0777 20.6969C36.0653 20.7467 36.0529 20.7965 36.0343 20.8463C36.0219 20.896 36.0033 20.9458 35.9847 20.9956C35.9599 21.0454 35.9413 21.0889 35.9165 21.1387C35.8979 21.1636 35.8855 21.1885 35.8669 21.2134C35.8546 21.232 35.8421 21.2507 35.8298 21.2694C35.7988 21.3129 35.7678 21.3565 35.7368 21.3938C35.6996 21.4312 35.6686 21.4747 35.6252 21.5058V21.5121C35.588 21.5432 35.5508 21.5805 35.5075 21.6116C35.3773 21.7112 35.2285 21.7858 35.0922 21.8792C35.0488 21.9103 35.0054 21.9352 34.9682 21.9725C34.9248 22.0036 34.8877 22.0347 34.8505 22.0721C34.8071 22.1094 34.7761 22.1468 34.7389 22.1903C34.7079 22.2276 34.6707 22.2712 34.6459 22.3148C34.6149 22.3583 34.584 22.4019 34.5592 22.4454C34.5344 22.4952 34.5158 22.5388 34.491 22.5885C34.4724 22.6383 34.4538 22.6819 34.4414 22.7317C34.4228 22.7877 34.4104 22.8374 34.398 22.8872C34.3918 22.9121 34.3918 22.9432 34.3856 22.9681C34.3794 22.993 34.3794 23.0179 34.3732 23.0428C34.3732 23.0926 34.367 23.1486 34.367 23.1983C34.367 23.2357 34.367 23.273 34.3732 23.3103C34.3732 23.3601 34.3794 23.4099 34.3918 23.4659C34.398 23.5157 34.4104 23.5655 34.4228 23.6152C34.4414 23.665 34.4538 23.7148 34.4724 23.7646C34.4848 23.7957 34.5034 23.8268 34.5158 23.8517L33.0902 23.2979C32.8485 23.2295 32.613 23.1672 32.3713 23.1112C32.2411 23.0801 32.111 23.049 31.9808 23.0179C31.6089 22.9432 31.2308 22.8872 30.8528 22.8499C30.8404 22.8499 30.8342 22.8437 30.8218 22.8437C30.4499 22.8063 30.0842 22.7877 29.7123 22.7877C29.4396 22.7877 29.1669 22.8001 28.9004 22.8188C28.5223 22.8437 28.1442 22.8934 27.7661 22.9557C27.6732 22.9681 27.5802 22.9868 27.4872 23.0054C27.2951 23.0428 27.1091 23.0863 26.9294 23.1299C26.8364 23.1548 26.7435 23.1797 26.6505 23.2046C26.5575 23.2419 26.4707 23.2854 26.384 23.3228C26.3158 23.3539 26.2476 23.385 26.1794 23.4161C26.167 23.4224 26.1546 23.4224 26.1484 23.4286C26.0865 23.4597 26.0307 23.4846 25.9749 23.5157C25.9563 23.5219 25.9439 23.5281 25.9315 23.5343C25.8633 23.5654 25.7952 23.6028 25.7394 23.6339C25.696 23.6526 25.6526 23.6775 25.6154 23.6961C25.5968 23.7086 25.572 23.721 25.5596 23.7272C25.5038 23.7583 25.4481 23.7895 25.3985 23.8206C25.3427 23.8517 25.2931 23.8828 25.2497 23.9139C25.2063 23.945 25.163 23.9699 25.1258 24.001C25.1196 24.0072 25.1134 24.0072 25.1072 24.0135C25.07 24.0384 25.0266 24.0695 24.9894 24.1006C24.9894 24.1006 24.9832 24.1068 24.977 24.113C24.946 24.1379 24.915 24.1628 24.8841 24.1877C24.8717 24.1939 24.8593 24.2063 24.8469 24.2126C24.8159 24.2375 24.7849 24.2686 24.7539 24.2935C24.7477 24.3059 24.7353 24.3121 24.7291 24.3184C24.6919 24.3557 24.6547 24.3868 24.6175 24.4241C24.6113 24.4241 24.6113 24.4304 24.6051 24.4366C24.568 24.4677 24.5308 24.505 24.4936 24.5424C24.4874 24.5486 24.4874 24.5548 24.4812 24.5548C24.4502 24.5859 24.4192 24.617 24.3882 24.6544C24.3758 24.6668 24.3572 24.6793 24.3448 24.6917C24.3138 24.729 24.2767 24.7664 24.2395 24.8037C24.2333 24.8161 24.2209 24.8224 24.2147 24.8348C24.1651 24.8846 24.1217 24.9344 24.0721 24.9841C24.0659 24.9904 24.0597 24.9966 24.0535 25.0028C23.9543 25.1086 23.849 25.2144 23.7374 25.3077C23.6259 25.4073 23.5081 25.5006 23.3903 25.5815C23.2664 25.6686 23.1486 25.7433 23.0184 25.818C22.8945 25.8864 22.7643 25.9486 22.628 26.0046C22.4978 26.0606 22.3615 26.1104 22.2251 26.154C21.9648 26.21 21.6983 26.3157 21.4689 26.3344C21.4193 26.3344 21.3636 26.3469 21.314 26.3531C21.2582 26.3655 21.2086 26.378 21.159 26.3904C21.1094 26.4091 21.0599 26.4278 21.0103 26.4464C20.9607 26.4651 20.9111 26.49 20.8615 26.5149C20.8181 26.546 20.7686 26.5709 20.7252 26.602C20.6818 26.6331 20.6384 26.6704 20.6012 26.7078C20.5578 26.7389 20.5144 26.7824 20.4772 26.8198C20.4401 26.8633 20.4029 26.9007 20.3719 26.9442C20.3409 26.994 20.3037 27.0376 20.2789 27.0873C20.2479 27.1309 20.2169 27.1807 20.1921 27.2304C20.1673 27.2864 20.1426 27.3362 20.124 27.3922C20.1054 27.442 20.0868 27.498 20.0682 27.554C20.0558 27.6038 20.0434 27.6536 20.0372 27.7033C20.0372 27.7096 20.031 27.7158 20.031 27.722C20.0186 27.778 20.0186 27.8527 20.0124 27.89C20.0062 27.9336 20 27.9709 20 28.0145C20 28.0394 20 28.0705 20.0062 28.0954C20.0124 28.1389 20.0186 28.1763 20.031 28.2136C20.0434 28.2509 20.0558 28.2883 20.0744 28.3256V28.3318C20.093 28.3692 20.1178 28.4065 20.1426 28.4438C20.1674 28.4812 20.1922 28.5185 20.2231 28.5558C20.2541 28.587 20.2913 28.6243 20.3285 28.6554C20.3657 28.6927 20.4029 28.7238 20.4463 28.755C20.595 28.8856 20.6322 28.9292 20.8244 29.0287C20.8553 29.0474 20.8863 29.0599 20.9235 29.0785C20.9297 29.0785 20.9359 29.0848 20.9421 29.0848C20.9421 29.0972 20.9421 29.1034 20.9483 29.1159C20.9545 29.1656 20.9669 29.2154 20.9793 29.2652C20.9917 29.3212 21.0103 29.371 21.0289 29.4145C21.0475 29.4519 21.0599 29.4892 21.0785 29.5265C21.0847 29.539 21.0909 29.5514 21.0971 29.5577C21.1219 29.6074 21.1467 29.651 21.1715 29.6946C21.2025 29.7381 21.2334 29.7817 21.2644 29.8252C21.2954 29.8626 21.3326 29.9061 21.3698 29.9435C21.407 29.9808 21.4442 30.0119 21.4876 30.0492C21.4876 30.0492 21.4938 30.0555 21.4999 30.0555C21.5371 30.0866 21.5743 30.1177 21.6115 30.1426C21.6549 30.1737 21.6983 30.1986 21.7479 30.2235C21.7913 30.2484 21.8408 30.2733 21.8904 30.2919C21.9276 30.3106 21.971 30.323 22.0144 30.3355C22.0206 30.3417 22.0268 30.3417 22.0392 30.3479C22.064 30.3542 22.095 30.3604 22.1198 30.3666C22.1012 30.7026 22.095 31.0199 22.1446 31.1319C22.2003 31.2564 22.4731 30.8768 22.7458 30.4413C22.7086 30.8706 22.6838 31.3746 22.7458 31.524C22.8139 31.6795 23.1858 31.1942 23.5081 30.659C27.9025 29.6386 31.9127 32.6876 32.3341 36.9935C32.2536 36.3215 31.4292 35.9481 31.0511 36.0414C30.8652 36.5019 30.5491 37.093 30.0409 37.4602C30.0842 37.0495 30.0657 36.6264 29.9789 36.2157C29.8425 36.7881 29.576 37.3233 29.2103 37.7837C28.6215 37.8273 28.0327 37.5411 27.7228 37.1117C27.698 37.093 27.6918 37.0557 27.6732 37.0308C27.6546 36.9873 27.636 36.9437 27.6236 36.9001C27.605 36.8566 27.5926 36.813 27.5864 36.7695C27.5802 36.7259 27.5802 36.6824 27.5802 36.6326C27.5802 36.6015 27.5802 36.5704 27.5802 36.5392C27.5864 36.4957 27.5988 36.4521 27.6112 36.4086C27.6236 36.365 27.636 36.3215 27.6546 36.2779C27.6794 36.2343 27.698 36.1908 27.729 36.1472C27.8343 35.8486 27.8343 35.6059 27.6422 35.4628C27.605 35.4379 27.5678 35.4192 27.5244 35.4005C27.4996 35.3943 27.4687 35.3819 27.4439 35.3756C27.4253 35.3694 27.4129 35.3632 27.3943 35.357C27.3509 35.3445 27.3075 35.3321 27.2641 35.3259C27.2207 35.3134 27.1774 35.3072 27.134 35.3072C27.0906 35.301 27.041 35.2948 26.9976 35.2948C26.9666 35.2948 26.9356 35.301 26.9046 35.301C26.8551 35.301 26.8117 35.3072 26.7683 35.3197C26.7249 35.3259 26.6815 35.3321 26.6381 35.3445C26.5947 35.357 26.5514 35.3694 26.508 35.3881C26.4646 35.4068 26.4274 35.4254 26.384 35.4441C26.3468 35.4628 26.3096 35.4877 26.2662 35.5063C24.8221 36.4521 25.6836 38.6673 26.6691 39.3082C26.2972 39.3767 25.9192 39.4576 25.8138 39.5385C25.8076 39.5447 25.8014 39.5509 25.8014 39.5509C26.0679 39.7127 26.3468 39.8496 26.6381 39.9678C27.0348 40.0985 27.4563 40.2167 27.6422 40.2665V40.2727C28.1567 40.3785 28.6773 40.4158 29.2041 40.3847C31.9499 40.1918 34.1997 38.0949 34.6088 35.3321C34.6212 35.3881 34.6336 35.4379 34.646 35.4939C34.6646 35.6059 34.6894 35.7241 34.7018 35.8423V35.8486C34.7142 35.9046 34.7204 35.9606 34.7266 36.0104V36.0353C34.7328 36.0913 34.739 36.1473 34.739 36.197C34.7452 36.2655 34.7514 36.3339 34.7514 36.4024V36.5019C34.7514 36.5331 34.7576 36.5704 34.7576 36.6015C34.7576 36.6388 34.7514 36.6762 34.7514 36.7135V36.8006C34.7514 36.8442 34.7451 36.8815 34.7451 36.9251C34.7451 36.95 34.7451 36.9749 34.7389 37.006C34.7389 37.0495 34.7327 37.0931 34.7327 37.1429C34.7265 37.1615 34.7265 37.1802 34.7265 37.1989C34.7203 37.2486 34.7141 37.2922 34.7079 37.342C34.7079 37.3606 34.7079 37.3793 34.7017 37.398C34.6955 37.4602 34.6831 37.5162 34.6769 37.5784V37.5847V37.5909C34.6645 37.6469 34.6521 37.7091 34.6397 37.7651V37.7838C34.6273 37.8398 34.6149 37.8958 34.6025 37.9518C34.6025 37.958 34.5963 37.9705 34.5963 37.9767C34.5839 38.0327 34.5715 38.0887 34.5529 38.1447V38.1634C34.5344 38.2256 34.5158 38.2816 34.5034 38.3376C34.4972 38.3438 34.4972 38.35 34.4972 38.35C34.4786 38.4123 34.46 38.4745 34.4414 38.5367C34.4166 38.5989 34.398 38.6549 34.3732 38.7172C34.3484 38.7794 34.3298 38.8416 34.305 38.8976C34.2802 38.9598 34.2554 39.0158 34.2306 39.0781H34.2244C34.1996 39.1341 34.1748 39.1963 34.1438 39.2523C34.1376 39.271 34.1315 39.2834 34.1253 39.2958C34.119 39.3021 34.119 39.3083 34.1129 39.3145C33.71 40.1297 33.115 40.8452 32.3712 41.4053C32.3216 41.4364 32.2721 41.4737 32.2225 41.511C32.2101 41.5235 32.1915 41.5297 32.1791 41.5421C32.1357 41.5733 32.0923 41.6044 32.0427 41.6355L32.0613 41.6728H32.0675C32.1543 41.6604 32.2411 41.6479 32.3278 41.6355H32.334C32.4952 41.6106 32.6563 41.5795 32.8175 41.5484C32.8609 41.5421 32.9105 41.5297 32.9539 41.5173C32.9848 41.511 33.0096 41.5048 33.0406 41.4986C33.084 41.4923 33.1274 41.4799 33.1708 41.4737C33.208 41.4613 33.2452 41.455 33.2824 41.4426C33.9022 41.2932 34.5034 41.0879 35.0798 40.8452C34.0943 42.1955 32.7741 43.2844 31.2308 44C31.9436 43.9502 32.6563 43.832 33.3443 43.6329C35.8421 42.8924 37.9433 41.2061 39.2015 38.9349C38.9474 40.3723 38.3771 41.7413 37.5342 42.936C38.1354 42.5377 38.687 42.0773 39.1891 41.5546C40.5774 40.0985 41.4886 38.2505 41.7985 36.2655C42.0092 37.2487 42.0712 38.2629 41.9782 39.2647C46.4532 32.9987 42.3501 26.5025 40.6332 24.7913C40.627 24.7789 40.6208 24.7727 40.6208 24.7602C40.6146 24.7665 40.6146 24.7665 40.6146 24.7727C40.6146 24.7664 40.6146 24.7664 40.6084 24.7602C40.6084 24.8349 40.6022 24.9096 40.596 24.9842C40.5774 25.1273 40.5588 25.2642 40.534 25.4011C40.5031 25.538 40.4659 25.6749 40.4287 25.8118C40.3853 25.9425 40.3357 26.0794 40.2799 26.21C40.2241 26.3345 40.1622 26.4652 40.094 26.5896C40.0258 26.7078 39.9514 26.8323 39.8709 26.9443C39.7903 27.0625 39.7035 27.1745 39.6167 27.2803C39.5238 27.3923 39.4246 27.4919 39.3254 27.5914C39.2634 27.6474 39.2077 27.6972 39.1457 27.747C39.0961 27.7905 39.0527 27.8279 39.0031 27.8714C38.8916 27.9586 38.78 28.0394 38.656 28.1141C38.5383 28.1888 38.4143 28.2635 38.2904 28.3257C38.1602 28.3879 38.03 28.4439 37.8999 28.4999C37.7697 28.5497 37.6334 28.5932 37.497 28.6306C37.3606 28.6679 37.2181 28.699 37.0817 28.7239C36.9392 28.7488 36.7966 28.7612 36.6603 28.7737C36.5611 28.7799 36.4619 28.7861 36.3628 28.7861C36.2202 28.7861 36.0777 28.7737 35.9413 28.7612C35.7987 28.7488 35.6562 28.7301 35.5198 28.699C35.3773 28.6741 35.2409 28.6368 35.1046 28.5932H35.0984C35.2347 28.5808 35.3711 28.5683 35.5074 28.5434C35.65 28.5185 35.7863 28.4874 35.9227 28.4501C36.0591 28.4128 36.1954 28.3692 36.3256 28.3194C36.4619 28.2697 36.5921 28.2074 36.716 28.1452C36.8462 28.083 36.964 28.0145 37.0879 27.9399C37.2057 27.859 37.3235 27.7781 37.435 27.691C37.5466 27.6039 37.6519 27.5105 37.7511 27.411C37.8565 27.3176 37.9495 27.2118 38.0424 27.1061C38.1354 26.9941 38.2222 26.8821 38.3027 26.77C38.3151 26.7514 38.3275 26.7265 38.3399 26.7078C38.4019 26.6083 38.4639 26.5087 38.5197 26.4091C38.5879 26.2847 38.6498 26.1602 38.7056 26.0296C38.7614 25.8989 38.811 25.7682 38.8544 25.6313C38.8978 25.5007 38.9287 25.3638 38.9597 25.2269C38.9845 25.0838 39.0093 24.9469 39.0217 24.81C39.0341 24.6669 39.0465 24.5237 39.0465 24.3869C39.0465 24.2873 39.0403 24.1877 39.0341 24.0882C39.0217 23.9451 39.0031 23.8082 38.9845 23.6713C38.9597 23.5282 38.9288 23.3913 38.8916 23.2544C38.8482 23.1237 38.8048 22.9868 38.7552 22.8561C38.7056 22.7255 38.6437 22.5948 38.5817 22.4703C38.5135 22.3459 38.4453 22.2214 38.3709 22.1032C38.2904 21.985 38.2098 21.873 38.123 21.761C38.0301 21.6552 37.9371 21.5494 37.8379 21.4436C37.7883 21.3939 37.7325 21.3379 37.6768 21.2881C37.3979 21.0703 37.1065 20.865 36.8152 20.6783C36.7719 20.6534 36.7347 20.6347 36.6913 20.6161C36.4867 20.4854 36.2946 20.4169 36.1025 20.3547Z"
        fill="#E0234E"
      />
    </g>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M34.1315 20C33.9579 20 33.7968 20.0373 33.648 20.0871C33.9641 20.2987 34.1377 20.5787 34.2244 20.896C34.2307 20.9396 34.243 20.9707 34.2492 21.0143C34.2555 21.0516 34.2616 21.0889 34.2616 21.1263C34.2864 21.6738 34.1191 21.7423 34.0013 22.0658C33.8216 22.4828 33.8712 22.9308 34.0881 23.2917C34.1067 23.3352 34.1315 23.385 34.1625 23.4286C33.9269 21.8543 35.2347 21.6178 35.4764 21.1263C35.495 20.6969 35.1418 20.4107 34.8628 20.2116C34.5963 20.0498 34.3546 20 34.1315 20ZM36.1025 20.3547C36.0777 20.4978 36.0962 20.4605 36.0901 20.5351C36.0839 20.5849 36.0839 20.6471 36.0777 20.6969C36.0653 20.7467 36.0529 20.7965 36.0343 20.8463C36.0219 20.896 36.0033 20.9458 35.9847 20.9956C35.9599 21.0454 35.9413 21.0889 35.9165 21.1387C35.8979 21.1636 35.8855 21.1885 35.8669 21.2134C35.8546 21.232 35.8421 21.2507 35.8298 21.2694C35.7988 21.3129 35.7678 21.3565 35.7368 21.3938C35.6996 21.4312 35.6686 21.4747 35.6252 21.5058V21.5121C35.588 21.5432 35.5508 21.5805 35.5075 21.6116C35.3773 21.7112 35.2285 21.7858 35.0922 21.8792C35.0488 21.9103 35.0054 21.9352 34.9682 21.9725C34.9248 22.0036 34.8877 22.0347 34.8505 22.0721C34.8071 22.1094 34.7761 22.1468 34.7389 22.1903C34.7079 22.2276 34.6707 22.2712 34.6459 22.3148C34.6149 22.3583 34.584 22.4019 34.5592 22.4454C34.5344 22.4952 34.5158 22.5388 34.491 22.5885C34.4724 22.6383 34.4538 22.6819 34.4414 22.7317C34.4228 22.7877 34.4104 22.8374 34.398 22.8872C34.3918 22.9121 34.3918 22.9432 34.3856 22.9681C34.3794 22.993 34.3794 23.0179 34.3732 23.0428C34.3732 23.0926 34.367 23.1486 34.367 23.1983C34.367 23.2357 34.367 23.273 34.3732 23.3103C34.3732 23.3601 34.3794 23.4099 34.3918 23.4659C34.398 23.5157 34.4104 23.5655 34.4228 23.6152C34.4414 23.665 34.4538 23.7148 34.4724 23.7646C34.4848 23.7957 34.5034 23.8268 34.5158 23.8517L33.0902 23.2979C32.8485 23.2295 32.613 23.1672 32.3713 23.1112C32.2411 23.0801 32.111 23.049 31.9808 23.0179C31.6089 22.9432 31.2308 22.8872 30.8528 22.8499C30.8404 22.8499 30.8342 22.8437 30.8218 22.8437C30.4499 22.8063 30.0842 22.7877 29.7123 22.7877C29.4396 22.7877 29.1669 22.8001 28.9004 22.8188C28.5223 22.8437 28.1442 22.8934 27.7661 22.9557C27.6732 22.9681 27.5802 22.9868 27.4872 23.0054C27.2951 23.0428 27.1091 23.0863 26.9294 23.1299C26.8364 23.1548 26.7435 23.1797 26.6505 23.2046C26.5575 23.2419 26.4707 23.2854 26.384 23.3228C26.3158 23.3539 26.2476 23.385 26.1794 23.4161C26.167 23.4224 26.1546 23.4224 26.1484 23.4286C26.0865 23.4597 26.0307 23.4846 25.9749 23.5157C25.9563 23.5219 25.9439 23.5281 25.9315 23.5343C25.8633 23.5654 25.7952 23.6028 25.7394 23.6339C25.696 23.6526 25.6526 23.6775 25.6154 23.6961C25.5968 23.7086 25.572 23.721 25.5596 23.7272C25.5038 23.7583 25.4481 23.7895 25.3985 23.8206C25.3427 23.8517 25.2931 23.8828 25.2497 23.9139C25.2063 23.945 25.163 23.9699 25.1258 24.001C25.1196 24.0072 25.1134 24.0072 25.1072 24.0135C25.07 24.0384 25.0266 24.0695 24.9894 24.1006C24.9894 24.1006 24.9832 24.1068 24.977 24.113C24.946 24.1379 24.915 24.1628 24.8841 24.1877C24.8717 24.1939 24.8593 24.2063 24.8469 24.2126C24.8159 24.2375 24.7849 24.2686 24.7539 24.2935C24.7477 24.3059 24.7353 24.3121 24.7291 24.3184C24.6919 24.3557 24.6547 24.3868 24.6175 24.4241C24.6113 24.4241 24.6113 24.4304 24.6051 24.4366C24.568 24.4677 24.5308 24.505 24.4936 24.5424C24.4874 24.5486 24.4874 24.5548 24.4812 24.5548C24.4502 24.5859 24.4192 24.617 24.3882 24.6544C24.3758 24.6668 24.3572 24.6793 24.3448 24.6917C24.3138 24.729 24.2767 24.7664 24.2395 24.8037C24.2333 24.8161 24.2209 24.8224 24.2147 24.8348C24.1651 24.8846 24.1217 24.9344 24.0721 24.9841C24.0659 24.9904 24.0597 24.9966 24.0535 25.0028C23.9543 25.1086 23.849 25.2144 23.7374 25.3077C23.6259 25.4073 23.5081 25.5006 23.3903 25.5815C23.2664 25.6686 23.1486 25.7433 23.0184 25.818C22.8945 25.8864 22.7643 25.9486 22.628 26.0046C22.4978 26.0606 22.3615 26.1104 22.2251 26.154C21.9648 26.21 21.6983 26.3157 21.4689 26.3344C21.4193 26.3344 21.3636 26.3469 21.314 26.3531C21.2582 26.3655 21.2086 26.378 21.159 26.3904C21.1094 26.4091 21.0599 26.4278 21.0103 26.4464C20.9607 26.4651 20.9111 26.49 20.8615 26.5149C20.8181 26.546 20.7686 26.5709 20.7252 26.602C20.6818 26.6331 20.6384 26.6704 20.6012 26.7078C20.5578 26.7389 20.5144 26.7824 20.4772 26.8198C20.4401 26.8633 20.4029 26.9007 20.3719 26.9442C20.3409 26.994 20.3037 27.0376 20.2789 27.0873C20.2479 27.1309 20.2169 27.1807 20.1921 27.2304C20.1673 27.2864 20.1426 27.3362 20.124 27.3922C20.1054 27.442 20.0868 27.498 20.0682 27.554C20.0558 27.6038 20.0434 27.6536 20.0372 27.7033C20.0372 27.7096 20.031 27.7158 20.031 27.722C20.0186 27.778 20.0186 27.8527 20.0124 27.89C20.0062 27.9336 20 27.9709 20 28.0145C20 28.0394 20 28.0705 20.0062 28.0954C20.0124 28.1389 20.0186 28.1763 20.031 28.2136C20.0434 28.2509 20.0558 28.2883 20.0744 28.3256V28.3318C20.093 28.3692 20.1178 28.4065 20.1426 28.4438C20.1674 28.4812 20.1922 28.5185 20.2231 28.5558C20.2541 28.587 20.2913 28.6243 20.3285 28.6554C20.3657 28.6927 20.4029 28.7238 20.4463 28.755C20.595 28.8856 20.6322 28.9292 20.8244 29.0287C20.8553 29.0474 20.8863 29.0599 20.9235 29.0785C20.9297 29.0785 20.9359 29.0848 20.9421 29.0848C20.9421 29.0972 20.9421 29.1034 20.9483 29.1159C20.9545 29.1656 20.9669 29.2154 20.9793 29.2652C20.9917 29.3212 21.0103 29.371 21.0289 29.4145C21.0475 29.4519 21.0599 29.4892 21.0785 29.5265C21.0847 29.539 21.0909 29.5514 21.0971 29.5577C21.1219 29.6074 21.1467 29.651 21.1715 29.6946C21.2025 29.7381 21.2334 29.7817 21.2644 29.8252C21.2954 29.8626 21.3326 29.9061 21.3698 29.9435C21.407 29.9808 21.4442 30.0119 21.4876 30.0492C21.4876 30.0492 21.4938 30.0555 21.4999 30.0555C21.5371 30.0866 21.5743 30.1177 21.6115 30.1426C21.6549 30.1737 21.6983 30.1986 21.7479 30.2235C21.7913 30.2484 21.8408 30.2733 21.8904 30.2919C21.9276 30.3106 21.971 30.323 22.0144 30.3355C22.0206 30.3417 22.0268 30.3417 22.0392 30.3479C22.064 30.3542 22.095 30.3604 22.1198 30.3666C22.1012 30.7026 22.095 31.0199 22.1446 31.1319C22.2003 31.2564 22.4731 30.8768 22.7458 30.4413C22.7086 30.8706 22.6838 31.3746 22.7458 31.524C22.8139 31.6795 23.1858 31.1942 23.5081 30.659C27.9025 29.6386 31.9127 32.6876 32.3341 36.9935C32.2536 36.3215 31.4292 35.9481 31.0511 36.0414C30.8652 36.5019 30.5491 37.093 30.0409 37.4602C30.0842 37.0495 30.0657 36.6264 29.9789 36.2157C29.8425 36.7881 29.576 37.3233 29.2103 37.7837C28.6215 37.8273 28.0327 37.5411 27.7228 37.1117C27.698 37.093 27.6918 37.0557 27.6732 37.0308C27.6546 36.9873 27.636 36.9437 27.6236 36.9001C27.605 36.8566 27.5926 36.813 27.5864 36.7695C27.5802 36.7259 27.5802 36.6824 27.5802 36.6326C27.5802 36.6015 27.5802 36.5704 27.5802 36.5392C27.5864 36.4957 27.5988 36.4521 27.6112 36.4086C27.6236 36.365 27.636 36.3215 27.6546 36.2779C27.6794 36.2343 27.698 36.1908 27.729 36.1472C27.8343 35.8486 27.8343 35.6059 27.6422 35.4628C27.605 35.4379 27.5678 35.4192 27.5244 35.4005C27.4996 35.3943 27.4687 35.3819 27.4439 35.3756C27.4253 35.3694 27.4129 35.3632 27.3943 35.357C27.3509 35.3445 27.3075 35.3321 27.2641 35.3259C27.2207 35.3134 27.1774 35.3072 27.134 35.3072C27.0906 35.301 27.041 35.2948 26.9976 35.2948C26.9666 35.2948 26.9356 35.301 26.9046 35.301C26.8551 35.301 26.8117 35.3072 26.7683 35.3197C26.7249 35.3259 26.6815 35.3321 26.6381 35.3445C26.5947 35.357 26.5514 35.3694 26.508 35.3881C26.4646 35.4068 26.4274 35.4254 26.384 35.4441C26.3468 35.4628 26.3096 35.4877 26.2662 35.5063C24.8221 36.4521 25.6836 38.6673 26.6691 39.3082C26.2972 39.3767 25.9192 39.4576 25.8138 39.5385C25.8076 39.5447 25.8014 39.5509 25.8014 39.5509C26.0679 39.7127 26.3468 39.8496 26.6381 39.9678C27.0348 40.0985 27.4563 40.2167 27.6422 40.2665V40.2727C28.1567 40.3785 28.6773 40.4158 29.2041 40.3847C31.9499 40.1918 34.1997 38.0949 34.6088 35.3321C34.6212 35.3881 34.6336 35.4379 34.646 35.4939C34.6646 35.6059 34.6894 35.7241 34.7018 35.8423V35.8486C34.7142 35.9046 34.7204 35.9606 34.7266 36.0104V36.0353C34.7328 36.0913 34.739 36.1473 34.739 36.197C34.7452 36.2655 34.7514 36.3339 34.7514 36.4024V36.5019C34.7514 36.5331 34.7576 36.5704 34.7576 36.6015C34.7576 36.6388 34.7514 36.6762 34.7514 36.7135V36.8006C34.7514 36.8442 34.7451 36.8815 34.7451 36.9251C34.7451 36.95 34.7451 36.9749 34.7389 37.006C34.7389 37.0495 34.7327 37.0931 34.7327 37.1429C34.7265 37.1615 34.7265 37.1802 34.7265 37.1989C34.7203 37.2486 34.7141 37.2922 34.7079 37.342C34.7079 37.3606 34.7079 37.3793 34.7017 37.398C34.6955 37.4602 34.6831 37.5162 34.6769 37.5784V37.5847V37.5909C34.6645 37.6469 34.6521 37.7091 34.6397 37.7651V37.7838C34.6273 37.8398 34.6149 37.8958 34.6025 37.9518C34.6025 37.958 34.5963 37.9705 34.5963 37.9767C34.5839 38.0327 34.5715 38.0887 34.5529 38.1447V38.1634C34.5344 38.2256 34.5158 38.2816 34.5034 38.3376C34.4972 38.3438 34.4972 38.35 34.4972 38.35C34.4786 38.4123 34.46 38.4745 34.4414 38.5367C34.4166 38.5989 34.398 38.6549 34.3732 38.7172C34.3484 38.7794 34.3298 38.8416 34.305 38.8976C34.2802 38.9598 34.2554 39.0158 34.2306 39.0781H34.2244C34.1996 39.1341 34.1748 39.1963 34.1438 39.2523C34.1376 39.271 34.1315 39.2834 34.1253 39.2958C34.119 39.3021 34.119 39.3083 34.1129 39.3145C33.71 40.1297 33.115 40.8452 32.3712 41.4053C32.3216 41.4364 32.2721 41.4737 32.2225 41.511C32.2101 41.5235 32.1915 41.5297 32.1791 41.5421C32.1357 41.5733 32.0923 41.6044 32.0427 41.6355L32.0613 41.6728H32.0675C32.1543 41.6604 32.2411 41.6479 32.3278 41.6355H32.334C32.4952 41.6106 32.6563 41.5795 32.8175 41.5484C32.8609 41.5421 32.9105 41.5297 32.9539 41.5173C32.9848 41.511 33.0096 41.5048 33.0406 41.4986C33.084 41.4923 33.1274 41.4799 33.1708 41.4737C33.208 41.4613 33.2452 41.455 33.2824 41.4426C33.9022 41.2932 34.5034 41.0879 35.0798 40.8452C34.0943 42.1955 32.7741 43.2844 31.2308 44C31.9436 43.9502 32.6563 43.832 33.3443 43.6329C35.8421 42.8924 37.9433 41.2061 39.2015 38.9349C38.9474 40.3723 38.3771 41.7413 37.5342 42.936C38.1354 42.5377 38.687 42.0773 39.1891 41.5546C40.5774 40.0985 41.4886 38.2505 41.7985 36.2655C42.0092 37.2487 42.0712 38.2629 41.9782 39.2647C46.4532 32.9987 42.3501 26.5025 40.6332 24.7913C40.627 24.7789 40.6208 24.7727 40.6208 24.7602C40.6146 24.7665 40.6146 24.7665 40.6146 24.7727C40.6146 24.7664 40.6146 24.7664 40.6084 24.7602C40.6084 24.8349 40.6022 24.9096 40.596 24.9842C40.5774 25.1273 40.5588 25.2642 40.534 25.4011C40.5031 25.538 40.4659 25.6749 40.4287 25.8118C40.3853 25.9425 40.3357 26.0794 40.2799 26.21C40.2241 26.3345 40.1622 26.4652 40.094 26.5896C40.0258 26.7078 39.9514 26.8323 39.8709 26.9443C39.7903 27.0625 39.7035 27.1745 39.6167 27.2803C39.5238 27.3923 39.4246 27.4919 39.3254 27.5914C39.2634 27.6474 39.2077 27.6972 39.1457 27.747C39.0961 27.7905 39.0527 27.8279 39.0031 27.8714C38.8916 27.9586 38.78 28.0394 38.656 28.1141C38.5383 28.1888 38.4143 28.2635 38.2904 28.3257C38.1602 28.3879 38.03 28.4439 37.8999 28.4999C37.7697 28.5497 37.6334 28.5932 37.497 28.6306C37.3606 28.6679 37.2181 28.699 37.0817 28.7239C36.9392 28.7488 36.7966 28.7612 36.6603 28.7737C36.5611 28.7799 36.4619 28.7861 36.3628 28.7861C36.2202 28.7861 36.0777 28.7737 35.9413 28.7612C35.7987 28.7488 35.6562 28.7301 35.5198 28.699C35.3773 28.6741 35.2409 28.6368 35.1046 28.5932H35.0984C35.2347 28.5808 35.3711 28.5683 35.5074 28.5434C35.65 28.5185 35.7863 28.4874 35.9227 28.4501C36.0591 28.4128 36.1954 28.3692 36.3256 28.3194C36.4619 28.2697 36.5921 28.2074 36.716 28.1452C36.8462 28.083 36.964 28.0145 37.0879 27.9399C37.2057 27.859 37.3235 27.7781 37.435 27.691C37.5466 27.6039 37.6519 27.5105 37.7511 27.411C37.8565 27.3176 37.9495 27.2118 38.0424 27.1061C38.1354 26.9941 38.2222 26.8821 38.3027 26.77C38.3151 26.7514 38.3275 26.7265 38.3399 26.7078C38.4019 26.6083 38.4639 26.5087 38.5197 26.4091C38.5879 26.2847 38.6498 26.1602 38.7056 26.0296C38.7614 25.8989 38.811 25.7682 38.8544 25.6313C38.8978 25.5007 38.9287 25.3638 38.9597 25.2269C38.9845 25.0838 39.0093 24.9469 39.0217 24.81C39.0341 24.6669 39.0465 24.5237 39.0465 24.3869C39.0465 24.2873 39.0403 24.1877 39.0341 24.0882C39.0217 23.9451 39.0031 23.8082 38.9845 23.6713C38.9597 23.5282 38.9288 23.3913 38.8916 23.2544C38.8482 23.1237 38.8048 22.9868 38.7552 22.8561C38.7056 22.7255 38.6437 22.5948 38.5817 22.4703C38.5135 22.3459 38.4453 22.2214 38.3709 22.1032C38.2904 21.985 38.2098 21.873 38.123 21.761C38.0301 21.6552 37.9371 21.5494 37.8379 21.4436C37.7883 21.3939 37.7325 21.3379 37.6768 21.2881C37.3979 21.0703 37.1065 20.865 36.8152 20.6783C36.7719 20.6534 36.7347 20.6347 36.6913 20.6161C36.4867 20.4854 36.2946 20.4169 36.1025 20.3547Z"
      fill="#E0234E"
    />
    <defs>
      <filter
        id="filter0_f_1305_2754"
        x={12}
        y={12}
        width={40}
        height={40}
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity={0} result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feGaussianBlur
          stdDeviation={4}
          result="effect1_foregroundBlur_1305_2754"
        />
      </filter>
    </defs>
  </svg>
);
