import clsx from "clsx";
import React from "react";

export const LandingHeroMobileAnimation = (
  props: React.SVGProps<SVGSVGElement>,
) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={296}
    height={174}
    fill="none"
    viewBox="0 0 296 174"
    style={{
      transform: "translate3d(0,0,1px)",
    }}
    {...props}
    className={clsx(
      "landing-hero-mobile-svg",
      "animation-parent",
      props.className,
    )}
  >
    <g className="base">
      <path
        className="base1"
        d="M84.5439 126.943C71.9583 119.627 64.5 110.194 64.5 100C64.5 89.8055 71.9582 80.3725 84.5439 73.057C85.6598 73.5274 87.0763 73.8015 88.603 73.8015C90.3207 73.8015 91.9004 73.4545 93.0693 72.87C94.2082 72.3006 95.103 71.4214 95.103 70.3015C95.103 69.5295 94.6767 68.8716 94.0418 68.3522C108.593 62.2106 127.422 58.5 148 58.5C168.578 58.5 187.407 62.2106 201.958 68.3522C201.323 68.8716 200.897 69.5295 200.897 70.3015C200.897 71.4214 201.792 72.3006 202.931 72.87C204.1 73.4545 205.679 73.8015 207.397 73.8015C208.924 73.8015 210.34 73.5274 211.456 73.057C224.042 80.3725 231.5 89.8055 231.5 100C231.5 110.194 224.042 119.627 211.456 126.943C210.34 126.473 208.924 126.198 207.397 126.198C205.679 126.198 204.1 126.546 202.931 127.13C201.792 127.699 200.897 128.579 200.897 129.698C200.897 130.471 201.323 131.128 201.958 131.648C187.407 137.789 168.578 141.5 148 141.5C127.422 141.5 108.593 137.789 94.0418 131.648C94.6767 131.128 95.103 130.471 95.103 129.698C95.103 128.579 94.2082 127.699 93.0693 127.13C91.9004 126.546 90.3207 126.198 88.603 126.198C87.0763 126.198 85.6598 126.473 84.5439 126.943Z"
        stroke="url(#base1)"
        strokeOpacity="0.1"
      />
      <ellipse cx="148" cy="100" rx="68" ry="34" fill="#0A0A29" />
      <path
        className="base2"
        d="M79.5 46C79.5 50.1437 76.8374 54.0588 72.1387 57.3039C71.0574 56.8846 69.7201 56.6421 68.2842 56.6421C66.5665 56.6421 64.9868 56.9891 63.8179 57.5736C62.679 58.143 61.7842 59.0222 61.7842 60.1421C61.7842 60.8449 62.1386 61.4535 62.6791 61.9477C56.2617 64.1839 48.4436 65.5 40 65.5C29.0151 65.5 19.0949 63.2727 11.9393 59.6949C4.75391 56.1022 0.5 51.2314 0.5 46C0.5 40.7686 4.75391 35.8978 11.9393 32.3051C19.0949 28.7273 29.0151 26.5 40 26.5C50.9849 26.5 60.9051 28.7273 68.0607 32.3051C75.2461 35.8978 79.5 40.7686 79.5 46Z"
        stroke="url(#base2)"
        strokeOpacity="0.1"
      />
      <ellipse cx="40" cy="46" rx="32" ry="16" fill="#0A0A29" />
      <path
        className="base3"
        d="M295.5 46C295.5 51.2314 291.246 56.1022 284.061 59.6949C276.905 63.2727 266.985 65.5 256 65.5C247.556 65.5 239.738 64.1839 233.321 61.9477C233.861 61.4535 234.216 60.8449 234.216 60.1421C234.216 59.0223 233.321 58.143 232.182 57.5736C231.013 56.9891 229.433 56.6421 227.716 56.6421C226.28 56.6421 224.943 56.8846 223.861 57.3039C219.163 54.0588 216.5 50.1437 216.5 46C216.5 40.7686 220.754 35.8978 227.939 32.3051C235.095 28.7273 245.015 26.5 256 26.5C266.985 26.5 276.905 28.7273 284.061 32.3051C291.246 35.8978 295.5 40.7686 295.5 46Z"
        stroke="url(#base3)"
        strokeOpacity="0.1"
      />
      <ellipse cx="256" cy="46" rx="32" ry="16" fill="#0A0A29" />
      <path
        className="base4"
        d="M40 134.5C48.4436 134.5 56.2617 135.816 62.6791 138.052C62.1386 138.546 61.7842 139.155 61.7842 139.858C61.7842 140.978 62.679 141.857 63.8179 142.426C64.9868 143.011 66.5665 143.358 68.2842 143.358C69.7201 143.358 71.0574 143.115 72.1387 142.696C76.8374 145.941 79.5 149.856 79.5 154C79.5 159.231 75.2461 164.102 68.0607 167.695C60.9051 171.273 50.9849 173.5 40 173.5C29.0151 173.5 19.0949 171.273 11.9393 167.695C4.75391 164.102 0.5 159.231 0.5 154C0.5 148.769 4.75391 143.898 11.9393 140.305C19.0949 136.727 29.0151 134.5 40 134.5Z"
        stroke="url(#base4)"
        strokeOpacity="0.1"
      />
      <ellipse
        cx="32"
        cy="16"
        rx="32"
        ry="16"
        transform="matrix(1 0 0 -1 8 170)"
        fill="#0A0A29"
      />
      <path
        className="base5"
        d="M256 134.5C266.985 134.5 276.905 136.727 284.061 140.305C291.246 143.898 295.5 148.769 295.5 154C295.5 159.231 291.246 164.102 284.061 167.695C276.905 171.273 266.985 173.5 256 173.5C245.015 173.5 235.095 171.273 227.939 167.695C220.754 164.102 216.5 159.231 216.5 154C216.5 149.856 219.163 145.941 223.861 142.696C224.943 143.115 226.28 143.358 227.716 143.358C229.433 143.358 231.013 143.011 232.182 142.426C233.321 141.857 234.216 140.978 234.216 139.858C234.216 139.155 233.861 138.546 233.321 138.052C239.738 135.816 247.556 134.5 256 134.5Z"
        stroke="url(#base5)"
        strokeOpacity="0.1"
      />
      <ellipse
        cx="32"
        cy="16"
        rx="32"
        ry="16"
        transform="matrix(1 0 0 -1 224 170)"
        fill="#0A0A29"
      />
      <path
        opacity="0.5"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M68.8761 62.1203C68.683 62.1347 68.4853 62.1421 68.2842 62.1421C66.075 62.1421 64.2842 61.2467 64.2842 60.1421C64.2842 59.0375 66.075 58.1421 68.2842 58.1421C70.4933 58.1421 72.2842 59.0375 72.2842 60.1421C72.2842 60.2483 72.2676 60.3525 72.2357 60.4543L87.8702 68.3352C88.1078 68.3133 88.3527 68.3018 88.603 68.3018C90.8122 68.3018 92.603 69.1972 92.603 70.3018C92.603 71.4063 90.8122 72.3018 88.603 72.3018C86.3939 72.3018 84.603 71.4063 84.603 70.3018C84.603 70.2207 84.6127 70.1408 84.6314 70.0622L68.8761 62.1203ZM207.397 72.3018C209.606 72.3018 211.397 71.4063 211.397 70.3018C211.397 70.2207 211.387 70.1408 211.369 70.0622L227.124 62.1203C227.317 62.1347 227.515 62.1421 227.716 62.1421C229.925 62.1421 231.716 61.2467 231.716 60.1421C231.716 59.0375 229.925 58.1421 227.716 58.1421C225.507 58.1421 223.716 59.0375 223.716 60.1421C223.716 60.2483 223.732 60.3525 223.764 60.4543L208.13 68.3352C207.892 68.3133 207.647 68.3018 207.397 68.3018C205.188 68.3018 203.397 69.1972 203.397 70.3018C203.397 71.4063 205.188 72.3018 207.397 72.3018ZM211.397 129.698C211.397 128.594 209.606 127.698 207.397 127.698C205.188 127.698 203.397 128.594 203.397 129.698C203.397 130.803 205.188 131.698 207.397 131.698C207.647 131.698 207.892 131.687 208.13 131.665L223.764 139.546C223.732 139.647 223.716 139.752 223.716 139.858C223.716 140.962 225.507 141.858 227.716 141.858C229.925 141.858 231.716 140.962 231.716 139.858C231.716 138.753 229.925 137.858 227.716 137.858C227.515 137.858 227.317 137.865 227.124 137.88L211.369 129.938C211.387 129.859 211.397 129.779 211.397 129.698ZM88.603 127.698C90.8122 127.698 92.603 128.594 92.603 129.698C92.603 130.803 90.8122 131.698 88.603 131.698C88.3527 131.698 88.1078 131.687 87.8702 131.665L72.2357 139.546C72.2676 139.647 72.2842 139.752 72.2842 139.858C72.2842 140.962 70.4933 141.858 68.2842 141.858C66.075 141.858 64.2842 140.962 64.2842 139.858C64.2842 138.753 66.075 137.858 68.2842 137.858C68.4853 137.858 68.683 137.865 68.8761 137.88L84.6314 129.938C84.6127 129.859 84.603 129.779 84.603 129.698C84.603 128.594 86.3939 127.698 88.603 127.698Z"
        fill="#0A0A29"
      />
      <path
        d="M148 60.5C163.403 60.5 177.323 63.6227 187.374 68.6482C197.455 73.6886 203.5 80.5594 203.5 88V98C203.5 105.441 197.455 112.311 187.374 117.352C177.323 122.377 163.403 125.5 148 125.5C132.597 125.5 118.677 122.377 108.626 117.352C98.5448 112.311 92.5 105.441 92.5 98V88C92.5 80.5594 98.5448 73.6886 108.626 68.6482C118.677 63.6227 132.597 60.5 148 60.5Z"
        fill="url(#paint5_linear_767_12374)"
        stroke="url(#base6)"
      />
      <g filter="url(#filter0_d_767_12374)">
        <ellipse
          cx="148"
          cy="88"
          rx="56"
          ry="28"
          fill="url(#paint7_radial_767_12374)"
        />
      </g>
      <ellipse cx="148" cy="88" rx="22" ry="11" fill="#0A0A29" />
      <g filter="url(#filter0_d_767_12374)">
        <ellipse
          cx="148"
          cy="88"
          rx="56"
          ry="28"
          fill="url(#paint7_radial_767_12374)"
        />
      </g>
      <ellipse cx="148" cy="88" rx="22" ry="11" fill="#0A0A29" />
      <path
        d="M256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39V44C283.5 47.5746 280.589 50.9454 275.575 53.4523C270.591 55.9443 263.671 57.5 256 57.5C248.329 57.5 241.409 55.9443 236.425 53.4523C231.411 50.9454 228.5 47.5746 228.5 44V39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5Z"
        fill="url(#paint8_linear_767_12374)"
        stroke="url(#paint9_linear_767_12374)"
      />
      <g filter="url(#filter1_d_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint10_radial_767_12374)"
        />
      </g>
      <ellipse cx="256" cy="39" rx="11" ry="5.5" fill="#0A0A29" />
      <path
        d="M256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147V152C283.5 155.575 280.589 158.945 275.575 161.452C270.591 163.944 263.671 165.5 256 165.5C248.329 165.5 241.409 163.944 236.425 161.452C231.411 158.945 228.5 155.575 228.5 152V147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5Z"
        fill="url(#paint11_linear_767_12374)"
        stroke="url(#paint12_linear_767_12374)"
      />
      <g filter="url(#filter2_d_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint13_radial_767_12374)"
        />
      </g>
      <ellipse cx="256" cy="147" rx="11" ry="5.5" fill="#0A0A29" />
      <path
        d="M40 25.5C47.6712 25.5 54.5915 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39V44C67.5 47.5746 64.5892 50.9454 59.5754 53.4523C54.5915 55.9443 47.6712 57.5 40 57.5C32.3288 57.5 25.4085 55.9443 20.4246 53.4523C15.4108 50.9454 12.5 47.5746 12.5 44V39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4085 27.0557 32.3288 25.5 40 25.5Z"
        fill="url(#paint14_linear_767_12374)"
        stroke="url(#paint15_linear_767_12374)"
      />
      <g filter="url(#filter3_d_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint16_radial_767_12374)"
        />
      </g>
      <ellipse cx="40" cy="39" rx="11" ry="5.5" fill="#0A0A29" />
      <path
        d="M40 133.5C47.6712 133.5 54.5915 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147V152C67.5 155.575 64.5892 158.945 59.5754 161.452C54.5915 163.944 47.6712 165.5 40 165.5C32.3288 165.5 25.4085 163.944 20.4246 161.452C15.4108 158.945 12.5 155.575 12.5 152V147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4085 135.056 32.3288 133.5 40 133.5Z"
        fill="url(#paint17_linear_767_12374)"
        stroke="url(#paint18_linear_767_12374)"
      />
      <g filter="url(#filter4_d_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint19_radial_767_12374)"
        />
      </g>
      <ellipse cx="40" cy="147" rx="11" ry="5.5" fill="#0A0A29" />
    </g>
    <g className="platform nextjs" opacity="0">
      <g filter="url(#filter5_d_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint20_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint21_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint22_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter6_i_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint23_radial_767_12374)"
        />
      </g>
      <path
        d="M40 46.5C43.9268 46.5 47.5065 45.7052 50.1231 44.397C52.7098 43.1036 54.5 41.2244 54.5 39C54.5 36.7756 52.7098 34.8964 50.1231 33.603C47.5065 32.2948 43.9268 31.5 40 31.5C36.0732 31.5 32.4935 32.2948 29.8769 33.603C27.2902 34.8964 25.5 36.7756 25.5 39C25.5 41.2244 27.2902 43.1036 29.8769 44.397C32.4935 45.7052 36.0732 46.5 40 46.5Z"
        stroke="url(#paint24_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint25_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint26_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint27_linear_767_12374)"
      />
      <mask
        id="mask0_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="0"
        width="24"
        height="24"
      >
        <path d="M28 0H52V0.5H28V0Z" fill="white" />
        <path d="M28 1H52V1.5H28V1Z" fill="white" />
        <path d="M28 2H52V2.5H28V2Z" fill="white" />
        <path d="M28 3H52V3.5H28V3Z" fill="white" />
        <path d="M28 4H52V4.5H28V4Z" fill="white" />
        <path d="M28 5H52V5.5H28V5Z" fill="white" />
        <path d="M28 6H52V6.5H28V6Z" fill="white" />
        <path d="M28 7H52V7.5H28V7Z" fill="white" />
        <path d="M28 8H52V8.5H28V8Z" fill="white" />
        <path d="M28 9H52V9.5H28V9Z" fill="white" />
        <path d="M28 10H52V10.5H28V10Z" fill="white" />
        <path d="M28 11H52V11.5H28V11Z" fill="white" />
        <path d="M28 12H52V12.5H28V12Z" fill="white" />
        <path d="M28 13H52V13.5H28V13Z" fill="white" />
        <path d="M28 14H52V14.5H28V14Z" fill="white" />
        <path d="M28 15H52V15.5H28V15Z" fill="white" />
        <path d="M28 16H52V16.5H28V16Z" fill="white" />
        <path d="M28 17H52V17.5H28V17Z" fill="white" />
        <path d="M28 18H52V18.5H28V18Z" fill="white" />
        <path d="M28 19H52V19.5H28V19Z" fill="white" />
        <path d="M28 20H52V20.5H28V20Z" fill="white" />
        <path d="M28 21H52V21.5H28V21Z" fill="white" />
        <path d="M28 22H52V22.5H28V22Z" fill="white" />
        <path d="M28 23H52V23.5H28V23Z" fill="white" />
        <path d="M28 0.5H52V1H28V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 1.5H52V2H28V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 2.5H52V3H28V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 3.5H52V4H28V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 4.5H52V5H28V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 5.5H52V6H28V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 6.5H52V7H28V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 7.5H52V8H28V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 8.5H52V9H28V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 9.5H52V10H28V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 10.5H52V11H28V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 11.5H52V12H28V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 12.5H52V13H28V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 13.5H52V14H28V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 14.5H52V15H28V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 15.5H52V16H28V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 16.5H52V17H28V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 17.5H52V18H28V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 18.5H52V19H28V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 19.5H52V20H28V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 20.5H52V21H28V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 21.5H52V22H28V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 22.5H52V23H28V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 23.5H52V24H28V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask0_767_12374)">
        <path
          d="M39.2141 0.00645753C39.1625 0.0111525 38.9983 0.0275701 38.8505 0.0393001C35.4416 0.346583 32.2487 2.18561 30.2264 5.01218C29.1003 6.5838 28.3801 8.36655 28.1079 10.2548C28.0117 10.9139 28 11.1086 28 12.0023C28 12.896 28.0117 13.0907 28.1079 13.7499C28.7601 18.256 31.9672 22.0419 36.3167 23.4446C37.0956 23.6956 37.9167 23.8669 38.8505 23.9701C39.2141 24.01 40.7859 24.01 41.1496 23.9701C42.7614 23.7918 44.1267 23.393 45.4734 22.7057C45.6798 22.6002 45.7196 22.5721 45.6915 22.5486L36.9924 10.222C36.983 10.2197 36.9737 11.8007 36.969 13.7312C36.9619 17.1113 36.9596 17.2473 36.9174 17.3271C36.8563 17.442 36.8094 17.4889 36.7109 17.5405C36.6358 17.578 36.5701 17.5851 36.2159 17.5851H35.81L35.702 17.5171C35.6317 17.4725 35.5801 17.4139 35.5449 17.3458L35.4956 17.2403L35.5003 12.5371L35.5073 7.83172L35.5801 7.74023C35.6176 7.69095 35.6974 7.62765 35.7537 7.59713C35.8499 7.55025 35.8875 7.54553 36.2933 7.54553C36.7719 7.54553 36.8517 7.56428 36.976 7.70033C36.976 7.70033 43.3848 17.511 46.6018 22.0466C47.4534 21.4931 48.3543 20.7049 49.0675 19.8839C50.5854 18.141 51.5636 16.0158 51.8921 13.7499C51.9883 13.0907 52 12.896 52 12.0023C52 11.1086 51.9883 10.9139 51.8921 10.2548C51.2399 5.74873 48.0329 1.96277 43.6833 0.560048C42.9162 0.3114 42.0998 0.140167 41.1848 0.0369525C40.9596 0.0135 39.4088 -0.0123075 39.2141 0.00645753ZM44.1267 7.26405C44.2393 7.32038 44.3308 7.42823 44.3636 7.5408L44.3754 16.0627L42.8856 13.7828L42.9091 7.56667C42.9467 7.43527 43.0288 7.33208 43.1414 7.2711C43.2376 7.22183 43.2728 7.2171 43.6411 7.2171C43.9883 7.2171 44.0493 7.22183 44.1267 7.26405Z"
          fill="white"
        />
      </g>
      <g filter="url(#filter7_d_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint28_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint29_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint30_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
    </g>
    <g className="backend supabase" opacity="0">
      <g filter="url(#filter7_d_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint28_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint29_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint30_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter8_i_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint31_radial_767_12374)"
        />
      </g>
      <path
        d="M40 154.5C43.9268 154.5 47.5065 153.705 50.1231 152.397C52.7098 151.104 54.5 149.224 54.5 147C54.5 144.776 52.7098 142.896 50.1231 141.603C47.5065 140.295 43.9268 139.5 40 139.5C36.0732 139.5 32.4935 140.295 29.8769 141.603C27.2902 142.896 25.5 144.776 25.5 147C25.5 149.224 27.2902 151.104 29.8769 152.397C32.4935 153.705 36.0732 154.5 40 154.5Z"
        stroke="url(#paint32_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint33_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint34_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint35_linear_767_12374)"
      />
      <mask
        id="mask1_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="108"
        width="24"
        height="24"
      >
        <path d="M28 108H52V108.5H28V108Z" fill="white" />
        <path d="M28 109H52V109.5H28V109Z" fill="white" />
        <path d="M28 110H52V110.5H28V110Z" fill="white" />
        <path d="M28 111H52V111.5H28V111Z" fill="white" />
        <path d="M28 112H52V112.5H28V112Z" fill="white" />
        <path d="M28 113H52V113.5H28V113Z" fill="white" />
        <path d="M28 114H52V114.5H28V114Z" fill="white" />
        <path d="M28 115H52V115.5H28V115Z" fill="white" />
        <path d="M28 116H52V116.5H28V116Z" fill="white" />
        <path d="M28 117H52V117.5H28V117Z" fill="white" />
        <path d="M28 118H52V118.5H28V118Z" fill="white" />
        <path d="M28 119H52V119.5H28V119Z" fill="white" />
        <path d="M28 120H52V120.5H28V120Z" fill="white" />
        <path d="M28 121H52V121.5H28V121Z" fill="white" />
        <path d="M28 122H52V122.5H28V122Z" fill="white" />
        <path d="M28 123H52V123.5H28V123Z" fill="white" />
        <path d="M28 124H52V124.5H28V124Z" fill="white" />
        <path d="M28 125H52V125.5H28V125Z" fill="white" />
        <path d="M28 126H52V126.5H28V126Z" fill="white" />
        <path d="M28 127H52V127.5H28V127Z" fill="white" />
        <path d="M28 128H52V128.5H28V128Z" fill="white" />
        <path d="M28 129H52V129.5H28V129Z" fill="white" />
        <path d="M28 130H52V130.5H28V130Z" fill="white" />
        <path d="M28 131H52V131.5H28V131Z" fill="white" />
        <path d="M28 108.5H52V109H28V108.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 109.5H52V110H28V109.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 110.5H52V111H28V110.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 111.5H52V112H28V111.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 112.5H52V113H28V112.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 113.5H52V114H28V113.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 114.5H52V115H28V114.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 115.5H52V116H28V115.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 116.5H52V117H28V116.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 117.5H52V118H28V117.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 118.5H52V119H28V118.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 119.5H52V120H28V119.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 120.5H52V121H28V120.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 121.5H52V122H28V121.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 122.5H52V123H28V122.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 123.5H52V124H28V123.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 124.5H52V125H28V124.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 125.5H52V126H28V125.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 126.5H52V127H28V126.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 127.5H52V128H28V127.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 128.5H52V129H28V128.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 129.5H52V130H28V129.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 130.5H52V131H28V130.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 131.5H52V132H28V131.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask1_767_12374)">
        <path
          d="M41.903 131.587C41.2794 132.387 40.015 131.949 40 130.928L40 116H49.8615C51.6476 116 52.6438 118.1 51.5332 119.524L41.903 131.587Z"
          fill="url(#paint36_linear_767_12374)"
        />
        <path
          d="M41.903 131.587C41.2794 132.387 40.015 131.949 40 130.928L40 116H49.8615C51.6476 116 52.6438 118.1 51.5332 119.524L41.903 131.587Z"
          fill="url(#paint37_linear_767_12374)"
          fillOpacity="0.2"
        />
        <path
          d="M38.0772 108.413C38.7073 107.613 39.9848 108.051 40 109.072L40 124H30.1608C28.356 124 27.3495 121.9 28.4717 120.476L38.0772 108.413Z"
          fill="#3ECF8E"
        />
      </g>
    </g>
    <g className="framework mui" opacity="0">
      <g filter="url(#filter9_d_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint38_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint39_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint40_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter10_i_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint41_radial_767_12374)"
        />
      </g>
      <path
        d="M256 46.5C259.927 46.5 263.507 45.7052 266.123 44.397C268.71 43.1036 270.5 41.2244 270.5 39C270.5 36.7756 268.71 34.8964 266.123 33.603C263.507 32.2948 259.927 31.5 256 31.5C252.073 31.5 248.493 32.2948 245.877 33.603C243.29 34.8964 241.5 36.7756 241.5 39C241.5 41.2244 243.29 43.1036 245.877 44.397C248.493 45.7052 252.073 46.5 256 46.5Z"
        stroke="url(#paint42_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint43_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint44_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint45_linear_767_12374)"
      />
      <mask
        id="mask2_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="0"
        width="24"
        height="24"
      >
        <path d="M244 0H268V0.5H244V0Z" fill="white" />
        <path d="M244 1H268V1.5H244V1Z" fill="white" />
        <path d="M244 2H268V2.5H244V2Z" fill="white" />
        <path d="M244 3H268V3.5H244V3Z" fill="white" />
        <path d="M244 4H268V4.5H244V4Z" fill="white" />
        <path d="M244 5H268V5.5H244V5Z" fill="white" />
        <path d="M244 6H268V6.5H244V6Z" fill="white" />
        <path d="M244 7H268V7.5H244V7Z" fill="white" />
        <path d="M244 8H268V8.5H244V8Z" fill="white" />
        <path d="M244 9H268V9.5H244V9Z" fill="white" />
        <path d="M244 10H268V10.5H244V10Z" fill="white" />
        <path d="M244 11H268V11.5H244V11Z" fill="white" />
        <path d="M244 12H268V12.5H244V12Z" fill="white" />
        <path d="M244 13H268V13.5H244V13Z" fill="white" />
        <path d="M244 14H268V14.5H244V14Z" fill="white" />
        <path d="M244 15H268V15.5H244V15Z" fill="white" />
        <path d="M244 16H268V16.5H244V16Z" fill="white" />
        <path d="M244 17H268V17.5H244V17Z" fill="white" />
        <path d="M244 18H268V18.5H244V18Z" fill="white" />
        <path d="M244 19H268V19.5H244V19Z" fill="white" />
        <path d="M244 20H268V20.5H244V20Z" fill="white" />
        <path d="M244 21H268V21.5H244V21Z" fill="white" />
        <path d="M244 22H268V22.5H244V22Z" fill="white" />
        <path d="M244 23H268V23.5H244V23Z" fill="white" />
        <path d="M244 0.5H268V1H244V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 1.5H268V2H244V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 2.5H268V3H244V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 3.5H268V4H244V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 4.5H268V5H244V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 5.5H268V6H244V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 6.5H268V7H244V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 7.5H268V8H244V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 8.5H268V9H244V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 9.5H268V10H244V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 10.5H268V11H244V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 11.5H268V12H244V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 12.5H268V13H244V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 13.5H268V14H244V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 14.5H268V15H244V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 15.5H268V16H244V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 16.5H268V17H244V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 17.5H268V18H244V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 18.5H268V19H244V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 19.5H268V20H244V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 20.5H268V21H244V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 21.5H268V22H244V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 22.5H268V23H244V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 23.5H268V24H244V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask2_767_12374)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M264.667 5.89029C264.667 6.15172 264.78 6.34742 265.005 6.47687C265.23 6.60531 265.454 6.60228 265.676 6.46777L267.676 5.25465C267.892 5.12267 268 4.93102 268 4.67565V2.20188C267.999 1.93893 267.887 1.74475 267.662 1.61529C267.437 1.48584 267.213 1.48989 266.991 1.6244L264.991 2.83752C264.775 2.9695 264.667 3.16115 264.667 3.41601V5.89029ZM264.229 15.8349C264.451 15.7055 264.563 15.5113 264.564 15.2524L264.576 11.3486C264.576 11.0886 264.688 10.894 264.91 10.7645L267.002 9.54886C267.105 9.48919 267.216 9.45935 267.335 9.45935C267.454 9.45935 267.565 9.4902 267.668 9.54987C267.771 9.61055 267.852 9.69247 267.911 9.79715C267.971 9.90081 268 10.0131 268 10.1339V17.2316C268 17.492 267.889 17.6872 267.666 17.8167L259.773 22.4037C259.552 22.5321 259.331 22.5321 259.11 22.4037L252.916 18.8199C252.692 18.6905 252.58 18.4948 252.58 18.2334V14.6547C252.58 14.6506 252.585 14.6481 252.589 14.6506C252.592 14.6521 252.597 14.6506 252.597 14.6456V14.6415C252.597 14.639 252.598 14.6365 252.601 14.635L257.702 11.6687C257.706 11.6661 257.704 11.6585 257.699 11.6585C257.696 11.6585 257.694 11.657 257.694 11.6535L257.704 8.14459C257.705 7.88417 257.594 7.68898 257.372 7.55801C257.15 7.42856 256.927 7.42704 256.704 7.55801L252.913 9.76832C252.691 9.89777 252.469 9.89777 252.247 9.76832L248.444 7.55295C248.341 7.49227 248.23 7.46244 248.111 7.46244C247.992 7.46244 247.881 7.49328 247.778 7.55295C247.675 7.61363 247.594 7.69555 247.534 7.80023C247.475 7.90389 247.445 8.01615 247.445 8.13701V14.4787C247.445 14.5991 247.415 14.7103 247.356 14.8155C247.297 14.9202 247.216 15.0021 247.113 15.0628C247.01 15.1224 246.9 15.1533 246.781 15.1533C246.662 15.1533 246.551 15.125 246.448 15.0653L244.336 13.8451C244.112 13.7141 244 13.5189 244 13.2575L244.019 2.17356C244.019 2.05321 244.049 1.94196 244.108 1.83678C244.168 1.73312 244.249 1.6517 244.352 1.59052C244.455 1.53085 244.566 1.5 244.685 1.5C244.804 1.5 244.914 1.52983 245.017 1.5895L252.248 5.79218C252.469 5.92012 252.69 5.92012 252.912 5.79218L260.14 1.5895C260.244 1.52983 260.355 1.5 260.474 1.5C260.592 1.5 260.703 1.53085 260.806 1.59203C260.909 1.6517 260.99 1.73463 261.05 1.83779C261.109 1.94247 261.139 2.05523 261.139 2.17558V13.2625C261.139 13.523 261.027 13.7172 260.805 13.8476L257.019 16.0539C256.796 16.1833 256.685 16.379 256.686 16.639C256.686 16.8994 256.798 17.0946 257.022 17.223L259.11 18.426C259.331 18.5545 259.552 18.5529 259.772 18.426L264.229 15.8354V15.8349Z"
          fill="#007FFF"
        />
      </g>
    </g>
    <g className="auth google" opacity="0">
      <g filter="url(#filter11_d_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint46_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint47_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint48_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter12_i_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint49_radial_767_12374)"
        />
      </g>
      <path
        d="M256 154.5C259.927 154.5 263.507 153.705 266.123 152.397C268.71 151.104 270.5 149.224 270.5 147C270.5 144.776 268.71 142.896 266.123 141.603C263.507 140.295 259.927 139.5 256 139.5C252.073 139.5 248.493 140.295 245.877 141.603C243.29 142.896 241.5 144.776 241.5 147C241.5 149.224 243.29 151.104 245.877 152.397C248.493 153.705 252.073 154.5 256 154.5Z"
        stroke="url(#paint50_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint51_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint52_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint53_linear_767_12374)"
      />
      <mask
        id="mask3_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="108"
        width="24"
        height="24"
      >
        <path d="M244 108H268V108.5H244V108Z" fill="white" />
        <path d="M244 109H268V109.5H244V109Z" fill="white" />
        <path d="M244 110H268V110.5H244V110Z" fill="white" />
        <path d="M244 111H268V111.5H244V111Z" fill="white" />
        <path d="M244 112H268V112.5H244V112Z" fill="white" />
        <path d="M244 113H268V113.5H244V113Z" fill="white" />
        <path d="M244 114H268V114.5H244V114Z" fill="white" />
        <path d="M244 115H268V115.5H244V115Z" fill="white" />
        <path d="M244 116H268V116.5H244V116Z" fill="white" />
        <path d="M244 117H268V117.5H244V117Z" fill="white" />
        <path d="M244 118H268V118.5H244V118Z" fill="white" />
        <path d="M244 119H268V119.5H244V119Z" fill="white" />
        <path d="M244 120H268V120.5H244V120Z" fill="white" />
        <path d="M244 121H268V121.5H244V121Z" fill="white" />
        <path d="M244 122H268V122.5H244V122Z" fill="white" />
        <path d="M244 123H268V123.5H244V123Z" fill="white" />
        <path d="M244 124H268V124.5H244V124Z" fill="white" />
        <path d="M244 125H268V125.5H244V125Z" fill="white" />
        <path d="M244 126H268V126.5H244V126Z" fill="white" />
        <path d="M244 127H268V127.5H244V127Z" fill="white" />
        <path d="M244 128H268V128.5H244V128Z" fill="white" />
        <path d="M244 129H268V129.5H244V129Z" fill="white" />
        <path d="M244 130H268V130.5H244V130Z" fill="white" />
        <path d="M244 131H268V131.5H244V131Z" fill="white" />
        <path
          d="M244 108.5H268V109H244V108.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 109.5H268V110H244V109.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 110.5H268V111H244V110.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 111.5H268V112H244V111.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 112.5H268V113H244V112.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 113.5H268V114H244V113.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 114.5H268V115H244V114.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 115.5H268V116H244V115.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 116.5H268V117H244V116.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 117.5H268V118H244V117.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 118.5H268V119H244V118.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 119.5H268V120H244V119.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 120.5H268V121H244V120.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 121.5H268V122H244V121.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 122.5H268V123H244V122.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 123.5H268V124H244V123.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 124.5H268V125H244V124.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 125.5H268V126H244V125.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 126.5H268V127H244V126.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 127.5H268V128H244V127.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 128.5H268V129H244V128.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 129.5H268V130H244V129.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 130.5H268V131H244V130.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 131.5H268V132H244V131.5Z"
          fill="white"
          fillOpacity="0.5"
        />
      </mask>
      <g mask="url(#mask3_767_12374)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M254.596 108.082C256.48 107.861 258.417 108.087 260.195 108.753C261.8 109.353 263.279 110.298 264.484 111.517C263.931 112.065 263.381 112.616 262.831 113.166C262.355 113.643 261.88 114.119 261.402 114.594C260.738 113.943 259.965 113.401 259.114 113.025C257.983 112.518 256.726 112.295 255.49 112.38C254.093 112.47 252.725 112.955 251.586 113.769C250.173 114.765 249.115 116.255 248.65 117.92C248.301 119.142 248.272 120.451 248.554 121.69C248.78 122.703 249.221 123.666 249.834 124.503C250.403 125.282 251.12 125.952 251.937 126.465C252.878 127.059 253.951 127.442 255.056 127.577C256.003 127.696 256.971 127.634 257.896 127.398C257.974 127.36 258.026 127.42 258.075 127.476C258.09 127.492 258.104 127.509 258.119 127.522C258.66 128.066 259.202 128.608 259.745 129.15L259.757 129.163C260.255 129.661 260.753 130.159 261.25 130.658C261.276 130.685 261.302 130.712 261.328 130.74L261.329 130.756C260.247 131.294 259.081 131.664 257.888 131.853C256.432 132.081 254.935 132.045 253.493 131.738C251.757 131.371 250.107 130.608 248.7 129.526C247.076 128.282 245.777 126.618 244.97 124.737C244.755 124.229 244.563 123.709 244.428 123.173C244.216 122.44 244.097 121.682 244.033 120.922C243.966 119.967 243.999 119.003 244.155 118.057C244.467 116.127 245.265 114.279 246.453 112.727C247.224 111.717 248.155 110.829 249.202 110.11C250.798 109.007 252.668 108.302 254.596 108.082ZM255.853 109.373C255.708 109.398 255.573 109.469 255.46 109.563C255.194 109.791 255.098 110.197 255.251 110.516C255.413 110.9 255.895 111.107 256.283 110.951C256.678 110.817 256.917 110.349 256.788 109.952C256.683 109.557 256.253 109.292 255.853 109.373ZM249.001 112.236C248.864 112.244 248.73 112.286 248.613 112.356C248.319 112.536 248.156 112.912 248.246 113.248C248.325 113.608 248.675 113.888 249.045 113.877C249.429 113.887 249.789 113.586 249.852 113.208C249.909 112.943 249.81 112.657 249.618 112.47C249.458 112.308 249.227 112.224 249.001 112.236ZM246.035 119.192C245.866 119.223 245.707 119.309 245.586 119.432C245.345 119.681 245.287 120.086 245.458 120.389C245.641 120.746 246.11 120.923 246.48 120.763C246.865 120.622 247.094 120.164 246.968 119.773C246.865 119.379 246.434 119.109 246.035 119.192ZM248.899 126.149C248.605 126.199 248.349 126.423 248.263 126.708C248.164 127.006 248.26 127.352 248.491 127.561C248.648 127.702 248.859 127.784 249.071 127.774C249.356 127.768 249.633 127.599 249.764 127.345C249.89 127.119 249.896 126.833 249.783 126.6C249.634 126.274 249.25 126.081 248.899 126.149ZM255.857 129.014C255.556 129.065 255.296 129.297 255.215 129.592C255.116 129.913 255.244 130.288 255.519 130.481C255.72 130.629 255.991 130.677 256.23 130.606C256.475 130.535 256.682 130.344 256.769 130.102C256.896 129.776 256.778 129.378 256.498 129.17C256.318 129.031 256.08 128.974 255.857 129.014Z"
          fill="#A0A0A0"
        />
        <path
          d="M263.39 126.265C263.223 126.151 263.009 126.118 262.812 126.151C262.489 126.204 262.214 126.473 262.155 126.795C262.117 127.003 262.151 127.23 262.276 127.405C262.423 127.64 262.705 127.782 262.982 127.769C263.195 127.77 263.398 127.668 263.549 127.522C263.673 127.379 263.765 127.198 263.77 127.006C263.792 126.715 263.641 126.415 263.39 126.265Z"
          fill="#A0A0A0"
        />
        <path
          d="M264.484 111.517L264.487 111.514C265.117 112.156 265.688 112.859 266.165 113.623C267.086 115.085 267.683 116.748 267.901 118.462C268.046 119.61 268.035 120.779 267.848 121.921C267.523 123.967 266.648 125.921 265.344 127.531C264.263 128.873 262.893 129.987 261.344 130.747L261.328 130.74C261.302 130.712 261.276 130.685 261.25 130.658C260.208 129.611 259.161 128.569 258.119 127.522C258.055 127.464 257.997 127.349 257.896 127.398C256.971 127.634 256.002 127.696 255.056 127.577C253.951 127.442 252.878 127.059 251.937 126.465C251.12 125.952 250.403 125.282 249.834 124.503C249.221 123.666 248.78 122.702 248.554 121.69C248.272 120.451 248.301 119.142 248.65 117.92C249.115 116.255 250.173 114.765 251.586 113.769C252.725 112.955 254.093 112.47 255.489 112.38C256.725 112.295 257.983 112.518 259.114 113.024C259.965 113.401 260.738 113.943 261.402 114.594C262.432 113.57 263.453 112.539 264.484 111.517ZM262.812 126.151C262.489 126.204 262.214 126.473 262.155 126.795C262.117 127.003 262.151 127.23 262.276 127.405C262.423 127.64 262.705 127.782 262.982 127.769C263.195 127.77 263.398 127.668 263.548 127.522C263.673 127.379 263.765 127.198 263.77 127.006C263.792 126.715 263.641 126.415 263.39 126.265C263.223 126.151 263.009 126.118 262.812 126.151Z"
          fill="#686868"
        />
        <path
          d="M255.488 116.221C255.733 116.181 255.983 116.196 256.231 116.195C257.196 116.241 258.129 116.689 258.789 117.392C259.186 117.825 259.494 118.342 259.659 118.907C262.75 120 263.5 120 266.872 120.295C266.889 120.321 266.895 120.35 266.889 120.381C266.79 120.859 266.334 121.229 265.847 121.236C265.089 121.235 264.331 121.236 263.573 121.235C263.531 121.227 263.532 121.275 263.526 121.301C263.253 122.877 262.472 124.363 261.318 125.471C260.388 126.378 259.222 127.04 257.967 127.374C256.499 125.907 255.034 124.438 253.568 122.97C253.313 122.721 253.064 122.462 252.861 122.168C252.566 121.742 252.359 121.256 252.259 120.748C252.102 119.931 252.205 119.061 252.578 118.314C252.889 117.692 253.367 117.152 253.957 116.782C254.417 116.484 254.945 116.294 255.488 116.221Z"
          fill="#474747"
        />
        <path
          d="M255.853 109.373C256.253 109.292 256.683 109.557 256.788 109.952C256.917 110.35 256.678 110.817 256.283 110.951C255.895 111.107 255.413 110.9 255.251 110.516C255.098 110.197 255.194 109.791 255.46 109.563C255.573 109.469 255.708 109.398 255.853 109.373Z"
          fill="#BEBEBE"
        />
        <path
          d="M246.035 119.192C246.434 119.11 246.865 119.379 246.968 119.773C247.094 120.164 246.865 120.622 246.48 120.763C246.11 120.923 245.641 120.746 245.458 120.389C245.287 120.086 245.345 119.681 245.586 119.433C245.707 119.309 245.866 119.224 246.035 119.192Z"
          fill="#BEBEBE"
        />
        <path
          d="M249 112.237C249.227 112.224 249.458 112.308 249.618 112.47C249.81 112.657 249.909 112.944 249.852 113.208C249.789 113.586 249.429 113.888 249.045 113.877C248.675 113.889 248.324 113.608 248.245 113.248C248.155 112.912 248.319 112.536 248.613 112.356C248.73 112.286 248.864 112.244 249 112.237Z"
          fill="#BEBEBE"
        />
        <path
          d="M248.899 126.149C249.25 126.081 249.634 126.274 249.783 126.601C249.896 126.833 249.89 127.119 249.764 127.345C249.633 127.599 249.356 127.768 249.071 127.774C248.859 127.784 248.648 127.702 248.491 127.562C248.26 127.352 248.164 127.006 248.263 126.709C248.349 126.423 248.605 126.199 248.899 126.149Z"
          fill="#BEBEBE"
        />
        <path
          d="M255.856 129.014C256.08 128.974 256.318 129.031 256.498 129.17C256.778 129.378 256.896 129.777 256.768 130.102C256.682 130.344 256.475 130.535 256.23 130.606C255.99 130.678 255.72 130.629 255.519 130.481C255.244 130.289 255.116 129.913 255.215 129.592C255.296 129.297 255.556 129.066 255.856 129.014Z"
          fill="#BEBEBE"
        />
        <path
          d="M255.177 119.281C255.381 119.046 255.689 118.904 256.001 118.907C257.22 118.907 258.44 118.907 259.659 118.907C260.648 118.908 261.637 118.908 262.626 118.908H262.629C263.701 118.908 264.774 118.908 265.846 118.909C266.26 118.908 266.907 119.25 266.907 119.849C266.925 119.999 266.903 120.149 266.872 120.295C266.775 120.659 266.473 120.957 266.109 121.055C265.991 121.089 265.868 121.093 265.746 121.092C262.506 121.09 259.266 121.091 256.026 121.092C255.779 121.097 255.532 121.018 255.337 120.867C255.047 120.647 254.88 120.276 254.91 119.913C254.928 119.681 255.024 119.456 255.177 119.281Z"
          fill="#BEBEBE"
        />
      </g>
    </g>
    <g className="platform vite" opacity="0">
      <g filter="url(#filter13_d_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint54_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint55_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint56_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter14_i_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint57_radial_767_12374)"
        />
      </g>
      <path
        d="M40 46.5C43.9268 46.5 47.5065 45.7052 50.1231 44.397C52.7098 43.1036 54.5 41.2244 54.5 39C54.5 36.7756 52.7098 34.8964 50.1231 33.603C47.5065 32.2948 43.9268 31.5 40 31.5C36.0732 31.5 32.4935 32.2948 29.8769 33.603C27.2902 34.8964 25.5 36.7756 25.5 39C25.5 41.2244 27.2902 43.1036 29.8769 44.397C32.4935 45.7052 36.0732 46.5 40 46.5Z"
        stroke="url(#paint58_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint59_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint60_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint61_linear_767_12374)"
      />
      <mask
        id="mask4_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="0"
        width="24"
        height="24"
      >
        <path d="M28 0H52V0.5H28V0Z" fill="white" />
        <path d="M28 1H52V1.5H28V1Z" fill="white" />
        <path d="M28 2H52V2.5H28V2Z" fill="white" />
        <path d="M28 3H52V3.5H28V3Z" fill="white" />
        <path d="M28 4H52V4.5H28V4Z" fill="white" />
        <path d="M28 5H52V5.5H28V5Z" fill="white" />
        <path d="M28 6H52V6.5H28V6Z" fill="white" />
        <path d="M28 7H52V7.5H28V7Z" fill="white" />
        <path d="M28 8H52V8.5H28V8Z" fill="white" />
        <path d="M28 9H52V9.5H28V9Z" fill="white" />
        <path d="M28 10H52V10.5H28V10Z" fill="white" />
        <path d="M28 11H52V11.5H28V11Z" fill="white" />
        <path d="M28 12H52V12.5H28V12Z" fill="white" />
        <path d="M28 13H52V13.5H28V13Z" fill="white" />
        <path d="M28 14H52V14.5H28V14Z" fill="white" />
        <path d="M28 15H52V15.5H28V15Z" fill="white" />
        <path d="M28 16H52V16.5H28V16Z" fill="white" />
        <path d="M28 17H52V17.5H28V17Z" fill="white" />
        <path d="M28 18H52V18.5H28V18Z" fill="white" />
        <path d="M28 19H52V19.5H28V19Z" fill="white" />
        <path d="M28 20H52V20.5H28V20Z" fill="white" />
        <path d="M28 21H52V21.5H28V21Z" fill="white" />
        <path d="M28 22H52V22.5H28V22Z" fill="white" />
        <path d="M28 23H52V23.5H28V23Z" fill="white" />
        <path d="M28 0.5H52V1H28V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 1.5H52V2H28V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 2.5H52V3H28V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 3.5H52V4H28V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 4.5H52V5H28V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 5.5H52V6H28V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 6.5H52V7H28V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 7.5H52V8H28V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 8.5H52V9H28V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 9.5H52V10H28V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 10.5H52V11H28V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 11.5H52V12H28V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 12.5H52V13H28V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 13.5H52V14H28V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 14.5H52V15H28V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 15.5H52V16H28V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 16.5H52V17H28V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 17.5H52V18H28V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 18.5H52V19H28V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 19.5H52V20H28V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 20.5H52V21H28V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 21.5H52V22H28V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 22.5H52V23H28V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 23.5H52V24H28V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask4_767_12374)">
        <path
          d="M51.9206 3.55238L40.6466 23.6869C40.4138 24.1026 39.8158 24.1051 39.5795 23.6914L28.082 3.55432C27.8246 3.10351 28.2106 2.55746 28.7221 2.64877L40.0081 4.66356C40.0801 4.67641 40.1538 4.67629 40.2258 4.66318L51.2759 2.65166C51.7857 2.55886 52.1735 3.10069 51.9206 3.55238Z"
          fill="url(#paint62_linear_767_12374)"
        />
        <path
          d="M45.3843 0.00590856L37.0412 1.63865C36.9041 1.66549 36.8026 1.78155 36.7943 1.92084L36.2811 10.5778C36.269 10.7817 36.4565 10.9399 36.6558 10.894L38.9786 10.3586C39.1959 10.3086 39.3923 10.4997 39.3476 10.718L38.6575 14.0931C38.6111 14.3203 38.8246 14.5145 39.0467 14.4471L40.4814 14.0118C40.7038 13.9444 40.9176 14.1392 40.8705 14.3665L39.7738 19.668C39.7052 19.9997 40.1468 20.1805 40.331 19.8962L40.454 19.7063L47.2524 6.1559C47.3663 5.92902 47.17 5.67032 46.9205 5.7184L44.5295 6.17928C44.3048 6.22254 44.1136 6.01356 44.1771 5.79401L45.7376 0.39098C45.8011 0.171059 45.6092 -0.0381044 45.3843 0.00590856Z"
          fill="url(#paint63_linear_767_12374)"
        />
      </g>
    </g>
    <g className="backend nest" opacity="0">
      <g filter="url(#filter15_d_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint64_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint65_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint66_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter16_i_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint67_radial_767_12374)"
        />
      </g>
      <path
        d="M40 154.5C43.9268 154.5 47.5065 153.705 50.1231 152.397C52.7098 151.104 54.5 149.224 54.5 147C54.5 144.776 52.7098 142.896 50.1231 141.603C47.5065 140.295 43.9268 139.5 40 139.5C36.0732 139.5 32.4935 140.295 29.8769 141.603C27.2902 142.896 25.5 144.776 25.5 147C25.5 149.224 27.2902 151.104 29.8769 152.397C32.4935 153.705 36.0732 154.5 40 154.5Z"
        stroke="url(#paint68_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint69_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint70_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint71_linear_767_12374)"
      />
      <mask
        id="mask5_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="108"
        width="24"
        height="24"
      >
        <path d="M28 108H52V108.5H28V108Z" fill="white" />
        <path d="M28 109H52V109.5H28V109Z" fill="white" />
        <path d="M28 110H52V110.5H28V110Z" fill="white" />
        <path d="M28 111H52V111.5H28V111Z" fill="white" />
        <path d="M28 112H52V112.5H28V112Z" fill="white" />
        <path d="M28 113H52V113.5H28V113Z" fill="white" />
        <path d="M28 114H52V114.5H28V114Z" fill="white" />
        <path d="M28 115H52V115.5H28V115Z" fill="white" />
        <path d="M28 116H52V116.5H28V116Z" fill="white" />
        <path d="M28 117H52V117.5H28V117Z" fill="white" />
        <path d="M28 118H52V118.5H28V118Z" fill="white" />
        <path d="M28 119H52V119.5H28V119Z" fill="white" />
        <path d="M28 120H52V120.5H28V120Z" fill="white" />
        <path d="M28 121H52V121.5H28V121Z" fill="white" />
        <path d="M28 122H52V122.5H28V122Z" fill="white" />
        <path d="M28 123H52V123.5H28V123Z" fill="white" />
        <path d="M28 124H52V124.5H28V124Z" fill="white" />
        <path d="M28 125H52V125.5H28V125Z" fill="white" />
        <path d="M28 126H52V126.5H28V126Z" fill="white" />
        <path d="M28 127H52V127.5H28V127Z" fill="white" />
        <path d="M28 128H52V128.5H28V128Z" fill="white" />
        <path d="M28 129H52V129.5H28V129Z" fill="white" />
        <path d="M28 130H52V130.5H28V130Z" fill="white" />
        <path d="M28 131H52V131.5H28V131Z" fill="white" />
        <path d="M28 108.5H52V109H28V108.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 109.5H52V110H28V109.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 110.5H52V111H28V110.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 111.5H52V112H28V111.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 112.5H52V113H28V112.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 113.5H52V114H28V113.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 114.5H52V115H28V114.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 115.5H52V116H28V115.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 116.5H52V117H28V116.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 117.5H52V118H28V117.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 118.5H52V119H28V118.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 119.5H52V120H28V119.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 120.5H52V121H28V120.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 121.5H52V122H28V121.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 122.5H52V123H28V122.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 123.5H52V124H28V123.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 124.5H52V125H28V124.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 125.5H52V126H28V125.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 126.5H52V127H28V126.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 127.5H52V128H28V127.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 128.5H52V129H28V128.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 129.5H52V130H28V129.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 130.5H52V131H28V130.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 131.5H52V132H28V131.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask5_767_12374)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M42.1315 108C41.9579 108 41.7968 108.037 41.648 108.087C41.9641 108.299 42.1377 108.579 42.2244 108.896C42.2307 108.94 42.243 108.971 42.2492 109.014C42.2555 109.052 42.2616 109.089 42.2616 109.126C42.2864 109.674 42.1191 109.742 42.0013 110.066C41.8216 110.483 41.8712 110.931 42.0881 111.292C42.1067 111.335 42.1315 111.385 42.1625 111.429C41.9269 109.854 43.2347 109.618 43.4764 109.126C43.495 108.697 43.1418 108.411 42.8628 108.212C42.5963 108.05 42.3546 108 42.1315 108ZM44.1025 108.355C44.0776 108.498 44.0962 108.46 44.0901 108.535C44.0839 108.585 44.0839 108.647 44.0777 108.697C44.0653 108.747 44.0529 108.796 44.0343 108.846C44.0219 108.896 44.0033 108.946 43.9847 108.996C43.9599 109.045 43.9413 109.089 43.9165 109.139C43.8979 109.164 43.8855 109.188 43.8669 109.213C43.8546 109.232 43.8421 109.251 43.8298 109.269C43.7988 109.313 43.7678 109.356 43.7368 109.394C43.6996 109.431 43.6686 109.475 43.6252 109.506V109.512C43.588 109.543 43.5508 109.581 43.5075 109.612C43.3773 109.711 43.2285 109.786 43.0922 109.879C43.0488 109.91 43.0054 109.935 42.9682 109.973C42.9248 110.004 42.8877 110.035 42.8505 110.072C42.8071 110.109 42.7761 110.147 42.7389 110.19C42.7079 110.228 42.6707 110.271 42.6459 110.315C42.6149 110.358 42.584 110.402 42.5592 110.445C42.5344 110.495 42.5158 110.539 42.491 110.589C42.4724 110.638 42.4538 110.682 42.4414 110.732C42.4228 110.788 42.4104 110.837 42.398 110.887C42.3918 110.912 42.3918 110.943 42.3856 110.968C42.3794 110.993 42.3794 111.018 42.3732 111.043C42.3732 111.093 42.367 111.149 42.367 111.198C42.367 111.236 42.367 111.273 42.3732 111.31C42.3732 111.36 42.3794 111.41 42.3918 111.466C42.398 111.516 42.4104 111.565 42.4228 111.615C42.4414 111.665 42.4538 111.715 42.4724 111.765C42.4848 111.796 42.5034 111.827 42.5158 111.852L41.0902 111.298C40.8485 111.229 40.613 111.167 40.3713 111.111C40.2411 111.08 40.111 111.049 39.9808 111.018C39.6089 110.943 39.2308 110.887 38.8528 110.85C38.8404 110.85 38.8342 110.844 38.8218 110.844C38.4499 110.806 38.0842 110.788 37.7123 110.788C37.4396 110.788 37.1669 110.8 36.9004 110.819C36.5223 110.844 36.1442 110.893 35.7661 110.956C35.6732 110.968 35.5802 110.987 35.4872 111.005C35.2951 111.043 35.1091 111.086 34.9294 111.13C34.8364 111.155 34.7435 111.18 34.6505 111.205C34.5575 111.242 34.4707 111.285 34.384 111.323C34.3158 111.354 34.2476 111.385 34.1794 111.416C34.167 111.422 34.1546 111.422 34.1484 111.429C34.0865 111.46 34.0307 111.485 33.9749 111.516C33.9563 111.522 33.9439 111.528 33.9315 111.534C33.8633 111.565 33.7952 111.603 33.7394 111.634C33.696 111.653 33.6526 111.677 33.6154 111.696C33.5968 111.709 33.572 111.721 33.5596 111.727C33.5038 111.758 33.4481 111.789 33.3985 111.821C33.3427 111.852 33.2931 111.883 33.2497 111.914C33.2063 111.945 33.163 111.97 33.1258 112.001C33.1196 112.007 33.1134 112.007 33.1072 112.013C33.07 112.038 33.0266 112.069 32.9894 112.101C32.9894 112.101 32.9832 112.107 32.977 112.113C32.946 112.138 32.915 112.163 32.8841 112.188C32.8717 112.194 32.8593 112.206 32.8469 112.213C32.8159 112.237 32.7849 112.269 32.7539 112.293C32.7477 112.306 32.7353 112.312 32.7291 112.318C32.6919 112.356 32.6547 112.387 32.6175 112.424C32.6113 112.424 32.6113 112.43 32.6051 112.437C32.568 112.468 32.5308 112.505 32.4936 112.542C32.4874 112.549 32.4874 112.555 32.4812 112.555C32.4502 112.586 32.4192 112.617 32.3882 112.654C32.3758 112.667 32.3572 112.679 32.3448 112.692C32.3138 112.729 32.2767 112.766 32.2395 112.804C32.2333 112.816 32.2209 112.822 32.2147 112.835C32.1651 112.885 32.1217 112.934 32.0721 112.984C32.0659 112.99 32.0597 112.997 32.0535 113.003C31.9543 113.109 31.849 113.214 31.7374 113.308C31.6259 113.407 31.5081 113.501 31.3903 113.581C31.2664 113.669 31.1486 113.743 31.0184 113.818C30.8945 113.886 30.7643 113.949 30.628 114.005C30.4978 114.061 30.3615 114.11 30.2251 114.154C29.9648 114.21 29.6983 114.316 29.4689 114.334C29.4193 114.334 29.3636 114.347 29.314 114.353C29.2582 114.366 29.2086 114.378 29.159 114.39C29.1094 114.409 29.0599 114.428 29.0103 114.446C28.9607 114.465 28.9111 114.49 28.8615 114.515C28.8181 114.546 28.7686 114.571 28.7252 114.602C28.6818 114.633 28.6384 114.67 28.6012 114.708C28.5578 114.739 28.5144 114.782 28.4772 114.82C28.4401 114.863 28.4029 114.901 28.3719 114.944C28.3409 114.994 28.3037 115.038 28.2789 115.087C28.2479 115.131 28.2169 115.181 28.1921 115.23C28.1673 115.286 28.1426 115.336 28.124 115.392C28.1054 115.442 28.0868 115.498 28.0682 115.554C28.0558 115.604 28.0434 115.654 28.0372 115.703C28.0372 115.71 28.031 115.716 28.031 115.722C28.0186 115.778 28.0186 115.853 28.0124 115.89C28.0062 115.934 28 115.971 28 116.014C28 116.039 28 116.07 28.0062 116.095C28.0124 116.139 28.0186 116.176 28.031 116.214C28.0434 116.251 28.0558 116.288 28.0744 116.326V116.332C28.093 116.369 28.1178 116.406 28.1426 116.444C28.1674 116.481 28.1922 116.519 28.2231 116.556C28.2541 116.587 28.2913 116.624 28.3285 116.655C28.3657 116.693 28.4029 116.724 28.4463 116.755C28.595 116.886 28.6322 116.929 28.8244 117.029C28.8553 117.047 28.8863 117.06 28.9235 117.079C28.9297 117.079 28.9359 117.085 28.9421 117.085C28.9421 117.097 28.9421 117.103 28.9483 117.116C28.9545 117.166 28.9669 117.215 28.9793 117.265C28.9917 117.321 29.0103 117.371 29.0289 117.415C29.0475 117.452 29.0599 117.489 29.0785 117.527C29.0847 117.539 29.0909 117.551 29.0971 117.558C29.1219 117.607 29.1467 117.651 29.1715 117.695C29.2025 117.738 29.2334 117.782 29.2644 117.825C29.2954 117.863 29.3326 117.906 29.3698 117.943C29.407 117.981 29.4442 118.012 29.4876 118.049C29.4876 118.049 29.4938 118.055 29.4999 118.055C29.5371 118.087 29.5743 118.118 29.6115 118.143C29.6549 118.174 29.6983 118.199 29.7479 118.223C29.7913 118.248 29.8408 118.273 29.8904 118.292C29.9276 118.311 29.971 118.323 30.0144 118.335C30.0206 118.342 30.0268 118.342 30.0392 118.348C30.064 118.354 30.095 118.36 30.1198 118.367C30.1012 118.703 30.095 119.02 30.1446 119.132C30.2003 119.256 30.4731 118.877 30.7458 118.441C30.7086 118.871 30.6838 119.375 30.7458 119.524C30.8139 119.68 31.1858 119.194 31.5081 118.659C35.9025 117.639 39.9127 120.688 40.3341 124.993C40.2536 124.321 39.4292 123.948 39.0511 124.041C38.8652 124.502 38.5491 125.093 38.0409 125.46C38.0842 125.049 38.0657 124.626 37.9789 124.216C37.8425 124.788 37.576 125.323 37.2103 125.784C36.6215 125.827 36.0327 125.541 35.7228 125.112C35.698 125.093 35.6918 125.056 35.6732 125.031C35.6546 124.987 35.636 124.944 35.6236 124.9C35.605 124.857 35.5926 124.813 35.5864 124.769C35.5802 124.726 35.5802 124.682 35.5802 124.633C35.5802 124.601 35.5802 124.57 35.5802 124.539C35.5864 124.496 35.5988 124.452 35.6112 124.409C35.6236 124.365 35.636 124.321 35.6546 124.278C35.6794 124.234 35.698 124.191 35.729 124.147C35.8343 123.849 35.8343 123.606 35.6422 123.463C35.605 123.438 35.5678 123.419 35.5244 123.401C35.4996 123.394 35.4687 123.382 35.4439 123.376C35.4253 123.369 35.4129 123.363 35.3943 123.357C35.3509 123.345 35.3075 123.332 35.2641 123.326C35.2207 123.313 35.1774 123.307 35.134 123.307C35.0906 123.301 35.041 123.295 34.9976 123.295C34.9666 123.295 34.9356 123.301 34.9046 123.301C34.8551 123.301 34.8117 123.307 34.7683 123.32C34.7249 123.326 34.6815 123.332 34.6381 123.345C34.5947 123.357 34.5514 123.369 34.508 123.388C34.4646 123.407 34.4274 123.425 34.384 123.444C34.3468 123.463 34.3096 123.488 34.2662 123.506C32.8221 124.452 33.6836 126.667 34.6691 127.308C34.2972 127.377 33.9192 127.458 33.8138 127.538C33.8076 127.545 33.8014 127.551 33.8014 127.551C34.0679 127.713 34.3468 127.85 34.6381 127.968C35.0348 128.098 35.4563 128.217 35.6422 128.266V128.273C36.1567 128.379 36.6773 128.416 37.2041 128.385C39.9499 128.192 42.1997 126.095 42.6088 123.332C42.6212 123.388 42.6336 123.438 42.646 123.494C42.6646 123.606 42.6894 123.724 42.7018 123.842V123.849C42.7142 123.905 42.7204 123.961 42.7266 124.01V124.035C42.7328 124.091 42.739 124.147 42.739 124.197C42.7452 124.265 42.7514 124.334 42.7514 124.402V124.502C42.7514 124.533 42.7576 124.57 42.7576 124.602C42.7576 124.639 42.7514 124.676 42.7514 124.714V124.801C42.7514 124.844 42.7451 124.882 42.7451 124.925C42.7451 124.95 42.7451 124.975 42.7389 125.006C42.7389 125.05 42.7327 125.093 42.7327 125.143C42.7265 125.162 42.7265 125.18 42.7265 125.199C42.7203 125.249 42.7141 125.292 42.7079 125.342C42.7079 125.361 42.7079 125.379 42.7017 125.398C42.6955 125.46 42.6831 125.516 42.6769 125.578V125.585V125.591C42.6645 125.647 42.6521 125.709 42.6397 125.765V125.784C42.6273 125.84 42.6149 125.896 42.6025 125.952C42.6025 125.958 42.5963 125.97 42.5963 125.977C42.5839 126.033 42.5715 126.089 42.5529 126.145V126.163C42.5344 126.226 42.5158 126.282 42.5034 126.338C42.4972 126.344 42.4972 126.35 42.4972 126.35C42.4786 126.412 42.46 126.474 42.4414 126.537C42.4166 126.599 42.398 126.655 42.3732 126.717C42.3484 126.779 42.3298 126.842 42.305 126.898C42.2802 126.96 42.2554 127.016 42.2306 127.078H42.2244C42.1996 127.134 42.1748 127.196 42.1438 127.252C42.1376 127.271 42.1315 127.283 42.1253 127.296C42.119 127.302 42.119 127.308 42.1129 127.315C41.71 128.13 41.115 128.845 40.3712 129.405C40.3216 129.436 40.2721 129.474 40.2225 129.511C40.2101 129.523 40.1915 129.53 40.1791 129.542C40.1357 129.573 40.0923 129.604 40.0427 129.635L40.0613 129.673H40.0675C40.1543 129.66 40.2411 129.648 40.3278 129.635H40.334C40.4952 129.611 40.6563 129.579 40.8175 129.548C40.8609 129.542 40.9105 129.53 40.9539 129.517C40.9848 129.511 41.0096 129.505 41.0406 129.499C41.084 129.492 41.1274 129.48 41.1708 129.474C41.208 129.461 41.2452 129.455 41.2824 129.443C41.9022 129.293 42.5034 129.088 43.0798 128.845C42.0943 130.195 40.7741 131.284 39.2308 132C39.9436 131.95 40.6563 131.832 41.3443 131.633C43.8421 130.892 45.9433 129.206 47.2015 126.935C46.9474 128.372 46.3771 129.741 45.5342 130.936C46.1354 130.538 46.687 130.077 47.1891 129.555C48.5774 128.099 49.4886 126.25 49.7984 124.266C50.0092 125.249 50.0712 126.263 49.9782 127.265C54.4532 120.999 50.3501 114.503 48.6332 112.791C48.627 112.779 48.6208 112.773 48.6208 112.76C48.6146 112.766 48.6146 112.766 48.6146 112.773C48.6146 112.766 48.6146 112.766 48.6084 112.76C48.6084 112.835 48.6022 112.91 48.596 112.984C48.5774 113.127 48.5588 113.264 48.534 113.401C48.5031 113.538 48.4659 113.675 48.4287 113.812C48.3853 113.942 48.3357 114.079 48.2799 114.21C48.2241 114.334 48.1622 114.465 48.094 114.59C48.0258 114.708 47.9514 114.832 47.8709 114.944C47.7903 115.063 47.7035 115.175 47.6167 115.28C47.5238 115.392 47.4246 115.492 47.3254 115.591C47.2634 115.647 47.2077 115.697 47.1457 115.747C47.0961 115.791 47.0527 115.828 47.0031 115.871C46.8916 115.959 46.78 116.039 46.656 116.114C46.5383 116.189 46.4143 116.263 46.2904 116.326C46.1602 116.388 46.03 116.444 45.8999 116.5C45.7697 116.55 45.6334 116.593 45.497 116.631C45.3607 116.668 45.2181 116.699 45.0817 116.724C44.9392 116.749 44.7966 116.761 44.6603 116.774C44.5611 116.78 44.4619 116.786 44.3628 116.786C44.2202 116.786 44.0777 116.774 43.9413 116.761C43.7987 116.749 43.6562 116.73 43.5198 116.699C43.3773 116.674 43.2409 116.637 43.1046 116.593H43.0984C43.2347 116.581 43.3711 116.568 43.5074 116.543C43.65 116.519 43.7863 116.487 43.9227 116.45C44.0591 116.413 44.1954 116.369 44.3256 116.319C44.4619 116.27 44.5921 116.207 44.716 116.145C44.8462 116.083 44.964 116.015 45.0879 115.94C45.2057 115.859 45.3235 115.778 45.435 115.691C45.5466 115.604 45.6519 115.511 45.7511 115.411C45.8565 115.318 45.9495 115.212 46.0424 115.106C46.1354 114.994 46.2222 114.882 46.3027 114.77C46.3151 114.751 46.3275 114.726 46.3399 114.708C46.4019 114.608 46.4639 114.509 46.5197 114.409C46.5879 114.285 46.6498 114.16 46.7056 114.03C46.7614 113.899 46.811 113.768 46.8544 113.631C46.8978 113.501 46.9287 113.364 46.9597 113.227C46.9845 113.084 47.0093 112.947 47.0217 112.81C47.0341 112.667 47.0465 112.524 47.0465 112.387C47.0465 112.287 47.0403 112.188 47.0341 112.088C47.0217 111.945 47.0031 111.808 46.9845 111.671C46.9597 111.528 46.9288 111.391 46.8916 111.254C46.8482 111.124 46.8048 110.987 46.7552 110.856C46.7056 110.725 46.6437 110.595 46.5817 110.47C46.5135 110.346 46.4453 110.221 46.3709 110.103C46.2904 109.985 46.2098 109.873 46.123 109.761C46.0301 109.655 45.9371 109.549 45.8379 109.444C45.7883 109.394 45.7325 109.338 45.6768 109.288C45.3978 109.07 45.1065 108.865 44.8152 108.678C44.7718 108.653 44.7347 108.635 44.6913 108.616C44.4867 108.485 44.2946 108.417 44.1025 108.355Z"
          fill="#E0234E"
        />
      </g>
    </g>
    <g className="framework antd" opacity="0">
      <g filter="url(#filter17_d_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint72_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint73_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint74_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter18_i_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint75_radial_767_12374)"
        />
      </g>
      <path
        d="M256 46.5C259.927 46.5 263.507 45.7052 266.123 44.397C268.71 43.1036 270.5 41.2244 270.5 39C270.5 36.7756 268.71 34.8964 266.123 33.603C263.507 32.2948 259.927 31.5 256 31.5C252.073 31.5 248.493 32.2948 245.877 33.603C243.29 34.8964 241.5 36.7756 241.5 39C241.5 41.2244 243.29 43.1036 245.877 44.397C248.493 45.7052 252.073 46.5 256 46.5Z"
        stroke="url(#paint76_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint77_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint78_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint79_linear_767_12374)"
      />
      <mask
        id="mask6_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="0"
        width="24"
        height="24"
      >
        <path d="M244 0H268V0.5H244V0Z" fill="white" />
        <path d="M244 1H268V1.5H244V1Z" fill="white" />
        <path d="M244 2H268V2.5H244V2Z" fill="white" />
        <path d="M244 3H268V3.5H244V3Z" fill="white" />
        <path d="M244 4H268V4.5H244V4Z" fill="white" />
        <path d="M244 5H268V5.5H244V5Z" fill="white" />
        <path d="M244 6H268V6.5H244V6Z" fill="white" />
        <path d="M244 7H268V7.5H244V7Z" fill="white" />
        <path d="M244 8H268V8.5H244V8Z" fill="white" />
        <path d="M244 9H268V9.5H244V9Z" fill="white" />
        <path d="M244 10H268V10.5H244V10Z" fill="white" />
        <path d="M244 11H268V11.5H244V11Z" fill="white" />
        <path d="M244 12H268V12.5H244V12Z" fill="white" />
        <path d="M244 13H268V13.5H244V13Z" fill="white" />
        <path d="M244 14H268V14.5H244V14Z" fill="white" />
        <path d="M244 15H268V15.5H244V15Z" fill="white" />
        <path d="M244 16H268V16.5H244V16Z" fill="white" />
        <path d="M244 17H268V17.5H244V17Z" fill="white" />
        <path d="M244 18H268V18.5H244V18Z" fill="white" />
        <path d="M244 19H268V19.5H244V19Z" fill="white" />
        <path d="M244 20H268V20.5H244V20Z" fill="white" />
        <path d="M244 21H268V21.5H244V21Z" fill="white" />
        <path d="M244 22H268V22.5H244V22Z" fill="white" />
        <path d="M244 23H268V23.5H244V23Z" fill="white" />
        <path d="M244 0.5H268V1H244V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 1.5H268V2H244V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 2.5H268V3H244V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 3.5H268V4H244V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 4.5H268V5H244V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 5.5H268V6H244V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 6.5H268V7H244V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 7.5H268V8H244V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 8.5H268V9H244V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 9.5H268V10H244V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 10.5H268V11H244V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 11.5H268V12H244V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 12.5H268V13H244V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 13.5H268V14H244V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 14.5H268V15H244V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 15.5H268V16H244V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 16.5H268V17H244V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 17.5H268V18H244V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 18.5H268V19H244V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 19.5H268V20H244V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 20.5H268V21H244V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 21.5H268V22H244V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 22.5H268V23H244V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 23.5H268V24H244V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask6_767_12374)">
        <path
          d="M254.976 0.42724L244.425 10.9759C243.858 11.543 243.858 12.4589 244.425 13.0261L254.976 23.5747C255.544 24.1418 256.46 24.1418 257.027 23.5747L261.451 19.1518C261.959 18.6439 261.959 17.8204 261.451 17.3126C260.943 16.8047 260.119 16.8047 259.611 17.3126L256.257 20.6655C256.116 20.8067 255.902 20.8067 255.761 20.6655L247.335 12.2417C247.194 12.1005 247.194 11.8863 247.335 11.7452L255.761 3.32133C255.902 3.18018 256.116 3.18018 256.257 3.32133L259.611 6.67428C260.119 7.18217 260.943 7.18217 261.451 6.67428C261.959 6.16639 261.959 5.34294 261.451 4.83505L257.027 0.412651C256.458 -0.142187 255.541 -0.137695 254.976 0.42724Z"
          fill="url(#paint80_linear_767_12374)"
        />
        <path
          d="M254.976 0.42724L244.425 10.9759C243.858 11.543 243.858 12.4589 244.425 13.0261L254.976 23.5747C255.544 24.1418 256.46 24.1418 257.027 23.5747L261.451 19.1518C261.959 18.6439 261.959 17.8204 261.451 17.3126C260.943 16.8047 260.119 16.8047 259.611 17.3126L256.257 20.6655C256.116 20.8067 255.902 20.8067 255.761 20.6655L247.335 12.2417C247.194 12.1005 247.194 11.8863 247.335 11.7452L255.761 3.32133C256.112 3.01808 256.686 2.40387 257.528 2.26021C258.154 2.15345 258.839 2.38843 259.581 2.96515C259.085 2.46868 258.233 1.61784 257.027 0.412651C256.458 -0.142187 255.541 -0.137695 254.976 0.42724Z"
          fill="url(#paint81_linear_767_12374)"
        />
        <path
          d="M262.472 16.3316C262.98 16.8395 263.803 16.8395 264.311 16.3316L267.575 13.069C268.142 12.5019 268.142 11.586 267.575 11.0189L264.283 7.73961C263.774 7.23232 262.95 7.23305 262.442 7.74124C261.934 8.24913 261.934 9.07258 262.442 9.58047L264.665 11.8032C264.806 11.9444 264.806 12.1586 264.665 12.2997L262.472 14.4924C261.964 15.0002 261.964 15.8237 262.472 16.3316Z"
          fill="url(#paint82_linear_767_12374)"
        />
        <path
          d="M256.054 14.9018C257.627 14.9018 258.903 13.6267 258.903 12.0537C258.903 10.4807 257.627 9.20557 256.054 9.20557C254.481 9.20557 253.205 10.4807 253.205 12.0537C253.205 13.6267 254.481 14.9018 256.054 14.9018Z"
          fill="url(#paint83_linear_767_12374)"
        />
      </g>
    </g>
    <g className="auth auth0" opacity="0">
      <g filter="url(#filter19_d_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint84_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint85_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint86_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter20_i_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint87_radial_767_12374)"
        />
      </g>
      <path
        d="M256 154.5C259.927 154.5 263.507 153.705 266.123 152.397C268.71 151.104 270.5 149.224 270.5 147C270.5 144.776 268.71 142.896 266.123 141.603C263.507 140.295 259.927 139.5 256 139.5C252.073 139.5 248.493 140.295 245.877 141.603C243.29 142.896 241.5 144.776 241.5 147C241.5 149.224 243.29 151.104 245.877 152.397C248.493 153.705 252.073 154.5 256 154.5Z"
        stroke="url(#paint88_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint89_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint90_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint91_linear_767_12374)"
      />
      <mask
        id="mask7_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="108"
        width="24"
        height="24"
      >
        <path d="M244 108H268V108.5H244V108Z" fill="white" />
        <path d="M244 109H268V109.5H244V109Z" fill="white" />
        <path d="M244 110H268V110.5H244V110Z" fill="white" />
        <path d="M244 111H268V111.5H244V111Z" fill="white" />
        <path d="M244 112H268V112.5H244V112Z" fill="white" />
        <path d="M244 113H268V113.5H244V113Z" fill="white" />
        <path d="M244 114H268V114.5H244V114Z" fill="white" />
        <path d="M244 115H268V115.5H244V115Z" fill="white" />
        <path d="M244 116H268V116.5H244V116Z" fill="white" />
        <path d="M244 117H268V117.5H244V117Z" fill="white" />
        <path d="M244 118H268V118.5H244V118Z" fill="white" />
        <path d="M244 119H268V119.5H244V119Z" fill="white" />
        <path d="M244 120H268V120.5H244V120Z" fill="white" />
        <path d="M244 121H268V121.5H244V121Z" fill="white" />
        <path d="M244 122H268V122.5H244V122Z" fill="white" />
        <path d="M244 123H268V123.5H244V123Z" fill="white" />
        <path d="M244 124H268V124.5H244V124Z" fill="white" />
        <path d="M244 125H268V125.5H244V125Z" fill="white" />
        <path d="M244 126H268V126.5H244V126Z" fill="white" />
        <path d="M244 127H268V127.5H244V127Z" fill="white" />
        <path d="M244 128H268V128.5H244V128Z" fill="white" />
        <path d="M244 129H268V129.5H244V129Z" fill="white" />
        <path d="M244 130H268V130.5H244V130Z" fill="white" />
        <path d="M244 131H268V131.5H244V131Z" fill="white" />
        <path
          d="M244 108.5H268V109H244V108.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 109.5H268V110H244V109.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 110.5H268V111H244V110.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 111.5H268V112H244V111.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 112.5H268V113H244V112.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 113.5H268V114H244V113.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 114.5H268V115H244V114.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 115.5H268V116H244V115.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 116.5H268V117H244V116.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 117.5H268V118H244V117.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 118.5H268V119H244V118.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 119.5H268V120H244V119.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 120.5H268V121H244V120.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 121.5H268V122H244V121.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 122.5H268V123H244V122.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 123.5H268V124H244V123.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 124.5H268V125H244V124.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 125.5H268V126H244V125.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 126.5H268V127H244V126.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 127.5H268V128H244V127.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 128.5H268V129H244V128.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 129.5H268V130H244V129.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 130.5H268V131H244V130.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 131.5H268V132H244V131.5Z"
          fill="white"
          fillOpacity="0.5"
        />
      </mask>
      <g mask="url(#mask7_767_12374)">
        <path
          d="M262.174 127.415L259.816 120L265.986 115.418H258.356L255.999 108H263.629L265.989 115.418C267.356 119.718 265.946 124.612 262.163 127.414L262.174 127.415ZM249.831 127.415L256.001 132L262.174 127.415L256.005 122.833L249.831 127.415ZM246.017 115.415C244.574 119.952 246.249 124.758 249.829 127.417V127.415L252.187 120L246.017 115.415L253.646 115.418L255.999 108H248.364L246.017 115.415Z"
          fill="#EB5424"
        />
      </g>
    </g>
    <g className="platform remix" opacity="0">
      <g filter="url(#filter21_d_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint92_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint93_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 39C67.5 42.5746 64.5892 45.9454 59.5754 48.4523C54.5914 50.9443 47.6712 52.5 40 52.5C32.3288 52.5 25.4086 50.9443 20.4246 48.4523C15.4108 45.9454 12.5 42.5746 12.5 39C12.5 35.4254 15.4108 32.0546 20.4246 29.5477C25.4086 27.0557 32.3288 25.5 40 25.5C47.6712 25.5 54.5914 27.0557 59.5754 29.5477C64.5892 32.0546 67.5 35.4254 67.5 39Z"
          stroke="url(#paint94_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter22_i_767_12374)">
        <ellipse
          cx="40"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint95_radial_767_12374)"
        />
      </g>
      <path
        d="M40 46.5C43.9268 46.5 47.5065 45.7052 50.1231 44.397C52.7098 43.1036 54.5 41.2244 54.5 39C54.5 36.7756 52.7098 34.8964 50.1231 33.603C47.5065 32.2948 43.9268 31.5 40 31.5C36.0732 31.5 32.4935 32.2948 29.8769 33.603C27.2902 34.8964 25.5 36.7756 25.5 39C25.5 41.2244 27.2902 43.1036 29.8769 44.397C32.4935 45.7052 36.0732 46.5 40 46.5Z"
        stroke="url(#paint96_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint97_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint98_radial_767_12374)"
      />
      <path
        d="M21 2H59L51 39C51 39 51 44.5 40 44.5C29 44.5 29 39 29 39L21 2Z"
        fill="url(#paint99_linear_767_12374)"
      />
      <mask
        id="mask8_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="0"
        width="24"
        height="24"
      >
        <path d="M28 0H52V0.5H28V0Z" fill="white" />
        <path d="M28 1H52V1.5H28V1Z" fill="white" />
        <path d="M28 2H52V2.5H28V2Z" fill="white" />
        <path d="M28 3H52V3.5H28V3Z" fill="white" />
        <path d="M28 4H52V4.5H28V4Z" fill="white" />
        <path d="M28 5H52V5.5H28V5Z" fill="white" />
        <path d="M28 6H52V6.5H28V6Z" fill="white" />
        <path d="M28 7H52V7.5H28V7Z" fill="white" />
        <path d="M28 8H52V8.5H28V8Z" fill="white" />
        <path d="M28 9H52V9.5H28V9Z" fill="white" />
        <path d="M28 10H52V10.5H28V10Z" fill="white" />
        <path d="M28 11H52V11.5H28V11Z" fill="white" />
        <path d="M28 12H52V12.5H28V12Z" fill="white" />
        <path d="M28 13H52V13.5H28V13Z" fill="white" />
        <path d="M28 14H52V14.5H28V14Z" fill="white" />
        <path d="M28 15H52V15.5H28V15Z" fill="white" />
        <path d="M28 16H52V16.5H28V16Z" fill="white" />
        <path d="M28 17H52V17.5H28V17Z" fill="white" />
        <path d="M28 18H52V18.5H28V18Z" fill="white" />
        <path d="M28 19H52V19.5H28V19Z" fill="white" />
        <path d="M28 20H52V20.5H28V20Z" fill="white" />
        <path d="M28 21H52V21.5H28V21Z" fill="white" />
        <path d="M28 22H52V22.5H28V22Z" fill="white" />
        <path d="M28 23H52V23.5H28V23Z" fill="white" />
        <path d="M28 0.5H52V1H28V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 1.5H52V2H28V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 2.5H52V3H28V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 3.5H52V4H28V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 4.5H52V5H28V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 5.5H52V6H28V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 6.5H52V7H28V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 7.5H52V8H28V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 8.5H52V9H28V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 9.5H52V10H28V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 10.5H52V11H28V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 11.5H52V12H28V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 12.5H52V13H28V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 13.5H52V14H28V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 14.5H52V15H28V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 15.5H52V16H28V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 16.5H52V17H28V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 17.5H52V18H28V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 18.5H52V19H28V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 19.5H52V20H28V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 20.5H52V21H28V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 21.5H52V22H28V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 22.5H52V23H28V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 23.5H52V24H28V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask8_767_12374)">
        <path
          d="M49.7949 24C49.7949 22.5811 49.7949 21.2813 49.5775 18.5083C49.3084 15.7225 47.8479 14.3106 45.3496 13.8144C48.3092 13.4328 50.5 11.1432 50.5 7.6323C50.5 2.93844 47.3867 0 41.1217 0H29.5V4.89179H39.9688C42.7361 4.89179 44.1197 6.07129 44.1197 8.01747C44.1197 10.2308 42.7361 11.0669 39.9688 11.0669H29.5V16.066H39.6613C41.8521 16.066 43.0436 16.6766 43.2357 19.4241C43.3811 21.3005 43.3628 22.2297 43.3454 23.1207L43.3454 23.1214L43.3452 23.1321C43.3397 23.4152 43.3343 23.6947 43.3343 24H49.7949Z"
          fill="white"
        />
        <path
          d="M29.5 20.2732V24H37.72V21.6148C37.72 21.1137 37.4723 20.2732 36.3313 20.2732H29.5Z"
          fill="white"
        />
      </g>
    </g>
    <g className="backend appwrite" opacity="0">
      <g filter="url(#filter23_d_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint100_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint101_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M67.5 147C67.5 150.575 64.5892 153.945 59.5754 156.452C54.5914 158.944 47.6712 160.5 40 160.5C32.3288 160.5 25.4086 158.944 20.4246 156.452C15.4108 153.945 12.5 150.575 12.5 147C12.5 143.425 15.4108 140.055 20.4246 137.548C25.4086 135.056 32.3288 133.5 40 133.5C47.6712 133.5 54.5914 135.056 59.5754 137.548C64.5892 140.055 67.5 143.425 67.5 147Z"
          stroke="url(#paint102_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter24_i_767_12374)">
        <ellipse
          cx="40"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint103_radial_767_12374)"
        />
      </g>
      <path
        d="M40 154.5C43.9268 154.5 47.5065 153.705 50.1231 152.397C52.7098 151.104 54.5 149.224 54.5 147C54.5 144.776 52.7098 142.896 50.1231 141.603C47.5065 140.295 43.9268 139.5 40 139.5C36.0732 139.5 32.4935 140.295 29.8769 141.603C27.2902 142.896 25.5 144.776 25.5 147C25.5 149.224 27.2902 151.104 29.8769 152.397C32.4935 153.705 36.0732 154.5 40 154.5Z"
        stroke="url(#paint104_radial_767_12374)"
      />
      <ellipse
        cx="40"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint105_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint106_radial_767_12374)"
      />
      <path
        d="M21 110H59L51 147C51 147 51 152.5 40 152.5C29 152.5 29 147 29 147L21 110Z"
        fill="url(#paint107_linear_767_12374)"
      />
      <mask
        id="mask9_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="28"
        y="108"
        width="24"
        height="24"
      >
        <path d="M28 108H52V108.5H28V108Z" fill="white" />
        <path d="M28 109H52V109.5H28V109Z" fill="white" />
        <path d="M28 110H52V110.5H28V110Z" fill="white" />
        <path d="M28 111H52V111.5H28V111Z" fill="white" />
        <path d="M28 112H52V112.5H28V112Z" fill="white" />
        <path d="M28 113H52V113.5H28V113Z" fill="white" />
        <path d="M28 114H52V114.5H28V114Z" fill="white" />
        <path d="M28 115H52V115.5H28V115Z" fill="white" />
        <path d="M28 116H52V116.5H28V116Z" fill="white" />
        <path d="M28 117H52V117.5H28V117Z" fill="white" />
        <path d="M28 118H52V118.5H28V118Z" fill="white" />
        <path d="M28 119H52V119.5H28V119Z" fill="white" />
        <path d="M28 120H52V120.5H28V120Z" fill="white" />
        <path d="M28 121H52V121.5H28V121Z" fill="white" />
        <path d="M28 122H52V122.5H28V122Z" fill="white" />
        <path d="M28 123H52V123.5H28V123Z" fill="white" />
        <path d="M28 124H52V124.5H28V124Z" fill="white" />
        <path d="M28 125H52V125.5H28V125Z" fill="white" />
        <path d="M28 126H52V126.5H28V126Z" fill="white" />
        <path d="M28 127H52V127.5H28V127Z" fill="white" />
        <path d="M28 128H52V128.5H28V128Z" fill="white" />
        <path d="M28 129H52V129.5H28V129Z" fill="white" />
        <path d="M28 130H52V130.5H28V130Z" fill="white" />
        <path d="M28 131H52V131.5H28V131Z" fill="white" />
        <path d="M28 108.5H52V109H28V108.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 109.5H52V110H28V109.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 110.5H52V111H28V110.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 111.5H52V112H28V111.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 112.5H52V113H28V112.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 113.5H52V114H28V113.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 114.5H52V115H28V114.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 115.5H52V116H28V115.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 116.5H52V117H28V116.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 117.5H52V118H28V117.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 118.5H52V119H28V118.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 119.5H52V120H28V119.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 120.5H52V121H28V120.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 121.5H52V122H28V121.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 122.5H52V123H28V122.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 123.5H52V124H28V123.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 124.5H52V125H28V124.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 125.5H52V126H28V125.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 126.5H52V127H28V126.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 127.5H52V128H28V127.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 128.5H52V129H28V128.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 129.5H52V130H28V129.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 130.5H52V131H28V130.5Z" fill="white" fillOpacity="0.5" />
        <path d="M28 131.5H52V132H28V131.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask9_767_12374)">
        <path
          d="M52 125.378V130.756H38.5571C34.6407 130.756 31.221 128.593 29.3914 125.378C29.1254 124.911 28.8927 124.42 28.6974 123.911C28.3141 122.914 28.0731 121.844 28 120.727V119.273C28.0159 119.024 28.0409 118.777 28.0736 118.533C28.1404 118.033 28.2414 117.543 28.3742 117.066C29.63 112.552 33.7133 109.244 38.5571 109.244C43.4009 109.244 47.4838 112.552 48.7395 117.066H42.9916C42.0479 115.595 40.4146 114.622 38.5571 114.622C36.6997 114.622 35.0663 115.595 34.1227 117.066C33.835 117.514 33.6119 118.007 33.4657 118.533C33.3358 119 33.2665 119.492 33.2665 120C33.2665 121.542 33.9043 122.931 34.9268 123.911C35.8743 124.821 37.1517 125.378 38.5571 125.378H52Z"
          fill="#FD366E"
        />
        <path
          d="M52 118.533V123.911H42.1874C43.21 122.931 43.8477 121.542 43.8477 120C43.8477 119.492 43.7785 119 43.6486 118.533H52Z"
          fill="#FD366E"
        />
      </g>
    </g>
    <g className="framework chakra">
      <g filter="url(#filter25_d_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="28"
          ry="14"
          fill="url(#paint108_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint109_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 39C283.5 42.5746 280.589 45.9454 275.575 48.4523C270.591 50.9443 263.671 52.5 256 52.5C248.329 52.5 241.409 50.9443 236.425 48.4523C231.411 45.9454 228.5 42.5746 228.5 39C228.5 35.4254 231.411 32.0546 236.425 29.5477C241.409 27.0557 248.329 25.5 256 25.5C263.671 25.5 270.591 27.0557 275.575 29.5477C280.589 32.0546 283.5 35.4254 283.5 39Z"
          stroke="url(#paint110_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter26_i_767_12374)">
        <ellipse
          cx="256"
          cy="39"
          rx="14"
          ry="7"
          fill="url(#paint111_radial_767_12374)"
        />
      </g>
      <path
        d="M256 46.5C259.927 46.5 263.507 45.7052 266.123 44.397C268.71 43.1036 270.5 41.2244 270.5 39C270.5 36.7756 268.71 34.8964 266.123 33.603C263.507 32.2948 259.927 31.5 256 31.5C252.073 31.5 248.493 32.2948 245.877 33.603C243.29 34.8964 241.5 36.7756 241.5 39C241.5 41.2244 243.29 43.1036 245.877 44.397C248.493 45.7052 252.073 46.5 256 46.5Z"
        stroke="url(#paint112_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="39"
        rx="11"
        ry="5.5"
        fill="url(#paint113_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint114_radial_767_12374)"
      />
      <path
        d="M237 2H275L267 39C267 39 267 44.5 256 44.5C245 44.5 245 39 245 39L237 2Z"
        fill="url(#paint115_linear_767_12374)"
      />
      <mask
        id="mask10_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="0"
        width="24"
        height="24"
      >
        <path d="M244 0H268V0.5H244V0Z" fill="white" />
        <path d="M244 1H268V1.5H244V1Z" fill="white" />
        <path d="M244 2H268V2.5H244V2Z" fill="white" />
        <path d="M244 3H268V3.5H244V3Z" fill="white" />
        <path d="M244 4H268V4.5H244V4Z" fill="white" />
        <path d="M244 5H268V5.5H244V5Z" fill="white" />
        <path d="M244 6H268V6.5H244V6Z" fill="white" />
        <path d="M244 7H268V7.5H244V7Z" fill="white" />
        <path d="M244 8H268V8.5H244V8Z" fill="white" />
        <path d="M244 9H268V9.5H244V9Z" fill="white" />
        <path d="M244 10H268V10.5H244V10Z" fill="white" />
        <path d="M244 11H268V11.5H244V11Z" fill="white" />
        <path d="M244 12H268V12.5H244V12Z" fill="white" />
        <path d="M244 13H268V13.5H244V13Z" fill="white" />
        <path d="M244 14H268V14.5H244V14Z" fill="white" />
        <path d="M244 15H268V15.5H244V15Z" fill="white" />
        <path d="M244 16H268V16.5H244V16Z" fill="white" />
        <path d="M244 17H268V17.5H244V17Z" fill="white" />
        <path d="M244 18H268V18.5H244V18Z" fill="white" />
        <path d="M244 19H268V19.5H244V19Z" fill="white" />
        <path d="M244 20H268V20.5H244V20Z" fill="white" />
        <path d="M244 21H268V21.5H244V21Z" fill="white" />
        <path d="M244 22H268V22.5H244V22Z" fill="white" />
        <path d="M244 23H268V23.5H244V23Z" fill="white" />
        <path d="M244 0.5H268V1H244V0.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 1.5H268V2H244V1.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 2.5H268V3H244V2.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 3.5H268V4H244V3.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 4.5H268V5H244V4.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 5.5H268V6H244V5.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 6.5H268V7H244V6.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 7.5H268V8H244V7.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 8.5H268V9H244V8.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 9.5H268V10H244V9.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 10.5H268V11H244V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 11.5H268V12H244V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 12.5H268V13H244V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 13.5H268V14H244V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 14.5H268V15H244V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 15.5H268V16H244V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 16.5H268V17H244V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 17.5H268V18H244V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 18.5H268V19H244V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 19.5H268V20H244V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 20.5H268V21H244V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 21.5H268V22H244V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 22.5H268V23H244V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M244 23.5H268V24H244V23.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask10_767_12374)">
        <circle cx="256" cy="12" r="11.25" fill="white" />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M256 0C262.627 0 268 5.37258 268 12C268 18.6274 262.627 24 256 24C249.373 24 244 18.6274 244 12C244 5.37258 249.373 0 256 0ZM258.676 4.38881L250.496 12.5123C250.377 12.6298 250.461 12.8316 250.627 12.8316H256.194C256.347 12.8316 256.435 13.0045 256.345 13.128L251.981 19.1488C251.848 19.3318 252.094 19.5492 252.26 19.395L261.479 10.7903C261.603 10.6746 261.521 10.467 261.352 10.467H256.091C255.949 10.467 255.859 10.3151 255.927 10.1907L258.971 4.61078C259.074 4.42172 258.828 4.23705 258.676 4.38881Z"
          fill="url(#paint116_linear_767_12374)"
        />
      </g>
    </g>
    <g className="auth strapi" opacity="0">
      <g filter="url(#filter27_d_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="28"
          ry="14"
          fill="url(#paint117_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint118_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M283.5 147C283.5 150.575 280.589 153.945 275.575 156.452C270.591 158.944 263.671 160.5 256 160.5C248.329 160.5 241.409 158.944 236.425 156.452C231.411 153.945 228.5 150.575 228.5 147C228.5 143.425 231.411 140.055 236.425 137.548C241.409 135.056 248.329 133.5 256 133.5C263.671 133.5 270.591 135.056 275.575 137.548C280.589 140.055 283.5 143.425 283.5 147Z"
          stroke="url(#paint119_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter28_i_767_12374)">
        <ellipse
          cx="256"
          cy="147"
          rx="14"
          ry="7"
          fill="url(#paint120_radial_767_12374)"
        />
      </g>
      <path
        d="M256 154.5C259.927 154.5 263.507 153.705 266.123 152.397C268.71 151.104 270.5 149.224 270.5 147C270.5 144.776 268.71 142.896 266.123 141.603C263.507 140.295 259.927 139.5 256 139.5C252.073 139.5 248.493 140.295 245.877 141.603C243.29 142.896 241.5 144.776 241.5 147C241.5 149.224 243.29 151.104 245.877 152.397C248.493 153.705 252.073 154.5 256 154.5Z"
        stroke="url(#paint121_radial_767_12374)"
      />
      <ellipse
        cx="256"
        cy="147"
        rx="11"
        ry="5.5"
        fill="url(#paint122_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint123_radial_767_12374)"
      />
      <path
        d="M237 110H275L267 147C267 147 267 152.5 256 152.5C245 152.5 245 147 245 147L237 110Z"
        fill="url(#paint124_linear_767_12374)"
      />
      <mask
        id="mask11_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="244"
        y="108"
        width="24"
        height="24"
      >
        <path d="M244 108H268V108.5H244V108Z" fill="white" />
        <path d="M244 109H268V109.5H244V109Z" fill="white" />
        <path d="M244 110H268V110.5H244V110Z" fill="white" />
        <path d="M244 111H268V111.5H244V111Z" fill="white" />
        <path d="M244 112H268V112.5H244V112Z" fill="white" />
        <path d="M244 113H268V113.5H244V113Z" fill="white" />
        <path d="M244 114H268V114.5H244V114Z" fill="white" />
        <path d="M244 115H268V115.5H244V115Z" fill="white" />
        <path d="M244 116H268V116.5H244V116Z" fill="white" />
        <path d="M244 117H268V117.5H244V117Z" fill="white" />
        <path d="M244 118H268V118.5H244V118Z" fill="white" />
        <path d="M244 119H268V119.5H244V119Z" fill="white" />
        <path d="M244 120H268V120.5H244V120Z" fill="white" />
        <path d="M244 121H268V121.5H244V121Z" fill="white" />
        <path d="M244 122H268V122.5H244V122Z" fill="white" />
        <path d="M244 123H268V123.5H244V123Z" fill="white" />
        <path d="M244 124H268V124.5H244V124Z" fill="white" />
        <path d="M244 125H268V125.5H244V125Z" fill="white" />
        <path d="M244 126H268V126.5H244V126Z" fill="white" />
        <path d="M244 127H268V127.5H244V127Z" fill="white" />
        <path d="M244 128H268V128.5H244V128Z" fill="white" />
        <path d="M244 129H268V129.5H244V129Z" fill="white" />
        <path d="M244 130H268V130.5H244V130Z" fill="white" />
        <path d="M244 131H268V131.5H244V131Z" fill="white" />
        <path
          d="M244 108.5H268V109H244V108.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 109.5H268V110H244V109.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 110.5H268V111H244V110.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 111.5H268V112H244V111.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 112.5H268V113H244V112.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 113.5H268V114H244V113.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 114.5H268V115H244V114.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 115.5H268V116H244V115.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 116.5H268V117H244V116.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 117.5H268V118H244V117.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 118.5H268V119H244V118.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 119.5H268V120H244V119.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 120.5H268V121H244V120.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 121.5H268V122H244V121.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 122.5H268V123H244V122.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 123.5H268V124H244V123.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 124.5H268V125H244V124.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 125.5H268V126H244V125.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 126.5H268V127H244V126.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 127.5H268V128H244V127.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 128.5H268V129H244V128.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 129.5H268V130H244V129.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 130.5H268V131H244V130.5Z"
          fill="white"
          fillOpacity="0.5"
        />
        <path
          d="M244 131.5H268V132H244V131.5Z"
          fill="white"
          fillOpacity="0.5"
        />
      </mask>
      <g mask="url(#mask11_767_12374)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M267.766 108H251.806V115.972H259.794C259.923 115.972 260.028 116.076 260.028 116.205V124.193H268V108.233C268 108.104 267.895 108 267.766 108Z"
          fill="#4945FF"
        />
        <path
          d="M251.808 108V115.972H244.117C244.013 115.972 243.961 115.846 244.035 115.773L251.808 108Z"
          fill="#4945FF"
          fillOpacity="0.4"
        />
        <path
          d="M260.227 131.966C260.154 132.039 260.028 131.987 260.028 131.883V124.193H252.043C251.914 124.193 251.809 124.089 251.809 123.96V115.972H259.914C259.978 115.972 260.031 116.024 260.031 116.089V124.193H268L260.227 131.966Z"
          fill="#4945FF"
          fillOpacity="0.4"
        />
      </g>
    </g>
    <g className="main">
      <g filter="url(#filter29_d_767_12374)">
        <ellipse
          cx="148"
          cy="88"
          rx="56"
          ry="28"
          fill="url(#paint125_radial_767_12374)"
          shapeRendering="crispEdges"
        />
        <path
          d="M203.5 88C203.5 95.4406 197.455 102.311 187.374 107.352C177.323 112.377 163.403 115.5 148 115.5C132.597 115.5 118.677 112.377 108.626 107.352C98.5448 102.311 92.5 95.4406 92.5 88C92.5 80.5594 98.5448 73.6887 108.626 68.6482C118.677 63.6228 132.597 60.5 148 60.5C163.403 60.5 177.323 63.6228 187.374 68.6482C197.455 73.6887 203.5 80.5594 203.5 88Z"
          stroke="url(#paint126_linear_767_12374)"
          strokeOpacity="0.5"
          shapeRendering="crispEdges"
        />
        <path
          d="M203.5 88C203.5 95.4406 197.455 102.311 187.374 107.352C177.323 112.377 163.403 115.5 148 115.5C132.597 115.5 118.677 112.377 108.626 107.352C98.5448 102.311 92.5 95.4406 92.5 88C92.5 80.5594 98.5448 73.6887 108.626 68.6482C118.677 63.6228 132.597 60.5 148 60.5C163.403 60.5 177.323 63.6228 187.374 68.6482C197.455 73.6887 203.5 80.5594 203.5 88Z"
          stroke="url(#paint127_linear_767_12374)"
          shapeRendering="crispEdges"
        />
      </g>
      <g filter="url(#filter30_i_767_12374)">
        <ellipse
          cx="148"
          cy="88"
          rx="28"
          ry="14"
          fill="url(#paint128_radial_767_12374)"
        />
      </g>
      <path
        d="M148 102.5C155.793 102.5 162.873 100.922 168.023 98.3467C173.143 95.7866 176.5 92.1574 176.5 88C176.5 83.8426 173.143 80.2134 168.023 77.6533C162.873 75.0783 155.793 73.5 148 73.5C140.207 73.5 133.127 75.0783 127.977 77.6533C122.857 80.2134 119.5 83.8426 119.5 88C119.5 92.1574 122.857 95.7866 127.977 98.3467C133.127 100.922 140.207 102.5 148 102.5Z"
        stroke="url(#paint129_radial_767_12374)"
      />
      <ellipse
        cx="148"
        cy="88"
        rx="22"
        ry="11"
        fill="url(#paint130_radial_767_12374)"
      />
      <path
        d="M110 14H186L170 88C170 88 170 99 148 99C126 99 126 88 126 88L110 14Z"
        fill="url(#paint131_radial_767_12374)"
      />
      <path
        d="M110 14H186L170 88C170 88 170 99 148 99C126 99 126 88 126 88L110 14Z"
        fill="url(#paint132_linear_767_12374)"
      />
      <mask
        id="mask12_767_12374"
        style={{
          maskType: "alpha",
        }}
        maskUnits="userSpaceOnUse"
        x="124"
        y="10"
        width="48"
        height="48"
      >
        <path d="M124 10H172V10.5H124V10Z" fill="white" />
        <path d="M124 11H172V11.5H124V11Z" fill="white" />
        <path d="M124 12H172V12.5H124V12Z" fill="white" />
        <path d="M124 13H172V13.5H124V13Z" fill="white" />
        <path d="M124 14H172V14.5H124V14Z" fill="white" />
        <path d="M124 15H172V15.5H124V15Z" fill="white" />
        <path d="M124 16H172V16.5H124V16Z" fill="white" />
        <path d="M124 17H172V17.5H124V17Z" fill="white" />
        <path d="M124 18H172V18.5H124V18Z" fill="white" />
        <path d="M124 19H172V19.5H124V19Z" fill="white" />
        <path d="M124 20H172V20.5H124V20Z" fill="white" />
        <path d="M124 21H172V21.5H124V21Z" fill="white" />
        <path d="M124 22H172V22.5H124V22Z" fill="white" />
        <path d="M124 23H172V23.5H124V23Z" fill="white" />
        <path d="M124 24H172V24.5H124V24Z" fill="white" />
        <path d="M124 25H172V25.5H124V25Z" fill="white" />
        <path d="M124 26H172V26.5H124V26Z" fill="white" />
        <path d="M124 27H172V27.5H124V27Z" fill="white" />
        <path d="M124 28H172V28.5H124V28Z" fill="white" />
        <path d="M124 29H172V29.5H124V29Z" fill="white" />
        <path d="M124 30H172V30.5H124V30Z" fill="white" />
        <path d="M124 31H172V31.5H124V31Z" fill="white" />
        <path d="M124 32H172V32.5H124V32Z" fill="white" />
        <path d="M124 33H172V33.5H124V33Z" fill="white" />
        <path d="M124 34H172V34.5H124V34Z" fill="white" />
        <path d="M124 35H172V35.5H124V35Z" fill="white" />
        <path d="M124 36H172V36.5H124V36Z" fill="white" />
        <path d="M124 37H172V37.5H124V37Z" fill="white" />
        <path d="M124 38H172V38.5H124V38Z" fill="white" />
        <path d="M124 39H172V39.5H124V39Z" fill="white" />
        <path d="M124 40H172V40.5H124V40Z" fill="white" />
        <path d="M124 41H172V41.5H124V41Z" fill="white" />
        <path d="M124 42H172V42.5H124V42Z" fill="white" />
        <path d="M124 43H172V43.5H124V43Z" fill="white" />
        <path d="M124 44H172V44.5H124V44Z" fill="white" />
        <path d="M124 45H172V45.5H124V45Z" fill="white" />
        <path d="M124 46H172V46.5H124V46Z" fill="white" />
        <path d="M124 47H172V47.5H124V47Z" fill="white" />
        <path d="M124 48H172V48.5H124V48Z" fill="white" />
        <path d="M124 49H172V49.5H124V49Z" fill="white" />
        <path d="M124 50H172V50.5H124V50Z" fill="white" />
        <path d="M124 51H172V51.5H124V51Z" fill="white" />
        <path d="M124 52H172V52.5H124V52Z" fill="white" />
        <path d="M124 53H172V53.5H124V53Z" fill="white" />
        <path d="M124 54H172V54.5H124V54Z" fill="white" />
        <path d="M124 55H172V55.5H124V55Z" fill="white" />
        <path d="M124 56H172V56.5H124V56Z" fill="white" />
        <path d="M124 57H172V57.5H124V57Z" fill="white" />
        <path d="M124 10.5H172V11H124V10.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 11.5H172V12H124V11.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 12.5H172V13H124V12.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 13.5H172V14H124V13.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 14.5H172V15H124V14.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 15.5H172V16H124V15.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 16.5H172V17H124V16.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 17.5H172V18H124V17.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 18.5H172V19H124V18.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 19.5H172V20H124V19.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 20.5H172V21H124V20.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 21.5H172V22H124V21.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 22.5H172V23H124V22.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 23.5H172V24H124V23.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 24.5H172V25H124V24.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 25.5H172V26H124V25.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 26.5H172V27H124V26.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 27.5H172V28H124V27.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 28.5H172V29H124V28.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 29.5H172V30H124V29.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 30.5H172V31H124V30.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 31.5H172V32H124V31.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 32.5H172V33H124V32.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 33.5H172V34H124V33.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 34.5H172V35H124V34.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 35.5H172V36H124V35.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 36.5H172V37H124V36.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 37.5H172V38H124V37.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 38.5H172V39H124V38.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 39.5H172V40H124V39.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 40.5H172V41H124V40.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 41.5H172V42H124V41.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 42.5H172V43H124V42.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 43.5H172V44H124V43.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 44.5H172V45H124V44.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 45.5H172V46H124V45.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 46.5H172V47H124V46.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 47.5H172V48H124V47.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 48.5H172V49H124V48.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 49.5H172V50H124V49.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 50.5H172V51H124V50.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 51.5H172V52H124V51.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 52.5H172V53H124V52.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 53.5H172V54H124V53.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 54.5H172V55H124V54.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 55.5H172V56H124V55.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 56.5H172V57H124V56.5Z" fill="white" fillOpacity="0.5" />
        <path d="M124 57.5H172V58H124V57.5Z" fill="white" fillOpacity="0.5" />
      </mask>
      <g mask="url(#mask12_767_12374)">
        <circle opacity="0.25" cx="148" cy="34" r="24" fill="#47EBEB" />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M153.25 44.5V23.5C153.25 20.6005 150.899 18.25 148 18.25C145.101 18.25 142.75 20.6005 142.75 23.5V44.5C142.75 47.3995 145.101 49.75 148 49.75C150.899 49.75 153.25 47.3995 153.25 44.5ZM148 16C143.858 16 140.5 19.3579 140.5 23.5V44.5C140.5 48.6421 143.858 52 148 52C152.142 52 155.5 48.6421 155.5 44.5V23.5C155.5 19.3579 152.142 16 148 16Z"
          fill="#47EBEB"
        />
        <circle cx="148" cy="23.5" r="4" fill="#47EBEB" />
      </g>
    </g>
    <defs>
      <filter
        id="filter0_d_767_12374"
        x="89.2"
        y="60"
        width="117.6"
        height="64.4"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="5.6" />
        <feGaussianBlur stdDeviation="1.4" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter1_d_767_12374"
        x="226.6"
        y="25"
        width="58.8"
        height="32.2"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="2.8" />
        <feGaussianBlur stdDeviation="0.7" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter2_d_767_12374"
        x="226.6"
        y="133"
        width="58.8"
        height="32.2"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="2.8" />
        <feGaussianBlur stdDeviation="0.7" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter3_d_767_12374"
        x="10.6"
        y="25"
        width="58.8"
        height="32.2"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="2.8" />
        <feGaussianBlur stdDeviation="0.7" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter4_d_767_12374"
        x="10.6"
        y="133"
        width="58.8"
        height="32.2"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="2.8" />
        <feGaussianBlur stdDeviation="0.7" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter5_d_767_12374"
        x="10"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter6_i_767_12374"
        x="25"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter7_d_767_12374"
        x="10"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter8_i_767_12374"
        x="25"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.243137 0 0 0 0 0.811765 0 0 0 0 0.556863 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter9_d_767_12374"
        x="226"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter10_i_767_12374"
        x="241"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0.498039 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter11_d_767_12374"
        x="226"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter12_i_767_12374"
        x="241"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter13_d_767_12374"
        x="10"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter14_i_767_12374"
        x="25"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 0.866667 0 0 0 0 0.207843 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter15_d_767_12374"
        x="10"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter16_i_767_12374"
        x="25"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.878431 0 0 0 0 0.137255 0 0 0 0 0.305882 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter17_d_767_12374"
        x="226"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter18_i_767_12374"
        x="241"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.160784 0 0 0 0 0.803922 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter19_d_767_12374"
        x="226"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter20_i_767_12374"
        x="241"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.921569 0 0 0 0 0.329412 0 0 0 0 0.141176 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter21_d_767_12374"
        x="10"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter22_i_767_12374"
        x="25"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter23_d_767_12374"
        x="10"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter24_i_767_12374"
        x="25"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.941176 0 0 0 0 0.180392 0 0 0 0 0.396078 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter25_d_767_12374"
        x="226"
        y="25"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter26_i_767_12374"
        x="241"
        y="31"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.160784 0 0 0 0 0.776471 0 0 0 0 0.717647 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter27_d_767_12374"
        x="226"
        y="133"
        width="60"
        height="34"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="4" />
        <feGaussianBlur stdDeviation="1" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter28_i_767_12374"
        x="241"
        y="139"
        width="30"
        height="16"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="2.8" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.286275 0 0 0 0 0.270588 0 0 0 0 1 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <filter
        id="filter29_d_767_12374"
        x="88"
        y="60"
        width="120"
        height="68"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset dy="8" />
        <feGaussianBlur stdDeviation="2" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
        />
        <feBlend
          mode="normal"
          in2="BackgroundImageFix"
          result="effect1_dropShadow_767_12374"
        />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="effect1_dropShadow_767_12374"
          result="shape"
        />
      </filter>
      <filter
        id="filter30_i_767_12374"
        x="119"
        y="73"
        width="58"
        height="30"
        filterUnits="userSpaceOnUse"
        colorInterpolationFilters="sRGB"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feBlend
          mode="normal"
          in="SourceGraphic"
          in2="BackgroundImageFix"
          result="shape"
        />
        <feColorMatrix
          in="SourceAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
          result="hardAlpha"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="5.6" />
        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.278431 0 0 0 0 0.921569 0 0 0 0 0.921569 0 0 0 0.5 0"
        />
        <feBlend
          mode="normal"
          in2="shape"
          result="effect1_innerShadow_767_12374"
        />
      </filter>
      <linearGradient
        id="base1"
        x1="148"
        y1="58"
        x2="148"
        y2="142"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0" />
        <stop offset="0.166667" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="base2"
        x1="40"
        y1="26"
        x2="40"
        y2="66"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0" />
        <stop offset="0.166667" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="base3"
        x1="256"
        y1="26"
        x2="256"
        y2="66"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0" />
        <stop offset="0.166667" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="base4"
        x1="40"
        y1="134"
        x2="40"
        y2="174"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0" />
        <stop offset="0.166667" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="base5"
        x1="256"
        y1="134"
        x2="256"
        y2="174"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="white" stopOpacity="0" />
        <stop offset="0.166667" stopColor="white" />
      </linearGradient>
      <linearGradient
        id="paint5_linear_767_12374"
        x1="204"
        y1="113.2"
        x2="92"
        y2="113.2"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0A0A29" />
        <stop offset="0.5" stopColor="#262659" />
        <stop offset="1" stopColor="#0A0A29" />
      </linearGradient>
      <linearGradient
        id="base6"
        x1="148"
        y1="60"
        x2="148"
        y2="138.4"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.356484" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint7_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 116) rotate(-90) scale(56)"
      >
        <stop stopColor="#3D3D8F" />
        <stop offset="1" stopColor="#171736" />
      </radialGradient>
      <linearGradient
        id="paint8_linear_767_12374"
        x1="284"
        y1="51.6"
        x2="228"
        y2="51.6"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0A0A29" />
        <stop offset="0.5" stopColor="#262659" />
        <stop offset="1" stopColor="#0A0A29" />
      </linearGradient>
      <linearGradient
        id="paint9_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="64.2"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.356484" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint10_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 53) rotate(-90) scale(28)"
      >
        <stop stopColor="#3D3D8F" />
        <stop offset="1" stopColor="#171736" />
      </radialGradient>
      <linearGradient
        id="paint11_linear_767_12374"
        x1="284"
        y1="159.6"
        x2="228"
        y2="159.6"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0A0A29" />
        <stop offset="0.5" stopColor="#262659" />
        <stop offset="1" stopColor="#0A0A29" />
      </linearGradient>
      <linearGradient
        id="paint12_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="172.2"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.356484" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint13_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 161) rotate(-90) scale(28)"
      >
        <stop stopColor="#3D3D8F" />
        <stop offset="1" stopColor="#171736" />
      </radialGradient>
      <linearGradient
        id="paint14_linear_767_12374"
        x1="68"
        y1="51.6"
        x2="12"
        y2="51.6"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0A0A29" />
        <stop offset="0.5" stopColor="#262659" />
        <stop offset="1" stopColor="#0A0A29" />
      </linearGradient>
      <linearGradient
        id="paint15_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="64.2"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.356484" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint16_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 53) rotate(-90) scale(28)"
      >
        <stop stopColor="#3D3D8F" />
        <stop offset="1" stopColor="#171736" />
      </radialGradient>
      <linearGradient
        id="paint17_linear_767_12374"
        x1="68"
        y1="159.6"
        x2="12"
        y2="159.6"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0A0A29" />
        <stop offset="0.5" stopColor="#262659" />
        <stop offset="1" stopColor="#0A0A29" />
      </linearGradient>
      <linearGradient
        id="paint18_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="172.2"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.356484" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.1" />
      </linearGradient>
      <radialGradient
        id="paint19_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 161) rotate(-90) scale(28)"
      >
        <stop stopColor="#3D3D8F" />
        <stop offset="1" stopColor="#171736" />
      </radialGradient>
      <radialGradient
        id="paint20_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="white" stopOpacity="0.5" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint21_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint22_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint23_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint24_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint25_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint26_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint27_linear_767_12374"
        x1="40"
        y1="-1.36667"
        x2="40"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint28_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#3ECF8E" stopOpacity="0.5" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint29_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#3ECF8E" stopOpacity="0" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint30_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#3ECF8E" stopOpacity="0" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint31_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#3ECF8E" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint32_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#3ECF8E" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint33_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#3ECF8E" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint34_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#3ECF8E" stopOpacity="0" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint35_linear_767_12374"
        x1="40"
        y1="106.633"
        x2="40"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#3ECF8E" stopOpacity="0" />
        <stop offset="1" stopColor="#3ECF8E" stopOpacity="0.5" />
      </linearGradient>
      <linearGradient
        id="paint36_linear_767_12374"
        x1="40"
        y1="119.31"
        x2="48.8104"
        y2="122.94"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#249361" />
        <stop offset="1" stopColor="#3ECF8E" />
      </linearGradient>
      <linearGradient
        id="paint37_linear_767_12374"
        x1="36.1143"
        y1="113.895"
        x2="40.2228"
        y2="121.493"
        gradientUnits="userSpaceOnUse"
      >
        <stop />
        <stop offset="1" stopOpacity="0" />
      </linearGradient>
      <radialGradient
        id="paint38_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#007FFF" stopOpacity="0.5" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint39_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#007FFF" stopOpacity="0" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint40_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#007FFF" stopOpacity="0" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint41_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#007FFF" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint42_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#007FFF" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint43_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#007FFF" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint44_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#007FFF" stopOpacity="0" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint45_linear_767_12374"
        x1="256"
        y1="-1.36667"
        x2="256"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#007FFF" stopOpacity="0" />
        <stop offset="1" stopColor="#007FFF" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint46_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#BEBEBE" stopOpacity="0.5" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint47_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#BEBEBE" stopOpacity="0" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint48_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#BEBEBE" stopOpacity="0" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint49_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#BEBEBE" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint50_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#BEBEBE" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint51_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#BEBEBE" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint52_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#BEBEBE" stopOpacity="0" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint53_linear_767_12374"
        x1="256"
        y1="106.633"
        x2="256"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#BEBEBE" stopOpacity="0" />
        <stop offset="1" stopColor="#BEBEBE" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint54_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#FFDD35" stopOpacity="0.5" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint55_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#FFDD35" stopOpacity="0" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint56_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#FFDD35" stopOpacity="0" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint57_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#FFDD35" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint58_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#FFDD35" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint59_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#FFDD35" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint60_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#FFDD35" stopOpacity="0" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint61_linear_767_12374"
        x1="40"
        y1="-1.36667"
        x2="40"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#FFDD35" stopOpacity="0" />
        <stop offset="1" stopColor="#FFDD35" stopOpacity="0.5" />
      </linearGradient>
      <linearGradient
        id="paint62_linear_767_12374"
        x1="27.8013"
        y1="1.92919"
        x2="41.8098"
        y2="20.9778"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#41D1FF" />
        <stop offset="1" stopColor="#BD34FE" />
      </linearGradient>
      <linearGradient
        id="paint63_linear_767_12374"
        x1="39.3604"
        y1="0.449195"
        x2="41.8923"
        y2="17.8401"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FFEA83" />
        <stop offset="0.0833333" stopColor="#FFDD35" />
        <stop offset="1" stopColor="#FFA800" />
        <stop offset="1" stopColor="#FFA800" />
      </linearGradient>
      <radialGradient
        id="paint64_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#E0234E" stopOpacity="0.5" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint65_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#E0234E" stopOpacity="0" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint66_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#E0234E" stopOpacity="0" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint67_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#E0234E" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint68_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#E0234E" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint69_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#E02354" />
        <stop offset="1" stopColor="#E02354" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint70_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#E02354" stopOpacity="0" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint71_linear_767_12374"
        x1="40"
        y1="106.633"
        x2="40"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#E0234E" stopOpacity="0" />
        <stop offset="1" stopColor="#E0234E" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint72_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#29CDFF" stopOpacity="0.5" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint73_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#29CDFF" stopOpacity="0" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint74_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#29CDFF" stopOpacity="0" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint75_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#29CDFF" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint76_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#29CDFF" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint77_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#29CDFF" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint78_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#29CDFF" stopOpacity="0" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint79_linear_767_12374"
        x1="256"
        y1="-1.36667"
        x2="256"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#29CDFF" stopOpacity="0" />
        <stop offset="1" stopColor="#29CDFF" stopOpacity="0.5" />
      </linearGradient>
      <linearGradient
        id="paint80_linear_767_12374"
        x1="255.074"
        y1="4.95524e-07"
        x2="265.104"
        y2="6.12128"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#4285EB" />
        <stop offset="1" stopColor="#2EC7FF" />
      </linearGradient>
      <linearGradient
        id="paint81_linear_767_12374"
        x1="256.419"
        y1="-2.82284e-07"
        x2="251.461"
        y2="25.6083"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#29CDFF" />
        <stop offset="0.378601" stopColor="#148EFF" />
        <stop offset="1" stopColor="#0A60FF" />
      </linearGradient>
      <linearGradient
        id="paint82_linear_767_12374"
        x1="266.2"
        y1="6.14614"
        x2="259.751"
        y2="16.2258"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FA816E" />
        <stop offset="0.414726" stopColor="#F74A5C" />
        <stop offset="1" stopColor="#F51D2C" />
      </linearGradient>
      <linearGradient
        id="paint83_linear_767_12374"
        x1="257.087"
        y1="7.17254"
        x2="254.94"
        y2="15.7532"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FA8E7D" />
        <stop offset="0.512635" stopColor="#F74A5C" />
        <stop offset="1" stopColor="#F51D2C" />
      </linearGradient>
      <radialGradient
        id="paint84_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#EB5424" stopOpacity="0.5" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint85_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#EB5424" stopOpacity="0" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint86_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#EB5424" stopOpacity="0" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint87_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#EB5424" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint88_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#EB5424" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint89_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#EB5424" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint90_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#EB5424" stopOpacity="0" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint91_linear_767_12374"
        x1="256"
        y1="106.633"
        x2="256"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#EB5424" stopOpacity="0" />
        <stop offset="1" stopColor="#EB5424" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint92_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="white" stopOpacity="0.5" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint93_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint94_linear_767_12374"
        x1="40"
        y1="25"
        x2="40"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint95_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint96_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint97_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="white" />
        <stop offset="1" stopColor="white" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint98_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint99_linear_767_12374"
        x1="40"
        y1="-1.36667"
        x2="40"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="white" stopOpacity="0" />
        <stop offset="1" stopColor="white" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint100_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#FD366E" stopOpacity="0.5" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint101_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#FD366E" stopOpacity="0" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint102_linear_767_12374"
        x1="40"
        y1="133"
        x2="40"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#FD366E" stopOpacity="0" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint103_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#FD366E" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint104_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#FD366E" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint105_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#FD366E" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint106_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(40 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#FD366E" stopOpacity="0" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint107_linear_767_12374"
        x1="40"
        y1="106.633"
        x2="40"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#FD366E" stopOpacity="0" />
        <stop offset="1" stopColor="#FD366E" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint108_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 53) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#29C6B7" stopOpacity="0.5" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint109_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#29C6B7" stopOpacity="0" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint110_linear_767_12374"
        x1="256"
        y1="25"
        x2="256"
        y2="53"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#29C6B7" stopOpacity="0" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint111_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#29C6B7" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint112_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 46) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#29C6B7" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint113_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 44.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#29C6B7" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint114_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 -1.36667) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#29C6B7" stopOpacity="0" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint115_linear_767_12374"
        x1="256"
        y1="-1.36667"
        x2="256"
        y2="44.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#29C6B7" stopOpacity="0" />
        <stop offset="1" stopColor="#29C6B7" stopOpacity="0.5" />
      </linearGradient>
      <linearGradient
        id="paint116_linear_767_12374"
        x1="256"
        y1="0"
        x2="256"
        y2="24"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#7BCBD4" />
        <stop offset="1" stopColor="#29C6B7" />
      </linearGradient>
      <radialGradient
        id="paint117_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 161) rotate(90) scale(11.2 17.1764)"
      >
        <stop stopColor="#4945FF" stopOpacity="0.5" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint118_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#4945FF" stopOpacity="0" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint119_linear_767_12374"
        x1="256"
        y1="133"
        x2="256"
        y2="161"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#4945FF" stopOpacity="0" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint120_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(90) scale(10.5 14)"
      >
        <stop stopColor="#4945FF" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint121_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 154) rotate(-90) scale(7 14)"
      >
        <stop stopColor="#4945FF" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint122_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 152.5) rotate(90) scale(8.25 11)"
      >
        <stop stopColor="#4945FF" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint123_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(256 106.633) rotate(90) scale(45.8667 32.5781)"
      >
        <stop offset="0.670101" stopColor="#4945FF" stopOpacity="0" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint124_linear_767_12374"
        x1="256"
        y1="106.633"
        x2="256"
        y2="152.5"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#4945FF" stopOpacity="0" />
        <stop offset="1" stopColor="#4945FF" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint125_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 116) rotate(90) scale(22.4 34.3528)"
      >
        <stop stopColor="#47EBEB" stopOpacity="0.5" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0" />
      </radialGradient>
      <linearGradient
        id="paint126_linear_767_12374"
        x1="148"
        y1="60"
        x2="148"
        y2="116"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.557292" stopColor="#47EBEB" stopOpacity="0" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0.25" />
      </linearGradient>
      <linearGradient
        id="paint127_linear_767_12374"
        x1="148"
        y1="60"
        x2="148"
        y2="116"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.880208" stopColor="#47EBEB" stopOpacity="0" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0.5" />
      </linearGradient>
      <radialGradient
        id="paint128_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 102) rotate(90) scale(21 28)"
      >
        <stop stopColor="#47EBEB" />
        <stop offset="1" stopColor="#0A0A29" stopOpacity="0.75" />
      </radialGradient>
      <radialGradient
        id="paint129_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 102) rotate(-90) scale(14 28)"
      >
        <stop stopColor="#47EBEB" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0.01" />
      </radialGradient>
      <radialGradient
        id="paint130_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 99) rotate(90) scale(16.5 22)"
      >
        <stop stopColor="#47EBEB" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0" />
      </radialGradient>
      <radialGradient
        id="paint131_radial_767_12374"
        cx="0"
        cy="0"
        r="1"
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(148 7.26666) rotate(90) scale(91.7333 65.1562)"
      >
        <stop offset="0.670101" stopColor="#47EBEB" stopOpacity="0" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0.5" />
      </radialGradient>
      <linearGradient
        id="paint132_linear_767_12374"
        x1="148"
        y1="7.26667"
        x2="148"
        y2="99"
        gradientUnits="userSpaceOnUse"
      >
        <stop offset="0.25" stopColor="#47EBEB" stopOpacity="0" />
        <stop offset="1" stopColor="#47EBEB" stopOpacity="0.5" />
      </linearGradient>
    </defs>
  </svg>
);
