import * as React from "react";
import type { SVGProps } from "react";

const SvgUIFrameworks = ({ className, ...props }: SVGProps<SVGSVGElement>) => (
  <svg
    width="32"
    height="32"
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className ? className : undefined}
    {...props}
  >
    <path
      opacity="0.75"
      fillRule="evenodd"
      clipRule="evenodd"
      d="M28.8924 10.975L28.1352 18.7984L28.1352 18.7989C30.4696 19.9658 32 22.3925 32 25.0326C32 28.8744 28.8747 32 25.0326 32H17.5484C14.4173 32 11.6715 30.3459 10.1185 27.871H2.58065C1.1576 27.871 0 26.7134 0 25.2903V2.58065C0 1.1576 1.1576 0 2.58065 0H18.0645C19.4876 0 20.6452 1.1576 20.6452 2.58065L20.6449 11.2321C22.1537 12.324 23.2514 13.9676 23.6143 15.9061C23.6214 15.9469 23.6277 15.989 23.6334 16.0402C23.7191 16.7624 24.1249 17.3921 24.7039 17.7713L24.2627 10.9301C24.2597 10.8801 24.258 10.8306 24.258 10.781V9.54851C24.258 8.86462 24.5606 8.25565 25.0318 7.8303C24.3018 7.3255 23.7419 6.39712 23.7419 5.16141C23.7419 2.29486 26.9857 0.639546 27.1242 0.57111L27.8709 0.19738V1.88492C27.8709 2.60661 28.0857 3.34712 28.5083 4.08793C28.7705 4.54619 28.9032 5.08102 28.9032 5.67755C28.9032 6.67206 28.5373 7.32964 28.0113 7.73286C28.5502 8.15868 28.9032 8.81001 28.9032 9.54852V10.7515C28.9032 10.8264 28.8991 10.9004 28.8924 10.975ZM26.8392 1.96042C26.0063 2.55282 24.7742 3.68052 24.7742 5.16137C24.7742 6.43671 25.5784 7.22588 26.3226 7.22588C27.0286 7.22588 27.871 6.95696 27.871 5.6775C27.871 5.26247 27.7837 4.90028 27.6125 4.59982C27.1132 3.72653 26.853 2.83879 26.8392 1.96042ZM26.3312 26.3222C26.3446 26.3212 26.3574 26.3183 26.3705 26.3179L27.8648 10.8753C27.8689 10.8345 27.871 10.7926 27.871 10.7513V9.54831C27.871 8.83656 27.2924 8.25798 26.5807 8.25798C25.8689 8.25798 25.2903 8.83658 25.2903 9.54831V10.3225H26.8387V11.3548H25.3244L26.2901 26.3196C26.2958 26.3196 26.3013 26.3203 26.3067 26.3211C26.312 26.3218 26.3172 26.3225 26.3226 26.3225C26.3255 26.3225 26.3283 26.3224 26.3312 26.3222ZM27.871 24.7742C27.871 24.4811 27.7844 24.2064 27.635 23.9679L27.4555 25.8219C27.7111 25.5458 27.871 25.1792 27.871 24.7742ZM25.2263 25.8663L25.0968 23.856C24.8966 24.1181 24.7742 24.4324 24.7742 24.7741C24.7742 25.2 24.947 25.5861 25.2263 25.8663ZM18.0645 1.03243H2.58061C1.7269 1.03243 1.03222 1.72711 1.03222 2.58082H19.6129C19.6129 1.72711 18.9182 1.03243 18.0645 1.03243ZM1.03222 25.2905C1.03222 26.1442 1.7269 26.8389 2.58061 26.8389H9.56222C9.41038 26.5043 9.27259 26.1617 9.16314 25.8066H7.22604V24.7744H8.91982C8.85946 24.4368 8.82144 24.0921 8.8007 23.7421H1.03222V25.2905ZM3.09674 18.0647H8.77416L8.77419 17.2905C8.77419 16.8497 8.82004 16.4202 8.89331 16.0002H3.09674V18.0647ZM2.06424 14.9679H9.14789L9.14794 14.9678C9.26499 14.6106 9.41062 14.2668 9.5779 13.9355H2.06424V9.80647H18.5804V10.1823C18.9366 10.2984 19.2813 10.4397 19.6126 10.6065V3.61307H1.03198V22.7098H8.77392V19.0969H2.06424V14.9679ZM10.2085 12.9034C10.8159 12.0677 11.5901 11.3642 12.4841 10.8389H3.09656V12.9034H10.2085ZM17.548 30.9679H25.0322L25.0323 30.9676C28.3047 30.9676 30.9674 28.3052 30.9674 25.0324C30.9674 22.9188 29.8165 20.9653 28.0271 19.9119L27.7624 22.6499C28.4679 23.1289 28.9029 23.9248 28.9029 24.7744C28.9029 26.1974 27.7453 27.355 26.3223 27.355C24.8992 27.355 23.7416 26.1974 23.7416 24.7744C23.7416 23.8728 24.229 23.0274 25.0128 22.5621L24.7806 18.9592C23.6146 18.5147 22.7601 17.4384 22.6082 16.1601L22.5979 16.0889C22.0299 13.0495 19.3626 10.8389 16.258 10.8389C12.7001 10.8389 9.80612 13.7332 9.80612 17.2908V23.226C9.80612 27.4949 13.2792 30.9679 17.548 30.9679ZM18.5807 4.64524H2.06457V8.77427H18.5807V4.64524ZM17.5484 7.74201H3.09683V5.67749H17.5484V7.74201ZM14.4516 19.0968C15.8747 19.0968 17.0323 17.9392 17.0323 16.5162C17.0323 15.0932 15.8747 13.9356 14.4516 13.9356C13.0286 13.9356 11.871 15.0932 11.871 16.5162C11.871 17.9392 13.0286 19.0968 14.4516 19.0968ZM14.4516 14.9678C15.3053 14.9678 16 15.6625 16 16.5162C16 17.3699 15.3053 18.0646 14.4516 18.0646C13.5979 18.0646 12.9033 17.3699 12.9033 16.5162C12.9033 15.6625 13.5979 14.9678 14.4516 14.9678ZM14.4516 20.1291C15.8747 20.1291 17.0323 21.2867 17.0323 22.7098C17.0323 24.1328 15.8747 25.2904 14.4516 25.2904C13.0286 25.2904 11.871 24.1328 11.871 22.7098C11.871 21.2867 13.0286 20.1291 14.4516 20.1291ZM12.9033 22.7098C12.9033 23.5635 13.5979 24.2581 14.4516 24.2581C15.3053 24.2581 16 23.5635 16 22.7098C16 21.856 15.3053 21.1614 14.4516 21.1614C13.5979 21.1614 12.9033 21.856 12.9033 22.7098ZM18.5807 24.7743C17.1577 24.7743 16.0001 25.9319 16.0001 27.3549C16.0001 28.778 17.1577 29.9356 18.5807 29.9356C20.0037 29.9356 21.1613 28.778 21.1613 27.3549C21.1613 25.9319 20.0037 24.7743 18.5807 24.7743ZM18.5807 28.9033C17.727 28.9033 17.0323 28.2086 17.0323 27.3549C17.0323 26.5012 17.727 25.8065 18.5807 25.8065C19.4344 25.8065 20.1291 26.5012 20.1291 27.3549C20.1291 28.2086 19.4344 28.9033 18.5807 28.9033Z"
      fill="url(#paint0_linear_1502_1691)"
    />
    <defs>
      <linearGradient
        id="paint0_linear_1502_1691"
        x1="16"
        y1="0"
        x2="16"
        y2="32"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
    </defs>
  </svg>
);

export default SvgUIFrameworks;
