import * as React from "react";
import type { SVGProps } from "react";

const SvgTutorial = ({ className, ...props }: SVGProps<SVGSVGElement>) => (
  <svg
    width="32"
    height="32"
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className ? className : undefined}
    {...props}
  >
    <g opacity="0.75">
      <path
        d="M17.3143 21.4187H14.6905C14.4474 21.4187 14.2539 21.2252 14.2539 20.982C14.2539 20.7389 14.4474 20.5454 14.6905 20.5454H17.3143C17.5574 20.5454 17.751 20.7389 17.751 20.982C17.751 21.2252 17.5574 21.4187 17.3143 21.4187Z"
        fill="url(#paint0_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.4266 6.72886C12.4266 8.69565 14.0333 10.3023 16.0045 10.3023C17.9713 10.3023 19.578 8.70456 19.578 6.72886C19.578 4.76208 17.9713 3.15986 16.0045 3.15986C14.0333 3.15986 12.4266 4.76208 12.4266 6.72886ZM13.3041 6.72892C13.3041 5.23917 14.5148 4.03747 16.0045 4.03747C17.4897 4.03747 18.7004 5.24815 18.7004 6.72892C18.7004 8.21415 17.4897 9.42929 16.0045 9.42929C14.5148 9.42929 13.3041 8.21415 13.3041 6.72892Z"
        fill="url(#paint1_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.13645 9.57766H9.13613C9.37924 9.57766 9.57279 9.38411 9.57279 9.14099V3.14131C9.57279 2.8982 9.37924 2.70465 9.13613 2.70465H3.13645C2.89334 2.70465 2.69978 2.8982 2.69978 3.14131V9.14099C2.69978 9.38411 2.89334 9.57766 3.13645 9.57766ZM8.69967 8.70457H3.57331V3.57821H8.69967V8.70457Z"
        fill="url(#paint2_linear_1502_1678)"
      />
      <path
        d="M28.8674 3.5782H22.9626C22.7195 3.5782 22.5259 3.38465 22.5259 3.14154C22.5259 2.89842 22.7195 2.70487 22.9626 2.70487H28.8674C29.1105 2.70487 29.3041 2.89842 29.3041 3.14154C29.3041 3.38465 29.1061 3.5782 28.8674 3.5782Z"
        fill="url(#paint3_linear_1502_1678)"
      />
      <path
        d="M22.9626 6.4898H28.8674C29.1061 6.4898 29.3041 6.29625 29.3041 6.05313C29.3041 5.81002 29.1105 5.61647 28.8674 5.61647H22.9626C22.7195 5.61647 22.5259 5.81002 22.5259 6.05313C22.5259 6.29625 22.7195 6.4898 22.9626 6.4898Z"
        fill="url(#paint4_linear_1502_1678)"
      />
      <path
        d="M28.8674 9.39763H22.9626C22.7195 9.39763 22.5259 9.20408 22.5259 8.96096C22.5259 8.71339 22.7195 8.51983 22.9626 8.51983H28.8674C29.1105 8.51983 29.3041 8.71338 29.3041 8.96096C29.3041 9.20408 29.1061 9.39763 28.8674 9.39763Z"
        fill="url(#paint5_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.9127 23.7367H1.87681C0.841637 23.7367 0.00443699 22.8996 0.00443699 21.8688V1.87237C0.00443699 0.841658 0.84158 0 1.87681 0H30.1321C31.1628 0 32 0.837143 32 1.87237V21.8688C32 22.8995 31.1629 23.7367 30.1321 23.7367H20.0883C20.6365 25.216 21.895 26.9742 23.2777 27.6255C23.4306 27.6977 23.5253 27.8506 23.5253 28.0171V29.3718C23.5342 29.6149 23.3362 29.8084 23.0933 29.8084H8.91149C8.66837 29.8084 8.47482 29.6149 8.47482 29.3718V28.0171C8.47482 27.8506 8.57394 27.693 8.7224 27.6255C10.1057 26.9778 11.3648 25.2219 11.9127 23.7367ZM12.4817 22.8677H1.87681C1.32341 22.8677 0.882271 22.4223 0.882271 21.8732V19.1007H31.1222V21.8732C31.1222 22.4221 30.6813 22.8677 30.1321 22.8677H19.5188C19.5028 22.8668 19.4867 22.8668 19.4705 22.8677H12.5298C12.5136 22.8668 12.4976 22.8668 12.4817 22.8677ZM0.882271 18.2229H7.24732C7.93452 14.91 10.4461 12.2506 13.7362 11.3957C13.8668 11.3598 14.0108 11.3912 14.1233 11.4767C15.2081 12.3588 16.7878 12.3588 17.877 11.4767C17.985 11.3912 18.129 11.3598 18.2641 11.3957C21.563 12.2509 24.0749 14.9101 24.7581 18.2229H31.1222V1.88129C31.1222 1.32764 30.681 0.877606 30.1321 0.877606H1.87681C1.32316 0.877606 0.882271 1.32767 0.882271 1.88129V18.2229ZM23.8623 18.2229H8.14199C8.79282 15.3757 10.9403 13.0988 13.754 12.2913C15.0909 13.241 16.9136 13.241 18.2458 12.2913C21.0595 13.1028 23.2106 15.3833 23.8623 18.2229ZM12.8327 23.7367C12.3058 25.3941 10.9434 27.4049 9.34343 28.2873V28.9398H22.6567V28.2873C21.0653 27.4049 19.6954 25.3941 19.1639 23.7367H12.8327Z"
        fill="url(#paint6_linear_1502_1678)"
      />
      <path
        d="M0.0125299 30.9737C0.0136461 30.9737 0.0145391 30.9735 0.0152088 30.9728V30.9692C0.0145391 30.9699 0.0136461 30.9706 0.0125299 30.971H0.00985096C0.00851152 30.971 0.00739526 30.9708 0.00627905 30.9701C0.00560931 30.969 0.00538607 30.9675 0.00538607 30.9657C0.00538607 30.9639 0.0056093 30.9628 0.00627905 30.9621C0.00739526 30.961 0.00851152 30.9603 0.00985096 30.9603H0.0125299C0.0136461 30.9603 0.0145391 30.961 0.0152088 30.9621V30.9585C0.0145391 30.9581 0.0136461 30.9576 0.0125299 30.9576C0.0118602 30.9572 0.0109672 30.9567 0.00985096 30.9567C0.00739497 30.9567 0.00538578 30.9576 0.00359982 30.9594C0.00181386 30.9612 0.000920885 30.9634 0.000920885 30.9657C0.000920885 30.9681 0.00181386 30.9701 0.00359982 30.9719C0.00538607 30.9733 0.00739526 30.9737 0.00985096 30.9737H0.0125299Z"
        fill="url(#paint7_linear_1502_1678)"
      />
      <path
        d="M0.0272638 30.9648C0.0272638 30.9643 0.0259243 30.9639 0.0254778 30.9639C0.0241383 30.9639 0.0232454 30.9646 0.0227989 30.9657V30.9737H0.018334V30.9612H0.0227989V30.9639C0.0227989 30.9628 0.0230221 30.9621 0.0236919 30.9621C0.0241383 30.9617 0.0250314 30.9612 0.0263708 30.9612L0.0272638 30.9648Z"
        fill="url(#paint8_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.0419421 30.9684C0.0419421 30.9666 0.0412724 30.9643 0.0401562 30.963C0.0388167 30.9619 0.0374772 30.9612 0.0356913 30.9612C0.0332356 30.9612 0.0314496 30.9619 0.0303334 30.963C0.0289939 30.9643 0.0285474 30.9657 0.0285474 30.9675C0.0285474 30.9692 0.0289939 30.9708 0.0303334 30.9719C0.0314496 30.9733 0.0332356 30.9737 0.0356913 30.9737H0.0383702C0.0394864 30.9737 0.0403794 30.9735 0.0410491 30.9728V30.9701C0.0405192 30.9701 0.0398494 30.9704 0.0390399 30.9708L0.0356913 30.971H0.0330123V30.9684H0.0419421ZM0.0365842 30.9648C0.0370307 30.9648 0.0374772 30.9655 0.0374772 30.9666H0.0330123V30.9648C0.0334588 30.9643 0.0343518 30.9639 0.0356913 30.9639C0.0361378 30.9639 0.0365842 30.9643 0.0365842 30.9648Z"
        fill="url(#paint9_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.0562856 30.9666V30.9737H0.0527137V30.9719C0.0520439 30.9726 0.051151 30.9733 0.0500348 30.9737H0.0482488C0.0469093 30.9737 0.0457931 30.9735 0.0446769 30.9728C0.0440071 30.9724 0.0437839 30.9715 0.0437839 30.9701C0.0437839 30.9684 0.0440071 30.9672 0.0446769 30.9666C0.0457931 30.9661 0.047579 30.9657 0.0500348 30.9657H0.0527137C0.0527137 30.9652 0.0522672 30.9648 0.0518207 30.9648C0.051151 30.9643 0.050258 30.9639 0.0491418 30.9639H0.0464628C0.0457931 30.9639 0.0451233 30.9643 0.0446769 30.9648V30.9621C0.0454864 30.9618 0.0468258 30.9612 0.0473558 30.9612H0.0500348C0.0522672 30.9612 0.0538299 30.9619 0.0544996 30.963C0.0556159 30.9637 0.0562856 30.9648 0.0562856 30.9666ZM0.0500345 30.9684C0.0493647 30.9684 0.048695 30.9688 0.0482485 30.9692V30.971H0.0518204C0.0522669 30.9706 0.0527134 30.9697 0.0527134 30.9684H0.0500345Z"
        fill="url(#paint10_linear_1502_1678)"
      />
      <path
        d="M0.0642666 30.9612V30.9576H0.0598017V30.9612H0.0580158V30.9639H0.0598017V30.9692C0.0598017 30.971 0.0600249 30.9724 0.0606947 30.9728C0.0618109 30.9735 0.0629271 30.9737 0.0642666 30.9737H0.0678385V30.971H0.0642666V30.9639H0.0678385V30.9612H0.0642666Z"
        fill="url(#paint11_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.0830471 30.9675L0.0741173 30.9684V30.971H0.0794752C0.0802847 30.9707 0.0816241 30.9701 0.0821541 30.9701V30.9728C0.0814844 30.9735 0.0805914 30.9737 0.0794752 30.9737H0.0767962C0.0743405 30.9737 0.0725546 30.9733 0.0714383 30.9719C0.0700989 30.9708 0.0696524 30.9692 0.0696524 30.9675C0.0696524 30.9657 0.0700989 30.9643 0.0714383 30.963C0.0725546 30.9619 0.0743405 30.9612 0.0767962 30.9612C0.0785822 30.9612 0.0799216 30.9619 0.0812611 30.963C0.0823773 30.9643 0.0830471 30.9657 0.0830471 30.9675ZM0.0785822 30.9666C0.0785822 30.9655 0.0781357 30.9648 0.0776892 30.9648C0.0776892 30.9643 0.0772427 30.9639 0.0767962 30.9639C0.0754568 30.9639 0.0745637 30.9643 0.0741173 30.9648V30.9666H0.0785822Z"
        fill="url(#paint12_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.0939861 30.9567V30.963C0.0939861 30.9625 0.0933163 30.9621 0.0922001 30.9621C0.0915304 30.9617 0.0908607 30.9612 0.0904142 30.9612C0.0886282 30.9612 0.0870655 30.9619 0.0859493 30.963C0.0852795 30.9643 0.0850563 30.9657 0.0850563 30.9675C0.0850563 30.9692 0.0852795 30.9708 0.0859493 30.9719C0.0870655 30.9733 0.0886282 30.9737 0.0904142 30.9737H0.0922001C0.0933163 30.9733 0.0939861 30.9726 0.0939861 30.9719V30.9737H0.098451V30.9567H0.0939861ZM0.0930931 30.9701C0.0930931 30.9708 0.0926466 30.971 0.0922001 30.971C0.0908607 30.971 0.0899676 30.9708 0.0895212 30.9701V30.9648C0.0899676 30.9643 0.0908607 30.9639 0.0922001 30.9639C0.0926466 30.9639 0.0930931 30.9643 0.0930931 30.9648C0.0935396 30.9654 0.0939861 30.9663 0.0939861 30.9675C0.0939861 30.9688 0.0935396 30.9697 0.0930931 30.9701Z"
        fill="url(#paint13_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.114301 30.963C0.114301 30.9625 0.114525 30.9621 0.115194 30.9621C0.116004 30.9618 0.117343 30.9612 0.117873 30.9612C0.119659 30.9612 0.120775 30.9619 0.121445 30.963C0.122561 30.9643 0.123231 30.9657 0.123231 30.9675C0.123231 30.9692 0.122561 30.9708 0.121445 30.9719C0.120775 30.9733 0.119659 30.9737 0.117873 30.9737H0.115194H0.109836V30.9567H0.114301V30.963ZM0.116087 30.971C0.117204 30.971 0.117873 30.9708 0.117873 30.9701C0.11832 30.9697 0.118766 30.9688 0.118766 30.9675C0.118766 30.9663 0.11832 30.9654 0.117873 30.9648C0.117873 30.9643 0.117204 30.9639 0.116087 30.9639C0.115418 30.9639 0.114748 30.9643 0.114301 30.9648V30.9701C0.114748 30.9708 0.115418 30.971 0.116087 30.971Z"
        fill="url(#paint14_linear_1502_1678)"
      />
      <path
        d="M0.128617 30.9612H0.124152L0.12951 30.9737C0.12951 30.9742 0.129063 30.9755 0.128617 30.9755H0.125938V30.9791H0.128617C0.129733 30.9791 0.130626 30.9786 0.131296 30.9782C0.131742 30.9775 0.132412 30.9764 0.133082 30.9746L0.13844 30.9612H0.133975L0.131296 30.9701L0.128617 30.9612Z"
        fill="url(#paint15_linear_1502_1678)"
      />
      <path
        d="M0.14843 30.9567H0.153788L0.158253 30.9657L0.161825 30.9567H0.167182V30.9737H0.162718V30.9621L0.159146 30.9701H0.156467L0.152895 30.9621V30.9737H0.14843V30.9567Z"
        fill="url(#paint16_linear_1502_1678)"
      />
      <path
        d="M0.174354 30.9612H0.170782V30.9684C0.170782 30.9701 0.171006 30.9717 0.171675 30.9728C0.172122 30.9735 0.173461 30.9737 0.175247 30.9737H0.177033L0.178819 30.9719V30.9737H0.183284V30.9612H0.178819V30.9675C0.178819 30.9688 0.178373 30.9697 0.177926 30.9701C0.177926 30.9708 0.17748 30.971 0.177033 30.971H0.175247C0.175247 30.971 0.174801 30.9699 0.174354 30.9692V30.9612Z"
        fill="url(#paint17_linear_1502_1678)"
      />
      <path
        d="M0.199358 30.9737H0.194893V30.9648C0.194893 30.9643 0.193553 30.9639 0.193107 30.9639C0.192437 30.9639 0.191767 30.9643 0.191321 30.9648V30.9737H0.186856V30.9567H0.191321V30.963C0.191321 30.9625 0.191544 30.9621 0.192214 30.9621C0.19333 30.9617 0.194223 30.9612 0.194893 30.9612C0.196009 30.9612 0.196902 30.9619 0.197572 30.963C0.198688 30.9637 0.199358 30.9648 0.199358 30.9666V30.9737Z"
        fill="url(#paint18_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.21451 30.9737V30.9666C0.21451 30.9648 0.213841 30.9637 0.212724 30.963C0.212055 30.9619 0.210492 30.9612 0.20826 30.9612H0.205581C0.205051 30.9612 0.204381 30.9615 0.203571 30.9618L0.202902 30.9648C0.203348 30.9643 0.204018 30.9639 0.204688 30.9639H0.207367C0.208483 30.9639 0.209376 30.9643 0.210046 30.9648C0.210492 30.9648 0.210938 30.9652 0.210938 30.9657H0.20826C0.205804 30.9657 0.204018 30.9661 0.202902 30.9666C0.202232 30.9672 0.202009 30.9684 0.202009 30.9701C0.202009 30.9715 0.202232 30.9724 0.202902 30.9728C0.204018 30.9735 0.205134 30.9737 0.206474 30.9737H0.20826C0.209376 30.9733 0.210269 30.9726 0.210938 30.9719V30.9737H0.21451ZM0.206473 30.9692C0.20692 30.9688 0.20759 30.9684 0.208259 30.9684H0.210938C0.210938 30.9697 0.210492 30.9706 0.210045 30.971H0.207366L0.206473 30.9692Z"
        fill="url(#paint19_linear_1502_1678)"
      />
      <path
        d="M0.229691 30.9639C0.230138 30.9628 0.230807 30.9621 0.231477 30.9621C0.231924 30.9617 0.232593 30.9612 0.233263 30.9612C0.235049 30.9612 0.236165 30.9619 0.236835 30.963C0.237281 30.9637 0.237728 30.9648 0.237728 30.9666V30.9737H0.234156V30.9675C0.234156 30.967 0.233709 30.9655 0.233263 30.9648C0.233263 30.9643 0.232816 30.9639 0.23237 30.9639C0.2317 30.9639 0.23103 30.9643 0.230584 30.9648C0.229914 30.9655 0.229691 30.9663 0.229691 30.9675V30.9737H0.226119V30.9675C0.226119 30.9663 0.225673 30.9655 0.225226 30.9648C0.225226 30.9643 0.22478 30.9639 0.224333 30.9639C0.223663 30.9639 0.222994 30.9643 0.222547 30.9648V30.9737H0.218082V30.9612H0.222547V30.963C0.222547 30.9625 0.22277 30.9621 0.22344 30.9621C0.223887 30.9617 0.22478 30.9612 0.226119 30.9612C0.226566 30.9612 0.227235 30.9617 0.227905 30.9621C0.228352 30.9621 0.229021 30.9628 0.229691 30.9639Z"
        fill="url(#paint20_linear_1502_1678)"
      />
      <path
        d="M0.254918 30.9621C0.254248 30.9621 0.253578 30.9628 0.253132 30.9639C0.252462 30.9628 0.251792 30.9621 0.251346 30.9621C0.250676 30.9617 0.250006 30.9612 0.24956 30.9612C0.24822 30.9612 0.247327 30.9617 0.246881 30.9621C0.246211 30.9621 0.245988 30.9625 0.245988 30.963V30.9612H0.241523V30.9737H0.245988V30.9648C0.246434 30.9643 0.247104 30.9639 0.247774 30.9639C0.24822 30.9639 0.248667 30.9643 0.248667 30.9648C0.249113 30.9655 0.24956 30.9663 0.24956 30.9675V30.9737H0.253132V30.9675C0.253132 30.9663 0.253355 30.9655 0.254025 30.9648C0.254471 30.9643 0.255141 30.9639 0.255811 30.9639C0.256257 30.9639 0.256704 30.9643 0.256704 30.9648C0.25715 30.9655 0.257597 30.9661 0.257597 30.9666V30.9737H0.261169V30.9666C0.261169 30.9648 0.260722 30.9637 0.260276 30.963C0.259606 30.9619 0.25849 30.9612 0.256704 30.9612C0.256034 30.9612 0.255364 30.9617 0.254918 30.9621Z"
        fill="url(#paint21_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.276628 30.9666V30.9737H0.273056V30.9719C0.272387 30.9726 0.271494 30.9733 0.270377 30.9737H0.268591C0.267252 30.9737 0.266136 30.9735 0.26502 30.9728C0.26435 30.9724 0.264127 30.9715 0.264127 30.9701C0.264127 30.9684 0.26435 30.9672 0.26502 30.9666C0.266136 30.9661 0.267922 30.9657 0.270377 30.9657H0.273056C0.273056 30.9652 0.27261 30.9648 0.272163 30.9648C0.271494 30.9643 0.270601 30.9639 0.269484 30.9639H0.266805L0.26557 30.9643L0.26502 30.9621C0.265829 30.9618 0.267169 30.9612 0.267698 30.9612H0.270377C0.27261 30.9612 0.274173 30.9619 0.274842 30.963C0.275959 30.9637 0.276628 30.9648 0.276628 30.9666ZM0.270377 30.9684C0.269707 30.9684 0.269038 30.9688 0.268591 30.9692V30.971H0.272163C0.27261 30.9706 0.273056 30.9697 0.273056 30.9684H0.270377Z"
        fill="url(#paint22_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.288209 30.9567V30.963C0.288209 30.9625 0.287539 30.9621 0.286423 30.9621C0.285753 30.9617 0.285084 30.9612 0.284637 30.9612C0.282851 30.9612 0.281288 30.9619 0.280172 30.963C0.279503 30.9643 0.279279 30.9657 0.279279 30.9675C0.279279 30.9692 0.279503 30.9708 0.280172 30.9719C0.281288 30.9733 0.282851 30.9737 0.284637 30.9737H0.286423C0.287539 30.9733 0.288209 30.9726 0.288209 30.9719V30.9737H0.292674V30.9567H0.288209ZM0.287316 30.9701C0.287316 30.9708 0.28687 30.971 0.286423 30.971C0.285084 30.971 0.284191 30.9708 0.283744 30.9701V30.9648C0.284191 30.9643 0.285084 30.9639 0.286423 30.9639C0.28687 30.9639 0.287316 30.9643 0.287316 30.9648C0.287763 30.9654 0.288209 30.9663 0.288209 30.9675C0.288209 30.9688 0.287763 30.9697 0.287316 30.9701Z"
        fill="url(#paint23_linear_1502_1678)"
      />
      <path
        d="M0.315668 30.9576V30.9612C0.314998 30.9608 0.314105 30.9603 0.312989 30.9603H0.31031C0.309641 30.9603 0.308971 30.9608 0.308524 30.9612C0.307855 30.9612 0.307631 30.9617 0.307631 30.9621L0.308971 30.9634L0.31031 30.9639H0.312096C0.313882 30.9639 0.314998 30.9646 0.315668 30.9657C0.316115 30.9663 0.316561 30.9672 0.316561 30.9683C0.316561 30.9701 0.315891 30.9717 0.314775 30.9728C0.314105 30.9735 0.312543 30.9737 0.31031 30.9737H0.306738C0.306069 30.9737 0.305176 30.9735 0.304059 30.9728V30.9692L0.306738 30.971H0.312096C0.312543 30.9706 0.312989 30.9699 0.312989 30.9692C0.313237 30.9694 0.312989 30.969 0.312989 30.9692L0.312096 30.9683C0.312096 30.9679 0.311427 30.9675 0.31031 30.9675H0.308524C0.306738 30.967 0.305399 30.9663 0.304952 30.9657C0.304283 30.9646 0.304059 30.9634 0.304059 30.9621C0.304059 30.9603 0.304506 30.9592 0.305845 30.9585C0.306962 30.9574 0.308524 30.9567 0.31031 30.9567L0.312096 30.9576H0.315668Z"
        fill="url(#paint24_linear_1502_1678)"
      />
      <path
        d="M0.328421 30.9737H0.332886V30.9666C0.332886 30.9648 0.332216 30.9637 0.3311 30.963C0.33043 30.9619 0.329537 30.9612 0.328421 30.9612C0.327751 30.9612 0.326858 30.9617 0.325742 30.9621C0.325072 30.9621 0.324849 30.9625 0.324849 30.963V30.9567H0.320384V30.9737H0.324849V30.9648C0.325296 30.9643 0.325965 30.9639 0.326635 30.9639C0.327082 30.9639 0.327528 30.9643 0.327528 30.9648L0.328421 30.9666V30.9737Z"
        fill="url(#paint25_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.347788 30.9666V30.9737H0.344216V30.9719C0.343546 30.9726 0.342653 30.9733 0.341537 30.9737H0.339751C0.338411 30.9737 0.337295 30.9735 0.336179 30.9728C0.335509 30.9724 0.335286 30.9715 0.335286 30.9701C0.335286 30.9684 0.335509 30.9672 0.336179 30.9666C0.337295 30.9661 0.339081 30.9657 0.341537 30.9657H0.344216C0.344216 30.9652 0.343769 30.9648 0.343323 30.9648C0.342653 30.9643 0.34176 30.9639 0.340644 30.9639H0.337965L0.336179 30.9648V30.9621C0.337295 30.9617 0.338188 30.9612 0.338858 30.9612H0.341537C0.343769 30.9612 0.345332 30.9619 0.346002 30.963C0.347118 30.9637 0.347788 30.9648 0.347788 30.9666ZM0.340652 30.9686L0.33975 30.9692V30.971H0.343322C0.343769 30.9706 0.344215 30.9697 0.344215 30.9684L0.340652 30.9686Z"
        fill="url(#paint26_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.356717 30.9621C0.356048 30.9621 0.355824 30.9625 0.355824 30.963V30.9567H0.351359V30.9737H0.355824H0.359396C0.361182 30.9737 0.362298 30.9733 0.362968 30.9719C0.364084 30.9708 0.364754 30.9692 0.364754 30.9675C0.364754 30.9657 0.364084 30.9643 0.362968 30.963C0.362298 30.9619 0.361182 30.9612 0.359396 30.9612L0.358206 30.9615L0.356717 30.9621ZM0.359396 30.9701C0.359396 30.9708 0.358727 30.971 0.35761 30.971C0.356941 30.971 0.356271 30.9708 0.355824 30.9701V30.9648L0.356791 30.9641C0.357907 30.9641 0.359396 30.9643 0.359396 30.9648C0.359843 30.9654 0.360289 30.9663 0.360289 30.9675C0.360289 30.9688 0.359843 30.9697 0.359396 30.9701Z"
        fill="url(#paint27_linear_1502_1678)"
      />
      <path
        d="M0.376614 30.9648C0.376614 30.9643 0.375275 30.9639 0.374828 30.9639C0.373489 30.9639 0.372596 30.9646 0.372149 30.9657V30.9737H0.367684V30.9612H0.372149V30.9639C0.372149 30.9628 0.372372 30.9621 0.373042 30.9621C0.373489 30.9617 0.374382 30.9612 0.375721 30.9612L0.376614 30.9648Z"
        fill="url(#paint28_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.390232 30.9737V30.9666C0.390232 30.9648 0.389562 30.9637 0.388446 30.963C0.387776 30.9619 0.386214 30.9612 0.383981 30.9612H0.381302L0.379676 30.9617L0.378623 30.9621V30.9648C0.37907 30.9643 0.379739 30.9639 0.380409 30.9639H0.383088C0.384204 30.9639 0.385097 30.9643 0.385767 30.9648C0.386214 30.9648 0.38666 30.9652 0.38666 30.9657H0.383981C0.381525 30.9657 0.379739 30.9661 0.378623 30.9666C0.377954 30.9672 0.37773 30.9684 0.37773 30.9701C0.37773 30.9715 0.377953 30.9724 0.378623 30.9728C0.379739 30.9735 0.380856 30.9737 0.382195 30.9737H0.383981C0.385097 30.9733 0.38599 30.9726 0.38666 30.9719V30.9737H0.390232ZM0.38338 30.9685L0.38666 30.9684C0.38666 30.9697 0.386213 30.9706 0.385767 30.971H0.383088L0.382195 30.9701C0.382506 30.9698 0.382927 30.9686 0.38338 30.9685Z"
        fill="url(#paint29_linear_1502_1678)"
      />
      <path
        d="M0.393804 30.9612H0.398269V30.9737H0.393804V30.9612Z"
        fill="url(#paint30_linear_1502_1678)"
      />
      <path
        d="M0.393804 30.9567H0.398269V30.9594H0.393804V30.9567Z"
        fill="url(#paint31_linear_1502_1678)"
      />
      <path
        d="M0.411468 30.9612H0.401645L0.401646 30.9639H0.407004L0.400752 30.971V30.9737H0.411468V30.971H0.405217L0.411468 30.9639V30.9612Z"
        fill="url(#paint32_linear_1502_1678)"
      />
      <path
        d="M0.00982277 30.9793V30.982H0.00625086V30.9838H0.00982277V30.9864H0.00625086V30.9963H0.00267894V30.9864H0V30.9838H0.00267894C0.00267894 30.9826 0.00290218 30.9809 0.00357192 30.9802C0.00401841 30.9797 0.00535788 30.9793 0.00714384 30.9793H0.00982277Z"
        fill="url(#paint33_linear_1502_1678)"
      />
      <path
        d="M0.0196735 30.9873L0.0205664 30.9838C0.019227 30.9838 0.017441 30.9842 0.0169945 30.9846C0.0163248 30.9846 0.0161015 30.9853 0.0161015 30.9864V30.9838H0.0116366V30.9963H0.0161015V30.9882C0.0165481 30.9871 0.017441 30.9864 0.0187805 30.9864C0.0192269 30.9864 0.0196735 30.9869 0.0196735 30.9873Z"
        fill="url(#paint34_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.0289939 30.9838C0.0307799 30.9838 0.0321193 30.9844 0.0334588 30.9855C0.034575 30.9869 0.0352448 30.9882 0.0352448 30.99C0.0352448 30.9918 0.034575 30.9934 0.0334588 30.9945C0.0321193 30.9958 0.0307799 30.9963 0.0289939 30.9963C0.0265382 30.9963 0.0247523 30.9958 0.023636 30.9945C0.0222965 30.9934 0.0218501 30.9918 0.0218501 30.99C0.0218501 30.9882 0.0222966 30.9869 0.023636 30.9855C0.0247523 30.9844 0.0265382 30.9838 0.0289939 30.9838ZM0.0289939 30.9864C0.0276545 30.9864 0.0267614 30.9869 0.026315 30.9873V30.9927C0.0267614 30.9934 0.0276545 30.9936 0.0289939 30.9936C0.0294404 30.9936 0.0301101 30.9934 0.0307799 30.9927C0.0312264 30.9922 0.0316729 30.9913 0.0316729 30.99C0.0316729 30.9889 0.0312264 30.988 0.0307799 30.9873C0.0301101 30.9869 0.0294404 30.9864 0.0289939 30.9864Z"
        fill="url(#paint35_linear_1502_1678)"
      />
      <path
        d="M0.0515696 30.9846C0.0508998 30.9846 0.0502301 30.9853 0.0497836 30.9864C0.0491139 30.9853 0.0484442 30.9846 0.0479976 30.9846C0.0473279 30.9842 0.0466582 30.9838 0.0462117 30.9838C0.0448722 30.9838 0.0439792 30.9842 0.0435327 30.9846C0.042863 30.9846 0.0426398 30.9851 0.0426398 30.9855V30.9838H0.0381749V30.9963H0.0426398V30.9873C0.0430863 30.9869 0.043756 30.9864 0.0444257 30.9864C0.0448722 30.9864 0.0453187 30.9869 0.0453187 30.9873C0.0457652 30.988 0.0462117 30.9889 0.0462117 30.99V30.9963H0.0497836V30.99C0.0497836 30.9889 0.0500068 30.988 0.0506766 30.9873C0.051123 30.9869 0.0517928 30.9864 0.0524625 30.9864C0.052909 30.9864 0.0533555 30.9869 0.0533555 30.9873C0.053802 30.988 0.0542485 30.9887 0.0542485 30.9891V30.9963H0.0578204V30.9891C0.0578204 30.9873 0.057374 30.9862 0.0569274 30.9855C0.0562577 30.9844 0.0551415 30.9838 0.0533555 30.9838C0.0526858 30.9838 0.0520161 30.9842 0.0515696 30.9846Z"
        fill="url(#paint36_linear_1502_1678)"
      />
      <path
        d="M0.073894 30.9802V30.9838H0.077466V30.9864H0.073894V30.9936H0.077466V30.9963H0.073894C0.0725545 30.9963 0.0714383 30.996 0.0703221 30.9954C0.0696524 30.9949 0.0694291 30.9936 0.0694291 30.9918V30.9864H0.0676432V30.9838H0.0694291V30.9802H0.073894Z"
        fill="url(#paint37_linear_1502_1678)"
      />
      <path
        d="M0.0926187 30.9963V30.9891C0.0926187 30.9873 0.091949 30.9862 0.0908327 30.9855C0.090163 30.9844 0.08927 30.9838 0.0881538 30.9838C0.0876238 30.9838 0.0869541 30.984 0.0861446 30.9844C0.0854748 30.9844 0.0845819 30.9851 0.0845819 30.9855V30.9793H0.080117V30.9963H0.0845819V30.9873C0.0850284 30.9869 0.0856981 30.9864 0.0863679 30.9864C0.0868144 30.9864 0.0872608 30.9869 0.0872608 30.9873L0.0881538 30.9891V30.9963H0.0926187Z"
        fill="url(#paint38_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.108748 30.99L0.0998183 30.9909V30.9936H0.105176C0.105986 30.9932 0.107325 30.9927 0.107855 30.9927V30.9954C0.107185 30.996 0.106292 30.9963 0.105176 30.9963H0.102497C0.100042 30.9963 0.0982556 30.9958 0.0971394 30.9945C0.0957999 30.9934 0.0953535 30.9918 0.0953535 30.99C0.0953535 30.9882 0.0957999 30.9869 0.0971394 30.9855C0.0982556 30.9844 0.100042 30.9838 0.102497 30.9838C0.104283 30.9838 0.105623 30.9844 0.106962 30.9855C0.108078 30.9869 0.108748 30.9882 0.108748 30.99ZM0.104283 30.9891C0.104283 30.988 0.103837 30.9873 0.10339 30.9873C0.10339 30.9869 0.102944 30.9864 0.102497 30.9864C0.101158 30.9864 0.100265 30.9869 0.0998183 30.9873V30.9891H0.104283Z"
        fill="url(#paint39_linear_1502_1678)"
      />
      <path
        d="M0.129929 30.9909L0.123678 30.9793H0.119213L0.119213 30.9963H0.123678V30.9847L0.129036 30.9963H0.134394V30.9793H0.129929V30.9909Z"
        fill="url(#paint40_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.144439 30.9838C0.146225 30.9838 0.147565 30.9844 0.148904 30.9855C0.150021 30.9869 0.15069 30.9882 0.15069 30.99C0.15069 30.9918 0.150021 30.9934 0.148904 30.9945C0.147565 30.9958 0.146225 30.9963 0.144439 30.9963C0.141984 30.9963 0.140198 30.9958 0.139082 30.9945C0.137742 30.9934 0.137296 30.9918 0.137296 30.99C0.137296 30.9882 0.137742 30.9869 0.139082 30.9855C0.140198 30.9844 0.141984 30.9838 0.144439 30.9838ZM0.144439 30.9864C0.1431 30.9864 0.142207 30.9869 0.14176 30.9873V30.9927C0.142207 30.9934 0.1431 30.9936 0.144439 30.9936C0.144886 30.9936 0.145556 30.9934 0.146225 30.9927C0.146672 30.9922 0.147118 30.9913 0.147118 30.99C0.147118 30.9889 0.146672 30.988 0.146225 30.9873C0.145556 30.9869 0.144886 30.9864 0.144439 30.9864Z"
        fill="url(#paint41_linear_1502_1678)"
      />
      <path
        d="M0.157192 30.9838H0.15362V30.9909C0.15362 30.9927 0.153844 30.9942 0.154513 30.9954C0.15496 30.996 0.156299 30.9963 0.158085 30.9963H0.159871L0.161657 30.9945V30.9963H0.166122V30.9838H0.161657V30.99C0.161657 30.9913 0.161211 30.9922 0.160764 30.9927C0.160764 30.9934 0.160318 30.9936 0.159871 30.9936H0.158085C0.158085 30.9936 0.157639 30.9925 0.157192 30.9918V30.9838Z"
        fill="url(#paint42_linear_1502_1678)"
      />
      <path
        d="M0.182196 30.9891V30.9963H0.177731V30.9873C0.177731 30.9869 0.176391 30.9864 0.175945 30.9864C0.175275 30.9864 0.174605 30.9869 0.174159 30.9873V30.9963H0.169694V30.9838H0.174159V30.9855C0.174159 30.9851 0.174382 30.9846 0.175052 30.9846C0.175861 30.9843 0.177201 30.9838 0.177731 30.9838C0.178847 30.9838 0.17974 30.9844 0.18041 30.9855C0.181526 30.9862 0.182196 30.9873 0.182196 30.9891Z"
        fill="url(#paint43_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.200697 30.9793H0.193553V30.9963H0.198018V30.9909H0.200697C0.20293 30.9909 0.204492 30.9907 0.205162 30.99C0.206278 30.9889 0.206948 30.9873 0.206948 30.9855C0.206948 30.9838 0.206278 30.9824 0.205162 30.9811C0.204492 30.98 0.20293 30.9793 0.200697 30.9793ZM0.198018 30.9873V30.9829H0.200697C0.201144 30.9829 0.201813 30.9833 0.202483 30.9838C0.20293 30.9838 0.203376 30.9844 0.203376 30.9855C0.203376 30.9862 0.20293 30.9869 0.202483 30.9873H0.198018Z"
        fill="url(#paint44_linear_1502_1678)"
      />
      <path
        d="M0.218808 30.9873C0.218808 30.9869 0.217468 30.9864 0.217022 30.9864C0.215682 30.9864 0.214789 30.9871 0.214343 30.9882V30.9963H0.209878V30.9838H0.214343V30.9864C0.214343 30.9853 0.214566 30.9846 0.215236 30.9846C0.215682 30.9842 0.216575 30.9838 0.217915 30.9838L0.218808 30.9873Z"
        fill="url(#paint45_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.2317 30.9855C0.230361 30.9844 0.229021 30.9838 0.227235 30.9838C0.22478 30.9838 0.222994 30.9844 0.221877 30.9855C0.220538 30.9869 0.220092 30.9882 0.220092 30.99C0.220092 30.9918 0.220538 30.9934 0.221877 30.9945C0.222994 30.9958 0.22478 30.9963 0.227235 30.9963C0.229021 30.9963 0.230361 30.9958 0.2317 30.9945C0.232816 30.9934 0.233486 30.9918 0.233486 30.99C0.233486 30.9882 0.232816 30.9869 0.2317 30.9855ZM0.224556 30.9873C0.225003 30.9869 0.225896 30.9864 0.227235 30.9864C0.227682 30.9864 0.228352 30.9869 0.229021 30.9873C0.229468 30.988 0.229914 30.9889 0.229914 30.99C0.229914 30.9913 0.229468 30.9922 0.229021 30.9927C0.228352 30.9934 0.227682 30.9936 0.227235 30.9936C0.225896 30.9936 0.225003 30.9934 0.224556 30.9927V30.9873Z"
        fill="url(#paint46_linear_1502_1678)"
      />
      <path
        d="M0.236416 30.9838H0.240881V30.9963C0.240881 30.9974 0.240211 30.9985 0.239095 30.9998C0.238425 31.0009 0.237309 31.0016 0.235523 31.0016H0.233737V30.998H0.235523C0.23597 30.998 0.236416 30.9974 0.236416 30.9963V30.9838Z"
        fill="url(#paint47_linear_1502_1678)"
      />
      <path
        d="M0.236416 30.9793H0.240881V30.982H0.236416V30.9793Z"
        fill="url(#paint48_linear_1502_1678)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.256759 30.9909C0.256759 30.9891 0.25609 30.9869 0.254974 30.9855C0.253634 30.9844 0.252295 30.9838 0.250509 30.9838C0.248053 30.9838 0.246267 30.9844 0.245151 30.9855C0.243811 30.9869 0.243365 30.9882 0.243365 30.99C0.243365 30.9918 0.243811 30.9934 0.245151 30.9945C0.246267 30.9958 0.248053 30.9963 0.250509 30.9963H0.253188C0.254304 30.9963 0.255197 30.996 0.255866 30.9954V30.9927C0.255337 30.9927 0.254667 30.993 0.253857 30.9933L0.250509 30.9936H0.24783V30.9909H0.256759ZM0.251402 30.9873C0.251848 30.9873 0.252295 30.988 0.252295 30.9891H0.24783V30.9873C0.248276 30.9869 0.249169 30.9864 0.250509 30.9864C0.250955 30.9864 0.251402 30.9869 0.251402 30.9873Z"
        fill="url(#paint49_linear_1502_1678)"
      />
      <path
        d="M0.269233 30.9846V30.9873H0.267447C0.267447 30.9869 0.266778 30.9864 0.265661 30.9864C0.264992 30.9864 0.264322 30.9869 0.263875 30.9873C0.263206 30.988 0.262982 30.9889 0.262982 30.99C0.262982 30.9913 0.263206 30.9922 0.263875 30.9927C0.264322 30.9934 0.264992 30.9936 0.265661 30.9936H0.26834L0.269233 30.9927V30.9963H0.265661C0.263206 30.9963 0.26142 30.9958 0.260303 30.9945C0.258964 30.9934 0.258518 30.9918 0.258518 30.99C0.258518 30.9882 0.258964 30.9869 0.260303 30.9855C0.26142 30.9844 0.263206 30.9838 0.265661 30.9838H0.267447C0.267894 30.9838 0.268564 30.9842 0.269233 30.9846Z"
        fill="url(#paint50_linear_1502_1678)"
      />
      <path
        d="M0.277242 30.9838V30.9802H0.272777V30.9838H0.270991V30.9864H0.272777V30.9918C0.272777 30.9936 0.273001 30.9949 0.27367 30.9954C0.274786 30.996 0.275903 30.9963 0.277242 30.9963H0.280814V30.9936H0.277242V30.9864H0.280814V30.9838H0.277242Z"
        fill="url(#paint51_linear_1502_1678)"
      />
    </g>
    <defs>
      <linearGradient
        id="paint0_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint1_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint2_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint3_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint4_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint5_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint6_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint7_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint8_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint9_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint10_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint11_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint12_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint13_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint14_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint15_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint16_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint17_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint18_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint19_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint20_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint21_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint22_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint23_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint24_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint25_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint26_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint27_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint28_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint29_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint30_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint31_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint32_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint33_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint34_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint35_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint36_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint37_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint38_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint39_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint40_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint41_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint42_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint43_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint44_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint45_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint46_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint47_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint48_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint49_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint50_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
      <linearGradient
        id="paint51_linear_1502_1678"
        x1="16"
        y1="0"
        x2="16"
        y2="31.0016"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
    </defs>
  </svg>
);

export default SvgTutorial;
