import clsx from "clsx";
import * as React from "react";
import type { SVGProps } from "react";

const SvgElideGraphql = ({ className, ...props }: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={48}
    height={48}
    viewBox="0 0 48 48"
    fill="none"
    className={clsx(
      "dark:text-[#ffffff] dark:fill-[#14141f] text-[#14141f] fill-[#ffffff]",
      className,
    )}
    {...props}
  >
    <path
      fill="currentColor"
      d="M24 21.143c5.8 0 10.5 1.279 10.5 2.857 0 .732-1.01 1.4-2.673 1.905-1.923.584-4.717.952-7.827.952-3.11 0-5.904-.367-7.826-.952C14.51 25.399 13.5 24.732 13.5 24c0-1.578 4.701-2.857 10.5-2.857Zm10.5 20C34.5 42.721 29.8 44 24 44c-5.799 0-10.5-1.28-10.5-2.857v-3.81c0 1.578 4.701 2.857 10.5 2.857 5.8 0 10.5-1.279 10.5-2.857v3.81Zm0-5.714c0 1.578-4.7 2.857-10.5 2.857-5.799 0-10.5-1.28-10.5-2.857v-3.81c0 1.578 4.701 2.857 10.5 2.857 5.8 0 10.5-1.279 10.5-2.857v3.81Zm0-5.715c0 1.578-4.7 2.858-10.5 2.858-5.799 0-10.5-1.28-10.5-2.858v-3.81c0 1.579 4.701 2.858 10.5 2.858 5.8 0 10.5-1.28 10.5-2.857v3.81ZM29.256 19.238H17.71c-1.16 0-2.151-.426-2.975-1.278-.823-.853-1.235-1.879-1.235-3.08 0-1.008.294-1.9.882-2.674a4.09 4.09 0 0 1 2.27-1.526v-.157c0-1.809.617-3.348 1.852-4.618C19.74 4.635 21.224 4 22.954 4c1.344 0 2.559.404 3.643 1.213a6.394 6.394 0 0 1 2.281 3.17c1.547-.121 2.87.353 3.97 1.423 1.102 1.07 1.652 2.396 1.652 3.979 0 1.496-.512 2.779-1.538 3.848-1.025 1.07-2.26 1.605-3.706 1.605Zm-11.647-6.55c-.537 0-1.008.218-1.411.653a2.19 2.19 0 0 0-.605 1.54c0 .591.206 1.1.617 1.526.412.426.912.64 1.5.64h11.546c.874 0 1.618-.318 2.232-.953.613-.635.92-1.404.92-2.31 0-.904-.307-1.674-.92-2.309-.614-.634-1.358-.952-2.232-.952-.252 0-.537.052-.857.157l-1.134.34-.177-1.201c-.184-1.044-.663-1.91-1.437-2.597a3.936 3.936 0 0 0-2.697-1.03c-1.16 0-2.151.422-2.975 1.265-.823.844-1.235 1.866-1.235 3.066 0 .209.033.505.1.887l.253 1.305-1.488-.026Z"
    />
    <rect width={24} height={24} x={24} y={24} fill="currentFill" rx={12} />
    <path
      fill="#E535AB"
      d="m29.59 39.855.587.339L36.72 28.86l-.587-.339-6.544 11.334Z"
    />
    <path fill="#E535AB" d="M42.541 38.95H29.455v.678H42.54v-.678Z" />
    <path
      fill="#E535AB"
      d="m29.714 39.33 6.546 3.78.339-.587-6.546-3.78-.34.588Zm5.687-9.85 6.545 3.78.34-.587-6.547-3.78-.338.588Z"
    />
    <path
      fill="#E535AB"
      d="m29.716 32.67.339.587 6.545-3.779-.339-.587-6.545 3.78Z"
    />
    <path
      fill="#E535AB"
      d="m35.282 28.861 6.543 11.333.588-.339-6.544-11.333-.587.339Zm-4.63 3.36h-.678v7.558h.678v-7.558Z"
    />
    <path fill="#E535AB" d="M42.027 32.22h-.678v7.56h.678v-7.56Z" />
    <path
      fill="#E535AB"
      d="m35.848 42.31.296.513 5.693-3.287-.296-.513-5.693 3.287Z"
    />
    <path
      fill="#E535AB"
      d="M42.926 40a1.428 1.428 0 0 1-2.472-1.426 1.428 1.428 0 0 1 2.652.899 1.422 1.422 0 0 1-.18.527Zm-11.383-6.574a1.429 1.429 0 0 1-1.95.523 1.428 1.428 0 0 1 1.427-2.472 1.43 1.43 0 0 1 .523 1.949ZM29.075 40a1.43 1.43 0 0 1 .523-1.949 1.43 1.43 0 0 1 1.949.523 1.43 1.43 0 0 1-.523 1.949 1.427 1.427 0 0 1-1.95-.523Zm11.383-6.574a1.43 1.43 0 0 1 .523-1.949 1.429 1.429 0 0 1 1.95.523 1.429 1.429 0 0 1-.524 1.949 1.428 1.428 0 0 1-1.949-.523ZM36.001 44a1.424 1.424 0 0 1-1.319-1.972A1.425 1.425 0 1 1 36.001 44Zm0-13.148a1.424 1.424 0 0 1-1.319-1.972 1.425 1.425 0 0 1 2.327-.463 1.423 1.423 0 0 1 .31 1.555 1.423 1.423 0 0 1-1.319.88Z"
    />
  </svg>
);

export default SvgElideGraphql;
