---
title: List of Packages
---

- `@refinedev/core` - Collection of `hooks`, `components` and `providers` for **authentication**, **access control**, **routing**, **networking**, **state management** and **i18n**. Your starting point for headless projects.
- `@refinedev/inferencer` - Provides a way to automatically generate views for resources based on the data structure. The aim is to reduce the amount of time spent on creating views for resources by generating the code automatically that can be customized easily.
- `@refinedev/cli` - It is a tool that allows you to perform important commands while developing with refine.

### UI Framework Packages:

To learn more about UI Libraries and integrations, check out [UI Libraries](/docs/guides-concepts/ui-libraries) guide.

- [`@refinedev/antd`](/docs/ui-integrations/ant-design/introduction) - [Ant Design](https://ant.design/) System UI Framework support. **20+** framework-specific `hooks` and  `components`  incl. Table, Form, Select, Menu, Layout, Notification and CRUD components.
- [`@refinedev/mui`](/docs/ui-integrations/material-ui/introduction) - [Material UI](https://mui.com/material-ui/getting-started/overview/) Framework support. **20+** framework-specific `hooks` and  `components`  incl. DataGrid (+ Pro), AutoComplete, Menu, Layout, Notification and CRUD components.
- [`@refinedev/mantine`](/docs/ui-integrations/mantine/introduction) - [Mantine](https://mantine.dev/) UI Framework support. **20+** framework-specific `hooks` and `components` incl. Table, Form, AutoComplete, Menu, Layout, Notification and CRUD components.
- [`@refinedev/chakra-ui`](/docs/ui-integrations/chakra-ui/introduction) - [Chakra UI](https://chakra-ui.com/) UI Framework support. **20+** framework-specific `components` incl. Menu, Layout, Notification and CRUD components.
- [`@ferdiunal/refine-shadcn`](https://github.com/ferdiunal/refine-shadcn) - ShadCN UI components with Refine.

### Data Provider Packages:

To learn more about Data Providers, check out [Data Provider](/docs/data/data-provider/) docs.

- [`@refinedev/simple-rest`](/docs/data/packages/simple-rest) - Connect any custom **REST API** backend.
- [`@refinedev/graphql`](/docs/data/packages/graphql) - Connect any custom **GraphQL** backend.
- [`@refinedev/nestjsx-crud`](/docs/data/packages/nestjsx-crud) - Consume **REST API**'s built with **NestJs**.
- [`@refinedev/nestjs-query`](/docs/data/packages/nestjs-query) - Consume **GraphQL API**'s built with **Nestjs-Query**.
- [`@refinedev/strapi-v4`](/docs/data/packages/strapi-v4) - [Strapi](https://strapi.io/) connector for **v4 REST API.**
- [`@refinedev/strapi`](/docs/data/packages/strapi-v4) - [Strapi](https://strapi.io/) connector for **legacy REST API.**
- [`@refinedev/supabase`](/docs/data/packages/supabase) -[Supabase](https://supabase.com/) data provider. Supports **Supabase Realtime** for **live/realtime** projects.
- [`@refinedev/hasura`](/docs/data/packages/hasura) - [Hasura GraphQL](https://hasura.io/) data provider. Supports **GraphQL Subscriptions** for **live/realtime** projects.
- [`@refinedev/appwrite`](/docs/data/packages/appwrite) - [Appwrite](https://appwrite.io/) data provider. Supports **Appwrite Realtime** for **live/realtime** projects.
- [`@refinedev/airtable`](/docs/data/packages/airtable) - Use [Airtable](https://airtable.com/) as backend service.
- `@refinedev/medusa` - [Medusa](https://medusajs.com/) connector for your e-commerce projects.

### Router Provider Packages

To learn more about Router Providers, check out [Routing](/docs/guides-concepts/routing) guide.

- [`@refinedev/react-router-v6`](/docs/routing/integrations/react-router) - Router Provider for [React Router (v6)](https://reactrouter.com)
- [`@refinedev/nextjs-router`](/docs/routing/integrations/next-js) - Router Provider for [Next.js](https://nextjs.org/docs/api-reference/next/router#userouter)
- [`@refinedev/remix-router`](/docs/routing/integrations/remix) - Router Provider for [Remix](https://remix.run/)
- [`@refinenative/expo-router`](https://www.npmjs.com/package/@refinenative/expo-router) - Router Provider for [Expo](https://docs.expo.dev/)

### Live Provider Packages

To learn more about Live Providers, check out [Realtime](/docs/guides-concepts/realtime) guide.

- `@refinedev/ably` - [Ably](https://ably.com/) integration for realtime applications.
- `@refinedev/graphql` - Realtime support through GraphQL Subscriptions.
- `@refinedev/nestjs-query` - Realtime support through GraphQL Subscriptions for **Nestjs-Query**.
- `@refinedev/supabase` -[Supabase](https://supabase.com/) realtime support.
- `@refinedev/hasura` - [Hasura GraphQL](https://hasura.io/) support with GraphQL Subscriptions.
- `@refinedev/appwrite` - [Appwrite](https://appwrite.io/) realtime support.

### Integrations

- [`@refinedev/kbar`](/docs/packages/command-palette) - [kbar](https://kbar.vercel.app/) integration. Add `command`/`crtrl`+`k` interfaces to your project.
- [`@refinedev/react-table`](/docs/packages/tanstack-table/introduction) - [React Table](https://tanstack.com/table/v8) integration. Powerful tables & datagrids for your headless projects.
- [`@refinedev/react-hook-form`](/docs/packages/react-hook-form/introduction) - [React Hook Form](https://react-hook-form.com/) integration. Extensible forms and validation for your projects.

### React Frameworks

- `NextJS` - SSR and SSG support for your projects.
- `Remix` - SSR support for your projects.
- `React Native` - Mobile support for your projects.

### ❤️ Community Packages:

- [`refine-firebase`](https://github.com/resulturan/refine-firebase) - Support for [Firebase](https://firebase.google.com/) services.
- [`@tspvivek/refine-directus`](https://github.com/tspvivek/refine-directus) - Connector for backends created with [Directus](https://directus.io/)
- [`refine-elide-rest`](https://github.com/chirdeeptomar/refine-elide-rest) - Connector for backends created with [Elide](https://elide.io/)
- [`refine-elide-graphql`](https://github.com/chirdeeptomar/refine-elide-graphql) - Connector for GraphQL backends created with [Elide](https://elide.io/)
- [`ent-refine`](https://github.com/diazoxide/entrefine) - A library that generates fully customizable UI based on [Entgo ORM](https://entgo.io/) and [GraphQL API](https://graphql.org/) with [Refine](https://github.com/refinedev/refine)
- [`refine-use-generated`](https://github.com/usegen/refine-use-generated) - Connector for GraphQL backends created with [useGenerated](https://usegenerated.com/)
- [`refine-hygraph`](https://github.com/acomagu/refine-hygraph) - Connector for [Hygraph](https://hygraph.com/) backends(GraphQL)
- [`refine-sanity`](https://github.com/hirenf14/refine-sanity) - Connector for [Sanity](https://www.sanity.io/) backends
- [`refine-sqlite`](https://github.com/mateusabelli/refine-sqlite) - Connector for [SQLite](https://www.sqlite.org/index.html) backends
- [`refine-jsonapi`](https://github.com/MahirMahdi/refine-jsonapi) - Connector for [JSON:API](https://jsonapi.org/) backends
- [`@refine-auth/kinde-react`](https://github.com/hirenf14/refine-auth-kinde-react) - Support for [Kinde](https://kinde.com) authentication.
- [`refine-pocketbase`](https://github.com/kruschid/refine-pocketbase) - Connector for backends created with [PocketBase](https://pocketbase.io/). Also has auth provider and live provider supports.
- [`refine-postgrest-ts`](https://github.com/ffimnsr/refine-postgrest-ts) - Connector for [PostgREST](https://postgrest.org) backends.
- [`refine-chakra-ui-v3-ts`](https://github.com/ffimnsr/refine-chakra-ui-v3-ts) - Integration for [Chakra UI v3](https://www.chakra-ui.com).
