import type { IconProps } from "src/types/icon";

export const Logo: React.FC<IconProps & { short?: boolean }> = ({
  short,
  ...props
}) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={88}
      height={64}
      viewBox="0 0 88 64"
      fill="none"
      {...props}
    >
      <path
        fill="currentColor"
        d="M30.085.921a8.727 8.727 0 0 0-7.806 0L4.824 9.65A8.727 8.727 0 0 0 0 17.455v16a8.727 8.727 0 0 0 4.824 7.805l12.63 6.315v-30.12a8.727 8.727 0 1 1 17.455 0V29.09h17.455V17.454a8.727 8.727 0 0 0-4.825-7.805L30.085.92Z"
      />
      <path
        fill="currentColor"
        d="M30.545 17.454a4.364 4.364 0 1 1-8.727 0 4.364 4.364 0 0 1 8.727 0ZM79.658 39.244h7.614v7.197h-3.138l-.375-3.077c-.356 1.1-.992 1.918-1.908 2.451-.915.533-2.033.8-3.352.8-1.201 0-2.271-.26-3.21-.782-.928-.522-1.659-1.27-2.194-2.243-.523-.974-.785-2.11-.785-3.408 0-2.074.636-3.714 1.909-4.92 1.272-1.205 3.251-1.808 5.938-1.808 1.534 0 2.883.244 4.048.73a7.45 7.45 0 0 1 2.996 2.26c-.535.267-1.581.8-3.138 1.6l-.446.243a4.421 4.421 0 0 0-1.623-1.008 5.541 5.541 0 0 0-1.962-.348c-1.141 0-1.991.296-2.55.887-.559.58-.838 1.298-.838 2.156 0 .927.297 1.675.891 2.242.607.568 1.528.852 2.765.852a5.34 5.34 0 0 0 1.551-.226c.511-.15.94-.411 1.284-.782h-3.477v-2.816Z"
      />
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M42.105 62.279c1.284 1.147 3.288 1.72 6.01 1.72 2.758 0 4.773-.573 6.045-1.72 1.273-1.148 1.909-2.77 1.909-4.868 0-2.063-.642-3.674-1.926-4.833-1.273-1.16-3.282-1.739-6.028-1.739-2.734 0-4.744.58-6.028 1.739-1.272 1.159-1.908 2.77-1.908 4.833 0 2.086.642 3.709 1.926 4.868Zm8.863-2.556c-.582.487-1.533.73-2.853.73-1.308 0-2.253-.249-2.836-.747-.582-.499-.873-1.264-.873-2.295 0-1.02.291-1.78.873-2.278.583-.498 1.528-.747 2.836-.747 1.32 0 2.27.25 2.853.747.583.499.874 1.258.874 2.278 0 1.043-.291 1.814-.874 2.312ZM71.043 57.967c.511-.695.767-1.547.767-2.556 0-1.286-.475-2.306-1.427-3.06-.95-.753-2.627-1.13-5.029-1.13H61.7v-.017H57.49c.095 2.249.143 4.352.143 6.311 0 1.959-.048 4.062-.143 6.31h4.209v-4.033h2.621c1.13 1.739 1.956 3.083 2.479 4.034h4.85l-2.888-3.912a4.19 4.19 0 0 0-.304-.434c1.225-.313 2.087-.818 2.586-1.513ZM61.7 56.542V54.56h2.407c1.023 0 1.795.029 2.318.087.523.058.88.156 1.07.295a.69.69 0 0 1 .286.591c0 .267-.101.47-.303.609-.203.139-.565.243-1.088.313-.511.058-1.272.087-2.283.087H61.7Z"
        clipRule="evenodd"
      />
      <path
        fill="currentColor"
        d="M77.442 60.644c4.518-.023 7.793-.087 9.826-.19-.083.474-.137.967-.16 1.477a82.19 82.19 0 0 0-.018 1.895H73.233c.096-2.249.143-4.352.143-6.311 0-1.959-.047-4.062-.143-6.31H87.09v3.146h-9.648v1.669a170.859 170.859 0 0 0 8.4-.087v2.99a170.859 170.859 0 0 0-8.4-.087v1.808ZM34.368 54.75c1.76.012 3.572.047 5.439.105v-3.65H24.488v3.65c1.843-.058 3.65-.093 5.421-.104v9.075h4.459V54.75ZM9.726 60.68c-.262.51-.595 1.06-.999 1.651 1.094.545 2.325.962 3.692 1.252 1.367.278 2.71.417 4.03.417 2.461 0 4.298-.353 5.51-1.06 1.213-.72 1.82-1.89 1.82-3.512 0-1.16-.571-2.017-1.712-2.573-1.142-.568-2.973-.852-5.493-.852-1.023 0-1.807-.081-2.354-.243-.535-.174-.803-.4-.803-.678 0-.279.197-.487.589-.626.392-.151 1.153-.226 2.282-.226.94 0 2.022.162 3.246.486 1.225.313 2.14.707 2.747 1.183a6.55 6.55 0 0 0 .178-.522c.38-1.101.743-2.034 1.088-2.799-1.047-.533-2.224-.95-3.531-1.252a16.148 16.148 0 0 0-3.799-.469c-2.128 0-3.858.37-5.19 1.113-1.33.741-1.997 1.895-1.997 3.46 0 1.1.547 1.9 1.641 2.398 1.094.487 2.853.73 5.279.73 2.211 0 3.317.354 3.317 1.061 0 .197-.202.383-.607.556-.404.163-1.1.244-2.086.244-.963 0-2.003-.134-3.121-.4-1.117-.267-2.098-.638-2.942-1.113-.25.672-.512 1.264-.785 1.773Z"
      />
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M67.628 46.441c-.226-.66-.529-1.49-.91-2.486H61.03l-.892 2.486h-4.476l4.993-12.621h6.563l5.029 12.621h-4.619Zm-1.926-5.198a229.126 229.126 0 0 0-1.39-3.65l-.429-1.13a419.14 419.14 0 0 0-1.837 4.78h3.656Z"
        clipRule="evenodd"
      />
      <path
        fill="currentColor"
        d="m51.103 41.695.928-7.875h4.351l-2.39 12.621h-5.474l-1.213-7.04-1.409 7.04h-5.243l-2.39-12.621h4.352l.91 7.77 1.426-7.77h4.761l1.391 7.875ZM22.503 44.946c.404-.591.737-1.142.998-1.651.274-.51.535-1.102.785-1.774.844.475 1.825.846 2.942 1.113 1.118.266 2.158.4 3.121.4.987 0 1.683-.081 2.087-.244.404-.173.606-.359.606-.556 0-.707-1.106-1.06-3.317-1.06-2.425 0-4.185-.244-5.279-.73-1.093-.499-1.64-1.299-1.64-2.4 0-1.564.666-2.718 1.997-3.46 1.332-.741 3.062-1.112 5.19-1.112 1.236 0 2.502.157 3.798.47 1.308.3 2.485.718 3.531 1.251a33.766 33.766 0 0 0-1.088 2.8c-.071.23-.13.405-.178.52-.606-.474-1.522-.869-2.746-1.181-1.225-.325-2.307-.487-3.246-.487-1.13 0-1.89.075-2.283.226-.392.139-.588.347-.588.626 0 .278.267.504.802.678.547.162 1.332.243 2.354.243 2.52 0 4.352.284 5.493.852 1.141.556 1.712 1.414 1.712 2.573 0 1.622-.606 2.793-1.819 3.511-1.213.707-3.05 1.061-5.51 1.061-1.32 0-2.664-.14-4.03-.417-1.368-.29-2.599-.707-3.692-1.252Z"
      />
    </svg>
  );
};
