import { useTheme } from "@mui/material";
import type { SVGProps } from "react";

export const RefineLogo = (props: SVGProps<SVGSVGElement>) => {
  const { palette } = useTheme();

  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={122}
      height={40}
      viewBox="0 0 122 40"
      fill="none"
      {...props}
    >
      <path
        fill={palette.primary.main}
        fillRule="evenodd"
        d="M17 19.997C16.999 13.37 12.97 8 8 8a4 4 0 0 0-4 4c0 4.97 5.373 9 12 9a1 1 0 0 0 1-1v-.003ZM24.5 11c-3.59 0-6.5 4.03-6.5 9a1 1 0 0 0 1 1c4.97 0 9-2.91 9-6.5a3.5 3.5 0 0 0-3.5-3.5ZM17 23c0 4.97-3.134 9-7 9a3 3 0 0 1-3-3c0-3.866 4.03-7 9-7a1 1 0 0 1 1 1ZM18 23a1 1 0 0 1 1-1c3.866 0 7 2.462 7 5.5a2.5 2.5 0 0 1-2.5 2.5c-3.038 0-5.5-3.134-5.5-7Z"
        clipRule="evenodd"
      />
      <path
        fill={palette.primary.main}
        d="M41.138 27V13.91h5.165c.988 0 1.832.176 2.53.53.704.35 1.239.846 1.605 1.489.37.64.556 1.391.556 2.256 0 .87-.187 1.618-.562 2.244-.375.622-.919 1.1-1.63 1.432-.708.332-1.564.498-2.57.498h-3.458v-2.224h3.01c.53 0 .968-.073 1.318-.217.349-.145.609-.363.78-.652.174-.29.262-.65.262-1.08 0-.435-.088-.802-.263-1.1a1.607 1.607 0 0 0-.786-.678c-.35-.157-.79-.236-1.323-.236h-1.866V27h-2.768Zm7.07-5.957L51.46 27h-3.055l-3.184-5.957h2.985Zm9.007 6.149c-1.01 0-1.879-.205-2.608-.614a4.203 4.203 0 0 1-1.674-1.751c-.392-.759-.588-1.656-.588-2.691 0-1.01.196-1.897.588-2.66a4.347 4.347 0 0 1 1.655-1.783c.716-.426 1.556-.639 2.519-.639.647 0 1.25.104 1.809.313a4.012 4.012 0 0 1 1.47.927c.422.413.75.933.984 1.56.235.622.352 1.35.352 2.186v.748h-8.29V21.1h5.727c0-.392-.086-.74-.256-1.042a1.833 1.833 0 0 0-.71-.71 2.024 2.024 0 0 0-1.041-.261c-.414 0-.78.096-1.1.287a2.017 2.017 0 0 0-.742.76 2.15 2.15 0 0 0-.274 1.056v1.604c0 .486.09.906.268 1.26.183.353.441.626.774.817.332.192.726.288 1.182.288.303 0 .58-.043.831-.128.252-.085.467-.213.646-.383s.315-.38.409-.627l2.518.166a3.439 3.439 0 0 1-.786 1.586c-.392.447-.9.797-1.521 1.048-.618.247-1.332.37-2.142.37Zm11.564-10.01v2.045h-6.06v-2.045h6.06ZM64.106 27V16.472c0-.711.139-1.302.416-1.77a2.67 2.67 0 0 1 1.15-1.055c.486-.234 1.038-.351 1.656-.351.417 0 .799.031 1.144.095.35.064.61.122.78.173l-.486 2.045a3.392 3.392 0 0 0-.397-.095 2.475 2.475 0 0 0-.472-.045c-.401 0-.68.094-.838.281-.157.183-.236.441-.236.773V27h-2.717Zm6.336 0v-9.818h2.723V27h-2.723Zm1.368-11.084a1.48 1.48 0 0 1-1.042-.402 1.306 1.306 0 0 1-.428-.978c0-.375.143-.697.428-.966.29-.272.637-.409 1.042-.409s.75.137 1.035.41c.29.268.435.59.435.965 0 .379-.145.705-.434.978-.286.268-.631.402-1.036.402Zm6.26 5.408V27h-2.724v-9.818h2.596v1.732h.115a2.74 2.74 0 0 1 1.093-1.355c.511-.337 1.131-.505 1.86-.505.682 0 1.276.15 1.783.447.507.299.901.725 1.183 1.279.28.55.422 1.206.422 1.969V27h-2.724v-5.766c.005-.6-.149-1.07-.46-1.406-.31-.34-.739-.511-1.284-.511-.367 0-.69.079-.972.236a1.648 1.648 0 0 0-.652.69c-.153.299-.232.659-.237 1.08Zm12.948 5.868c-1.01 0-1.88-.205-2.608-.614a4.202 4.202 0 0 1-1.675-1.751c-.392-.759-.588-1.656-.588-2.691 0-1.01.196-1.897.588-2.66a4.347 4.347 0 0 1 1.656-1.783c.716-.426 1.555-.639 2.518-.639.648 0 1.251.104 1.81.313a4.013 4.013 0 0 1 1.47.927c.421.413.75.933.984 1.56.234.622.352 1.35.352 2.186v.748h-8.291V21.1h5.727c0-.392-.085-.74-.255-1.042a1.831 1.831 0 0 0-.71-.71 2.024 2.024 0 0 0-1.042-.261c-.413 0-.78.096-1.1.287a2.016 2.016 0 0 0-.74.76c-.18.316-.271.668-.276 1.056v1.604c0 .486.09.906.269 1.26.183.353.44.626.773.817.333.192.727.288 1.183.288.302 0 .58-.043.83-.128.252-.085.467-.213.646-.383.18-.17.316-.38.41-.627l2.518.166a3.44 3.44 0 0 1-.786 1.586c-.392.447-.9.797-1.522 1.048-.618.247-1.331.37-2.14.37ZM97.353 27V13.91h2.767v5.4h5.619v-5.4h2.761V27h-2.761v-5.408h-5.619V27h-2.767Zm13.429 0V13.91h5.165c.989 0 1.832.176 2.531.53.703.35 1.238.846 1.605 1.489.37.64.556 1.391.556 2.256 0 .87-.188 1.618-.563 2.244-.375.622-.918 1.1-1.63 1.432-.707.332-1.564.498-2.569.498h-3.458v-2.224h3.01c.529 0 .968-.073 1.317-.217.35-.145.609-.363.78-.652.175-.29.262-.65.262-1.08 0-.435-.087-.802-.262-1.1a1.612 1.612 0 0 0-.786-.678c-.35-.157-.791-.236-1.323-.236h-1.867V27h-2.768Zm7.07-5.957L121.105 27h-3.055l-3.183-5.957h2.985Z"
      />
    </svg>
  );
};
