import { Suspense } from "react";
import type { Metadata } from "next";
import { GitHubBanner, Refine } from "@refinedev/core";
import routerProvider from "@refinedev/nextjs-router";
import { Layout } from "@/components/layout";
import { BasketContextProvider } from "@/context";
import { dataProvider } from "@/providers/data-provider/client";
import "src/styles/globals.css";

export const metadata: Metadata = {
  title: "RefineFoods headless storefront example",
  description: "Generated by create Refine app",
  icons: {
    icon: "/favicon.ico",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <>
      <html lang="en">
        <body>
          <Suspense>
            <GitHubBanner />
            <Refine
              resources={[
                {
                  name: "categories",
                  show: "/categories/:id",
                },
                {
                  name: "orders",
                  show: "/orders/:id",
                },
              ]}
              routerProvider={routerProvider}
              dataProvider={dataProvider}
            >
              <BasketContextProvider>
                <Layout>{children}</Layout>
              </BasketContextProvider>
            </Refine>
          </Suspense>
        </body>
      </html>
    </>
  );
}
