import Icon from "@ant-design/icons";

const BikeWhiteSVG: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={14}
    height={14}
    viewBox="0 0 14 14"
    fill="none"
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M10.349 1.967c.207.014.403.044.592.123.439.182.787.53.97.969.078.189.108.384.122.59.014.199.014.44.014.73v.016a.49.49 0 0 1-.489.489h-.527c.207.215.412.46.602.732a5.82 5.82 0 0 1 1.05 2.912 1.791 1.791 0 1 1-2.257 1.565H6.137a2.443 2.443 0 0 1-4.786 0H.488A.488.488 0 0 1 0 9.605C0 8.448.41 7.5 1.107 6.845 1.8 6.191 2.74 5.86 3.744 5.86c1.006 0 1.945.332 2.637.984.582.548.964 1.3 1.074 2.206a1.43 1.43 0 0 0 .629-.414c.289-.315.51-.771.67-1.308.32-1.075.356-2.317.356-2.933V2.93H7.615v-.977h2c.291 0 .534 0 .734.014Zm-.263.966v.974h.98a4.339 4.339 0 0 0-.008-.191.9.9 0 0 0-.05-.283m-.947 1.87c-.04.671-.137 1.518-.372 2.304-.159.534-.39 1.07-.733 1.51h1.872c.225-.273.528-.477.875-.58a4.849 4.849 0 0 0-.87-2.361 5.021 5.021 0 0 0-.772-.872ZM6.479 9.117c-.092-.673-.376-1.192-.767-1.56-.487-.459-1.175-.719-1.968-.719-.793 0-1.481.26-1.967.718-.392.37-.676.888-.768 1.561h5.47Zm3.607-6.183c.074.002.138.005.197.009.158.01.234.03.284.05.2.083.358.241.44.44m-8.645 6.661a1.466 1.466 0 0 0 2.764 0H2.362Zm2.685-5.21H2.442v-.976h2.605v.977Zm7.162 4.559a.814.814 0 1 0 0 1.628.814.814 0 0 0 0-1.628Z"
      clipRule="evenodd"
    />
  </svg>
);

export const BikeWhiteIcon = (props: React.ComponentProps<typeof Icon>) => (
  <Icon component={BikeWhiteSVG} {...props} />
);
