---
id: prepare-env
title: 2. Prepare your dev environment
tutorial:
  prev: 3.xx.xx/tutorial/getting-started/{preferredUI}/index
  next: 3.xx.xx/tutorial/getting-started/{preferredUI}/create-project
---

## Get the dev tools you need

Before you can create a **refine** app, you need to set up a development environment on your local machine. This includes installing a few tools that you will use to create your project and run key commands to build, develop, and test your site.

### Terminal

You will use a terminal (also known as a command line interface) to run these commands and interact with your operating system. You can access the terminal through a local program for your operating system, such as Terminal (MacOS/Linux) or Command Prompt (Windows).

In order to run **refine** applications on your system, you will also need to have [Node.js](https://nodejs.org/en/) installed. Node.js is a JavaScript runtime that allows developers to run JavaScript code outside of a web browser. It is required to run **refine** applications because it is a JavaScript-based tool.

To check if you already have a compatible version of Node.js (v.16.0.0 or higher) installed:

1. Launch your terminal and type the following command:

   ```bash
   node -v
   ```

2. If you do not have a compatible version of Node.js installed, follow these instructions to [install Node.js](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm) via the terminal.

### Code Editor

In addition to a terminal, you will also need a code editor to write and edit your code. A code editor is a software application that allows you to write and edit code for various programming languages.

:::info
This tutorial will use **VS Code**, but you can use any code editor that is compatible with your operating system. Some other popular code editors include **Sublime Text**, **Atom**, and **Eclipse**.
:::

To install a code editor:

1. Download and install the code editor of your choice from the Internet.
2. Follow the prompts to complete the installation process.

<Checklist>

<ChecklistItem id="has-access-to-terminal">
I am able to access the command line via a terminal.
</ChecklistItem>
<ChecklistItem id="installed-nodejs">
Node.js has been installed on my device.
</ChecklistItem>
<ChecklistItem id="installed-vscode">
I am using a code editor similar to Visual Studio Code.
</ChecklistItem>

</Checklist>
