---
id: list-of-packages
title: List of Packages
---

- `@pankod/refine-core` - Collection of `hooks`, `components` and `providers` for **authentication**, **access control**, **routing**, **networking**, **state management** and **i18n**. Your starting point for headless projects.
- `@pankod/refine-inferencer` - Provides a way to automatically generate views for resources based on the data structure. The aim is to reduce the amount of time spent on creating views for resources by generating the code automatically that can be customized easily. 
- `@pankod/refine-cli` - It is a tool that allows you to perform important commands while developing with refine.


### UI Framework Packages:

- `@pankod/refine-antd` -  [Ant Design](https://ant.design/) System UI Framework support.  **20+** *framework-specific*  `hooks` and  `components`  incl. *Table, Form, Select, Menu, Layout, Notification and CRUD components.*

- `@pankod/refine-mui` - [Material UI](https://mui.com/material-ui/getting-started/overview/) Framework support. **20+** *framework-specific*  `hooks` and  `components`  incl. *DataGrid (+ Pro), AutoComplete, Menu, Layout, Notification and CRUD components.*

- `@pankod/refine-mantine` - [Mantine](https://mantine.dev/) UI Framework support. **20+** framework-specific **hooks** and **components** incl. *Table, Form, AutoComplete, Menu, Layout, Notification and CRUD components.*

- `@pankod/refine-chakra-ui` - [Chakra UI](https://chakra-ui.com/) UI Framework support. **20+** framework-specific **components** incl. *Menu, Layout, Notification and CRUD components.*

### [Data Provider](https://refine.dev/docs/core/providers/data-provider/) Packages:

  

- `@pankod/refine-simple-rest` - Connect any custom **REST API** backend.

- `@pankod/refine-graphql` - Connect any custom **GraphQL** backend.

- `@pankod/refine-nestjsx-crud` -  Consume **REST API**'s built with **NestJs**.

- `@pankod/refine-strapi-v4` - [Strapi](https://strapi.io/) connector for **v4 REST API.**

- `@pankod/refine-strapi-graphql` - [Strapi](https://strapi.io/) connector for **GraphQL API.**

- `@pankod/refine-strapi` - [Strapi](https://strapi.io/) connector for **legacy REST API.**

- `@pankod/refine-supabase` -[Supabase](https://supabase.com/) data provider. Supports **Supabase Realtime** for **live/realtime** projects.

- `@pankod/refine-hasura` -  [Hasura GraphQL](https://hasura.io/) data provider. Supports **GraphQL Subscriptions** for **live/realtime** projects.

- `@pankod/refine-appwrite` - [Appwrite](https://appwrite.io/) data provider. Supports **Appwrite Realtime** for **live/realtime** projects.

- `@pankod/refine-medusa` -  [Medusa](https://medusajs.com/) connector for your e-commerce projects.

- `@pankod/refine-airtable` - Use [Airtable](https://airtable.com/) as backend service.

- `@pankod/refine-nhost` -   [Nhost](https://nhost.io/) data provider. Supports **GraphQL Subscriptions** for **live/realtime** projects.


### [Router Provider](https://refine.dev/docs/core/providers/router-provider/) Packages


- `@pankod/refine-react-router-v6` - Router Provider for [React Router (v6)](https://reactrouter.com)

- `@pankod/refine-react-router` - Router Provider for [React Router (v5)](https://v5.reactrouter.com/)

- `@pankod/refine-nextjs-router` - Router Provider for [Next.js](https://nextjs.org/docs/api-reference/next/router#userouter)

- `@pankod/refine-react-location` - Router Provider for [React Location](https://github.com/tannerlinsley/react-location)

- `@pankod/refine-remix-router` - Router Provider for [Remix](https://remix.run/)


### [Live Provider](https://refine.dev/docs/core/providers/live-provider/) Packages


- `@pankod/refine-ably` - [React Table](https://ably.com/) support for for **live/realtime** projects.


### Integrations

- `@pankod/refine-kbar` - [kbar](https://kbar.vercel.app/) integration. Add `command`/`crtrl`+`k` interfaces to your project.
-  `@pankod/refine-react-table` - [React Table](https://tanstack.com/table/v8) integration. Powerful tables & datagrids for your headless projects. 
-  `@pankod/refine-react-hook-form` - [React Hook Form](https://react-hook-form.com/) integration. Extensible forms and validation for your projects.

### React Frameworks
 `NextJS` - SSR and SSG support for your projects.

### React Frameworks
 `Remix` - SSR support for your projects.

### ❤️ Community Packages:

- [`refine-firebase`](https://github.com/resulturan/refine-firebase) - Support for [Firebase](https://firebase.google.com/) services.
- [`@tspvivek/refine-directus`](https://github.com/tspvivek/refine-directus) - Connector for backends created with [Directus](https://directus.io/)
- [`refine-elide-rest`](https://github.com/chirdeeptomar/refine-elide-rest) - Connector for backends created with [Elide](https://elide.io/)
- [`ent-refine`](https://github.com/diazoxide/entrefine) - A library that generates fully customizable UI based on [Entgo ORM](https://entgo.io/) and [GraphQL API](https://graphql.org/) with [refine](https://github.com/refinedev/refine)
- [`refine-use-generated`](https://github.com/usegen/refine-use-generated) - Support for [useGenerated](https://usegenerated.com/)  GraphQL API generator based on NestJs + Prisma ORM.
  
