import React from "react";

export const EarlyAccess = (
    props: React.SVGProps<SVGSVGElement>,
): JSX.Element => (
    <svg
        width="64"
        height="64"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            fill="url(#EarlyAccess)"
            fillRule="evenodd"
            d="M20.6446 2.9445v16.5161a2.065 2.065 0 0 0 .6046 1.46c.3871.387.9124.6046 1.4599.6046h6.0488l2.2092 7.5253a1.0325 1.0325 0 0 0 1.9821 0l2.2917-7.5253h6.0488a2.0653 2.0653 0 0 0 1.4599-.6046 2.065 2.065 0 0 0 .6046-1.46V2.9446a2.065 2.065 0 0 0-.6046-1.46A2.0649 2.0649 0 0 0 41.2897.88H22.709a2.065 2.065 0 0 0-1.4599.6046 2.065 2.065 0 0 0-.6046 1.46h.0001Zm20.6451 16.5161h-6.8129a1.0325 1.0325 0 0 0-1.0322.7328l-1.4452 4.9654-1.4867-4.965v-.0004a1.0315 1.0315 0 0 0-1.0322-.7327h-6.7714V2.9445h18.5806v16.5161Zm-9.2894 14.4517 5.9456-1.0323 5.1924-1.6929a7.135 7.135 0 0 1 2.2811-.3715h2.6115a5.163 5.163 0 0 1-2.07-3.6392 5.1613 5.1613 0 0 1 5.136-5.6742 5.1613 5.1613 0 0 1 3.066 9.3134h.547a5.1633 5.1633 0 0 1 3.6498 1.5115 5.1635 5.1635 0 0 1 1.5115 3.6498v10.3226h-2.0645V35.9769a3.0978 3.0978 0 0 0-.907-2.1898 3.0972 3.0972 0 0 0-2.1898-.9069h-9.2903a5.158 5.158 0 0 0-1.6617.3198h-.0005l-5.2336 1.7447h-.165l-5.3262.8774v1.1972h5.0788l6.1111-1.0322c.3-.0475.606.0391.836.2377.2295.1959.3613.4825.3613.7844v9.2903h-2.0646v-8.0724l-4.9963.8364-12.7174-.0004-4.9964-.836v8.0724h-2.0645v-9.2903a1.0313 1.0313 0 0 1 .3613-.795 1.0319 1.0319 0 0 1 .8359-.2373l6.1111 1.0323h5.0788l-.0004-1.177-5.3263-.8875h-.1649l-5.2645-1.7964a5.1657 5.1657 0 0 0-1.6309-.2682H9.2904a3.098 3.098 0 0 0-2.1898.9069 3.097 3.097 0 0 0-.907 2.1898v10.3226H4.1293V35.9768a5.1631 5.1631 0 0 1 1.5114-3.6498 5.1636 5.1636 0 0 1 3.6498-1.5115h.547a5.1633 5.1633 0 0 1-2.07-3.6392 5.1611 5.1611 0 0 1 5.136-5.6742 5.161 5.161 0 0 1 3.8268 1.6977 5.163 5.163 0 0 1 1.3093 3.9765 5.1637 5.1637 0 0 1-2.0701 3.6392h2.6116a7.1418 7.1418 0 0 1 2.3125.3406l5.1612 1.7239 5.9456 1.0323Zm-21.2862-5.036a3.0975 3.0975 0 0 0 4.3796 0 3.0974 3.0974 0 0 0 0-4.3796 3.0974 3.0974 0 0 0-4.3796 0 3.0971 3.0971 0 0 0 0 4.3796Zm38.1935-4.3796a3.0968 3.0968 0 0 0-.9069 2.1898c0 .821.3263 1.6091.9069 2.1898a3.0974 3.0974 0 0 0 4.3796 0 3.0977 3.0977 0 0 0 .9069-2.1898 3.098 3.098 0 0 0-.9069-2.1898 3.0972 3.0972 0 0 0-4.3796 0Zm-9.6818 22.8349a1.0321 1.0321 0 0 0-.4645-.8567l-6.1936-4.129a1.0309 1.0309 0 0 0-1.1354 0l-6.1936 4.129a1.0321 1.0321 0 0 0-.4645.8567v2.0645H0v2.0646h24.7742v6.1935h-2.0645c-.5701 0-1.0323.4622-1.0323 1.0323v5.1613a1.0325 1.0325 0 0 0 1.0323 1.0322h18.5806a1.0323 1.0323 0 0 0 1.0323-1.0322v-5.1613c0-.2738-.1088-.5364-.3023-.73a1.0327 1.0327 0 0 0-.73-.3023h-2.0645v-6.1935H64v-2.0646H39.2258v-2.0645Zm-12.3871.5576L32 44.4413l5.1613 3.4479v9.765H26.8387v-9.765Zm13.4194 11.8291v3.0968H23.7419v-3.0968h16.5162ZM32.001 47.3316a3.0974 3.0974 0 0 0-2.1898.9069 3.0974 3.0974 0 0 0 0 4.3796 3.097 3.097 0 0 0 4.3796 0 3.0975 3.0975 0 0 0 0-4.3796 3.098 3.098 0 0 0-2.1898-.9069Zm0 4.129c-.4175 0-.794-.2516-.9534-.6373a1.0314 1.0314 0 0 1 .2235-1.1249 1.0314 1.0314 0 0 1 1.1248-.2235 1.0318 1.0318 0 0 1 .3351 1.6834 1.0325 1.0325 0 0 1-.73.3023Zm-1.828-35.664a1.0324 1.0324 0 0 1-.7225.2995 1.0336 1.0336 0 0 1-.7226-.2995l-2.9213-2.9213 1.4452-1.4557 2.1987 2.1885 7.2981-7.2982 1.4451 1.4558-8.0207 8.0309Z"
            clipRule="evenodd"
        />
        <defs>
            <linearGradient
                id="EarlyAccess"
                x1="4.6617"
                x2="47.2651"
                y1="7.38"
                y2="64.3657"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#3FDCF7" />
                <stop offset="1" stopColor="#1890FF" />
            </linearGradient>
        </defs>
    </svg>
);

export const Training = (props: React.SVGProps<SVGSVGElement>): JSX.Element => (
    <svg
        width="64"
        height="64"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            fill="url(#Training)"
            d="M62.667 19.5093h-5.3335v-5.3334a1.3309 1.3309 0 0 0-.3902-.9433 1.3344 1.3344 0 0 0-.9428-.3903H42.667v2.6671h12.0001v40.0001H38.6667a7.9746 7.9746 0 0 0-5.3329 2.0416V52.843h-2.6671v4.7207-.0006a7.9585 7.9585 0 0 0-5.3329-2.0535H9.3335V15.5094h12v-2.6671H8c-.3533 0-.693.1405-.9427.3903a1.3308 1.3308 0 0 0-.3903.9433v5.3335H1.3335a1.3303 1.3303 0 0 0-.9432.3902A1.3332 1.3332 0 0 0 0 20.8423v42.6671c0 .3538.1404.6929.3908.9427.2498.2504.589.3908.9427.3908h61.333A1.333 1.333 0 0 0 64 63.5094V20.8423a1.3327 1.3327 0 0 0-1.3335-1.3329l.0005-.0001ZM2.6675 62.1764V22.1763h4v34.6662a1.3293 1.3293 0 0 0 .3903.9427c.2498.2504.5895.3908.9427.3903h17.3338a5.3388 5.3388 0 0 1 5.1577 4l-27.8245.0009Zm58.6674 0H33.5103l-.0006-.0005a5.339 5.339 0 0 1 5.1577-4.0001h17.3338a1.329 1.329 0 0 0 .9427-.3902 1.3282 1.3282 0 0 0 .3902-.9427V22.1767h4.0001l.0007 39.9997ZM37.3351 51.5093a4.004 4.004 0 0 0 2.8271-1.173 4.0064 4.0064 0 0 0 1.1729-2.827V14.1766a1.3389 1.3389 0 0 0-.2242-.7397l-8-12A1.3846 1.3846 0 0 0 32.0016.88c-.4371 0-.848.2068-1.1093.5568l-8 12.0001a1.3389 1.3389 0 0 0-.2242.7397v33.3327a4.0064 4.0064 0 0 0 1.1729 2.827 4.004 4.004 0 0 0 2.8271 1.173h10.667Zm1.3335-10.6666h-5.3334V15.5095h5.3334v25.3332Zm-6.6671-36.263 5.5088 8.2635-11.0175-.0005 5.5087-8.263ZM25.335 15.5096h5.3335l-.0006 25.3333H25.335V15.5096Zm0 32.0007v-4.0006h13.3331v4c-.0011.7359-.5971 1.3324-1.333 1.3335H26.668c-.7359-.0011-1.3319-.5976-1.333-1.3335v.0006Z"
        />
        <defs>
            <linearGradient
                id="Training"
                x1="4.6617"
                x2="47.2334"
                y1="7.3762"
                y2="64.3525"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#3FDCF7" />
                <stop offset="1" stopColor="#1890FF" />
            </linearGradient>
        </defs>
    </svg>
);

export const FastTrackSupport = (
    props: React.SVGProps<SVGSVGElement>,
): JSX.Element => (
    <svg
        width="64"
        height="64"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            fill="url(#FastTrackSupport)"
            fillRule="evenodd"
            d="M45.9674 13.1881c-3.5765-3.5753-8.5165-5.7886-13.9693-5.7886v.001c-5.4528 0-10.3931 2.2133-13.9744 5.7935-3.5753 3.5766-5.7886 8.5166-5.7886 13.9693 0 2.3492.4152 4.6116 1.1776 6.7157.6775 1.8755 1.6319 3.619 2.811 5.1805l-4.5203 9.0068c-.2719.4419-.2922 1.0183-.0015 1.491.4106.6682 1.2866.8775 1.9552.4668l8.919-5.487a19.6065 19.6065 0 0 0 4.1348 1.6686 19.7588 19.7588 0 0 0 5.2871.7207c5.4562 0 10.3981-2.2132 13.9744-5.7896 3.5753-3.5756 5.7886-8.5185 5.7886-13.9743 0-5.4527-2.2133-10.3931-5.7936-13.9744Zm-5.7408 35.4183c-.7514-.7515-1.7886-1.2177-2.9285-1.2177l.0015-.0007c-1.1429 0-2.181.4653-2.931 1.2153-.75.7499-1.2153 1.7877-1.2153 2.931 0 1.1444.4653 2.181 1.2153 2.931.7499.75 1.7877 1.2152 2.931 1.2152 1.0962 0 2.0961-.431 2.8397-1.1314l.0917-.0838c.7153-.7153 1.1717-1.692 1.2118-2.7748 4.8328-1.8616 8.9801-5.114 11.9473-9.2637a26.2214 26.2214 0 0 0 3.3243-6.3159 1.367 1.367 0 0 0 .1439.0075h1.9068c1.435 0 2.7454-.5907 3.6978-1.5371C63.4112 33.6328 64 32.3229 64 30.8824v-4.675c0-1.436-.5908-2.7455-1.5422-3.6988-.9479-.9469-2.256-1.5371-3.6929-1.5371h-1.2172c-1.1524-4.7714-3.6067-9.0347-6.9652-12.3932C45.827 3.8229 39.2558.88 31.9999.88c-7.2558 0-13.8271 2.943-18.5825 7.6983-3.3587 3.3587-5.813 7.6219-6.9652 12.3932H5.235c-1.437 0-2.7445.5908-3.6979 1.5422C.5903 23.4621 0 24.7715 0 26.2076v4.6749c0 1.4404.5888 2.7504 1.5397 3.6963.95.9494 2.2599 1.5397 3.6954 1.5397h1.9067c.7852 0 1.4226-.6374 1.4226-1.4226v-7.5346c0-6.4716 2.624-12.3316 6.8635-16.5711 4.2391-4.2396 10.0995-6.8635 16.5712-6.8635 6.4716 0 12.3316 2.624 16.5711 6.8635 4.2395 4.239 6.8635 10.099 6.8635 16.5711 0 5.0834-1.6151 9.7866-4.3566 13.6214-2.616 3.6586-6.2623 6.5355-10.5127 8.2042a4.174 4.174 0 0 0-.3378-.3805Zm-8.2285-38.3615c4.674 0 8.9055 1.8933 11.9661 4.9513l-.0002-.0001c3.058 3.0609 4.9513 7.292 4.9513 11.966 0 4.6726-1.8943 8.9041-4.9538 11.9636-3.061 3.0605-7.2911 4.9544-11.9636 4.9544-1.5823 0-3.1027-.2118-4.5312-.6082-1.4801-.4092-2.8868-1.0233-4.1845-1.805-.4702-.2828-1.0387-.2619-1.4772.0059l-5.3878 3.3149 2.744-5.4686c.2589-.5173.1696-1.1195-.1771-1.5387-1.243-1.493-2.2341-3.2033-2.9052-5.0693-.6464-1.7861-.998-3.7216-.998-5.7489 0-4.6739 1.8933-8.9055 4.9512-11.966 3.0609-3.058 7.2921-4.9513 11.966-4.9513Zm3.7328 7.5041c.1698-.631-.2039-1.2766-.8324-1.4463-.6237-.1724-1.2765.2013-1.4463.8322l-5.2686 19.5913c-.17.6312.2039 1.2766.8324 1.4465.102.0292.2062.0412.3081.0412.5217 0 .9974-.3471 1.1382-.8736l5.2686-19.5913Zm-9.5785 5.3025c.4609-.4612.4609-1.2086 0-1.6697-.4612-.4585-1.2086-.4585-1.6697 0l-4.9943 4.9942a1.1762 1.1762 0 0 0-.3443.7776 1.1762 1.1762 0 0 0 .3395.8897l4.9942 5.0476a1.1836 1.1836 0 0 0 1.6698.0098c.4634-.4587.4682-1.2061.0096-1.6697l-4.17-4.2147 4.1652-4.1648Zm18.2685 3.3173-5.0477-4.9943c-.466-.4587-1.2134-.4539-1.6696.0097-.4563.4636-.4539 1.2109.0097 1.6697l4.2057 4.1612-4.2105 4.211c-.4612.461-.4612 1.2086 0 1.6695.2305.2283.5338.3448.8349.3448.3009 0 .6041-.1165.8346-.3448l5.0478-5.0475a1.1779 1.1779 0 0 0 .3344-.9971 1.1734 1.1734 0 0 0-.3393-.6822Z"
            clipRule="evenodd"
        />
        <defs>
            <linearGradient
                id="FastTrackSupport"
                x1="4.6617"
                x2="39.2019"
                y1="6.4457"
                y2="60.4018"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#3FDCF7" />
                <stop offset="1" stopColor="#1890FF" />
            </linearGradient>
        </defs>
    </svg>
);

export const NewBusiness = (
    props: React.SVGProps<SVGSVGElement>,
): JSX.Element => (
    <svg
        width="64"
        height="64"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            fill="url(#NewBusiness)"
            d="M31.9989 16.8796a15.9987 15.9987 0 0 0-11.3135 4.6868 15.9984 15.9984 0 0 0 0 22.6269 15.998 15.998 0 0 0 22.6269 0 15.9981 15.9981 0 0 0 4.6868-11.3134A16.0184 16.0184 0 0 0 31.999 16.8798l-.0001-.0002Zm0 29.334a13.334 13.334 0 0 1-13.3335-13.3334 13.334 13.334 0 0 1 13.3335-13.3335 13.334 13.334 0 0 1 13.3334 13.3335 13.3498 13.3498 0 0 1-13.3334 13.3334Zm-2.6668-17.3329a2.6698 2.6698 0 0 0 .7818 1.8855c.5.5 1.1776.7808 1.885.7813a5.3303 5.3303 0 0 1 5.0007 7.1838 5.3302 5.3302 0 0 1-3.6673 3.3075v2.8423h-2.6668v-2.8423a5.3402 5.3402 0 0 1-4.0002-5.1577h2.6668a2.668 2.668 0 0 0 .7813 1.8855 2.666 2.666 0 0 0 1.8856.7808 2.6661 2.6661 0 0 0 1.8855-.7808c.5-.4999.7813-1.1786.7813-1.8855a2.6696 2.6696 0 0 0-.7813-1.8861 2.6664 2.6664 0 0 0-1.8855-.7807 5.33 5.33 0 0 1-1.3334-10.4913v-2.8423h2.6668v2.8423a5.3366 5.3366 0 0 1 2.8797 1.8967 5.3385 5.3385 0 0 1 1.1204 3.261h-2.6668a2.6667 2.6667 0 0 0-5.3336 0Zm-7.9999 2.6668h2.6668v2.6668h-2.6668v-2.6668Zm21.3333 0v2.6668h-2.6668v-2.6668h2.6668Zm17.99 23.6462-2.1545-.3593h.0005a7.5798 7.5798 0 0 0 1.4977-4.6212c0-3.2895-2.044-5.3336-5.3336-5.3336-3.2889 0-5.3336 2.0441-5.3336 5.3336h.0006a7.5824 7.5824 0 0 0 1.4981 4.6206l-2.1567.3593v.0006a3.986 3.986 0 0 0-2.3966 1.3575 3.9848 3.9848 0 0 0-.9444 2.5877V64.88h2.6668v-5.7411a1.3298 1.3298 0 0 1 1.1142-1.3155l5.5521-.9259 5.5522.9259a1.3298 1.3298 0 0 1 1.1142 1.3155V64.88h2.6668v-5.7411a3.9834 3.9834 0 0 0-.9455-2.5883 3.9863 3.9863 0 0 0-2.3984-1.3569h.0001Zm-5.9893-7.6467c2.3905 0 2.6668 1.5216 2.6668 2.6668 0 2.1281-1.2459 3.9973-2.6639 3.9996h-.0056c-1.4208-.0028-2.6639-1.8715-2.6639-4.0002 0-1.1445.2763-2.6662 2.6668-2.6662h-.0002ZM.0002 20.8804h2.6667v-5.7411a1.3297 1.3297 0 0 1 1.1143-1.3154l5.5521-.9254 5.5521.9259v-.0005a1.3298 1.3298 0 0 1 1.1143 1.3154v5.7411h2.6668v-5.7411a3.983 3.983 0 0 0-.9456-2.5883 3.9863 3.9863 0 0 0-2.3983-1.3569l-2.1546-.3593h.0006a7.584 7.584 0 0 0 1.4981-4.6212C14.6667 2.9241 12.6226.88 9.3331.88c-3.289 0-5.3336 2.044-5.3336 5.3336h.0006a7.577 7.577 0 0 0 1.4977 4.6206l-2.1567.3593v.0006a3.985 3.985 0 0 0-2.3967 1.3575A3.9877 3.9877 0 0 0 0 15.1393l.0001 5.7411ZM9.3333 3.5475c2.3904 0 2.6668 1.5217 2.6668 2.6668 0 2.1282-1.246 3.9973-2.664 3.9996h-.0056c-1.4208-.0028-2.664-1.8714-2.664-4.0002 0-1.1445.2764-2.6662 2.6669-2.6662h-.0001Zm0 17.3329v12a22.6891 22.6891 0 0 0 6.6462 16.0201 22.691 22.691 0 0 0 16.02 6.6462h6.1149l-3.0576-3.058 1.8856-1.8855 5.3336 5.3336h-.0006c.25.25.3907.5891.3907.9427 0 .3537-.1407.6928-.3907.9428l-5.3336 5.3336-1.8855-1.8856 3.0569-3.0569h-6.1137a25.3639 25.3639 0 0 1-17.9054-7.4286 25.3613 25.3613 0 0 1-7.4286-17.9054v-12l2.6678.001Zm45.3338 21.3333v-9.3333a22.6925 22.6925 0 0 0-6.6462-16.02 22.694 22.694 0 0 0-16.02-6.6462h-6.1143l3.0569 3.057-1.8855 1.8855-5.3336-5.3336h.0006c-.25-.25-.3907-.589-.3907-.9428 0-.3536.1407-.6927.3907-.9427l5.3336-5.3336 1.8849 1.8861-3.0575 3.058 6.1149-.0006a25.3641 25.3641 0 0 1 17.9054 7.4286 25.3613 25.3613 0 0 1 7.4286 17.9054v9.3332l-2.6678-.001Z"
        />
        <defs>
            <linearGradient
                id="NewBusiness"
                x1="4.6616"
                x2="47.2652"
                y1="7.38"
                y2="64.3652"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#3FDCF7" />
                <stop offset="1" stopColor="#1890FF" />
            </linearGradient>
        </defs>
    </svg>
);
