import React from "react";

export const SenovoIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={250}
    height={250}
    viewBox="0 0 250 250"
    fill="none"
    {...props}
  >
    <path
      fill="#FDC800"
      fillRule="evenodd"
      d="M162.485 31.552c-18.112 2.639-38.151 9.011-59.323 19.052-61.497 29.094-86.64 71.886-60.768 127.615a78.578 78.578 0 0 0 19.284 25.953c28.724 25.31 76.367 29.095 125.664-3.759 51.524-34.346 72.826-86.754 58.086-128.477-11.719-33.368-42.513-46.255-82.943-40.384Z"
      clipRule="evenodd"
    />
    <path
      fill="#009DDE"
      fillRule="evenodd"
      d="M219.71 69.709c-14.557-19.902-35.234-31.862-57.226-38.157h-.065c-36.12-10.299-75.742-5.304-97.435 5.15-55.3 26.506-90.638 69.516-41.888 134.206a123.07 123.07 0 0 0 38.58 33.265c31.55 17.431 70.899 21.138 105.131-.245 50.95-31.823 80.755-96.088 52.903-134.219Z"
      clipRule="evenodd"
    />
    <mask
      id="senovo-a"
      width={199}
      height={188}
      x={32}
      y={31}
      maskUnits="userSpaceOnUse"
      style={{
        maskType: "luminance",
      }}
    >
      <path
        fill="#fff"
        fillRule="evenodd"
        d="M219.712 69.71c-14.557-19.903-35.234-31.863-57.227-38.158-18.112 2.64-38.151 9.012-59.323 19.053-61.497 29.094-86.64 71.886-60.768 127.615a78.588 78.588 0 0 0 19.284 25.953c31.55 17.431 70.899 21.138 105.13-.245 50.951-31.823 80.729-96.087 52.904-134.219Z"
        clipRule="evenodd"
      />
    </mask>
    <g mask="url(#senovo-a)">
      <path
        fill="#001A3A"
        fillRule="evenodd"
        d="M162.485 31.551c-18.112 2.64-38.151 9.012-59.323 19.053-61.497 29.094-86.64 71.886-60.768 127.615a78.578 78.578 0 0 0 19.284 25.953c28.724 25.31 76.367 29.095 125.664-3.759 51.524-34.346 72.826-86.754 58.086-128.477-11.719-33.369-42.513-46.255-82.943-40.385Z"
        clipRule="evenodd"
      />
    </g>
    <path
      fill="#FEFEFE"
      fillRule="evenodd"
      d="M51.584 110.838a9.875 9.875 0 0 0-3.828 3.077 7.509 7.509 0 0 0-1.471 4.647 9.146 9.146 0 0 0 1.21 4.66 8.625 8.625 0 0 0 4.584 3.412l4.518 1.725c.824.31 1.61.712 2.344 1.197.325.187.595.456.783.779.187.323.285.689.284 1.062.014.442-.102.879-.333 1.258a2.32 2.32 0 0 1-.969.879 6.584 6.584 0 0 1-3.15.721 13.017 13.017 0 0 1-4.949-.953 21.007 21.007 0 0 1-4.244-2.343v5.935a16.825 16.825 0 0 0 4.114 2.111c1.583.583 3.26.879 4.948.876 1.922.02 3.827-.366 5.586-1.133a10.113 10.113 0 0 0 4.023-3.09 7.322 7.322 0 0 0 1.51-4.57 6.707 6.707 0 0 0-1.444-4.235 10.87 10.87 0 0 0-4.493-3.142l-3.593-1.467a24.259 24.259 0 0 1-3.112-1.481 2.592 2.592 0 0 1-.816-.786 2.554 2.554 0 0 1 .269-3.153 4.517 4.517 0 0 1 1.849-1.03 7.48 7.48 0 0 1 2.252-.347 9.524 9.524 0 0 1 4.063.824 31.782 31.782 0 0 1 3.372 1.763v-5.909a16.162 16.162 0 0 0-3.542-1.609 15.072 15.072 0 0 0-4.635-.682 11.968 11.968 0 0 0-5.13 1.094v-.09Zm25.104 11.239v-6.579H91.35v-5.149H70.594v29.004H91.35v-5.343H76.688v-7.016h12.956v-4.892l-12.956-.025Zm39.583-11.78v17.753l-17.317-17.92H96.7v29.223h6.081v-17.482l17.383 17.701h2.226v-29.223l-6.12-.052Zm19.532.464a14.924 14.924 0 0 0-4.896 3.115 14.474 14.474 0 0 0-3.308 4.828 16.372 16.372 0 0 0 0 12.294 14.408 14.408 0 0 0 3.334 4.789 15.135 15.135 0 0 0 4.896 3.115 16.047 16.047 0 0 0 5.937 1.107 15.79 15.79 0 0 0 5.912-1.107 15.365 15.365 0 0 0 4.882-3.115 14.165 14.165 0 0 0 3.321-4.789 16.203 16.203 0 0 0 0-12.294 14.257 14.257 0 0 0-3.321-4.776 15.149 15.149 0 0 0-4.882-3.116 15.569 15.569 0 0 0-5.912-1.107c-2.033-.016-4.05.36-5.937 1.107l-.026-.051Zm10.625 5.819a9.065 9.065 0 0 1 3.242 3.372 10.588 10.588 0 0 1 0 9.681 8.934 8.934 0 0 1-3.242 3.373 8.918 8.918 0 0 1-4.688 1.287 8.914 8.914 0 0 1-4.641-1.194 8.79 8.79 0 0 1-3.328-3.414 10.486 10.486 0 0 1 0-9.681 9.06 9.06 0 0 1 3.256-3.373 8.947 8.947 0 0 1 4.713-1.287 8.84 8.84 0 0 1 4.688 1.287v-.051Zm32.552-6.283-8.06 19.182-8.008-19.182h-7.135l13.658 29.223h3.021l13.737-29.171-7.213-.052Zm15.299.464a14.934 14.934 0 0 0-4.896 3.115 14.497 14.497 0 0 0-3.333 4.776 16.363 16.363 0 0 0 0 12.294 14.395 14.395 0 0 0 3.333 4.789 15.132 15.132 0 0 0 4.896 3.116 16.008 16.008 0 0 0 5.938 1.107 15.785 15.785 0 0 0 5.911-1.107 15.372 15.372 0 0 0 4.883-3.116 14.35 14.35 0 0 0 3.32-4.789 16.203 16.203 0 0 0 0-12.294 14.44 14.44 0 0 0-3.32-4.776 15.15 15.15 0 0 0-4.883-3.115 15.544 15.544 0 0 0-5.911-1.107 15.762 15.762 0 0 0-5.938 1.107Zm10.625 5.819a8.978 8.978 0 0 1 3.229 3.372 10.49 10.49 0 0 1 1.186 4.841c0 1.684-.407 3.343-1.186 4.84a8.687 8.687 0 0 1-3.297 3.415 8.834 8.834 0 0 1-4.619 1.194 9.07 9.07 0 0 1-4.714-1.287 8.766 8.766 0 0 1-3.255-3.373 10.486 10.486 0 0 1-1.186-4.841c0-1.683.407-3.343 1.186-4.84a8.938 8.938 0 0 1 3.255-3.373 8.95 8.95 0 0 1 4.714-1.287 8.857 8.857 0 0 1 4.687 1.287v.052Z"
      clipRule="evenodd"
    />
  </svg>
);
