import React from "react";

export const RefineWeekIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width="40"
    height="40"
    viewBox="0 0 40 40"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="text-white dark:text-refine-indigo-alt/10"
    />
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="text-refine-indigo-alt"
      fillOpacity="0.1"
    />
    <path
      d="M16.4 20.8C17.0627 20.8 17.6 20.2627 17.6 19.6C17.6 18.9373 17.0627 18.4 16.4 18.4C15.7373 18.4 15.2 18.9373 15.2 19.6C15.2 20.2627 15.7373 20.8 16.4 20.8Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
    <path
      d="M17.6 23.6C17.6 24.2627 17.0627 24.8 16.4 24.8C15.7373 24.8 15.2 24.2627 15.2 23.6C15.2 22.9373 15.7373 22.4 16.4 22.4C17.0627 22.4 17.6 22.9373 17.6 23.6Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
    <path
      d="M20 20.8C20.6627 20.8 21.2 20.2627 21.2 19.6C21.2 18.9373 20.6627 18.4 20 18.4C19.3373 18.4 18.8 18.9373 18.8 19.6C18.8 20.2627 19.3373 20.8 20 20.8Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
    <path
      d="M21.2 23.6C21.2 24.2627 20.6627 24.8 20 24.8C19.3373 24.8 18.8 24.2627 18.8 23.6C18.8 22.9373 19.3373 22.4 20 22.4C20.6627 22.4 21.2 22.9373 21.2 23.6Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
    <path
      d="M23.6 20.8C24.2627 20.8 24.8 20.2627 24.8 19.6C24.8 18.9373 24.2627 18.4 23.6 18.4C22.9373 18.4 22.4 18.9373 22.4 19.6C22.4 20.2627 22.9373 20.8 23.6 20.8Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M16.4 12C15.2954 12 14.4 12.8954 14.4 14V14.4C13.0745 14.4 12 15.4745 12 16.8V25.6C12 26.9255 13.0745 28 14.4 28H25.6C26.9255 28 28 26.9255 28 25.6V16.8C28 15.4745 26.9255 14.4 25.6 14.4V14C25.6 12.8954 24.7046 12 23.6 12C22.4954 12 21.6 12.8954 21.6 14V14.4H18.4V14C18.4 12.8954 17.5046 12 16.4 12ZM16 14C16 13.7791 16.1791 13.6 16.4 13.6C16.6209 13.6 16.8 13.7791 16.8 14V15.2C16.8 15.6418 17.1582 16 17.6 16H22.4C22.8418 16 23.2 15.6418 23.2 15.2V14C23.2 13.7791 23.3791 13.6 23.6 13.6C23.8209 13.6 24 13.7791 24 14V15.2C24 15.6418 24.3582 16 24.8 16H25.6C26.0418 16 26.4 16.3582 26.4 16.8V25.6C26.4 26.0418 26.0418 26.4 25.6 26.4H14.4C13.9582 26.4 13.6 26.0418 13.6 25.6V16.8C13.6 16.3582 13.9582 16 14.4 16H15.2C15.6418 16 16 15.6418 16 15.2V14Z"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fill="currentColor"
    />
  </svg>
);
