import React from "react";

export const GithubStarIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width="48"
    height="48"
    viewBox="0 0 48 48"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M25.375 0.215468C24.9355 0.0742408 24.4721 -0.000178705 24 3.22247e-07C23.5279 -0.00017838 23.0645 0.0742446 22.625 0.215471C22.0845 0.38855 21.5925 0.658728 21.167 1.00384C20.7424 1.34751 20.377 1.77126 20.0959 2.26225C20.0096 2.41259 19.9319 2.56821 19.8632 2.72838L15.8665 11.7208C15.2907 13.0166 14.0703 13.9093 12.6611 14.0659L4.00316 15.0279C2.28393 15.2189 0.826377 16.3785 0.253797 18.0108C-0.318784 19.6431 0.0949749 21.4591 1.31814 22.6823L8.52259 29.8868C9.48721 30.8514 9.89215 32.242 9.59622 33.5737L7.60724 42.524C7.21386 44.2943 7.92148 46.1276 9.40217 47.1746C10.8829 48.2215 12.8473 48.2773 14.385 47.3162L21.8853 42.6285C23.1791 41.8199 24.8209 41.8199 26.1147 42.6285L33.615 47.3162C35.1527 48.2773 37.1171 48.2215 38.5978 47.1746C40.0785 46.1276 40.7861 44.2943 40.3928 42.524L38.4038 33.5737C38.1078 32.242 38.5128 30.8514 39.4774 29.8868L46.6819 22.6823C47.905 21.4591 48.3188 19.6431 47.7462 18.0108C47.1736 16.3785 45.7161 15.2189 43.9968 15.0279L35.3389 14.0659C33.9297 13.9093 32.7094 13.0166 32.1335 11.7208L28.1368 2.7284C28.0681 2.56822 27.9904 2.4126 27.9041 2.26225C27.6229 1.77113 27.2574 1.34727 26.8327 1.00355C26.4072 0.65858 25.9154 0.388499 25.375 0.215468ZM16.2443 14.929C18.4253 13.0354 21.1952 11.9971 24.0576 12.0001C26.8983 12.0249 29.6389 13.0743 31.7954 14.963C33.952 16.8518 35.3856 19.4583 35.843 22.322C36.3004 25.1857 35.7521 28.1225 34.2951 30.6134C32.8381 33.1042 30.5661 34.989 27.8805 35.9346C27.2667 36.0555 27.0523 35.7458 27.0523 35.3455V31.9695C27.0825 31.5538 27.0248 31.1363 26.8832 30.7454C26.7416 30.3544 26.5194 29.9992 26.2315 29.7037C28.9157 29.4242 31.7329 28.3895 31.7329 23.6615C31.7513 22.4402 31.3092 21.2585 30.4981 20.3609C30.8464 19.3025 30.7936 18.1491 30.3502 17.1284C30.3502 17.1284 29.3445 16.7961 27.0449 18.3897C25.0702 17.8359 22.9859 17.8359 21.0112 18.3897C18.7115 16.7961 17.6985 17.1284 17.6985 17.1284C17.2612 18.16 17.219 19.3217 17.5802 20.3836C16.7691 21.2811 16.327 22.4629 16.3454 23.6841C16.3454 28.3593 19.1552 29.4167 21.8319 29.7263C21.4012 30.1675 21.1389 30.7515 21.0925 31.3728C20.7965 31.5411 20.4709 31.6481 20.1343 31.6875C19.7977 31.727 19.4568 31.6982 19.1312 31.6028C18.8056 31.5073 18.5016 31.3471 18.2367 31.1314C17.9718 30.9157 17.7512 30.6487 17.5876 30.3456C17.3951 30.0053 17.1292 29.7142 16.8102 29.4944C16.4912 29.2746 16.1275 29.1318 15.7464 29.0768C15.7464 29.0768 14.5707 29.0768 15.6577 29.8321C16.2987 30.2532 16.7729 30.8928 16.9961 31.6372C16.9961 31.6372 17.7059 34.0389 21.0703 33.2912V35.3833C21.0703 35.7081 20.8559 36.0933 20.2496 35.98C17.533 35.0586 15.2264 33.1792 13.7432 30.6786C12.26 28.178 11.6972 25.2196 12.1555 22.3335C12.6138 19.4475 14.0633 16.8225 16.2443 14.929Z"
      fill={`url(#github-star${props.id})`}
    />
    <defs>
      <linearGradient
        id={`github-star${props.id}`}
        x1="24"
        y1="0"
        x2="24"
        y2="48.0002"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FFBF00" />
        <stop offset="1" stopColor="#FF9933" />
      </linearGradient>
    </defs>
  </svg>
);
