import React from "react";

export const ExamplesIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width="40"
    height="40"
    viewBox="0 0 40 40"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="text-white dark:text-refine-indigo-alt/10"
    />
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="dark:text-refine-indigo-alt text-refine-indigo"
      fillOpacity="0.1"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M20 12C15.5817 12 12 15.5817 12 20C12 24.4183 15.5817 28 20 28C24.4183 28 28 24.4183 28 20C28 15.5817 24.4183 12 20 12ZM13.6495 19.2C13.9498 16.7921 15.5877 14.7996 17.7962 13.9896C17.7051 14.2014 17.6211 14.4245 17.544 14.6558C17.1374 15.8756 16.8759 17.461 16.8141 19.2H13.6495ZM19.9878 13.6024C19.9955 13.6001 19.9996 13.6 19.9999 13.6C19.9999 13.6 20 13.6 19.9999 13.6C20.0003 13.6 20.0045 13.6001 20.0122 13.6024C20.0211 13.6052 20.0388 13.6119 20.0651 13.6281C20.1205 13.662 20.2036 13.7313 20.3059 13.861C20.514 14.1251 20.7365 14.5569 20.9381 15.1618C21.2822 16.1941 21.5236 17.6022 21.5848 19.2H18.4152C18.4764 17.6022 18.7178 16.1941 19.0619 15.1618C19.2635 14.5569 19.486 14.1251 19.6941 13.861C19.7964 13.7313 19.8795 13.662 19.9349 13.6281C19.9612 13.6119 19.9789 13.6052 19.9878 13.6024ZM21.5848 20.8H18.4152C18.4764 22.3978 18.7178 23.8059 19.0619 24.8382C19.2635 25.4431 19.486 25.8749 19.6941 26.139C19.7964 26.2687 19.8795 26.338 19.9349 26.3719C19.9612 26.3881 19.9789 26.3948 19.9878 26.3976C19.9958 26.4 20 26.4 20 26.4C20 26.4 20.0042 26.4 20.0122 26.3976C20.0211 26.3948 20.0388 26.3881 20.0651 26.3719C20.1205 26.338 20.2036 26.2687 20.3059 26.139C20.514 25.8749 20.7365 25.4431 20.9381 24.8382C21.2822 23.8059 21.5236 22.3978 21.5848 20.8ZM22.2038 26.0104C22.2949 25.7986 22.3789 25.5755 22.456 25.3442C22.8626 24.1244 23.1241 22.539 23.1859 20.8H26.3505C26.0502 23.2079 24.4123 25.2004 22.2038 26.0104ZM23.1859 19.2C23.1241 17.461 22.8626 15.8756 22.456 14.6558C22.3789 14.4245 22.2949 14.2014 22.2038 13.9896C24.4123 14.7996 26.0502 16.7921 26.3505 19.2H23.1859ZM13.6495 20.8H16.8141C16.8759 22.539 17.1374 24.1244 17.544 25.3442C17.6211 25.5755 17.7051 25.7986 17.7962 26.0104C15.5877 25.2004 13.9498 23.2079 13.6495 20.8Z"
      fill="currentColor"
      className="dark:text-refine-indigo-alt text-refine-indigo"
    />
  </svg>
);
