import React from "react";

export const DocumentsIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width="40"
    height="40"
    viewBox="0 0 40 40"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="dark:text-refine-blue-alt/10 text-white"
    />
    <rect
      width="40"
      height="40"
      rx="20"
      fill="currentColor"
      className="dark:text-refine-blue-alt text-refine-blue"
      fillOpacity="0.1"
    />
    <path
      d="M16.8001 20.8C16.8001 20.3582 17.1583 20 17.6001 20H22.4001C22.8419 20 23.2001 20.3582 23.2001 20.8C23.2001 21.2418 22.8419 21.6 22.4001 21.6H17.6001C17.1583 21.6 16.8001 21.2418 16.8001 20.8Z"
      fill="currentColor"
      className="dark:text-refine-blue-alt text-refine-blue"
    />
    <path
      d="M17.6001 23.2C17.1583 23.2 16.8001 23.5582 16.8001 24C16.8001 24.4418 17.1583 24.8 17.6001 24.8H20.0001C20.4419 24.8 20.8001 24.4418 20.8001 24C20.8001 23.5582 20.4419 23.2 20.0001 23.2H17.6001Z"
      fill="currentColor"
      className="dark:text-refine-blue-alt text-refine-blue"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13.6001 14.4C13.6001 13.0745 14.6746 12 16.0001 12H20.9374C21.5739 12 22.1843 12.2528 22.6344 12.7029L25.6971 15.7657C26.1472 16.2158 26.4001 16.8262 26.4001 17.4627V25.6C26.4001 26.9255 25.3256 28 24.0001 28H16.0001C14.6746 28 13.6001 26.9255 13.6001 25.6V14.4ZM16.0001 13.6C15.5583 13.6 15.2001 13.9582 15.2001 14.4V25.6C15.2001 26.0418 15.5583 26.4 16.0001 26.4H24.0001C24.4419 26.4 24.8001 26.0418 24.8001 25.6V17.4627C24.8001 17.2506 24.7158 17.0471 24.5658 16.8971L21.5031 13.8343C21.353 13.6843 21.1495 13.6 20.9374 13.6H16.0001Z"
      fill="currentColor"
      className="dark:text-refine-blue-alt text-refine-blue"
    />
  </svg>
);
