import React, { type SVGProps } from "react";

export const LandingTileHoneycombIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    width={304}
    height={184}
    viewBox="0 0 304 184"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <mask
      id="mask0_736_21041"
      style={{
        maskType: "alpha",
      }}
      maskUnits="userSpaceOnUse"
      x={0}
      y={0}
      width={304}
      height={184}
    >
      <path
        d="M0 12C0 5.37258 5.37258 0 12 0H292C298.627 0 304 5.37258 304 12V184H0V12Z"
        fill="url(#paint0_radial_736_21041)"
      />
    </mask>
    <g mask="url(#mask0_736_21041)">
      <path
        d="M130.269 29.351C131.545 26.9679 133.961 25.5 136.571 25.5H167.429C170.039 25.5 172.455 26.9679 173.731 29.351L186.588 53.351C187.804 55.6197 187.804 58.3803 186.588 60.649L173.731 84.649C172.455 87.0321 170.039 88.5 167.429 88.5H136.571C133.961 88.5 131.545 87.0321 130.269 84.649L117.412 60.649C116.196 58.3803 116.196 55.6197 117.412 53.351L130.269 29.351Z"
        fill="url(#paint1_radial_736_21041)"
        stroke="url(#paint2_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M258.269 29.351C259.545 26.9679 261.961 25.5 264.571 25.5H295.429C298.039 25.5 300.455 26.9679 301.731 29.351L314.588 53.351C315.804 55.6197 315.804 58.3803 314.588 60.649L301.731 84.649C300.455 87.0321 298.039 88.5 295.429 88.5H264.571C261.961 88.5 259.545 87.0321 258.269 84.649L245.412 60.649C244.196 58.3803 244.196 55.6197 245.412 53.351L258.269 29.351Z"
        fill="url(#paint3_radial_736_21041)"
        stroke="url(#paint4_radial_736_21041)"
      />
      <path
        opacity={0.25}
        d="M2.26867 29.351C3.54529 26.9679 5.96064 25.5 8.57142 25.5H39.4286C42.0393 25.5 44.4547 26.9679 45.7313 29.351L58.5885 53.351C59.8038 55.6197 59.8038 58.3803 58.5885 60.649L45.7313 84.649C44.4547 87.0321 42.0393 88.5 39.4286 88.5H8.57142C5.96064 88.5 3.54529 87.0321 2.26867 84.649L-10.5885 60.649C-11.8038 58.3803 -11.8038 55.6197 -10.5885 53.351L2.26867 29.351Z"
        fill="url(#paint5_radial_736_21041)"
        stroke="url(#paint6_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M130.269 -40.649C131.545 -43.0321 133.961 -44.5 136.571 -44.5H167.429C170.039 -44.5 172.455 -43.0321 173.731 -40.649L186.588 -16.649C187.804 -14.3803 187.804 -11.6197 186.588 -9.35096L173.731 14.649C172.455 17.0321 170.039 18.5 167.429 18.5H136.571C133.961 18.5 131.545 17.0321 130.269 14.649L117.412 -9.35096C116.196 -11.6197 116.196 -14.3803 117.412 -16.649L130.269 -40.649Z"
        fill="url(#paint7_radial_736_21041)"
        stroke="url(#paint8_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M258.269 -40.649C259.545 -43.0321 261.961 -44.5 264.571 -44.5H295.429C298.039 -44.5 300.455 -43.0321 301.731 -40.649L314.588 -16.649C315.804 -14.3803 315.804 -11.6197 314.588 -9.35096L301.731 14.649C300.455 17.0321 298.039 18.5 295.429 18.5H264.571C261.961 18.5 259.545 17.0321 258.269 14.649L245.412 -9.35096C244.196 -11.6197 244.196 -14.3803 245.412 -16.649L258.269 -40.649Z"
        fill="url(#paint9_radial_736_21041)"
        stroke="url(#paint10_radial_736_21041)"
      />
      <path
        opacity={0.25}
        d="M2.26867 -40.649C3.54529 -43.0321 5.96064 -44.5 8.57142 -44.5H39.4286C42.0393 -44.5 44.4547 -43.0321 45.7313 -40.649L58.5885 -16.649C59.8038 -14.3803 59.8038 -11.6197 58.5885 -9.35096L45.7313 14.649C44.4547 17.0321 42.0393 18.5 39.4286 18.5H8.57142C5.96064 18.5 3.54529 17.0321 2.26867 14.649L-10.5885 -9.35096C-11.8038 -11.6197 -11.8038 -14.3803 -10.5885 -16.649L2.26867 -40.649Z"
        fill="url(#paint11_radial_736_21041)"
        stroke="url(#paint12_radial_736_21041)"
      />
      <path
        d="M130.269 99.351C131.545 96.9679 133.961 95.5 136.571 95.5H167.429C170.039 95.5 172.455 96.9679 173.731 99.351L186.588 123.351C187.804 125.62 187.804 128.38 186.588 130.649L173.731 154.649C172.455 157.032 170.039 158.5 167.429 158.5H136.571C133.961 158.5 131.545 157.032 130.269 154.649L117.412 130.649C116.196 128.38 116.196 125.62 117.412 123.351L130.269 99.351Z"
        fill="url(#paint13_radial_736_21041)"
        stroke="url(#paint14_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M258.269 99.351C259.545 96.9679 261.961 95.5 264.571 95.5H295.429C298.039 95.5 300.455 96.9679 301.731 99.351L314.588 123.351C315.804 125.62 315.804 128.38 314.588 130.649L301.731 154.649C300.455 157.032 298.039 158.5 295.429 158.5H264.571C261.961 158.5 259.545 157.032 258.269 154.649L245.412 130.649C244.196 128.38 244.196 125.62 245.412 123.351L258.269 99.351Z"
        fill="url(#paint15_radial_736_21041)"
        stroke="url(#paint16_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M2.26867 99.351C3.54529 96.9679 5.96064 95.5 8.57142 95.5H39.4286C42.0393 95.5 44.4547 96.9679 45.7313 99.351L58.5885 123.351C59.8038 125.62 59.8038 128.38 58.5885 130.649L45.7313 154.649C44.4547 157.032 42.0393 158.5 39.4286 158.5H8.57142C5.96064 158.5 3.54529 157.032 2.26867 154.649L-10.5885 130.649C-11.8038 128.38 -11.8038 125.62 -10.5885 123.351L2.26867 99.351Z"
        fill="url(#paint17_radial_736_21041)"
        stroke="url(#paint18_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M130.269 169.351C131.545 166.968 133.961 165.5 136.571 165.5H167.429C170.039 165.5 172.455 166.968 173.731 169.351L186.588 193.351C187.804 195.62 187.804 198.38 186.588 200.649L173.731 224.649C172.455 227.032 170.039 228.5 167.429 228.5H136.571C133.961 228.5 131.545 227.032 130.269 224.649L117.412 200.649C116.196 198.38 116.196 195.62 117.412 193.351L130.269 169.351Z"
        fill="url(#paint19_radial_736_21041)"
        stroke="url(#paint20_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M258.269 169.351C259.545 166.968 261.961 165.5 264.571 165.5H295.429C298.039 165.5 300.455 166.968 301.731 169.351L314.588 193.351C315.804 195.62 315.804 198.38 314.588 200.649L301.731 224.649C300.455 227.032 298.039 228.5 295.429 228.5H264.571C261.961 228.5 259.545 227.032 258.269 224.649L245.412 200.649C244.196 198.38 244.196 195.62 245.412 193.351L258.269 169.351Z"
        fill="url(#paint21_radial_736_21041)"
        stroke="url(#paint22_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M2.26867 169.351C3.54529 166.968 5.96064 165.5 8.57142 165.5H39.4286C42.0393 165.5 44.4547 166.968 45.7313 169.351L58.5885 193.351C59.8038 195.62 59.8038 198.38 58.5885 200.649L45.7313 224.649C44.4547 227.032 42.0393 228.5 39.4286 228.5H8.57142C5.96064 228.5 3.54529 227.032 2.26867 224.649L-10.5885 200.649C-11.8038 198.38 -11.8038 195.62 -10.5885 193.351L2.26867 169.351Z"
        fill="url(#paint23_radial_736_21041)"
        stroke="url(#paint24_radial_736_21041)"
      />
      <path
        d="M194.269 64.351C195.545 61.9679 197.961 60.5 200.571 60.5H231.429C234.039 60.5 236.455 61.9679 237.731 64.351L250.588 88.351C251.804 90.6197 251.804 93.3803 250.588 95.649L237.731 119.649C236.455 122.032 234.039 123.5 231.429 123.5H200.571C197.961 123.5 195.545 122.032 194.269 119.649L181.412 95.649C180.196 93.3803 180.196 90.6197 181.412 88.351L194.269 64.351Z"
        fill="url(#paint25_radial_736_21041)"
        stroke="url(#paint26_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M194.269 134.351C195.545 131.968 197.961 130.5 200.571 130.5H231.429C234.039 130.5 236.455 131.968 237.731 134.351L250.588 158.351C251.804 160.62 251.804 163.38 250.588 165.649L237.731 189.649C236.455 192.032 234.039 193.5 231.429 193.5H200.571C197.961 193.5 195.545 192.032 194.269 189.649L181.412 165.649C180.196 163.38 180.196 160.62 181.412 158.351L194.269 134.351Z"
        fill="url(#paint27_radial_736_21041)"
        stroke="url(#paint28_radial_736_21041)"
      />
      <path
        d="M66.2687 64.351C67.5453 61.9679 69.9606 60.5 72.5714 60.5H103.429C106.039 60.5 108.455 61.9679 109.731 64.351L122.588 88.351C123.804 90.6197 123.804 93.3803 122.588 95.649L109.731 119.649C108.455 122.032 106.039 123.5 103.429 123.5H72.5714C69.9606 123.5 67.5453 122.032 66.2687 119.649L53.4115 95.649C52.1962 93.3803 52.1962 90.6197 53.4115 88.351L66.2687 64.351Z"
        fill="url(#paint29_radial_736_21041)"
        stroke="url(#paint30_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M66.2687 134.351C67.5453 131.968 69.9606 130.5 72.5714 130.5H103.429C106.039 130.5 108.455 131.968 109.731 134.351L122.588 158.351C123.804 160.62 123.804 163.38 122.588 165.649L109.731 189.649C108.455 192.032 106.039 193.5 103.429 193.5H72.5714C69.9606 193.5 67.5453 192.032 66.2687 189.649L53.4115 165.649C52.1962 163.38 52.1962 160.62 53.4115 158.351L66.2687 134.351Z"
        fill="url(#paint31_radial_736_21041)"
        stroke="url(#paint32_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M66.2687 -5.64903C67.5453 -8.03206 69.9606 -9.5 72.5714 -9.5H103.429C106.039 -9.5 108.455 -8.03206 109.731 -5.64903L122.588 18.351C123.804 20.6197 123.804 23.3803 122.588 25.649L109.731 49.649C108.455 52.0321 106.039 53.5 103.429 53.5H72.5714C69.9606 53.5 67.5453 52.0321 66.2687 49.649L53.4115 25.649C52.1962 23.3803 52.1962 20.6197 53.4115 18.351L66.2687 -5.64903Z"
        fill="url(#paint33_radial_736_21041)"
        stroke="url(#paint34_radial_736_21041)"
      />
      <path
        opacity={0.5}
        d="M194.269 -5.64903C195.545 -8.03206 197.961 -9.5 200.571 -9.5H231.429C234.039 -9.5 236.455 -8.03206 237.731 -5.64903L250.588 18.351C251.804 20.6197 251.804 23.3803 250.588 25.649L237.731 49.649C236.455 52.0321 234.039 53.5 231.429 53.5H200.571C197.961 53.5 195.545 52.0321 194.269 49.649L181.412 25.649C180.196 23.3803 180.196 20.6197 181.412 18.351L194.269 -5.64903Z"
        fill="url(#paint35_radial_736_21041)"
        stroke="url(#paint36_radial_736_21041)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M88.0002 74C97.9412 74 106 82.0589 106 92C106 101.941 97.9412 110 88 110C78.0588 110 70 101.941 70 92C70 82.0589 78.0588 74 88.0002 74ZM84.5214 83.3875C84.3609 83.6056 84.2683 83.8661 84.2551 84.1365C84.2419 84.4069 84.3087 84.6753 84.4472 84.9079C84.5391 85.0617 84.6605 85.1958 84.8045 85.3024C86.8903 86.8563 88.0878 89.2323 88.0878 91.8221C88.0878 94.4119 86.8903 96.7879 84.8045 98.3419C84.6607 98.4485 84.5394 98.5826 84.4476 98.7363C84.2614 99.0479 84.2063 99.4206 84.2944 99.7728C84.3379 99.9473 84.415 100.111 84.5214 100.256C84.6277 100.4 84.7614 100.522 84.9149 100.614C85.0684 100.707 85.2386 100.768 85.4159 100.794C85.5931 100.82 85.7738 100.811 85.9475 100.768C86.1213 100.724 86.2847 100.646 86.4283 100.539C87.0707 100.06 87.6592 99.513 88.1835 98.907H92.0469C92.7992 98.907 93.4105 98.2948 93.4105 97.539C93.4105 96.7833 92.8005 96.171 92.0469 96.171H89.9146C90.5106 94.7989 90.8167 93.3184 90.8137 91.8223C90.8169 90.3262 90.5108 88.8455 89.9148 87.4732H92.0483C92.8005 87.4732 93.4116 86.8612 93.4116 86.1052C93.4116 85.3494 92.8016 84.7374 92.0483 84.7374H88.1857C87.6612 84.1308 87.0723 83.583 86.4294 83.1037C86.286 82.9967 86.1228 82.9192 85.9493 82.8755C85.7758 82.8318 85.5953 82.8228 85.4183 82.8491C85.0603 82.9028 84.7382 83.0965 84.5227 83.3875H84.5214ZM82.3687 91.414C82.3622 91.1417 82.4096 90.8709 82.5083 90.6171C82.6065 90.364 82.7542 90.133 82.9427 89.9375C83.1304 89.7429 83.3553 89.588 83.604 89.4819C83.852 89.3762 84.1188 89.3217 84.3883 89.3217C84.6579 89.3217 84.9247 89.3762 85.1727 89.4819C85.4215 89.588 85.6464 89.7429 85.8342 89.9375C86.0227 90.133 86.1703 90.364 86.2686 90.6171C86.3671 90.8709 86.4144 91.1418 86.4078 91.414C86.3955 91.9458 86.1774 92.4521 85.7993 92.8264C85.4237 93.198 84.9168 93.4067 84.3884 93.4072C83.8599 93.4068 83.3528 93.1981 82.9772 92.8264C82.5991 92.4521 82.3809 91.9458 82.3687 91.414Z"
        fill="url(#paint37_linear_736_21041)"
      />
      <path
        d="M214.464 74.6431L198.638 90.5221C197.787 91.3757 197.787 92.7546 198.638 93.6082L214.464 109.487C215.315 110.341 216.69 110.341 217.54 109.487L224.176 102.829C224.938 102.065 224.938 100.825 224.176 100.061C223.414 99.2962 222.179 99.2962 221.417 100.061L216.386 105.108C216.174 105.32 215.853 105.32 215.641 105.108L203.003 92.4275C202.791 92.215 202.791 91.8926 203.003 91.6801L215.641 78.9996C215.853 78.7872 216.174 78.7872 216.386 78.9996L221.417 84.0469C222.179 84.8114 223.414 84.8114 224.176 84.0469C224.938 83.2823 224.938 82.0428 224.176 81.2783L217.541 74.6212C216.687 73.786 215.312 73.7927 214.464 74.6431Z"
        fill="url(#paint38_linear_736_21041)"
      />
      <path
        d="M214.464 74.6431L198.638 90.5221C197.787 91.3757 197.787 92.7546 198.638 93.6082L214.464 109.487C215.315 110.341 216.69 110.341 217.54 109.487L224.176 102.829C224.938 102.065 224.938 100.825 224.176 100.061C223.414 99.2962 222.179 99.2962 221.417 100.061L216.386 105.108C216.174 105.32 215.853 105.32 215.641 105.108L203.003 92.4275C202.791 92.215 202.791 91.8926 203.003 91.6801L215.641 78.9996C216.169 78.5432 217.029 77.6186 218.292 77.4023C219.231 77.2416 220.258 77.5953 221.372 78.4635C220.627 77.7161 219.35 76.4354 217.541 74.6212C216.687 73.786 215.312 73.7927 214.464 74.6431Z"
        fill="url(#paint39_linear_736_21041)"
      />
      <path
        d="M225.708 98.5837C226.47 99.3482 227.705 99.3482 228.467 98.5837L233.362 93.6726C234.213 92.8189 234.213 91.4401 233.362 90.5865L228.424 85.6501C227.661 84.8865 226.425 84.8876 225.662 85.6526C224.9 86.4171 224.9 87.6567 225.662 88.4212L228.997 91.7671C229.209 91.9796 229.209 92.3021 228.997 92.5145L225.708 95.8151C224.946 96.5796 224.946 97.8192 225.708 98.5837Z"
        fill="url(#paint40_linear_736_21041)"
      />
      <path
        d="M216.081 96.432C218.441 96.432 220.354 94.5125 220.354 92.1447C220.354 89.7769 218.441 87.8574 216.081 87.8574C213.721 87.8574 211.808 89.7769 211.808 92.1447C211.808 94.5125 213.721 96.432 216.081 96.432Z"
        fill="url(#paint41_linear_736_21041)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M152 109C161.941 109 170 117.059 170 127C170 136.941 161.941 145 152 145C142.059 145 134 136.941 134 127C134 117.059 142.059 109 152 109ZM156.013 115.583L143.744 127.768C143.566 127.945 143.691 128.247 143.941 128.247H152.291C152.52 128.247 152.652 128.507 152.518 128.692L145.971 137.723C145.772 137.998 146.141 138.324 146.389 138.092L160.219 125.185C160.405 125.012 160.282 124.7 160.028 124.7H152.136C151.923 124.7 151.788 124.473 151.89 124.286L156.457 115.916C156.611 115.633 156.242 115.356 156.013 115.583Z"
        fill="url(#paint42_linear_736_21041)"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M165 47.5854C165 47.9776 165.169 48.2711 165.507 48.4653C165.846 48.658 166.181 48.6534 166.514 48.4517L169.514 46.632C169.838 46.434 170 46.1465 170 45.7635V42.0528C169.999 41.6584 169.831 41.3671 169.492 41.1729C169.155 40.9788 168.819 40.9848 168.486 41.1866L165.486 43.0063C165.163 43.2042 165.001 43.4917 165 43.874V47.5854ZM164.343 62.5024C164.677 62.3082 164.844 62.0169 164.845 61.6286L164.863 55.7728C164.864 55.383 165.031 55.0909 165.365 54.8968L168.503 53.0733C168.657 52.9838 168.824 52.939 169.002 52.939C169.181 52.939 169.347 52.9853 169.501 53.0748C169.656 53.1658 169.777 53.2887 169.867 53.4457C169.956 53.6012 170 53.7696 170 53.9509V64.5974C170 64.988 169.833 65.2808 169.498 65.475L157.659 72.3555C157.328 72.5482 156.997 72.5482 156.666 72.3555L147.374 66.9799C147.038 66.7857 146.87 66.4922 146.87 66.1V60.732C146.87 60.7259 146.877 60.7222 146.883 60.7259C146.888 60.7282 146.895 60.7259 146.895 60.7184V60.7123C146.895 60.7085 146.897 60.7047 146.901 60.7024L154.553 56.253C154.56 56.2492 154.557 56.2378 154.549 56.2378C154.544 56.2378 154.541 56.2355 154.541 56.2302L154.556 50.9669C154.557 50.5763 154.392 50.2835 154.057 50.087C153.724 49.8928 153.39 49.8906 153.056 50.087L147.369 53.4025C147.037 53.5967 146.704 53.5967 146.371 53.4025L140.666 50.0794C140.512 49.9884 140.345 49.9437 140.167 49.9437C139.988 49.9437 139.821 49.9899 139.667 50.0794C139.512 50.1704 139.391 50.2933 139.301 50.4503C139.212 50.6058 139.167 50.7742 139.167 50.9555V60.4681C139.167 60.6486 139.123 60.8155 139.034 60.9732C138.945 61.1302 138.824 61.2531 138.669 61.3441C138.515 61.4336 138.349 61.4799 138.171 61.4799C137.992 61.4799 137.826 61.4374 137.672 61.3479L134.504 59.5176C134.168 59.3212 134 59.0284 134 58.6362L134.028 42.0103C134.028 41.8298 134.073 41.6629 134.163 41.5052C134.252 41.3497 134.374 41.2276 134.528 41.1358C134.682 41.0463 134.849 41 135.027 41C135.206 41 135.371 41.0448 135.526 41.1343L146.372 47.4383C146.703 47.6302 147.035 47.6302 147.367 47.4383L158.21 41.1343C158.365 41.0448 158.532 41 158.71 41C158.889 41 159.055 41.0463 159.21 41.138C159.364 41.2276 159.486 41.352 159.575 41.5067C159.664 41.6637 159.708 41.8328 159.708 42.0134V58.6438C159.708 59.0345 159.541 59.3257 159.207 59.5214L153.529 62.8308C153.194 63.025 153.028 63.3186 153.029 63.7084C153.029 64.0991 153.197 64.3918 153.533 64.5845L156.666 66.389C156.997 66.5817 157.328 66.5794 157.658 66.389L164.343 62.5031V62.5024Z"
        fill="url(#paint43_linear_736_21041)"
      />
    </g>
    <defs>
      <radialGradient
        id="paint0_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(152 92) rotate(180) scale(152 152)"
      >
        <stop stopColor="white" />
        <stop offset={1} stopColor="white" stopOpacity={0.5} />
      </radialGradient>
      <radialGradient
        id="paint1_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(188 89) rotate(-138.366) scale(96.3327 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.25} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.75} />
      </radialGradient>
      <radialGradient
        id="paint2_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(116 25) rotate(41.6335) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint3_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(244 25) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint4_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(316 89) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint5_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(-12 25) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint6_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(60 89) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint7_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(116 -45) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint8_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(188 19) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint9_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(244 -45) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint10_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(316 19) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint11_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(-12 -45) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint12_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(60 19) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint13_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(188 159) rotate(-138.366) scale(96.3327 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.25} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.75} />
      </radialGradient>
      <radialGradient
        id="paint14_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(116 95) rotate(41.6335) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint15_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(244 95) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint16_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(316 159) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint17_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(-12 95) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint18_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(60 159) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint19_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(116 165) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint20_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(188 229) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint21_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(244 165) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint22_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(316 229) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint23_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(-12 165) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint24_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(60 229) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint25_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(252 124) rotate(-138.366) scale(96.3327 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.25} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.75} />
      </radialGradient>
      <radialGradient
        id="paint26_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(180 60) rotate(41.6335) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint27_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(180 130) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint28_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(252 194) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint29_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(124 124) rotate(-138.366) scale(96.3327 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.25} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.75} />
      </radialGradient>
      <radialGradient
        id="paint30_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(52 60) rotate(41.6335) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint31_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(52 130) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint32_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(124 194) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint33_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(52 -10) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint34_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(124 54) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint35_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(180 -10) rotate(41.6335) scale(96.3328 221.952)"
      >
        <stop stopColor="#4D4DB3" stopOpacity={0} />
        <stop offset={0.333333} stopColor="#4D4DB3" stopOpacity={0.05} />
        <stop offset={0.666667} stopColor="#4D4DB3" stopOpacity={0.1} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0.2} />
      </radialGradient>
      <radialGradient
        id="paint36_radial_736_21041"
        cx={0}
        cy={0}
        r={1}
        gradientUnits="userSpaceOnUse"
        gradientTransform="translate(252 54) rotate(-138.366) scale(96.3328 95.6684)"
      >
        <stop stopColor="#4D4DB3" />
        <stop offset={0.5} stopColor="#4D4DB3" stopOpacity={0.3} />
        <stop offset={1} stopColor="#4D4DB3" stopOpacity={0} />
      </radialGradient>
      <linearGradient
        id="paint37_linear_736_21041"
        x1={70}
        y1={74}
        x2={106}
        y2={110}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#339AF0" />
        <stop offset={1} stopColor="#3BC9DB" />
      </linearGradient>
      <linearGradient
        id="paint38_linear_736_21041"
        x1={214.611}
        y1={74}
        x2={229.684}
        y2={83.167}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#4285EB" />
        <stop offset={1} stopColor="#2EC7FF" />
      </linearGradient>
      <linearGradient
        id="paint39_linear_736_21041"
        x1={216.628}
        y1={74}
        x2={209.14}
        y2={112.539}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#29CDFF" />
        <stop offset={0.378601} stopColor="#148EFF" />
        <stop offset={1} stopColor="#0A60FF" />
      </linearGradient>
      <linearGradient
        id="paint40_linear_736_21041"
        x1={231.3}
        y1={83.2515}
        x2={221.578}
        y2={98.3933}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FA816E" />
        <stop offset={0.414726} stopColor="#F74A5C" />
        <stop offset={1} stopColor="#F51D2C" />
      </linearGradient>
      <linearGradient
        id="paint41_linear_736_21041"
        x1={217.63}
        y1={84.7971}
        x2={214.389}
        y2={97.7083}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FA8E7D" />
        <stop offset={0.512635} stopColor="#F74A5C" />
        <stop offset={1} stopColor="#F51D2C" />
      </linearGradient>
      <linearGradient
        id="paint42_linear_736_21041"
        x1={170}
        y1={145}
        x2={134}
        y2={109}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#7BCBD4" />
        <stop offset={1} stopColor="#29C6B7" />
      </linearGradient>
      <linearGradient
        id="paint43_linear_736_21041"
        x1={170}
        y1={72.5}
        x2={134}
        y2={41}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0059B2" />
        <stop offset={1} stopColor="#3399FF" />
      </linearGradient>
    </defs>
  </svg>
);
