import React from "react";

export const LandingAppCrmSvg = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    width={1168}
    height={736}
    fill="none"
    viewBox="0 0 1168 736"
    {...props}
  >
    <path fill="#F4F8FB" d="M0 0h1168v736H0z" />
    <rect width={200} height={376} x={12} y={88} fill="#F4F8FB" rx={32} />
    <rect
      width={176}
      height={40}
      x={24}
      y={100}
      fill="#6EB3F7"
      fillOpacity={0.1}
      rx={20}
    />
    <g clipPath="url(#clip0_1_3812)">
      <path
        fill="#0080FF"
        fillRule="evenodd"
        d="M41 114.8a6 6 0 0 1 8.2 8.2.67.67 0 1 0 1.15.67 7.33 7.33 0 1 0-12.7 0 .67.67 0 0 0 1.16-.67 6 6 0 0 1 2.2-8.2Zm6.14 3a.67.67 0 0 0-.94-.94l-2.67 2.67a.67.67 0 0 0 .94.94l2.67-2.66Z"
        clipRule="evenodd"
      />
    </g>
    <path
      fill="#0080FF"
      d="M68.38 125h-3.15v-10.18h3.28c1 0 1.84.2 2.54.61a4 4 0 0 1 1.62 1.74c.37.76.56 1.66.56 2.72 0 1.06-.2 1.97-.57 2.74a4.03 4.03 0 0 1-1.65 1.76c-.72.4-1.6.61-2.63.61Zm-1.91-1.1h1.83c.84 0 1.54-.16 2.09-.48a3 3 0 0 0 1.24-1.39c.27-.6.4-1.31.4-2.14 0-.82-.13-1.53-.4-2.12a2.97 2.97 0 0 0-1.2-1.38 3.8 3.8 0 0 0-2-.48h-1.96v8Zm10.91 1.28c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.08-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4a2.68 2.68 0 0 1 1.89-1.63 4.54 4.54 0 0 1 2.02-.07c.32.06.63.18.92.36.3.18.56.45.76.8.2.37.3.85.3 1.46V125H79.7v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.06c.47 0 .86-.09 1.18-.27a1.87 1.87 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.84 29.84 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.27.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm10.87-5.05-1.05.3a1.96 1.96 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.3.21-.46.48-.46.81 0 .3.1.52.32.7.2.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.77.34.33.5.77.5 1.3 0 .44-.12.83-.37 1.17-.25.35-.6.62-1.05.82-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.48-1.32c0-.43.12-.81.36-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm3.08 1.34V125h-1.17v-10.18h1.17v3.74h.1c.18-.4.45-.71.8-.94.37-.24.85-.36 1.45-.36.52 0 .98.1 1.37.32.39.2.7.52.9.95.23.42.33.96.33 1.62V125H95.3v-4.77c0-.6-.16-1.08-.47-1.41-.31-.33-.75-.5-1.3-.5-.38 0-.73.08-1.03.24-.3.16-.54.4-.72.71a2.3 2.3 0 0 0-.26 1.14Zm7.26 4.59v-10.18h1.17v3.76h.1l.36-.51c.16-.2.38-.4.67-.56.29-.16.68-.25 1.18-.25a3.04 3.04 0 0 1 2.85 1.85c.27.6.41 1.29.41 2.1 0 .8-.14 1.5-.41 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.52 7.52 0 0 1-.37-.53h-.14V125h-1.13Zm1.15-3.82c0 .58.09 1.09.26 1.53.17.44.41.78.74 1.03.32.24.72.37 1.2.37s.9-.13 1.22-.4c.33-.25.58-.6.74-1.05.17-.44.26-.94.26-1.48s-.08-1.02-.25-1.45a2.25 2.25 0 0 0-.74-1.03 1.96 1.96 0 0 0-1.24-.38 1.96 1.96 0 0 0-1.94 1.37c-.16.42-.25.92-.25 1.5Zm10.49 3.98c-.7 0-1.3-.16-1.82-.5a3.34 3.34 0 0 1-1.2-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.82-.5a3.3 3.3 0 0 1 3.02 1.87c.3.6.44 1.3.44 2.1 0 .78-.15 1.47-.44 2.06-.29.59-.7 1.05-1.21 1.38a3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .95-.14 1.3-.4.33-.28.58-.63.74-1.07a4.1 4.1 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.28.4c-.34.28-.6.63-.76 1.08a4.1 4.1 0 0 0-.24 1.42c0 .51.08.99.24 1.42.17.44.42.8.76 1.06.33.27.77.4 1.29.4Zm7.5 1.07c-.49 0-.93-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19a52 52 0 0 1 1.12-.13c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.55.5-.68.78l-1.1-.4a2.68 2.68 0 0 1 1.88-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V125h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.32.17l-.58.12a29.9 29.9 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.23.7c0 .41.15.72.45.93.3.2.69.3 1.16.3Zm5.46.88v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.67 3.67 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.72 1.72 0 0 0-.94 1.56V125h-1.16Zm7.86.16a3 3 0 0 1-2.83-1.85c-.28-.6-.41-1.3-.41-2.1 0-.81.14-1.5.41-2.1a3.04 3.04 0 0 1 2.85-1.85c.5 0 .89.09 1.18.25.29.16.51.35.66.56l.37.5h.1v-3.75h1.17V125h-1.13v-1.17h-.14l-.37.52c-.16.21-.39.4-.68.57-.3.16-.7.24-1.18.24Zm.16-1.05c.47 0 .87-.13 1.2-.37.32-.25.56-.6.73-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.24-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.25.4-.32.24-.57.59-.74 1.02a4.1 4.1 0 0 0-.24 1.45c0 .54.08 1.04.25 1.48.17.44.42.8.75 1.06s.74.39 1.23.39Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M47.33 165.33a.67.67 0 0 0-1.33 0v.67h-4v-.67a.67.67 0 0 0-1.33 0v.67h-1.34a2 2 0 0 0-2 2v9.33c0 1.1.9 2 2 2h9.34a2 2 0 0 0 2-2V168a2 2 0 0 0-2-2h-1.34v-.67Zm2 4.67v-2c0-.37-.3-.67-.66-.67h-1.34v.67a.67.67 0 0 1-1.33 0v-.67h-4v.67a.67.67 0 0 1-1.33 0v-.67h-1.34c-.36 0-.66.3-.66.67v2h10.66Zm-10.66 1.33h10.66v6c0 .37-.3.67-.66.67h-9.34a.67.67 0 0 1-.66-.67v-6Zm2 2c0-.37.3-.66.66-.66h.01a.67.67 0 1 1 0 1.33.67.67 0 0 1-.67-.67Zm3.33-.66a.67.67 0 1 0 0 1.33.67.67 0 0 0 0-1.33Zm2 .66c0-.37.3-.66.67-.66a.67.67 0 1 1 0 1.33.67.67 0 0 1-.67-.67Zm-4.67 2a.67.67 0 0 0 0 1.34h.01a.67.67 0 0 0 0-1.34Zm2 .67a.67.67 0 1 1 .67.67.67.67 0 0 1-.67-.67Zm3.34-.67a.67.67 0 0 0 0 1.34.67.67 0 0 0 0-1.34Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M73.43 170h-1.24a2.57 2.57 0 0 0-1.04-1.61 2.78 2.78 0 0 0-.85-.42 3.39 3.39 0 0 0-2.65.33c-.5.31-.89.77-1.18 1.38-.3.6-.44 1.35-.44 2.23 0 .88.14 1.63.44 2.23.3.6.69 1.07 1.18 1.38.5.31 1.06.47 1.68.47.34 0 .66-.05.97-.14.32-.1.6-.23.85-.42a2.63 2.63 0 0 0 1.04-1.61h1.24a3.81 3.81 0 0 1-2.65 3.1c-.45.15-.94.22-1.45.22-.87 0-1.64-.21-2.32-.64a4.37 4.37 0 0 1-1.6-1.8 6.2 6.2 0 0 1-.57-2.8c0-1.06.19-2 .58-2.78a4.27 4.27 0 0 1 3.91-2.45c.51 0 1 .08 1.45.23a3.95 3.95 0 0 1 2.14 1.7c.24.41.41.88.5 1.4Zm4.08 7.18c-.49 0-.93-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.05-.19l1.13-.13c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.11-.4a2.68 2.68 0 0 1 1.89-1.63 4.54 4.54 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V177h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.87 1.87 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.32.17l-.58.12a29.93 29.93 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.24.7c0 .41.16.72.46.93.3.2.69.3 1.16.3Zm6.63-9.3V177h-1.17v-10.18h1.17Zm5.35 10.34a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.02h4.7c0-.43-.1-.81-.27-1.15a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm6.12-4.75V177h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.4-.36.53 0 .98.11 1.37.32.38.21.69.53.9.96.22.42.32.96.32 1.6V177H99.5v-4.77c0-.6-.15-1.07-.47-1.4-.3-.34-.74-.51-1.28-.51-.37 0-.7.08-1 .24-.3.16-.53.4-.7.71-.16.31-.25.7-.25 1.14Zm9.9 4.75a3 3 0 0 1-2.83-1.85c-.27-.6-.41-1.3-.41-2.1 0-.81.14-1.5.41-2.1a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.17.51.35.67.56l.36.5h.1v-3.75h1.17V177h-1.13v-1.17h-.14l-.37.52c-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.2-.36.32-.25.57-.6.73-1.03.17-.44.26-.95.26-1.53 0-.57-.09-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.24.4-.33.24-.58.59-.74 1.02a4.1 4.1 0 0 0-.25 1.45c0 .54.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Zm7.9 1.08c-.48 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19l1.13-.13c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.66-.41-1.2-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.53 4.53 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V177h-1.17v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.69.2-1.13.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.88 1.88 0 0 0 .98-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a29.98 29.98 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm5.46.88v-7.64h1.14v1.16h.08c.13-.38.39-.69.75-.92.37-.24.78-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.6 3.6 0 0 0-.72-.08c-.37 0-.7.08-.99.23a1.71 1.71 0 0 0-.93 1.56V177h-1.18Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M38.67 219.33c0-.37.3-.66.66-.66h9.34c.36 0 .66.3.66.66v9.34c0 .37-.3.66-.66.66h-9.34a.67.67 0 0 1-.66-.66v-9.34Zm.66-2a2 2 0 0 0-2 2v9.34c0 1.1.9 2 2 2h9.34a2 2 0 0 0 2-2v-9.34a2 2 0 0 0-2-2h-9.34Zm2.67 3.34a.67.67 0 0 0-1.33 0v4.66a.67.67 0 1 0 1.33 0v-4.66Zm2-.67c.37 0 .67.3.67.67v2.66a.67.67 0 1 1-1.34 0v-2.66c0-.37.3-.67.67-.67Zm3.33.67a.67.67 0 0 0-1.33 0v6a.67.67 0 0 0 1.33 0v-6Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M70.8 221.36c-.06-.5-.3-.9-.72-1.17a2.79 2.79 0 0 0-1.57-.42c-.45 0-.84.08-1.18.22-.33.15-.6.35-.78.6a1.44 1.44 0 0 0-.09 1.57c.13.2.3.36.5.49.21.12.43.23.65.31l.63.2 1.03.27c.27.07.56.17.88.29.33.12.65.29.94.5.3.21.55.48.75.8.2.34.3.74.3 1.22 0 .55-.15 1.04-.44 1.49-.28.44-.7.8-1.25 1.06s-1.21.39-2 .39c-.72 0-1.36-.12-1.89-.35a2.8 2.8 0 0 1-1.76-2.45h1.27c.03.38.16.7.39.95.22.25.51.43.86.56.35.12.73.18 1.13.18.48 0 .9-.08 1.27-.23.38-.16.67-.38.9-.65.21-.28.32-.6.32-.97 0-.34-.1-.62-.28-.83a2.07 2.07 0 0 0-.75-.52 7.7 7.7 0 0 0-1-.34l-1.25-.36a4.67 4.67 0 0 1-1.89-.98c-.46-.43-.7-.98-.7-1.67 0-.57.16-1.06.47-1.49.3-.43.73-.76 1.25-1a4.22 4.22 0 0 1 1.76-.35c.66 0 1.24.12 1.75.35.51.23.92.55 1.22.96.3.4.46.86.47 1.37H70.8Zm6.3 7.8a3.3 3.3 0 0 1-1.85-.5 3.3 3.3 0 0 1-1.19-1.4 4.73 4.73 0 0 1-.42-2.04c0-.77.15-1.46.43-2.05a3.23 3.23 0 0 1 3.01-1.9c.54 0 1.02.1 1.46.3a2.6 2.6 0 0 1 1.57 2.09h-1.18a1.78 1.78 0 0 0-1.83-1.33c-.45-.01-.85.1-1.2.35-.34.23-.6.56-.8 1a3.7 3.7 0 0 0-.28 1.5c0 .6.09 1.1.28 1.54.18.44.45.78.8 1.02.34.24.74.36 1.2.36.3 0 .59-.05.83-.15a1.7 1.7 0 0 0 1-1.18h1.18a2.72 2.72 0 0 1-1.52 2.08c-.43.2-.92.3-1.49.3Zm4.72-.16v-7.64h1.14v1.16h.08c.13-.38.39-.69.75-.92.37-.24.78-.36 1.23-.36a14.78 14.78 0 0 1 .62.02v1.2a3.66 3.66 0 0 0-.72-.08c-.37 0-.7.08-.99.23a1.71 1.71 0 0 0-.93 1.56V229h-1.18Zm10.02-3.12v-4.52h1.18V229h-1.18v-1.3h-.08a2.5 2.5 0 0 1-.83 1c-.38.27-.86.4-1.43.4-.48 0-.9-.1-1.28-.31a2.2 2.2 0 0 1-.87-.96 3.63 3.63 0 0 1-.32-1.61v-4.86h1.17v4.78c0 .55.16 1 .47 1.33.32.33.72.5 1.2.5a2 2 0 0 0 1.97-2.1Zm3.33 3.12v-7.64h1.13v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.28-.35s.92.12 1.25.35c.34.22.6.54.8.95h.08c.19-.4.48-.71.88-.94.39-.24.86-.36 1.4-.36.68 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V229h-1.17v-5.11c0-.56-.16-.97-.47-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.24.49-.3.32-.45.72-.45 1.22V229h-1.19v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V229h-1.17Zm12.32 0v-10.18h1.18v3.76h.1c.08-.14.2-.3.35-.51.16-.2.38-.4.67-.56.3-.16.69-.25 1.18-.25a3.03 3.03 0 0 1 2.85 1.85c.28.6.41 1.29.41 2.1 0 .8-.13 1.5-.4 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.88 7.88 0 0 1-.38-.53h-.13V229h-1.14Zm1.16-3.82c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.72.36 1.2.36s.9-.12 1.22-.38c.33-.26.58-.62.75-1.06.17-.44.25-.94.25-1.48 0-.53-.08-1.02-.25-1.45-.16-.43-.4-.78-.74-1.03a1.96 1.96 0 0 0-1.24-.38 1.95 1.95 0 0 0-1.94 1.37c-.16.42-.24.92-.24 1.5Zm10.48 3.98c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.05 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.06c.53 0 .96-.13 1.3-.4.33-.27.58-.62.74-1.06a4.1 4.1 0 0 0 0-2.85c-.16-.44-.4-.8-.75-1.06a2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07c-.17.45-.25.92-.25 1.43 0 .51.08.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm7.5 1.08c-.48 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19l1.13-.13c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.66-.41-1.2-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.55 4.55 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V229h-1.17v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.88 1.88 0 0 0 .98-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a29 29 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm5.46.88v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.6 3.6 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.71 1.71 0 0 0-.94 1.56V229h-1.16Zm7.86.16a3 3 0 0 1-2.83-1.85c-.27-.6-.41-1.3-.41-2.1 0-.81.14-1.5.41-2.1a3.03 3.03 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.17.51.35.67.56l.36.5h.1v-3.75h1.17V229h-1.13v-1.17h-.14l-.37.52c-.16.21-.39.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.2-.36.32-.25.56-.6.73-1.03.17-.44.26-.95.26-1.53 0-.57-.08-1.07-.25-1.5a1.95 1.95 0 0 0-1.94-1.37c-.5 0-.91.14-1.24.4-.33.24-.58.59-.74 1.02-.17.43-.25.92-.25 1.45 0 .54.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M41.1 269.45a.72.72 0 0 0-.74.73v12.37h7.28v-12.37a.73.73 0 0 0-.73-.73h-5.82Zm-2.2.73v5.1h-.72a2.18 2.18 0 0 0-2.18 2.18v4.36a2.18 2.18 0 0 0 2.18 2.18h11.64a2.18 2.18 0 0 0 2.18-2.18v-6.55a2.18 2.18 0 0 0-2.18-2.18h-.73v-2.9a2.18 2.18 0 0 0-2.18-2.19h-5.82a2.18 2.18 0 0 0-2.18 2.18Zm10.2 4.37v8h.72a.72.72 0 0 0 .73-.73v-6.55a.73.73 0 0 0-.73-.72h-.73Zm-10.92 2.18h.73v5.81h-.73a.72.72 0 0 1-.73-.72v-4.37a.73.73 0 0 1 .73-.72Zm3.64-5.1c0-.4.32-.72.73-.72h2.9a.73.73 0 0 1 0 1.45h-2.9a.73.73 0 0 1-.73-.72Zm.73 2.19a.73.73 0 0 0 0 1.45h2.9a.73.73 0 0 0 0-1.45h-2.9Zm-.73 3.63c0-.4.32-.72.73-.72h2.9a.73.73 0 0 1 0 1.45h-2.9a.73.73 0 0 1-.73-.73Zm.73 2.19a.73.73 0 0 0 0 1.45h2.9a.73.73 0 0 0 0-1.45h-2.9Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M73.43 274h-1.24a2.57 2.57 0 0 0-1.04-1.61 2.78 2.78 0 0 0-.85-.42 3.39 3.39 0 0 0-2.65.33c-.5.31-.89.77-1.18 1.38-.3.6-.44 1.35-.44 2.23 0 .88.14 1.63.44 2.23.3.6.69 1.07 1.18 1.38.5.31 1.06.47 1.68.47.34 0 .66-.05.97-.14.32-.1.6-.23.85-.42a2.63 2.63 0 0 0 1.04-1.61h1.24a3.81 3.81 0 0 1-2.65 3.1c-.45.14-.94.22-1.45.22-.87 0-1.64-.21-2.32-.64a4.37 4.37 0 0 1-1.6-1.8 6.2 6.2 0 0 1-.57-2.8c0-1.06.19-2 .58-2.77a4.27 4.27 0 0 1 3.91-2.45c.51 0 1 .07 1.45.22a3.95 3.95 0 0 1 2.14 1.7c.24.41.41.88.5 1.4Zm4.93 7.16c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.32.93.79 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.06c.53 0 .96-.13 1.3-.4.33-.27.58-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.25-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07 4.1 4.1 0 0 0-.25 1.43c0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm5.25.9v-7.64h1.14v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.27-.35.5 0 .93.12 1.26.35.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.86-.36 1.4-.36.7 0 1.25.22 1.68.65.44.42.66 1.08.66 1.98V281h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.54 0-.95.16-1.25.49-.3.32-.44.73-.44 1.22V281h-1.2v-5.23c0-.43-.13-.78-.41-1.05-.29-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.64.68a2 2 0 0 0-.23.99V281H83.6Zm12.17 2.86v-10.5h1.13v1.22h.14l.36-.51c.16-.2.38-.4.67-.56.29-.16.68-.25 1.18-.25a3.03 3.03 0 0 1 2.85 1.85c.28.6.41 1.29.41 2.1 0 .8-.13 1.5-.41 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.55 7.55 0 0 1-.37-.53h-.1v4.03h-1.17Zm1.15-6.68c0 .58.09 1.09.26 1.53.17.44.41.78.74 1.03.32.24.72.37 1.2.37s.9-.13 1.22-.4c.33-.25.58-.6.75-1.05.17-.44.25-.94.25-1.48s-.08-1.02-.25-1.45c-.16-.43-.4-.78-.74-1.03a1.96 1.96 0 0 0-1.24-.38 1.96 1.96 0 0 0-1.94 1.37c-.16.42-.25.92-.25 1.5Zm9.63 4c-.48 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.19a52 52 0 0 1 1.13-.13c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.68 2.68 0 0 1 1.9-1.63 4.55 4.55 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V281h-1.17v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.87 1.87 0 0 0 .98-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a29.9 29.9 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm6.63-3.71V281h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V281h-1.18v-4.77c0-.6-.15-1.07-.46-1.4-.32-.34-.74-.51-1.29-.51-.37 0-.7.08-1 .24-.3.16-.52.4-.7.71-.16.31-.25.7-.25 1.14Zm7.02 4.59v-7.64h1.17V281h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.23 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm5.92 9.06a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07.29-.6.7-1.06 1.2-1.4a3.6 3.6 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.35.21.77.31 1.24.31.31 0 .6-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.05.68c-.41.16-.88.24-1.4.24Zm10.36-6.09-1.05.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.47.48-.47.81 0 .3.11.52.32.7.22.16.55.3 1 .42l1.13.27c.68.17 1.2.42 1.53.76.33.34.5.78.5 1.31 0 .44-.13.83-.38 1.18-.25.34-.6.61-1.04.81-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.32-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.45-.29.75 0 1.34.17 1.78.5.43.33.74.77.92 1.31Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M39.64 324.36a2.18 2.18 0 1 1 4.36 0 2.18 2.18 0 0 1-4.36 0Zm2.18-3.63a3.64 3.64 0 1 0 0 7.27 3.64 3.64 0 0 0 0-7.27Zm-2.18 8.72A3.64 3.64 0 0 0 36 333.1v1.46a.73.73 0 1 0 1.45 0v-1.46a2.18 2.18 0 0 1 2.19-2.18H44a2.18 2.18 0 0 1 2.18 2.18v1.46a.73.73 0 1 0 1.46 0v-1.46a3.64 3.64 0 0 0-3.64-3.63h-4.36Zm8.75.65c.1-.4.5-.63.88-.53A3.64 3.64 0 0 1 52 333.1v1.46a.73.73 0 1 1-1.45 0v-1.46a2.18 2.18 0 0 0-1.64-2.1.73.73 0 0 1-.52-.9Zm-1.3-9.25a.73.73 0 1 0-.36 1.4 2.18 2.18 0 0 1 0 4.23.73.73 0 0 0 .36 1.41 3.63 3.63 0 0 0 0-7.04Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M73.43 326h-1.24a2.57 2.57 0 0 0-1.04-1.61 2.78 2.78 0 0 0-.85-.42 3.39 3.39 0 0 0-2.65.33c-.5.31-.89.77-1.18 1.38-.3.6-.44 1.35-.44 2.23 0 .88.14 1.63.44 2.23.3.6.69 1.07 1.18 1.38.5.31 1.06.47 1.68.47.34 0 .66-.05.97-.14.32-.1.6-.23.85-.42a2.63 2.63 0 0 0 1.04-1.61h1.24a3.81 3.81 0 0 1-2.65 3.1c-.45.14-.94.22-1.45.22-.87 0-1.64-.21-2.32-.64a4.37 4.37 0 0 1-1.6-1.8 6.2 6.2 0 0 1-.57-2.8c0-1.06.19-2 .58-2.77a4.27 4.27 0 0 1 3.91-2.45c.51 0 1 .07 1.45.22a3.95 3.95 0 0 1 2.14 1.7c.24.41.41.88.5 1.4Zm4.93 7.16c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.32.93.79 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.06c.53 0 .96-.13 1.3-.4.33-.27.58-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.25-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07 4.1 4.1 0 0 0-.25 1.43c0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm6.43-3.7v4.6H83.6v-7.64h1.14v1.2h.1c.17-.4.45-.7.81-.94.37-.24.84-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V333h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.33-3.04v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.32-.02.2-.04.23 1.05a2.38 2.38 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm6.82 9.65c-.49 0-.93-.1-1.32-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.36-.07.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.11-.4a2.68 2.68 0 0 1 1.89-1.63 4.54 4.54 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V333h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.17-1.06c.47 0 .86-.09 1.18-.27a1.88 1.88 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.9 29.9 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.46.93.3.2.69.3 1.15.3Zm8.57 1.04a3.3 3.3 0 0 1-1.85-.5 3.3 3.3 0 0 1-1.2-1.4 4.72 4.72 0 0 1-.41-2.04c0-.77.14-1.46.43-2.05a3.23 3.23 0 0 1 3.01-1.9c.54 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.78 1.78 0 0 0-1.83-1.33c-.46-.01-.86.1-1.2.35-.35.23-.61.56-.8 1a3.7 3.7 0 0 0-.29 1.5c0 .6.1 1.1.28 1.54.19.44.45.78.8 1.02.34.24.75.37 1.2.37.31 0 .6-.06.84-.16a1.71 1.71 0 0 0 1-1.18h1.17a2.72 2.72 0 0 1-1.52 2.08c-.42.2-.92.3-1.48.3Zm8.04-7.8v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.4 2.4 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.93 1.93 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm9.84 3.54-1.06.3a1.96 1.96 0 0 0-.3-.51c-.12-.17-.29-.3-.5-.42-.23-.1-.5-.16-.85-.16a2 2 0 0 0-1.17.32c-.3.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.05.81-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.1.41.3.72.6.93.3.2.7.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.29-.66a1.76 1.76 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.48-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.74.77.93 1.31Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M39.33 374.67c-.36 0-.66.3-.66.66v.78a2 2 0 0 1 .66-.11h9.34a2 2 0 0 1 .66.11v-.78c0-.37-.3-.66-.66-.66h-9.34Zm-.47 2.86c-.12.12-.2.3-.2.47v.67H40c.66 0 1.38.24 1.87.78l.69.57.04.04a1.99 1.99 0 0 0 2.91-.04l.71-.58a2.74 2.74 0 0 1 1.85-.77h1.26V378a.67.67 0 0 0-.66-.67h-9.34a.67.67 0 0 0-.47.2ZM49.33 380h-1.26a1.41 1.41 0 0 0-.98.45l-.71.58a3.32 3.32 0 0 1-4.7 0l-.7-.58a.6.6 0 0 1-.1-.09c-.17-.22-.5-.36-.88-.36h-1.33v4.67c0 .37.3.66.66.66h9.34c.36 0 .66-.3.66-.66V380Zm-12-.67v5.34c0 1.1.9 2 2 2h9.34a2 2 0 0 0 2-2v-9.34a2 2 0 0 0-2-2h-9.34a2 2 0 0 0-2 2v4Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M68.93 381.82h1.35l1.14 1.49.3.4 1.69 2.25h-1.36l-1.11-1.5-.28-.38-1.73-2.26Zm4.9-1.91c0 1.07-.2 2-.59 2.78a4.37 4.37 0 0 1-1.6 1.81c-.67.43-1.44.64-2.31.64-.87 0-1.64-.21-2.32-.64a4.37 4.37 0 0 1-1.6-1.8 6.2 6.2 0 0 1-.57-2.8c0-1.06.19-2 .58-2.77a4.27 4.27 0 0 1 3.91-2.45c.87 0 1.64.21 2.32.63.67.43 1.2 1.03 1.6 1.81.38.79.57 1.71.57 2.79Zm-1.2 0c0-.88-.15-1.63-.44-2.23a3.08 3.08 0 0 0-2.86-1.85 3.1 3.1 0 0 0-2.86 1.85c-.3.6-.44 1.35-.44 2.23 0 .88.14 1.63.44 2.23.3.6.69 1.07 1.18 1.38.5.31 1.06.47 1.68.47a3.08 3.08 0 0 0 2.86-1.85c.3-.6.44-1.35.44-2.23Zm7.92 1.97v-4.52h1.17V385h-1.17v-1.3h-.08a2.5 2.5 0 0 1-.83 1c-.38.26-.86.4-1.44.4-.47 0-.9-.1-1.27-.31a2.2 2.2 0 0 1-.87-.96 3.63 3.63 0 0 1-.32-1.61v-4.86h1.17v4.78c0 .55.16 1 .47 1.33.31.33.71.5 1.2.5a2 2 0 0 0 1.97-2.1Zm6.42 3.28c-.68 0-1.29-.17-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.81-.5.7 0 1.3.17 1.81.5.53.32.93.79 1.22 1.38.29.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.06c.53 0 .96-.13 1.3-.4.34-.27.59-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07 4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm8.58-6.74v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.37 2.37 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm7.68 9.63a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.41.16-.88.24-1.4.24Zm10.36-6.09-1.06.3a1.96 1.96 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.05.81-.44.2-.96.3-1.56.3-.77 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.7.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.28-.66a1.76 1.76 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.87 1.87 0 0 1-.5-1.32c0-.43.13-.81.37-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Z"
    />
    <path
      fill="#6C7793"
      fillRule="evenodd"
      d="M37.03 426.07a.67.67 0 0 1 .8.16l3.4 3.95 2.2-3.84a.67.67 0 0 1 1.15 0l2.2 3.84 3.38-3.95a.67.67 0 0 1 1.15.6l-2 8c-.07.3-.34.5-.64.5h-9.34c-.3 0-.57-.2-.64-.5l-2-8a.67.67 0 0 1 .34-.76Zm1.64 3.18 1.18 4.75h8.3l1.19-4.75-2.17 2.52a.67.67 0 0 1-1.08-.1L44 428l-2.09 3.65a.67.67 0 0 1-1.08.1l-2.16-2.51Zm0 8.08c0-.37.3-.66.66-.66h9.34a.67.67 0 1 1 0 1.33h-9.34a.67.67 0 0 1-.66-.67Z"
      clipRule="evenodd"
    />
    <path
      fill="#474E6B"
      d="M65.65 437h-1.3l3.75-10.18h1.27L73.1 437h-1.3l-3.04-8.57h-.08L65.65 437Zm.48-3.98h5.2v1.1h-5.2v-1.1Zm11.29 4.14a3 3 0 0 1-2.83-1.86c-.28-.59-.41-1.29-.41-2.1 0-.8.13-1.5.4-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.19.25.29.17.51.35.66.56l.37.5h.1v-3.75h1.17V437h-1.14v-1.17h-.13l-.37.52c-.16.21-.39.4-.68.56-.3.17-.7.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.2-.36.32-.25.56-.6.73-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.24-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.25.4-.32.24-.57.59-.74 1.02a4.1 4.1 0 0 0-.24 1.45c0 .55.08 1.04.25 1.48.17.44.42.8.74 1.06.34.26.75.38 1.24.38Zm5.65.9v-7.64h1.13v1.2h.1c.16-.41.42-.73.77-.95.36-.23.78-.35 1.28-.35s.92.12 1.26.35c.34.22.6.54.79.95h.08c.2-.4.49-.71.88-.94.39-.24.86-.36 1.4-.36.69 0 1.25.22 1.68.65.44.42.65 1.08.65 1.98V437h-1.17v-5.11c0-.56-.15-.97-.46-1.2-.31-.25-.67-.37-1.1-.37-.53 0-.94.16-1.24.49-.3.32-.44.73-.44 1.22V437h-1.2v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.64-.4-1.09-.4-.3 0-.59.08-.85.24-.26.16-.48.39-.64.68a2 2 0 0 0-.24.99V437h-1.17Zm12.17 0v-7.64h1.17V437H95.4Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.59.23Zm3.9 4.3v4.6h-1.18v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V437h-1.18v-4.77c0-.6-.15-1.07-.47-1.4-.3-.34-.73-.51-1.28-.51-.37 0-.7.08-1 .24-.3.16-.52.4-.7.71-.16.31-.25.7-.25 1.14Zm7.01 4.6v-7.64h1.17V437h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.25-.57a.83.83 0 0 1 .59-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm8.13 2.97-1.05.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.31.7.22.16.55.3 1 .42l1.13.27c.69.17 1.2.42 1.53.76.33.34.5.78.5 1.31 0 .44-.13.83-.38 1.18-.25.34-.6.61-1.04.81-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.37-1.14.24-.33.57-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.23-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.66-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm4.56 9.47v-7.64h1.14v1.16h.08c.14-.38.39-.69.75-.92.37-.24.78-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.67 3.67 0 0 0-.72-.08c-.37 0-.7.08-.99.23a1.72 1.72 0 0 0-.93 1.56V437h-1.18Zm7.46.18c-.49 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.19l1.13-.13c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.66-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.55.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.55 4.55 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V437h-1.18v-1.03h-.05a2.3 2.3 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.88 1.88 0 0 0 .97-1.61v-1.08c-.04.06-.15.12-.32.17l-.58.12a29 29 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.69.3 1.16.3Zm8.78-6.76v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.34 2.34 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.78-.66c-.21-.29-.31-.66-.31-1.1v-7.6Zm4.57 9.47v-7.64h1.17V437h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.16.16.25.35.25.56 0 .22-.09.41-.25.57a.82.82 0 0 1-.59.23Zm5.82 9.06c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5s1.3.17 1.81.5c.52.32.92.79 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07c-.28.59-.69 1.05-1.21 1.38a3.3 3.3 0 0 1-1.8.49Zm0-1.06c.52 0 .95-.13 1.3-.4.33-.27.58-.62.74-1.06a4.1 4.1 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4c-.33.28-.58.63-.74 1.07a4.1 4.1 0 0 0-.25 1.43c0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm6.42-3.7v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.46-.7.82-.94.37-.24.84-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V437h-1.18v-4.77c0-.6-.15-1.07-.46-1.4-.31-.34-.74-.51-1.29-.51-.37 0-.7.08-1 .24-.3.16-.52.4-.7.71-.16.31-.25.7-.25 1.14Z"
    />
    <path fill="#fff" d="M0 0h1168v64H0z" />
    <path fill="#fff" d="M0 12h232v40H0z" />
    <path
      fill="#0080FF"
      fillRule="evenodd"
      d="M28 44a12 12 0 1 0 0-24 12 12 0 0 0 0 24Zm3.74-18.41c.19-.65-.44-1.03-1.02-.62l-8 5.7c-.63.45-.53 1.33.14 1.33h2.11v-.02h4.11l-3.35 1.19-1.47 5.24c-.19.65.44 1.03 1.02.62l8-5.7c.63-.45.53-1.33-.14-1.33h-3.2l1.8-6.41Z"
      clipRule="evenodd"
    />
    <path
      fill="#14141F"
      d="M48.88 37V26.82h4.02c.77 0 1.43.14 1.97.41.55.27.96.66 1.25 1.16.29.5.43 1.08.43 1.75 0 .68-.14 1.26-.44 1.75-.29.48-.71.85-1.26 1.11-.55.26-1.22.4-2 .4h-2.7v-1.74h2.35c.41 0 .75-.06 1.02-.17.28-.11.48-.28.61-.5.14-.23.2-.51.2-.85 0-.33-.06-.62-.2-.85-.13-.23-.34-.4-.61-.53a2.5 2.5 0 0 0-1.03-.18h-1.45V37h-2.16Zm5.5-4.63L56.91 37h-2.37l-2.48-4.63h2.32Zm7.01 4.78c-.79 0-1.46-.16-2.03-.48-.56-.32-1-.77-1.3-1.36a4.5 4.5 0 0 1-.46-2.1c0-.78.15-1.47.46-2.06.3-.6.73-1.06 1.29-1.39.55-.33 1.2-.5 1.96-.5.5 0 .97.09 1.4.25a3.12 3.12 0 0 1 1.91 1.93c.18.49.27 1.05.27 1.7v.58h-6.44v-1.3h4.45c0-.31-.07-.58-.2-.82a1.42 1.42 0 0 0-.55-.55c-.23-.14-.5-.2-.81-.2a1.57 1.57 0 0 0-1.43.82c-.14.24-.21.5-.22.81v1.25c0 .38.07.7.21.98.15.27.35.49.6.63a2 2 0 0 0 1.57.12c.2-.06.36-.16.5-.29.14-.13.25-.3.32-.49l1.96.13c-.1.47-.3.88-.61 1.24-.3.34-.7.62-1.18.81-.49.2-1.04.29-1.67.29Zm9-7.79v1.6h-4.72v-1.6h4.71ZM66.74 37v-8.19c0-.55.1-1.01.32-1.38.22-.36.52-.63.9-.82.38-.18.8-.27 1.28-.27a4.9 4.9 0 0 1 1.5.21l-.38 1.6a2.65 2.65 0 0 0-.67-.12c-.31 0-.53.07-.65.22a.9.9 0 0 0-.19.6V37h-2.11Zm4.93 0v-7.64h2.12V37h-2.12Zm1.06-8.62c-.31 0-.58-.1-.8-.31a1.02 1.02 0 0 1-.34-.76 1 1 0 0 1 .33-.76c.23-.2.5-.31.81-.31.32 0 .58.1.8.31.23.21.34.46.34.76a1 1 0 0 1-.33.76c-.23.2-.5.3-.8.3Zm4.87 4.2V37h-2.12v-7.64h2.02v1.35h.09c.17-.44.45-.8.85-1.05.4-.26.88-.4 1.45-.4.53 0 .99.12 1.38.35.4.23.7.57.92 1 .22.42.33.93.33 1.53V37h-2.12v-4.48c0-.47-.11-.84-.35-1.1-.25-.26-.58-.4-1-.4-.29 0-.54.07-.76.19-.21.12-.38.3-.5.54-.13.23-.19.5-.19.84Zm10.07 4.57c-.78 0-1.46-.16-2.03-.48-.56-.32-1-.77-1.3-1.36a4.5 4.5 0 0 1-.46-2.1c0-.78.15-1.47.46-2.06.3-.6.73-1.06 1.29-1.39.55-.33 1.2-.5 1.96-.5.5 0 .97.09 1.4.25a3.12 3.12 0 0 1 1.91 1.93c.18.49.28 1.05.28 1.7v.58h-6.45v-1.3h4.45c0-.31-.06-.58-.2-.82a1.42 1.42 0 0 0-.55-.55c-.23-.14-.5-.2-.8-.2a1.57 1.57 0 0 0-1.43.82c-.15.24-.22.5-.22.81v1.25c0 .38.07.7.2.98.15.27.35.49.6.63.26.15.57.23.93.23a2 2 0 0 0 .64-.1 1.3 1.3 0 0 0 .82-.79l1.96.13c-.1.47-.3.88-.61 1.24-.3.34-.7.62-1.18.81-.48.2-1.04.29-1.67.29Zm17.15-6.77h-2.18a2.13 2.13 0 0 0-.24-.75 1.9 1.9 0 0 0-1.14-.92 2.55 2.55 0 0 0-.8-.13c-.54 0-1 .13-1.39.4-.39.25-.69.63-.9 1.13a4.5 4.5 0 0 0-.33 1.8c0 .72.1 1.33.32 1.83s.53.87.92 1.12a2.68 2.68 0 0 0 2.16.26 1.9 1.9 0 0 0 1.14-.88c.13-.2.21-.45.26-.72l2.18.01a3.94 3.94 0 0 1-1.32 2.51c-.38.34-.82.6-1.34.8-.52.2-1.1.3-1.76.3-.9 0-1.72-.2-2.43-.62-.72-.4-1.28-1-1.7-1.78a6 6 0 0 1-.61-2.83c0-1.11.2-2.06.63-2.83.41-.78.98-1.38 1.7-1.78a5.21 5.21 0 0 1 4.06-.37c.5.16.95.4 1.34.72.4.32.7.7.95 1.16.25.46.41.98.48 1.57Zm1.55 6.62V26.82h4.01c.77 0 1.43.14 1.97.41.55.27.96.66 1.25 1.16.29.5.43 1.08.43 1.75 0 .68-.14 1.26-.44 1.75-.29.48-.71.85-1.26 1.11-.55.26-1.22.4-2 .4h-2.7v-1.74H110c.41 0 .75-.06 1.02-.17.27-.11.48-.28.61-.5.14-.23.2-.51.2-.85 0-.33-.06-.62-.2-.85-.13-.23-.34-.4-.61-.53a2.5 2.5 0 0 0-1.03-.18h-1.45V37h-2.16Zm5.5-4.63L114.4 37h-2.37l-2.48-4.63h2.32Zm3.68-5.55h2.66l2.8 6.84h.12l2.8-6.84h2.66V37h-2.09v-6.63h-.08l-2.64 6.58h-1.42l-2.64-6.6h-.08V37h-2.09V26.82Z"
    />
    <rect width={32} height={32} x={1072} y={16} fill="#EDF2F7" rx={16} />
    <path
      fill="#6C7793"
      d="M1092.75 36h-.37v-5.31c0-2.2-1.63-4.03-3.75-4.33v-.61a.63.63 0 0 0-1.25 0v.6a4.37 4.37 0 0 0-3.75 4.34v5.3h-.38a.5.5 0 0 0-.5.5v.5c0 .08.06.13.13.13h3.37a1.75 1.75 0 1 0 3.5 0h3.38c.06 0 .12-.05.12-.12v-.5a.5.5 0 0 0-.5-.5Zm-4.75 1.87a.75.75 0 0 1-.75-.75h1.5c0 .42-.34.75-.75.75Zm-3.25-1.87v-5.31a3.24 3.24 0 1 1 6.5 0v5.3h-6.5Z"
    />
    <rect
      width={32}
      height={32}
      x={1120}
      y={16}
      fill="url(#pattern0)"
      rx={16}
    />
    <rect width={255} height={31} x={456.5} y={16.5} fill="#fff" rx={15.5} />
    <g clipPath="url(#clip1_1_3812)">
      <path
        fill="#A3ADC2"
        d="m481.21 37.35-4.06-4.05a4.66 4.66 0 0 0-3.72-7.54 4.66 4.66 0 0 0-4.68 4.68 4.66 4.66 0 0 0 4.69 4.69c1.05 0 2.04-.34 2.85-.97l4.06 4.05a.13.13 0 0 0 .1.04h.04l.04-.04.68-.68a.14.14 0 0 0 .03-.04.14.14 0 0 0 0-.1.14.14 0 0 0-.03-.04Zm-5.3-4.44a3.48 3.48 0 0 1-4.95 0 3.48 3.48 0 0 1 0-4.95 3.48 3.48 0 0 1 4.95 0 3.48 3.48 0 0 1 0 4.95Z"
      />
    </g>
    <path
      fill="#A3ADC2"
      d="M496.8 29.36c-.06-.5-.3-.9-.73-1.17a2.78 2.78 0 0 0-1.56-.42c-.45 0-.84.08-1.18.22-.33.15-.6.35-.78.6a1.45 1.45 0 0 0-.09 1.57c.13.2.3.36.5.49.21.12.43.23.65.3.23.09.44.15.63.2l1.03.28c.27.07.56.17.88.29.33.12.65.29.94.5a2.32 2.32 0 0 1 1.04 2.01c0 .56-.14 1.05-.43 1.5-.28.44-.7.8-1.25 1.06s-1.21.39-2 .39c-.72 0-1.36-.12-1.89-.35a2.8 2.8 0 0 1-1.76-2.45h1.27c.03.38.16.7.39.95s.51.43.86.56c.35.12.73.18 1.13.18.48 0 .9-.08 1.27-.23.38-.16.67-.37.9-.65.21-.28.32-.6.32-.97 0-.34-.1-.62-.28-.83a2.08 2.08 0 0 0-.75-.52 7.8 7.8 0 0 0-1-.34l-1.25-.36a4.67 4.67 0 0 1-1.89-.98c-.46-.43-.7-.98-.7-1.67 0-.57.16-1.06.47-1.49.3-.43.72-.76 1.25-1a4.23 4.23 0 0 1 1.76-.35c.66 0 1.24.12 1.75.35.51.23.92.55 1.22.96.3.4.46.86.47 1.37h-1.19Zm6.4 7.8a3.6 3.6 0 0 1-1.9-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.92 2.92 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.9v-1.01h4.7c0-.44-.08-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm7.2.02c-.49 0-.93-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.18l1.12-.14c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.55.5-.68.78l-1.1-.4a2.68 2.68 0 0 1 1.88-1.63 4.54 4.54 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V37h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.18-1.05c.46 0 .85-.1 1.17-.28a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.15.12-.32.17a5.55 5.55 0 0 1-1.21.21l-.5.06c-.3.04-.58.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.24.7c0 .41.16.72.46.93.3.2.69.3 1.16.3Zm5.46.87v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a13.15 13.15 0 0 1 .62.02v1.2a3.46 3.46 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.71 1.71 0 0 0-.94 1.56V37h-1.16Zm8.08.16a3.3 3.3 0 0 1-1.85-.5 3.3 3.3 0 0 1-1.2-1.4 4.74 4.74 0 0 1-.41-2.04c0-.77.14-1.46.43-2.05a3.23 3.23 0 0 1 3.01-1.9c.54 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.81 1.81 0 0 0-1.83-1.34c-.46 0-.86.12-1.2.36-.35.23-.61.56-.8 1a3.7 3.7 0 0 0-.29 1.5c0 .6.1 1.1.28 1.54.19.44.45.78.8 1.02.34.24.74.37 1.2.37.31 0 .59-.06.84-.16a1.71 1.71 0 0 0 1-1.18h1.17a2.71 2.71 0 0 1-1.52 2.08c-.43.2-.92.3-1.48.3ZM530 32.4V37h-1.17V26.82H530v3.74h.1c.18-.4.45-.71.8-.94a2.6 2.6 0 0 1 1.45-.36c.52 0 .97.1 1.36.32.4.2.7.52.91.95.22.42.33.96.33 1.62V37h-1.17v-4.77c0-.6-.16-1.08-.47-1.41-.32-.33-.75-.5-1.3-.5-.39 0-.73.08-1.04.24-.3.16-.54.4-.71.71-.17.31-.26.7-.26 1.14Z"
    />
    <rect width={20} height={20} x={687} y={22} fill="#EDF2F7" rx={10} />
    <path fill="#A3ADC2" d="m698.87 26.86-2.82 10.45h-.92l2.82-10.45h.92Z" />
    <rect
      width={255}
      height={31}
      x={456.5}
      y={16.5}
      stroke="#CFD7E2"
      rx={15.5}
    />
    <foreignObject x={224} y={88} width={296} height={136}>
      <svg
        id="thing"
        xmlns="http://www.w3.org/2000/svg"
        width={296}
        height={136}
        fill="none"
        viewBox="0 0 296 136"
        {...props}
      >
        <g clipPath="url(#clip0_1_3910)">
          <rect width={296} height={136} fill="#fff" rx={16} />
          <path
            fill="#6C7793"
            d="M77.3 26.82V37h-1.19l-5.54-8h-.1v8h-1.24V26.82h1.2l5.56 8.01h.1v-8.01h1.22Zm7.13 7.06v-4.52h1.17V37h-1.17v-1.3h-.08a2.5 2.5 0 0 1-.84 1c-.38.27-.85.4-1.43.4-.48 0-.9-.1-1.27-.31a2.2 2.2 0 0 1-.88-.96 3.62 3.62 0 0 1-.32-1.61v-4.86h1.18v4.78c0 .55.15 1 .47 1.33.31.33.71.5 1.2.5a2 2 0 0 0 1.97-2.1ZM87.75 37v-7.64h1.13v1.2h.1c.16-.41.42-.73.77-.95a2.3 2.3 0 0 1 1.28-.35c.5 0 .92.12 1.26.35.34.22.6.54.79.95h.08c.2-.4.49-.71.88-.94.39-.24.86-.36 1.4-.36.69 0 1.25.22 1.68.65.44.42.65 1.08.65 1.98V37H96.6v-5.11c0-.56-.16-.97-.46-1.2-.31-.25-.67-.37-1.1-.37-.53 0-.94.16-1.24.49-.3.32-.44.72-.44 1.22V37h-1.2v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.64-.4-1.09-.4-.3 0-.59.08-.85.24-.26.16-.48.39-.64.68a2 2 0 0 0-.24.99V37h-1.17Zm12.33 0V26.82h1.17v3.76h.1l.36-.51c.15-.2.38-.4.66-.56.3-.16.69-.25 1.19-.25a3.03 3.03 0 0 1 2.85 1.85c.27.6.4 1.29.4 2.1 0 .8-.13 1.5-.4 2.1a2.99 2.99 0 0 1-2.83 1.85c-.5 0-.89-.08-1.18-.24-.3-.17-.52-.36-.68-.57a7.86 7.86 0 0 1-.37-.52h-.14V37h-1.13Zm1.15-3.82c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.73.37 1.2.37.49 0 .9-.13 1.23-.4.33-.25.58-.6.74-1.05.17-.44.25-.93.25-1.48 0-.54-.08-1.02-.24-1.45-.17-.43-.41-.78-.74-1.03a1.96 1.96 0 0 0-1.24-.38 1.96 1.96 0 0 0-1.94 1.37c-.17.42-.25.92-.25 1.5Zm10.58 3.98a3.26 3.26 0 0 1-3.13-1.86 4.67 4.67 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07.3-.6.7-1.06 1.2-1.4a3.62 3.62 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm4.95-.16v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.78-.36 1.23-.36a13.07 13.07 0 0 1 .62.02v1.2a3.46 3.46 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.72 1.72 0 0 0-.93 1.56V37h-1.17Zm12.25.16c-.69 0-1.3-.16-1.81-.5a3.35 3.35 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.06 1.21-1.38.53-.33 1.13-.5 1.82-.5.69 0 1.3.17 1.81.5.52.32.92.79 1.21 1.38.3.6.44 1.29.44 2.08a4.6 4.6 0 0 1-.44 2.07 3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .96-.14 1.3-.4.33-.28.58-.63.74-1.07a4.08 4.08 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07c-.17.45-.25.92-.25 1.43 0 .51.08.99.25 1.42.16.44.4.8.75 1.06.34.27.77.4 1.29.4Zm8.65-6.75v1h-4.12v-1h4.12ZM134.78 37v-8.69c0-.44.1-.8.3-1.1.21-.29.48-.5.8-.65a2.94 2.94 0 0 1 2.15-.02l-.33 1.01a5.95 5.95 0 0 0-.25-.07c-.1-.03-.24-.05-.4-.05-.4 0-.67.1-.84.3-.17.2-.26.48-.26.86V37h-1.17Zm11.57.16a3.3 3.3 0 0 1-1.85-.5c-.52-.35-.92-.81-1.2-1.4a4.74 4.74 0 0 1-.41-2.04c0-.77.14-1.46.42-2.05.3-.6.7-1.06 1.2-1.4.52-.34 1.13-.5 1.82-.5.53 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.79 1.79 0 0 0-1.83-1.33c-.46-.01-.86.1-1.2.35-.35.23-.62.56-.8 1a3.7 3.7 0 0 0-.3 1.5c0 .6.1 1.1.29 1.54.19.44.45.78.8 1.02.34.24.74.37 1.2.37.31 0 .59-.06.84-.16a1.72 1.72 0 0 0 1-1.18h1.17a2.71 2.71 0 0 1-1.52 2.08c-.43.2-.92.3-1.48.3Zm7.82 0c-.7 0-1.3-.16-1.82-.5a3.34 3.34 0 0 1-1.21-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.82-.5a3.3 3.3 0 0 1 3.02 1.87c.3.6.44 1.3.44 2.1a4.6 4.6 0 0 1-.44 2.06 3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .95-.14 1.29-.4.34-.28.59-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43-.16-.44-.41-.8-.75-1.06a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07 4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.16.44.42.8.75 1.06.34.27.77.4 1.3.4Zm5.25.89v-7.64h1.13v1.2h.1c.16-.41.42-.73.77-.95.36-.23.78-.35 1.28-.35s.92.12 1.26.35c.33.22.6.54.79.95h.08c.2-.4.49-.71.88-.94.39-.24.86-.36 1.4-.36.69 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V37h-1.17v-5.11c0-.56-.16-.97-.47-1.2-.3-.25-.67-.37-1.08-.37-.54 0-.96.16-1.25.49-.3.32-.44.72-.44 1.22V37h-1.2v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.65-.4-1.09-.4-.3 0-.59.08-.85.24-.27.16-.48.39-.64.68-.16.28-.24.61-.24.99V37h-1.17Zm12.17 2.86v-10.5h1.13v1.22h.14c.08-.14.2-.3.36-.51.15-.2.37-.4.66-.56.3-.16.69-.25 1.19-.25a3.03 3.03 0 0 1 2.84 1.85c.28.6.42 1.29.42 2.1 0 .8-.14 1.5-.42 2.1a2.99 2.99 0 0 1-2.83 1.85c-.49 0-.88-.08-1.17-.24-.3-.17-.53-.36-.68-.57a7.5 7.5 0 0 1-.37-.52h-.1v4.03h-1.17Zm1.15-6.68c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.73.37 1.2.37.49 0 .9-.13 1.22-.4.34-.25.58-.6.75-1.05.17-.44.25-.93.25-1.48 0-.54-.08-1.02-.25-1.45-.16-.43-.4-.78-.74-1.03a1.95 1.95 0 0 0-1.23-.38 1.96 1.96 0 0 0-1.94 1.37c-.17.42-.25.92-.25 1.5Zm9.62 4c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.35-.08.7-.14 1.06-.18l1.13-.14c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4c.2-.46.46-.82.8-1.08.33-.26.7-.44 1.09-.55a4.54 4.54 0 0 1 2.01-.07c.33.06.64.18.94.36.3.18.55.45.75.8.2.37.3.85.3 1.46V37h-1.18v-1.03h-.06a2.29 2.29 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.05c.47 0 .86-.1 1.18-.28a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17a5.55 5.55 0 0 1-1.2.21l-.5.06c-.3.04-.59.1-.85.2-.27.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.7.3 1.16.3Zm6.64-3.72V37H188v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .97.11 1.35.32.4.21.7.53.9.96.22.42.33.96.33 1.6V37h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm7.01 4.59v-7.64h1.18V37h-1.18Zm.6-8.9a.83.83 0 0 1-.59-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.16.16.25.35.25.57 0 .21-.09.4-.25.56a.82.82 0 0 1-.59.23Zm5.93 9.06a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.92 2.92 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5H200v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.32 1.25.32.3 0 .59-.05.83-.13.26-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm10.35-6.09-1.05.3a1.96 1.96 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.3.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.05.81-.44.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.1.41.3.72.6.93.3.2.7.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.29-.66a1.77 1.77 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.87 1.87 0 0 1-.48-1.32c0-.43.12-.81.36-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.43.33.74.77.92 1.31Z"
          />
          <path
            fill="#14141F"
            d="M79.43 89.36c-1.7 0-3.23-.32-4.58-.96a8.16 8.16 0 0 1-3.2-2.66 7.04 7.04 0 0 1-1.26-3.86H75a3.63 3.63 0 0 0 1.4 2.63 4.73 4.73 0 0 0 3.04 1.01 4.58 4.58 0 0 0 4.2-2.42 5.2 5.2 0 0 0 .6-2.59c.01-.99-.2-1.87-.62-2.63a4.69 4.69 0 0 0-1.75-1.8 4.89 4.89 0 0 0-2.56-.67c-.78 0-1.55.14-2.31.44s-1.36.69-1.8 1.17l-4.29-.7 1.37-13.5h15.19v3.96H76.19l-.75 6.94h.15a5.4 5.4 0 0 1 2.06-1.42 7.26 7.26 0 0 1 2.92-.57 8.06 8.06 0 0 1 7.18 4.2 9.14 9.14 0 0 1 1.08 4.47c0 1.73-.4 3.27-1.2 4.62a8.5 8.5 0 0 1-3.32 3.19c-1.4.76-3.03 1.15-4.88 1.15Zm22.98 0c-1.9 0-3.58-.32-5.06-.96a8.43 8.43 0 0 1-3.45-2.62 6.15 6.15 0 0 1-1.23-3.8c0-1.1.23-2.1.72-3.03a6.75 6.75 0 0 1 4.75-3.49v-.18a5.54 5.54 0 0 1-3.27-2.06 5.94 5.94 0 0 1-1.23-3.74c0-1.35.37-2.55 1.13-3.6a7.67 7.67 0 0 1 3.12-2.5c1.32-.61 2.83-.92 4.53-.92 1.67 0 3.17.3 4.48.92a7.67 7.67 0 0 1 3.12 2.5 5.98 5.98 0 0 1 1.15 3.6c0 1.41-.42 2.66-1.26 3.74a5.52 5.52 0 0 1-3.24 2.06v.18a6.75 6.75 0 0 1 4.73 3.49c.5.92.74 1.93.74 3.03 0 1.42-.41 2.68-1.25 3.8a8.43 8.43 0 0 1-3.45 2.62 12.4 12.4 0 0 1-5.02.96Zm0-3.66c.98 0 1.84-.16 2.56-.5a3.87 3.87 0 0 0 2.3-3.55c0-.84-.22-1.57-.65-2.21-.42-.65-1-1.16-1.73-1.52a5.42 5.42 0 0 0-2.47-.55c-.94 0-1.78.18-2.51.55-.73.36-1.31.87-1.74 1.52a3.88 3.88 0 0 0-.61 2.2 3.72 3.72 0 0 0 2.27 3.55c.73.34 1.6.51 2.59.51Zm0-11.93c.8 0 1.51-.16 2.13-.48a3.7 3.7 0 0 0 2.02-3.36c-.01-.75-.2-1.41-.54-1.97a3.46 3.46 0 0 0-1.46-1.32 4.69 4.69 0 0 0-2.14-.47c-.83 0-1.56.16-2.2.47a3.46 3.46 0 0 0-1.95 3.29c0 .75.16 1.42.51 2 .36.57.85 1.03 1.47 1.36.64.32 1.36.48 2.17.48Z"
          />
          <path
            stroke="#0080FF"
            strokeLinecap="round"
            strokeLinejoin="round"
            strokeWidth={1.33}
            d="m80 113.33 2.67 2.67-2.67 2.67M72 113.33 69.33 116l2.67 2.67M69.33 116h13.34"
          />
          <path
            fill="#0080FF"
            d="M92.33 111.27V120h-1.59v-7.19h-.05l-2.04 1.3v-1.44l2.17-1.4h1.5Zm5.31 8.85c-.63 0-1.2-.1-1.68-.32-.5-.21-.88-.5-1.15-.87-.28-.38-.42-.8-.41-1.27 0-.37.07-.7.23-1a2.24 2.24 0 0 1 1.59-1.17v-.06c-.45-.1-.81-.33-1.1-.69a1.98 1.98 0 0 1-.4-1.25c0-.45.12-.85.38-1.2.25-.35.6-.63 1.03-.83.45-.2.95-.3 1.51-.3s1.06.1 1.5.3c.44.2.79.48 1.04.83a2 2 0 0 1 .38 1.2 1.97 1.97 0 0 1-1.5 1.94v.06a2.24 2.24 0 0 1 1.82 2.17c0 .47-.13.9-.41 1.27-.28.36-.66.66-1.15.87-.49.21-1.05.32-1.68.32Zm0-1.22c.33 0 .61-.06.86-.17.24-.1.42-.27.56-.47.13-.2.2-.44.2-.71 0-.28-.07-.52-.21-.74a1.44 1.44 0 0 0-.58-.5 1.8 1.8 0 0 0-.83-.19c-.3 0-.59.06-.83.19-.25.12-.44.29-.58.5-.14.22-.2.46-.2.74a1.24 1.24 0 0 0 .75 1.18c.25.11.53.17.86.17Zm0-3.98c.27 0 .5-.05.71-.16a1.24 1.24 0 0 0 .67-1.12 1.15 1.15 0 0 0-.66-1.1c-.2-.1-.45-.15-.72-.15-.27 0-.52.05-.73.16a1.15 1.15 0 0 0-.65 1.1c0 .24.06.47.17.66.12.2.29.34.5.45.2.11.44.16.71.16Zm9.31 3.44v-.46c0-.34.08-.65.22-.93a1.72 1.72 0 0 1 1.63-.95c.4 0 .74.1 1.01.26.28.17.48.4.62.69.14.28.21.6.21.93v.46c0 .34-.07.65-.2.94-.15.28-.36.51-.64.68-.27.18-.6.26-1 .26s-.74-.08-1.01-.26c-.28-.17-.49-.4-.63-.68a2.1 2.1 0 0 1-.2-.94Zm1.12-.46v.46c0 .23.05.43.16.62.1.19.3.28.57.28.27 0 .46-.09.56-.27.11-.2.16-.4.16-.63v-.46c0-.22-.05-.43-.15-.62-.1-.19-.29-.28-.57-.28-.27 0-.46.1-.57.28-.1.19-.16.4-.16.62Zm-5.55-4.53v-.46c0-.34.07-.65.22-.94.14-.28.35-.51.63-.68.27-.17.6-.26 1-.26s.73.09 1 .26c.28.17.49.4.63.68.14.29.2.6.2.94v.46c0 .34-.06.65-.2.94-.14.28-.35.5-.63.67-.27.17-.6.26-1 .26s-.74-.08-1.02-.26c-.27-.17-.48-.4-.62-.68s-.21-.6-.21-.93Zm1.12-.46v.46c0 .23.05.43.16.62.1.19.3.28.57.28.27 0 .46-.1.56-.28.1-.19.16-.4.16-.62v-.46c0-.23-.05-.44-.15-.62-.1-.2-.3-.29-.57-.29-.27 0-.46.1-.57.29-.1.19-.16.4-.16.62ZM103 120l6-8.73h1.07l-6 8.73H103Z"
          />
          <path
            fill="#6C7793"
            d="m120 110.86-2.8 10.45h-.93l2.81-10.45h.93Zm1.2 9.14v-6.55h.97v1.03h.08c.14-.35.36-.62.67-.82.3-.2.66-.3 1.09-.3.43 0 .8.1 1.08.3.29.2.51.47.68.82h.06c.17-.34.42-.6.76-.8.33-.21.74-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V120h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V120h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.5.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V120h-1.01Zm13.09.14c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.12-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.44.28.79.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .81-.12 1.1-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.07 2.07 0 0 0-.64-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.11.35-.3.23-.5.54-.65.92-.13.38-.2.78-.2 1.22 0 .44.07.84.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Zm5.5-3.18V120h-1v-6.55h.97v1.03h.08c.16-.34.4-.6.7-.8.32-.2.72-.31 1.21-.31.45 0 .84.09 1.17.27.33.18.59.45.77.82.19.36.28.82.28 1.38V120h-1v-4.1c0-.5-.14-.9-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.33 0-.61.07-.87.21a1.5 1.5 0 0 0-.59.61c-.14.27-.22.6-.22.97Zm8.86-2.6v.85h-3.39v-.86h3.4Zm-2.4-1.57h1v6.23c0 .29.05.5.13.64.09.14.2.24.32.28.14.05.28.07.43.07l.27-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm5.06 4.17V120h-1v-8.73h1v3.2h.09c.15-.33.38-.6.69-.8.3-.2.72-.3 1.23-.3.45 0 .84.09 1.18.27.33.17.6.44.78.81.18.36.28.83.28 1.4V120h-1v-4.1c0-.51-.14-.91-.41-1.2a1.45 1.45 0 0 0-1.12-.43c-.32 0-.62.07-.88.21-.26.14-.47.34-.62.61-.14.27-.22.6-.22.97Z"
          />
          <rect width={40} height={40} x={12} y={12} fill="#F4F8FB" rx={20} />
          <path
            fill="#0080FF"
            fillRule="evenodd"
            d="M29.1 25.45a.73.73 0 0 0-.74.73V38.55h7.28V26.18a.73.73 0 0 0-.73-.73h-5.82Zm-2.2.73v5.1h-.72A2.18 2.18 0 0 0 24 33.44v4.37A2.18 2.18 0 0 0 26.18 40h11.64A2.18 2.18 0 0 0 40 37.82v-6.55a2.18 2.18 0 0 0-2.18-2.18h-.73v-2.9A2.18 2.18 0 0 0 34.91 24h-5.82a2.18 2.18 0 0 0-2.18 2.18Zm10.2 4.37v8h.72a.73.73 0 0 0 .73-.73v-6.55a.73.73 0 0 0-.73-.72h-.73Zm-10.92 2.18h.73v5.82h-.73a.73.73 0 0 1-.73-.73v-4.37a.73.73 0 0 1 .73-.72Zm3.64-5.1c0-.4.32-.72.73-.72h2.9a.73.73 0 0 1 0 1.45h-2.9a.73.73 0 0 1-.73-.72Zm.73 2.19a.73.73 0 1 0 0 1.45h2.9a.73.73 0 0 0 0-1.45h-2.9Zm-.73 3.63c0-.4.32-.72.73-.72h2.9a.73.73 0 0 1 0 1.45h-2.9a.73.73 0 0 1-.73-.73Zm.73 2.19a.73.73 0 1 0 0 1.45h2.9a.73.73 0 0 0 0-1.45h-2.9Z"
            clipRule="evenodd"
          />
          <path
            fill="url(#paint0_linear_1_3910)"
            d="M200.32 79c-7.68 0-13.28-2.57-16.32-3.86V100h96V52s-12.48 5.01-16.8 7.71-8.16 7.72-15.36 7.72c-7.2 0-7.2-3.86-15.84-3.86S208 79 200.32 79Z"
          />
          <path
            stroke="#fff"
            strokeLinecap="round"
            strokeWidth={6}
            d="M184 75.14c3.04 1.29 8.64 3.86 16.32 3.86S223.36 63.57 232 63.57s8.64 3.86 15.84 3.86c7.2 0 11.04-5.02 15.36-7.72S280 52 280 52"
          />
          <path
            stroke="#0080FF"
            strokeLinecap="round"
            strokeWidth={2}
            d="M184 75.14c3.04 1.29 8.64 3.86 16.32 3.86S223.36 63.57 232 63.57s8.64 3.86 15.84 3.86c7.2 0 11.04-5.02 15.36-7.72S280 52 280 52"
          />
          <circle
            cx={296}
            r={120}
            fill="url(#paint1_radial_1_3910)"
            fillOpacity={0.3}
            opacity={0.5}
          />
        </g>
        <defs>
          <radialGradient
            id="paint1_radial_1_3910"
            cx={0}
            cy={0}
            r={1}
            gradientTransform="matrix(0 120 -120 0 296 0)"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0080FF" />
            <stop offset={1} stopColor="#0080FF" stopOpacity={0} />
          </radialGradient>
          <linearGradient
            id="paint0_linear_1_3910"
            x1={232}
            x2={232}
            y1={52}
            y2={100}
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0080FF" stopOpacity={0.25} />
            <stop offset={1} stopColor="#0080FF" stopOpacity={0} />
          </linearGradient>
          <clipPath id="clip0_1_3910">
            <rect width={296} height={136} fill="#fff" rx={16} />
          </clipPath>
        </defs>
      </svg>
    </foreignObject>
    <g clipPath="url(#clip3_1_3812)">
      <rect width={296} height={136} x={536} y={88} fill="#fff" rx={16} />
      <path
        fill="#6C7793"
        d="M613.3 114.82V125h-1.19l-5.54-8h-.1v8h-1.24v-10.18h1.2l5.56 8.01h.1v-8.01h1.22Zm7.13 7.06v-4.52h1.17V125h-1.17v-1.3h-.08c-.18.4-.46.72-.84 1-.38.27-.85.4-1.43.4-.48 0-.9-.1-1.27-.31a2.2 2.2 0 0 1-.88-.96 3.63 3.63 0 0 1-.31-1.61v-4.86h1.17v4.78c0 .55.15 1 .47 1.33.31.33.71.5 1.2.5a2 2 0 0 0 1.97-2.1Zm3.32 3.12v-7.64h1.13v1.2h.1c.16-.41.42-.73.77-.95.36-.23.78-.35 1.28-.35s.92.12 1.26.35c.34.22.6.54.79.95h.08c.2-.4.49-.71.88-.94.39-.24.86-.36 1.4-.36.69 0 1.25.22 1.68.65.43.42.65 1.08.65 1.98V125h-1.17v-5.11c0-.56-.15-.97-.46-1.2-.31-.25-.67-.37-1.1-.37-.53 0-.94.16-1.24.49-.3.32-.44.72-.44 1.22V125h-1.2v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.64-.4-1.09-.4-.3 0-.59.08-.85.24-.26.16-.48.39-.64.68-.16.28-.24.61-.24.99V125h-1.17Zm12.33 0v-10.18h1.17v3.76h.1l.36-.51c.15-.2.38-.4.66-.56.3-.16.69-.25 1.19-.25a3.03 3.03 0 0 1 2.85 1.85c.27.6.4 1.29.4 2.1 0 .8-.13 1.5-.4 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.88 7.88 0 0 1-.37-.53h-.14V125h-1.13Zm1.15-3.82c0 .58.09 1.09.25 1.53.17.44.42.78.74 1.03.33.24.73.37 1.2.37.49 0 .9-.13 1.23-.4.33-.25.58-.6.74-1.05.17-.44.25-.94.25-1.48s-.08-1.02-.24-1.45c-.17-.43-.41-.78-.74-1.03a1.96 1.96 0 0 0-1.24-.38 1.96 1.96 0 0 0-1.94 1.37c-.17.42-.25.92-.25 1.5Zm10.59 3.98a3.27 3.27 0 0 1-3.13-1.86 4.67 4.67 0 0 1-.43-2.06c0-.78.14-1.47.42-2.07.3-.6.7-1.06 1.2-1.4a3.61 3.61 0 0 1 2.99-.3 2.94 2.94 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.02h4.7c0-.43-.1-.81-.26-1.15a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.88.12-1.22.36-.34.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.35.21.77.31 1.25.31.3 0 .58-.04.83-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm4.94-.16v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.37-.24.78-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.67 3.67 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.72 1.72 0 0 0-.93 1.56V125h-1.17Zm12.25.16c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5s1.3.17 1.81.5c.52.32.92.78 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .96-.14 1.3-.4.33-.28.58-.63.74-1.07a4.08 4.08 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.08c-.17.44-.25.91-.25 1.42 0 .51.08.99.25 1.42.16.44.4.8.75 1.06a2 2 0 0 0 1.29.4Zm8.65-6.75v1h-4.12v-1h4.12Zm-2.88 7.64v-8.69c0-.44.1-.8.3-1.1.21-.29.48-.5.8-.65a2.9 2.9 0 0 1 2.15-.02l-.33 1.01a6 6 0 0 0-.25-.07c-.1-.03-.24-.05-.4-.05-.4 0-.67.1-.84.3-.17.2-.26.48-.26.86V125h-1.17Zm11.57.16a3.3 3.3 0 0 1-1.85-.5c-.52-.35-.92-.81-1.2-1.4a4.74 4.74 0 0 1-.41-2.04c0-.77.14-1.46.42-2.05.3-.6.7-1.06 1.2-1.4.52-.34 1.13-.5 1.82-.5.53 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.78 1.78 0 0 0-1.83-1.33c-.46-.01-.86.1-1.2.35-.35.23-.62.56-.8 1a3.7 3.7 0 0 0-.3 1.5c0 .6.1 1.1.29 1.54.19.44.45.78.8 1.02.34.24.74.37 1.2.37.31 0 .59-.06.84-.16a1.71 1.71 0 0 0 1-1.18h1.17a2.72 2.72 0 0 1-1.52 2.08c-.43.2-.92.3-1.48.3Zm7.82 0c-.7 0-1.3-.16-1.82-.5a3.34 3.34 0 0 1-1.21-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.82-.5.69 0 1.29.17 1.8.5.53.32.93.78 1.22 1.38.3.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .95-.14 1.29-.4.34-.28.59-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.42-.16-.45-.41-.8-.75-1.07a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.08 4.1 4.1 0 0 0 0 2.84c.16.44.42.8.75 1.06.34.27.77.4 1.3.4Zm6.42-3.7V125h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.4-.36.52 0 .98.11 1.37.32.38.21.68.53.9.96.22.42.32.96.32 1.6V125h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.3-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.34-3.05v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.15.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.34 2.34 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19a52 52 0 0 1 1.13-.13c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.66-.41-1.2-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.68 2.68 0 0 1 1.9-1.63 4.55 4.55 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V125h-1.17v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.86 1.86 0 0 0 .98-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a29.9 29.9 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm8.56 1.04a3.3 3.3 0 0 1-1.84-.5 3.3 3.3 0 0 1-1.2-1.4 4.74 4.74 0 0 1-.42-2.04c0-.77.15-1.46.43-2.05a3.23 3.23 0 0 1 3.01-1.9c.54 0 1.02.1 1.46.3a2.6 2.6 0 0 1 1.57 2.09h-1.18a1.78 1.78 0 0 0-1.83-1.33c-.45-.01-.85.1-1.2.35-.34.23-.6.56-.8 1a3.7 3.7 0 0 0-.28 1.5c0 .6.09 1.1.27 1.54.2.44.46.78.8 1.02.35.24.75.37 1.21.37.3 0 .59-.06.83-.16a1.71 1.71 0 0 0 1-1.18h1.18a2.73 2.73 0 0 1-1.53 2.08c-.42.2-.91.3-1.48.3Zm8.04-7.8v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm9.84 3.54-1.05.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.47.48-.47.81 0 .3.11.52.32.7.22.16.55.3 1 .42l1.13.27c.68.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.13.83-.38 1.17-.25.35-.6.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.32-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.37-1.14.24-.33.57-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Z"
      />
      <path
        fill="#14141F"
        d="M616.98 150.82V177h-4.75v-21.57h-.15l-6.12 3.91V155l6.5-4.18h4.52Zm8.1 26.46c-.77 0-1.44-.27-1.99-.82a2.65 2.65 0 0 1-.82-2c0-.76.27-1.42.82-1.96a2.74 2.74 0 0 1 2-.82c.74 0 1.4.28 1.95.82a2.69 2.69 0 0 1 .45 3.39c-.26.42-.6.77-1.02 1.02-.42.25-.88.37-1.39.37Zm7.54-.28v-3.43l9.1-8.9c.86-.88 1.59-1.66 2.17-2.35a8.54 8.54 0 0 0 1.3-1.98 4.9 4.9 0 0 0 .43-2.04 3.73 3.73 0 0 0-2.1-3.5 5 5 0 0 0-2.24-.5 4.6 4.6 0 0 0-2.26.54 3.7 3.7 0 0 0-1.51 1.5 4.81 4.81 0 0 0-.53 2.31h-4.51a7.68 7.68 0 0 1 4.27-7.19 10.1 10.1 0 0 1 4.6-1c1.76 0 3.3.33 4.63.98a7.54 7.54 0 0 1 3.1 2.7 7.03 7.03 0 0 1 1.1 3.91c0 .98-.18 1.95-.56 2.9-.37.94-1.03 1.99-1.98 3.14a49.83 49.83 0 0 1-3.95 4.18l-4.51 4.59v.18h11.4V177h-17.95Zm31.67.36c-1.9 0-3.59-.32-5.06-.96a8.42 8.42 0 0 1-3.45-2.62 6.15 6.15 0 0 1-1.23-3.8c-.01-1.1.23-2.1.71-3.03a6.74 6.74 0 0 1 4.76-3.49v-.18a5.54 5.54 0 0 1-3.27-2.06 5.93 5.93 0 0 1-1.23-3.74c0-1.35.37-2.55 1.13-3.6a7.67 7.67 0 0 1 3.11-2.5c1.33-.61 2.83-.92 4.53-.92 1.68 0 3.17.3 4.49.92a7.67 7.67 0 0 1 3.12 2.5 5.98 5.98 0 0 1 1.15 3.6c0 1.41-.42 2.66-1.27 3.74a5.53 5.53 0 0 1-3.23 2.06v.18a6.74 6.74 0 0 1 5.47 6.52c0 1.42-.42 2.68-1.25 3.8a8.43 8.43 0 0 1-3.46 2.62 12.4 12.4 0 0 1-5.02.96Zm0-3.66c.98 0 1.83-.16 2.56-.5a3.87 3.87 0 0 0 2.3-3.55c-.01-.84-.23-1.57-.65-2.21-.42-.65-1-1.16-1.73-1.52a5.43 5.43 0 0 0-2.48-.55c-.94 0-1.77.18-2.5.55-.74.36-1.32.87-1.75 1.52a3.88 3.88 0 0 0-.6 2.2 3.71 3.71 0 0 0 2.27 3.55c.73.34 1.6.51 2.58.51Zm0-11.93c.8 0 1.5-.16 2.12-.48a3.7 3.7 0 0 0 2.02-3.36c0-.75-.19-1.41-.53-1.97a3.46 3.46 0 0 0-1.46-1.32 4.68 4.68 0 0 0-2.15-.47c-.83 0-1.56.16-2.19.47a3.46 3.46 0 0 0-1.95 3.29c-.01.75.16 1.42.5 2 .37.57.86 1.03 1.48 1.36.63.32 1.35.48 2.16.48Zm23.52 15.59c-1.25-.01-2.48-.23-3.67-.65a8.63 8.63 0 0 1-3.22-2.11 10.38 10.38 0 0 1-2.28-3.9 18.51 18.51 0 0 1-.83-6.05c0-2.24.24-4.24.72-6a13.24 13.24 0 0 1 2.06-4.44 9.08 9.08 0 0 1 3.23-2.8 9.34 9.34 0 0 1 4.26-.95c1.64 0 3.1.32 4.37.97a8.24 8.24 0 0 1 4.55 6.44h-4.66c-.24-1-.73-1.8-1.48-2.4-.73-.6-1.66-.9-2.78-.9-1.82 0-3.22.78-4.2 2.36-.97 1.58-1.46 3.74-1.47 6.5h.18c.42-.76.96-1.4 1.63-1.94a7.96 7.96 0 0 1 4.92-1.69 7.86 7.86 0 0 1 7.04 4.13 8.75 8.75 0 0 1 1.06 4.4c.01 1.72-.38 3.27-1.17 4.64a8.53 8.53 0 0 1-3.31 3.22 9.95 9.95 0 0 1-4.95 1.17Zm-.03-3.84c.93 0 1.76-.22 2.5-.68a4.9 4.9 0 0 0 1.74-1.82c.42-.77.63-1.63.62-2.59.01-.93-.2-1.78-.61-2.54a4.67 4.67 0 0 0-4.18-2.47 4.7 4.7 0 0 0-3.5 1.5 5.14 5.14 0 0 0 .94 7.91c.73.46 1.57.7 2.5.7Z"
      />
      <path
        stroke="#1FAD66"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth={1.33}
        d="m607.33 204 4.67-4.67 4.67 4.67M612 208.67v-9.34"
      />
      <path
        fill="#1FAD66"
        d="M624.78 208v-1.14l3.02-2.97c.3-.3.54-.55.73-.78.2-.23.34-.45.43-.66.1-.22.15-.44.15-.68a1.25 1.25 0 0 0-.7-1.17c-.22-.11-.47-.16-.75-.16-.29 0-.54.06-.75.18-.22.11-.39.28-.5.5a1.6 1.6 0 0 0-.18.76h-1.5c0-.55.12-1.03.37-1.44.26-.4.6-.73 1.05-.95.44-.22.96-.34 1.53-.34.59 0 1.1.11 1.54.33.45.22.8.52 1.04.9s.37.82.37 1.3c0 .33-.07.65-.2.97-.12.31-.34.66-.65 1.05-.31.38-.75.84-1.32 1.39l-1.5 1.53v.06h3.8V208h-5.98Zm7.45 0v-1.14l3.03-2.97c.29-.3.53-.55.72-.78.2-.23.34-.45.44-.66.1-.22.14-.44.14-.68 0-.28-.06-.52-.18-.71-.13-.2-.3-.35-.52-.46-.22-.11-.47-.16-.75-.16s-.53.06-.75.18c-.22.11-.38.28-.5.5a1.6 1.6 0 0 0-.18.76h-1.5a2.56 2.56 0 0 1 1.42-2.4c.45-.21.96-.33 1.54-.33.58 0 1.1.11 1.54.33.44.22.78.52 1.03.9s.37.82.37 1.3c0 .33-.06.65-.19.97a4.1 4.1 0 0 1-.66 1.05c-.31.38-.75.84-1.32 1.39l-1.5 1.53v.06h3.8V208h-5.98Zm12.12-1.64v-.46c0-.34.07-.65.21-.93a1.72 1.72 0 0 1 1.63-.95c.4 0 .74.1 1.02.26.27.18.48.4.62.69.14.28.2.6.2.93v.46c0 .34-.06.65-.2.94a1.7 1.7 0 0 1-.63.68c-.27.18-.6.26-1 .26s-.74-.08-1.02-.26a1.7 1.7 0 0 1-.62-.68 2.1 2.1 0 0 1-.21-.94Zm1.11-.46v.46c0 .23.05.43.16.62s.3.28.57.28c.28 0 .47-.09.57-.27.1-.2.16-.4.16-.63v-.46c0-.22-.05-.43-.15-.62-.1-.19-.3-.28-.58-.28-.26 0-.45.1-.56.28-.11.19-.17.4-.17.62Zm-5.55-4.53v-.46c0-.34.07-.65.22-.94.14-.28.35-.51.63-.68.28-.17.6-.26 1-.26s.74.09 1.01.26c.28.17.48.4.62.68.14.29.21.6.21.94v.46c0 .34-.07.65-.21.94-.14.28-.35.5-.62.67-.28.18-.61.26-1 .26-.4 0-.75-.09-1.02-.26-.28-.17-.48-.4-.63-.68-.14-.28-.2-.6-.2-.93Zm1.12-.46v.46c0 .23.06.43.16.62s.3.28.57.28c.27 0 .46-.1.56-.28.1-.19.16-.4.16-.62v-.46c0-.23-.05-.44-.15-.62-.1-.2-.29-.29-.57-.29-.27 0-.46.1-.56.29-.11.19-.17.4-.17.62Zm-.63 7.09 6-8.73h1.06l-6 8.73h-1.06Z"
      />
      <path
        fill="#6C7793"
        d="m658 198.86-2.8 10.45h-.93l2.82-10.45h.92Zm1.2 9.14v-6.54h.97v1.02h.09c.13-.35.35-.62.65-.82.3-.2.67-.3 1.1-.3.43 0 .8.1 1.08.3.29.2.51.47.68.82h.06c.17-.34.42-.6.76-.8.33-.21.74-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V208h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V208h-1.02v-4.48c0-.38-.12-.68-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.5.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V208h-1.01Zm13.09.14c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.12-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.44.28.79.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.45.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.07 2.07 0 0 0-.64-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.11.35-.3.23-.5.54-.64.92s-.21.78-.21 1.22c0 .44.07.84.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Zm5.5-3.18V208h-1v-6.54h.97v1.02h.08c.16-.33.4-.6.7-.8.32-.2.72-.31 1.21-.31.45 0 .84.09 1.17.27.33.18.59.45.77.82.19.36.28.82.28 1.38V208h-1v-4.1c0-.5-.14-.9-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.33 0-.61.07-.87.21a1.5 1.5 0 0 0-.59.61c-.14.27-.22.6-.22.97Zm8.86-2.6v.85h-3.39v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.05.5.13.63.09.14.2.24.32.28.14.05.28.07.42.07l.28-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm5.06 4.17V208h-1v-8.73h1v3.2h.09c.15-.33.38-.6.69-.8.3-.2.72-.3 1.23-.3.45 0 .84.09 1.18.27.33.17.6.45.78.81.18.37.28.83.28 1.4V208h-1v-4.1c0-.51-.14-.91-.41-1.2a1.45 1.45 0 0 0-1.12-.43c-.32 0-.62.07-.88.21-.26.14-.47.34-.62.61-.14.27-.22.6-.22.97Z"
      />
      <rect width={40} height={40} x={548} y={100} fill="#F4F8FB" rx={20} />
      <path
        fill="#1FAD66"
        fillRule="evenodd"
        d="M563.64 116.36a2.18 2.18 0 1 1 4.36 0 2.18 2.18 0 0 1-4.36 0Zm2.18-3.63a3.64 3.64 0 1 0 0 7.27 3.64 3.64 0 0 0 0-7.27Zm-2.18 8.72a3.64 3.64 0 0 0-3.64 3.64v1.46a.73.73 0 0 0 1.46 0v-1.46a2.18 2.18 0 0 1 2.18-2.18H568a2.18 2.18 0 0 1 2.18 2.18v1.46a.73.73 0 0 0 1.46 0v-1.46a3.64 3.64 0 0 0-3.64-3.64h-4.36Zm8.75.64c.1-.38.5-.62.88-.52a3.64 3.64 0 0 1 2.73 3.52v1.46a.73.73 0 0 1-1.46 0v-1.46a2.18 2.18 0 0 0-1.63-2.1.73.73 0 0 1-.52-.9Zm-1.3-9.25a.73.73 0 1 0-.36 1.41 2.18 2.18 0 0 1 0 4.23.73.73 0 0 0 .36 1.41 3.63 3.63 0 0 0 0-7.05Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#paint2_linear_1_3812)"
        d="M736.32 144.5C720 144.5 720 163.14 720 163.14V188h96v-48s-3.5 8-9.5 8-7.34-6.5-17-6.5-10.5 15-22 15-14.86-12-31.18-12Z"
      />
      <path
        stroke="#fff"
        strokeLinecap="round"
        strokeWidth={6}
        d="M720 163.14s0-18.64 16.32-18.64 19.68 12 31.18 12 12.34-15 22-15 11 6.5 17 6.5 9.5-8 9.5-8"
      />
      <path
        stroke="#1FAD66"
        strokeLinecap="round"
        strokeWidth={2}
        d="M720 163.14s0-18.64 16.32-18.64 19.68 12 31.18 12 12.34-15 22-15 11 6.5 17 6.5 9.5-8 9.5-8"
      />
      <circle
        cx={832}
        cy={88}
        r={120}
        fill="url(#paint3_radial_1_3812)"
        fillOpacity={0.3}
        opacity={0.5}
      />
    </g>
    <g clipPath="url(#clip4_1_3812)">
      <rect width={296} height={136} x={848} y={88} fill="#fff" rx={16} />
      <path
        fill="#6C7793"
        d="M916.68 115.91v-1.1h7.63v1.1h-3.2V125h-1.23v-9.09h-3.2Zm11.37 9.25c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.32.93.78 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.05c.53 0 .96-.14 1.3-.4.33-.28.58-.63.74-1.07a4.08 4.08 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.08c-.16.44-.25.91-.25 1.42 0 .51.09.99.25 1.42.16.44.41.8.75 1.06a2 2 0 0 0 1.3.4Zm8.57-6.75v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.41 2.41 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.93 1.93 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.36-.08.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V125h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.06c.47 0 .86-.09 1.18-.27a1.88 1.88 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.9 29.9 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.46.93.3.2.69.3 1.15.3Zm6.64-9.3V125h-1.17v-10.18h1.17Zm8.97 10.34a3 3 0 0 1-2.83-1.85c-.27-.6-.41-1.3-.41-2.1 0-.81.14-1.5.41-2.1a3.03 3.03 0 0 1 2.85-1.85c.5 0 .89.09 1.18.25.29.16.51.35.66.56l.37.5h.1v-3.75h1.17V125h-1.13v-1.17h-.14l-.37.52c-.16.21-.39.4-.68.57-.3.16-.69.24-1.18.24Zm.16-1.05c.47 0 .87-.13 1.2-.37.32-.25.56-.6.73-1.03.17-.44.26-.95.26-1.53 0-.57-.09-1.07-.25-1.5a1.95 1.95 0 0 0-1.94-1.37c-.5 0-.91.14-1.24.4-.33.24-.58.59-.74 1.02-.17.43-.25.91-.25 1.45 0 .54.08 1.04.25 1.48.17.44.42.8.75 1.06s.74.39 1.23.39Zm8.85 1.05a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.9v-1.02h4.7c0-.43-.08-.81-.26-1.15a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.35.21.77.31 1.24.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm7.2.02c-.49 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.08.7-.14 1.06-.19l1.12-.13c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.55.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.53 4.53 0 0 1 2-.07c.33.06.64.18.94.36.3.18.55.45.75.8.2.37.3.85.3 1.46V125h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.18-1.06c.46 0 .85-.09 1.17-.27a1.88 1.88 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.64.39a1 1 0 0 0-.23.7c0 .41.15.72.45.93.3.2.69.3 1.16.3Zm6.63-9.3V125h-1.17v-10.18h1.17Zm7.56 4.25-1.05.3a1.99 1.99 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.47.48-.47.81 0 .3.11.52.32.7.22.16.55.3 1 .42l1.13.27c.68.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.13.83-.38 1.17-.25.35-.6.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.32-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.76 1.76 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.37-1.14.24-.33.57-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.84 5.93v-7.64h1.18V125h-1.18Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.09-.41.25-.57a.83.83 0 0 1 .59-.23c.23 0 .42.08.59.23.16.16.25.35.25.56 0 .22-.09.41-.25.57a.82.82 0 0 1-.59.23Zm3.9 4.3v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .97.11 1.35.32.39.21.69.53.91.96.21.42.32.96.32 1.6V125h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.95 7.46v-10.5h1.14v1.22h.14c.08-.14.2-.3.35-.51a2.14 2.14 0 0 1 1.85-.8 3.02 3.02 0 0 1 2.85 1.84c.28.6.41 1.29.41 2.1 0 .8-.13 1.5-.41 2.1a3 3 0 0 1-2.83 1.85c-.49 0-.88-.08-1.18-.25a2.25 2.25 0 0 1-.68-.56 5.38 5.38 0 0 1-.36-.52h-.1v4.03h-1.18Zm1.16-6.68c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.72.37 1.19.37.49 0 .9-.13 1.23-.4.33-.25.58-.6.75-1.05.17-.44.25-.94.25-1.48s-.08-1.02-.25-1.45a2.24 2.24 0 0 0-.74-1.03 1.96 1.96 0 0 0-1.24-.38c-.47 0-.87.12-1.2.36-.32.24-.57.57-.74 1-.16.43-.24.93-.24 1.5Zm7.37 3.82v-7.64h1.18V125h-1.18Zm.6-8.9a.82.82 0 0 1-.59-.24.76.76 0 0 1-.24-.56c0-.22.08-.41.24-.57a.82.82 0 0 1 .59-.23c.23 0 .42.08.59.23.16.16.25.35.25.56 0 .22-.09.41-.25.57a.83.83 0 0 1-.59.23Zm2.73 11.76v-10.5h1.13v1.22h.14l.36-.51c.15-.2.37-.4.66-.56.29-.16.69-.25 1.19-.25.64 0 1.21.16 1.7.49.49.32.87.77 1.14 1.36.28.6.42 1.29.42 2.1 0 .8-.14 1.5-.42 2.1a3 3 0 0 1-2.82 1.85c-.49 0-.89-.08-1.18-.25-.3-.16-.52-.35-.68-.56a8.89 8.89 0 0 1-.37-.52h-.1v4.03h-1.17Zm1.15-6.68c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.73.37 1.2.37.49 0 .9-.13 1.23-.4.33-.25.58-.6.74-1.05.17-.44.25-.94.25-1.48s-.08-1.02-.24-1.45a2.25 2.25 0 0 0-.75-1.03 1.93 1.93 0 0 0-1.23-.38c-.48 0-.88.12-1.21.36-.32.24-.57.57-.73 1-.17.43-.25.93-.25 1.5Zm10.58 3.98c-.74 0-1.37-.16-1.91-.49a3.27 3.27 0 0 1-1.22-1.37 4.61 4.61 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.4 3.4 0 0 1 1.2-1.4 3.62 3.62 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81c.19.49.28 1.09.28 1.8v.5h-5.89v-1.02h4.7c0-.43-.09-.81-.26-1.15-.17-.34-.41-.6-.73-.8-.31-.2-.68-.3-1.1-.3-.47 0-.87.12-1.21.36a2.54 2.54 0 0 0-1.06 2.08v.67c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.31 1.25.31.31 0 .59-.04.83-.12.26-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm6.12-10.34V125h-1.17v-10.18h1.17Zm2.15 10.18v-7.64h1.17V125h-1.17Zm.59-8.9a.85.85 0 0 1-.59-.24.76.76 0 0 1-.24-.56c0-.22.08-.41.24-.57a.85.85 0 0 1 .59-.23c.23 0 .43.08.59.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.59.23Zm3.9 4.3v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V125h-1.18v-4.77c0-.6-.15-1.07-.46-1.4-.32-.34-.74-.51-1.29-.51-.37 0-.71.08-1 .24-.29.16-.52.4-.69.71-.17.31-.26.7-.26 1.14Zm10.22 4.76a3.29 3.29 0 0 1-3.13-1.86 4.61 4.61 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.4 3.4 0 0 1 1.2-1.4 3.62 3.62 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81c.19.49.28 1.09.28 1.8v.5h-5.88v-1.02h4.69c0-.43-.09-.81-.26-1.15-.17-.34-.41-.6-.72-.8-.32-.2-.68-.3-1.11-.3-.47 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.09 1.07.29 1.47.21.4.49.7.84.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Z"
      />
      <path
        fill="#14141F"
        d="M927.72 177.36c-1.84 0-3.47-.32-4.9-.95a8.22 8.22 0 0 1-3.38-2.63 6.82 6.82 0 0 1-1.32-3.9h4.8c.05.7.29 1.33.71 1.85.43.52 1 .93 1.7 1.22.71.29 1.5.43 2.38.43.94 0 1.77-.16 2.5-.48.72-.34 1.28-.8 1.7-1.38a3.4 3.4 0 0 0 .6-2.04c0-.79-.2-1.49-.62-2.1a4.1 4.1 0 0 0-1.81-1.41 7.1 7.1 0 0 0-2.84-.51h-2.32v-3.66h2.32c.9 0 1.7-.16 2.39-.47a3.87 3.87 0 0 0 1.62-1.33c.4-.58.59-1.25.58-2.01a3.5 3.5 0 0 0-.5-1.93c-.33-.55-.8-.99-1.42-1.3a5.62 5.62 0 0 0-4.36-.03c-.68.3-1.23.72-1.65 1.25a3.14 3.14 0 0 0-.66 1.9h-4.57a6.64 6.64 0 0 1 1.27-3.87 8.17 8.17 0 0 1 3.27-2.6c1.36-.63 2.9-.95 4.59-.95 1.75 0 3.26.33 4.55.98 1.3.65 2.3 1.53 3 2.63a6.6 6.6 0 0 1 1.07 3.64c0 1.47-.43 2.7-1.3 3.7a6.12 6.12 0 0 1-3.43 1.96v.2c1.84.26 3.25.94 4.23 2.05a5.87 5.87 0 0 1 1.47 4.1c0 1.47-.42 2.78-1.25 3.94a8.31 8.31 0 0 1-3.43 2.71c-1.45.66-3.11.99-4.99.99Zm13.58-5.22v-3.77l11.11-17.55h3.15v5.37h-1.92l-7.48 11.85v.2h15.5v3.9H941.3Zm12.5 4.86v-6l.04-1.7v-18.48h4.48V177h-4.53Z"
      />
      <path
        stroke="#FF4C4D"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth={1.33}
        d="m919.33 204 4.67 4.67 4.67-4.67M924 199.33v9.34"
      />
      <path
        fill="#FF4C4D"
        d="M939.88 208.12c-.64 0-1.2-.1-1.69-.32-.49-.21-.87-.5-1.15-.87-.28-.38-.41-.8-.4-1.27-.01-.37.07-.7.23-1a2.24 2.24 0 0 1 1.59-1.17v-.06c-.45-.1-.82-.33-1.1-.69a1.97 1.97 0 0 1-.4-1.25c0-.45.12-.85.37-1.2s.6-.63 1.04-.83c.44-.2.94-.3 1.5-.3.57 0 1.07.1 1.5.3.44.2.8.48 1.04.83a2 2 0 0 1 .39 1.2 1.97 1.97 0 0 1-1.5 1.94v.06a2.24 2.24 0 0 1 1.82 2.17c0 .47-.14.9-.42 1.27-.28.36-.66.66-1.15.87-.48.21-1.04.32-1.67.32Zm0-1.22c.33 0 .6-.06.85-.17.24-.1.43-.27.56-.47.14-.2.2-.44.2-.71 0-.28-.07-.52-.21-.74a1.44 1.44 0 0 0-.57-.5 1.81 1.81 0 0 0-.83-.19c-.31 0-.6.06-.84.19-.24.12-.43.29-.58.5-.14.22-.2.46-.2.74a1.23 1.23 0 0 0 .76 1.18c.24.11.53.17.86.17Zm0-3.97c.26 0 .5-.06.7-.17a1.23 1.23 0 0 0 .68-1.12c0-.25-.06-.47-.18-.65-.12-.2-.28-.34-.49-.44-.2-.1-.44-.16-.71-.16-.28 0-.52.05-.73.16a1.15 1.15 0 0 0-.65 1.1c0 .25.05.47.17.66.12.2.28.34.49.45.2.11.45.17.72.17Zm9.3 3.43v-.46c0-.34.08-.65.22-.93a1.72 1.72 0 0 1 1.63-.95c.4 0 .75.1 1.02.26.27.18.48.4.62.69.14.28.2.6.2.93v.46c0 .34-.06.65-.2.94a1.7 1.7 0 0 1-.63.68c-.27.18-.6.26-1 .26s-.74-.08-1.02-.26a1.7 1.7 0 0 1-.62-.68c-.14-.29-.21-.6-.21-.94Zm1.12-.46v.46c0 .23.05.43.16.62s.3.28.57.28c.28 0 .47-.09.57-.27.1-.2.16-.4.16-.63v-.46c0-.22-.05-.43-.15-.62-.1-.19-.3-.28-.58-.28-.26 0-.45.1-.56.28-.12.19-.17.4-.17.62Zm-5.55-4.53v-.46c0-.34.07-.65.22-.94.14-.28.35-.51.63-.68.27-.17.6-.26 1-.26s.74.09 1.01.26c.28.17.48.4.62.68.14.29.21.6.21.94v.46c0 .34-.07.65-.21.94-.14.28-.35.5-.62.67-.28.18-.61.26-1 .26-.4 0-.75-.09-1.02-.26-.28-.17-.48-.4-.63-.68-.14-.28-.2-.6-.2-.93Zm1.12-.46v.46c0 .23.05.43.16.62.1.19.3.28.57.28.27 0 .46-.1.56-.28.1-.19.16-.4.16-.62v-.46c0-.23-.05-.44-.15-.62-.1-.2-.29-.29-.57-.29-.27 0-.46.1-.57.29-.1.19-.16.4-.16.62Zm-.63 7.09 6-8.73h1.06l-6 8.73h-1.06Z"
      />
      <path
        fill="#6C7793"
        d="m962 198.86-2.8 10.45h-.93l2.82-10.45h.92Zm1.2 9.14v-6.54h.97v1.02h.09c.13-.35.35-.62.65-.82.3-.2.67-.3 1.1-.3.43 0 .8.1 1.08.3.29.2.51.47.68.82h.06c.17-.34.42-.6.76-.8.33-.21.74-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V208h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V208h-1.02v-4.48c0-.38-.12-.68-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.5.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V208h-1.01Zm13.09.14c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.12-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.44.28.79.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.45.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.07 2.07 0 0 0-.64-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.11.35-.3.23-.5.54-.64.92s-.21.78-.21 1.22c0 .44.07.84.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Zm5.5-3.18V208h-1v-6.54h.97v1.02h.08c.16-.33.4-.6.7-.8.32-.2.72-.31 1.21-.31.45 0 .84.09 1.17.27.33.18.59.45.77.82.19.36.28.82.28 1.38V208h-1v-4.1c0-.5-.14-.9-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.33 0-.61.07-.87.21a1.5 1.5 0 0 0-.59.61c-.14.27-.22.6-.22.97Zm8.86-2.6v.85h-3.39v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.05.5.13.63.09.14.2.24.32.28.14.05.28.07.42.07l.28-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm5.06 4.17V208h-1v-8.73h1v3.2h.09c.15-.33.38-.6.69-.8.3-.2.72-.3 1.23-.3.45 0 .84.09 1.18.27.33.17.6.45.78.81.18.37.28.83.28 1.4V208h-1v-4.1c0-.51-.14-.91-.41-1.2a1.45 1.45 0 0 0-1.12-.43c-.32 0-.62.07-.88.21-.26.14-.47.34-.62.61-.14.27-.22.6-.22.97Z"
      />
      <rect width={40} height={40} x={860} y={100} fill="#F4F8FB" rx={20} />
      <path
        fill="#FF4C4D"
        fillRule="evenodd"
        d="M880 112c-.75 0-1.48.23-2.04.74a2.86 2.86 0 0 0-.87 2.17c0 .89.24 1.38.46 1.77l.04.06c.16.28.23.4.23.72V120H876a2.54 2.54 0 0 0-2.54 2.55v1.09a1.45 1.45 0 0 0 1.45 1.45h10.18a1.45 1.45 0 0 0 1.45-1.45v-1.1c0-.66-.26-1.32-.74-1.8a2.56 2.56 0 0 0-1.8-.74h-1.82v-2.55c0-.3.07-.43.23-.7l.04-.07c.22-.4.46-.88.46-1.77A2.9 2.9 0 0 0 880 112Zm.73 8v-2.55c0-.7.24-1.12.42-1.42l.04-.07c.14-.25.26-.49.26-1.05a1.45 1.45 0 0 0-1.45-1.45c-.46 0-.82.13-1.05.35-.22.2-.4.54-.4 1.1s.12.8.26 1.05l.04.07c.18.3.42.72.42 1.42V120h1.46Zm3.69 1.54a1.07 1.07 0 0 0-.42-.09h-8a1.1 1.1 0 0 0-1.1 1.1v1.09h10.2v-1.1a1.1 1.1 0 0 0-.68-1Zm-10.24 5.73c0-.4.33-.72.73-.72h10.18a.73.73 0 1 1 0 1.45h-10.18a.73.73 0 0 1-.73-.73Z"
        clipRule="evenodd"
      />
      <path
        fill="url(#paint4_linear_1_3812)"
        d="M1048.32 152.43c-10.32 0-13.28 9-16.32 7.71V188h96v-44s-11 6.5-16.8 6.5c-5.8 0-8.16 13-15.36 13-7.2 0-3.84-23.5-15.84-23.5s-21.36 12.43-31.68 12.43Z"
      />
      <path
        stroke="#fff"
        strokeLinecap="round"
        strokeWidth={6}
        d="M1032 160.14c3.04 1.29 6-7.71 16.32-7.71S1068 140 1080 140s8.64 23.5 15.84 23.5c7.2 0 9.56-13 15.36-13 5.8 0 16.8-6.5 16.8-6.5"
      />
      <path
        stroke="#FF4C4D"
        strokeLinecap="round"
        strokeWidth={2}
        d="M1032 160.14c3.04 1.29 6-7.71 16.32-7.71S1068 140 1080 140s8.64 23.5 15.84 23.5c7.2 0 9.56-13 15.36-13 5.8 0 16.8-6.5 16.8-6.5"
      />
      <circle
        cx={1144}
        cy={88}
        r={120}
        fill="url(#paint5_radial_1_3812)"
        fillOpacity={0.3}
        opacity={0.5}
      />
    </g>
    <g clipPath="url(#clip5_1_3812)">
      <rect width={296} height={472} x={224} y={240} fill="#fff" rx={8} />
      <path fill="#EDF2F7" d="M224 240h296v56H224z" />
      <path
        fill="#6C7793"
        fillRule="evenodd"
        d="M255.33 261.33a.67.67 0 1 0-1.33 0v.67h-4v-.67a.67.67 0 1 0-1.33 0v.67h-1.34a2 2 0 0 0-2 2v9.33c0 1.1.9 2 2 2h9.34a2 2 0 0 0 2-2V264a2 2 0 0 0-2-2h-1.34v-.67Zm2 4.67v-2c0-.37-.3-.67-.66-.67h-1.34v.67a.67.67 0 1 1-1.33 0v-.67h-4v.67a.67.67 0 1 1-1.33 0v-.67h-1.34c-.37 0-.66.3-.66.67v2h10.66Zm-10.66 1.33h10.66v6c0 .37-.3.67-.66.67h-9.34a.67.67 0 0 1-.66-.67v-6Zm2 2c0-.37.3-.66.66-.66h.01a.67.67 0 1 1 0 1.33.67.67 0 0 1-.67-.67Zm3.33-.66a.67.67 0 1 0 0 1.33.67.67 0 0 0 0-1.33Zm2 .66c0-.37.3-.66.67-.66a.67.67 0 1 1 0 1.33.67.67 0 0 1-.67-.67Zm-4.67 2a.67.67 0 1 0 0 1.34h.01a.67.67 0 0 0 0-1.34Zm2 .67a.67.67 0 1 1 .67.67.67.67 0 0 1-.67-.67Zm3.34-.67a.67.67 0 1 0 0 1.34.67.67 0 0 0 0-1.34Z"
        clipRule="evenodd"
      />
      <path
        fill="#14141F"
        d="M279.67 262.82h1.54v6.7c0 .7-.17 1.34-.5 1.89-.34.55-.81.98-1.42 1.3-.6.3-1.31.46-2.13.46a4.6 4.6 0 0 1-2.13-.47 3.5 3.5 0 0 1-1.4-1.3 3.57 3.57 0 0 1-.51-1.88v-6.7h1.53v6.57a2.21 2.21 0 0 0 1.17 2.07c.38.2.83.3 1.34.3.52 0 .96-.1 1.34-.3.38-.2.66-.48.86-.84.2-.36.3-.77.3-1.23v-6.57Zm3.65 13.04v-10.5h1.45v1.24h.13c.08-.16.2-.34.37-.55.16-.2.39-.4.68-.55.29-.16.67-.24 1.14-.24a2.98 2.98 0 0 1 2.79 1.82c.28.59.42 1.3.42 2.12a5 5 0 0 1-.42 2.12 2.94 2.94 0 0 1-2.78 1.83c-.46 0-.84-.08-1.13-.24-.3-.15-.52-.33-.69-.54-.16-.21-.3-.4-.38-.56h-.1v4.05h-1.48Zm1.46-6.68c0 .54.08 1 .23 1.41.16.4.38.73.68.95.3.23.65.34 1.08.34.45 0 .82-.12 1.12-.35.3-.24.52-.56.67-.97.16-.4.24-.87.24-1.38 0-.5-.08-.95-.23-1.36-.15-.4-.38-.71-.68-.94-.3-.24-.67-.35-1.12-.35-.43 0-.8.1-1.1.33-.29.22-.51.53-.66.93-.16.4-.23.86-.23 1.4Zm10.4 3.97c-.74 0-1.38-.16-1.91-.5-.53-.34-.94-.8-1.22-1.4a4.65 4.65 0 0 1-.43-2.03c0-.78.14-1.46.44-2.06.29-.6.7-1.06 1.23-1.4.53-.33 1.15-.5 1.87-.5.58 0 1.1.11 1.55.33a2.71 2.71 0 0 1 1.6 2.24h-1.44a1.73 1.73 0 0 0-.55-.93 1.6 1.6 0 0 0-1.13-.38c-.42 0-.78.1-1.09.33-.3.21-.55.52-.72.92-.17.4-.26.87-.26 1.41 0 .56.08 1.04.25 1.44.17.4.41.72.72.94.31.23.68.34 1.1.34.28 0 .54-.05.76-.16.24-.1.43-.25.59-.45.15-.2.27-.43.33-.7h1.45a2.78 2.78 0 0 1-1.56 2.24 3.5 3.5 0 0 1-1.58.32Zm7.94 0a3.32 3.32 0 0 1-3.12-1.87 4.57 4.57 0 0 1-.44-2.06c0-.8.15-1.49.44-2.08a3.32 3.32 0 0 1 3.12-1.88 3.32 3.32 0 0 1 3.12 1.87c.3.6.44 1.3.44 2.09 0 .78-.15 1.47-.44 2.06a3.32 3.32 0 0 1-3.12 1.87Zm0-1.24c.47 0 .86-.13 1.16-.37.3-.25.53-.57.68-.98.15-.4.22-.86.22-1.35 0-.49-.07-.93-.22-1.34a2.2 2.2 0 0 0-.68-.99c-.3-.25-.69-.37-1.15-.37-.47 0-.86.12-1.17.37-.3.25-.53.58-.68.99-.14.4-.22.85-.22 1.34 0 .5.08.94.22 1.35.15.4.38.73.68.98.31.24.7.37 1.17.37Zm5.22 1.09v-7.64h1.43v1.25h.1c.15-.42.41-.75.77-.99.36-.24.8-.36 1.3-.36.51 0 .94.12 1.28.36.35.24.6.57.77.99h.08c.19-.41.48-.74.87-.98.4-.24.88-.37 1.43-.37.69 0 1.25.22 1.7.66.43.43.65 1.08.65 1.96V273h-1.49v-4.98c0-.52-.14-.9-.42-1.13a1.54 1.54 0 0 0-1-.34c-.49 0-.87.15-1.13.44-.27.3-.4.68-.4 1.14V273h-1.49v-5.08c0-.41-.13-.74-.39-1-.26-.25-.6-.37-1-.37-.29 0-.55.07-.79.22-.23.15-.42.35-.57.61-.14.26-.21.57-.21.91V273h-1.49Zm12.37 0v-7.64h1.5V273h-1.5Zm.75-8.81a.94.94 0 0 1-.66-.26.84.84 0 0 1-.28-.63c0-.25.1-.45.28-.63.18-.17.4-.26.66-.26s.48.09.67.26c.18.18.27.38.27.63 0 .24-.09.45-.27.63a.93.93 0 0 1-.67.25Zm4.23 4.28V273h-1.49v-7.64h1.43v1.25h.1c.17-.4.44-.73.82-.98.38-.24.85-.37 1.42-.37.52 0 .98.11 1.37.33.4.22.7.54.91.97.22.42.32.95.32 1.58V273h-1.48v-4.68c0-.55-.15-.98-.44-1.3a1.53 1.53 0 0 0-1.18-.47c-.35 0-.65.08-.92.23a1.6 1.6 0 0 0-.63.65c-.16.29-.23.63-.23 1.04Zm10.08 7.55a4.6 4.6 0 0 1-1.57-.24 3.03 3.03 0 0 1-1.06-.63 2.66 2.66 0 0 1-.62-.86l1.28-.52c.09.14.2.3.36.46.15.16.36.3.61.42.27.12.6.18 1.01.18.57 0 1.03-.14 1.4-.42.37-.27.55-.7.55-1.3v-1.5h-.1c-.08.16-.21.34-.38.54s-.4.37-.69.52a3.18 3.18 0 0 1-2.77-.2 3 3 0 0 1-1.14-1.26 4.57 4.57 0 0 1-.41-2.06c0-.81.13-1.5.4-2.09.29-.58.67-1.02 1.15-1.33a2.97 2.97 0 0 1 1.65-.47c.47 0 .85.08 1.14.24.3.16.52.34.69.55.16.2.29.4.38.55h.1v-1.24h1.46v7.8c0 .66-.15 1.2-.45 1.63-.3.42-.72.73-1.24.93-.52.2-1.1.3-1.75.3Zm-.02-4.37c.43 0 .8-.1 1.09-.3.3-.2.52-.49.67-.86.16-.38.24-.83.24-1.36 0-.51-.08-.96-.23-1.36-.15-.39-.38-.7-.67-.91-.3-.22-.66-.33-1.1-.33-.44 0-.82.11-1.11.35-.3.22-.53.54-.68.93-.15.4-.22.83-.22 1.32 0 .5.07.94.22 1.32.16.38.38.67.68.88.3.22.67.32 1.11.32Zm12.45 1.5c-.75 0-1.4-.16-1.94-.48a3.27 3.27 0 0 1-1.25-1.37 4.62 4.62 0 0 1-.44-2.07c0-.78.15-1.47.44-2.07.3-.6.7-1.06 1.23-1.4a3.73 3.73 0 0 1 3.11-.29 3.05 3.05 0 0 1 1.85 1.87c.19.48.28 1.07.28 1.76v.53h-6.07v-1.11h4.61c0-.4-.07-.74-.23-1.04a1.8 1.8 0 0 0-1.68-.99c-.42 0-.78.1-1.1.31-.3.2-.54.47-.71.8a2.3 2.3 0 0 0-.25 1.05v.88c0 .5.1.94.27 1.3.18.36.44.63.76.82.33.18.7.28 1.14.28.28 0 .54-.04.77-.12a1.59 1.59 0 0 0 .99-.97l1.4.25c-.1.42-.3.78-.6 1.09-.29.3-.65.55-1.09.72-.43.17-.93.25-1.49.25Zm11.24-7.79-2.76 7.64h-1.6l-2.77-7.64h1.6l1.93 5.88h.08l1.93-5.88h1.6Zm4.43 7.8c-.75 0-1.4-.17-1.94-.49a3.27 3.27 0 0 1-1.25-1.37 4.62 4.62 0 0 1-.44-2.07c0-.78.14-1.47.44-2.07.3-.6.7-1.06 1.23-1.4a3.73 3.73 0 0 1 3.11-.29 3.05 3.05 0 0 1 1.85 1.87c.19.48.28 1.07.28 1.76v.53h-6.07v-1.11h4.61c0-.4-.08-.74-.24-1.04a1.8 1.8 0 0 0-1.67-.99c-.42 0-.78.1-1.1.31-.3.2-.54.47-.71.8a2.3 2.3 0 0 0-.25 1.05v.88c0 .5.09.94.27 1.3.18.36.43.63.76.82.32.18.7.28 1.14.28.28 0 .54-.04.77-.12a1.59 1.59 0 0 0 .99-.97l1.4.25c-.1.42-.31.78-.6 1.09-.3.3-.65.55-1.1.72-.43.17-.92.25-1.48.25Zm6.42-4.7V273h-1.5v-7.64h1.44v1.25h.09c.18-.4.45-.73.82-.98.38-.24.86-.37 1.43-.37.52 0 .98.11 1.37.33.39.22.7.54.9.97.22.42.33.95.33 1.58V273h-1.49v-4.68c0-.55-.14-.98-.43-1.3a1.53 1.53 0 0 0-1.19-.47c-.34 0-.65.08-.92.23a1.6 1.6 0 0 0-.63.65c-.15.29-.22.63-.22 1.04Zm10.44-3.1v1.2h-4.17v-1.2h4.17Zm-3.05-1.83h1.48v7.23c0 .29.05.5.13.65.09.14.2.24.34.3a1.7 1.7 0 0 0 .77.05l.2-.05.27 1.23c-.09.03-.21.07-.37.1a2.92 2.92 0 0 1-1.69-.15 1.87 1.87 0 0 1-.82-.68c-.2-.3-.31-.68-.31-1.14v-7.54Zm10.3 3.7-1.35.24a1.6 1.6 0 0 0-.27-.5 1.34 1.34 0 0 0-.49-.38c-.2-.1-.46-.15-.77-.15-.42 0-.77.1-1.05.29-.29.18-.43.42-.43.72 0 .25.1.46.29.61.19.16.5.29.91.39l1.22.27c.7.17 1.22.42 1.57.75.34.34.51.78.51 1.32a2 2 0 0 1-.4 1.23 2.6 2.6 0 0 1-1.1.83c-.46.2-1 .3-1.62.3-.86 0-1.55-.18-2.1-.54a2.31 2.31 0 0 1-.99-1.57l1.44-.22c.09.38.27.66.55.85.28.2.64.29 1.1.29.48 0 .87-.1 1.16-.3.3-.21.44-.46.44-.76a.78.78 0 0 0-.27-.6 1.76 1.76 0 0 0-.81-.37l-1.3-.28a3.1 3.1 0 0 1-1.58-.78c-.33-.35-.5-.8-.5-1.34 0-.45.12-.85.38-1.19.25-.33.6-.6 1.04-.79.44-.19.95-.29 1.52-.29.83 0 1.48.18 1.95.54.48.36.8.83.94 1.43Z"
      />
      <rect width={6} height={6} x={249} y={325} fill="#0080FF" rx={3} />
      <path
        fill="#6C7793"
        d="M272.58 324.21v-.94h6.55v.94h-2.75V332h-1.06v-7.79h-2.74Zm9.75 7.93c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.45.28.8.68 1.04 1.19a4 4 0 0 1 .38 1.78c0 .68-.13 1.27-.38 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.51-.53.65-.91s.21-.78.21-1.22c0-.44-.07-.84-.2-1.22a2.07 2.07 0 0 0-.65-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.1.35-.3.24-.51.54-.65.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.15.38.36.68.65.9.3.24.66.35 1.11.35Zm6.97.9a2.56 2.56 0 0 1-2.42-1.6c-.24-.5-.36-1.1-.36-1.8 0-.68.12-1.28.36-1.79a2.6 2.6 0 0 1 2.44-1.59c.43 0 .76.08 1 .22.26.14.45.3.58.48l.31.43h.09v-3.22h1V332h-.97v-1h-.12l-.31.45c-.14.18-.33.34-.59.48-.25.14-.59.2-1 .2Zm.14-.9c.4 0 .74-.11 1.02-.32.28-.22.5-.5.64-.88s.21-.82.21-1.31c0-.5-.07-.92-.21-1.29a1.67 1.67 0 0 0-1.66-1.17c-.43 0-.78.11-1.07.33-.28.22-.49.51-.63.88s-.21.79-.21 1.25c0 .46.07.89.21 1.27.15.38.36.68.64.9.29.22.64.33 1.06.33Zm6.77.91c-.41 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.8-.3.31-.07.61-.12.92-.16l.96-.12c.25-.03.44-.07.55-.14.12-.06.17-.18.17-.34v-.04c0-.41-.11-.74-.34-.97-.23-.24-.57-.35-1.04-.35-.48 0-.85.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.55.15.8.3.26.15.47.38.64.7.18.3.26.72.26 1.24V332h-1v-.89h-.06c-.06.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.59.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a20.74 20.74 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.07-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm5.1 3.2a2.22 2.22 0 0 1-.73-.12l.25-.88c.25.06.46.08.65.07.19-.02.35-.1.5-.25a2 2 0 0 0 .4-.72l.19-.52-2.42-6.57h1.1l1.8 5.21h.07l1.8-5.22h1.1l-2.79 7.5c-.12.34-.27.62-.46.84-.18.23-.4.4-.64.5-.24.11-.52.16-.82.16Zm7.12-3.64-.07.46a20.3 20.3 0 0 1-.78 2.86h-.77l.15-.72a27.98 27.98 0 0 0 .33-2.13l.05-.47h1.1Zm7.95 1.3a3 3 0 0 1-1.35-.29c-.4-.2-.72-.47-.97-.82a2.24 2.24 0 0 1-.4-1.18h1.03c.04.4.22.72.54.98.32.25.7.38 1.15.38a1.81 1.81 0 0 0 1.61-.94c.17-.3.25-.63.25-1 0-.38-.09-.72-.25-1.02a1.84 1.84 0 0 0-1.68-.98 2.74 2.74 0 0 0-1.52.45l-.99-.12.53-4.3h4.54v.94h-3.65l-.3 2.57h.04a2.57 2.57 0 0 1 1.52-.5 2.69 2.69 0 0 1 2.42 1.43c.24.44.36.95.36 1.51s-.13 1.06-.38 1.5c-.24.43-.58.77-1.02 1.02-.43.25-.93.38-1.48.38Zm4.59 2.34v-9h.97v1.04h.12l.3-.43a1.82 1.82 0 0 1 1.6-.7 2.6 2.6 0 0 1 2.43 1.6c.24.5.36 1.1.36 1.78 0 .7-.12 1.3-.36 1.8a2.56 2.56 0 0 1-2.42 1.59 2.1 2.1 0 0 1-1.01-.2c-.25-.14-.45-.3-.58-.48a6.15 6.15 0 0 1-.32-.46h-.08v3.46h-1.01Zm.99-5.72c0 .5.07.93.22 1.3.14.38.35.68.63.89.28.2.62.31 1.02.31.42 0 .77-.1 1.06-.33.28-.22.5-.52.63-.9.15-.38.22-.8.22-1.27 0-.46-.07-.88-.21-1.25a1.92 1.92 0 0 0-.64-.88 1.67 1.67 0 0 0-1.06-.33 1.67 1.67 0 0 0-1.66 1.18c-.14.36-.21.79-.21 1.28Zm6.32 3.27v-6.55h.97v1.03h.09c.13-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.07.3.3.2.52.47.68.82h.07c.17-.34.42-.6.75-.8.34-.21.74-.31 1.2-.31.6 0 1.07.18 1.44.55.38.36.56.93.56 1.7V332h-1v-4.38c0-.48-.13-.83-.4-1.04-.26-.2-.57-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V332h-1.02v-4.48c0-.38-.12-.67-.37-.9a1.3 1.3 0 0 0-.93-.35c-.26 0-.5.07-.73.21-.23.14-.4.33-.55.58-.13.25-.2.53-.2.85V332h-1Zm17.56-4.83v.94h-3.82v-.94h3.82Zm8.02 4.95c-.36 0-.71-.07-1.07-.2a2.58 2.58 0 0 1-.98-.67 3.4 3.4 0 0 1-.71-1.26 8.75 8.75 0 0 1-.05-4.07c.14-.6.35-1.1.63-1.5.27-.42.6-.73 1-.95.38-.21.83-.32 1.32-.32.49 0 .92.1 1.3.3.39.2.7.46.94.8.24.35.4.75.47 1.2h-1.04c-.1-.39-.28-.71-.56-.97a1.56 1.56 0 0 0-1.11-.39c-.68 0-1.21.3-1.6.88a4.5 4.5 0 0 0-.58 2.48h.06a2.54 2.54 0 0 1 2.15-1.16 2.77 2.77 0 0 1 2.37 1.4c.25.44.38.94.38 1.5 0 .54-.12 1.03-.37 1.48a2.76 2.76 0 0 1-2.55 1.45Zm0-.94c.36 0 .68-.09.97-.27a2.04 2.04 0 0 0 .93-1.73 2.02 2.02 0 0 0-.9-1.69c-.29-.18-.6-.26-.96-.26a1.94 1.94 0 0 0-1.78 1.23 2.02 2.02 0 0 0 .77 2.45c.28.18.6.27.97.27Zm4.61 3.27v-9h.97v1.04h.12l.3-.43a1.82 1.82 0 0 1 1.6-.7 2.6 2.6 0 0 1 2.43 1.6c.24.5.36 1.1.36 1.78 0 .7-.12 1.3-.36 1.8a2.56 2.56 0 0 1-2.42 1.59 2.1 2.1 0 0 1-1.01-.2c-.25-.14-.45-.3-.58-.48a6.15 6.15 0 0 1-.32-.46h-.08v3.46h-1.01Zm.99-5.72c0 .5.07.93.22 1.3.14.38.35.68.63.89.28.2.62.31 1.02.31.42 0 .77-.1 1.06-.33.28-.22.5-.52.63-.9.15-.38.22-.8.22-1.27 0-.46-.07-.88-.21-1.25a1.92 1.92 0 0 0-.64-.88 1.67 1.67 0 0 0-1.06-.33 1.67 1.67 0 0 0-1.66 1.18c-.14.36-.21.79-.21 1.28Zm6.32 3.27v-6.55h.97v1.03h.09c.13-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.07.3.3.2.52.47.68.82h.07c.17-.34.42-.6.75-.8.34-.21.74-.31 1.2-.31.6 0 1.07.18 1.44.55.38.36.56.93.56 1.7V332h-1v-4.38c0-.48-.13-.83-.4-1.04-.26-.2-.57-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V332h-1.02v-4.48c0-.38-.12-.67-.37-.9a1.3 1.3 0 0 0-.93-.35c-.26 0-.5.07-.73.21-.23.14-.4.33-.55.58-.13.25-.2.53-.2.85V332h-1Z"
      />
      <path
        fill="#14141F"
        d="M272.68 351.91v-1.1h7.63v1.1h-3.2V361h-1.23v-9.09h-3.2Zm11.47 9.25a3.6 3.6 0 0 1-1.9-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.49.7.84.9.36.21.78.31 1.25.31.3 0 .59-.04.84-.12.25-.1.46-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm7.2.02c-.49 0-.93-.1-1.32-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.36-.07.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.31.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V361h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.17-1.06c.47 0 .86-.09 1.18-.27a1.88 1.88 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.9 29.9 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.7.3 1.16.3Zm5.47.88v-7.64h1.13v1.2h.1c.16-.41.41-.73.77-.95a2.3 2.3 0 0 1 1.28-.35c.5 0 .92.12 1.25.35.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.87-.36 1.41-.36.69 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V361h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.24.49-.3.32-.45.73-.45 1.22V361h-1.19v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V361h-1.17Zm16.26-10.18h1.47l3.46 8.45h.12l3.46-8.45h1.47V361h-1.15v-7.74h-.1L318.8 361h-1.12l-3.18-7.74h-.1V361h-1.15v-10.18Zm15.5 10.34a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.89v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12.25-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.05.68c-.4.16-.88.24-1.4.24Zm8.15 0a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.94 2.94 0 0 1 1.81 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.22.36-.33.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12.25-.1.47-.23.65-.4.19-.18.33-.4.43-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm8.26-7.8v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.41 2.41 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.93 1.93 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm4.57 9.47v-7.64h1.17V361h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.23 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm3.9 4.3v4.6h-1.18v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V361h-1.18v-4.77c0-.6-.15-1.07-.46-1.4-.31-.34-.74-.51-1.29-.51-.37 0-.7.08-1 .24-.3.16-.52.4-.7.71-.16.31-.25.7-.25 1.14Zm10.1 7.62c-.57 0-1.06-.07-1.47-.22a3.09 3.09 0 0 1-1.66-1.3l.94-.67c.1.14.24.3.4.48.16.19.38.34.66.48.29.13.66.2 1.12.2a2.5 2.5 0 0 0 1.53-.45c.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.2.31-.37.52-.15.2-.38.38-.67.54-.3.15-.69.23-1.19.23a3.07 3.07 0 0 1-2.82-1.71 4.45 4.45 0 0 1-.42-2.03c0-.78.14-1.46.42-2.04a3.04 3.04 0 0 1 2.85-1.83c.5 0 .89.08 1.18.24.3.17.52.35.67.56.16.2.29.37.37.5h.12v-1.2h1.13v7.85c0 .65-.14 1.19-.44 1.6-.3.41-.7.72-1.2.9-.5.2-1.05.3-1.66.3Zm-.05-4.2c.47 0 .87-.1 1.2-.32.32-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.25-1.45a2.2 2.2 0 0 0-.73-1 1.97 1.97 0 0 0-1.2-.35 2 2 0 0 0-1.99 1.39c-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.16.41.41.73.74.96.33.23.74.35 1.23.35Z"
      />
      <path
        fill="#DEE5ED"
        d="M512 383H232v2h280v-2Z"
        mask="url(#path-84-inside-1_1_3812)"
      />
      <rect width={6} height={6} x={249} y={405} fill="#8000FF" rx={3} />
      <path
        fill="#6C7793"
        d="M272.58 404.21v-.94h6.55v.94h-2.75V412h-1.06v-7.79h-2.74Zm9.75 7.93c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.45.28.8.68 1.04 1.19a4 4 0 0 1 .38 1.78c0 .68-.13 1.27-.38 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.51-.53.65-.91s.21-.78.21-1.22c0-.44-.07-.84-.2-1.22a2.07 2.07 0 0 0-.65-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.1.35-.3.24-.51.54-.65.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.15.38.36.68.65.9.3.24.66.35 1.11.35Zm4.5.76v-6.55h.97v1.03h.09c.13-.35.35-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .78.1 1.07.3.3.2.52.47.68.82h.07c.16-.34.42-.6.75-.8.34-.21.74-.31 1.2-.31.6 0 1.07.18 1.44.55.38.36.56.93.56 1.7V412h-1v-4.38c0-.48-.14-.83-.4-1.04-.26-.2-.58-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V412h-1.02v-4.48c0-.38-.13-.67-.37-.9a1.3 1.3 0 0 0-.93-.35c-.26 0-.5.07-.73.21-.23.14-.41.33-.55.58-.14.25-.2.53-.2.85V412h-1Zm13.09.14c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.45.28.8.68 1.04 1.19a4 4 0 0 1 .38 1.78c0 .68-.13 1.27-.38 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.51-.53.65-.91s.21-.78.21-1.22c0-.44-.07-.84-.2-1.22a2.06 2.06 0 0 0-.65-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.1.35-.3.24-.51.54-.65.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.15.38.36.68.65.9.3.24.66.35 1.1.35Zm4.5.76v-6.55h.97v1h.07c.12-.33.34-.6.65-.8.31-.2.66-.3 1.06-.3a10.86 10.86 0 0 1 .52.02v1.02a3.3 3.3 0 0 0-.61-.07c-.32 0-.6.07-.85.2s-.45.32-.6.55c-.13.23-.2.5-.2.79V412h-1.01Zm4.46 0v-6.55h.98v1h.06c.12-.33.34-.6.65-.8.31-.2.67-.3 1.06-.3a10.94 10.94 0 0 1 .53.02v1.02a3.3 3.3 0 0 0-.62-.07c-.31 0-.6.07-.85.2s-.44.32-.59.55c-.14.23-.2.5-.2.79V412h-1.01Zm6.93.14c-.6 0-1.1-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.38-1.78.24-.51.6-.9 1.03-1.19.45-.28.97-.42 1.56-.42.6 0 1.1.14 1.55.42.45.28.8.68 1.04 1.19a4 4 0 0 1 .38 1.78c0 .68-.13 1.27-.38 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.51-.53.65-.91s.21-.78.21-1.22c0-.44-.07-.84-.2-1.22a2.06 2.06 0 0 0-.65-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.1.35-.3.24-.51.54-.65.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.15.38.36.68.65.9.3.24.66.35 1.11.35Zm5.76.76-2-6.55h1.06l1.42 5.02h.07l1.4-5.02h1.07l1.38 5h.07l1.41-5h1.06l-2 6.55h-.98l-1.44-5.03h-.1l-1.43 5.03h-.99Zm8.88-1.2-.07.47a19.35 19.35 0 0 1-.78 2.86h-.77l.14-.72a25.91 25.91 0 0 0 .34-2.13l.05-.47h1.09Zm5.73 1.2h-1.1l3.2-8.73h1.09l3.2 8.73h-1.1l-2.61-7.35h-.07l-2.61 7.35Zm.4-3.4h4.48v.93h-4.47v-.94Zm8.22-5.33V412h-1v-8.73h1Zm2.85 0V412h-1v-8.73h1Zm8.05 8.73H353v-8.73h2.81c.85 0 1.58.18 2.18.53.6.34 1.06.84 1.38 1.5.32.64.48 1.42.48 2.32 0 .9-.16 1.7-.48 2.35-.32.65-.8 1.15-1.42 1.5-.62.35-1.37.53-2.25.53Zm-1.64-.94h1.57a3.5 3.5 0 0 0 1.8-.42c.47-.27.82-.67 1.05-1.18.23-.52.35-1.13.35-1.84 0-.7-.11-1.31-.34-1.82-.23-.51-.58-.9-1.04-1.18a3.26 3.26 0 0 0-1.7-.41h-1.7v6.85Zm9.36 1.1c-.42 0-.8-.09-1.13-.24-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.14-.24.34-.42.59-.55.25-.14.52-.24.82-.3.3-.07.6-.12.9-.16.4-.06.72-.1.97-.12.25-.03.43-.07.55-.14.11-.06.17-.18.17-.34v-.04c0-.41-.11-.74-.34-.97-.23-.24-.58-.35-1.04-.35-.48 0-.86.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.15.8.3s.47.38.64.7c.17.3.26.72.26 1.24V412h-1v-.89h-.06c-.07.15-.18.3-.34.46-.16.16-.37.3-.64.41-.26.12-.58.17-.96.17Zm.15-.91a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.14.1-.28.14a20.74 20.74 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.23.07-.4.19-.55.34a.86.86 0 0 0-.2.6c0 .35.13.62.39.8.26.17.59.26.99.26Zm5.1 3.2a2.22 2.22 0 0 1-.74-.12l.26-.88c.24.06.46.08.65.07.18-.02.35-.1.5-.25a2 2 0 0 0 .4-.72l.19-.52-2.42-6.57h1.09l1.8 5.21h.07l1.8-5.22h1.1l-2.78 7.5c-.12.34-.28.62-.46.84-.19.23-.4.4-.65.5-.24.11-.51.16-.81.16Z"
      />
      <path
        fill="#14141F"
        d="M273.23 441v-10.18h3.44c.8 0 1.45.14 1.96.43s.89.67 1.14 1.16c.24.49.36 1.03.36 1.63 0 .6-.12 1.14-.36 1.63-.25.5-.62.89-1.13 1.18-.5.29-1.15.43-1.95.43h-2.46v-1.1h2.42c.55 0 .99-.09 1.32-.28.33-.19.57-.44.72-.76.15-.33.23-.7.23-1.1 0-.4-.08-.77-.23-1.1-.15-.31-.39-.57-.72-.75a2.75 2.75 0 0 0-1.34-.28h-2.16V441h-1.24Zm8.73 0v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.67 3.67 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.72 1.72 0 0 0-.94 1.56V441h-1.16Zm8.08.16c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.51-.33 1.12-.5 1.8-.5.7 0 1.3.17 1.82.5.52.32.92.79 1.21 1.38.3.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.06c.52 0 .95-.13 1.3-.4.33-.27.58-.62.74-1.06a4.1 4.1 0 0 0 0-2.85c-.16-.44-.41-.8-.75-1.06a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.28.4 2.4 2.4 0 0 0-.75 1.07 4.1 4.1 0 0 0 0 2.85c.16.44.4.8.75 1.06.33.27.77.4 1.29.4Zm8.13 1.06a3 3 0 0 1-2.82-1.86c-.28-.59-.42-1.29-.42-2.1 0-.8.14-1.5.42-2.09a3.03 3.03 0 0 1 2.85-1.85c.5 0 .88.09 1.17.25.3.17.52.35.67.56l.36.5h.1v-3.75h1.17V441h-1.13v-1.17h-.14c-.08.14-.2.31-.37.52-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.2-.36.32-.25.57-.6.74-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.95 1.95 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.24.91-.24 1.45 0 .55.08 1.04.25 1.48.16.44.41.8.74 1.06s.74.38 1.23.38Zm10.47-2.22v-4.52h1.17V441h-1.17v-1.3h-.08a2.5 2.5 0 0 1-.84 1c-.37.26-.85.4-1.43.4-.47 0-.9-.1-1.27-.31a2.2 2.2 0 0 1-.88-.96 3.63 3.63 0 0 1-.31-1.61v-4.86h1.17v4.78c0 .55.15 1 .47 1.33.31.33.71.5 1.2.5a2 2 0 0 0 1.97-2.1Zm6.42 3.28a3.3 3.3 0 0 1-1.85-.5c-.51-.35-.91-.81-1.19-1.4a4.74 4.74 0 0 1-.42-2.04c0-.77.14-1.46.43-2.05a3.24 3.24 0 0 1 3.01-1.9c.54 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.78 1.78 0 0 0-1.83-1.33c-.45-.01-.85.1-1.2.35-.34.23-.6.56-.8 1-.19.42-.28.93-.28 1.5 0 .6.09 1.1.27 1.54.2.44.46.78.8 1.02.35.24.75.37 1.21.37.3 0 .58-.06.83-.16a1.71 1.71 0 0 0 1-1.18h1.18a2.72 2.72 0 0 1-1.53 2.08c-.42.2-.91.3-1.48.3Zm8.04-7.8v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm11.8 9.47h-3.14v-10.18h3.28c1 0 1.84.2 2.54.61a4 4 0 0 1 1.62 1.75c.37.75.56 1.65.56 2.7 0 1.07-.2 1.98-.57 2.75a4.04 4.04 0 0 1-1.65 1.76c-.72.4-1.6.61-2.63.61Zm-1.9-1.1h1.83c.84 0 1.54-.16 2.09-.48a3 3 0 0 0 1.24-1.39c.27-.6.4-1.31.4-2.14 0-.82-.13-1.53-.4-2.12a2.97 2.97 0 0 0-1.2-1.38 3.81 3.81 0 0 0-2-.48h-1.96v8Zm11.87 1.26a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.94 2.94 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.89v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12.26-.1.47-.23.65-.4.19-.18.33-.4.43-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm4.94-.16v-7.64h1.14v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.28-.35s.92.12 1.25.35c.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.87-.36 1.41-.36.68 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V441h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.24.49-.3.32-.45.73-.45 1.22V441h-1.19v-5.23c0-.43-.14-.78-.42-1.05-.28-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V441h-1.18Zm15.28.16c-.7 0-1.3-.17-1.82-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.82-.5a3.3 3.3 0 0 1 3.02 1.87c.29.6.44 1.3.44 2.1 0 .78-.15 1.47-.44 2.06-.29.59-.7 1.05-1.22 1.38a3.3 3.3 0 0 1-1.8.49Zm0-1.06c.52 0 .95-.13 1.29-.4.34-.27.59-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4c-.33.28-.58.63-.75 1.07a4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.17.44.42.8.75 1.06.34.27.77.4 1.3.4Zm6.42-3.7v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .97.11 1.35.32.4.21.7.53.9.96.22.42.33.96.33 1.6V441h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm12.43-1.33-1.06.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.29-.3-.5-.42-.23-.1-.5-.16-.85-.16a2 2 0 0 0-1.17.32c-.3.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.05.81-.44.2-.96.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.1.41.3.72.6.93.3.2.7.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.29-.66a1.76 1.76 0 0 0-.85-.41l-1.27-.3a3.04 3.04 0 0 1-1.55-.77 1.86 1.86 0 0 1-.48-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.74.77.93 1.31Zm5.22-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.87.14c-.34 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm4.57 9.47v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a14.83 14.83 0 0 1 .62.02v1.2a3.67 3.67 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.71 1.71 0 0 0-.94 1.56V441h-1.16Zm7.45.18c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.08-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.35-.07.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.54 4.54 0 0 1 2.01-.07c.33.06.64.18.93.36.3.18.56.45.75.8.2.37.3.85.3 1.46V441h-1.17v-1.03h-.06a2.27 2.27 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.06c.47 0 .86-.09 1.18-.27a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.27.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm8.78-6.76v1h-3.95v-1h3.95Zm-2.8-1.83h1.18v7.28c0 .33.04.58.14.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm4.57 9.47v-7.64h1.17V441h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.25-.57a.83.83 0 0 1 .59-.23c.23 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm5.82 9.06c-.69 0-1.29-.17-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.81-.5.7 0 1.3.17 1.81.5.53.32.93.79 1.22 1.38.29.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.06c.53 0 .96-.13 1.3-.4.34-.27.59-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07c-.16.45-.24.92-.24 1.43 0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm6.43-3.7v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .97.11 1.35.32.4.21.7.53.9.96.22.42.33.96.33 1.6V441h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm12.96 4.6-2.78-10.18h1.25l2.13 8.3h.1l2.16-8.3h1.4l2.16 8.3h.1l2.13-8.3h1.25L439.4 441h-1.27l-2.25-8.11h-.08l-2.25 8.11h-1.27Zm13.77.16a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.64.52-1.05.68-.41.16-.88.24-1.4.24Zm5.1-.16v-10.18h1.18v3.76h.1l.36-.51c.15-.2.38-.4.67-.56.29-.16.68-.25 1.18-.25a3.03 3.03 0 0 1 2.85 1.85c.27.6.41 1.29.41 2.1 0 .8-.14 1.5-.41 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.88 7.88 0 0 1-.37-.53h-.14V441h-1.13Zm1.16-3.82c0 .58.09 1.09.26 1.53.17.44.41.78.74 1.03.32.24.72.37 1.19.37.49 0 .9-.13 1.23-.4.33-.25.58-.6.74-1.05.17-.44.26-.94.26-1.48s-.09-1.02-.25-1.45c-.16-.43-.41-.78-.74-1.03a1.96 1.96 0 0 0-1.24-.38 1.95 1.95 0 0 0-1.94 1.37c-.17.42-.25.92-.25 1.5Zm7.38 3.82v-7.64h1.18V441h-1.18Zm.6-8.9a.83.83 0 0 1-.59-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.16.16.25.35.25.56 0 .22-.09.41-.25.57a.82.82 0 0 1-.59.23Zm3.9 4.3v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.4-.36.52 0 .98.11 1.36.32.4.21.7.53.91.96.21.42.32.96.32 1.6V441h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm9.26 4.78c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.08-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.35-.07.7-.14 1.06-.19l1.13-.13c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.54 4.54 0 0 1 2.02-.07c.32.06.63.18.92.36.3.18.56.45.76.8.2.37.3.85.3 1.46V441h-1.18v-1.03h-.06a2.27 2.27 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.06c.47 0 .86-.09 1.18-.27a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm5.47.88v-7.64h1.13v1.16h.08c.14-.38.39-.69.75-.92.37-.24.78-.36 1.24-.36a14.75 14.75 0 0 1 .61.02v1.2a3.67 3.67 0 0 0-.71-.08c-.37 0-.7.08-1 .23a1.72 1.72 0 0 0-.93 1.56V441h-1.17Z"
      />
      <path
        fill="#DEE5ED"
        d="M512 463H232v2h280v-2Z"
        mask="url(#path-89-inside-2_1_3812)"
      />
      <rect width={6} height={6} x={249} y={485} fill="#0FBDBD" rx={3} />
      <path
        fill="#6C7793"
        d="M273.42 492h-1.11l3.2-8.73h1.1l3.2 8.73h-1.11l-2.6-7.35h-.08l-2.6 7.35Zm.4-3.4h4.47v.93h-4.47v-.94Zm11.33.72v-3.87h1.01V492h-1v-1.1h-.07c-.16.32-.4.6-.72.84-.32.23-.73.34-1.23.34-.4 0-.77-.08-1.09-.26a1.87 1.87 0 0 1-.75-.82 3.1 3.1 0 0 1-.27-1.39v-4.16h1v4.1c0 .47.14.85.4 1.14.28.28.62.42 1.04.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.26-.6.26-1Zm5.5 5.27c-.5 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.09.11.2.25.35.4.13.16.32.3.57.41.24.12.56.18.95.18.53 0 .97-.13 1.31-.39.35-.25.52-.65.52-1.2v-1.33h-.09c-.07.12-.18.27-.31.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.02.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.35-1.74c0-.67.11-1.25.35-1.75s.56-.88.98-1.16c.42-.27.91-.41 1.46-.41.43 0 .76.07 1.01.21.26.14.45.3.58.48l.32.43h.1v-1.04h.97v6.74c0 .56-.12 1.02-.38 1.37-.25.36-.6.62-1.02.78-.43.17-.9.25-1.43.25Zm-.04-3.6c.4 0 .75-.09 1.02-.27.28-.19.5-.45.64-.8.14-.35.22-.76.22-1.24s-.08-.9-.22-1.25a1.87 1.87 0 0 0-.63-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.06.86.2 1.21.15.35.36.62.64.82.29.2.64.3 1.06.3Zm8.83-1.67v-3.87h1V492h-1v-1.1h-.07c-.15.32-.39.6-.71.84-.33.23-.74.34-1.23.34-.41 0-.77-.08-1.1-.26a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.27-1.39v-4.16h1v4.1c0 .47.13.85.4 1.14.27.28.61.42 1.03.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.27-.6.27-1Zm7.48-2.4-.9.26c-.06-.15-.14-.3-.25-.44-.1-.15-.26-.27-.44-.36-.2-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.09.45.27.6.18.14.47.26.85.36l.98.23c.58.15 1.02.36 1.3.66.29.29.43.66.43 1.12 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.95-.24c.1.36.26.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.27-.2.41-.44.41-.72a.76.76 0 0 0-.24-.57c-.15-.16-.4-.28-.73-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.31-.98s.5-.5.86-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.43.37.28.64.65.8 1.12Zm4.48-1.47v.86h-3.39v-.86h3.4Zm-2.4-1.56h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.29a1.83 1.83 0 0 0 .7.05l.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm7.27 8.11v-.77l2.88-3.15c.34-.37.62-.7.84-.96.22-.28.38-.54.49-.78.1-.24.16-.5.16-.77a1.42 1.42 0 0 0-.82-1.31 1.94 1.94 0 0 0-.85-.19c-.34 0-.63.07-.88.21-.25.14-.44.33-.57.58-.14.25-.2.53-.2.87h-1.01a2.46 2.46 0 0 1 1.32-2.25c.4-.22.86-.33 1.37-.33.51 0 .97.11 1.36.33.4.21.7.5.93.87.22.37.34.77.34 1.22 0 .32-.06.64-.18.95-.11.3-.31.64-.6 1.01-.28.38-.67.83-1.17 1.37l-1.96 2.1v.06h4.06v.94h-5.5Zm10.07.12c-.59 0-1.1-.1-1.56-.31-.44-.21-.79-.5-1.04-.87a2.17 2.17 0 0 1-.37-1.26 2.31 2.31 0 0 1 .82-1.8c.26-.22.55-.36.87-.41v-.06c-.42-.1-.75-.34-1-.7a2.13 2.13 0 0 1-.37-1.24c0-.44.11-.84.34-1.19.23-.35.54-.62.94-.82a3 3 0 0 1 1.37-.3c.5 0 .95.1 1.35.3.4.2.71.47.94.82.23.35.35.75.35 1.2 0 .45-.13.87-.38 1.23s-.58.6-.99.7v.06c.32.05.6.19.86.4a2.35 2.35 0 0 1 .45 3.07c-.25.37-.6.66-1.05.87-.44.2-.95.3-1.53.3Zm0-.94c.39 0 .73-.06 1.02-.19.28-.13.5-.3.66-.54.16-.23.24-.5.24-.82 0-.33-.09-.62-.25-.87-.17-.26-.4-.45-.69-.6a2.15 2.15 0 0 0-.98-.22c-.38 0-.7.08-1 .22-.3.14-.52.34-.69.6-.16.25-.24.54-.24.87 0 .31.07.59.22.82.16.23.38.41.67.54.3.13.64.2 1.04.2Zm0-4.14c.3 0 .59-.06.83-.19a1.42 1.42 0 0 0 .78-1.31 1.35 1.35 0 0 0-.78-1.28 1.84 1.84 0 0 0-.83-.19c-.33 0-.62.06-.86.19a1.33 1.33 0 0 0-.76 1.28c0 .3.06.56.2.79.14.22.33.4.57.52.25.13.53.19.85.19Zm5.84 3.77-.07.46a19.37 19.37 0 0 1-.78 2.86h-.77l.15-.72a30.42 30.42 0 0 0 .33-2.13l.05-.47h1.1Zm8.02 1.3c-.59 0-1.1-.1-1.55-.3-.45-.21-.8-.5-1.05-.87a2.17 2.17 0 0 1-.37-1.26 2.33 2.33 0 0 1 .82-1.8c.26-.22.55-.36.87-.41v-.06c-.42-.1-.75-.34-1-.7a2.13 2.13 0 0 1-.36-1.24c0-.44.1-.84.33-1.19s.54-.62.94-.82a3 3 0 0 1 1.37-.3c.5 0 .96.1 1.35.3.4.2.71.47.94.82.23.35.35.75.35 1.2 0 .45-.13.87-.38 1.23s-.57.6-.98.7v.06c.31.05.6.19.85.4a2.38 2.38 0 0 1 .84 1.81c0 .47-.14.9-.39 1.26-.25.37-.6.66-1.04.87-.45.2-.96.3-1.54.3Zm0-.93c.4 0 .74-.06 1.02-.19.29-.13.51-.3.67-.54a1.57 1.57 0 0 0-.02-1.7c-.17-.25-.4-.44-.69-.59a2.15 2.15 0 0 0-.98-.22c-.37 0-.7.08-1 .22-.29.14-.52.34-.68.6-.17.25-.25.54-.25.87 0 .31.08.59.23.82.15.23.38.41.67.54.29.13.63.2 1.03.2Zm0-4.14c.31 0 .59-.06.83-.19a1.42 1.42 0 0 0 .79-1.31c0-.3-.07-.55-.21-.77-.14-.22-.33-.4-.57-.51a1.85 1.85 0 0 0-.84-.19c-.33 0-.61.06-.86.19-.24.12-.43.29-.56.5-.14.23-.2.48-.2.78 0 .3.06.56.2.79.14.22.33.4.58.52.24.13.52.19.84.19Zm6.54 5.11c-.41 0-.79-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.81-.3.3-.07.6-.12.9-.16.4-.06.73-.1.97-.12.25-.03.44-.07.55-.14.12-.06.18-.18.18-.34v-.04c0-.41-.12-.74-.35-.97-.23-.24-.57-.35-1.03-.35-.49 0-.86.1-1.13.31-.28.21-.47.44-.58.67l-.95-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.27.04.54.15.8.3.25.15.46.38.63.7.18.3.26.72.26 1.24V492h-1v-.89h-.06a1.96 1.96 0 0 1-.98.87c-.26.12-.58.17-.96.17Zm.15-.9a2 2 0 0 0 1.01-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.05.05-.14.1-.29.14a21.3 21.3 0 0 1-1.46.23c-.25.04-.5.1-.73.17-.22.07-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm4.69.75v-6.55h.97v1.03h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.08.3.29.2.51.47.67.82h.07c.17-.34.42-.6.76-.8.33-.21.73-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V492h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V492h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.94-.35c-.26 0-.5.07-.73.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V492h-1.01Zm17.55-4.83v.94h-3.82v-.94h3.82Zm8.2-3.9V492h-1.06v-7.62h-.05l-2.13 1.42v-1.08l2.18-1.45h1.06Zm5.57 0V492h-1.05v-7.62h-.05l-2.13 1.42v-1.08l2.18-1.45h1.05Zm4.46 8.88c-.42 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.14-.24.34-.42.59-.55.25-.14.52-.24.82-.3.3-.07.6-.12.9-.16.4-.06.72-.1.97-.12.25-.03.43-.07.55-.14.11-.06.17-.18.17-.34v-.04c0-.41-.11-.74-.34-.97-.23-.24-.57-.35-1.04-.35-.48 0-.86.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.15.8.3s.47.38.64.7c.17.3.26.72.26 1.24V492h-1v-.89h-.06c-.07.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.6.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.07-.4.19-.54.34a.85.85 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm4.68.75v-6.55h.98v1.03h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.07.3.3.2.52.47.68.82h.07c.17-.34.42-.6.75-.8.34-.21.74-.31 1.21-.31.59 0 1.06.18 1.44.55.37.36.56.93.56 1.7V492h-1.01v-4.38c0-.48-.13-.83-.4-1.04-.26-.2-.57-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V492h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.94-.35c-.26 0-.5.07-.73.21-.22.14-.4.33-.55.58-.13.25-.2.53-.2.85V492h-1Z"
      />
      <path
        fill="#14141F"
        d="M273.23 521v-10.18h6.15v1.1h-4.91v3.43h4.59v1.1h-4.6v3.46h5V521h-6.23Zm14.45-7.64-2.82 7.64h-1.2l-2.82-7.64h1.28l2.1 6.09h.08l2.11-6.09h1.27Zm3.57 7.82c-.49 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18l1.13-.14c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.53 4.53 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V521h-1.18v-1.03h-.05a2.28 2.28 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.05c.46 0 .85-.1 1.17-.28a1.87 1.87 0 0 0 .97-1.61v-1.08c-.04.06-.15.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.69.3 1.16.3Zm6.63-9.31V521h-1.17v-10.18h1.17Zm6.96 7.06v-4.52h1.18V521h-1.18v-1.3h-.07a2.5 2.5 0 0 1-.84 1c-.38.26-.86.4-1.43.4-.48 0-.9-.1-1.27-.31a2.2 2.2 0 0 1-.88-.96 3.63 3.63 0 0 1-.32-1.61v-4.86h1.18v4.78c0 .55.15 1 .46 1.33.32.33.72.5 1.2.5a2 2 0 0 0 1.97-2.1Zm5.57 3.3c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.36-.07.7-.14 1.06-.18l1.13-.14c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.31.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V521h-1.18v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.05c.47 0 .86-.1 1.18-.28a1.88 1.88 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.9 29.9 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.7.3 1.16.3Zm8.79-6.77v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.34 2.34 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm4.56 9.47v-7.64h1.18V521h-1.18Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.25-.57a.83.83 0 0 1 .59-.23c.23 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm5.83 9.06c-.7 0-1.3-.16-1.82-.5a3.34 3.34 0 0 1-1.21-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.29-.6.7-1.05 1.21-1.38.52-.33 1.13-.5 1.82-.5.69 0 1.29.17 1.8.5.53.33.93.78 1.22 1.38.3.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .95-.14 1.29-.4.34-.28.59-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43-.16-.44-.41-.8-.75-1.06a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4c-.33.28-.58.63-.75 1.07a4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.17.44.42.8.75 1.06.34.27.77.4 1.3.4Zm6.42-3.7V521H333v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.4-.36.53 0 .98.11 1.37.32.38.21.69.53.9.96.21.42.32.96.32 1.6V521h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.3-.34-.74-.51-1.28-.51-.38 0-.7.08-1 .24-.3.16-.53.4-.7.71-.16.31-.25.7-.25 1.14Zm11.11-5.6h1.48l3.46 8.46h.11l3.47-8.45h1.47V521h-1.16v-7.74h-.1l-3.18 7.74h-1.11l-3.18-7.74h-.1V521h-1.16v-10.18Zm15.5 10.35a3.6 3.6 0 0 1-1.9-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.18.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.49.7.84.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.04.68c-.42.16-.88.24-1.4.24Zm8.15 0a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.32 1.25.32.3 0 .59-.05.83-.13.26-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm8.27-7.8v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm4.56 9.47v-7.64h1.18V521h-1.18Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.25-.57a.83.83 0 0 1 .59-.23c.23 0 .42.08.59.23.16.16.24.35.24.56 0 .22-.08.41-.24.57a.82.82 0 0 1-.6.23Zm3.9 4.3v4.6h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .96.11 1.35.32.39.21.7.53.9.96.22.42.33.96.33 1.6V521h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.1 7.62c-.57 0-1.06-.07-1.46-.22a3.1 3.1 0 0 1-1.67-1.3l.94-.66c.1.13.24.3.4.47.16.19.39.34.67.48.28.13.66.2 1.12.2a2.5 2.5 0 0 0 1.52-.45c.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.2.31-.36.51-.16.2-.38.39-.68.55-.3.15-.69.23-1.18.23a3.07 3.07 0 0 1-2.82-1.71 4.45 4.45 0 0 1-.42-2.03c0-.78.13-1.46.4-2.04a3.04 3.04 0 0 1 2.85-1.84c.5 0 .9.09 1.2.25.29.16.51.35.67.56l.37.5h.11v-1.2h1.14v7.85c0 .65-.15 1.19-.45 1.6-.3.41-.7.72-1.2.9-.49.2-1.04.3-1.65.3Zm-.04-4.2c.47 0 .87-.1 1.19-.32.33-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.24-1.46a2.2 2.2 0 0 0-.74-.98 1.97 1.97 0 0 0-1.2-.36 2 2 0 0 0-1.99 1.39c-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.17.41.42.73.74.96.34.23.75.35 1.24.35Z"
      />
      <path
        fill="#DEE5ED"
        d="M512 543H232v2h280v-2Z"
        mask="url(#path-94-inside-3_1_3812)"
      />
      <rect width={6} height={6} x={249} y={565} fill="#F93" rx={3} />
      <path
        fill="#6C7793"
        d="M273.42 572h-1.11l3.2-8.73h1.1l3.2 8.73h-1.11l-2.6-7.35h-.08l-2.6 7.35Zm.4-3.4h4.47v.93h-4.47v-.94Zm11.33.72v-3.87h1.01V572h-1v-1.1h-.07c-.16.32-.4.6-.72.84-.32.23-.73.35-1.23.35-.4 0-.77-.1-1.09-.27a1.87 1.87 0 0 1-.75-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.14.86.4 1.15.28.28.62.42 1.04.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.26-.6.26-1Zm5.5 5.27c-.5 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.09.12.2.25.35.4.13.16.32.3.57.41.24.12.56.18.95.18.53 0 .97-.13 1.31-.39.35-.25.52-.66.52-1.2v-1.33h-.09c-.07.12-.18.27-.31.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.02.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.35-1.74c0-.67.11-1.25.35-1.75s.56-.89.98-1.16c.42-.27.91-.41 1.46-.41.43 0 .76.07 1.01.21.26.14.45.3.58.48l.32.43h.1v-1.03h.97v6.73c0 .56-.12 1.02-.38 1.37-.25.36-.6.62-1.02.78-.43.17-.9.25-1.43.25Zm-.04-3.6c.4 0 .75-.09 1.02-.27.28-.19.5-.45.64-.8.14-.35.22-.76.22-1.24 0-.47-.08-.9-.22-1.25a1.87 1.87 0 0 0-.63-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.06.86.2 1.21.15.35.36.62.64.82.29.2.64.3 1.06.3Zm8.83-1.67v-3.87h1V572h-1v-1.1h-.07c-.15.32-.39.6-.71.84-.33.23-.74.35-1.23.35-.41 0-.77-.1-1.1-.27a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.13.86.4 1.15.27.28.61.42 1.03.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.27-.6.27-1Zm7.48-2.4-.9.26c-.06-.15-.14-.3-.25-.44-.1-.15-.26-.27-.44-.36-.2-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.09.45.27.6.18.14.47.26.85.36l.98.23c.58.14 1.02.36 1.3.65.29.3.43.67.43 1.13 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.95-.24c.1.35.26.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.27-.2.41-.44.41-.72a.76.76 0 0 0-.24-.57c-.15-.16-.4-.28-.73-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.31-.98s.5-.5.86-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.42.37.29.64.67.8 1.13Zm4.48-1.46v.85h-3.39v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.28.14.05.28.07.43.07l.27-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm7.27 8.11v-.77l2.88-3.15c.34-.37.62-.7.84-.96.22-.28.38-.54.49-.78.1-.24.16-.5.16-.77a1.42 1.42 0 0 0-.82-1.31 1.94 1.94 0 0 0-.85-.19c-.34 0-.63.07-.88.21-.25.14-.44.33-.57.58-.14.25-.2.53-.2.87h-1.01a2.46 2.46 0 0 1 1.32-2.25c.4-.22.86-.33 1.37-.33.51 0 .97.11 1.36.33.4.21.7.5.93.87.22.37.34.77.34 1.22 0 .32-.06.64-.18.95-.11.3-.31.64-.6 1.01-.28.38-.67.83-1.17 1.37l-1.96 2.1v.06h4.06v.94h-5.5Zm10.07.12c-.59 0-1.1-.1-1.56-.31-.44-.21-.79-.5-1.04-.87a2.17 2.17 0 0 1-.37-1.26 2.31 2.31 0 0 1 .82-1.8c.26-.22.55-.36.87-.41v-.06c-.42-.1-.75-.34-1-.7a2.13 2.13 0 0 1-.37-1.24c0-.44.11-.84.34-1.19.23-.35.54-.62.94-.82a3 3 0 0 1 1.37-.3c.5 0 .95.1 1.35.3.4.2.71.47.94.82.23.35.35.75.35 1.2 0 .45-.13.87-.38 1.23s-.58.6-.99.7v.06c.32.05.6.19.86.4a2.35 2.35 0 0 1 .45 3.07c-.25.37-.6.66-1.05.87-.44.2-.95.3-1.53.3Zm0-.94c.39 0 .73-.06 1.02-.19.28-.13.5-.3.66-.54.16-.23.24-.5.24-.82 0-.33-.09-.62-.25-.87-.17-.26-.4-.46-.69-.6a2.15 2.15 0 0 0-.98-.22c-.38 0-.7.08-1 .22-.3.14-.52.34-.69.6-.16.25-.24.54-.24.87 0 .31.07.59.22.82.16.23.38.41.67.54.3.13.64.2 1.04.2Zm0-4.14c.3 0 .59-.06.83-.19a1.42 1.42 0 0 0 .78-1.31 1.35 1.35 0 0 0-.78-1.28 1.84 1.84 0 0 0-.83-.19c-.33 0-.62.06-.86.19a1.33 1.33 0 0 0-.76 1.28c0 .3.06.56.2.79.14.22.33.4.57.52.25.13.53.19.85.19Zm5.84 3.77-.07.46a19.37 19.37 0 0 1-.78 2.86h-.77l.15-.72a30.42 30.42 0 0 0 .33-2.13l.05-.47h1.1Zm8.02 1.3c-.59 0-1.1-.1-1.55-.3-.45-.21-.8-.5-1.05-.87a2.17 2.17 0 0 1-.37-1.26 2.33 2.33 0 0 1 .82-1.8c.26-.22.55-.36.87-.41v-.06c-.42-.1-.75-.34-1-.7a2.13 2.13 0 0 1-.36-1.24c0-.44.1-.84.33-1.19s.54-.62.94-.82a3 3 0 0 1 1.37-.3c.5 0 .96.1 1.35.3.4.2.71.47.94.82.23.35.35.75.35 1.2 0 .45-.13.87-.38 1.23s-.57.6-.98.7v.06c.31.05.6.19.85.4a2.38 2.38 0 0 1 .84 1.81c0 .47-.14.9-.39 1.26-.25.37-.6.66-1.04.87-.45.2-.96.3-1.54.3Zm0-.93c.4 0 .74-.06 1.02-.19.29-.13.51-.3.67-.54a1.57 1.57 0 0 0-.02-1.7c-.17-.25-.4-.45-.69-.59a2.15 2.15 0 0 0-.98-.22c-.37 0-.7.08-1 .22-.29.14-.52.34-.68.6-.17.25-.25.54-.25.87 0 .31.08.59.23.82.15.23.38.41.67.54.29.13.63.2 1.03.2Zm0-4.14c.31 0 .59-.06.83-.19a1.42 1.42 0 0 0 .79-1.31c0-.3-.07-.55-.21-.77-.14-.22-.33-.4-.57-.51a1.85 1.85 0 0 0-.84-.19c-.33 0-.61.06-.86.19-.24.12-.43.29-.56.5-.14.23-.2.48-.2.78 0 .3.06.56.2.79.14.22.33.4.58.52.24.13.52.19.84.19Zm6.54 5.11c-.41 0-.79-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.81-.3.3-.07.6-.12.9-.16.4-.06.73-.1.97-.12.25-.03.44-.07.55-.14.12-.07.18-.18.18-.34v-.03c0-.43-.12-.75-.35-.99-.23-.23-.57-.34-1.03-.34-.49 0-.86.1-1.13.31-.28.21-.47.44-.58.67l-.95-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.27.04.54.14.8.3.25.15.46.38.63.7.18.3.26.72.26 1.24V572h-1v-.89h-.06a1.96 1.96 0 0 1-.98.87c-.26.12-.58.17-.96.17Zm.15-.9a2 2 0 0 0 1.01-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.05.05-.14.1-.29.14a21.3 21.3 0 0 1-1.46.23c-.25.04-.5.1-.73.17-.22.08-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm4.69.75v-6.54h.97v1.02h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.08.3.29.2.51.47.67.82h.07c.17-.34.42-.6.76-.8.33-.21.73-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V572h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V572h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.94-.35c-.26 0-.5.07-.73.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V572h-1.01Zm17.55-4.83v.94h-3.82v-.94h3.82Zm8.2-3.9V572h-1.06v-7.62h-.05l-2.13 1.41v-1.07l2.18-1.45h1.06Zm5.57 0V572h-1.05v-7.62h-.05l-2.13 1.41v-1.07l2.18-1.45h1.05Zm4.46 8.88c-.42 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.14-.24.34-.42.59-.55.25-.14.52-.24.82-.3.3-.07.6-.12.9-.16.4-.06.72-.1.97-.12.25-.03.43-.07.55-.14.11-.07.17-.18.17-.34v-.03c0-.43-.11-.75-.34-.99-.23-.23-.57-.34-1.04-.34-.48 0-.86.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.14.8.3.26.15.47.38.64.7.17.3.26.72.26 1.24V572h-1v-.89h-.06c-.07.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.6.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.08-.4.19-.54.34a.85.85 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm4.68.75v-6.54h.98v1.02h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.07.3.3.2.52.47.68.82h.07c.17-.34.42-.6.75-.8.34-.21.74-.31 1.21-.31.59 0 1.06.18 1.44.55.37.36.56.93.56 1.7V572h-1.01v-4.38c0-.48-.13-.83-.4-1.04-.26-.2-.57-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V572h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.94-.35c-.26 0-.5.07-.73.21-.22.14-.4.33-.55.58-.13.25-.2.53-.2.85V572h-1Z"
      />
      <path
        fill="#14141F"
        d="M278.8 593.36c-.06-.5-.3-.9-.73-1.17a2.79 2.79 0 0 0-1.56-.42c-.45 0-.84.08-1.18.22-.33.15-.6.35-.78.6a1.44 1.44 0 0 0-.09 1.57c.13.2.3.36.5.49.21.12.43.23.65.31l.63.2 1.03.27c.27.07.56.17.88.29.33.12.65.29.94.5a2.32 2.32 0 0 1 1.04 2.01c0 .56-.14 1.05-.43 1.5-.28.44-.7.8-1.25 1.06s-1.21.39-2 .39c-.72 0-1.36-.12-1.89-.35a2.8 2.8 0 0 1-1.76-2.45h1.27c.03.38.16.7.39.95s.51.43.86.56c.35.12.73.18 1.13.18.48 0 .9-.08 1.27-.23.38-.16.67-.38.9-.65.21-.28.32-.6.32-.97 0-.34-.1-.62-.28-.83a2.08 2.08 0 0 0-.75-.52c-.3-.13-.64-.25-1-.34l-1.25-.36a4.68 4.68 0 0 1-1.89-.98c-.46-.43-.7-.98-.7-1.67 0-.57.16-1.06.47-1.49.3-.43.72-.76 1.25-1a4.22 4.22 0 0 1 1.76-.35c.66 0 1.24.12 1.75.35.51.23.92.55 1.22.96.3.4.46.86.47 1.37h-1.19Zm5.45 7.82c-.49 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18l1.13-.14c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.67 2.67 0 0 1 1.9-1.63 4.53 4.53 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V601h-1.18v-1.03h-.05a2.28 2.28 0 0 1-1.14 1.01c-.31.13-.69.2-1.13.2Zm.18-1.05c.46 0 .85-.1 1.17-.28a1.87 1.87 0 0 0 .97-1.61v-1.08c-.04.06-.15.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.69.3 1.16.3Zm6.63-9.31V601h-1.17v-10.18h1.17Zm5.35 10.34a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07.29-.6.7-1.06 1.2-1.4a3.6 3.6 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.95 1.95 0 0 0-1.82-1.1c-.47 0-.88.12-1.22.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.35.21.77.32 1.24.32.31 0 .6-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.05.68c-.41.16-.88.24-1.4.24Zm10.36-6.09-1.05.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.31.7.21.16.55.3 1 .42l1.13.27c.68.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.13.83-.38 1.17-.25.35-.6.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.32-.24.49-.52.49-.85 0-.26-.1-.48-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.45-.29.75 0 1.34.17 1.78.5.43.33.74.77.92 1.31Zm6 5.93v-10.18h3.44c.8 0 1.45.14 1.96.43s.89.67 1.13 1.16c.25.49.37 1.03.37 1.63 0 .6-.12 1.14-.37 1.63-.24.5-.61.89-1.12 1.18-.5.29-1.16.43-1.95.43h-2.46v-1.1h2.42c.55 0 .99-.09 1.32-.28.33-.18.57-.44.72-.76.15-.33.23-.7.23-1.1 0-.4-.08-.77-.23-1.1-.15-.32-.39-.57-.73-.75a2.75 2.75 0 0 0-1.33-.28H314V601h-1.23Zm8.73 0v-7.64h1.17V601h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.57c0-.21.08-.4.25-.56a.83.83 0 0 1 .59-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm6.04 1.26v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.37.33.16.05.32.08.5.08l.32-.02.2-.04.23 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.65-.31-1.1v-7.6Zm7.59 9.63a3.3 3.3 0 0 1-1.85-.5c-.52-.35-.92-.81-1.2-1.4a4.74 4.74 0 0 1-.41-2.04c0-.77.14-1.46.42-2.05.3-.6.7-1.06 1.2-1.4.53-.34 1.13-.5 1.82-.5.53 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.78 1.78 0 0 0-1.83-1.33c-.46-.01-.86.1-1.2.35-.35.23-.61.57-.8 1a3.7 3.7 0 0 0-.29 1.5c0 .6.1 1.1.28 1.54.19.44.45.78.8 1.02.34.24.74.37 1.2.37.31 0 .59-.06.84-.16a1.71 1.71 0 0 0 1-1.18h1.17a2.72 2.72 0 0 1-1.52 2.08c-.43.2-.92.3-1.48.3Zm5.89-4.75V601h-1.17v-10.18h1.17v3.74h.1c.18-.4.45-.71.8-.94.37-.24.85-.36 1.45-.36.52 0 .97.1 1.36.32.4.2.7.52.91.95.22.42.33.96.33 1.62V601h-1.17v-4.77c0-.6-.16-1.08-.47-1.41-.32-.33-.75-.5-1.3-.5-.39 0-.73.08-1.04.24-.3.16-.54.4-.71.71-.17.31-.26.7-.26 1.14Zm11.2 4.59v-10.18h3.44c.8 0 1.45.14 1.95.43.51.29.9.67 1.14 1.16.24.49.37 1.03.37 1.63 0 .6-.13 1.14-.37 1.63-.25.5-.62.89-1.13 1.18-.5.29-1.15.43-1.95.43h-2.46v-1.1h2.43c.54 0 .98-.09 1.31-.28.33-.18.57-.44.72-.76.15-.33.23-.7.23-1.1 0-.4-.07-.77-.23-1.1-.15-.32-.39-.57-.72-.75a2.75 2.75 0 0 0-1.33-.28h-2.17V601H350Zm8.72 0v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.37-.24.78-.36 1.23-.36a14.85 14.85 0 0 1 .62.02v1.2a3.7 3.7 0 0 0-.72-.08c-.37 0-.7.08-.99.23a1.71 1.71 0 0 0-.94 1.56V601h-1.17Zm8.18.16a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.32 1.25.32.3 0 .59-.05.83-.13.26-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm10.36-6.09-1.06.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.29-.3-.5-.42-.23-.1-.5-.16-.85-.16a2 2 0 0 0-1.17.32c-.3.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.77.34.33.5.77.5 1.3 0 .44-.12.83-.37 1.17-.25.35-.6.62-1.05.82-.44.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.1.41.3.72.6.93.3.2.7.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.48-.29-.66a1.77 1.77 0 0 0-.85-.41l-1.27-.3a3.03 3.03 0 0 1-1.55-.77 1.86 1.86 0 0 1-.48-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.74.77.93 1.31Zm5.1 6.09a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81c.19.49.29 1.09.29 1.8v.5h-5.9v-1.01h4.7c0-.44-.08-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.23-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.64.52-1.05.68-.41.16-.88.24-1.4.24Zm6.12-4.75V601h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.82-.94.36-.24.83-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.32.96.32 1.6V601h-1.17v-4.77c0-.6-.15-1.07-.46-1.4-.32-.34-.75-.51-1.29-.51-.37 0-.7.08-1 .24-.3.16-.52.4-.7.71-.16.31-.25.7-.25 1.14Zm10.34-3.05v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.5.08l.31-.02.2-.04.24 1.05a2.34 2.34 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.31-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.08-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18a52 52 0 0 1 1.13-.14c.29-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4a2.68 2.68 0 0 1 1.88-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.56.45.75.8.2.37.3.85.3 1.46V601h-1.17v-1.03h-.06a2.3 2.3 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.18-1.05c.47 0 .86-.1 1.18-.28a1.87 1.87 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a29.9 29.9 0 0 1-1.12.15c-.3.04-.59.1-.85.2-.27.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm8.79-6.77v1h-3.96v-1h3.95Zm-2.8-1.83h1.16v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.41 2.41 0 0 1-.87.14c-.33 0-.66-.07-.97-.21a1.94 1.94 0 0 1-.8-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm4.56 9.47v-7.64h1.17V601h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.57c0-.21.08-.4.25-.56a.83.83 0 0 1 .59-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm5.82 9.06c-.69 0-1.29-.16-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.65 4.65 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.05 1.21-1.38.52-.33 1.13-.5 1.81-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.22 1.38.29.6.43 1.29.43 2.08s-.14 1.48-.43 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.05c.53 0 .96-.14 1.3-.4.33-.28.58-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43-.17-.44-.42-.8-.75-1.06a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07 4.1 4.1 0 0 0 0 2.85c.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm6.43-3.7V601h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .96.11 1.35.32.4.21.7.53.9.96.22.42.33.96.33 1.6V601h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Z"
      />
      <path
        fill="#DEE5ED"
        d="M512 623H232v2h280v-2Z"
        mask="url(#path-99-inside-4_1_3812)"
      />
      <rect width={6} height={6} x={249} y={645} fill="#FF4C4D" rx={3} />
      <path
        fill="#6C7793"
        d="M273.42 652h-1.11l3.2-8.73h1.1l3.2 8.73h-1.11l-2.6-7.35h-.08l-2.6 7.35Zm.4-3.4h4.47v.93h-4.47v-.94Zm11.33.72v-3.87h1.01V652h-1v-1.1h-.07c-.16.32-.4.6-.72.84-.32.23-.73.35-1.23.35-.4 0-.77-.1-1.09-.27a1.87 1.87 0 0 1-.75-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.14.86.4 1.15.28.28.62.42 1.04.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.26-.6.26-1Zm5.5 5.27c-.5 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.09.12.2.25.35.4.13.16.32.3.57.41.24.12.56.18.95.18.53 0 .97-.13 1.31-.39.35-.25.52-.66.52-1.2v-1.33h-.09c-.07.12-.18.27-.31.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.02.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.35-1.74c0-.67.11-1.25.35-1.75s.56-.89.98-1.16c.42-.27.91-.41 1.46-.41.43 0 .76.07 1.01.21.26.14.45.3.58.48l.32.43h.1v-1.03h.97v6.73c0 .56-.12 1.02-.38 1.37-.25.36-.6.62-1.02.78-.43.17-.9.25-1.43.25Zm-.04-3.6c.4 0 .75-.09 1.02-.27.28-.19.5-.45.64-.8.14-.35.22-.76.22-1.24 0-.47-.08-.9-.22-1.25a1.87 1.87 0 0 0-.63-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.06.86.2 1.21.15.35.36.62.64.82.29.2.64.3 1.06.3Zm8.83-1.67v-3.87h1V652h-1v-1.1h-.07c-.15.32-.39.6-.71.84-.33.23-.74.35-1.23.35-.41 0-.77-.1-1.1-.27a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.13.86.4 1.15.27.28.61.42 1.03.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.27-.6.27-1Zm7.48-2.4-.9.26c-.06-.15-.14-.3-.25-.44-.1-.15-.26-.27-.44-.36-.2-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.09.45.27.6.18.14.47.26.85.36l.98.23c.58.14 1.02.36 1.3.65.29.3.43.67.43 1.13 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.95-.24c.1.35.26.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.27-.2.41-.44.41-.72a.76.76 0 0 0-.24-.57c-.15-.16-.4-.28-.73-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.31-.98s.5-.5.86-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.42.37.29.64.67.8 1.13Zm4.48-1.46v.85h-3.39v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.28.14.05.28.07.43.07l.27-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm10.22 8.23c-.56 0-1.06-.1-1.5-.29-.44-.2-.79-.46-1.05-.8-.25-.35-.39-.75-.41-1.21h1.07c.02.28.12.52.3.73.16.2.38.36.66.47.28.1.58.16.92.16.37 0 .7-.06 1-.2.28-.13.51-.3.68-.54.16-.23.24-.5.24-.8 0-.33-.08-.61-.24-.86-.15-.24-.39-.44-.7-.58-.3-.14-.68-.2-1.12-.2h-.7v-.94h.7c.35 0 .65-.07.91-.2.27-.12.47-.3.62-.52.15-.23.23-.5.23-.8 0-.3-.07-.55-.2-.77a1.35 1.35 0 0 0-.55-.51 2.2 2.2 0 0 0-1.69-.02c-.27.1-.48.27-.65.47-.17.2-.26.45-.27.75h-1.03c.02-.46.16-.86.42-1.2.26-.35.6-.62 1.01-.82a3.28 3.28 0 0 1 2.78.04 2.3 2.3 0 0 1 1.2 2 1.97 1.97 0 0 1-1.43 1.98v.07c.55.1.98.33 1.29.7.3.38.46.85.46 1.4 0 .48-.13.9-.39 1.28-.25.37-.6.67-1.04.88a3.4 3.4 0 0 1-1.52.33Zm7.54 0a2.6 2.6 0 0 1-1.64-.52c-.45-.36-.8-.87-1.03-1.53a7.26 7.26 0 0 1-.36-2.43c0-.95.12-1.75.36-2.42a3.3 3.3 0 0 1 1.04-1.53c.45-.36 1-.54 1.63-.54.64 0 1.18.18 1.63.54.46.35.8.86 1.04 1.53.25.67.37 1.47.37 2.42s-.12 1.75-.36 2.43a3.27 3.27 0 0 1-1.04 1.52c-.45.36-1 .53-1.64.53Zm0-.94c.64 0 1.13-.3 1.49-.92.35-.61.52-1.49.52-2.62 0-.76-.08-1.4-.24-1.93a2.66 2.66 0 0 0-.69-1.22c-.3-.28-.66-.42-1.08-.42-.63 0-1.12.31-1.48.94-.35.62-.53 1.5-.53 2.63 0 .75.08 1.4.24 1.92.16.53.39.93.69 1.2.3.28.66.42 1.08.42Zm11.8-4.01v.94h-3.82v-.94h3.82Zm10.05-1.71a1.34 1.34 0 0 0-.62-1.01 2.39 2.39 0 0 0-1.34-.36c-.39 0-.72.06-1.01.19-.3.12-.51.3-.68.51a1.24 1.24 0 0 0-.07 1.35c.11.16.26.3.44.41.17.11.36.2.55.27.2.07.37.13.53.17l.89.24c.23.06.48.14.76.24.28.11.55.25.8.43a1.99 1.99 0 0 1 .9 1.73c0 .47-.13.9-.38 1.28-.24.38-.6.68-1.07.9-.47.23-1.04.34-1.71.34a4 4 0 0 1-1.62-.3 2.4 2.4 0 0 1-1.51-2.1h1.08c.03.33.14.6.34.82.2.21.44.37.74.47.3.1.62.16.97.16.4 0 .76-.07 1.09-.2.32-.13.57-.32.76-.55.19-.24.28-.52.28-.84 0-.29-.08-.52-.24-.7a1.79 1.79 0 0 0-.64-.45 6.61 6.61 0 0 0-.86-.3l-1.07-.3a4 4 0 0 1-1.62-.84c-.4-.37-.6-.84-.6-1.43 0-.49.13-.91.4-1.28.26-.36.62-.65 1.07-.85.45-.2.96-.3 1.51-.3.57 0 1.07.1 1.5.3.44.2.79.47 1.04.81.26.35.4.74.41 1.19h-1.02Zm5.49 6.68a2.8 2.8 0 0 1-2.68-1.6 4 4 0 0 1-.37-1.76c0-.67.12-1.26.36-1.77a2.77 2.77 0 0 1 2.58-1.64c.35 0 .68.06 1.02.17a2.5 2.5 0 0 1 1.56 1.56c.16.42.24.93.24 1.54v.43h-5.05v-.87h4.03c0-.37-.08-.7-.23-.99a1.67 1.67 0 0 0-1.56-.94c-.4 0-.75.1-1.04.3-.3.2-.52.45-.67.77-.16.31-.24.65-.24 1.01v.58c0 .5.09.92.26 1.26.17.34.41.6.72.78.3.17.66.26 1.07.26.26 0 .5-.03.71-.1.22-.09.4-.2.56-.35.16-.15.28-.34.37-.57l.97.27c-.1.33-.28.62-.52.87s-.54.44-.9.58c-.35.14-.75.2-1.2.2Zm4.24 2.32v-9h.97v1.03h.12l.3-.43a1.82 1.82 0 0 1 1.6-.7 2.6 2.6 0 0 1 2.43 1.6c.24.5.36 1.1.36 1.78 0 .7-.12 1.3-.36 1.8a2.56 2.56 0 0 1-2.42 1.59 2.1 2.1 0 0 1-1.01-.2c-.25-.14-.45-.3-.58-.48a6.2 6.2 0 0 1-.32-.46h-.09v3.47h-1Zm.99-5.73c0 .5.07.93.21 1.3.15.38.36.68.64.89.28.2.62.31 1.02.31.42 0 .77-.1 1.06-.33.28-.22.5-.52.63-.9.15-.38.22-.8.22-1.27 0-.46-.07-.88-.21-1.25a1.92 1.92 0 0 0-.64-.88 1.67 1.67 0 0 0-1.06-.33 1.67 1.67 0 0 0-1.66 1.18c-.14.36-.21.79-.21 1.28Zm9.17-3.27v.85h-3.4v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.04.5.12.63.09.14.2.24.33.28.13.05.27.07.42.07l.27-.01.17-.04.2.9a2.2 2.2 0 0 1-1.58-.06c-.27-.12-.5-.3-.67-.56a1.6 1.6 0 0 1-.27-.94v-6.51Zm6.58 8.25a2.8 2.8 0 0 1-2.68-1.6 4 4 0 0 1-.37-1.76c0-.67.13-1.26.37-1.77a2.77 2.77 0 0 1 2.58-1.64c.34 0 .68.06 1.01.17a2.5 2.5 0 0 1 1.56 1.56c.16.42.25.93.25 1.54v.43h-5.05v-.87h4.02c0-.37-.07-.7-.22-.99a1.67 1.67 0 0 0-1.57-.94c-.4 0-.75.1-1.04.3-.29.2-.51.45-.67.77-.15.31-.23.65-.23 1.01v.58c0 .5.08.92.25 1.26.18.34.42.6.73.78.3.17.66.26 1.06.26.27 0 .5-.03.72-.1.22-.09.4-.2.56-.35.16-.15.28-.34.36-.57l.97.27c-.1.33-.27.62-.51.87s-.54.44-.9.58c-.35.14-.75.2-1.2.2Zm4.24-.14v-6.54h.98v1.02h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.07.3.3.2.52.47.68.82h.07c.17-.34.42-.6.75-.8.34-.21.74-.31 1.21-.31.59 0 1.06.18 1.44.55.37.36.56.93.56 1.7V652h-1.01v-4.38c0-.48-.13-.83-.4-1.04-.26-.2-.57-.3-.93-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V652h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.94-.35c-.26 0-.5.07-.73.21-.22.14-.4.33-.55.58-.13.25-.2.53-.2.85V652h-1Zm10.57 0v-8.73h1v3.22h.1l.3-.43a1.82 1.82 0 0 1 1.58-.7 2.6 2.6 0 0 1 2.44 1.6c.24.5.36 1.1.36 1.78 0 .7-.12 1.3-.35 1.8-.24.51-.57.9-.99 1.18-.41.28-.9.42-1.44.42a2.1 2.1 0 0 1-1.01-.21c-.25-.14-.45-.3-.58-.48a6.2 6.2 0 0 1-.32-.46h-.12V652h-.97Zm.99-3.27c0 .5.07.93.22 1.3.14.38.35.68.63.89.28.2.62.31 1.02.31.42 0 .77-.1 1.06-.33.28-.22.5-.52.64-.9s.21-.8.21-1.27c0-.46-.07-.88-.21-1.25a1.92 1.92 0 0 0-.63-.88 1.67 1.67 0 0 0-1.07-.33 1.67 1.67 0 0 0-1.66 1.18c-.14.36-.21.79-.21 1.28Zm9.07 3.4c-.63 0-1.17-.13-1.63-.41a2.8 2.8 0 0 1-1.05-1.18c-.25-.5-.37-1.1-.37-1.76 0-.67.12-1.26.37-1.77a2.77 2.77 0 0 1 2.58-1.64c.34 0 .68.06 1 .17.34.11.64.3.92.55.27.26.49.6.65 1 .16.43.24.94.24 1.55v.43h-5.04v-.87h4.02c0-.37-.07-.7-.22-.99a1.66 1.66 0 0 0-1.57-.94c-.4 0-.75.1-1.04.3-.29.2-.51.45-.67.77-.16.31-.23.65-.23 1.01v.58c0 .5.08.92.25 1.26.18.34.42.6.72.78.3.17.66.26 1.07.26.27 0 .5-.03.72-.1.21-.09.4-.2.56-.35.15-.15.27-.34.36-.57l.97.27c-.1.33-.28.62-.52.87s-.54.44-.9.58c-.35.14-.75.2-1.19.2Zm4.24-.13v-6.54h.97v.98h.07c.12-.32.34-.58.65-.79.31-.2.66-.3 1.06-.3a10.86 10.86 0 0 1 .52.02v1.02a3.3 3.3 0 0 0-.6-.07c-.33 0-.61.07-.86.2s-.45.32-.59.55c-.14.23-.21.5-.21.79V652h-1Zm8.1 0 3.9-7.72v-.07h-4.5v-.94h5.6v1l-3.9 7.73h-1.1Z"
      />
      <path
        fill="#14141F"
        d="M281.43 674h-1.24a2.56 2.56 0 0 0-1.04-1.61 2.77 2.77 0 0 0-.85-.42 3.39 3.39 0 0 0-2.65.33c-.5.31-.89.77-1.18 1.38-.3.6-.44 1.35-.44 2.23 0 .88.14 1.63.44 2.23.3.6.69 1.07 1.18 1.38.5.31 1.06.47 1.68.47.34 0 .66-.05.97-.14.32-.1.6-.23.85-.42a2.62 2.62 0 0 0 1.04-1.61h1.24c-.1.52-.27.98-.51 1.4a3.8 3.8 0 0 1-2.14 1.7c-.45.15-.94.22-1.45.22-.87 0-1.64-.21-2.32-.64a4.37 4.37 0 0 1-1.6-1.8 6.2 6.2 0 0 1-.58-2.8c0-1.06.2-2 .59-2.77a4.27 4.27 0 0 1 3.91-2.45c.51 0 1 .07 1.45.22a3.95 3.95 0 0 1 2.14 1.7c.24.41.41.88.5 1.4Zm4.93 7.16c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.05 1.22-1.38.52-.33 1.12-.5 1.81-.5a3.3 3.3 0 0 1 3.02 1.87c.3.6.44 1.3.44 2.1 0 .78-.14 1.47-.44 2.06-.28.59-.69 1.05-1.2 1.38a3.3 3.3 0 0 1-1.82.49Zm0-1.05c.52 0 .96-.14 1.3-.4.33-.28.58-.63.74-1.07a4.1 4.1 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4c-.33.28-.58.63-.74 1.07a4.1 4.1 0 0 0-.25 1.43c0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm6.43-3.7V681h-1.18v-7.64h1.14v1.2h.1c.17-.4.45-.7.81-.94.37-.24.84-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.69.53.9.96.22.42.33.96.33 1.6V681h-1.18v-4.77c0-.6-.15-1.07-.46-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.41-3.05v1h-4.11v-1h4.11Zm-2.88 7.64v-8.69c0-.44.1-.8.3-1.1.21-.29.48-.5.8-.65a2.9 2.9 0 0 1 2.15-.02l-.33 1.01a6 6 0 0 0-.25-.07c-.1-.03-.23-.05-.4-.05-.4 0-.67.1-.84.3-.17.2-.26.48-.26.86V681h-1.17Zm7.42.16a3.6 3.6 0 0 1-1.91-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07.3-.6.7-1.06 1.2-1.4a3.61 3.61 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5H305v-1.01h4.7c0-.44-.1-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.88.12-1.22.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm4.94-.16v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.37-.24.78-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.51 3.51 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.71 1.71 0 0 0-.93 1.56V681h-1.17Zm8.18.16a3.6 3.6 0 0 1-1.9-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.32 1.25.32.3 0 .59-.05.83-.13.26-.1.47-.23.66-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm6.12-4.75V681h-1.17v-7.64h1.13v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.42-.36.51 0 .97.11 1.35.32.4.21.7.53.9.96.22.42.33.96.33 1.6V681h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.12 4.75a3.3 3.3 0 0 1-1.85-.5c-.52-.35-.92-.81-1.2-1.4a4.74 4.74 0 0 1-.41-2.04c0-.77.14-1.46.43-2.05a3.24 3.24 0 0 1 3.01-1.9c.54 0 1.02.1 1.45.3a2.6 2.6 0 0 1 1.57 2.09h-1.17a1.78 1.78 0 0 0-1.83-1.33c-.46-.01-.86.1-1.2.35-.35.23-.61.57-.8 1-.2.42-.29.93-.29 1.5 0 .6.1 1.1.28 1.54.19.44.45.78.8 1.02.34.24.74.37 1.2.37.31 0 .59-.06.84-.16a1.71 1.71 0 0 0 1-1.18h1.17a2.72 2.72 0 0 1-1.52 2.08c-.43.2-.92.3-1.48.3Zm7.92 0a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.94 2.94 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.89v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13.25-.1.47-.23.65-.4.19-.18.33-.4.43-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm10.9-.16-2.8-10.18h1.26l2.13 8.3h.1l2.16-8.3h1.4l2.16 8.3h.1l2.13-8.3h1.25L363.03 681h-1.27l-2.25-8.11h-.08l-2.25 8.11h-1.27Zm13.76.16a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.41.16-.88.24-1.4.24Zm8.15 0a3.28 3.28 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.78.32 1.25.32.3 0 .59-.05.84-.13.25-.1.46-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.04.68c-.42.16-.88.24-1.4.24Zm6.04-2.94-.02-1.46h.24l3.34-3.4h1.45l-3.56 3.6h-.1l-1.35 1.26Zm-1.1 2.78v-10.18h1.18V681h-1.17Zm4.86 0-2.98-3.78.83-.81 3.64 4.59h-1.5Z"
      />
    </g>
    <g clipPath="url(#clip6_1_3812)">
      <rect width={608} height={472} x={536} y={240} fill="#fff" rx={8} />
      <path fill="#EDF2F7" d="M536 240h608v56H536z" />
      <path
        stroke="#6C7793"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth={1.33}
        d="M568.67 262h-9.34c-.73 0-1.33.6-1.33 1.33v9.34c0 .73.6 1.33 1.33 1.33h9.34c.73 0 1.33-.6 1.33-1.33v-9.34c0-.73-.6-1.33-1.33-1.33ZM562 265.33h4.67M561.33 268h4M563.33 270.67h3.34"
      />
      <path
        fill="#14141F"
        d="M585.12 273v-10.18h1.53v8.86h4.62V273h-6.15Zm10 .17c-.48 0-.92-.09-1.3-.27a2.2 2.2 0 0 1-.94-.79 2.26 2.26 0 0 1-.34-1.27c0-.43.09-.78.25-1.06.17-.28.4-.5.67-.66.28-.17.6-.29.95-.37.35-.08.7-.15 1.06-.19l1.12-.13c.28-.04.49-.1.62-.17.13-.08.2-.21.2-.4v-.03c0-.43-.13-.77-.38-1-.24-.24-.6-.36-1.08-.36-.5 0-.9.1-1.18.33a1.8 1.8 0 0 0-.6.73l-1.4-.32a2.7 2.7 0 0 1 1.84-1.75 4.31 4.31 0 0 1 2.29-.09c.34.07.67.2.96.4.3.18.55.45.74.8.2.35.3.8.3 1.36V273h-1.46v-1.04h-.06c-.1.19-.24.38-.43.56-.2.19-.44.34-.74.47-.3.12-.67.18-1.09.18Zm.33-1.2c.4 0 .76-.08 1.05-.24a1.7 1.7 0 0 0 .9-1.48v-.99a.78.78 0 0 1-.3.15c-.15.04-.32.08-.51.11l-.57.09-.45.06c-.3.03-.56.1-.8.18-.23.09-.42.21-.56.38a.93.93 0 0 0-.21.63c0 .37.14.65.4.84.28.18.63.28 1.05.28Zm8.99-6.6v1.19h-4.17v-1.2h4.17Zm-3.06-1.84h1.5v7.23c0 .29.03.5.12.65.09.14.2.24.33.3a1.7 1.7 0 0 0 .77.05l.2-.05.28 1.23c-.09.03-.21.07-.37.1a2.92 2.92 0 0 1-1.7-.15 1.87 1.87 0 0 1-.81-.68c-.21-.3-.32-.68-.32-1.14v-7.54Zm7.91 9.62c-.75 0-1.4-.16-1.94-.48a3.27 3.27 0 0 1-1.26-1.37 4.62 4.62 0 0 1-.43-2.07c0-.78.14-1.47.43-2.07.3-.6.71-1.06 1.24-1.4a3.73 3.73 0 0 1 3.11-.29 3.05 3.05 0 0 1 1.85 1.87c.18.48.28 1.07.28 1.76v.53h-6.07v-1.11h4.61c0-.4-.08-.74-.24-1.04a1.8 1.8 0 0 0-1.67-.99c-.42 0-.79.1-1.1.31-.3.2-.55.47-.71.8a2.3 2.3 0 0 0-.25 1.05v.88c0 .5.09.94.27 1.3.18.36.43.63.76.82.32.18.7.28 1.13.28.29 0 .54-.04.78-.12a1.59 1.59 0 0 0 .99-.97l1.4.25c-.11.42-.31.78-.6 1.09-.3.3-.66.55-1.1.72-.43.17-.92.25-1.48.25Zm10.65-5.92-1.35.24a1.6 1.6 0 0 0-.27-.5 1.33 1.33 0 0 0-.49-.38c-.2-.1-.46-.15-.76-.15-.43 0-.78.1-1.06.29-.28.18-.42.42-.42.72 0 .25.1.46.28.61.2.16.5.29.92.39l1.2.27c.71.17 1.24.42 1.58.75.34.34.52.78.52 1.32a2 2 0 0 1-.4 1.23 2.6 2.6 0 0 1-1.1.83c-.47.2-1 .3-1.63.3-.85 0-1.55-.18-2.09-.54a2.31 2.31 0 0 1-1-1.57l1.45-.22c.08.38.27.66.55.85.27.2.64.29 1.09.29.48 0 .87-.1 1.16-.3.3-.21.44-.46.44-.76a.78.78 0 0 0-.27-.6 1.76 1.76 0 0 0-.8-.37l-1.3-.28a3.1 3.1 0 0 1-1.58-.78c-.34-.35-.5-.8-.5-1.34 0-.45.12-.85.37-1.19.25-.33.6-.6 1.04-.79.45-.19.96-.29 1.53-.29.83 0 1.48.18 1.95.54.47.36.79.83.94 1.43Zm5.35-1.87v1.2h-4.17v-1.2h4.17Zm-3.06-1.83h1.5v7.23c0 .29.03.5.12.65.09.14.2.24.33.3a1.7 1.7 0 0 0 .77.05l.2-.05.28 1.23c-.09.03-.21.07-.37.1a2.93 2.93 0 0 1-1.7-.15 1.88 1.88 0 0 1-.81-.68c-.21-.3-.32-.68-.32-1.14v-7.54Zm10.63 9.64c-.49 0-.92-.09-1.31-.27-.4-.18-.7-.44-.93-.79a2.27 2.27 0 0 1-.34-1.27c0-.43.08-.78.25-1.06.16-.28.39-.5.67-.66.28-.17.6-.29.94-.37.35-.08.7-.15 1.07-.19l1.11-.13c.28-.04.5-.1.62-.17.13-.08.2-.21.2-.4v-.03c0-.43-.13-.77-.37-1-.25-.24-.6-.36-1.09-.36-.5 0-.9.1-1.18.33-.28.22-.48.46-.6.73l-1.39-.32a2.68 2.68 0 0 1 1.84-1.75 4.32 4.32 0 0 1 2.28-.09c.35.07.67.2.97.4.3.18.55.45.74.8.2.35.29.8.29 1.36V273h-1.46v-1.04h-.05a2.3 2.3 0 0 1-1.17 1.03c-.3.12-.67.18-1.1.18Zm.32-1.2c.41 0 .76-.08 1.06-.24a1.7 1.7 0 0 0 .9-1.48v-.99a.78.78 0 0 1-.3.15l-.52.11-.56.09-.46.06c-.29.03-.55.1-.79.18-.24.09-.42.21-.57.38a.93.93 0 0 0-.2.63c0 .37.13.65.4.84.27.18.62.28 1.04.28Zm8.64 1.18c-.74 0-1.37-.16-1.9-.5-.54-.34-.94-.8-1.23-1.4a4.65 4.65 0 0 1-.43-2.03c0-.78.15-1.46.44-2.06.3-.6.7-1.06 1.23-1.4.53-.33 1.16-.5 1.88-.5.58 0 1.1.11 1.55.33a2.7 2.7 0 0 1 1.6 2.24h-1.45a1.74 1.74 0 0 0-.54-.93 1.61 1.61 0 0 0-1.14-.38c-.41 0-.77.1-1.09.33-.3.21-.54.52-.72.92-.17.4-.25.87-.25 1.41 0 .56.08 1.04.25 1.44.17.4.4.72.72.94.3.23.67.34 1.1.34.27 0 .53-.05.76-.16.23-.1.42-.25.58-.45.16-.2.27-.43.33-.7h1.45a2.8 2.8 0 0 1-1.56 2.23 3.5 3.5 0 0 1-1.58.33Zm8.3-7.79v1.2h-4.18v-1.2h4.17Zm-3.06-1.83h1.49v7.23c0 .29.04.5.13.65.08.14.2.24.33.3a1.7 1.7 0 0 0 .77.05l.2-.05.27 1.23a2.93 2.93 0 0 1-2.06-.05 1.88 1.88 0 0 1-.81-.68c-.21-.3-.32-.68-.32-1.14v-7.54Zm4.7 9.47v-7.64h1.49V273h-1.5Zm.75-8.81a.94.94 0 0 1-.67-.26.84.84 0 0 1-.27-.63c0-.25.1-.45.27-.63.19-.17.41-.26.67-.26.26 0 .48.09.66.26.19.18.28.38.28.63 0 .24-.1.45-.28.63a.93.93 0 0 1-.66.25Zm9.27 1.17L659 273h-1.6l-2.77-7.64h1.6l1.93 5.88h.08l1.93-5.88h1.6Zm1.4 7.64v-7.64h1.48V273h-1.49Zm.75-8.81a.94.94 0 0 1-.67-.26.84.84 0 0 1-.27-.63c0-.25.09-.45.27-.63.19-.17.4-.26.67-.26.25 0 .48.09.66.26.18.18.27.38.27.63 0 .24-.09.45-.27.63a.93.93 0 0 1-.66.25Zm6.3 1.17v1.2h-4.18v-1.2h4.18Zm-3.06-1.83h1.49v7.23c0 .29.04.5.13.65.09.14.2.24.33.3a1.7 1.7 0 0 0 .77.05l.2-.05.27 1.23a2.92 2.92 0 0 1-2.06-.05 1.87 1.87 0 0 1-.81-.68c-.21-.3-.32-.68-.32-1.14v-7.54Zm4.7 9.47v-7.64h1.49V273h-1.49Zm.75-8.81a.95.95 0 0 1-.66-.26.84.84 0 0 1-.28-.63.93.93 0 0 1 .94-.89c.26 0 .48.09.66.26.19.18.28.38.28.63a.93.93 0 0 1-.94.88Zm6.03 8.96c-.75 0-1.4-.16-1.95-.48a3.28 3.28 0 0 1-1.25-1.37 4.63 4.63 0 0 1-.44-2.07c0-.78.15-1.47.44-2.07.3-.6.7-1.06 1.23-1.4a3.73 3.73 0 0 1 3.11-.29 3.03 3.03 0 0 1 1.86 1.87c.18.48.27 1.07.27 1.76v.53h-6.07v-1.11h4.62c0-.4-.08-.74-.24-1.04a1.8 1.8 0 0 0-1.68-.99c-.41 0-.78.1-1.09.31-.3.2-.55.47-.72.8a2.3 2.3 0 0 0-.25 1.05v.88c0 .5.1.94.27 1.3.19.36.44.63.76.82.33.18.7.28 1.14.28.29 0 .54-.04.77-.12a1.6 1.6 0 0 0 .99-.97l1.41.25c-.11.42-.32.78-.6 1.09-.3.3-.66.55-1.1.72-.43.17-.92.25-1.48.25Zm10.65-5.92-1.35.24a1.6 1.6 0 0 0-.27-.5 1.33 1.33 0 0 0-.49-.38c-.2-.1-.46-.15-.77-.15-.42 0-.77.1-1.05.29-.28.18-.42.42-.42.72 0 .25.09.46.28.61.19.16.5.29.91.39l1.22.27c.7.17 1.22.42 1.57.75.34.34.52.78.52 1.32a2 2 0 0 1-.4 1.23c-.26.35-.63.63-1.1.83-.47.2-1.01.3-1.63.3-.85 0-1.55-.18-2.09-.54a2.32 2.32 0 0 1-1-1.57l1.44-.22c.1.38.28.66.55.85.28.2.64.29 1.1.29.48 0 .87-.1 1.16-.3.3-.21.44-.46.44-.76a.78.78 0 0 0-.27-.6 1.75 1.75 0 0 0-.81-.37l-1.3-.28a3.11 3.11 0 0 1-1.57-.78c-.34-.35-.51-.8-.51-1.34 0-.45.13-.85.38-1.19.25-.33.6-.6 1.04-.79.45-.19.95-.29 1.53-.29.82 0 1.47.18 1.95.54.47.36.78.83.94 1.43Z"
      />
      <circle cx={584} cy={344} r={24} fill="url(#pattern1)" />
      <path
        fill="#6C7793"
        d="M627.63 332.12a3 3 0 0 1-1.35-.3 2.5 2.5 0 0 1-.96-.82 2.23 2.23 0 0 1-.4-1.18h1.02c.04.4.22.72.54.98.32.25.7.38 1.15.38a1.8 1.8 0 0 0 1.62-.94c.16-.3.24-.63.24-1 0-.38-.09-.72-.25-1.02a1.84 1.84 0 0 0-1.68-.98 2.73 2.73 0 0 0-1.51.45l-1-.12.54-4.3h4.53v.94h-3.65l-.3 2.57h.05a2.57 2.57 0 0 1 1.52-.5 2.69 2.69 0 0 1 2.4 1.43c.25.44.37.95.37 1.51s-.12 1.06-.37 1.5a2.74 2.74 0 0 1-2.5 1.4Zm7.97-.12v-6.55h.97v1.03h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.08.3.29.2.51.47.67.82h.07c.17-.34.42-.6.76-.8.33-.21.73-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V332h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V332h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.51.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V332h-1.01Zm10.43 0v-6.55h1V332h-1Zm.5-7.64a.71.71 0 0 1-.5-.2.64.64 0 0 1-.2-.48c0-.19.06-.35.2-.48s.31-.2.5-.2c.2 0 .37.07.51.2s.21.3.21.48c0 .19-.07.35-.21.48a.7.7 0 0 1-.5.2Zm3.35 3.7V332h-1v-6.55h.97v1.03h.08c.15-.34.39-.6.7-.8.31-.2.72-.31 1.2-.31.45 0 .84.09 1.17.27.34.18.6.45.78.82.18.36.27.82.27 1.38V332h-1v-4.1c0-.5-.13-.9-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.86.21-.25.14-.45.34-.6.61-.14.27-.21.6-.21.97Zm10.14 1.26v-3.87h1V332h-1v-1.1h-.07a2.07 2.07 0 0 1-1.94 1.2c-.41-.02-.78-.1-1.1-.28a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.28-1.39v-4.16h1v4.1c0 .47.14.85.4 1.14.28.28.62.42 1.04.42.25 0 .5-.06.76-.19a1.66 1.66 0 0 0 .93-1.6Zm5.7-3.87v.86h-3.4v-.86h3.4Zm-2.41-1.56h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.29a1.83 1.83 0 0 0 .7.05l.17-.04.2.9a2.25 2.25 0 0 1-.75.13c-.28 0-.56-.07-.83-.19-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm6.59 8.25a2.81 2.81 0 0 1-2.68-1.6c-.25-.5-.37-1.1-.37-1.76 0-.67.12-1.26.36-1.77a2.77 2.77 0 0 1 2.58-1.64c.35 0 .68.06 1.02.17.33.11.63.3.9.55.28.26.5.6.66 1 .16.43.24.94.24 1.55v.43h-5.05v-.87h4.03c0-.37-.08-.7-.23-.99a1.67 1.67 0 0 0-1.56-.94c-.4 0-.75.1-1.04.3-.3.2-.52.45-.67.77-.16.31-.24.65-.24 1.01v.58c0 .5.09.92.26 1.26.17.34.41.6.72.78.3.17.66.26 1.07.26.26 0 .5-.03.72-.1a1.55 1.55 0 0 0 .92-.91l.97.26c-.1.33-.28.62-.52.87a2.5 2.5 0 0 1-.9.58c-.35.14-.75.2-1.2.2Zm8.88-5.22-.9.26c-.06-.15-.15-.3-.26-.44-.1-.15-.25-.27-.44-.36-.19-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.1.45.27.6.18.14.47.26.85.36l.98.23c.58.15 1.02.36 1.3.66.3.29.43.66.43 1.12 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.93 1.93 0 0 1-.83-1.27l.95-.24c.1.36.27.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.28-.2.41-.44.41-.72a.76.76 0 0 0-.23-.57c-.16-.16-.4-.28-.74-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.32-.98.2-.28.5-.5.85-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.43.38.28.64.65.8 1.12Zm6.93 5.23c-.42 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.8-.3.31-.07.61-.12.92-.16l.96-.12c.25-.03.44-.07.55-.14.12-.06.17-.18.17-.34v-.04c0-.41-.11-.74-.34-.97-.23-.24-.57-.35-1.04-.35-.48 0-.85.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.15.8.3s.47.38.64.7c.17.3.26.72.26 1.24V332h-1v-.89h-.06c-.06.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.59.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a20.74 20.74 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.07-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm7.33 3.34c-.49 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.1.11.2.25.35.4.14.16.33.3.57.41.24.12.56.18.96.18.53 0 .96-.13 1.3-.39.35-.25.52-.65.52-1.2v-1.33h-.08c-.08.12-.18.27-.32.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.01.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.36-1.74c0-.67.12-1.25.35-1.75a2.6 2.6 0 0 1 2.44-1.57c.43 0 .77.07 1.02.21.25.14.44.3.58.48l.31.43h.1v-1.04h.98v6.74c0 .56-.13 1.02-.39 1.37-.25.36-.59.62-1.02.78-.43.17-.9.25-1.42.25Zm-.04-3.6c.4 0 .75-.09 1.03-.27.28-.19.49-.45.63-.8.15-.35.22-.76.22-1.24s-.07-.9-.21-1.25a1.87 1.87 0 0 0-.64-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.07.86.2 1.21.15.35.37.62.65.82.28.2.63.3 1.05.3Zm7.37 1.15c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.44.28.8.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.45.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.06 2.06 0 0 0-.64-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.11.35-.3.24-.5.54-.64.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Z"
      />
      <path
        fill="#14141F"
        d="M633.72 354.25h-1.86a2.33 2.33 0 0 0-.83-1.41 2.21 2.21 0 0 0-.72-.38 2.84 2.84 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.67 4.67 0 0 0-.37 1.95c0 .78.12 1.43.36 1.97.25.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.27-.94c.15-.24.25-.5.31-.8h1.86a3.99 3.99 0 0 1-1.35 2.5c-.37.32-.8.57-1.3.75-.5.18-1.05.27-1.66.27a4.35 4.35 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .6-2.81 4.38 4.38 0 0 1 4.06-2.42c.57 0 1.1.08 1.58.24.49.16.92.39 1.3.7.38.3.7.68.94 1.12.25.44.41.95.49 1.51Zm3.4 2.28V361h-1.8v-10.18h1.77v3.84h.09c.18-.43.45-.77.83-1.02.38-.25.86-.38 1.44-.38.53 0 1 .12 1.39.34.4.22.7.54.91.97.22.43.33.95.33 1.57V361h-1.8v-4.58c0-.52-.13-.92-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.06-.86.2-.24.14-.44.34-.58.6-.14.25-.21.57-.21.94Zm10.18 4.62c-.77 0-1.43-.16-1.99-.48a3.24 3.24 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.44-2.08c0-.79.15-1.48.44-2.07a3.4 3.4 0 0 1 3.17-1.9c.47 0 .92.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.62 1.62 0 0 0-.6-.64 1.72 1.72 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.82.25 1.14.16.32.38.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.33.16-.15.28-.33.36-.55l1.68.2c-.1.44-.31.82-.61 1.16-.3.32-.67.58-1.13.76-.46.18-1 .27-1.58.27Zm5.81 2.71a3.61 3.61 0 0 1-1.17-.19l.42-1.4c.26.08.5.12.7.11.2 0 .39-.07.54-.2.16-.11.3-.32.4-.6l.16-.42-2.77-7.8h1.9l1.77 5.77h.08l1.76-5.77h1.92l-3.06 8.56c-.14.4-.33.75-.57 1.04-.23.3-.52.52-.86.67-.34.16-.75.23-1.22.23Zm10.07-2.71c-.76 0-1.42-.16-1.98-.48a3.23 3.23 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.4 3.4 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23.42.15.8.38 1.11.7.33.31.58.71.77 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.08-.66-.22-.93a1.63 1.63 0 0 0-1.52-.87c-.37 0-.69.09-.97.26-.27.18-.5.41-.65.7-.15.29-.23.6-.23.94v1.06c0 .44.08.82.24 1.14.16.32.4.56.68.73.3.16.64.25 1.03.25.26 0 .5-.04.7-.11a1.4 1.4 0 0 0 .9-.88l1.7.2c-.11.44-.31.82-.61 1.16-.3.32-.68.58-1.14.76-.46.18-.98.27-1.58.27Zm6.72-4.62V361h-1.8v-7.64h1.72v1.3h.09c.18-.43.46-.77.84-1.02.39-.25.87-.38 1.44-.38.52 0 .98.12 1.37.34.4.23.7.55.92.98.22.43.33.95.32 1.56V361H673v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.08-.43c-.32 0-.6.06-.84.2-.25.14-.44.34-.58.6a2 2 0 0 0-.2.94Zm8.53 0V361h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.39-.25.87-.38 1.44-.38.52 0 .98.12 1.38.34.39.23.7.55.91.98.22.43.33.95.32 1.56V361h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.08-.43c-.32 0-.6.06-.84.2-.25.14-.44.34-.58.6a2 2 0 0 0-.2.94Zm10.11 4.62c-.76 0-1.42-.16-1.98-.48a3.25 3.25 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.44-2.08c0-.79.14-1.48.44-2.07a3.4 3.4 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.07-.66-.22-.93a1.62 1.62 0 0 0-.61-.64 1.72 1.72 0 0 0-.9-.23c-.37 0-.7.09-.98.26-.27.18-.5.41-.65.7a2 2 0 0 0-.23.94v1.06c0 .44.08.82.24 1.14.17.32.4.56.68.73.3.16.64.25 1.03.25.26 0 .5-.04.7-.11.22-.08.4-.19.56-.33.16-.15.27-.33.35-.55l1.69.2c-.11.44-.31.82-.61 1.16-.3.32-.67.58-1.13.76-.47.18-1 .27-1.59.27Zm8.47-.15v-10.18h1.85v4.68h.12l3.98-4.68h2.25l-3.94 4.57 3.97 5.61h-2.22l-3.03-4.37-1.13 1.34V361H697Zm12.22.15c-.77 0-1.43-.16-1.98-.48a3.23 3.23 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.38 3.38 0 0 1 3.16-1.9c.48 0 .92.08 1.34.23.42.15.79.38 1.11.7.33.31.58.71.77 1.2.18.49.27 1.06.27 1.73v.55h-6.25v-1.2h4.53c0-.35-.08-.66-.22-.93a1.63 1.63 0 0 0-.62-.64 1.71 1.71 0 0 0-.9-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.09.82.25 1.14.16.32.39.56.68.73.3.16.63.25 1.02.25.27 0 .5-.04.72-.11.2-.08.4-.19.55-.33.15-.15.27-.33.35-.55l1.68.2c-.1.44-.3.82-.6 1.16-.3.32-.68.58-1.14.76-.46.18-.99.27-1.58.27Zm6.72-4.62V361h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.38-.25.86-.38 1.43-.38.53 0 .99.12 1.38.34.4.23.7.55.92.98.22.43.32.95.32 1.56V361h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.06-.84.2s-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.54-3.17v1.4h-4.39v-1.4h4.4Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.72 1.72 0 0 0 .53-.07l.3 1.4a3.83 3.83 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.3-1.2v-7.47Zm8.1 9.62c-.76 0-1.42-.16-1.98-.48a3.24 3.24 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.44-2.08c0-.79.15-1.48.44-2.07a3.4 3.4 0 0 1 3.17-1.9c.47 0 .92.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.62 1.62 0 0 0-.6-.64 1.72 1.72 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.82.25 1.14.16.32.38.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.33.16-.15.28-.33.36-.55l1.68.2c-.1.44-.31.82-.61 1.16-.3.32-.67.58-1.13.76-.46.18-1 .27-1.58.27Zm4.92-.15v-7.64h1.75v1.28h.08a1.91 1.91 0 0 1 1.88-1.39 4.15 4.15 0 0 1 .65.05v1.66a3.37 3.37 0 0 0-.83-.1c-.33 0-.63.07-.9.2a1.56 1.56 0 0 0-.83 1.45V361h-1.8Z"
      />
      <path
        fill="#474E6B"
        d="M746.07 361v-7.64h1.14v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.27-.35.5 0 .93.12 1.26.35.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.86-.36 1.41-.36.68 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V361h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.25.49-.3.32-.44.73-.44 1.22V361h-1.2v-5.23c0-.43-.13-.78-.41-1.05-.29-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V361h-1.18Zm15.27.16c-.69 0-1.29-.17-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.06 1.2-1.38.53-.33 1.13-.5 1.82-.5.7 0 1.3.17 1.81.5.52.32.93.79 1.22 1.38.29.6.43 1.29.43 2.08s-.14 1.48-.43 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.06c.53 0 .96-.13 1.3-.4.34-.27.59-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07c-.16.45-.24.92-.24 1.43 0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm11.23-6.74-2.83 7.64h-1.2l-2.81-7.64H767l2.1 6.09h.09l2.1-6.09h1.28Zm4.47 7.8a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.9v-1.01h4.7c0-.44-.08-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.22-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.64.52-1.05.68-.41.16-.88.24-1.4.24Zm7.83 0a3 3 0 0 1-2.83-1.86c-.27-.59-.4-1.29-.4-2.1 0-.8.13-1.5.4-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.17.51.35.67.56l.36.5h.1v-3.75h1.17V361h-1.13v-1.17h-.14c-.09.14-.2.31-.37.52-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.2-.36.32-.25.57-.6.74-1.03.16-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.25.91-.25 1.45 0 .55.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Z"
      />
      <path
        fill="#14141F"
        d="M803.72 354.25h-1.86a2.33 2.33 0 0 0-.83-1.41 2.21 2.21 0 0 0-.72-.38 2.84 2.84 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.67 4.67 0 0 0-.37 1.95c0 .78.12 1.43.36 1.97.25.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.27-.94c.15-.24.25-.5.31-.8h1.86a3.99 3.99 0 0 1-1.35 2.5c-.37.32-.8.57-1.3.75-.5.18-1.05.27-1.66.27a4.35 4.35 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .6-2.81 4.38 4.38 0 0 1 4.06-2.42c.57 0 1.1.08 1.58.24.49.16.92.39 1.3.7.38.3.7.68.94 1.12.25.44.41.95.49 1.51Zm3.4-3.43V361h-1.8v-10.18h1.8Zm5.19 10.33a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.52 4.52 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.73-1.06 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.32.97.79 1.27 1.38.3.6.45 1.28.45 2.07 0 .79-.15 1.48-.45 2.07a3.3 3.3 0 0 1-1.27 1.38c-.55.32-1.2.49-1.94.49Zm.01-1.44c.4 0 .74-.11 1.01-.34.28-.22.48-.52.61-.9.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2.01 2.01 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.62.34 1.03.34Zm10.04-1.92v-4.43h1.8V361h-1.74v-1.36h-.08a2.3 2.3 0 0 1-.85 1.05c-.4.27-.87.4-1.45.4-.5 0-.94-.1-1.32-.32a2.32 2.32 0 0 1-.9-.98 3.47 3.47 0 0 1-.32-1.56v-4.87h1.8v4.59c0 .48.13.87.4 1.15.26.29.6.43 1.04.43.26 0 .52-.07.77-.2s.45-.32.61-.57c.16-.26.24-.58.24-.97Zm6.49 3.34a2.89 2.89 0 0 1-2.74-1.8 5.01 5.01 0 0 1-.4-2.14c0-.85.13-1.56.4-2.15.3-.58.67-1.03 1.15-1.32a2.93 2.93 0 0 1 2.7-.23c.28.15.51.33.68.55.17.2.3.4.4.59h.07v-3.81h1.8V361h-1.76v-1.2h-.11c-.1.18-.23.38-.4.59a2.2 2.2 0 0 1-1.8.74Zm.5-1.47c.38 0 .7-.1.98-.31.26-.2.47-.5.6-.87.15-.37.22-.8.22-1.3s-.07-.92-.21-1.29a1.83 1.83 0 0 0-.61-.85c-.26-.2-.6-.3-.98-.3-.4 0-.74.1-1 .31-.27.21-.47.5-.61.87s-.2.79-.2 1.26c0 .48.06.9.2 1.28a2 2 0 0 0 .61.88c.27.21.6.32 1 .32Zm9.03 1.34v-10.18h6.53v1.54h-4.68v2.77h4.23v1.55h-4.23V361h-1.85Zm12.52-3.21v-4.43h1.8V361h-1.75v-1.36h-.08a2.3 2.3 0 0 1-.85 1.05c-.39.27-.87.4-1.44.4-.5 0-.95-.1-1.33-.32a2.32 2.32 0 0 1-.9-.98 3.47 3.47 0 0 1-.32-1.56v-4.87h1.8v4.59c0 .48.13.87.4 1.15.26.29.61.43 1.04.43a1.65 1.65 0 0 0 1.38-.77c.17-.26.25-.58.25-.97Zm5.45-1.26V361h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.38-.25.86-.38 1.43-.38.53 0 .99.12 1.38.34.4.23.7.55.92.98.22.43.32.95.32 1.56V361h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.06-.84.2s-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.06 4.62a3.36 3.36 0 0 1-3.22-1.89 4.6 4.6 0 0 1-.44-2.05c0-.77.15-1.46.45-2.05a3.36 3.36 0 0 1 3.2-1.9c.62 0 1.17.12 1.65.35a2.81 2.81 0 0 1 1.63 2.4h-1.72a1.64 1.64 0 0 0-.5-.92c-.25-.25-.6-.37-1.04-.37-.36 0-.69.1-.96.3-.28.19-.5.47-.66.84-.15.37-.22.8-.22 1.32s.07.97.22 1.34c.16.38.37.66.65.86.27.2.6.3.97.3.27 0 .5-.05.72-.15.2-.1.38-.25.53-.44.14-.2.24-.42.3-.7h1.71a2.83 2.83 0 0 1-1.6 2.41c-.47.23-1.03.35-1.67.35Zm8.56-7.79v1.4h-4.39v-1.4h4.4Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.7 1.7 0 0 0 .53-.07l.3 1.4a3.9 3.9 0 0 1-1.06.18c-.45.02-.85-.05-1.21-.2a1.9 1.9 0 0 1-.87-.7c-.2-.32-.3-.72-.3-1.2v-7.47Zm4.8 9.47v-7.64h1.8V361h-1.8Zm.91-8.72c-.28 0-.53-.1-.73-.28a.91.91 0 0 1-.31-.7c0-.27.1-.5.3-.69.21-.19.46-.28.74-.28.3 0 .54.1.74.28.2.2.3.42.3.7 0 .26-.1.5-.3.69-.2.19-.45.28-.74.28Zm6.08 8.87a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.06 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.32.97.79 1.26 1.38.3.6.46 1.28.46 2.07 0 .79-.15 1.48-.46 2.07a3.3 3.3 0 0 1-1.26 1.38c-.55.32-1.2.49-1.94.49Zm0-1.44c.41 0 .75-.11 1.02-.34a2 2 0 0 0 .6-.9c.14-.38.21-.8.21-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.42 0-.76.11-1.04.34-.27.22-.47.53-.6.9-.14.39-.2.8-.2 1.28 0 .46.06.88.2 1.26.13.38.33.68.6.9.28.23.62.34 1.04.34Zm6.99-3.18V361h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.83-1.02.4-.25.87-.38 1.44-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V361h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.06-.84.2s-.43.34-.57.6a2 2 0 0 0-.2.94Zm8.92 4.62c-.48 0-.92-.08-1.3-.25a2.14 2.14 0 0 1-.92-.78 2.27 2.27 0 0 1-.33-1.26c0-.43.08-.79.24-1.07.16-.28.37-.5.65-.68.27-.17.58-.3.93-.38.35-.09.7-.16 1.08-.2l1.09-.12c.27-.04.48-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.79.09-1.04.28-.26.2-.43.42-.52.68l-1.68-.24a2.68 2.68 0 0 1 1.77-1.87 4.77 4.77 0 0 1 2.56-.11c.37.09.7.23 1 .43.3.2.55.46.73.8.18.34.28.76.28 1.27V361h-1.73v-1.05h-.06a2.2 2.2 0 0 1-1.2 1.04 3 3 0 0 1-1.05.16Zm.47-1.32c.36 0 .68-.07.94-.21.27-.15.47-.34.61-.58.15-.24.22-.5.22-.78v-.9a.85.85 0 0 1-.29.13 12.93 12.93 0 0 1-.94.18l-.42.06c-.27.04-.5.1-.72.18-.21.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.13.58.37.75.24.17.55.25.92.25Zm7.17-9.01V361h-1.8v-10.18h1.8Zm1.86 10.18v-7.64h1.8V361h-1.8Zm.9-8.72c-.28 0-.53-.1-.74-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.21-.19.46-.28.74-.28.29 0 .53.1.74.28.2.2.3.42.3.7 0 .26-.1.5-.3.69-.2.19-.45.28-.74.28Zm6.56 1.08v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.12.05.26.07.4.07a1.72 1.72 0 0 0 .54-.07l.3 1.4a3.83 3.83 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.3-1.2v-7.47Zm5.92 12.33a3.63 3.63 0 0 1-1.17-.19l.42-1.4c.26.08.5.12.7.11.2 0 .38-.07.54-.2.16-.11.3-.32.4-.6l.16-.42-2.77-7.8h1.9l1.77 5.77h.08l1.76-5.77h1.92l-3.06 8.56c-.14.4-.33.75-.57 1.04-.23.3-.52.52-.86.67-.34.16-.75.23-1.22.23Z"
      />
      <path
        fill="#474E6B"
        d="M933.4 353.36v1h-3.96v-1h3.95Zm-2.8-1.83h1.16v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm6.8 9.65c-.48 0-.92-.1-1.31-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.05-.19l1.13-.13c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.1-.4a2.67 2.67 0 0 1 1.88-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V361h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.19-1.06c.46 0 .85-.09 1.17-.27a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.15.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.24.7c0 .41.16.72.46.93.3.2.69.3 1.16.3Zm10.87-5.05-1.06.3a1.96 1.96 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.05.81-.44.2-.96.3-1.56.3-.77 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.7.3 1.17.3.55 0 .99-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.28-.66a1.76 1.76 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.5-1.32c0-.43.13-.81.37-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Zm3 3.15-.02-1.46h.23l3.35-3.4h1.45l-3.56 3.6h-.1l-1.35 1.26Zm-1.1 2.78v-10.18h1.18V361h-1.18Zm4.86 0-2.99-3.78.84-.81 3.64 4.59h-1.5Zm10.02-7.64v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm7.58 9.63c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.06 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.32.93.79 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.06a2 2 0 0 0 1.3-.4c.33-.27.58-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.76-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07c-.16.45-.25.92-.25 1.43 0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Z"
      />
      <path
        fill="#14141F"
        d="M988.72 354.25h-1.86a2.33 2.33 0 0 0-.83-1.41 2.21 2.21 0 0 0-.72-.38 2.84 2.84 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.67 4.67 0 0 0-.37 1.95c0 .78.12 1.43.36 1.97.25.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.27-.94c.15-.24.25-.5.31-.8h1.86a3.99 3.99 0 0 1-1.35 2.5c-.37.32-.8.57-1.3.75-.5.18-1.05.27-1.66.27a4.35 4.35 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .6-2.81 4.38 4.38 0 0 1 4.06-2.42c.57 0 1.1.08 1.58.24.49.16.92.39 1.3.7.38.3.7.68.94 1.12.25.44.41.95.49 1.51Zm4.94 6.9a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.06 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.32.97.79 1.27 1.38.3.6.45 1.28.45 2.07a4.5 4.5 0 0 1-.45 2.07c-.3.59-.72 1.05-1.27 1.38-.55.32-1.2.49-1.94.49Zm.01-1.44c.4 0 .74-.11 1.01-.34a2 2 0 0 0 .61-.9c.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.62.34 1.03.34Zm5.18 1.29v-7.64h1.72v1.3h.09c.16-.44.42-.78.79-1.02.36-.25.8-.38 1.31-.38.52 0 .96.13 1.31.38a2 2 0 0 1 .76 1.02h.08c.17-.42.45-.76.85-1.01.41-.26.89-.39 1.44-.39.7 0 1.27.23 1.72.67.44.44.67 1.1.67 1.94V361h-1.81v-4.85c0-.47-.13-.82-.38-1.04a1.34 1.34 0 0 0-.92-.33c-.44 0-.78.14-1.02.4-.24.28-.36.63-.36 1.06V361h-1.77v-4.92c0-.4-.12-.71-.36-.95a1.23 1.23 0 0 0-.92-.35 1.31 1.31 0 0 0-1.21.75c-.13.24-.19.51-.19.83V361h-1.8Zm12.56 2.86v-10.5h1.77v1.27h.11c.09-.19.22-.39.39-.6.17-.2.4-.39.68-.54.29-.15.66-.23 1.11-.23.59 0 1.12.16 1.59.46.48.3.86.74 1.14 1.32.28.59.42 1.3.42 2.15a5.1 5.1 0 0 1-.41 2.14 3.15 3.15 0 0 1-1.13 1.34c-.47.31-1.01.46-1.61.46-.43 0-.8-.07-1.09-.21a2.2 2.2 0 0 1-.69-.53c-.17-.21-.31-.4-.4-.6h-.08v4.07h-1.8Zm1.77-6.68c0 .5.07.93.2 1.3a2 2 0 0 0 .62.87c.26.2.59.3.97.3.4 0 .73-.1 1-.31.27-.22.47-.5.61-.88s.21-.8.21-1.28c0-.47-.07-.9-.21-1.26a1.85 1.85 0 0 0-.61-.87c-.26-.2-.6-.3-1-.3-.38 0-.71.1-.98.3-.27.2-.47.48-.61.84-.14.37-.2.8-.2 1.3Zm8.78-6.36V361h-1.8v-10.18h1.8Zm5.23 10.33c-.76 0-1.42-.16-1.98-.48a3.21 3.21 0 0 1-1.28-1.36 4.54 4.54 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.38 3.38 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23.42.15.79.38 1.11.7.33.31.58.71.77 1.2.18.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.08-.66-.22-.93a1.66 1.66 0 0 0-1.52-.87c-.37 0-.69.09-.97.26-.28.18-.49.41-.65.7-.15.29-.23.6-.23.94v1.06c0 .44.08.82.24 1.14.16.32.39.56.68.73.29.16.64.25 1.03.25.26 0 .5-.04.71-.11.21-.08.39-.19.55-.33.16-.15.27-.33.35-.55l1.68.2c-.1.44-.31.82-.6 1.16-.3.32-.68.58-1.14.76a4.3 4.3 0 0 1-1.58.27Zm8.73-7.79v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.11.56.07.13.17.21.29.26.13.05.26.07.41.07a2.03 2.03 0 0 0 .53-.07l.3 1.4a3.35 3.35 0 0 1-1.06.18c-.45.02-.85-.05-1.21-.2a1.84 1.84 0 0 1-.86-.7 2.05 2.05 0 0 1-.31-1.2v-7.47Zm8.11 9.62c-.77 0-1.43-.16-1.99-.48a3.2 3.2 0 0 1-1.27-1.36 4.54 4.54 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.38 3.38 0 0 1 3.16-1.9c.47 0 .92.08 1.34.23.42.15.79.38 1.11.7.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54a1.97 1.97 0 0 0-.23-.93 1.6 1.6 0 0 0-.61-.64 1.72 1.72 0 0 0-.9-.23 1.78 1.78 0 0 0-1.62.96 2 2 0 0 0-.24.94v1.06c0 .44.08.82.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11a1.45 1.45 0 0 0 .91-.88l1.68.2c-.11.44-.31.82-.61 1.16-.29.32-.67.58-1.13.76-.46.18-.99.27-1.58.27Zm7.75-.02c-.6 0-1.14-.15-1.61-.46-.48-.3-.85-.75-1.13-1.34a5.1 5.1 0 0 1-.41-2.14c0-.85.14-1.56.42-2.15a2.93 2.93 0 0 1 3.84-1.55c.29.15.51.33.68.55.17.2.3.4.4.59h.07v-3.81h1.81V361h-1.77v-1.2h-.11c-.1.18-.23.38-.41.59-.17.2-.4.38-.69.53a2.4 2.4 0 0 1-1.09.21Zm.5-1.47c.38 0 .71-.1.98-.31.26-.2.47-.5.61-.87s.21-.8.21-1.3-.07-.92-.21-1.29a1.86 1.86 0 0 0-.61-.85c-.26-.2-.59-.3-.98-.3-.4 0-.73.1-1 .31s-.47.5-.61.87-.2.79-.2 1.26c0 .48.06.9.2 1.28.14.37.34.66.61.88.27.21.61.32 1 .32Z"
      />
      <path fill="url(#pattern2)" d="M1057.01 361.98h14v-14h-14v14Z" />
      <path
        fill="#474E6B"
        d="m1082.48 355.07-1.05.3a2.4 2.4 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3.99.42l1.13.27c.69.17 1.2.42 1.53.76.33.34.5.78.5 1.31 0 .44-.12.83-.38 1.18-.24.34-.59.61-1.04.81-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.2 2.2 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.69.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85a.87.87 0 0 0-.28-.66 1.74 1.74 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.89 1.89 0 0 1-.49-1.32c0-.43.13-.81.37-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.23-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.43 2.43 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.93 1.93 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.32-.27-.39-.19-.7-.46-.94-.8a2.27 2.27 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.41-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.19l1.13-.13c.29-.03.5-.09.63-.16.14-.08.21-.21.21-.4v-.04c0-.5-.14-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4c.19-.46.46-.82.79-1.08.34-.26.7-.44 1.09-.55a4.57 4.57 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V361h-1.17v-1.03h-.06a2.2 2.2 0 0 1-1.14 1.01c-.31.13-.68.2-1.13.2Zm.18-1.06c.46 0 .86-.09 1.17-.27.33-.18.57-.42.73-.7.17-.3.25-.6.25-.91v-1.08c-.05.06-.16.12-.33.17a5.78 5.78 0 0 1-1.21.21l-.49.06c-.31.04-.59.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.69.3 1.16.3Zm8.55 3.9a4.4 4.4 0 0 1-1.47-.22c-.4-.14-.74-.33-1.02-.56a3.3 3.3 0 0 1-.64-.75l.94-.66c.1.14.24.3.4.48.16.19.38.34.67.48.28.13.65.2 1.12.2.61 0 1.12-.15 1.52-.45.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.21.31-.36.52-.16.2-.39.38-.68.54-.29.15-.69.23-1.18.23a3.02 3.02 0 0 1-2.82-1.71 4.47 4.47 0 0 1-.43-2.03c0-.78.14-1.46.42-2.04a3.02 3.02 0 0 1 2.85-1.83c.49 0 .89.08 1.18.24.29.17.52.35.68.56.15.2.28.37.36.5h.12v-1.2h1.14v7.85c0 .65-.15 1.19-.45 1.6-.3.41-.69.72-1.19.9-.5.2-1.05.3-1.66.3Zm-.04-4.2c.47 0 .86-.1 1.19-.32.32-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.25-1.45a2.17 2.17 0 0 0-.73-1 1.99 1.99 0 0 0-1.2-.35 2 2 0 0 0-1.25.38c-.33.25-.57.59-.74 1.01-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.17.41.41.73.74.96.33.23.75.35 1.24.35Zm8.69 1.34a3.29 3.29 0 0 1-3.14-1.86 4.75 4.75 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07a3.22 3.22 0 0 1 3.02-1.9c.39 0 .79.06 1.17.2a2.97 2.97 0 0 1 1.82 1.82c.19.48.29 1.08.29 1.8v.49h-5.89v-1.01h4.69c0-.44-.08-.82-.25-1.16-.17-.34-.41-.6-.73-.8-.31-.2-.68-.3-1.1-.3-.47 0-.88.12-1.22.36a2.42 2.42 0 0 0-1.05 2.07v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12a1.72 1.72 0 0 0 1.07-1.06l1.14.31c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.05.68-.41.16-.88.24-1.39.24Zm5.8-.08a.84.84 0 0 1-.63-.26.85.85 0 0 1-.27-.63c0-.25.09-.46.27-.64a.84.84 0 0 1 .63-.26.88.88 0 0 1 .89.9c0 .16-.04.3-.12.44a.98.98 0 0 1-.32.33.9.9 0 0 1-.45.12Z"
      />
      <path
        fill="#DEE5ED"
        d="M1120 383H560v2h560v-2Z"
        mask="url(#path-114-inside-5_1_3812)"
      />
      <rect
        width={48}
        height={48}
        x={560}
        y={400}
        fill="url(#pattern3)"
        rx={4}
      />
      <path
        fill="#6C7793"
        d="M627.85 412.12c-.56 0-1.06-.1-1.5-.29-.44-.2-.79-.46-1.05-.8-.25-.35-.4-.75-.41-1.21h1.07c.02.28.12.52.29.73.17.2.4.35.67.47.28.1.58.16.92.16.37 0 .7-.06 1-.2.28-.13.5-.3.67-.54.17-.23.25-.5.25-.8 0-.33-.08-.61-.24-.86-.16-.24-.39-.44-.7-.58-.3-.14-.68-.2-1.12-.2h-.7v-.94h.7c.34 0 .65-.07.91-.2.26-.12.47-.3.62-.52.15-.23.23-.5.23-.8 0-.3-.07-.55-.2-.77a1.35 1.35 0 0 0-.55-.51 2.2 2.2 0 0 0-1.69-.02c-.27.1-.48.27-.65.47-.17.2-.26.46-.27.75h-1.03c.02-.46.16-.86.42-1.2.26-.35.6-.62 1.01-.82a3.28 3.28 0 0 1 2.78.04 2.3 2.3 0 0 1 1.2 2c0 .5-.13.92-.4 1.27-.25.34-.6.58-1.04.72v.06c.56.1.99.33 1.3.7.3.38.46.85.46 1.4 0 .48-.13.9-.39 1.28-.25.37-.6.67-1.04.88a3.4 3.4 0 0 1-1.52.33Zm9.1-4.06V412h-1.01v-8.73h1v3.2h.09c.15-.33.38-.6.69-.8.3-.2.72-.3 1.23-.3.45 0 .84.09 1.17.27.34.17.6.44.78.81.2.37.29.83.29 1.4V412h-1.01v-4.1c0-.51-.13-.91-.4-1.2a1.45 1.45 0 0 0-1.12-.43c-.33 0-.62.07-.88.21-.26.14-.47.34-.62.61-.14.27-.22.6-.22.97Zm8.73 4.08c-.59 0-1.1-.14-1.55-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.12-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.96-.42 1.55-.42.6 0 1.11.14 1.56.42.44.28.79.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.45.29-.96.43-1.56.43Zm0-.9c.45 0 .82-.12 1.11-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.06 2.06 0 0 0-.65-.92 1.71 1.71 0 0 0-1.1-.35c-.45 0-.82.12-1.11.35-.3.24-.5.54-.65.92-.14.38-.2.78-.2 1.22 0 .44.06.85.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Zm8.63-1.92v-3.87h1V412h-1v-1.1h-.07c-.15.32-.39.6-.71.84-.33.23-.74.34-1.23.34-.4 0-.77-.08-1.1-.26a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.27-1.39v-4.16h1v4.1c0 .47.13.85.4 1.14.27.28.62.42 1.03.42.25 0 .5-.06.77-.19a1.67 1.67 0 0 0 .92-1.6Zm2.85 2.68v-6.55h.97v1h.07c.12-.33.33-.6.65-.8.3-.2.66-.3 1.05-.3a10.86 10.86 0 0 1 .53.02v1.02a3.3 3.3 0 0 0-.61-.07c-.32 0-.6.07-.85.2s-.45.32-.6.55c-.13.23-.2.5-.2.79V412h-1.01Zm9.1-5.08-.9.26c-.06-.15-.14-.3-.25-.44-.11-.15-.26-.27-.45-.36-.19-.1-.43-.14-.72-.14-.4 0-.73.1-1 .28-.26.18-.4.4-.4.69 0 .25.1.45.28.6.18.14.46.26.85.36l.97.23c.59.15 1.02.36 1.3.66.3.29.44.66.44 1.12 0 .37-.1.7-.33 1-.2.3-.5.53-.89.7-.38.17-.83.26-1.34.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.96-.24c.09.36.26.62.51.8.26.17.6.26 1 .26.47 0 .85-.1 1.12-.3.28-.2.42-.44.42-.72a.76.76 0 0 0-.24-.57c-.16-.16-.4-.28-.73-.35l-1.1-.26a2.6 2.6 0 0 1-1.31-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.3-.98.22-.28.5-.5.87-.67a3 3 0 0 1 1.23-.24c.65 0 1.16.14 1.53.43.37.28.63.65.79 1.12Zm6.93 5.23c-.41 0-.79-.07-1.13-.23-.33-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.35-.42.6-.55.24-.14.51-.24.81-.3.3-.07.6-.12.91-.16.4-.06.72-.1.97-.12.25-.03.43-.07.54-.14.12-.06.18-.18.18-.34v-.04c0-.41-.12-.74-.35-.97-.22-.24-.57-.35-1.03-.35-.48 0-.86.1-1.13.31-.27.21-.47.44-.58.67l-.95-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.27.04.54.15.8.3.25.15.47.38.64.7.17.3.25.72.25 1.24V412h-1v-.89h-.05c-.07.15-.18.3-.34.46-.16.16-.37.3-.64.41-.26.12-.58.17-.97.17Zm.16-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.14.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.23.07-.4.19-.55.34a.85.85 0 0 0-.2.6c0 .35.13.62.38.8.27.17.6.26 1 .26Zm7.32 3.34c-.48 0-.9-.06-1.25-.19a2.67 2.67 0 0 1-1.42-1.12l.8-.56.34.4c.14.16.33.3.57.41.25.12.57.18.96.18.53 0 .97-.13 1.31-.39.34-.25.52-.65.52-1.2v-1.33h-.09c-.07.12-.18.27-.31.44-.14.18-.33.33-.58.47-.25.13-.6.2-1.02.2a2.64 2.64 0 0 1-2.42-1.47 3.82 3.82 0 0 1-.36-1.74c0-.67.12-1.25.36-1.75a2.6 2.6 0 0 1 2.44-1.57c.43 0 .76.07 1.01.21.26.14.45.3.58.48l.32.43h.1v-1.04h.97v6.74c0 .56-.13 1.02-.38 1.37-.25.36-.6.62-1.02.78-.43.17-.9.25-1.43.25Zm-.03-3.6c.4 0 .74-.09 1.02-.27.28-.19.5-.45.63-.8.15-.35.22-.76.22-1.24s-.07-.9-.21-1.25a1.87 1.87 0 0 0-.63-.85c-.28-.2-.62-.3-1.03-.3-.43 0-.78.1-1.07.32-.28.21-.49.5-.63.87-.14.36-.21.76-.21 1.2 0 .46.07.86.21 1.21.15.35.36.62.64.82.28.2.64.3 1.06.3Zm7.36 1.15c-.59 0-1.1-.14-1.55-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.12-1.28.37-1.78.25-.51.6-.9 1.04-1.19.44-.28.96-.42 1.55-.42.6 0 1.1.14 1.55.42.45.28.8.68 1.04 1.19a4 4 0 0 1 .38 1.78c0 .68-.13 1.27-.38 1.77-.25.51-.6.9-1.04 1.18-.44.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.51-.53.65-.91s.21-.78.21-1.22c0-.44-.07-.84-.2-1.22a2.06 2.06 0 0 0-.65-.92 1.71 1.71 0 0 0-1.1-.35c-.46 0-.83.12-1.12.35-.29.24-.5.54-.64.92s-.2.78-.2 1.22c0 .44.06.85.2 1.22.14.38.35.68.64.9.3.24.66.35 1.11.35Z"
      />
      <path
        fill="#14141F"
        d="M628.19 442.27v-12.72h.81v12.72h-.81Zm2.35-8.65a1.36 1.36 0 0 0-.59-1.02 2.25 2.25 0 0 0-1.33-.36c-.39 0-.72.06-1 .17-.27.12-.48.28-.62.48a1.15 1.15 0 0 0-.08 1.23c.1.15.23.29.4.4.17.1.36.2.56.27.2.07.41.13.62.18l.96.24c.38.09.75.2 1.1.36.37.15.69.35.97.58a2.52 2.52 0 0 1 .92 2 2.76 2.76 0 0 1-1.78 2.63c-.57.25-1.27.37-2.08.37a5.3 5.3 0 0 1-2.06-.36 3.07 3.07 0 0 1-1.37-1.08 3.2 3.2 0 0 1-.52-1.72h1.81a1.55 1.55 0 0 0 1.08 1.41c.31.12.66.18 1.04.18.4 0 .76-.06 1.06-.18.3-.12.54-.3.71-.5.18-.23.26-.48.27-.77a.97.97 0 0 0-.24-.66 1.73 1.73 0 0 0-.64-.44 6.15 6.15 0 0 0-.95-.32l-1.16-.3a4.66 4.66 0 0 1-1.99-.97 2.26 2.26 0 0 1-.73-1.76c0-.6.17-1.12.5-1.57.32-.46.77-.8 1.33-1.05s1.2-.38 1.91-.38c.73 0 1.36.13 1.9.38.55.25.98.6 1.29 1.04.31.44.47.94.48 1.52h-1.77Zm7.6-2.8V441h-1.85v-8.39h-.06l-2.38 1.52v-1.69l2.53-1.62h1.76Zm6.31 10.32c-.49 0-.96-.09-1.43-.25a3.35 3.35 0 0 1-1.25-.82 4.03 4.03 0 0 1-.88-1.52 7.22 7.22 0 0 1-.33-2.35c0-.87.1-1.65.28-2.33.19-.69.45-1.26.8-1.73a3.52 3.52 0 0 1 2.92-1.46c.64 0 1.2.13 1.7.38a3.2 3.2 0 0 1 1.77 2.5h-1.82c-.1-.39-.28-.7-.57-.93a1.65 1.65 0 0 0-1.08-.36c-.71 0-1.25.31-1.63.93a4.82 4.82 0 0 0-.58 2.52h.07c.17-.3.38-.54.63-.75a3.1 3.1 0 0 1 1.91-.66 3.06 3.06 0 0 1 2.75 1.6c.28.5.41 1.08.41 1.72a3.33 3.33 0 0 1-1.75 3.06c-.54.3-1.19.45-1.92.45Zm0-1.5c.35 0 .68-.08.96-.26.29-.17.51-.4.68-.7a2 2 0 0 0 .24-1.01c0-.37-.08-.7-.24-.99a1.82 1.82 0 0 0-2.37-.8c-.24.1-.44.24-.61.42a2 2 0 0 0-.3 2.36 1.79 1.79 0 0 0 1.64.99Zm7.05-.03-.07.54c-.04.42-.13.85-.25 1.28a16.02 16.02 0 0 1-.68 2.06h-1.21a166.3 166.3 0 0 0 .43-2c.07-.44.12-.88.15-1.32l.04-.56h1.59Zm5.23 1.53a4.9 4.9 0 0 1-1.97-.37 3.27 3.27 0 0 1-1.34-1.02 2.4 2.4 0 0 1-.48-1.48c0-.43.09-.82.28-1.18a2.63 2.63 0 0 1 1.85-1.35v-.07a2.15 2.15 0 0 1-1.27-.8 2.3 2.3 0 0 1-.48-1.46c0-.53.14-1 .44-1.4.3-.41.7-.74 1.2-.97.52-.24 1.11-.36 1.77-.36.65 0 1.23.12 1.74.36.52.23.92.56 1.22.97.3.4.44.88.44 1.4a2.3 2.3 0 0 1-.49 1.45c-.32.42-.74.69-1.25.8v.07a2.63 2.63 0 0 1 2.13 2.54 2.4 2.4 0 0 1-.5 1.48c-.32.43-.77.77-1.34 1.02-.56.25-1.21.37-1.95.37Zm0-1.42c.38 0 .71-.07 1-.2.27-.13.5-.31.65-.55.16-.24.24-.52.24-.83 0-.32-.09-.61-.25-.86a1.66 1.66 0 0 0-.68-.59 2.1 2.1 0 0 0-.96-.21c-.37 0-.69.07-.98.21a1.7 1.7 0 0 0-.67.6 1.5 1.5 0 0 0-.24.85 1.45 1.45 0 0 0 .88 1.38c.29.13.63.2 1 .2Zm0-4.64c.31 0 .59-.06.82-.19a1.44 1.44 0 0 0 .79-1.3 1.35 1.35 0 0 0-.78-1.28 1.81 1.81 0 0 0-.83-.19c-.32 0-.6.06-.85.19a1.35 1.35 0 0 0-.76 1.27c0 .3.06.56.2.78.14.22.33.4.57.53.24.13.52.19.84.19Zm8.96 6.06a4.1 4.1 0 0 1-1.78-.37c-.53-.26-.94-.6-1.25-1.04-.3-.44-.47-.94-.49-1.5h1.8c.02.42.2.76.53 1.02.33.27.73.4 1.19.4a1.78 1.78 0 0 0 1.63-.94c.16-.3.24-.63.24-1.01 0-.39-.08-.73-.25-1.02a1.9 1.9 0 0 0-1.68-.96c-.3 0-.6.05-.9.16-.29.12-.52.27-.7.46l-1.66-.27.53-5.25h5.9v1.54h-4.37l-.3 2.7h.07c.18-.22.45-.4.8-.55a3.13 3.13 0 0 1 3.93 1.4c.27.51.41 1.1.41 1.74a3.31 3.31 0 0 1-1.75 3.04 3.9 3.9 0 0 1-1.9.45Zm9.08.05c-.82 0-1.52-.2-2.1-.62a3.95 3.95 0 0 1-1.35-1.8 7.75 7.75 0 0 1-.47-2.85c0-1.11.16-2.06.47-2.84a3.9 3.9 0 0 1 1.35-1.78 3.57 3.57 0 0 1 2.1-.62c.82 0 1.52.2 2.1.62.59.4 1.04 1 1.35 1.78.31.79.47 1.73.47 2.84a7.7 7.7 0 0 1-.47 2.85 3.87 3.87 0 0 1-1.35 1.8c-.58.42-1.28.62-2.1.62Zm0-1.55c.64 0 1.14-.31 1.5-.94.38-.63.56-1.56.56-2.78 0-.81-.08-1.49-.25-2.04a2.7 2.7 0 0 0-.72-1.24c-.3-.28-.67-.43-1.09-.43-.63 0-1.13.32-1.5.95a5.58 5.58 0 0 0-.56 2.76c0 .81.08 1.5.25 2.05.16.55.4.97.71 1.25.3.28.68.42 1.1.42Zm6.3 1.47c-.3 0-.55-.1-.77-.32a1.02 1.02 0 0 1-.32-.77c0-.3.1-.56.32-.77.22-.21.48-.32.78-.32.29 0 .54.1.76.32a1.04 1.04 0 0 1 .17 1.32c-.1.16-.23.3-.4.4-.16.1-.34.14-.53.14Zm6.3.08c-.81 0-1.52-.2-2.1-.62a3.96 3.96 0 0 1-1.35-1.8 7.77 7.77 0 0 1-.47-2.85c0-1.11.16-2.06.47-2.84a3.9 3.9 0 0 1 1.35-1.78 3.57 3.57 0 0 1 2.1-.62c.82 0 1.52.2 2.1.62.6.4 1.04 1 1.36 1.78.31.79.47 1.73.47 2.84a7.7 7.7 0 0 1-.47 2.85 3.88 3.88 0 0 1-1.35 1.8c-.59.42-1.29.62-2.1.62Zm0-1.55c.64 0 1.14-.31 1.51-.94.37-.63.56-1.56.56-2.78 0-.81-.09-1.49-.26-2.04a2.7 2.7 0 0 0-.71-1.24c-.3-.28-.67-.43-1.1-.43-.63 0-1.13.32-1.5.95a5.56 5.56 0 0 0-.55 2.76c0 .81.07 1.5.24 2.05.17.55.4.97.72 1.25.3.28.67.42 1.1.42Zm9.34 1.55c-.82 0-1.52-.2-2.1-.62a3.96 3.96 0 0 1-1.35-1.8 7.75 7.75 0 0 1-.47-2.85c0-1.11.16-2.06.47-2.84a3.9 3.9 0 0 1 1.35-1.78 3.57 3.57 0 0 1 2.1-.62c.82 0 1.52.2 2.1.62.6.4 1.04 1 1.35 1.78.32.79.48 1.73.48 2.84 0 1.11-.16 2.06-.48 2.85a3.88 3.88 0 0 1-1.34 1.8c-.59.42-1.29.62-2.1.62Zm0-1.55c.64 0 1.14-.31 1.51-.94.37-.63.56-1.56.56-2.78 0-.81-.09-1.49-.26-2.04a2.7 2.7 0 0 0-.71-1.24c-.31-.28-.68-.43-1.1-.43-.63 0-1.13.32-1.5.95a5.56 5.56 0 0 0-.56 2.76c0 .81.08 1.5.25 2.05.17.55.4.97.72 1.25.3.28.67.42 1.1.42Z"
      />
      <path
        fill="#474E6B"
        d="M707.23 441v-10.18h1.18v3.76h.1c.08-.14.2-.3.35-.51.16-.2.38-.4.67-.56.3-.16.69-.25 1.18-.25a3.03 3.03 0 0 1 2.85 1.85c.28.6.41 1.29.41 2.1 0 .8-.13 1.5-.4 2.1a3 3 0 0 1-2.83 1.85 2.18 2.18 0 0 1-1.86-.8 7.2 7.2 0 0 1-.37-.53h-.14V441h-1.14Zm1.16-3.82c0 .58.08 1.09.25 1.53.17.44.42.78.74 1.03.33.24.72.37 1.2.37s.9-.13 1.22-.4c.33-.25.58-.6.75-1.05.17-.44.25-.94.25-1.48s-.08-1.02-.25-1.45a2.25 2.25 0 0 0-.74-1.03 1.96 1.96 0 0 0-1.24-.38 1.96 1.96 0 0 0-1.94 1.37c-.16.42-.24.92-.24 1.5Zm7.38 3.82v-7.64h1.17V441h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.58.23Zm3.9-1.28V441h-1.18v-10.18h1.17Zm3.32 0V441h-1.18v-10.18h1.18Zm5.35 10.34a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.94 2.94 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.89v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.22.36-.33.22-.6.52-.77.9-.19.36-.28.75-.28 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12.25-.1.47-.23.65-.4.19-.18.33-.4.43-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm7.83 0a3 3 0 0 1-2.83-1.86c-.28-.59-.41-1.29-.41-2.1 0-.8.13-1.5.4-2.09a3.03 3.03 0 0 1 2.85-1.85c.5 0 .9.09 1.19.25.29.17.51.35.66.56l.37.5h.1v-3.75h1.17V441h-1.14v-1.17H739l-.37.52c-.16.21-.39.4-.68.56-.3.17-.7.25-1.18.25Zm.16-1.06c.47 0 .87-.12 1.19-.36.33-.25.57-.6.74-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.24-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.25.4-.32.24-.57.59-.74 1.02a4.1 4.1 0 0 0-.24 1.45c0 .55.08 1.04.25 1.48.17.44.42.8.74 1.06.34.26.75.38 1.24.38Zm14.8 3.76v-4.03h-.1l-.37.52c-.16.21-.39.4-.68.56-.3.17-.69.25-1.18.25a3 3 0 0 1-2.83-1.86c-.27-.59-.41-1.29-.41-2.1 0-.8.14-1.5.41-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.17.51.35.66.56l.37.5h.14v-1.2h1.13v10.5h-1.17Zm-2.17-3.75c.47 0 .87-.13 1.2-.37.32-.25.57-.6.73-1.03.17-.44.26-.95.26-1.53 0-.57-.09-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.24.4-.33.24-.58.59-.74 1.02a4.1 4.1 0 0 0-.25 1.45c0 .55.08 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Zm10.3-2.23v-4.52h1.17V441h-1.17v-1.3h-.08a2.5 2.5 0 0 1-.83 1c-.38.26-.86.4-1.44.4-.47 0-.9-.1-1.27-.31a2.19 2.19 0 0 1-.87-.96 3.63 3.63 0 0 1-.32-1.61v-4.86h1.17v4.78c0 .55.16 1 .47 1.33.31.33.71.5 1.2.5a2 2 0 0 0 1.97-2.1Zm6.43 3.28c-.7 0-1.3-.17-1.82-.5a3.34 3.34 0 0 1-1.21-1.37 4.65 4.65 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.29-.6.7-1.06 1.21-1.38.52-.33 1.13-.5 1.82-.5a3.3 3.3 0 0 1 3.02 1.87c.29.6.44 1.3.44 2.1 0 .78-.15 1.47-.44 2.06-.29.59-.7 1.05-1.21 1.38a3.3 3.3 0 0 1-1.81.49Zm0-1.06c.52 0 .95-.13 1.29-.4.34-.27.59-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43-.16-.44-.41-.8-.75-1.06a2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4c-.34.28-.59.63-.75 1.07a4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm8.57-6.74v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm7.68 9.63a3.6 3.6 0 0 1-1.9-.49 3.28 3.28 0 0 1-1.23-1.37 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.7c0-.44-.1-.82-.27-1.16a1.94 1.94 0 0 0-1.83-1.1c-.46 0-.87.12-1.21.36-.34.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.31 1.25.31.31 0 .59-.04.84-.12.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01 2.9 2.9 0 0 1-1.04.68c-.41.16-.88.24-1.4.24Zm8.89-.16v-7.64h1.17V441h-1.17Zm.6-8.9a.83.83 0 0 1-.6-.24.75.75 0 0 1-.24-.56c0-.22.08-.41.24-.57a.83.83 0 0 1 .6-.23c.22 0 .42.08.58.23.17.16.25.35.25.56 0 .22-.08.41-.25.57a.82.82 0 0 1-.59.23Zm8.13 2.97-1.06.3a1.95 1.95 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.76.34.34.5.78.5 1.31 0 .44-.12.83-.37 1.18-.25.34-.6.61-1.04.81-.45.2-.97.3-1.57.3-.77 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.7.3 1.17.3.55 0 .99-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.5-1.32c0-.43.13-.81.37-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Zm11.25 0-1.05.3a1.95 1.95 0 0 0-.3-.51c-.12-.17-.3-.3-.51-.42-.22-.1-.5-.16-.85-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.11.52.32.7.21.16.55.3 1 .42l1.13.27c.68.17 1.2.42 1.53.76.33.34.5.78.5 1.31 0 .44-.13.83-.38 1.18-.25.34-.6.61-1.04.81-.45.2-.97.3-1.56.3-.78 0-1.43-.17-1.94-.5a2.25 2.25 0 0 1-.97-1.49l1.12-.28c.1.41.3.72.6.93.3.2.69.3 1.17.3.54 0 .98-.11 1.3-.34.32-.24.49-.52.49-.85 0-.26-.1-.49-.28-.66a1.77 1.77 0 0 0-.86-.41l-1.27-.3a3.03 3.03 0 0 1-1.54-.77 1.86 1.86 0 0 1-.49-1.32c0-.43.12-.81.36-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Zm5.1 6.09a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.42-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .79.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81c.18.49.28 1.09.28 1.8v.5h-5.89v-1.01h4.7c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.22.36-.33.22-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.31 1.25.31.3 0 .58-.04.83-.12.25-.1.47-.23.65-.4.19-.18.33-.4.43-.67l1.13.32c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm6.13-4.75V441h-1.18v-7.64h1.14v1.2h.1c.18-.4.45-.7.81-.94.37-.24.84-.36 1.41-.36.52 0 .97.11 1.36.32.39.21.7.53.9.96.22.42.33.96.33 1.6V441h-1.17v-4.77c0-.6-.16-1.07-.47-1.4-.31-.34-.74-.51-1.28-.51-.38 0-.71.08-1 .24-.3.16-.53.4-.7.71-.17.31-.25.7-.25 1.14Zm10.33-3.05v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.31.08.49.08l.32-.02.2-.04.23 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.66-.31-1.1v-7.6Zm11.83 1.83v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.5.08l.3-.02.2-.04.25 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.66-.3-1.1v-7.6Zm7.58 9.63c-.69 0-1.3-.17-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.06 1.2-1.38.53-.33 1.13-.5 1.82-.5.7 0 1.3.17 1.81.5.52.32.93.79 1.22 1.38.29.6.43 1.29.43 2.08s-.14 1.48-.43 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.06c.53 0 .96-.13 1.3-.4.33-.27.58-.62.75-1.06.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4c-.34.28-.59.63-.75 1.07a4.1 4.1 0 0 0-.24 1.43c0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Z"
      />
      <path
        fill="#14141F"
        d="M859.54 433.62a1.36 1.36 0 0 0-.59-1.02 2.25 2.25 0 0 0-1.33-.36c-.39 0-.72.06-1 .17-.27.12-.48.28-.62.48a1.15 1.15 0 0 0-.08 1.23c.1.15.23.29.4.4.17.1.36.2.56.27.2.07.41.13.62.18l.96.24c.38.09.75.2 1.1.36.37.15.69.35.97.58a2.52 2.52 0 0 1 .92 2 2.76 2.76 0 0 1-1.78 2.63c-.57.25-1.27.37-2.08.37a5.3 5.3 0 0 1-2.06-.36 3.07 3.07 0 0 1-1.37-1.08 3.2 3.2 0 0 1-.52-1.72h1.81a1.55 1.55 0 0 0 1.08 1.41c.31.12.66.18 1.04.18.4 0 .76-.06 1.06-.18.3-.12.54-.3.71-.5.18-.23.26-.48.27-.77a.97.97 0 0 0-.24-.66 1.73 1.73 0 0 0-.64-.44 6.15 6.15 0 0 0-.95-.32l-1.16-.3a4.66 4.66 0 0 1-1.99-.97 2.26 2.26 0 0 1-.73-1.76c0-.6.17-1.12.5-1.57.32-.46.77-.8 1.33-1.05s1.2-.38 1.91-.38c.73 0 1.36.13 1.9.38.55.25.98.6 1.29 1.04.31.44.47.94.48 1.52h-1.77Zm7.29-.26v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.12.05.26.07.4.07a1.72 1.72 0 0 0 .54-.07l.3 1.4a3.83 3.83 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.3-1.2v-7.47Zm8.1 9.62c-.76 0-1.42-.16-1.98-.48a3.23 3.23 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.4 3.4 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.07-.66-.22-.93a1.62 1.62 0 0 0-.61-.64 1.72 1.72 0 0 0-.9-.23c-.37 0-.7.09-.98.26-.27.18-.5.41-.65.7a2 2 0 0 0-.23.94v1.06c0 .44.08.82.24 1.14.17.32.4.56.68.73.3.16.64.25 1.03.25.26 0 .5-.04.7-.11.22-.08.4-.19.56-.33.16-.15.28-.33.35-.55l1.69.2c-.11.44-.31.82-.61 1.16-.3.32-.68.58-1.14.76-.46.18-.98.27-1.58.27Zm4.92-.15v-7.64h1.75v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.15 4.15 0 0 1 .65.05v1.66a3.38 3.38 0 0 0-.84-.1c-.33 0-.62.07-.88.2a1.56 1.56 0 0 0-.84 1.45V441h-1.8Zm7.35-10.18V441h-1.8v-10.18h1.8Zm1.85 10.18v-7.64h1.8V441h-1.8Zm.9-8.72c-.28 0-.52-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28s.53.1.73.28c.2.2.31.42.31.7 0 .26-.1.5-.3.69-.2.19-.45.28-.74.28Zm4.55 4.25V441h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.4-.25.87-.38 1.44-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V441h-1.8v-4.58c0-.51-.14-.91-.4-1.2a1.4 1.4 0 0 0-1.1-.43c-.3 0-.59.06-.83.2s-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.06 7.5a4.7 4.7 0 0 1-1.67-.27c-.46-.17-.84-.4-1.12-.7-.28-.29-.48-.61-.59-.97l1.63-.39a1.72 1.72 0 0 0 .88.81c.23.1.53.15.9.15.5 0 .93-.12 1.26-.37.34-.25.5-.65.5-1.22v-1.44h-.08c-.1.18-.23.37-.41.57-.18.2-.41.36-.7.5a3.14 3.14 0 0 1-2.68-.21c-.48-.29-.86-.7-1.14-1.25a4.6 4.6 0 0 1-.42-2.08c0-.84.14-1.55.42-2.13a2.93 2.93 0 0 1 3.84-1.54c.29.15.52.33.7.55.16.2.3.4.39.59h.1v-1.27h1.77v7.76c0 .66-.16 1.2-.47 1.63-.3.42-.74.74-1.27.95a5 5 0 0 1-1.84.32Zm.01-4.55c.38 0 .7-.1.98-.28.26-.19.47-.45.6-.8.15-.35.22-.77.22-1.25s-.07-.9-.21-1.27a1.8 1.8 0 0 0-.61-.84c-.26-.2-.6-.3-.98-.3-.4 0-.74.1-1 .31-.27.21-.47.5-.61.86s-.2.78-.2 1.24c0 .46.06.87.2 1.23.14.34.34.62.61.81.27.2.6.29 1 .29Zm17.68-5.23h-1.86a2.33 2.33 0 0 0-.82-1.41 2.21 2.21 0 0 0-.73-.38 2.83 2.83 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.69 4.69 0 0 0-.37 1.95c0 .78.12 1.43.37 1.97.24.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.26-.94c.15-.24.26-.5.31-.8h1.86a4.01 4.01 0 0 1-2.65 3.25c-.5.18-1.05.27-1.66.27a4.34 4.34 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .61-2.81 4.37 4.37 0 0 1 4.05-2.42c.57 0 1.1.08 1.58.24a4.03 4.03 0 0 1 2.25 1.82c.24.44.4.95.48 1.51Zm4.94 6.9a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.52 4.52 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.73-1.06 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.32.97.79 1.27 1.38.3.6.45 1.28.45 2.07 0 .79-.15 1.48-.45 2.07a3.3 3.3 0 0 1-1.27 1.38c-.55.32-1.2.49-1.94.49Zm.01-1.44c.4 0 .75-.11 1.02-.34a2 2 0 0 0 .6-.9c.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.27.22-.48.53-.61.9-.14.39-.2.8-.2 1.28 0 .46.06.88.2 1.26.13.38.34.68.6.9.28.23.63.34 1.04.34Zm8.51 1.44a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.06 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.32.97.79 1.27 1.38.3.6.45 1.28.45 2.07a4.5 4.5 0 0 1-.45 2.07c-.3.59-.72 1.05-1.27 1.38-.55.32-1.2.49-1.94.49Zm.01-1.44c.4 0 .74-.11 1.01-.34a2 2 0 0 0 .61-.9c.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.62.34 1.03.34Zm5.18 4.15v-10.5h1.77v1.27h.1c.1-.19.23-.39.4-.6.16-.2.4-.39.68-.54a2.9 2.9 0 0 1 3.83 1.55c.28.59.42 1.3.42 2.15 0 .84-.13 1.55-.4 2.14a2.9 2.9 0 0 1-2.74 1.8 2.18 2.18 0 0 1-1.78-.75c-.18-.2-.31-.4-.4-.58h-.08v4.06h-1.8Zm1.76-6.68c0 .5.07.93.21 1.3.14.37.35.66.61.87.27.2.6.3.98.3.4 0 .73-.1 1-.31.26-.22.47-.5.6-.88.14-.38.21-.8.21-1.28 0-.47-.07-.9-.2-1.26a1.9 1.9 0 0 0-.6-.87c-.28-.2-.61-.3-1.01-.3-.39 0-.71.1-.98.3-.27.2-.47.48-.61.84-.14.37-.2.8-.2 1.3Zm10.37 3.97c-.77 0-1.43-.16-1.99-.48a3.23 3.23 0 0 1-1.27-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.39 3.39 0 0 1 3.16-1.9c.47 0 .92.08 1.34.23.42.15.79.38 1.1.7.33.31.59.71.77 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.63 1.63 0 0 0-.6-.64 1.71 1.71 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.82.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.33.16-.15.28-.33.36-.55l1.68.2c-.1.44-.31.82-.6 1.16-.3.32-.68.58-1.14.76-.46.18-.99.27-1.58.27Zm4.91-.15v-7.64h1.75v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.1 4.1 0 0 1 .65.05v1.66a3.38 3.38 0 0 0-.84-.1c-.32 0-.62.07-.88.2a1.56 1.56 0 0 0-.83 1.45V441h-1.8Z"
      />
      <path
        fill="#DEE5ED"
        d="M1120 463H560v2h560v-2Z"
        mask="url(#path-124-inside-6_1_3812)"
      />
      <circle cx={584} cy={504} r={24} fill="url(#pattern4)" />
      <path
        fill="#6C7793"
        d="M627.63 492.12a3 3 0 0 1-1.35-.3 2.5 2.5 0 0 1-.96-.82 2.23 2.23 0 0 1-.4-1.18h1.02c.04.4.22.72.54.98.32.25.7.38 1.15.38a1.8 1.8 0 0 0 1.62-.94c.16-.3.24-.63.24-1 0-.38-.09-.72-.25-1.02a1.84 1.84 0 0 0-1.68-.98 2.73 2.73 0 0 0-1.51.45l-1-.12.54-4.3h4.53v.94h-3.65l-.3 2.57h.05a2.57 2.57 0 0 1 1.52-.5 2.69 2.69 0 0 1 2.4 1.43c.25.44.37.95.37 1.51s-.12 1.06-.37 1.5a2.74 2.74 0 0 1-2.5 1.4Zm7.97-.12v-6.55h.97v1.03h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .79.1 1.08.3.29.2.51.47.67.82h.07c.17-.34.42-.6.76-.8.33-.21.73-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V492h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V492h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.51.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V492h-1.01Zm10.43 0v-6.55h1V492h-1Zm.5-7.64a.71.71 0 0 1-.5-.2.64.64 0 0 1-.2-.48c0-.19.06-.35.2-.48s.31-.2.5-.2c.2 0 .37.07.51.2s.21.3.21.48c0 .19-.07.35-.21.48a.7.7 0 0 1-.5.2Zm3.35 3.7V492h-1v-6.55h.97v1.03h.08c.15-.34.39-.6.7-.8.31-.2.72-.31 1.2-.31.45 0 .84.09 1.17.27.34.18.6.45.78.82.18.36.27.82.27 1.38V492h-1v-4.1c0-.5-.13-.9-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.86.21-.25.14-.45.34-.6.61-.14.27-.21.6-.21.97Zm10.14 1.26v-3.87h1V492h-1v-1.1h-.07a2.07 2.07 0 0 1-1.94 1.2c-.41-.02-.78-.1-1.1-.28a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.28-1.39v-4.16h1v4.1c0 .47.14.85.4 1.14.28.28.62.42 1.04.42.25 0 .5-.06.76-.19a1.66 1.66 0 0 0 .93-1.6Zm5.7-3.87v.86h-3.4v-.86h3.4Zm-2.41-1.56h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.29a1.83 1.83 0 0 0 .7.05l.17-.04.2.9a2.25 2.25 0 0 1-.75.13c-.28 0-.56-.07-.83-.19-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm6.59 8.25a2.81 2.81 0 0 1-2.68-1.6c-.25-.5-.37-1.1-.37-1.76 0-.67.12-1.26.36-1.77a2.77 2.77 0 0 1 2.58-1.64c.35 0 .68.06 1.02.17.33.11.63.3.9.55.28.26.5.6.66 1 .16.43.24.94.24 1.55v.43h-5.05v-.87h4.03c0-.37-.08-.7-.23-.99a1.67 1.67 0 0 0-1.56-.94c-.4 0-.75.1-1.04.3-.3.2-.52.45-.67.77-.16.31-.24.65-.24 1.01v.58c0 .5.09.92.26 1.26.17.34.41.6.72.78.3.17.66.26 1.07.26.26 0 .5-.03.72-.1a1.55 1.55 0 0 0 .92-.91l.97.26c-.1.33-.28.62-.52.87a2.5 2.5 0 0 1-.9.58c-.35.14-.75.2-1.2.2Zm8.88-5.22-.9.26c-.06-.15-.15-.3-.26-.44-.1-.15-.25-.27-.44-.36-.19-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.1.45.27.6.18.14.47.26.85.36l.98.23c.58.15 1.02.36 1.3.66.3.29.43.66.43 1.12 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.93 1.93 0 0 1-.83-1.27l.95-.24c.1.36.27.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.28-.2.41-.44.41-.72a.76.76 0 0 0-.23-.57c-.16-.16-.4-.28-.74-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.32-.98.2-.28.5-.5.85-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.43.38.28.64.65.8 1.12Zm6.93 5.23c-.42 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.8-.3.31-.07.61-.12.92-.16l.96-.12c.25-.03.44-.07.55-.14.12-.06.17-.18.17-.34v-.04c0-.41-.11-.74-.34-.97-.23-.24-.57-.35-1.04-.35-.48 0-.85.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.15.8.3s.47.38.64.7c.17.3.26.72.26 1.24V492h-1v-.89h-.06c-.06.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.59.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a20.74 20.74 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.07-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm7.33 3.34c-.49 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.1.11.2.25.35.4.14.16.33.3.57.41.24.12.56.18.96.18.53 0 .96-.13 1.3-.39.35-.25.52-.65.52-1.2v-1.33h-.08c-.08.12-.18.27-.32.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.01.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.36-1.74c0-.67.12-1.25.35-1.75a2.6 2.6 0 0 1 2.44-1.57c.43 0 .77.07 1.02.21.25.14.44.3.58.48l.31.43h.1v-1.04h.98v6.74c0 .56-.13 1.02-.39 1.37-.25.36-.59.62-1.02.78-.43.17-.9.25-1.42.25Zm-.04-3.6c.4 0 .75-.09 1.03-.27.28-.19.49-.45.63-.8.15-.35.22-.76.22-1.24s-.07-.9-.21-1.25a1.87 1.87 0 0 0-.64-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.07.86.2 1.21.15.35.37.62.65.82.28.2.63.3 1.05.3Zm7.37 1.15c-.6 0-1.11-.14-1.56-.43a2.86 2.86 0 0 1-1.04-1.18 4 4 0 0 1-.37-1.77c0-.68.13-1.28.37-1.78.25-.51.6-.9 1.04-1.19.45-.28.97-.42 1.56-.42.59 0 1.1.14 1.55.42.44.28.8.68 1.04 1.19a4 4 0 0 1 .37 1.78c0 .68-.12 1.27-.37 1.77-.25.51-.6.9-1.04 1.18-.45.29-.96.43-1.55.43Zm0-.9c.45 0 .82-.12 1.1-.35.3-.23.5-.53.65-.91.14-.38.2-.78.2-1.22 0-.44-.06-.84-.2-1.22a2.06 2.06 0 0 0-.64-.92 1.71 1.71 0 0 0-1.11-.35c-.45 0-.82.12-1.11.35-.3.24-.5.54-.64.92s-.21.78-.21 1.22c0 .44.07.85.2 1.22.14.38.36.68.65.9.29.24.66.35 1.1.35Z"
      />
      <path
        fill="#14141F"
        d="M633.72 514.25h-1.86a2.33 2.33 0 0 0-.83-1.41 2.21 2.21 0 0 0-.72-.38 2.84 2.84 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.67 4.67 0 0 0-.37 1.95c0 .78.12 1.43.36 1.97.25.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.27-.95c.15-.23.25-.5.31-.8l1.86.02a3.99 3.99 0 0 1-1.35 2.49c-.37.32-.8.57-1.3.75-.5.18-1.05.27-1.66.27a4.35 4.35 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .6-2.81 4.38 4.38 0 0 1 4.06-2.42c.57 0 1.1.08 1.58.24.49.16.92.39 1.3.7.38.3.7.68.94 1.12.25.44.41.95.49 1.51Zm3.4 2.28V521h-1.8v-10.18h1.77v3.84h.09c.18-.43.45-.77.83-1.02.38-.25.86-.38 1.44-.38.53 0 1 .12 1.39.34.4.22.7.54.91.97.22.43.33.95.33 1.57V521h-1.8v-4.58c0-.52-.13-.92-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.86.2-.24.14-.44.34-.58.6-.14.25-.21.57-.21.94Zm9 4.62c-.5 0-.93-.08-1.32-.25a2.14 2.14 0 0 1-.91-.78 2.27 2.27 0 0 1-.33-1.26c0-.43.08-.79.24-1.07.16-.28.37-.5.65-.68.27-.17.58-.3.93-.38.35-.09.7-.15 1.08-.2l1.08-.12c.28-.04.49-.1.61-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.79.09-1.05.28-.25.2-.42.42-.51.68l-1.68-.24a2.67 2.67 0 0 1 1.77-1.87 4.77 4.77 0 0 1 2.56-.11c.37.09.7.23 1 .43.3.2.54.46.73.8.18.34.27.76.27 1.27V521h-1.73v-1.05h-.05a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.05.16Zm.46-1.32c.36 0 .67-.07.94-.21.26-.15.47-.34.61-.58.15-.24.22-.5.22-.78v-.9a.87.87 0 0 1-.29.13 13.22 13.22 0 0 1-1.36.24c-.27.04-.51.1-.72.18-.21.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.12.58.37.75.24.17.55.25.92.25Zm7.17-3.3V521h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.4-.25.87-.38 1.44-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V521h-1.8v-4.58c0-.51-.14-.91-.4-1.2a1.4 1.4 0 0 0-1.1-.43c-.3 0-.59.07-.83.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.07 4.62a3.36 3.36 0 0 1-3.22-1.89c-.3-.6-.44-1.28-.44-2.05 0-.77.15-1.46.45-2.05a3.35 3.35 0 0 1 3.2-1.9c.62 0 1.17.12 1.64.35a2.81 2.81 0 0 1 1.64 2.4h-1.72a1.64 1.64 0 0 0-.5-.92c-.26-.25-.6-.37-1.04-.37-.37 0-.69.1-.97.3-.28.19-.5.47-.65.84-.15.37-.23.8-.23 1.32s.08.97.23 1.34c.15.38.37.66.64.86.28.2.6.3.98.3.27 0 .5-.05.71-.15.21-.1.4-.25.53-.44.15-.2.24-.43.3-.7h1.72a2.82 2.82 0 0 1-1.6 2.41c-.48.23-1.03.35-1.67.35Zm8.13 0c-.77 0-1.43-.16-1.99-.48a3.24 3.24 0 0 1-1.28-1.36 4.56 4.56 0 0 1-.44-2.08c0-.79.15-1.48.44-2.07a3.39 3.39 0 0 1 3.17-1.9c.47 0 .92.08 1.33.23.43.15.8.38 1.12.7.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.63 1.63 0 0 0-.6-.64 1.72 1.72 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.38.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.34.16-.14.28-.32.36-.54l1.68.2c-.1.44-.31.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-1 .27-1.58.27Zm8.47-.15v-10.18h3.82c.78 0 1.43.14 1.96.44.54.29.94.69 1.21 1.2.28.5.41 1.08.41 1.73a3.6 3.6 0 0 1-.4 1.74c-.28.5-.69.9-1.23 1.2-.53.28-1.2.43-1.98.43h-2.53v-1.52h2.28c.46 0 .83-.08 1.13-.24.29-.15.5-.37.64-.65s.22-.6.22-.96-.08-.68-.22-.96a1.45 1.45 0 0 0-.65-.64c-.3-.15-.67-.23-1.13-.23h-1.69V521h-1.84Zm10.73-4.47V521h-1.8v-10.18h1.76v3.84h.09c.17-.43.45-.77.83-1.02.37-.25.86-.38 1.44-.38.53 0 1 .12 1.38.34.4.22.7.54.92.97.22.43.33.95.33 1.57V521h-1.8v-4.58c0-.52-.13-.92-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.86.2-.25.14-.44.34-.59.6-.13.25-.2.57-.2.94Zm6.78 4.47v-7.64h1.8V521h-1.8Zm.9-8.72c-.28 0-.52-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28s.53.1.73.28c.2.2.31.42.31.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm4.55-1.46V521h-1.8v-10.18h1.8Zm1.85 10.18v-7.64h1.8V521h-1.8Zm.9-8.72c-.28 0-.52-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28s.53.1.73.28c.2.2.31.42.31.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm2.75 11.58v-10.5h1.77v1.27h.1c.1-.19.23-.39.4-.6.17-.2.4-.39.69-.54a2.9 2.9 0 0 1 3.83 1.55c.28.59.42 1.3.42 2.15 0 .84-.13 1.55-.41 2.14a2.9 2.9 0 0 1-2.73 1.8c-.44 0-.8-.07-1.1-.22a2.18 2.18 0 0 1-.69-.52c-.17-.21-.3-.4-.4-.6h-.08v4.07h-1.8Zm1.77-6.68c0 .5.07.93.2 1.3.15.37.35.66.62.87.27.2.6.3.97.3.4 0 .73-.1 1-.31.27-.22.47-.5.6-.88.15-.38.22-.8.22-1.28 0-.47-.07-.9-.2-1.26a1.9 1.9 0 0 0-.61-.87c-.27-.2-.6-.3-1-.3s-.72.1-.99.3c-.26.2-.47.48-.6.84-.14.37-.21.8-.21 1.3Zm13.02-1.8-1.64.18a1.33 1.33 0 0 0-.25-.47 1.2 1.2 0 0 0-.45-.35c-.2-.09-.43-.13-.7-.13-.38 0-.7.08-.95.24-.25.16-.38.37-.38.63 0 .22.08.4.25.54.17.14.45.26.83.35l1.3.27c.73.16 1.27.4 1.62.75.35.33.53.78.53 1.32 0 .48-.14.9-.42 1.28-.27.36-.66.64-1.15.85-.49.2-1.05.3-1.69.3-.93 0-1.69-.19-2.25-.58-.58-.4-.92-.94-1.02-1.64l1.75-.17c.08.34.25.6.5.78.27.17.6.26 1.02.26.42 0 .77-.09 1.03-.26.26-.18.39-.4.39-.65 0-.22-.09-.4-.25-.54a1.77 1.77 0 0 0-.78-.33l-1.3-.28a3.11 3.11 0 0 1-1.63-.77 1.9 1.9 0 0 1-.52-1.38c0-.47.12-.88.38-1.22a2.5 2.5 0 0 1 1.1-.8c.46-.2 1-.3 1.6-.3.9 0 1.6.2 2.12.58.52.38.84.9.96 1.54Z"
      />
      <path
        fill="#474E6B"
        d="M730.07 521v-7.64h1.14v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.27-.35.5 0 .93.12 1.26.35.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.86-.36 1.41-.36.68 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V521h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.25.48-.3.33-.44.74-.44 1.23V521h-1.2v-5.23c0-.43-.13-.78-.41-1.05-.29-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V521h-1.18Zm15.27.16c-.69 0-1.29-.16-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.05 1.2-1.38.53-.33 1.13-.5 1.82-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.22 1.38.29.6.43 1.29.43 2.08s-.14 1.48-.43 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.05c.53 0 .96-.14 1.3-.4.34-.28.59-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07c-.16.45-.24.92-.24 1.43 0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm11.23-6.75-2.83 7.64h-1.2l-2.81-7.64H751l2.1 6.09h.09l2.1-6.09h1.28Zm4.47 7.8a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.9v-1.01h4.7c0-.44-.08-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.23-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.64.52-1.05.68-.41.16-.88.24-1.4.24Zm7.83 0a3 3 0 0 1-2.83-1.86c-.27-.59-.4-1.29-.4-2.1 0-.8.13-1.5.4-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.16.51.35.67.56l.36.5h.1v-3.75h1.17V521h-1.13v-1.17h-.14c-.09.14-.2.31-.37.52-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.05c.47 0 .87-.13 1.2-.37.32-.25.57-.6.74-1.03.16-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.25.91-.25 1.45 0 .55.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Z"
      />
      <path
        fill="#14141F"
        d="M779 521v-10.18h6.63v1.54h-4.78v2.77h4.43v1.54h-4.43v2.78h4.82V521H779Zm10.23-4.47V521h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.39-.25.87-.38 1.43-.38.53 0 1 .12 1.38.34.4.23.7.55.92.98.22.43.32.95.32 1.56V521h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.54-3.17v1.4h-4.39v-1.4h4.4Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.71 1.71 0 0 0 .53-.07l.3 1.4a3.8 3.8 0 0 1-1.06.18c-.45.02-.85-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.3-1.2v-7.47Zm8.1 9.62c-.76 0-1.42-.16-1.98-.48a3.24 3.24 0 0 1-1.27-1.36 4.56 4.56 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.39 3.39 0 0 1 3.16-1.9c.47 0 .92.08 1.34.23a3 3 0 0 1 1.1.7c.33.31.59.71.77 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.63 1.63 0 0 0-.6-.64 1.72 1.72 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.22-.08.4-.19.56-.34.15-.14.27-.32.35-.54l1.68.2c-.1.44-.31.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-.99.27-1.58.27Zm4.92-.15v-7.64h1.75v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.15 4.15 0 0 1 .65.05v1.66a3.37 3.37 0 0 0-.84-.1c-.32 0-.62.07-.88.2a1.56 1.56 0 0 0-.84 1.45V521h-1.8Zm5.56 2.86v-10.5h1.77v1.27h.1c.1-.19.22-.39.4-.6.16-.2.4-.39.68-.54a2.9 2.9 0 0 1 3.83 1.55c.28.59.42 1.3.42 2.15 0 .84-.13 1.55-.4 2.14a2.89 2.89 0 0 1-2.73 1.8c-.45 0-.81-.07-1.1-.22a2.18 2.18 0 0 1-.7-.52c-.17-.21-.3-.4-.4-.6h-.07v4.07h-1.8Zm1.76-6.68c0 .5.07.93.21 1.3.14.37.35.66.61.87.27.2.6.3.98.3.4 0 .73-.1 1-.31.26-.22.47-.5.6-.88.14-.38.21-.8.21-1.28 0-.47-.07-.9-.2-1.26a1.9 1.9 0 0 0-.61-.87c-.27-.2-.6-.3-1-.3-.39 0-.72.1-.98.3-.27.2-.48.48-.62.84-.13.37-.2.8-.2 1.3Zm6.99 3.82v-7.64h1.74v1.28h.08a1.91 1.91 0 0 1 1.88-1.39 4.15 4.15 0 0 1 .65.05v1.66a3.37 3.37 0 0 0-.83-.1c-.33 0-.63.07-.89.2a1.56 1.56 0 0 0-.83 1.45V521h-1.8Zm5.55 0v-7.64h1.8V521h-1.8Zm.9-8.72c-.28 0-.53-.1-.73-.28a.91.91 0 0 1-.31-.7c0-.27.1-.5.3-.69.21-.19.46-.28.74-.28.29 0 .53.1.74.28.2.2.3.42.3.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm8.78 3.1-1.64.18a1.33 1.33 0 0 0-.24-.47 1.2 1.2 0 0 0-.46-.35c-.2-.09-.43-.13-.7-.13-.38 0-.7.08-.95.24-.25.16-.38.37-.37.63 0 .22.08.4.24.54.17.14.45.26.84.35l1.3.27c.72.16 1.26.4 1.61.75.35.33.53.78.54 1.32 0 .48-.15.9-.43 1.28-.27.36-.65.64-1.14.85-.5.2-1.06.3-1.7.3-.93 0-1.68-.19-2.25-.58-.57-.4-.91-.94-1.02-1.64l1.75-.17c.08.34.25.6.51.78.26.17.6.26 1.01.26.43 0 .77-.09 1.03-.26.26-.18.4-.4.4-.65 0-.22-.1-.4-.26-.54a1.78 1.78 0 0 0-.78-.33l-1.3-.28a3.1 3.1 0 0 1-1.63-.77 1.89 1.89 0 0 1-.52-1.38c0-.47.13-.88.39-1.22a2.5 2.5 0 0 1 1.08-.8c.47-.2 1.01-.3 1.62-.3.9 0 1.6.2 2.11.58.52.38.84.9.96 1.54Zm5.03 5.77c-.76 0-1.43-.16-1.98-.48a3.23 3.23 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.39 3.39 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23.42.15.8.38 1.11.7.33.31.58.71.77 1.2.18.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.08-.66-.22-.93a1.63 1.63 0 0 0-.61-.64 1.71 1.71 0 0 0-.9-.23c-.38 0-.7.09-.98.26-.28.18-.5.41-.65.7a2 2 0 0 0-.23.94v1.06c0 .44.08.83.24 1.14.16.32.39.56.68.73.3.16.64.25 1.03.25.26 0 .5-.04.7-.11.22-.08.4-.19.56-.34.15-.14.27-.32.35-.54l1.68.2c-.1.44-.3.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-.99.27-1.58.27Zm8.47-.15v-10.18h3.82c.78 0 1.44.14 1.97.44.53.29.93.69 1.2 1.2.28.5.42 1.08.42 1.73a3.6 3.6 0 0 1-.41 1.74c-.28.5-.68.9-1.22 1.2-.54.28-1.2.43-1.98.43h-2.54v-1.52h2.29c.45 0 .83-.08 1.12-.24.3-.15.5-.37.65-.65.14-.28.21-.6.21-.96s-.07-.68-.21-.96a1.45 1.45 0 0 0-.65-.64c-.3-.15-.67-.23-1.13-.23h-1.7V521h-1.84Zm10.73-10.18V521h-1.8v-10.18h1.8Zm4.05 10.33a3.2 3.2 0 0 1-1.3-.25 2.15 2.15 0 0 1-.92-.78 2.27 2.27 0 0 1-.34-1.26c0-.43.08-.79.24-1.07.16-.28.38-.5.65-.68.28-.17.59-.3.93-.38.35-.09.71-.15 1.08-.2l1.1-.12c.27-.04.47-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.8.09-1.05.28-.25.2-.43.42-.52.68l-1.68-.24a2.67 2.67 0 0 1 1.78-1.87 4.77 4.77 0 0 1 2.56-.11c.36.09.7.23 1 .43.3.2.54.46.72.8.19.34.28.76.28 1.27V521h-1.73v-1.05h-.06a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.47-1.32c.36 0 .67-.07.94-.21.26-.15.47-.34.6-.58.15-.24.23-.5.23-.78v-.9a.86.86 0 0 1-.3.13 13.22 13.22 0 0 1-.94.18l-.41.06c-.27.04-.51.1-.73.18-.2.09-.37.2-.5.35a.85.85 0 0 0-.18.57c0 .33.12.58.36.75.24.17.55.25.93.25Zm7.17-3.3V521h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.39-.25.87-.38 1.44-.38.52 0 .98.12 1.38.34.39.23.7.55.91.98.22.43.33.95.32 1.56V521h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.08-.43c-.32 0-.6.07-.84.2-.25.14-.44.34-.58.6a2 2 0 0 0-.2.94Zm8.53 0V521h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.39-.25.87-.38 1.44-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.32 1.56V521h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.08-.43c-.32 0-.6.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm6.73 4.47v-7.64h1.8V521h-1.8Zm.9-8.72c-.28 0-.52-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28s.53.1.73.28c.21.2.31.42.31.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm4.55 4.25V521h-1.8v-7.64h1.72v1.3h.1c.17-.43.45-.77.83-1.02.4-.25.87-.38 1.44-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V521h-1.8v-4.58c0-.51-.14-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.06 7.5a4.7 4.7 0 0 1-1.67-.27c-.46-.17-.84-.4-1.12-.7-.28-.29-.47-.61-.58-.97l1.62-.39c.07.15.17.3.31.44.14.15.33.27.57.37.24.1.53.15.9.15.5 0 .93-.12 1.26-.37.34-.25.5-.65.5-1.21v-1.45h-.08c-.1.18-.23.37-.41.57-.18.2-.41.36-.7.5a3.14 3.14 0 0 1-2.68-.21c-.48-.29-.86-.7-1.14-1.25a4.6 4.6 0 0 1-.42-2.08c0-.84.14-1.55.42-2.13a2.93 2.93 0 0 1 3.84-1.54c.29.15.52.33.7.54.17.21.3.41.39.6h.1v-1.27h1.77v7.76c0 .66-.15 1.2-.47 1.63-.3.42-.73.74-1.27.96a5 5 0 0 1-1.84.31Zm.01-4.55c.38 0 .7-.1.98-.28.26-.19.47-.45.6-.8.15-.35.22-.77.22-1.25s-.07-.9-.21-1.27a1.8 1.8 0 0 0-.6-.84c-.27-.2-.6-.3-.99-.3-.4 0-.73.1-1 .31s-.47.5-.6.86c-.14.37-.21.78-.21 1.24 0 .46.07.87.2 1.23.14.34.34.62.61.81.27.2.6.29 1 .29Z"
      />
      <path
        fill="#474E6B"
        d="M919.4 513.36v1h-3.96v-1h3.95Zm-2.8-1.83h1.16v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.8 9.65c-.48 0-.92-.1-1.31-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.05-.18l1.13-.14c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.1-.4a2.67 2.67 0 0 1 1.88-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V521h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.19-1.05c.46 0 .85-.1 1.17-.28a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.15.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.24.7c0 .41.16.72.46.93.3.2.69.3 1.16.3Zm10.87-5.06-1.06.3a1.96 1.96 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.77.34.33.5.77.5 1.3 0 .44-.12.83-.37 1.17-.25.35-.6.62-1.05.82-.44.2-.96.3-1.56.3-.77 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.7.3 1.17.3.55 0 .99-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.48-.28-.66a1.76 1.76 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.5-1.32c0-.43.13-.81.37-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Zm3 3.15-.02-1.46h.23l3.35-3.4h1.45l-3.56 3.6h-.1l-1.35 1.26Zm-1.1 2.78v-10.18h1.18V521h-1.18Zm4.86 0-2.99-3.78.84-.81 3.64 4.59h-1.5Zm10.02-7.64v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm7.58 9.63c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.05 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.05a2 2 0 0 0 1.3-.4c.33-.28.58-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.76-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07c-.16.45-.25.92-.25 1.43 0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Z"
      />
      <path
        fill="#14141F"
        d="M974.72 514.25h-1.86a2.33 2.33 0 0 0-.83-1.41 2.21 2.21 0 0 0-.72-.38 2.84 2.84 0 0 0-2.34.3c-.43.27-.76.67-1 1.2a4.67 4.67 0 0 0-.37 1.95c0 .78.12 1.43.36 1.97.25.53.58.93 1 1.2a2.94 2.94 0 0 0 2.32.28 2.32 2.32 0 0 0 1.27-.95c.15-.23.25-.5.31-.8l1.86.02a3.99 3.99 0 0 1-1.35 2.49c-.37.32-.8.57-1.3.75-.5.18-1.05.27-1.66.27a4.35 4.35 0 0 1-4.06-2.42c-.4-.78-.6-1.72-.6-2.81a6 6 0 0 1 .6-2.81 4.38 4.38 0 0 1 4.06-2.42c.57 0 1.1.08 1.58.24.49.16.92.39 1.3.7.38.3.7.68.94 1.12.25.44.41.95.49 1.51Zm4.94 6.9a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.05 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.33.97.78 1.27 1.38.3.6.45 1.28.45 2.07a4.5 4.5 0 0 1-.45 2.07c-.3.59-.72 1.05-1.27 1.38-.55.33-1.2.49-1.94.49Zm.01-1.44c.4 0 .74-.11 1.01-.34a2 2 0 0 0 .61-.9c.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.62.34 1.03.34Zm5.18 1.29v-7.64h1.72v1.3h.09c.16-.44.42-.78.79-1.02.37-.25.8-.38 1.31-.38.52 0 .96.13 1.31.38.36.25.61.59.76 1.02h.08c.17-.42.45-.76.85-1.01.4-.26.88-.39 1.44-.39.7 0 1.27.23 1.72.67.44.45.67 1.1.67 1.94V521h-1.8v-4.85c0-.47-.13-.82-.39-1.04a1.35 1.35 0 0 0-.92-.33c-.44 0-.78.14-1.02.4a1.5 1.5 0 0 0-.36 1.06V521h-1.77v-4.92c0-.4-.12-.71-.36-.95a1.25 1.25 0 0 0-.92-.35c-.26 0-.5.07-.7.2a1.4 1.4 0 0 0-.51.55c-.13.24-.2.51-.2.83V521h-1.8Zm12.56 2.86v-10.5h1.77v1.27h.1c.1-.19.23-.39.4-.6a2.16 2.16 0 0 1 1.79-.77c.59 0 1.12.15 1.59.46.48.3.86.74 1.14 1.32.28.59.42 1.3.42 2.15a5.1 5.1 0 0 1-.41 2.14 3.15 3.15 0 0 1-1.13 1.34c-.47.31-1.01.46-1.61.46-.43 0-.8-.07-1.09-.22a2.28 2.28 0 0 1-.7-.52c-.16-.21-.3-.4-.4-.6h-.07v4.07h-1.8Zm1.77-6.68c0 .5.07.93.2 1.3.15.37.35.66.62.87.26.2.59.3.97.3.4 0 .73-.1 1-.31.27-.22.47-.5.61-.88s.21-.8.21-1.28c0-.47-.07-.9-.21-1.26a1.85 1.85 0 0 0-.61-.87c-.26-.2-.6-.3-1-.3-.38 0-.71.1-.98.3-.27.2-.47.48-.61.84-.14.37-.2.8-.2 1.3Zm8.78-6.36V521h-1.8v-10.18h1.8Zm5.23 10.33c-.76 0-1.42-.16-1.98-.48a3.21 3.21 0 0 1-1.28-1.36 4.54 4.54 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.38 3.38 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23.42.15.79.38 1.11.7.33.31.58.71.77 1.2.18.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.53c0-.35-.08-.66-.22-.93a1.66 1.66 0 0 0-1.52-.87c-.37 0-.69.09-.97.26-.28.18-.49.41-.65.7-.15.29-.23.6-.23.94v1.06c0 .44.08.83.24 1.14.16.32.39.56.68.73.29.16.64.25 1.03.25.26 0 .5-.04.71-.11.21-.08.39-.19.55-.34.16-.14.27-.32.35-.54l1.68.2c-.1.44-.31.82-.6 1.15-.3.33-.68.59-1.14.77a4.3 4.3 0 0 1-1.58.27Zm8.73-7.79v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.11.56.07.13.17.21.29.26.13.05.26.07.41.07a2.03 2.03 0 0 0 .53-.07l.3 1.4a3.35 3.35 0 0 1-1.06.18c-.45.02-.85-.05-1.21-.2a1.84 1.84 0 0 1-.86-.7 2.05 2.05 0 0 1-.31-1.2v-7.47Zm8.11 9.62c-.77 0-1.43-.16-1.99-.48a3.2 3.2 0 0 1-1.27-1.36 4.54 4.54 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.38 3.38 0 0 1 3.16-1.9c.47 0 .92.08 1.34.23.42.15.79.38 1.11.7.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54a1.97 1.97 0 0 0-.23-.93 1.6 1.6 0 0 0-.61-.64 1.72 1.72 0 0 0-.9-.23 1.78 1.78 0 0 0-1.62.96 2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11a1.45 1.45 0 0 0 .91-.88l1.68.2c-.11.44-.31.82-.61 1.15-.29.33-.67.59-1.13.77-.46.18-.99.27-1.58.27Zm7.75-.02c-.6 0-1.14-.15-1.61-.46-.48-.3-.85-.75-1.13-1.34a5.1 5.1 0 0 1-.41-2.14c0-.85.14-1.56.42-2.15a2.93 2.93 0 0 1 3.84-1.55c.29.15.51.33.68.54.17.21.3.41.4.6h.07v-3.81h1.81V521h-1.77v-1.2h-.11c-.1.18-.23.38-.41.59-.17.2-.4.38-.69.52a2.4 2.4 0 0 1-1.09.22Zm.5-1.47c.38 0 .71-.1.98-.31.26-.2.47-.5.61-.87s.21-.8.21-1.3-.07-.92-.21-1.29a1.86 1.86 0 0 0-.61-.85c-.26-.2-.59-.3-.98-.3-.4 0-.73.1-1 .31s-.47.5-.61.87-.2.79-.2 1.26c0 .48.06.9.2 1.28.14.37.34.66.61.88.27.21.61.32 1 .32Z"
      />
      <path fill="url(#pattern5)" d="M1043.01 521.98h14v-14h-14v14Z" />
      <path
        fill="#474E6B"
        d="m1068.48 515.07-1.05.3a2.4 2.4 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3.99.42l1.13.27c.69.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.12.83-.38 1.17-.24.35-.59.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.2 2.2 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.69.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85a.87.87 0 0 0-.28-.66 1.74 1.74 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.89 1.89 0 0 1-.49-1.32c0-.43.13-.81.37-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.23-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.43 2.43 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.93 1.93 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.32-.27-.39-.19-.7-.46-.94-.8a2.27 2.27 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.41-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18l1.13-.14c.29-.03.5-.09.63-.16.14-.08.21-.21.21-.4v-.04c0-.5-.14-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4c.19-.46.46-.82.79-1.08.34-.26.7-.44 1.09-.55a4.57 4.57 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V521h-1.17v-1.03h-.06a2.2 2.2 0 0 1-1.14 1.01c-.31.13-.68.2-1.13.2Zm.18-1.05c.46 0 .86-.1 1.17-.28.33-.18.57-.42.73-.7.17-.3.25-.6.25-.91v-1.08c-.05.06-.16.12-.33.17a5.78 5.78 0 0 1-1.21.21l-.49.06c-.31.04-.59.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.69.3 1.16.3Zm8.55 3.9a4.4 4.4 0 0 1-1.47-.23c-.4-.14-.74-.33-1.02-.56a3.3 3.3 0 0 1-.64-.75l.94-.65c.1.13.24.3.4.47.16.19.38.34.67.48.28.13.65.2 1.12.2.61 0 1.12-.15 1.52-.45.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.21.31-.36.51-.16.2-.39.39-.68.55-.29.15-.69.23-1.18.23a3.02 3.02 0 0 1-2.82-1.71 4.47 4.47 0 0 1-.43-2.03c0-.78.14-1.46.42-2.04a3.02 3.02 0 0 1 2.85-1.84 2.18 2.18 0 0 1 1.86.8c.15.22.28.38.36.52h.12v-1.22h1.14v7.86c0 .65-.15 1.19-.45 1.6-.3.41-.69.72-1.19.9-.5.2-1.05.3-1.66.3Zm-.04-4.2c.47 0 .86-.11 1.19-.33.32-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.25-1.46a2.17 2.17 0 0 0-.73-.98 1.99 1.99 0 0 0-1.2-.36 2 2 0 0 0-1.25.38c-.33.25-.57.59-.74 1.01-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.17.41.41.73.74.96.33.23.75.35 1.24.35Zm8.69 1.33a3.29 3.29 0 0 1-3.14-1.86 4.75 4.75 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07a3.22 3.22 0 0 1 3.02-1.9c.39 0 .79.06 1.17.2a2.97 2.97 0 0 1 1.82 1.82c.19.48.29 1.08.29 1.8v.49h-5.89v-1.01h4.69c0-.44-.08-.82-.25-1.16-.17-.34-.41-.6-.73-.8-.31-.2-.68-.3-1.1-.3-.47 0-.88.12-1.22.36a2.42 2.42 0 0 0-1.05 2.07v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13a1.72 1.72 0 0 0 1.07-1.06l1.14.31c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.05.68-.41.16-.88.24-1.39.24Zm5.8-.08a.84.84 0 0 1-.63-.26.85.85 0 0 1-.27-.64c0-.24.09-.45.27-.63a.84.84 0 0 1 .63-.26.88.88 0 0 1 .89.9c0 .16-.04.3-.12.44a.98.98 0 0 1-.32.33.9.9 0 0 1-.45.12Z"
      />
      <path
        fill="#DEE5ED"
        d="M1120 543H560v2h560v-2Z"
        mask="url(#path-131-inside-7_1_3812)"
      />
      <rect
        width={48}
        height={48}
        x={560}
        y={560}
        fill="url(#pattern6)"
        rx={4}
      />
      <path
        fill="#6C7793"
        d="M624.3 563.27h1.22l2.42 4.08h.1l2.42-4.08h1.21l-3.15 5.13v3.6h-1.06v-3.6l-3.15-5.13Zm10.42 8.87a2.8 2.8 0 0 1-2.68-1.6 4 4 0 0 1-.37-1.76c0-.67.12-1.26.37-1.77a2.77 2.77 0 0 1 2.58-1.64c.34 0 .67.06 1 .17.34.11.64.3.91.55.28.26.5.6.66 1 .16.43.24.94.24 1.55v.43h-5.05v-.87h4.03c0-.37-.08-.7-.23-.99a1.67 1.67 0 0 0-1.56-.94c-.4 0-.75.1-1.04.3-.3.2-.51.45-.67.77-.16.31-.24.65-.24 1.01v.58c0 .5.09.92.26 1.26.17.34.41.6.72.78.3.17.66.26 1.07.26.26 0 .5-.03.71-.1.22-.09.4-.2.56-.35.16-.15.28-.34.37-.57l.97.27c-.1.33-.28.62-.52.87s-.54.44-.9.58c-.35.14-.75.2-1.2.2Zm8.88-5.22-.9.26c-.06-.15-.15-.3-.26-.44-.1-.15-.26-.27-.44-.36-.19-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.1.45.27.6.19.14.47.26.86.36l.97.23c.58.14 1.02.36 1.3.65.3.3.44.67.44 1.13 0 .37-.11.7-.33 1-.21.3-.51.53-.9.7-.38.17-.82.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.95-.24c.1.35.27.62.52.8.26.17.59.26 1 .26.47 0 .84-.1 1.12-.3.28-.2.41-.44.41-.72a.76.76 0 0 0-.23-.57c-.16-.16-.4-.28-.74-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.31-.98.22-.28.5-.5.86-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.42.38.29.64.67.8 1.13Zm4.48-1.46v.85h-3.4v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.04.5.12.63.09.14.2.24.33.28.13.05.27.07.42.07l.27-.01.17-.04.2.9a2.16 2.16 0 0 1-1.58-.06c-.27-.12-.5-.3-.67-.56a1.6 1.6 0 0 1-.27-.94v-6.51Zm6.58 8.25a2.8 2.8 0 0 1-2.68-1.6 4 4 0 0 1-.37-1.76c0-.67.12-1.26.37-1.77a2.77 2.77 0 0 1 2.58-1.64c.34 0 .68.06 1.01.17a2.5 2.5 0 0 1 1.56 1.56c.16.42.24.93.24 1.54v.43h-5.04v-.87h4.02c0-.37-.07-.7-.22-.99a1.67 1.67 0 0 0-1.57-.94c-.4 0-.75.1-1.04.3-.29.2-.51.45-.67.77-.16.31-.23.65-.23 1.01v.58c0 .5.08.92.25 1.26.18.34.42.6.72.78.31.17.67.26 1.07.26.27 0 .5-.03.72-.1.21-.09.4-.2.56-.35.15-.15.27-.34.36-.57l.97.27c-.1.33-.27.62-.51.87-.25.25-.54.44-.9.58-.36.14-.75.2-1.2.2Zm4.24-.14v-6.54h.97v.98h.07c.12-.32.34-.58.65-.79.31-.2.66-.3 1.06-.3a10.86 10.86 0 0 1 .52.02v1.02a3.3 3.3 0 0 0-.6-.07c-.33 0-.61.07-.86.2s-.44.32-.59.55c-.14.23-.21.5-.21.79V572h-1Zm6.74.14a2.56 2.56 0 0 1-2.42-1.6c-.24-.5-.36-1.1-.36-1.8 0-.68.12-1.28.36-1.78a2.6 2.6 0 0 1 2.44-1.59c.42 0 .76.07 1 .21.26.14.45.3.58.48.13.18.24.32.3.43h.1v-3.22h1V572h-.97v-1h-.12a6.2 6.2 0 0 1-.32.45c-.13.17-.33.34-.58.48-.25.14-.59.2-1.01.2Zm.14-.9c.4 0 .74-.11 1.02-.32.28-.21.49-.5.63-.88.15-.38.22-.82.22-1.31 0-.5-.07-.92-.21-1.28a1.67 1.67 0 0 0-1.66-1.17c-.43 0-.78.1-1.07.32-.28.22-.5.51-.63.88-.14.37-.21.79-.21 1.25 0 .46.07.89.21 1.27.15.38.36.68.64.9.28.22.64.33 1.06.33Zm6.77.91c-.42 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.14-.24.34-.42.59-.55.25-.14.52-.24.82-.3.3-.07.6-.12.9-.16.4-.06.72-.1.97-.12.25-.03.43-.07.55-.14.11-.07.17-.18.17-.34v-.03c0-.43-.11-.75-.34-.99-.23-.23-.58-.34-1.04-.34-.48 0-.86.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.54.14.8.3.26.15.47.38.64.7.17.3.26.72.26 1.24V572h-1v-.89h-.06c-.07.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.6.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.08-.4.19-.54.34a.85.85 0 0 0-.21.6c0 .35.13.62.39.8.26.17.59.26 1 .26Zm5.1 3.2a2.24 2.24 0 0 1-.74-.12l.26-.88c.24.06.46.08.65.07.18-.02.35-.1.5-.25a2 2 0 0 0 .4-.73l.19-.5-2.42-6.58h1.09l1.8 5.21h.07l1.81-5.21h1.1l-2.79 7.5c-.12.33-.28.61-.46.83-.19.23-.4.4-.65.5-.24.11-.51.17-.81.17Zm11.33-2.3c-.41 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.59-.55.25-.14.52-.24.82-.3.3-.07.6-.12.9-.16.4-.06.73-.1.97-.12.25-.03.43-.07.55-.14.12-.07.17-.18.17-.34v-.03c0-.43-.11-.75-.34-.99-.23-.23-.57-.34-1.04-.34-.48 0-.85.1-1.13.31-.27.21-.46.44-.57.67l-.96-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.55.14.8.3.26.15.47.38.64.7.17.3.26.72.26 1.24V572h-1v-.89h-.06c-.07.15-.18.3-.34.46-.16.16-.37.3-.63.41-.27.12-.59.17-.97.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.08-.4.19-.54.34a.85.85 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm7.53-5.8v.86h-3.39v-.85h3.4Zm-2.4-1.56h1v6.24c0 .28.04.5.13.63.08.14.2.24.32.28.13.05.27.07.42.07l.28-.01.17-.04.2.9a2.16 2.16 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm7.07 6.32v-.87l3.83-6.07h.63v1.35h-.42l-2.9 4.59v.06h5.16v.94h-6.3Zm4.1 1.79v-8.73h1.01V572h-1Zm4.55-1.12a.74.74 0 0 1-.54-.22.74.74 0 0 1-.23-.54c0-.21.08-.4.23-.54a.74.74 0 0 1 .54-.23c.21 0 .4.07.54.23.15.15.23.33.23.54 0 .14-.04.26-.1.38a.8.8 0 0 1-.28.28.73.73 0 0 1-.39.1Zm0-4.41a.74.74 0 0 1-.54-.23.74.74 0 0 1-.23-.54c0-.2.08-.39.23-.54a.74.74 0 0 1 .54-.23c.21 0 .4.08.54.23.15.15.23.33.23.54 0 .14-.04.27-.1.38a.78.78 0 0 1-.28.29.72.72 0 0 1-.39.1Zm5.5 5.65c-.56 0-1.06-.1-1.5-.29-.44-.2-.78-.46-1.04-.8-.26-.35-.4-.75-.42-1.21h1.07c.03.28.12.52.3.73.16.2.39.36.66.47.28.1.58.16.92.16.37 0 .7-.06 1-.2.28-.13.51-.3.68-.54.16-.23.24-.5.24-.8 0-.33-.07-.61-.23-.86a1.6 1.6 0 0 0-.7-.58c-.31-.14-.69-.2-1.13-.2h-.7v-.94h.7c.35 0 .65-.07.91-.2.27-.12.47-.3.62-.52.15-.23.23-.5.23-.8 0-.3-.07-.55-.2-.77a1.34 1.34 0 0 0-.55-.51 1.8 1.8 0 0 0-.84-.19c-.3 0-.58.06-.85.17-.26.1-.48.27-.65.47-.16.2-.26.45-.27.75h-1.02c.01-.46.15-.86.41-1.2.26-.35.6-.62 1.01-.82a3.28 3.28 0 0 1 2.78.04 2.3 2.3 0 0 1 1.2 2 1.97 1.97 0 0 1-1.43 1.98v.07c.55.1.98.33 1.29.7.3.38.46.85.46 1.4 0 .48-.13.9-.38 1.28-.26.37-.6.67-1.05.88-.45.22-.95.33-1.51.33Zm7.42 0a3 3 0 0 1-1.35-.3c-.4-.2-.72-.47-.96-.82a2.24 2.24 0 0 1-.4-1.18h1.03c.04.4.21.72.53.98.33.25.7.38 1.15.38a1.81 1.81 0 0 0 1.62-.94c.16-.3.24-.63.24-1 0-.38-.08-.72-.25-1.02a1.84 1.84 0 0 0-1.67-.98 2.74 2.74 0 0 0-1.52.45l-.99-.12.53-4.3h4.53v.94h-3.64l-.31 2.57h.05a2.57 2.57 0 0 1 1.52-.5 2.69 2.69 0 0 1 2.41 1.43c.24.44.37.95.37 1.51s-.13 1.06-.38 1.5c-.25.43-.59.77-1.02 1.02-.44.25-.93.38-1.49.38Zm4.6 2.34v-9h.97v1.03h.12l.3-.43a1.82 1.82 0 0 1 1.59-.7 2.6 2.6 0 0 1 2.44 1.6c.24.5.35 1.1.35 1.78 0 .7-.12 1.3-.35 1.8a2.56 2.56 0 0 1-2.42 1.59 2.1 2.1 0 0 1-1.01-.2c-.26-.14-.45-.3-.59-.48a6.15 6.15 0 0 1-.31-.46h-.09v3.47h-1Zm.98-5.73c0 .5.08.93.22 1.3.15.38.36.68.64.89.27.2.62.31 1.02.31.42 0 .77-.1 1.05-.33.29-.22.5-.52.64-.9.15-.38.22-.8.22-1.27 0-.46-.07-.88-.22-1.25a1.92 1.92 0 0 0-.63-.88 1.67 1.67 0 0 0-1.06-.33 1.67 1.67 0 0 0-1.66 1.18c-.15.36-.22.79-.22 1.28Zm6.33 3.27v-6.54h.97v1.02h.08c.14-.35.36-.62.66-.82.3-.2.67-.3 1.1-.3.43 0 .8.1 1.08.3.29.2.51.47.67.82h.07c.17-.34.42-.6.76-.8.33-.21.73-.31 1.2-.31.59 0 1.07.18 1.44.55.37.36.56.93.56 1.7V572h-1v-4.38c0-.48-.14-.83-.4-1.04-.27-.2-.58-.3-.94-.3-.46 0-.81.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V572h-1.02v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.93-.35c-.27 0-.51.07-.74.21-.22.14-.4.33-.54.58-.14.25-.2.53-.2.85V572h-1.01Z"
      />
      <circle cx={636} cy={596} r={12} fill="url(#pattern7)" />
      <path
        fill="#14141F"
        d="M653 590.82h2.26l3.02 7.38h.12l3.03-7.38h2.25V601h-1.77v-7h-.1l-2.8 6.97h-1.33l-2.81-6.98h-.1V601H653v-10.18ZM665.61 601v-7.64h1.8V601h-1.8Zm.9-8.72c-.28 0-.52-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28.28 0 .53.1.73.28.2.2.31.42.31.7 0 .26-.1.5-.3.69-.2.18-.46.28-.74.28Zm2.75 8.72v-7.64h1.75v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.15 4.15 0 0 1 .65.05v1.66a3.38 3.38 0 0 0-.84-.1c-.33 0-.62.07-.88.2a1.56 1.56 0 0 0-.84 1.45V601h-1.8Zm7.61.15c-.48 0-.92-.08-1.3-.25a2.14 2.14 0 0 1-.92-.78 2.27 2.27 0 0 1-.33-1.26c0-.43.08-.79.24-1.07.16-.28.37-.5.65-.68.27-.17.58-.3.93-.38.35-.09.7-.15 1.08-.2l1.09-.12c.27-.04.48-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.79.09-1.04.28-.26.2-.43.42-.52.68l-1.68-.24a2.68 2.68 0 0 1 1.77-1.87 4.77 4.77 0 0 1 2.56-.11c.37.09.7.23 1 .43.3.2.55.46.73.8.18.34.28.76.28 1.27V601h-1.73v-1.05h-.06a2.2 2.2 0 0 1-1.2 1.04 3 3 0 0 1-1.05.16Zm.47-1.32c.36 0 .68-.07.94-.21.27-.15.47-.34.61-.58.15-.24.22-.5.22-.78v-.9a.85.85 0 0 1-.29.13 12.93 12.93 0 0 1-.94.18l-.42.06c-.27.04-.5.1-.72.18-.21.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.13.58.37.75.24.17.55.25.92.25Zm8.93 1.17v-10.18h3.9c.73 0 1.34.11 1.83.35.5.23.86.54 1.1.94.24.4.37.84.37 1.35a2 2 0 0 1-.88 1.77c-.27.18-.57.32-.9.4v.1a2.31 2.31 0 0 1 1.86 1.18c.2.36.31.8.31 1.32s-.12 1-.38 1.42a2.6 2.6 0 0 1-1.15.99c-.51.24-1.16.36-1.94.36h-4.12Zm1.84-1.54h1.99c.67 0 1.15-.13 1.44-.38.3-.26.45-.6.45-1a1.52 1.52 0 0 0-.86-1.39 2.1 2.1 0 0 0-.98-.21h-2.04v2.98Zm0-4.31h1.83c.31 0 .6-.06.86-.18a1.34 1.34 0 0 0 .82-1.28c0-.39-.14-.71-.41-.97-.28-.25-.69-.38-1.23-.38h-1.87v2.8Zm10.61 6a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.73-1.05 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.75 0 1.4.17 1.94.5.55.33.97.78 1.27 1.38.3.6.45 1.28.45 2.07 0 .79-.15 1.48-.45 2.07a3.3 3.3 0 0 1-1.27 1.38c-.55.33-1.2.49-1.94.49Zm.01-1.44c.4 0 .74-.11 1.01-.34a2 2 0 0 0 .61-.9c.14-.38.2-.8.2-1.26 0-.47-.06-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.41 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.62.34 1.03.34Zm8.99-6.35v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.12.05.26.07.4.07a1.73 1.73 0 0 0 .54-.07l.3 1.4a3.9 3.9 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7c-.2-.32-.3-.72-.3-1.2v-7.47Zm6.77 5V601h-1.8v-10.18h1.76v3.84h.09c.18-.43.46-.77.83-1.02.38-.25.86-.38 1.44-.38.53 0 1 .12 1.39.34.4.22.7.54.91.97.22.43.33.95.33 1.57V601h-1.8v-4.58c0-.52-.13-.92-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.86.2-.24.14-.44.34-.58.6-.14.25-.21.57-.21.94Zm6.78 4.47v-7.64h1.73v1.3h.08c.16-.44.43-.78.8-1.02.36-.25.8-.38 1.31-.38.52 0 .96.13 1.31.38.36.25.61.59.76 1.02h.08c.17-.42.45-.76.85-1.01.4-.26.88-.39 1.44-.39.7 0 1.27.23 1.72.67.44.45.66 1.1.66 1.94V601h-1.8v-4.85c0-.47-.13-.82-.38-1.04a1.35 1.35 0 0 0-.92-.33c-.44 0-.78.14-1.02.4a1.5 1.5 0 0 0-.37 1.06V601h-1.76v-4.92c0-.4-.12-.71-.36-.95a1.25 1.25 0 0 0-.92-.35c-.26 0-.5.07-.7.2a1.4 1.4 0 0 0-.52.55c-.12.24-.19.51-.19.83V601h-1.8Zm14.77.15c-.49 0-.92-.08-1.31-.25a2.14 2.14 0 0 1-.91-.78 2.27 2.27 0 0 1-.34-1.26c0-.43.08-.79.24-1.07.16-.28.38-.5.65-.68.28-.17.59-.3.93-.38.35-.09.7-.15 1.08-.2l1.09-.12c.28-.04.48-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.11-.67-.33-.87-.23-.2-.54-.3-.96-.3-.44 0-.8.09-1.05.28-.26.2-.43.42-.52.68l-1.68-.24a2.67 2.67 0 0 1 1.78-1.87 4.77 4.77 0 0 1 2.56-.11c.36.09.7.23 1 .43.3.2.54.46.72.8.19.34.28.76.28 1.27V601h-1.73v-1.05h-.06a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.47-1.32c.36 0 .67-.07.93-.21.27-.15.47-.34.62-.58.14-.24.22-.5.22-.78v-.9a.87.87 0 0 1-.3.13 13.22 13.22 0 0 1-1.36.24c-.26.04-.5.1-.72.18-.2.09-.38.2-.5.35a.85.85 0 0 0-.18.57c0 .33.12.58.36.75.24.17.55.25.93.25Zm7.17-3.3V601h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.39-.25.87-.38 1.44-.38.52 0 .98.12 1.37.34.4.23.7.55.92.98.22.43.32.95.32 1.56V601h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.59.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Z"
      />
      <path
        fill="#474E6B"
        d="M752.07 601v-7.64h1.14v1.2h.1c.16-.41.41-.73.77-.95.35-.23.78-.35 1.27-.35.5 0 .93.12 1.26.35.34.22.6.54.8.95h.07c.2-.4.5-.71.88-.94.4-.24.86-.36 1.41-.36.68 0 1.24.22 1.68.65.43.42.65 1.08.65 1.98V601h-1.18v-5.11c0-.56-.15-.97-.46-1.2-.3-.25-.67-.37-1.09-.37-.53 0-.95.16-1.25.48-.3.33-.44.74-.44 1.23V601h-1.2v-5.23c0-.43-.13-.78-.41-1.05-.29-.27-.65-.4-1.1-.4-.3 0-.58.08-.85.24-.26.16-.47.39-.63.68a2 2 0 0 0-.24.99V601h-1.18Zm15.27.16c-.69 0-1.29-.16-1.81-.5a3.34 3.34 0 0 1-1.21-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.15-1.49.44-2.08.29-.6.7-1.05 1.2-1.38.53-.33 1.13-.5 1.82-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.22 1.38.29.6.43 1.29.43 2.08s-.14 1.48-.43 2.07a3.3 3.3 0 0 1-1.22 1.38 3.3 3.3 0 0 1-1.8.49Zm0-1.05c.53 0 .96-.14 1.3-.4.34-.28.59-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.29.4 2.4 2.4 0 0 0-.75 1.07c-.16.45-.24.92-.24 1.43 0 .51.08.99.24 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Zm11.23-6.75-2.83 7.64h-1.2l-2.81-7.64H773l2.1 6.09h.09l2.1-6.09h1.28Zm4.47 7.8a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.15-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.9v-1.01h4.7c0-.44-.08-.82-.26-1.16a1.95 1.95 0 0 0-1.83-1.1c-.46 0-.87.12-1.2.36-.35.23-.6.52-.79.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.31 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.14.32c-.12.38-.32.72-.6 1.01-.29.3-.64.52-1.05.68-.41.16-.88.24-1.4.24Zm7.83 0a3 3 0 0 1-2.83-1.86c-.27-.59-.4-1.29-.4-2.1 0-.8.13-1.5.4-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.16.51.35.67.56l.36.5h.1v-3.75h1.17V601h-1.13v-1.17h-.14c-.09.14-.2.31-.37.52-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.05c.47 0 .87-.13 1.2-.37.32-.25.57-.6.74-1.03.16-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.25.91-.25 1.45 0 .55.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Zm12.91-6.75v1H800v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.31.08.49.08l.31-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.31-.65-.31-1.1v-7.6Zm5.9 4.88V601h-1.17v-10.18h1.18v3.74h.1c.17-.4.44-.71.8-.94.36-.24.84-.36 1.44-.36.52 0 .98.1 1.37.32.4.2.7.52.91.95.22.42.33.96.33 1.62V601h-1.18v-4.77c0-.6-.15-1.08-.47-1.41-.3-.33-.74-.5-1.3-.5-.38 0-.72.08-1.03.24-.3.16-.54.4-.72.71a2.3 2.3 0 0 0-.25 1.14Zm10.3 4.75a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07.3-.6.7-1.06 1.2-1.4a3.61 3.61 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.88.12-1.22.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13.25-.1.47-.23.65-.4.18-.18.33-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Z"
      />
      <path
        fill="#14141F"
        d="M830.46 601H827v-10.18h3.52c1.01 0 1.88.2 2.6.61.74.4 1.3.99 1.69 1.75.4.75.59 1.66.59 2.72a5.9 5.9 0 0 1-.6 2.73c-.39.77-.95 1.35-1.7 1.76a5.4 5.4 0 0 1-2.64.61Zm-1.61-1.6h1.51c.71 0 1.3-.13 1.78-.38.47-.27.83-.65 1.07-1.17.24-.52.36-1.17.36-1.95s-.12-1.43-.36-1.94c-.24-.52-.6-.9-1.06-1.16a3.51 3.51 0 0 0-1.73-.39h-1.57v7Zm8.3 1.6v-10.18h3.9c.73 0 1.34.11 1.83.35.5.23.86.54 1.1.94.25.4.37.84.37 1.35a2 2 0 0 1-.88 1.77c-.27.18-.57.32-.9.4v.1a2.31 2.31 0 0 1 1.86 1.18c.2.36.31.8.31 1.32s-.12 1-.38 1.42c-.25.42-.64.75-1.15.99-.51.24-1.16.36-1.94.36h-4.12Zm1.84-1.54h1.99c.67 0 1.15-.13 1.44-.38.3-.26.45-.6.45-1a1.52 1.52 0 0 0-.86-1.39 2.1 2.1 0 0 0-.98-.21h-2.04v2.98Zm0-4.31h1.83c.32 0 .6-.06.86-.18.25-.12.45-.28.6-.5.15-.22.22-.48.22-.77 0-.4-.14-.72-.41-.98-.28-.25-.69-.38-1.23-.38h-1.87v2.8Zm12.14 5.85h-1.97l3.59-10.18h2.27l3.6 10.18h-1.98l-2.72-8.1h-.07l-2.72 8.1Zm.07-4h5.36v1.49h-5.36V597Zm13.54.79v-4.43h1.8V601h-1.74v-1.36h-.08a2.3 2.3 0 0 1-.85 1.05c-.4.27-.88.4-1.45.4-.5 0-.94-.1-1.33-.32a2.32 2.32 0 0 1-.9-.98 3.47 3.47 0 0 1-.32-1.56v-4.87h1.8v4.59c0 .48.14.87.4 1.15.27.29.61.43 1.04.43.27 0 .53-.07.78-.2s.45-.32.6-.57c.17-.26.25-.58.25-.97Zm6.49 3.34a2.89 2.89 0 0 1-2.74-1.8 5.01 5.01 0 0 1-.41-2.14c0-.85.14-1.56.42-2.15a2.93 2.93 0 0 1 3.84-1.55c.28.15.51.33.68.54.17.21.3.41.4.6h.07v-3.81h1.8V601h-1.77v-1.2h-.1c-.1.18-.23.38-.41.59a2.2 2.2 0 0 1-1.78.74Zm.5-1.47c.38 0 .7-.1.97-.31.27-.2.47-.5.61-.87s.21-.8.21-1.3-.07-.92-.2-1.29a1.84 1.84 0 0 0-.61-.85c-.27-.2-.6-.3-.98-.3-.4 0-.74.1-1 .31-.27.21-.48.5-.61.87-.14.37-.2.79-.2 1.26 0 .48.06.9.2 1.28a2 2 0 0 0 .6.88c.28.21.61.32 1 .32Zm5.48 1.34v-7.64h1.8V601h-1.8Zm.9-8.72c-.28 0-.53-.1-.73-.28a.91.91 0 0 1-.3-.7c0-.27.1-.5.3-.69.2-.19.45-.28.74-.28.28 0 .53.1.73.28.2.2.3.42.3.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm6.56 1.08v1.4h-4.39v-1.4h4.4Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.73 1.73 0 0 0 .53-.07l.3 1.4a3.83 3.83 0 0 1-1.06.18c-.45.02-.85-.05-1.21-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.31-1.2v-7.47Z"
      />
      <path
        fill="#474E6B"
        d="M893.96 601.16a3 3 0 0 1-2.83-1.86c-.28-.59-.41-1.29-.41-2.1 0-.8.13-1.5.4-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.19.25.29.16.5.35.66.56a9 9 0 0 1 .36.5h.1v-3.75h1.18V601h-1.14v-1.17h-.14c-.08.14-.2.31-.36.52-.16.21-.39.4-.68.56-.3.17-.7.25-1.18.25Zm.16-1.05c.47 0 .87-.13 1.19-.37.32-.25.57-.6.74-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.24.91-.24 1.45 0 .55.08 1.04.25 1.48.17.44.41.8.74 1.06.34.26.75.38 1.24.38Zm8.85 1.05a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.43-2.06c0-.78.14-1.47.43-2.07a3.23 3.23 0 0 1 3.01-1.9c.4 0 .8.06 1.18.2a2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .28 1.8v.5h-5.88v-1.01h4.69c0-.44-.09-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.87.12-1.21.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.83.9.36.21.78.32 1.25.32.3 0 .59-.05.84-.13.25-.1.47-.23.65-.4.18-.18.32-.4.42-.67l1.13.32a2.5 2.5 0 0 1-.6 1.01c-.28.3-.63.52-1.04.68-.42.16-.88.24-1.4.24Zm7.2.02c-.49 0-.93-.1-1.32-.27-.4-.19-.71-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.69-.65.29-.15.6-.27.95-.35.36-.07.7-.14 1.06-.18l1.13-.14c.3-.03.5-.09.64-.16.13-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.27-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.11-.4a2.67 2.67 0 0 1 1.89-1.63 4.53 4.53 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V601h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.13.2Zm.17-1.05c.47 0 .86-.1 1.18-.28a1.87 1.87 0 0 0 .97-1.61v-1.08c-.05.06-.16.12-.33.17l-.57.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.48.21-.64.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.7.3 1.16.3Zm6.64-9.31V601h-1.17v-10.18h1.17Zm9.49 2.54v1h-4.12v-1h4.12Zm-2.89 7.64v-8.69c0-.44.1-.8.31-1.1.2-.29.47-.5.8-.65a2.91 2.91 0 0 1 2.15-.02l-.33 1.01a5.44 5.44 0 0 0-.25-.07c-.1-.03-.24-.05-.41-.05-.39 0-.67.1-.84.3-.17.2-.25.48-.25.86V601h-1.18Zm7.32.16c-.7 0-1.3-.16-1.82-.5a3.34 3.34 0 0 1-1.2-1.37 4.66 4.66 0 0 1-.44-2.07c0-.8.14-1.49.43-2.08.3-.6.7-1.05 1.21-1.38.52-.33 1.13-.5 1.82-.5.69 0 1.3.17 1.8.5.53.33.93.78 1.22 1.38.3.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38 3.3 3.3 0 0 1-1.81.49Zm0-1.05c.52 0 .95-.14 1.3-.4.33-.28.58-.63.74-1.07a4.08 4.08 0 0 0 0-2.85 2.4 2.4 0 0 0-.75-1.06 2 2 0 0 0-1.3-.41 2 2 0 0 0-1.28.4c-.34.28-.6.63-.75 1.07a4.1 4.1 0 0 0-.25 1.43c0 .51.08.99.25 1.42.16.44.4.8.75 1.06.33.27.76.4 1.29.4Zm5.25.89v-7.64h1.13v1.16h.08c.14-.38.4-.69.76-.92.36-.24.77-.36 1.23-.36a14.75 14.75 0 0 1 .62.02v1.2a3.7 3.7 0 0 0-.72-.08c-.37 0-.7.08-1 .23a1.71 1.71 0 0 0-.94 1.56V601h-1.16Z"
      />
      <path
        fill="#14141F"
        d="M947.85 590.82V601H946v-10.18h1.85Zm3.72 5.7V601h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.38-.25.86-.38 1.43-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V601h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm6.73 4.48v-7.64h1.8V601h-1.8Zm.9-8.72c-.28 0-.53-.1-.73-.28a.91.91 0 0 1-.31-.7c0-.27.1-.5.3-.69.21-.19.46-.28.74-.28.3 0 .54.1.74.28.2.2.3.42.3.7 0 .26-.1.5-.3.69-.2.18-.45.28-.74.28Zm6.56 1.08v1.4h-4.39v-1.4h4.4Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.73 1.73 0 0 0 .53-.07l.3 1.4a3.9 3.9 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7c-.2-.32-.3-.72-.3-1.2v-7.47Zm8.1 9.62c-.76 0-1.42-.16-1.98-.48a3.24 3.24 0 0 1-1.28-1.36 4.57 4.57 0 0 1-.44-2.08c0-.79.15-1.48.44-2.07a3.38 3.38 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23.42.15.8.38 1.12.7.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.63 1.63 0 0 0-.61-.64 1.71 1.71 0 0 0-.9-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.38.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.34.16-.14.28-.32.36-.54l1.68.2c-.11.44-.31.82-.61 1.15-.3.33-.67.59-1.13.77-.47.18-1 .27-1.58.27Zm8.25 0a3.36 3.36 0 0 1-3.22-1.89c-.29-.6-.44-1.28-.44-2.05 0-.77.15-1.46.45-2.05a3.35 3.35 0 0 1 3.2-1.9c.62 0 1.17.12 1.65.35a2.8 2.8 0 0 1 1.64 2.4h-1.73a1.64 1.64 0 0 0-.5-.92c-.25-.25-.6-.37-1.03-.37-.37 0-.7.1-.97.3-.28.19-.5.47-.65.84-.15.37-.23.8-.23 1.32s.08.97.23 1.34c.15.38.37.66.64.86.28.2.6.3.98.3.26 0 .5-.05.71-.15.21-.1.39-.25.53-.44.14-.2.24-.43.3-.7h1.72a2.82 2.82 0 0 1-1.6 2.41c-.48.23-1.04.35-1.68.35Zm6.55-4.62V601h-1.8v-10.18h1.76v3.84h.1c.17-.43.45-.77.82-1.02.38-.25.86-.38 1.44-.38.54 0 1 .12 1.4.34.39.22.7.54.9.97.23.43.34.95.34 1.57V601h-1.8v-4.58c0-.52-.14-.92-.4-1.2a1.41 1.41 0 0 0-1.1-.43c-.32 0-.61.07-.86.2-.25.14-.45.34-.59.6-.14.25-.2.57-.2.94Z"
      />
      <path
        fill="#474E6B"
        d="M1000.39 593.36v1h-3.95v-1h3.95Zm-2.8-1.83h1.17v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.43 2.43 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm7.59 9.63c-.69 0-1.29-.16-1.81-.5a3.33 3.33 0 0 1-1.22-1.37 4.64 4.64 0 0 1-.43-2.07c0-.8.14-1.49.43-2.08.29-.6.7-1.05 1.22-1.38.52-.33 1.12-.5 1.81-.5s1.29.17 1.81.5c.52.33.92.78 1.21 1.38.29.6.44 1.29.44 2.08s-.15 1.48-.44 2.07a3.3 3.3 0 0 1-1.21 1.38c-.52.33-1.12.49-1.81.49Zm0-1.05c.52 0 .95-.14 1.29-.4.34-.28.59-.63.75-1.07.17-.43.25-.9.25-1.42 0-.5-.08-.98-.25-1.43-.16-.44-.41-.8-.75-1.06a2 2 0 0 0-1.29-.41 2 2 0 0 0-1.29.4c-.34.28-.59.63-.75 1.07-.17.45-.25.92-.25 1.43 0 .51.08.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.29.4Z"
      />
      <rect
        width={43}
        height={20}
        x={1014}
        y={586}
        fill="#1FAD66"
        fillOpacity={0.1}
        rx={4}
      />
      <path
        fill="#1FAD66"
        d="m1024.7 600-2.47-8.73h1.7l1.58 6.42h.08l1.68-6.42h1.54l1.69 6.42h.07l1.58-6.42h1.7l-2.47 8.73h-1.56l-1.74-6.12h-.07l-1.75 6.12h-1.56Zm12.36.13c-.64 0-1.19-.14-1.66-.42a2.87 2.87 0 0 1-1.09-1.18c-.26-.51-.38-1.1-.38-1.78 0-.67.12-1.27.38-1.77.26-.51.62-.9 1.09-1.19a3.17 3.17 0 0 1 1.66-.42c.64 0 1.19.14 1.66.42.47.28.83.68 1.09 1.19.26.5.39 1.1.39 1.77 0 .68-.13 1.27-.39 1.78-.26.5-.62.9-1.09 1.18-.47.28-1.02.42-1.66.42Zm.01-1.24c.35 0 .64-.1.87-.28.23-.2.41-.46.52-.78.12-.32.17-.68.17-1.08s-.05-.76-.17-1.09a1.71 1.71 0 0 0-.52-.78 1.3 1.3 0 0 0-.87-.29c-.35 0-.65.1-.89.3-.23.19-.4.45-.52.77-.11.33-.17.69-.17 1.09 0 .4.06.76.17 1.08.12.32.29.58.52.78.24.19.54.28.89.28Zm5.98-2.73V600h-1.54v-6.54h1.47v1.1h.08c.15-.36.39-.65.72-.87a2.2 2.2 0 0 1 1.23-.32c.45 0 .85.1 1.18.29.34.2.6.47.78.84.19.37.28.81.28 1.33V600h-1.54v-3.93c0-.44-.11-.78-.34-1.03a1.21 1.21 0 0 0-.93-.37 1.3 1.3 0 0 0-1.22.69 1.8 1.8 0 0 0-.17.8Z"
      />
      <path
        fill="#474E6B"
        d="m1067.48 595.07-1.05.3a2.4 2.4 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3.99.42l1.13.27c.69.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.12.83-.38 1.17-.24.35-.59.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.2 2.2 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.69.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85a.87.87 0 0 0-.28-.66 1.74 1.74 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.89 1.89 0 0 1-.49-1.32c0-.43.13-.81.37-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.23-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.43 2.43 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.93 1.93 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.32-.27-.39-.19-.7-.46-.94-.8a2.27 2.27 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.41-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18l1.13-.14c.29-.03.5-.09.63-.16.14-.08.21-.21.21-.4v-.04c0-.5-.14-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4c.19-.46.46-.82.79-1.08.34-.26.7-.44 1.09-.55a4.57 4.57 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V601h-1.17v-1.03h-.06a2.2 2.2 0 0 1-1.14 1.01c-.31.13-.68.2-1.13.2Zm.18-1.05c.46 0 .86-.1 1.17-.28.33-.18.57-.42.73-.7.17-.3.25-.6.25-.91v-1.08c-.05.06-.16.12-.33.17a5.78 5.78 0 0 1-1.21.21l-.49.06c-.31.04-.59.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.69.3 1.16.3Zm8.55 3.9a4.4 4.4 0 0 1-1.47-.23c-.4-.14-.74-.33-1.02-.56a3.3 3.3 0 0 1-.64-.75l.94-.65c.1.13.24.3.4.47.16.19.38.34.67.48.28.13.65.2 1.12.2.61 0 1.12-.15 1.52-.45.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.21.31-.36.51-.16.2-.39.39-.68.55-.29.15-.69.23-1.18.23a3.02 3.02 0 0 1-2.82-1.71 4.47 4.47 0 0 1-.43-2.03c0-.78.14-1.46.42-2.04a3.02 3.02 0 0 1 2.85-1.84 2.18 2.18 0 0 1 1.86.8c.15.22.28.38.36.52h.12v-1.22h1.14v7.86c0 .65-.15 1.19-.45 1.6-.3.41-.69.72-1.19.9-.5.2-1.05.3-1.66.3Zm-.04-4.2c.47 0 .86-.11 1.19-.33.32-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.25-1.46a2.17 2.17 0 0 0-.73-.98 1.99 1.99 0 0 0-1.2-.36 2 2 0 0 0-1.25.38c-.33.25-.57.59-.74 1.01-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.17.41.41.73.74.96.33.23.75.35 1.24.35Zm8.69 1.33a3.29 3.29 0 0 1-3.14-1.86 4.75 4.75 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07a3.22 3.22 0 0 1 3.02-1.9c.39 0 .79.06 1.17.2a2.97 2.97 0 0 1 1.82 1.82c.19.48.29 1.08.29 1.8v.49h-5.89v-1.01h4.69c0-.44-.08-.82-.25-1.16-.17-.34-.41-.6-.73-.8-.31-.2-.68-.3-1.1-.3-.47 0-.88.12-1.22.36a2.42 2.42 0 0 0-1.05 2.07v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13a1.72 1.72 0 0 0 1.07-1.06l1.14.31c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.05.68-.41.16-.88.24-1.39.24Zm5.8-.08a.84.84 0 0 1-.63-.26.85.85 0 0 1-.27-.64c0-.24.09-.45.27-.63a.84.84 0 0 1 .63-.26.88.88 0 0 1 .89.9c0 .16-.04.3-.12.44a.98.98 0 0 1-.32.33.9.9 0 0 1-.45.12Z"
      />
      <path
        fill="#DEE5ED"
        d="M1120 623H560v2h560v-2Z"
        mask="url(#path-141-inside-8_1_3812)"
      />
      <circle cx={584} cy={664} r={24} fill="url(#pattern8)" />
      <path
        fill="#6C7793"
        d="M625.41 652h-1.1l3.2-8.73h1.1l3.2 8.73h-1.11l-2.6-7.35h-.08l-2.6 7.35Zm.41-3.4h4.47v.93h-4.47v-.94Zm11.33.72v-3.87h1.01V652h-1v-1.1h-.07c-.16.32-.4.6-.72.84-.32.23-.73.35-1.23.35-.4 0-.77-.1-1.09-.27a1.87 1.87 0 0 1-.75-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.14.86.4 1.15.28.28.62.42 1.04.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.26-.6.26-1Zm5.5 5.27c-.5 0-.9-.06-1.26-.19a2.66 2.66 0 0 1-1.42-1.12l.8-.56c.09.12.2.25.35.4.13.16.32.3.57.41.24.12.56.18.95.18.53 0 .97-.13 1.31-.39.35-.25.52-.66.52-1.2v-1.33h-.09c-.07.12-.18.27-.31.44a1.8 1.8 0 0 1-.58.47c-.25.13-.59.2-1.02.2a2.63 2.63 0 0 1-2.42-1.47 3.81 3.81 0 0 1-.35-1.74c0-.67.11-1.25.35-1.75s.56-.89.98-1.16c.42-.27.91-.41 1.46-.41.43 0 .76.07 1.01.21.26.14.45.3.59.48l.31.43h.1v-1.03h.97v6.73c0 .56-.12 1.02-.38 1.37-.25.36-.6.62-1.02.78-.43.17-.9.25-1.43.25Zm-.04-3.6c.4 0 .75-.09 1.02-.27.28-.19.5-.45.64-.8.14-.35.22-.76.22-1.24 0-.47-.08-.9-.22-1.25a1.87 1.87 0 0 0-.63-.85 1.7 1.7 0 0 0-1.03-.3 1.7 1.7 0 0 0-1.7 1.19c-.14.36-.2.76-.2 1.2 0 .46.06.86.2 1.21.15.35.36.62.64.82.29.2.64.3 1.06.3Zm8.83-1.67v-3.87h1V652h-1v-1.1h-.07c-.15.32-.39.6-.71.84-.33.23-.74.35-1.23.35-.41 0-.77-.1-1.1-.27a1.88 1.88 0 0 1-.74-.82 3.1 3.1 0 0 1-.27-1.39v-4.15h1v4.08c0 .48.13.86.4 1.15.27.28.62.42 1.03.42a1.71 1.71 0 0 0 1.42-.78c.18-.26.27-.6.27-1Zm7.48-2.4-.9.26c-.06-.15-.14-.3-.25-.44-.1-.15-.26-.27-.44-.36-.2-.1-.43-.14-.72-.14-.4 0-.74.1-1 .28-.27.18-.4.4-.4.69 0 .25.09.45.27.6.18.14.47.26.85.36l.97.23c.59.14 1.03.36 1.31.65.29.3.43.67.43 1.13 0 .37-.1.7-.32 1-.21.3-.51.53-.9.7-.38.17-.83.26-1.33.26-.67 0-1.22-.15-1.66-.44a1.92 1.92 0 0 1-.83-1.27l.95-.24c.1.35.26.62.52.8.25.17.59.26 1 .26.47 0 .84-.1 1.12-.3.27-.2.41-.44.41-.72a.76.76 0 0 0-.24-.57c-.15-.16-.4-.28-.73-.35l-1.09-.26a2.6 2.6 0 0 1-1.32-.66 1.6 1.6 0 0 1-.42-1.13c0-.37.1-.7.31-.98s.5-.5.86-.67a3 3 0 0 1 1.24-.24c.64 0 1.15.14 1.52.42.37.29.64.67.8 1.13Zm4.48-1.46v.85h-3.39v-.85h3.4Zm-2.4-1.57h1v6.24c0 .28.05.5.13.63.09.14.2.24.32.28.14.05.28.07.42.07l.28-.01.17-.04.2.9a2.18 2.18 0 0 1-1.58-.06c-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm10.34-.62V652h-1.05v-7.62h-.05l-2.14 1.41v-1.07l2.19-1.45h1.05Zm2.3 6.94v-.87l3.84-6.07h.63v1.35h-.42l-2.9 4.59v.06h5.17v.94h-6.31Zm4.12 1.79v-8.73h1V652h-1Zm9.11.15c-.41 0-.8-.07-1.13-.23-.34-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.07-.68.22-.91.15-.24.34-.42.6-.55.24-.14.51-.24.8-.3.31-.07.61-.12.92-.16l.96-.12c.25-.03.44-.07.55-.14.12-.07.17-.18.17-.34v-.03c0-.43-.11-.75-.34-.99-.23-.23-.57-.34-1.04-.34-.48 0-.85.1-1.13.31-.27.21-.46.44-.57.67l-.95-.34a2.3 2.3 0 0 1 1.61-1.4 3.89 3.89 0 0 1 1.73-.05c.28.04.55.14.8.3.26.15.47.38.64.7.17.3.26.72.26 1.24V652h-1v-.89h-.06a1.96 1.96 0 0 1-.98.87c-.26.12-.58.17-.96.17Zm.15-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.13.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.22.08-.4.19-.54.34a.86.86 0 0 0-.2.6c0 .35.12.62.38.8.26.17.6.26 1 .26Zm7.53-5.8v.86h-3.39v-.85h3.4Zm-2.4-1.56h1v6.24c0 .28.05.5.13.63.08.14.2.24.32.28.13.05.28.07.42.07l.28-.01.17-.04.2.9a2.25 2.25 0 0 1-.75.13c-.28 0-.56-.07-.83-.19-.27-.12-.5-.3-.68-.56a1.6 1.6 0 0 1-.26-.94v-6.51Zm10.34-.62V652h-1.06v-7.62h-.05l-2.13 1.41v-1.07l2.18-1.45h1.06Zm5.58 0V652H707v-7.62h-.05l-2.13 1.41v-1.07l2.18-1.45h1.06Zm3.26 7.61a.74.74 0 0 1-.54-.22.74.74 0 0 1-.23-.54c0-.21.08-.4.23-.54a.74.74 0 0 1 .54-.23c.2 0 .39.07.54.23.15.15.23.33.23.54a.8.8 0 0 1-.38.66.74.74 0 0 1-.4.1Zm0-4.41a.74.74 0 0 1-.54-.23.74.74 0 0 1-.23-.54c0-.2.08-.39.23-.54a.74.74 0 0 1 .54-.23c.2 0 .39.08.54.23.15.15.23.33.23.54 0 .14-.04.27-.11.38a.8.8 0 0 1-.28.29.73.73 0 0 1-.38.1Zm2.55 5.53v-.77l2.88-3.15c.34-.37.62-.7.84-.96.22-.28.38-.54.49-.78.1-.24.16-.5.16-.77a1.41 1.41 0 0 0-.82-1.31 1.94 1.94 0 0 0-.85-.19c-.34 0-.63.07-.88.21-.25.14-.44.33-.58.58-.13.25-.2.53-.2.87h-1a2.44 2.44 0 0 1 1.32-2.25c.4-.22.86-.33 1.37-.33.51 0 .97.11 1.36.33.4.21.7.5.93.87.22.37.34.77.34 1.22 0 .32-.06.64-.18.95-.11.3-.31.64-.6 1.01-.28.38-.67.83-1.17 1.37l-1.96 2.1v.06h4.06v.94h-5.5Zm6.88-1.79v-.87l3.83-6.07h.63v1.35h-.42l-2.9 4.59v.06h5.16v.94h-6.3Zm4.1 1.79v-8.73h1.01V652h-1Zm5.74.15c-.41 0-.79-.07-1.13-.23-.33-.16-.6-.39-.8-.69-.2-.3-.3-.66-.3-1.09 0-.37.08-.68.22-.91.15-.24.35-.42.6-.55.24-.14.51-.24.81-.3.3-.07.6-.12.91-.16.4-.06.72-.1.97-.12.25-.03.43-.07.54-.14.12-.07.18-.18.18-.34v-.03c0-.43-.12-.75-.35-.99-.22-.23-.57-.34-1.03-.34-.48 0-.86.1-1.13.31-.27.21-.47.44-.58.67l-.95-.34a2.3 2.3 0 0 1 1.62-1.4 3.89 3.89 0 0 1 1.73-.05c.27.04.54.14.8.3.25.15.47.38.64.7.17.3.25.72.25 1.24V652h-1v-.89h-.05c-.07.15-.18.3-.34.46-.16.16-.37.3-.64.41-.26.12-.59.17-.97.17Zm.16-.9a2 2 0 0 0 1-.23 1.6 1.6 0 0 0 .84-1.39v-.92c-.04.05-.14.1-.28.14a21.3 21.3 0 0 1-1.46.23c-.26.04-.5.1-.73.17-.23.08-.4.19-.55.34a.85.85 0 0 0-.2.6c0 .35.13.62.38.8.27.17.6.26 1 .26Zm4.68.75v-6.54h.97v1.02h.09c.13-.35.35-.62.66-.82.3-.2.67-.3 1.1-.3.42 0 .78.1 1.07.3.29.2.52.47.68.82h.07c.16-.34.41-.6.75-.8.34-.21.74-.31 1.2-.31.6 0 1.07.18 1.44.55.38.36.56.93.56 1.7V652h-1v-4.38c0-.48-.14-.83-.4-1.04-.26-.2-.58-.3-.93-.3-.47 0-.82.13-1.07.41a1.5 1.5 0 0 0-.38 1.05V652h-1.03v-4.48c0-.38-.12-.67-.36-.9a1.3 1.3 0 0 0-.93-.35c-.26 0-.5.07-.73.21-.23.14-.41.33-.55.58-.14.25-.2.53-.2.85V652h-1.01Z"
      />
      <path
        fill="#14141F"
        d="M629.02 670.82h1.83v7.16c0 .65-.14 1.22-.42 1.7-.27.46-.66.83-1.15 1.08a3.7 3.7 0 0 1-1.71.38c-.6 0-1.14-.1-1.62-.32a2.63 2.63 0 0 1-1.13-.95 2.79 2.79 0 0 1-.41-1.58h1.83c0 .28.06.52.18.72.12.2.29.35.5.45.2.11.44.16.71.16.3 0 .55-.06.75-.18.21-.13.37-.31.47-.56.11-.24.17-.54.17-.9v-7.16Zm5.95 10.33a3.2 3.2 0 0 1-1.3-.25 2.14 2.14 0 0 1-.92-.78 2.26 2.26 0 0 1-.34-1.26c0-.43.08-.79.24-1.07.16-.28.38-.5.65-.68.28-.17.59-.3.93-.38.35-.09.71-.15 1.08-.2l1.1-.12c.27-.04.47-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.8.09-1.05.28-.25.2-.43.42-.52.68l-1.68-.24a2.68 2.68 0 0 1 1.78-1.87 4.77 4.77 0 0 1 2.56-.11c.36.09.7.23 1 .43.3.2.54.46.72.8.19.34.28.76.28 1.27V681h-1.73v-1.05h-.06a2.2 2.2 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.47-1.32c.36 0 .67-.07.94-.21.26-.15.47-.34.6-.58.15-.24.23-.5.23-.78v-.9a.85.85 0 0 1-.3.13 12.89 12.89 0 0 1-1.36.24c-.26.04-.5.1-.71.18-.22.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.12.58.36.75.24.17.55.25.93.25Zm5.37 1.17v-7.64h1.72v1.3h.1c.15-.44.41-.78.78-1.02.37-.25.8-.38 1.32-.38s.95.13 1.3.38c.37.25.62.59.76 1.02h.08c.17-.42.46-.76.86-1.01.4-.26.88-.39 1.43-.39.7 0 1.28.23 1.72.67.45.45.67 1.1.67 1.94V681h-1.8v-4.85c0-.47-.13-.82-.38-1.04a1.35 1.35 0 0 0-.93-.33c-.43 0-.77.14-1.02.4a1.5 1.5 0 0 0-.36 1.06V681h-1.76v-4.92c0-.4-.12-.71-.36-.95a1.25 1.25 0 0 0-.93-.35c-.25 0-.5.07-.7.2a1.4 1.4 0 0 0-.51.55c-.13.24-.19.51-.19.83V681h-1.8Zm15.95.15c-.77 0-1.43-.16-1.99-.48a3.24 3.24 0 0 1-1.27-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.4 3.4 0 0 1 3.16-1.9c.47 0 .92.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.62 1.62 0 0 0-.6-.64 1.72 1.72 0 0 0-.91-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.34.16-.14.28-.32.36-.54l1.68.2c-.1.44-.31.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-.99.27-1.58.27Zm10.95-5.77-1.64.18a1.33 1.33 0 0 0-.24-.47 1.2 1.2 0 0 0-.46-.35c-.2-.09-.43-.13-.7-.13-.38 0-.7.08-.95.24-.25.16-.38.37-.38.63 0 .22.08.4.25.54.17.14.45.26.83.35l1.3.27c.73.16 1.27.4 1.62.75.35.33.53.78.53 1.32 0 .48-.14.9-.42 1.28-.27.36-.66.64-1.15.85-.49.2-1.05.3-1.69.3-.93 0-1.68-.19-2.25-.58-.57-.4-.91-.94-1.02-1.64l1.75-.17c.08.34.25.6.5.78.27.17.6.26 1.02.26.43 0 .77-.09 1.03-.26.26-.18.39-.4.39-.65 0-.22-.08-.4-.25-.54a1.77 1.77 0 0 0-.78-.33l-1.3-.28a3.11 3.11 0 0 1-1.63-.77 1.9 1.9 0 0 1-.52-1.38c0-.47.13-.88.38-1.22a2.5 2.5 0 0 1 1.1-.8c.46-.2 1-.3 1.6-.3.9 0 1.6.2 2.12.58.52.38.84.9.96 1.54Zm10.73-1.76a1.36 1.36 0 0 0-.58-1.02 2.25 2.25 0 0 0-1.34-.36c-.38 0-.7.06-.98.17-.28.12-.49.28-.64.48a1.15 1.15 0 0 0-.07 1.23c.1.15.23.29.4.4.17.1.35.2.56.27.2.07.41.13.62.18l.96.24c.38.09.75.2 1.1.36.36.15.68.35.96.58.29.23.51.51.68.84.16.33.25.71.25 1.15 0 .6-.15 1.12-.46 1.58-.3.45-.75.8-1.32 1.06-.58.25-1.27.37-2.09.37a5.3 5.3 0 0 1-2.06-.36 3.07 3.07 0 0 1-1.36-1.08 3.17 3.17 0 0 1-.53-1.72h1.82a1.55 1.55 0 0 0 1.08 1.41c.3.12.66.18 1.04.18.4 0 .75-.06 1.05-.18.3-.12.55-.3.72-.5.17-.23.26-.48.26-.77a.97.97 0 0 0-.23-.66 1.72 1.72 0 0 0-.64-.44 6.08 6.08 0 0 0-.96-.32l-1.15-.3a4.66 4.66 0 0 1-2-.97 2.26 2.26 0 0 1-.72-1.76c0-.6.16-1.12.49-1.57.33-.46.77-.8 1.34-1.05.56-.25 1.2-.38 1.91-.38.72 0 1.36.13 1.9.38.55.25.97.6 1.29 1.04.3.44.47.94.48 1.52h-1.78Zm7.3-.26v1.4h-4.4v-1.4h4.4Zm-3.31-1.83h1.8v7.17c0 .25.04.43.1.56.08.13.18.21.3.26.13.05.27.07.41.07a1.71 1.71 0 0 0 .53-.07l.3 1.4a3.8 3.8 0 0 1-1.05.18c-.46.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.31-1.2v-7.47Zm7 9.62a3.2 3.2 0 0 1-1.3-.25 2.15 2.15 0 0 1-.91-.78 2.27 2.27 0 0 1-.34-1.26c0-.43.08-.79.24-1.07.16-.28.38-.5.65-.68.28-.17.59-.3.93-.38.35-.09.71-.15 1.08-.2l1.09-.12c.28-.04.48-.1.6-.18.14-.08.2-.2.2-.38v-.03c0-.38-.11-.67-.33-.87-.22-.2-.54-.3-.96-.3-.44 0-.8.09-1.05.28-.26.2-.43.42-.52.68l-1.68-.24a2.67 2.67 0 0 1 1.78-1.87 4.77 4.77 0 0 1 2.56-.11c.36.09.7.23 1 .43.3.2.54.46.72.8.19.34.28.76.28 1.27V681h-1.73v-1.05h-.06a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.48-1.32c.36 0 .67-.07.94-.21.26-.15.47-.34.6-.58.15-.24.23-.5.23-.78v-.9a.87.87 0 0 1-.3.13 13.22 13.22 0 0 1-.94.18l-.42.06c-.26.04-.5.1-.72.18-.2.09-.38.2-.5.35a.85.85 0 0 0-.18.57c0 .33.12.58.36.75.24.17.55.25.93.25Zm7.17-3.3V681h-1.8v-7.64H697v1.3h.09c.18-.43.46-.77.84-1.02.39-.25.87-.38 1.44-.38.52 0 .98.12 1.37.34.4.23.7.55.92.98.22.43.33.95.32 1.56V681h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.08-.43c-.32 0-.6.07-.85.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Zm10.54-3.17v1.4h-4.38v-1.4h4.38Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.13.05.26.07.41.07a1.72 1.72 0 0 0 .53-.07l.3 1.4a3.83 3.83 0 0 1-1.05.18c-.46.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7 2.1 2.1 0 0 1-.31-1.2v-7.47Zm8.06 9.62a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.05 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.74 0 1.4.17 1.94.5.54.33.97.78 1.26 1.38.3.6.46 1.28.46 2.07 0 .79-.15 1.48-.45 2.07a3.3 3.3 0 0 1-1.27 1.38c-.55.33-1.2.49-1.94.49Zm0-1.44c.41 0 .75-.11 1.02-.34a2 2 0 0 0 .6-.9c.14-.38.21-.8.21-1.26 0-.47-.07-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.42 0-.76.11-1.03.34-.28.22-.48.53-.62.9-.13.39-.2.8-.2 1.28 0 .46.07.88.2 1.26.14.38.34.68.62.9.27.23.61.34 1.03.34Zm6.99-3.18V681h-1.8v-7.64h1.72v1.3h.09c.17-.43.45-.77.84-1.02.38-.25.86-.38 1.43-.38.53 0 .99.12 1.38.34.4.23.7.55.91.98.22.43.33.95.33 1.56V681h-1.8v-4.58c0-.51-.13-.91-.4-1.2a1.4 1.4 0 0 0-1.09-.43c-.31 0-.6.07-.84.2-.24.14-.43.34-.57.6a2 2 0 0 0-.2.94Z"
      />
      <path
        fill="#474E6B"
        d="M733.32 681.18c-.48 0-.92-.1-1.32-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18a52 52 0 0 1 1.13-.14c.29-.03.5-.09.63-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.66-.41-1.2-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.12-.4a2.68 2.68 0 0 1 1.9-1.63 4.55 4.55 0 0 1 2.01-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V681h-1.17v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.69.2-1.13.2Zm.18-1.05c.46 0 .86-.1 1.17-.28a1.86 1.86 0 0 0 .98-1.61v-1.08c-.05.06-.16.12-.33.17l-.58.12a30.87 30.87 0 0 1-1.12.15c-.3.04-.6.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.3.2.7.3 1.16.3Zm8.35 1.03a3 3 0 0 1-2.83-1.86c-.28-.59-.41-1.29-.41-2.1 0-.8.13-1.5.4-2.09a3.03 3.03 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.16.52.35.67.56.16.2.28.37.36.5h.1v-3.75h1.18V681h-1.14v-1.17h-.14c-.08.14-.2.31-.37.52-.15.21-.38.4-.68.56-.3.17-.68.25-1.17.25Zm.15-1.05c.48 0 .87-.13 1.2-.37.32-.25.57-.6.74-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02a4.1 4.1 0 0 0-.24 1.45c0 .55.08 1.04.25 1.48.17.44.41.8.74 1.06s.75.38 1.24.38Zm8.54 1.05a3 3 0 0 1-2.83-1.86c-.27-.59-.41-1.29-.41-2.1 0-.8.14-1.5.41-2.09a3.04 3.04 0 0 1 2.85-1.85c.5 0 .9.09 1.18.25.3.16.51.35.67.56l.36.5h.1v-3.75h1.17V681h-1.13v-1.17h-.14l-.37.52c-.16.21-.38.4-.68.56-.3.17-.69.25-1.18.25Zm.16-1.05c.47 0 .87-.13 1.2-.37.32-.25.57-.6.73-1.03.17-.44.26-.95.26-1.53 0-.57-.09-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.91.14-1.24.4-.33.24-.58.59-.74 1.02-.17.43-.25.91-.25 1.45 0 .55.09 1.04.25 1.48.17.44.42.8.75 1.06s.74.38 1.23.38Zm8.85 1.05a3.27 3.27 0 0 1-3.13-1.86 4.68 4.68 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07.3-.6.7-1.06 1.2-1.4a3.61 3.61 0 0 1 2.99-.3 2.93 2.93 0 0 1 1.82 1.81 5 5 0 0 1 .29 1.8v.5h-5.89v-1.01h4.7c0-.44-.1-.82-.26-1.16a1.94 1.94 0 0 0-1.83-1.1c-.47 0-.88.12-1.22.36-.34.23-.6.52-.78.9-.18.36-.27.75-.27 1.17v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13.25-.1.47-.23.65-.4.18-.18.33-.4.42-.67l1.14.32a2.5 2.5 0 0 1-.6 1.01c-.29.3-.63.52-1.05.68-.41.16-.88.24-1.4.24Zm7.84 0a3 3 0 0 1-2.83-1.86c-.28-.59-.42-1.29-.42-2.1 0-.8.14-1.5.42-2.09a3.03 3.03 0 0 1 2.85-1.85c.5 0 .88.09 1.17.25.3.16.52.35.67.56.15.2.28.37.36.5h.1v-3.75h1.17V681h-1.13v-1.17h-.14c-.08.14-.2.31-.37.52-.15.21-.38.4-.68.56-.3.17-.68.25-1.17.25Zm.15-1.05c.48 0 .87-.13 1.2-.37.32-.25.57-.6.74-1.03.17-.44.25-.95.25-1.53 0-.57-.08-1.07-.25-1.5a1.96 1.96 0 0 0-1.94-1.37c-.5 0-.9.14-1.24.4-.33.24-.57.59-.74 1.02-.16.43-.24.91-.24 1.45 0 .55.08 1.04.25 1.48.16.44.41.8.74 1.06s.74.38 1.23.38Z"
      />
      <path
        fill="#14141F"
        d="M778 670.82h2.26l3.02 7.38h.12l3.03-7.38h2.25V681h-1.77v-7h-.1l-2.8 6.97h-1.33l-2.81-6.98h-.1V681H778v-10.18Zm14.81 10.33a3.2 3.2 0 0 1-1.3-.25 2.15 2.15 0 0 1-.92-.78 2.27 2.27 0 0 1-.34-1.26c0-.43.08-.79.24-1.07.16-.28.38-.5.65-.68.28-.17.59-.3.93-.38.35-.09.71-.15 1.08-.2l1.1-.12c.27-.04.47-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.8.09-1.05.28-.25.2-.43.42-.52.68l-1.68-.24a2.67 2.67 0 0 1 1.78-1.87 4.77 4.77 0 0 1 2.56-.11c.36.09.7.23 1 .43.3.2.54.46.72.8.19.34.28.76.28 1.27V681h-1.73v-1.05h-.06a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.47-1.32c.36 0 .67-.07.94-.21.26-.15.47-.34.6-.58.15-.24.23-.5.23-.78v-.9a.86.86 0 0 1-.3.13 13.22 13.22 0 0 1-.94.18l-.41.06c-.27.04-.51.1-.73.18-.2.09-.37.2-.5.35a.85.85 0 0 0-.18.57c0 .33.12.58.36.75.24.17.55.25.93.25Zm5.37 1.17v-7.64h1.75v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.1 4.1 0 0 1 .65.05v1.66a3.36 3.36 0 0 0-.83-.1c-.34 0-.63.07-.9.2a1.56 1.56 0 0 0-.83 1.45V681h-1.8Zm7.2-2.4-.01-2.17h.29l2.74-3.07h2.1l-3.37 3.76h-.38l-1.38 1.48Zm-1.65 2.4v-10.18h1.8V681h-1.8Zm4.8 0-2.5-3.48 1.22-1.26 3.43 4.74H809Zm6.24.15c-.77 0-1.43-.16-1.99-.48a3.24 3.24 0 0 1-1.27-1.36 4.56 4.56 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.39 3.39 0 0 1 3.16-1.9c.48 0 .92.08 1.34.23.42.15.79.38 1.11.7.32.31.58.71.77 1.2.18.49.27 1.06.27 1.73v.55h-6.25v-1.2h4.53c0-.35-.08-.66-.22-.93a1.63 1.63 0 0 0-.62-.64 1.72 1.72 0 0 0-.9-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.23.94v1.06c0 .44.08.83.24 1.14.16.32.39.56.68.73.3.16.63.25 1.02.25.27 0 .5-.04.72-.11.2-.08.4-.19.55-.34.15-.14.27-.32.35-.54l1.68.2c-.1.44-.3.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-.99.27-1.58.27Zm8.73-7.79v1.4h-4.39v-1.4h4.39Zm-3.3-1.83h1.8v7.17c0 .25.03.43.1.56.08.13.18.21.3.26.12.05.26.07.4.07a1.73 1.73 0 0 0 .54-.07l.3 1.4a3.9 3.9 0 0 1-1.06.18c-.45.02-.86-.05-1.22-.2a1.9 1.9 0 0 1-.86-.7c-.2-.32-.3-.72-.3-1.2v-7.47Zm8.36 9.47v-10.18h3.82c.78 0 1.43.13 1.97.4.53.28.93.66 1.2 1.15.28.49.41 1.05.41 1.7 0 .66-.13 1.22-.41 1.7-.28.48-.68.85-1.22 1.11-.54.26-1.2.4-1.98.4h-2.72v-1.54h2.47c.46 0 .83-.06 1.13-.19.29-.13.5-.31.64-.56.14-.25.22-.55.22-.91 0-.37-.07-.68-.22-.93a1.36 1.36 0 0 0-.65-.59c-.3-.13-.67-.2-1.13-.2h-1.69V681h-1.84Zm5.26-4.61 2.52 4.61h-2.06l-2.48-4.61h2.02Zm7.04 4.76c-.77 0-1.43-.16-1.99-.48a3.24 3.24 0 0 1-1.28-1.36 4.56 4.56 0 0 1-.44-2.08c0-.79.14-1.48.44-2.07a3.39 3.39 0 0 1 3.17-1.9c.47 0 .91.08 1.33.23a3 3 0 0 1 1.12.7c.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2H843c0-.35-.07-.66-.22-.93a1.63 1.63 0 0 0-.61-.64 1.72 1.72 0 0 0-.9-.23c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7a2 2 0 0 0-.24.94v1.06c0 .44.08.83.25 1.14.16.32.38.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.21-.08.4-.19.55-.34.16-.14.28-.32.36-.54l1.68.2c-.11.44-.31.82-.61 1.15-.3.33-.67.59-1.13.77-.46.18-1 .27-1.58.27Zm10.95-5.77-1.64.18a1.31 1.31 0 0 0-.7-.82c-.2-.09-.43-.13-.7-.13-.38 0-.7.08-.95.24-.25.16-.38.37-.38.63 0 .22.08.4.25.54.17.14.45.26.83.35l1.3.27c.73.16 1.26.4 1.62.75.35.33.53.78.53 1.32 0 .48-.14.9-.42 1.28-.27.36-.66.64-1.15.85-.49.2-1.05.3-1.69.3-.93 0-1.69-.19-2.26-.58-.57-.4-.9-.94-1.01-1.64l1.75-.17c.08.34.25.6.5.78.27.17.6.26 1.02.26.42 0 .77-.09 1.03-.26.26-.18.39-.4.39-.65 0-.22-.09-.4-.25-.54a1.78 1.78 0 0 0-.78-.33l-1.3-.28a3.1 3.1 0 0 1-1.63-.77 1.89 1.89 0 0 1-.52-1.38c0-.47.12-.88.38-1.22a2.5 2.5 0 0 1 1.09-.8c.47-.2 1-.3 1.62-.3.9 0 1.6.2 2.1.58.53.38.85.9.97 1.54Zm5.03 5.77c-.77 0-1.43-.16-1.99-.48a3.23 3.23 0 0 1-1.27-1.36 4.57 4.57 0 0 1-.45-2.08c0-.79.15-1.48.45-2.07a3.4 3.4 0 0 1 3.16-1.9c.47 0 .92.08 1.33.23.43.15.8.38 1.12.7.32.31.58.71.76 1.2.19.49.28 1.06.28 1.73v.55h-6.26v-1.2h4.54c0-.35-.08-.66-.23-.93a1.63 1.63 0 0 0-1.51-.87c-.37 0-.7.09-.97.26-.28.18-.5.41-.65.7-.15.29-.23.6-.24.94v1.06c0 .44.09.83.25 1.14.16.32.39.56.68.73.29.16.63.25 1.02.25.26 0 .5-.04.71-.11.22-.08.4-.19.56-.34.15-.14.27-.32.35-.54l1.68.2c-.1.44-.31.82-.6 1.15-.3.33-.68.59-1.14.77-.46.18-.99.27-1.58.27Zm7.11 0a3.2 3.2 0 0 1-1.3-.25 2.14 2.14 0 0 1-.92-.78 2.27 2.27 0 0 1-.33-1.26c0-.43.08-.79.24-1.07.15-.28.37-.5.65-.68.27-.17.58-.3.93-.38.34-.09.7-.15 1.08-.2l1.09-.12c.27-.04.48-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.12-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.79.09-1.05.28-.25.2-.42.42-.51.68l-1.68-.24a2.68 2.68 0 0 1 1.77-1.87 4.76 4.76 0 0 1 2.56-.11c.37.09.7.23 1 .43.3.2.54.46.73.8.18.34.28.76.28 1.27V681h-1.74v-1.05h-.06a2.2 2.2 0 0 1-1.2 1.04 3 3 0 0 1-1.04.16Zm.47-1.32c.36 0 .68-.07.94-.21.26-.15.47-.34.61-.58.15-.24.22-.5.22-.78v-.9a.85.85 0 0 1-.29.13 12.57 12.57 0 0 1-.94.18l-.42.06c-.27.04-.5.1-.72.18-.21.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.12.58.37.75.24.17.55.25.92.25Zm5.38 1.17v-7.64H872v1.28h.08a1.9 1.9 0 0 1 1.88-1.39 4.1 4.1 0 0 1 .65.05v1.66a3.38 3.38 0 0 0-.84-.1c-.32 0-.62.07-.88.2a1.56 1.56 0 0 0-.84 1.45V681h-1.8Zm8.56.15a3.36 3.36 0 0 1-3.22-1.89 4.6 4.6 0 0 1-.44-2.05c0-.77.15-1.46.45-2.05a3.35 3.35 0 0 1 3.2-1.9c.62 0 1.17.12 1.65.35a2.81 2.81 0 0 1 1.63 2.4h-1.72a1.65 1.65 0 0 0-.5-.92c-.25-.25-.6-.37-1.03-.37-.37 0-.7.1-.97.3-.28.19-.5.47-.65.84-.16.37-.23.8-.23 1.32s.07.97.23 1.34c.15.38.36.66.64.86.28.2.6.3.98.3.26 0 .5-.05.7-.15.22-.1.4-.25.54-.44.14-.2.24-.43.3-.7h1.71a2.83 2.83 0 0 1-1.6 2.41c-.47.23-1.03.35-1.67.35Zm6.55-4.62V681h-1.8v-10.18h1.76v3.84h.09c.18-.43.46-.77.83-1.02.38-.25.86-.38 1.44-.38.53 0 1 .12 1.39.34.4.22.7.54.91.97.22.43.33.95.33 1.57V681h-1.8v-4.58c0-.52-.13-.92-.4-1.2a1.42 1.42 0 0 0-1.1-.43c-.32 0-.6.07-.85.2-.25.14-.45.34-.6.6-.13.25-.2.57-.2.94Z"
      />
      <path
        fill="#474E6B"
        d="M900.4 673.36v1h-3.96v-1h3.95Zm-2.8-1.83h1.16v7.28c0 .33.05.58.15.75.1.16.22.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.23 1.05a2.34 2.34 0 0 1-.87.14c-.33 0-.66-.07-.98-.21a1.94 1.94 0 0 1-.78-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.8 9.65c-.48 0-.92-.1-1.31-.27-.4-.19-.7-.46-.94-.8a2.26 2.26 0 0 1-.35-1.28c0-.44.09-.79.26-1.06.17-.28.4-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.05-.18l1.13-.14c.3-.03.5-.09.64-.16.14-.08.2-.21.2-.4v-.04c0-.5-.13-.87-.4-1.14-.26-.28-.67-.41-1.2-.41-.57 0-1 .12-1.33.37-.31.24-.54.5-.67.78l-1.1-.4a2.67 2.67 0 0 1 1.88-1.63 4.55 4.55 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V681h-1.18v-1.03h-.06a2.28 2.28 0 0 1-1.14 1.01c-.3.13-.68.2-1.12.2Zm.19-1.05c.46 0 .85-.1 1.17-.28a1.86 1.86 0 0 0 .97-1.61v-1.08c-.05.06-.15.12-.32.17l-.58.12a29.98 29.98 0 0 1-1.13.15c-.3.04-.59.1-.85.2-.26.08-.47.21-.64.39a1 1 0 0 0-.24.7c0 .41.16.72.46.93.3.2.69.3 1.16.3Zm10.87-5.06-1.06.3a1.96 1.96 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.16.32c-.31.21-.47.48-.47.81 0 .3.1.52.32.7.21.16.54.3 1 .42l1.13.27c.68.17 1.19.42 1.52.77.34.33.5.77.5 1.3 0 .44-.12.83-.37 1.17-.25.35-.6.62-1.05.82-.44.2-.96.3-1.56.3-.77 0-1.42-.17-1.93-.5a2.25 2.25 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.7.3 1.17.3.55 0 .99-.11 1.3-.34.33-.24.5-.52.5-.85 0-.26-.1-.48-.28-.66a1.76 1.76 0 0 0-.86-.41l-1.27-.3a3.04 3.04 0 0 1-1.54-.77 1.86 1.86 0 0 1-.5-1.32c0-.43.13-.81.37-1.14.25-.33.58-.6 1-.78.43-.2.9-.29 1.44-.29.76 0 1.35.17 1.78.5.44.33.75.77.93 1.31Zm3 3.15-.02-1.46h.23l3.35-3.4h1.45l-3.56 3.6h-.1l-1.35 1.26Zm-1.1 2.78v-10.18h1.18V681h-1.18Zm4.86 0-2.99-3.78.84-.81 3.64 4.59h-1.5Zm10.02-7.64v1h-3.96v-1h3.96Zm-2.8-1.83h1.17v7.28c0 .33.04.58.14.75.1.16.23.27.38.33.15.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.41 2.41 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.94 1.94 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm7.58 9.63c-.69 0-1.3-.16-1.81-.5a3.34 3.34 0 0 1-1.22-1.37 4.66 4.66 0 0 1-.43-2.07c0-.8.15-1.49.43-2.08.3-.6.7-1.05 1.22-1.38.52-.33 1.12-.5 1.81-.5.7 0 1.3.17 1.81.5.52.33.93.78 1.21 1.38.3.6.44 1.29.44 2.08s-.14 1.48-.44 2.07a3.3 3.3 0 0 1-1.2 1.38 3.3 3.3 0 0 1-1.82.49Zm0-1.05a2 2 0 0 0 1.3-.4c.33-.28.58-.63.75-1.07.16-.43.24-.9.24-1.42 0-.5-.08-.98-.24-1.43a2.4 2.4 0 0 0-.76-1.06 2 2 0 0 0-1.29-.41 2 2 0 0 0-1.3.4 2.4 2.4 0 0 0-.74 1.07c-.16.45-.25.92-.25 1.43 0 .51.09.99.25 1.42.16.44.41.8.75 1.06.34.27.77.4 1.3.4Z"
      />
      <path
        fill="#14141F"
        d="M947 681v-10.18h3.9c.74 0 1.35.11 1.84.35.49.23.85.54 1.1.94.24.4.36.84.36 1.35a2 2 0 0 1-.88 1.77c-.27.18-.57.32-.9.4v.1a2.31 2.31 0 0 1 1.86 1.18c.21.36.32.8.32 1.32s-.13 1-.38 1.42a2.6 2.6 0 0 1-1.15.99c-.52.24-1.17.36-1.94.36H947Zm1.85-1.54h1.98c.67 0 1.15-.13 1.45-.38.3-.26.45-.6.45-1a1.53 1.53 0 0 0-.86-1.39 2.1 2.1 0 0 0-.99-.21h-2.03v2.98Zm0-4.31h1.82c.32 0 .6-.06.86-.18s.46-.28.6-.5c.15-.22.23-.48.23-.77 0-.4-.14-.72-.42-.98-.27-.25-.68-.38-1.23-.38h-1.86v2.8Zm9.47 6c-.48 0-.92-.08-1.3-.25a2.14 2.14 0 0 1-.92-.78 2.27 2.27 0 0 1-.33-1.26c0-.43.08-.79.24-1.07.16-.28.37-.5.65-.68.27-.17.58-.3.93-.38.35-.09.7-.15 1.08-.2l1.09-.12c.27-.04.48-.1.6-.18.13-.08.2-.2.2-.38v-.03c0-.38-.11-.67-.34-.87-.22-.2-.54-.3-.96-.3-.44 0-.79.09-1.05.28-.25.2-.42.42-.51.68l-1.68-.24a2.67 2.67 0 0 1 1.77-1.87 4.77 4.77 0 0 1 2.56-.11c.37.09.7.23 1 .43.3.2.54.46.73.8.18.34.27.76.27 1.27V681h-1.73v-1.05h-.05a2.22 2.22 0 0 1-1.2 1.04 3 3 0 0 1-1.05.16Zm.47-1.32c.36 0 .68-.07.94-.21.26-.15.47-.34.61-.58.15-.24.22-.5.22-.78v-.9a.87.87 0 0 1-.29.13 13.22 13.22 0 0 1-1.36.24c-.27.04-.5.1-.72.18-.21.09-.38.2-.5.35a.85.85 0 0 0-.19.57c0 .33.12.58.37.75.24.17.55.25.92.25Zm8.7 1.32a3.36 3.36 0 0 1-3.22-1.89 4.6 4.6 0 0 1-.43-2.05c0-.77.15-1.46.44-2.05a3.35 3.35 0 0 1 3.2-1.9c.63 0 1.17.12 1.65.35a2.81 2.81 0 0 1 1.64 2.4h-1.72a1.65 1.65 0 0 0-.5-.92c-.26-.25-.6-.37-1.04-.37-.37 0-.69.1-.97.3-.28.19-.5.47-.65.84-.15.37-.23.8-.23 1.32s.08.97.23 1.34c.15.38.37.66.64.86.28.2.6.3.98.3.27 0 .5-.05.71-.15.21-.1.4-.25.53-.44.15-.2.24-.43.3-.7h1.72a2.83 2.83 0 0 1-1.6 2.41c-.48.23-1.03.35-1.67.35Zm6.4-2.55v-2.17h.28l2.74-3.07h2.1l-3.37 3.76h-.37l-1.38 1.48Zm-1.64 2.4v-10.18h1.8V681h-1.8Zm4.79 0-2.49-3.48 1.22-1.26 3.42 4.74h-2.15Zm4.98-10.18V681h-1.8v-10.18h1.8Zm5.18 10.33a3.7 3.7 0 0 1-1.94-.5 3.34 3.34 0 0 1-1.27-1.37 4.53 4.53 0 0 1-.45-2.07c0-.79.15-1.48.45-2.07.3-.6.72-1.05 1.27-1.38a3.7 3.7 0 0 1 1.94-.5c.74 0 1.39.17 1.94.5.54.33.97.78 1.26 1.38.3.6.46 1.28.46 2.07a4.5 4.5 0 0 1-.46 2.07c-.3.59-.72 1.05-1.26 1.38-.55.33-1.2.49-1.94.49Zm0-1.44c.41 0 .75-.11 1.02-.34a2 2 0 0 0 .6-.9c.14-.38.21-.8.21-1.26 0-.47-.07-.9-.2-1.27a2 2 0 0 0-.6-.91 1.54 1.54 0 0 0-1.02-.34c-.42 0-.76.11-1.04.34-.27.22-.47.53-.6.9-.14.39-.2.8-.2 1.28 0 .46.06.88.2 1.26.13.38.33.68.6.9.28.23.62.34 1.04.34Zm8.5 4.31a4.7 4.7 0 0 1-1.66-.26c-.46-.17-.84-.4-1.12-.7a2.4 2.4 0 0 1-.59-.97l1.63-.39c.07.15.17.3.31.44.14.15.33.27.57.37.23.1.53.15.9.15.5 0 .93-.12 1.26-.37.34-.25.5-.65.5-1.21v-1.45h-.09c-.09.18-.22.37-.4.57-.18.2-.41.36-.7.5a3.14 3.14 0 0 1-2.68-.21c-.48-.29-.86-.7-1.14-1.25a4.6 4.6 0 0 1-.42-2.08c0-.84.14-1.55.42-2.13a3.1 3.1 0 0 1 1.14-1.31 2.92 2.92 0 0 1 2.7-.23c.29.15.52.33.7.54.17.21.3.41.38.6h.1v-1.27h1.78v7.76c0 .66-.16 1.2-.47 1.63-.31.42-.74.74-1.28.96a5 5 0 0 1-1.83.31Zm.02-4.54c.38 0 .7-.1.97-.28.27-.19.48-.45.62-.8.14-.35.2-.77.2-1.25s-.06-.9-.2-1.27a1.8 1.8 0 0 0-.61-.84c-.27-.2-.6-.3-.98-.3-.4 0-.74.1-1 .31-.27.21-.48.5-.61.86-.14.37-.2.78-.2 1.24 0 .46.06.87.2 1.23.14.34.34.62.61.81.27.2.6.29 1 .29Z"
      />
      <path
        fill="#474E6B"
        d="m1011.48 675.07-1.05.3a2.4 2.4 0 0 0-.29-.51c-.13-.17-.3-.3-.52-.42-.22-.1-.5-.16-.84-.16a2 2 0 0 0-1.17.32c-.31.21-.46.48-.46.81 0 .3.1.52.32.7.21.16.54.3.99.42l1.13.27c.69.17 1.2.42 1.53.77.33.33.5.77.5 1.3 0 .44-.12.83-.38 1.17-.24.35-.59.62-1.04.82-.45.2-.97.3-1.56.3-.78 0-1.42-.17-1.93-.5a2.2 2.2 0 0 1-.97-1.49l1.11-.28c.11.41.31.72.6.93.3.2.69.3 1.17.3.55 0 .98-.11 1.3-.34.33-.24.49-.52.49-.85a.87.87 0 0 0-.28-.66 1.74 1.74 0 0 0-.85-.41l-1.28-.3a3.04 3.04 0 0 1-1.54-.77 1.89 1.89 0 0 1-.49-1.32c0-.43.13-.81.37-1.14.24-.33.58-.6 1-.78.42-.2.9-.29 1.44-.29.75 0 1.35.17 1.78.5.43.33.74.77.92 1.31Zm5.23-1.7v.99h-3.96v-1h3.96Zm-2.8-1.84h1.17v7.28c0 .33.05.58.14.75.1.16.23.27.38.33.16.05.32.08.49.08l.32-.02.2-.04.24 1.05a2.43 2.43 0 0 1-.88.14c-.33 0-.65-.07-.97-.21a1.93 1.93 0 0 1-.79-.66c-.2-.29-.3-.65-.3-1.1v-7.6Zm6.81 9.65c-.48 0-.92-.1-1.32-.27-.39-.19-.7-.46-.94-.8a2.27 2.27 0 0 1-.34-1.28c0-.44.08-.79.25-1.06.18-.28.41-.5.7-.65.28-.15.6-.27.95-.35.35-.07.7-.14 1.06-.18l1.13-.14c.29-.03.5-.09.63-.16.14-.08.21-.21.21-.4v-.04c0-.5-.14-.87-.4-1.14-.27-.28-.67-.41-1.21-.41-.56 0-1 .12-1.32.37-.32.24-.54.5-.67.78l-1.11-.4c.19-.46.46-.82.79-1.08.34-.26.7-.44 1.09-.55a4.57 4.57 0 0 1 2.02-.07c.32.06.63.18.93.36.3.18.55.45.75.8.2.37.3.85.3 1.46V681h-1.17v-1.03h-.06a2.2 2.2 0 0 1-1.14 1.01c-.31.13-.68.2-1.13.2Zm.18-1.05c.46 0 .86-.1 1.17-.28.33-.18.57-.42.73-.7.17-.3.25-.6.25-.91v-1.08c-.05.06-.16.12-.33.17a5.78 5.78 0 0 1-1.21.21l-.49.06c-.31.04-.59.1-.86.2-.26.08-.47.21-.63.39a1 1 0 0 0-.24.7c0 .41.15.72.45.93.31.2.69.3 1.16.3Zm8.55 3.9a4.4 4.4 0 0 1-1.47-.23c-.4-.14-.74-.33-1.02-.56a3.3 3.3 0 0 1-.64-.75l.94-.65c.1.13.24.3.4.47.16.19.38.34.67.48.28.13.65.2 1.12.2.61 0 1.12-.15 1.52-.45.4-.3.6-.76.6-1.4v-1.55h-.1c-.08.14-.21.31-.36.51-.16.2-.39.39-.68.55-.29.15-.69.23-1.18.23a3.02 3.02 0 0 1-2.82-1.71 4.47 4.47 0 0 1-.43-2.03c0-.78.14-1.46.42-2.04a3.02 3.02 0 0 1 2.85-1.84 2.18 2.18 0 0 1 1.86.8c.15.22.28.38.36.52h.12v-1.22h1.14v7.86c0 .65-.15 1.19-.45 1.6-.3.41-.69.72-1.19.9-.5.2-1.05.3-1.66.3Zm-.04-4.2c.47 0 .86-.11 1.19-.33.32-.21.57-.52.74-.93.17-.4.25-.88.25-1.45 0-.55-.08-1.03-.25-1.46a2.17 2.17 0 0 0-.73-.98 1.99 1.99 0 0 0-1.2-.36 2 2 0 0 0-1.25.38c-.33.25-.57.59-.74 1.01-.16.42-.24.9-.24 1.41 0 .53.08 1 .25 1.4.17.41.41.73.74.96.33.23.75.35 1.24.35Zm8.69 1.33a3.29 3.29 0 0 1-3.14-1.86 4.75 4.75 0 0 1-.42-2.06c0-.78.14-1.47.42-2.07a3.22 3.22 0 0 1 3.02-1.9c.39 0 .79.06 1.17.2a2.97 2.97 0 0 1 1.82 1.82c.19.48.29 1.08.29 1.8v.49h-5.89v-1.01h4.69c0-.44-.08-.82-.25-1.16-.17-.34-.41-.6-.73-.8-.31-.2-.68-.3-1.1-.3-.47 0-.88.12-1.22.36a2.42 2.42 0 0 0-1.05 2.07v.68c0 .58.1 1.07.3 1.47.2.4.48.7.84.9.36.21.77.32 1.25.32.3 0 .58-.05.83-.13a1.72 1.72 0 0 0 1.07-1.06l1.14.31c-.12.38-.32.72-.6 1.01-.28.3-.63.52-1.05.68-.41.16-.88.24-1.39.24Zm5.8-.08a.84.84 0 0 1-.63-.26.85.85 0 0 1-.27-.64c0-.24.09-.45.27-.63a.84.84 0 0 1 .63-.26.88.88 0 0 1 .89.9c0 .16-.04.3-.12.44a.98.98 0 0 1-.32.33.9.9 0 0 1-.45.12Z"
      />
    </g>
    <defs>
      <pattern
        id="pattern0"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image0_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern1"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image1_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern2"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image2_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern3"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image3_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern4"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image4_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern5"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image2_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern6"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image5_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern7"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image6_1_3812" transform="scale(0)" />
      </pattern>
      <pattern
        id="pattern8"
        width={1}
        height={1}
        patternContentUnits="objectBoundingBox"
      >
        <use xlinkHref="#image7_1_3812" transform="scale(0)" />
      </pattern>
      <image id="image0_1_3812" width={150} height={150} />
      <image id="image1_1_3812" width={200} height={200} />
      <image id="image2_1_3812" width={160} height={160} />
      <image id="image3_1_3812" width={640} height={640} />
      <image id="image4_1_3812" width={1024} height={1024} />
      <image id="image5_1_3812" width={200} height={200} />
      <image id="image6_1_3812" width={1024} height={1024} />
      <image id="image7_1_3812" width={1024} height={1024} />
      <clipPath id="clip0_1_3812">
        <path fill="#fff" d="M36 112h16v16H36z" />
      </clipPath>
      <clipPath id="clip1_1_3812">
        <path fill="#fff" d="M468 25h14v14h-14z" />
      </clipPath>
      <clipPath id="clip2_1_3812">
        <rect width={296} height={136} x={224} y={88} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="clip3_1_3812">
        <rect width={296} height={136} x={536} y={88} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="clip4_1_3812">
        <rect width={296} height={136} x={848} y={88} fill="#fff" rx={16} />
      </clipPath>
      <clipPath id="clip5_1_3812">
        <rect width={296} height={472} x={224} y={240} fill="#fff" rx={8} />
      </clipPath>
      <clipPath id="clip6_1_3812">
        <rect width={608} height={472} x={536} y={240} fill="#fff" rx={8} />
      </clipPath>
      <radialGradient
        id="paint1_radial_1_3812"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="matrix(0 120 -120 0 520 88)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0080FF" />
        <stop offset={1} stopColor="#0080FF" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint3_radial_1_3812"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="matrix(0 120 -120 0 832 88)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#1FAD66" />
        <stop offset={1} stopColor="#1FAD66" stopOpacity={0} />
      </radialGradient>
      <radialGradient
        id="paint5_radial_1_3812"
        cx={0}
        cy={0}
        r={1}
        gradientTransform="matrix(0 120 -120 0 1144 88)"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF4C4D" />
        <stop offset={1} stopColor="#FF4C4D" stopOpacity={0} />
      </radialGradient>
      <linearGradient
        id="paint0_linear_1_3812"
        x1={456}
        x2={456}
        y1={140}
        y2={188}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#0080FF" stopOpacity={0.25} />
        <stop offset={1} stopColor="#0080FF" stopOpacity={0} />
      </linearGradient>
      <linearGradient
        id="paint2_linear_1_3812"
        x1={768}
        x2={768}
        y1={140}
        y2={188}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#1FAD66" stopOpacity={0.25} />
        <stop offset={1} stopColor="#1FAD66" stopOpacity={0} />
      </linearGradient>
      <linearGradient
        id="paint4_linear_1_3812"
        x1={1080}
        x2={1080}
        y1={140}
        y2={188}
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#FF4C4D" stopOpacity={0.25} />
        <stop offset={1} stopColor="#FF4C4D" stopOpacity={0} />
      </linearGradient>
      <filter id="blurry-behind" x="0" y="0">
        <feGaussianBlur in="SourceGraphic" stdDeviation="15" />
      </filter>
    </defs>
    <rect width={1168} height={736} x={0} y={0} fill="#fff" fillOpacity={0.5} />
    <use
      xlinkHref="#thing"
      x={224}
      y={88}
      width={296}
      height={136}
      style={{
        filter: "drop-shadow(0 3px 10px rgba(0,0,0,0.25))",
      }}
      visibility="hidden"
    />
  </svg>
);
