import React from "react";

export const GithubIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    width={12}
    height={12}
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M11.053 0A10.904 10.904 0 0 0 3.89 2.685 11.34 11.34 0 0 0 .142 9.472a11.48 11.48 0 0 0 1.456 7.65 11.087 11.087 0 0 0 5.964 4.86c.556.103.752-.25.752-.547v-1.918C5.23 20.202 4.58 18 4.58 18a3.012 3.012 0 0 0-1.227-1.655c-.997-.692.081-.692.081-.692.35.05.683.18.975.382.293.202.536.469.713.78.15.278.352.523.595.721a2.312 2.312 0 0 0 2.618.221c.042-.57.283-1.105.678-1.509-2.454-.284-5.03-1.253-5.03-5.539a4.415 4.415 0 0 1 1.132-3.025A4.194 4.194 0 0 1 5.224 4.7s.928-.305 3.036 1.156c1.81-.508 3.72-.508 5.531 0 2.108-1.46 3.03-1.156 3.03-1.156.406.936.455 1.993.135 2.963a4.415 4.415 0 0 1 1.132 3.026c0 4.334-2.582 5.282-5.043 5.538.264.271.468.597.598.955.13.358.182.741.155 1.122V21.4c0 .367.196.65.759.54a11.093 11.093 0 0 0 5.88-4.878 11.481 11.481 0 0 0 1.419-7.6 11.34 11.34 0 0 0-3.71-6.746A10.907 10.907 0 0 0 11.053 0Z"
      fill="currentColor"
    />
  </svg>
);

export const GithubIconOutlined = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={24}
    height={24}
    viewBox="0 0 24 24"
    fill="none"
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M12.066.001a11.91 11.91 0 0 1 7.745 2.966 12.326 12.326 0 0 1 4.032 7.33 12.46 12.46 0 0 1-1.54 8.245 12.088 12.088 0 0 1-6.406 5.314l-.105.037-.11.021c-.508.1-1.232.093-1.83-.422-.577-.498-.681-1.166-.681-1.565v-3.008l.004-.053a1.102 1.102 0 0 0-.062-.453 1.058 1.058 0 0 0-.235-.377l-.839-.86-.863.882a.802.802 0 0 0-.224.502l-.015.217v3.183c0 .434-.14 1.029-.628 1.492-.541.514-1.246.62-1.864.505l-.108-.02-.104-.035a12.082 12.082 0 0 1-6.498-5.296 12.457 12.457 0 0 1-1.58-8.298c.45-2.86 1.891-5.471 4.073-7.375A11.909 11.909 0 0 1 12.05.001h.016Zm-10.43 10.54a10.957 10.957 0 0 0 1.39 7.303 10.58 10.58 0 0 0 5.693 4.638c.53.099.717-.238.717-.522v-1.83c-.588.13-1.083.15-1.5.1a2.95 2.95 0 0 1-.542-.117 2.551 2.551 0 0 1-.422-.176 2.362 2.362 0 0 1-.82-.72c-.208-.294-.28-.535-.28-.535a2.876 2.876 0 0 0-1.17-1.58l-.016-.01c-.925-.65.093-.65.093-.65.106.015.21.038.313.068l.017.005a2.172 2.172 0 0 1 .962.603c.122.13.23.276.319.433a2.29 2.29 0 0 0 .68.775h.002s0 .001 0 0a2.211 2.211 0 0 0 2.385.124v-.014a2.302 2.302 0 0 1 .647-1.427 8.754 8.754 0 0 1-1.625-.328 4.865 4.865 0 0 1-1.416-.695 3.883 3.883 0 0 1-.432-.365c-.8-.786-1.328-2.002-1.328-3.899a4.214 4.214 0 0 1 1.08-2.887 4.003 4.003 0 0 1 .104-2.848s.886-.291 2.898 1.103a9.762 9.762 0 0 1 5.28 0c2.011-1.393 2.891-1.103 2.891-1.103.388.893.434 1.902.13 2.828a4.214 4.214 0 0 1 1.08 2.888c0 3.166-1.444 4.44-3.174 4.972a8.617 8.617 0 0 1-1.64.314 2.558 2.558 0 0 1 .699 1.425c.026.184.033.371.02.558v2.955c0 .35.187.62.724.515a10.588 10.588 0 0 0 5.613-4.656 10.958 10.958 0 0 0 1.354-7.254 10.824 10.824 0 0 0-3.541-6.439 10.41 10.41 0 0 0-6.77-2.592 10.408 10.408 0 0 0-6.837 2.563 10.824 10.824 0 0 0-3.578 6.478ZM16.374 7.8a8.003 8.003 0 0 0-.856.524l-.58.401-.679-.19a8.262 8.262 0 0 0-4.469 0l-.68.19-.58-.402a7.982 7.982 0 0 0-.846-.519c.019.186.059.37.12.549l.282.832-.588.653a2.714 2.714 0 0 0-.696 1.86v.024c0 1.724.503 2.513.998 2.937.563.481 1.397.736 2.476.86l1.567.182 1.954-.204c1.082-.112 1.912-.358 2.47-.833.492-.418.999-1.209.999-2.96v-.026a2.714 2.714 0 0 0-.696-1.86l-.582-.647.273-.826c.058-.178.096-.36.113-.545Z"
      clipRule="evenodd"
    />
  </svg>
);
