import React from "react";

export const TimelineIcon = (
  props: React.SVGProps<SVGSVGElement>,
): JSX.Element => (
  <svg
    width="31"
    height="23"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fill="#1890FF"
      fillRule="evenodd"
      d="M20.3641 6.7081a.9581.9581 0 0 0-.9582-.9582.9582.9582 0 0 0-.9583.9582v5.75c0 .2542.1009.4979.2806.6776l2.875 2.875a.9583.9583 0 0 0 1.3553 0c.3743-.3743.3743-.9811 0-1.3552l-2.5944-2.5943v-5.353Zm5.8178 11.5677c-1.8099 1.8101-4.2168 2.8071-6.7759 2.8071-2.5597 0-4.9663-.9969-6.7759-2.8071-1.8102-1.8099-2.8072-4.2164-2.8072-6.7759 0-2.5594.997-4.966 2.8072-6.776 1.8098-1.81 4.2163-2.807 6.7759-2.807 2.5593 0 4.9663.9969 6.7759 2.807C27.992 6.5342 28.989 8.9408 28.989 11.5c0 2.5597-.9969 4.9663-2.8071 6.7759ZM19.406 0c-3.072 0-5.9594 1.1964-8.1313 3.3688C9.1027 5.5404 7.9063 8.4283 7.9063 11.5s1.1963 5.9594 3.3684 8.1312C13.4467 21.8037 16.3343 23 19.406 23c3.0715 0 5.9589-1.1964 8.1312-3.3688 2.1724-2.1716 3.3688-5.0595 3.3688-8.1312s-1.1964-5.9594-3.3685-8.1312C25.3652 1.1963 22.4775 0 19.4062 0h-.0002Z"
      clipRule="evenodd"
    />
    <circle
      cx="2.4174"
      cy="20.5823"
      r="2.1152"
      fill="#fff"
      stroke="#1890FF"
      strokeWidth=".6043"
      transform="rotate(-90 2.4174 20.5823)"
    />
    <circle
      cx="2.4177"
      cy="20.5828"
      r="1.2087"
      fill="#1890FF"
      transform="rotate(-90 2.4177 20.5828)"
    />
    <circle
      cx="2.4174"
      cy="14.5387"
      r="1.8131"
      fill="#fff"
      stroke="#1890FF"
      strokeWidth="1.2087"
      transform="rotate(-90 2.4174 14.5387)"
    />
    <circle
      cx="2.4174"
      cy="8.4951"
      r="2.1152"
      fill="#fff"
      stroke="#1890FF"
      strokeWidth=".6043"
      transform="rotate(-90 2.4174 8.495)"
    />
    <circle
      cx="2.4177"
      cy="8.4954"
      r="1.2087"
      fill="#1890FF"
      transform="rotate(-90 2.4177 8.4954)"
    />
    <circle
      cx="2.4174"
      cy="2.4515"
      r="1.8131"
      fill="#fff"
      stroke="#1890FF"
      strokeWidth="1.2087"
      transform="rotate(-90 2.4174 2.4515)"
    />
    <path
      stroke="#1890FF"
      strokeLinecap="round"
      strokeWidth=".6043"
      d="M2.4166 18.4665v-1.813M2.4166 12.4229v-1.813M2.4166 6.3808v-1.813"
    />
  </svg>
);
