import * as React from "react";
import type { SVGProps } from "react";

const SvgRefine = ({ className, ...props }: SVGProps<SVGSVGElement>) => (
  <svg
    width="32"
    height="32"
    viewBox="0 0 32 32"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className ? className : undefined}
    {...props}
  >
    <g opacity="0.75">
      <path
        d="M17.6851 10.6108C17.6851 11.6913 16.8 12.5672 15.7082 12.5672C14.6163 12.5672 13.7312 11.6913 13.7312 10.6108C13.7312 9.53025 14.6163 8.65432 15.7082 8.65432C16.8 8.65432 17.6851 9.53025 17.6851 10.6108Z"
        fill="#1890FF"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.0872 8.07679C13.7824 7.38857 14.725 7.00133 15.7083 7C16.6916 7.00133 17.6343 7.38857 18.3295 8.07679C19.0247 8.76501 19.4157 9.69802 19.4167 10.6711V21.3301C19.4167 22.3034 19.026 23.2369 18.3305 23.9251C17.6351 24.6133 16.6918 25 15.7083 25C14.7248 25 13.7816 24.6133 13.0861 23.9251C12.3907 23.2369 12 22.3034 12 21.3301V10.6711C12.001 9.69802 12.392 8.76501 13.0872 8.07679ZM17.5456 8.85287C17.0584 8.37063 16.3975 8.09971 15.7083 8.09971C15.3671 8.09971 15.0292 8.16623 14.714 8.29545C14.3987 8.42468 14.1123 8.61409 13.871 8.85287C13.6297 9.09165 13.4383 9.37512 13.3078 9.6871C13.1772 9.99908 13.11 10.3335 13.11 10.6711V21.3301C13.11 22.0121 13.3837 22.6661 13.871 23.1484C14.3583 23.6306 15.0192 23.9015 15.7083 23.9015C16.3975 23.9015 17.0584 23.6306 17.5456 23.1484C18.0329 22.6661 18.3067 22.0121 18.3067 21.3301V10.6711C18.3067 9.98916 18.0329 9.3351 17.5456 8.85287Z"
        fill="#1890FF"
      />
    </g>
    <circle
      opacity="0.75"
      cx="16"
      cy="16"
      r="15.3333"
      stroke="url(#paint0_linear_1520_2185)"
      strokeWidth="1.33333"
    />
    <defs>
      <linearGradient
        id="paint0_linear_1520_2185"
        x1="16"
        y1="0"
        x2="16"
        y2="32"
        gradientUnits="userSpaceOnUse"
      >
        <stop stopColor="#3FDCF7" />
        <stop offset="1" stopColor="#1890FF" />
      </linearGradient>
    </defs>
  </svg>
);

export default SvgRefine;
