import clsx from "clsx";
import * as React from "react";
import type { SVGProps } from "react";

const SvgElide = ({ className, ...props }: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={48}
    height={48}
    viewBox="0 0 48 48"
    fill="none"
    className={clsx("dark:text-gray-0 text-[#273646]", className)}
    {...props}
  >
    <path
      fill="currentColor"
      d="M24 21.143c5.8 0 10.5 1.279 10.5 2.857 0 .732-1.01 1.4-2.673 1.905-1.923.584-4.717.952-7.827.952-3.11 0-5.904-.367-7.826-.952C14.51 25.399 13.5 24.732 13.5 24c0-1.578 4.701-2.857 10.5-2.857Zm10.5 20C34.5 42.721 29.8 44 24 44c-5.799 0-10.5-1.28-10.5-2.857v-3.81c0 1.578 4.701 2.857 10.5 2.857 5.8 0 10.5-1.279 10.5-2.857v3.81Zm0-5.714c0 1.578-4.7 2.857-10.5 2.857-5.799 0-10.5-1.28-10.5-2.857v-3.81c0 1.578 4.701 2.857 10.5 2.857 5.8 0 10.5-1.279 10.5-2.857v3.81Zm0-5.715c0 1.578-4.7 2.858-10.5 2.858-5.799 0-10.5-1.28-10.5-2.858v-3.81c0 1.579 4.701 2.858 10.5 2.858 5.8 0 10.5-1.28 10.5-2.857v3.81ZM29.256 19.238H17.71c-1.16 0-2.151-.426-2.975-1.278-.823-.853-1.235-1.879-1.235-3.08 0-1.008.294-1.9.882-2.674a4.09 4.09 0 0 1 2.27-1.526v-.157c0-1.809.617-3.348 1.852-4.618C19.74 4.635 21.224 4 22.954 4c1.344 0 2.559.404 3.643 1.213a6.394 6.394 0 0 1 2.281 3.17c1.547-.121 2.87.353 3.97 1.423 1.102 1.07 1.652 2.396 1.652 3.979 0 1.496-.512 2.779-1.538 3.848-1.025 1.07-2.26 1.605-3.706 1.605Zm-11.647-6.55c-.537 0-1.008.218-1.411.653a2.19 2.19 0 0 0-.605 1.54c0 .591.206 1.1.617 1.526.412.426.912.64 1.5.64h11.546c.874 0 1.618-.318 2.232-.953.613-.635.92-1.404.92-2.31 0-.904-.307-1.674-.92-2.309-.614-.634-1.358-.952-2.232-.952-.252 0-.537.052-.857.157l-1.134.34-.177-1.201c-.184-1.044-.663-1.91-1.437-2.597a3.936 3.936 0 0 0-2.697-1.03c-1.16 0-2.151.422-2.975 1.265-.823.844-1.235 1.866-1.235 3.066 0 .209.033.505.1.887l.253 1.305-1.488-.026Z"
    />
  </svg>
);

export default SvgElide;
