/** @type {import('@docusaurus/plugin-content-docs/src/sidebars/types').Sidebars} */
module.exports = {
  mainSidebar: [
    // Getting Started
    {
      type: "category",
      label: "Getting Started",
      className: "category-as-header",
      items: [
        "getting-started/overview",
        "getting-started/quickstart",
        {
          type: "link",
          href: "/tutorial/essentials/intro",
          label: "Tutorial",
        },
        {
          type: "link",
          href: "https://s.refine.dev/examples",
          label: "Examples",
          customProps: {
            external: true,
          },
        },
        {
          type: "link",
          href: "https://refine.dev/templates",
          label: "Templates",
          customProps: {
            external: true,
          },
        },
      ],
    },
    // Devtools
    {
      type: "link",
      href: "/enterprise",
      label: "Enterprise Edition",
      className: "enterprise-badge",
    },
    // Guides & Concepts
    {
      type: "category",
      label: "Guides & Concepts",
      className: "category-as-header",
      items: [
        "guides-concepts/general-concepts/index",
        "guides-concepts/data-fetching/index",
        "guides-concepts/forms/index",
        "guides-concepts/tables/index",
        "guides-concepts/routing/index",
        "guides-concepts/authentication/index",
        "guides-concepts/authorization/index",
        "guides-concepts/ui-libraries/index",
        "guides-concepts/notifications/index",
        "guides-concepts/realtime/index",
        "guides-concepts/audit-logs/index",
        "guides-concepts/multitenancy/index",
        "guides-concepts/import-export/index",
        "guides-concepts/i18n/index",
        "guides-concepts/usage-with-existing-projects/index",
        "guides-concepts/deployment/index",
        {
          type: "category",
          label: "Advanced Tutorials",
          link: {
            type: "generated-index",
            title: "Advanced Tutorials",
            slug: "/advanced-tutorials",
          },
          items: [
            "advanced-tutorials/access-control",
            {
              type: "category",
              label: "Auth",
              items: [
                "advanced-tutorials/auth/auth0",
                "advanced-tutorials/auth/azure-ad",
              ],
            },
            "advanced-tutorials/custom-layout",
            {
              type: "category",
              label: "Data Provider",
              items: ["advanced-tutorials/data-provider/handling-filters"],
            },
            {
              type: "category",
              label: "Form",
              items: ["advanced-tutorials/forms/custom-form-validation"],
            },
            "advanced-tutorials/real-time",
            "advanced-tutorials/multi-level-menu/multi-level-menu",
            "advanced-tutorials/mutation-mode",
            {
              type: "category",
              label: "Search",
              items: [
                "advanced-tutorials/search/list-search",
                "advanced-tutorials/search/search",
                "advanced-tutorials/search/table-search",
              ],
            },
            {
              type: "category",
              label: "Upload",
              items: [
                "advanced-tutorials/upload/base64-upload",
                "advanced-tutorials/upload/multipart-upload",
              ],
            },
            {
              type: "category",
              label: "Web3",
              items: ["advanced-tutorials/web3/ethereum-signin"],
            },
          ],
        },
        "guides-concepts/development/index",
        "guides-concepts/contributing/index",
        "guides-concepts/faq/index",
      ],
    },
    // Core API
    {
      type: "category",
      label: "Core",
      className: "category-as-header",
      items: [
        {
          type: "doc",
          id: "core/refine-component/index",
          label: "<Refine>",
        },
        "core/interface-references/index",
      ],
    },
    // Data
    {
      type: "category",
      label: "Data",
      className: "category-as-header",
      items: [
        "data/data-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: [
            "data/hooks/use-show/index",
            "data/hooks/use-table/index",
            "data/hooks/use-form/index",
            "data/hooks/use-select/index",
            "data/hooks/use-invalidate/index",
            "data/hooks/use-list/index",
            "data/hooks/use-infinite-list/index",
            "data/hooks/use-one/index",
            "data/hooks/use-many/index",
            "data/hooks/use-create/index",
            "data/hooks/use-create-many/index",
            "data/hooks/use-update/index",
            "data/hooks/use-update-many/index",
            "data/hooks/use-delete/index",
            "data/hooks/use-delete-many/index",
            "data/hooks/use-custom/index",
            "data/hooks/use-custom-mutation/index",
            "data/hooks/use-data-provider/index",
            "data/hooks/use-api-url/index",
          ],
        },
        {
          type: "category",
          label: "Packages",
          items: [
            "data/packages/airtable/index",
            "data/packages/appwrite/index",
            "data/packages/graphql/index",
            "data/packages/simple-rest/index",
            "data/packages/strapi-v4/index",
            "data/packages/supabase/index",
            "data/packages/nestjs-query/index",
            "data/packages/nestjsx-crud/index",
            "data/packages/hasura/index",
            "data/packages/community-data-providers/index",
          ],
        },
        {
          type: "category",
          label: "Examples",
          items: [
            "examples/data-provider/airtable",
            "examples/data-provider/appwrite",
            "examples/data-provider/directus",
            "examples/data-provider/elide",
            "examples/data-provider/hasura",
            "examples/data-provider/multiple",
            "examples/data-provider/nestjsxCrud",
            "examples/data-provider/nestjs-query",
            "examples/data-provider/strapi",
            "examples/data-provider/strapi-v4",
            "examples/data-provider/supabase",
            "examples/data-provider/sanity",
          ],
        },
      ],
    },
    // Router
    {
      type: "category",
      label: "Routing",
      className: "category-as-header",
      items: [
        "routing/router-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Integrations",
          items: [
            {
              type: "category",
              label: "React Router",
              link: {
                type: "doc",
                id: "routing/integrations/react-router/index",
              },
              items: [
                "routing/integrations/react-router/migration-guide-v6-to-v7",
              ],
            },
            "routing/integrations/next-js/index",
            "routing/integrations/remix/index",
          ],
        },
        {
          type: "category",
          collapsed: false,
          label: "Components",
          items: ["routing/components/link/index"],
        },
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: [
            "routing/hooks/use-resource-params/index",
            "routing/hooks/use-resource/index",
            "routing/hooks/use-go/index",
            "routing/hooks/use-back/index",
            "routing/hooks/use-parsed/index",
            "routing/hooks/use-link/index",
            "routing/hooks/use-get-to-path/index",
            "routing/hooks/use-navigation/index",
          ],
        },
        {
          type: "category",
          label: "Examples",
          items: [
            { type: "html", value: "Next.js" },
            "examples/next-js/nextjs",
            "examples/next-js/auth",
            "examples/next-js/NextAuth-js",
            { type: "html", value: "Remix" },
            "examples/remix/remix-headless",
            "examples/remix/remix-auth",
          ],
        },
      ],
    },
    // Authentication
    {
      type: "category",
      label: "Authentication",
      className: "category-as-header",
      items: [
        "authentication/auth-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Components",
          items: [
            "authentication/components/authenticated/index",
            "authentication/components/auth-page/index",
          ],
        },
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: [
            "authentication/hooks/use-is-authenticated/index",
            "authentication/hooks/use-on-error/index",
            "authentication/hooks/use-get-identity/index",
            "authentication/hooks/use-login/index",
            "authentication/hooks/use-logout/index",
            "authentication/hooks/use-permissions/index",
            "authentication/hooks/use-register/index",
            "authentication/hooks/use-forgot-password/index",
            "authentication/hooks/use-update-password/index",
          ],
        },
        {
          type: "category",
          label: "Examples",
          items: [
            "examples/authentication/headless",
            "examples/auth-provider/auth0",
            "examples/auth-provider/google-auth",
            "examples/auth-provider/keycloak",
            "examples/auth-provider/kinde",
            "examples/auth-provider/otpLogin",
          ],
        },
      ],
    },
    // Authorization
    {
      type: "category",
      label: "Authorization",
      className: "category-as-header",
      items: [
        "authorization/access-control-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Components",
          items: ["authorization/components/can-access/index"],
        },
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: ["authorization/hooks/use-can/index"],
        },
        {
          type: "category",
          label: "Examples",
          items: [
            "examples/access-control/casbin",
            "examples/access-control/cerbos",
            "examples/access-control/permify",
          ],
        },
      ],
    },
    // Realtime
    {
      type: "category",
      label: "Realtime",
      className: "category-as-header",
      items: [
        "realtime/live-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: [
            "realtime/hooks/use-publish/index",
            "realtime/hooks/use-subscription/index",
          ],
        },
        {
          type: "category",
          label: "Examples",
          items: ["examples/live-provider/ably"],
        },
      ],
    },
    // Notification
    {
      type: "category",
      label: "Notification",
      className: "category-as-header",
      items: [
        "notification/notification-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: ["notification/hooks/use-notification/index"],
        },
        {
          type: "category",
          label: "Examples",
          items: ["examples/notification-provider/react-toastify"],
        },
      ],
    },
    // i18n
    {
      type: "category",
      label: "I18n",
      className: "category-as-header",
      items: [
        "i18n/i18n-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: ["i18n/hooks/use-translation/index"],
        },
        {
          type: "category",
          label: "Examples",
          items: ["examples/i18n/i18n-nextjs", "examples/i18n/i18n-react"],
        },
      ],
    },
    // Audit Logs
    {
      type: "category",
      label: "Audit Logs",
      className: "category-as-header",
      items: [
        "audit-logs/audit-log-provider/index",
        {
          type: "category",
          collapsed: false,
          label: "Hooks",
          items: [
            "audit-logs/hooks/use-log/index",
            "audit-logs/hooks/use-log-list/index",
          ],
        },
        {
          type: "category",
          label: "Examples",
          items: [
            "examples/audit-log/audit-log-antd",
            "examples/audit-log/audit-log-provider",
          ],
        },
      ],
    },
    {
      type: "category",
      label: "Core Utilities",
      className: "category-as-header",
      items: [
        {
          type: "category",
          label: "Components",
          collapsed: false,
          items: [
            // TODO: add doc
            "core/components/auto-save-indicator/index",
            "core/components/inferencer/index",
          ],
        },
        {
          type: "category",
          label: "Hooks",
          collapsed: false,
          items: [
            "core/hooks/utilities/use-modal/index",
            "core/hooks/utilities/use-menu/index",
            "core/hooks/utilities/use-breadcrumb/index",
            "core/hooks/utilities/use-import/index",
            "core/hooks/utilities/use-export/index",
            "core/hooks/utilities/buttons/index",
          ],
        },
      ],
    },
    // UI Integrations
    {
      type: "category",
      label: "UI Integrations",
      className: "category-as-header",
      items: [
        // Ant Design
        {
          type: "category",
          label: "Ant Design",
          collapsed: false,
          // className: "category-as-header",
          items: [
            "ui-integrations/ant-design/introduction/index",
            {
              type: "category",
              label: "Components",
              items: [
                "ui-integrations/ant-design/components/themed-layout/index",
                "ui-integrations/ant-design/components/auth-page/index",
                "ui-integrations/ant-design/components/breadcrumb/index",
                "ui-integrations/ant-design/components/filter-dropdown/index",
                "ui-integrations/ant-design/components/auto-save-indicator/index",
                "ui-integrations/ant-design/components/inferencer/index",
                // "ui-integrations/ant-design/components/custom-inputs/index", // This should be included in the guide
                {
                  type: "category",
                  label: "Basic Views",
                  items: [
                    "ui-integrations/ant-design/components/basic-views/create/index",
                    "ui-integrations/ant-design/components/basic-views/edit/index",
                    "ui-integrations/ant-design/components/basic-views/list/index",
                    "ui-integrations/ant-design/components/basic-views/show/index",
                  ],
                },
                {
                  type: "category",
                  label: "Buttons",
                  items: [
                    "ui-integrations/ant-design/components/buttons/clone-button/index",
                    "ui-integrations/ant-design/components/buttons/create-button/index",
                    "ui-integrations/ant-design/components/buttons/delete-button/index",
                    "ui-integrations/ant-design/components/buttons/edit-button/index",
                    "ui-integrations/ant-design/components/buttons/export-button/index",
                    "ui-integrations/ant-design/components/buttons/import-button/index",
                    "ui-integrations/ant-design/components/buttons/list-button/index",
                    "ui-integrations/ant-design/components/buttons/refresh-button/index",
                    "ui-integrations/ant-design/components/buttons/save-button/index",
                    "ui-integrations/ant-design/components/buttons/show-button/index",
                  ],
                },
                {
                  type: "category",
                  label: "Fields",
                  items: [
                    "ui-integrations/ant-design/components/fields/boolean-field/index",
                    "ui-integrations/ant-design/components/fields/date-field/index",
                    "ui-integrations/ant-design/components/fields/email-field/index",
                    "ui-integrations/ant-design/components/fields/file-field/index",
                    "ui-integrations/ant-design/components/fields/image-field/index",
                    "ui-integrations/ant-design/components/fields/markdown-field/index",
                    "ui-integrations/ant-design/components/fields/number-field/index",
                    "ui-integrations/ant-design/components/fields/tag-field/index",
                    "ui-integrations/ant-design/components/fields/text-field/index",
                    "ui-integrations/ant-design/components/fields/url-field/index",
                  ],
                },
              ],
            },
            {
              type: "category",
              label: "Hooks",
              items: [
                "ui-integrations/ant-design/hooks/use-table/index",
                "ui-integrations/ant-design/hooks/use-editable-table/index",
                "ui-integrations/ant-design/hooks/use-simple-list/index",
                "ui-integrations/ant-design/hooks/use-form/index",
                "ui-integrations/ant-design/hooks/use-drawer-form/index",
                "ui-integrations/ant-design/hooks/use-modal-form/index",
                "ui-integrations/ant-design/hooks/use-steps-form/index",
                "ui-integrations/ant-design/hooks/use-select/index",
                "ui-integrations/ant-design/hooks/use-checkbox-group/index",
                "ui-integrations/ant-design/hooks/use-radio-group/index",
                "ui-integrations/ant-design/hooks/use-import/index",
                "ui-integrations/ant-design/hooks/use-modal/index",
              ],
            },
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/authentication/antd",
                "examples/table/antd/useTable",
                "examples/table/antd/tableFilter",
                "examples/table/antd/useEditableTable",
                "examples/table/antd/advancedTable",
                "examples/table/antd/useUpdateMany",
                "examples/table/antd/useDeleteMany",
                "examples/form/antd/useForm",
                "examples/form/antd/useModalForm",
                "examples/form/antd/useDrawerForm",
                "examples/form/antd/useStepsForm",
                "examples/form/antd/custom-form-validation",
                "examples/form/antd/serverSideFormValidation",
                "examples/upload/antd/base64",
                "examples/upload/antd/multipart",
                "examples/import-export/antd",
                "examples/antd-calendar-example",
                "examples/customization/theme/customThemeAntd",
                "examples/themes/refine-themes-antd",
                "examples/remix/remix-antd",
                "examples/storybook/antd-storybook",
              ],
            },
            "ui-integrations/ant-design/theming/index",
            "ui-integrations/ant-design/migration-guide/index",
          ],
        },
        // Material UI
        {
          type: "category",
          label: "Material UI",
          collapsed: false,
          // className: "category-as-header",
          items: [
            "ui-integrations/material-ui/introduction/index",
            {
              type: "category",
              label: "Components",
              items: [
                "ui-integrations/material-ui/components/themed-layout/index",
                "ui-integrations/material-ui/components/auth-page/index",
                "ui-integrations/material-ui/components/breadcrumb/index",
                "ui-integrations/material-ui/components/auto-save-indicator/index",
                "ui-integrations/material-ui/components/inferencer/index",
                {
                  type: "category",
                  label: "Basic Views",
                  items: [
                    "ui-integrations/material-ui/components/basic-views/create/index",
                    "ui-integrations/material-ui/components/basic-views/edit/index",
                    "ui-integrations/material-ui/components/basic-views/list/index",
                    "ui-integrations/material-ui/components/basic-views/show/index",
                  ],
                },
                {
                  type: "category",
                  label: "Buttons",
                  items: [
                    "ui-integrations/material-ui/components/buttons/clone-button/index",
                    "ui-integrations/material-ui/components/buttons/create-button/index",
                    "ui-integrations/material-ui/components/buttons/delete-button/index",
                    "ui-integrations/material-ui/components/buttons/edit-button/index",
                    "ui-integrations/material-ui/components/buttons/export-button/index",
                    "ui-integrations/material-ui/components/buttons/import-button/index",
                    "ui-integrations/material-ui/components/buttons/list-button/index",
                    "ui-integrations/material-ui/components/buttons/refresh-button/index",
                    "ui-integrations/material-ui/components/buttons/save-button/index",
                    "ui-integrations/material-ui/components/buttons/show-button/index",
                  ],
                },
                {
                  type: "category",
                  label: "Fields",
                  items: [
                    "ui-integrations/material-ui/components/fields/boolean-field/index",
                    "ui-integrations/material-ui/components/fields/date-field/index",
                    "ui-integrations/material-ui/components/fields/email-field/index",
                    "ui-integrations/material-ui/components/fields/file-field/index",
                    "ui-integrations/material-ui/components/fields/markdown-field/index",
                    "ui-integrations/material-ui/components/fields/number-field/index",
                    "ui-integrations/material-ui/components/fields/tag-field/index",
                    "ui-integrations/material-ui/components/fields/text-field/index",
                    "ui-integrations/material-ui/components/fields/url-field/index",
                  ],
                },
              ],
            },
            {
              type: "category",
              label: "Hooks",
              items: [
                "ui-integrations/material-ui/hooks/use-auto-complete/index",
                "ui-integrations/material-ui/hooks/use-data-grid/index",
              ],
            },
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/authentication/mui",
                "examples/table/mui/useDataGrid",
                "examples/table/mui/filter",
                "examples/table/mui/advanced",
                "examples/table/mui/cursor-pagination",
                "examples/table/mui/useUpdateMany",
                "examples/table/mui/useDeleteMany",
                "examples/form/mui/useForm",
                "examples/form/mui/useModalForm",
                "examples/form/mui/useDrawerForm",
                "examples/form/mui/useStepsForm",
                "examples/form/mui/serverSideFormValidation",
                "examples/upload/mui/base64",
                "examples/upload/mui/multipart",
                "examples/import-export/material-ui",
                "examples/customization/theme/customThemeMaterialUI",
                "examples/themes/refine-themes-mui",
                "examples/remix/remix-material-ui",
                "examples/storybook/material-ui-storybook",
              ],
            },
            "ui-integrations/material-ui/theming/index",
            {
              type: "category",
              label: "Migration Guide",
              items: [
                "ui-integrations/material-ui/migration-guide/material-ui-v5-to-v6",
                "ui-integrations/material-ui/migration-guide/x-data-grid-v4-to-v5",
              ],
            },
          ],
        },
        // Chakra UI
        {
          type: "category",
          label: "Chakra UI",
          collapsed: false,
          // className: "category-as-header",
          items: [
            "ui-integrations/chakra-ui/introduction/index",
            {
              type: "category",
              label: "Components",
              items: [
                "ui-integrations/chakra-ui/components/themed-layout/index",
                "ui-integrations/chakra-ui/components/auth-page/index",
                "ui-integrations/chakra-ui/components/breadcrumb/index",
                "ui-integrations/chakra-ui/components/auto-save-indicator/index",
                "ui-integrations/chakra-ui/components/inferencer/index",
                {
                  type: "category",
                  label: "Basic Views",
                  items: [
                    "ui-integrations/chakra-ui/components/basic-views/create/index",
                    "ui-integrations/chakra-ui/components/basic-views/edit/index",
                    "ui-integrations/chakra-ui/components/basic-views/list/index",
                    "ui-integrations/chakra-ui/components/basic-views/show/index",
                  ],
                },
                {
                  type: "category",
                  label: "Buttons",
                  items: [
                    "ui-integrations/chakra-ui/components/buttons/clone-button/index",
                    "ui-integrations/chakra-ui/components/buttons/create-button/index",
                    "ui-integrations/chakra-ui/components/buttons/delete-button/index",
                    "ui-integrations/chakra-ui/components/buttons/edit-button/index",
                    "ui-integrations/chakra-ui/components/buttons/export-button/index",
                    "ui-integrations/chakra-ui/components/buttons/import-button/index",
                    "ui-integrations/chakra-ui/components/buttons/list-button/index",
                    "ui-integrations/chakra-ui/components/buttons/refresh-button/index",
                    "ui-integrations/chakra-ui/components/buttons/save-button/index",
                    "ui-integrations/chakra-ui/components/buttons/show-button/index",
                  ],
                },
                {
                  type: "category",
                  label: "Fields",
                  items: [
                    "ui-integrations/chakra-ui/components/fields/boolean-field/index",
                    "ui-integrations/chakra-ui/components/fields/date-field/index",
                    "ui-integrations/chakra-ui/components/fields/email-field/index",
                    "ui-integrations/chakra-ui/components/fields/file-field/index",
                    "ui-integrations/chakra-ui/components/fields/markdown-field/index",
                    "ui-integrations/chakra-ui/components/fields/number-field/index",
                    "ui-integrations/chakra-ui/components/fields/tag-field/index",
                    "ui-integrations/chakra-ui/components/fields/text-field/index",
                    "ui-integrations/chakra-ui/components/fields/url-field/index",
                  ],
                },
              ],
            },
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/authentication/chakra-ui",
                "examples/table/chakra-ui/basic",
                "examples/table/chakra-ui/advanced-react-table",
                "examples/form/chakra-ui/useForm",
                "examples/form/chakra-ui/useModalForm",
                "examples/form/chakra-ui/useDrawerForm",
                "examples/form/chakra-ui/serverSideFormValidation",
                "examples/upload/chakra-ui/base64",
                "examples/upload/chakra-ui/multipart",
                "examples/customization/theme/customThemeChakraUI",
                "examples/themes/refine-themes-chakra-ui",
              ],
            },
            "ui-integrations/chakra-ui/theming/index",
          ],
        },
        // Mantine
        {
          type: "category",
          label: "Mantine",
          collapsed: false,
          // className: "category-as-header",
          items: [
            "ui-integrations/mantine/introduction/index",
            {
              type: "category",
              label: "Components",
              items: [
                "ui-integrations/mantine/components/themed-layout/index",
                "ui-integrations/mantine/components/auth-page/index",
                "ui-integrations/mantine/components/breadcrumb/index",
                "ui-integrations/mantine/components/auto-save-indicator/index",
                "ui-integrations/mantine/components/inferencer/index",
                {
                  type: "category",
                  label: "Basic Views",
                  items: [
                    "ui-integrations/mantine/components/basic-views/create/index",
                    "ui-integrations/mantine/components/basic-views/edit/index",
                    "ui-integrations/mantine/components/basic-views/list/index",
                    "ui-integrations/mantine/components/basic-views/show/index",
                  ],
                },
                {
                  type: "category",
                  label: "Buttons",
                  items: [
                    "ui-integrations/mantine/components/buttons/clone-button/index",
                    "ui-integrations/mantine/components/buttons/create-button/index",
                    "ui-integrations/mantine/components/buttons/delete-button/index",
                    "ui-integrations/mantine/components/buttons/edit-button/index",
                    "ui-integrations/mantine/components/buttons/export-button/index",
                    "ui-integrations/mantine/components/buttons/import-button/index",
                    "ui-integrations/mantine/components/buttons/list-button/index",
                    "ui-integrations/mantine/components/buttons/refresh-button/index",
                    "ui-integrations/mantine/components/buttons/save-button/index",
                    "ui-integrations/mantine/components/buttons/show-button/index",
                  ],
                },
                {
                  type: "category",
                  label: "Fields",
                  items: [
                    "ui-integrations/mantine/components/fields/boolean-field/index",
                    "ui-integrations/mantine/components/fields/date-field/index",
                    "ui-integrations/mantine/components/fields/email-field/index",
                    "ui-integrations/mantine/components/fields/file-field/index",
                    "ui-integrations/mantine/components/fields/markdown-field/index",
                    "ui-integrations/mantine/components/fields/number-field/index",
                    "ui-integrations/mantine/components/fields/tag-field/index",
                    "ui-integrations/mantine/components/fields/text-field/index",
                    "ui-integrations/mantine/components/fields/url-field/index",
                  ],
                },
              ],
            },
            {
              type: "category",
              label: "Hooks",
              items: [
                "ui-integrations/mantine/hooks/use-form/index",
                "ui-integrations/mantine/hooks/use-drawer-form/index",
                "ui-integrations/mantine/hooks/use-modal-form/index",
                "ui-integrations/mantine/hooks/use-steps-form/index",
                "ui-integrations/mantine/hooks/use-select/index",
              ],
            },
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/authentication/mantine",
                "examples/table/mantine/basic",
                "examples/table/mantine/advanced-react-table",
                "examples/form/mantine/useForm",
                "examples/form/mantine/useModalForm",
                "examples/form/mantine/useDrawerForm",
                "examples/form/mantine/useStepsForm",
                "examples/form/mantine/serverSideFormValidation",
                "examples/upload/mantine/base64",
                "examples/upload/mantine/multipart",
                "examples/import-export/mantine",
                "examples/customization/theme/customThemeMantine",
                "examples/themes/refine-themes-mantine",
              ],
            },
            "ui-integrations/mantine/theming/index",
          ],
        },
      ],
    },
    // Packages
    {
      type: "category",
      label: "Packages",
      className: "category-as-header",
      items: [
        "packages/list-of-packages/index",
        // React Table
        {
          type: "category",
          label: "React Table",
          collapsed: false,
          items: [
            "packages/tanstack-table/introduction/index",
            "packages/tanstack-table/use-table/index",
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/table/tanstack-table/basic-tanstack-table",
                "examples/table/tanstack-table/advanced-tanstack-table",
              ],
            },
          ],
        },
        // React Hook Form
        {
          type: "category",
          label: "React Hook Form",
          collapsed: false,
          items: [
            "packages/react-hook-form/introduction/index",
            "packages/react-hook-form/use-form/index",
            "packages/react-hook-form/use-modal-form/index",
            "packages/react-hook-form/use-steps-form/index",
            {
              type: "category",
              label: "Examples",
              items: [
                "examples/form/react-hook-form/useForm",
                "examples/form/react-hook-form/useModalForm",
                "examples/form/react-hook-form/useStepsForm",
              ],
            },
          ],
        },
        "packages/cli/index",
        // "packages/devtools/index",
        "packages/inferencer/index",
        "packages/command-palette/index",
      ],
    },
    // Enterprise Edition
    {
      type: "category",
      label: "Enterprise Edition",
      className: "category-as-header",
      items: [
        "enterprise-edition/index",
        "enterprise-edition/okta/index",
        "enterprise-edition/devtools/index",
        "enterprise-edition/multitenancy/index",
      ],
    },
    // Migration Guide
    {
      type: "category",
      label: "Migration Guide 🚀",
      className: "category-as-header",
      items: [
        "migration-guide/3x-to-4x",
        "migration-guide/auth-provider",
        "migration-guide/router-provider",
      ],
    },
    // Further Readings
    {
      type: "category",
      label: "Further Readings",
      className: "category-as-header",
      items: [
        "further-readings/testing",
        "further-readings/telemetry",
        "further-readings/comparison",
        "further-readings/license",
      ],
    },
  ],
};
