---
title: refine Open Source Hackathon 2
description: The second Refine Open Source Hackathon is an excellent opportunity for developers to showcase their skills, learn Refine and win prizes!
slug: refine-hackathon-2
authors: necati
tags: [community, Refine]
image: https://refine.ams3.cdn.digitaloceanspaces.com/hackathon-2/hackathon_cover.png
hide_table_of_contents: false
---

## 🏆 Hackathon Winners

🎉 Congratulations to all the participants.

The hackathon has officially wrapped up, and we're seriously blown away by the incredible results you've achieved. Picking the winners from all the outstanding submissions was quite a challenge!

A big shoutout to our awesome sponsors - [Supabase](https://supabase.com/) and [MUI](https://mui.com/)! Thanks for teaming up with us to make this hackathon a massive hit.

🥳 To all the participants, you're all superstars!

After much consideration, we're thrilled to announce the well-deserved winners who really stood out from the crowd.

Let's celebrate their success together!

## ⭐ Best Overall Project

<div className="centered-image">
   <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-08-04-refine-hackathon-2-winners/refine-native.png"  alt="docker volume" />
</div>

### Refine Native

Refine Native, the empowering library for Refine, opens up a world of possibilities for creating cross-platform apps. You can build web and native crud apps 3x faster by leveraging the power of React Native and refine.

Inside this project, you'll discover two awesome libraries: [@refinenative/expo-router](https://www.npmjs.com/package/@refinenative/expo-router) and [@refinenative/react-native-paper](https://www.npmjs.com/package/@refinenative/react-native-paper). The first one seamlessly integrates Refine with your expo-router project, while the second one provides handy components built with react-native-paper, speeding up the creation of CRUD pages.

**Author**: [Abdellah](https://github.com/abdellah711) - [GitHub Repo](https://github.com/abdellah711/refinenative) - [Project Details](https://dev.to/abdellah711/refine-native-2p1d)  
**Prize**: **$1000 + Refine, Supabase, MUI Swag kits, $300 USD credit to the DEV Shop!**

## ⭐ Most Technically Impressive

<div className="centered-image">
   <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-08-04-refine-hackathon-2-winners/supaheroes.png"  alt="docker volume" />
</div>

### Supaheroes

Introducing Supaheroes, the AI-powered platform that crafts character biographies from your favorite games, comics, and movies. Unleash the power of AI to bring your beloved characters to life!

**Author**: [Luis](https://twitter.com/asyncerror) - [GitHub Repo](https://github.com/lvisb/versus-heroes) - [Project Details](https://dev.to/asyncerror/supaheroes-ai-powered-heroes-3f3j)  
**Prize**: **$1000 + Refine, Supabase, MUI Swag kits, $300 USD credit to the DEV Shop!**

## ⭐ Most Visually Pleasing

<div className="centered-image">
   <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-08-04-refine-hackathon-2-winners/tripstash.png"  alt="docker volume" />
</div>

### TripStash: Travel planning tool

TripStash is designed to help users plan their trips efficiently and easily. Collaborate seamlessly, plan effortlessly, and manage your trips like never before—all in one place.

Creating a project, inviting travel companions, and building a shared itinerary for accommodation, flights, sightseeing, dining, and more is a breeze! Travel planning has never been this easy.

**Authors**: [Brinda](https://twitter.com/brindashree6) - [Akshay](https://github.com/aKshayKadam03) - [Rahul](https://www.linkedin.com/in/rahul-nadendla-34212252) - [GitHub Repo](https://github.com/brindashree/trip-stash) - [Project Details](https://dev.to/brindashree/tripstash-2o7k)  
**Prize**: **$1000 + Refine, Supabase, MUI Swag kits, $300 USD credit to the DEV Shop!**

## ⭐ Best Project Using Supabase

<div className="centered-image">
   <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-08-04-refine-hackathon-2-winners/anisong.png"  alt="docker volume" />
</div>

### Anisong: Anime playlist creator

Anisong, a web app that lets you curate personalized playlists filled with the most captivating opening and ending theme songs from your beloved anime series. Enjoy the perfect anime soundtrack tailored just for you!

**Author**: [Darius Pasca](https://twitter.com/pasca_darius) - [GitHub Repo](https://github.com/dariuspasca/anisong) - [Project Details](https://dev.to/dariuspasca/anisong-your-personal-anime-playlist-creator-3cmd)  
**Prize**: **$1000 + Refine, Supabase, MUI Swag kits, $300 USD credit to the DEV Shop!**

## ⭐ Best Project Using Material UI

<div className="centered-image">
   <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-08-04-refine-hackathon-2-winners/rvsquick.png"  alt="docker volume" />
</div>

### RSVQuick: Online Invitation App

RSVP Plus, your one-stop solution for creating and sending personalized online RSVP invitations with optional surveys and questions to gather valuable insights from your potential attendees in no time!

**Author**: [Ansell Maximilian](https://twitter.com/AnsellMax) - [GitHub Repo](https://github.com/AnsellMaximilian/rsvquick) - [Project Details](https://dev.to/ansellmaximilian/rsvquick-online-invitation-app-made-using-refine-148e)  
**Prize**: **$1000 + Refine, Supabase, MUI Swag kits, $300 USD credit to the DEV Shop!**

## 👼 Runners-Up, in random order!

**All runner-ups will get $250 USD + Special Swag Kits from Refine + $150 USD credit to the DEV Shop**

### Prompteer - AI Prompts & Engaging comments

A prompt sharing platform where users can share their AI prompts and receive comments

**Author**: [Mateus Abelli](https://twitter.com/mateusabelli) - [GitHub Repo](https://github.com/mateusabelli/prompteer) - [Project Details](https://dev.to/mateusabelli/prompteer-ai-prompts-engaging-comments-3h7o)

### Managify: Manage Your Teams Easily

A real-time collaboration platform with team management, task tracking, and chat features.

**Author**: [Rasir Colakel](https://twitter.com/rasitcolakel) - [GitHub Repo](https://github.com/rasitcolakel/managify) - [Project Details](https://dev.to/rasitcolakel/manage-your-team-easily-with-managify-5gbp)

### Rapply: The All-In-One Job Hunting Assistant

Rapply aims to simplify and streamline the job search journey by offering a comprehensive solution that combines an Application Tracker, Personalized Cover Letter Generator, and Resume Builder.

**Author**: [Mahir Mahdi](https://twitter.com/_MahirMahdi) - [GitHub Repo](https://github.com/MahirMahdi/Rapply) - [Project Details](https://dev.to/mahirmahdi/rapply-supercharge-your-job-search-with-the-all-in-one-job-hunting-assistant-159f)

### Competee: An online competition platform

The platform enables individuals to host their competitions, providing opportunities for others to participate and showcase their abilities.

**Author**: [Alex](https://github.com/alexcode4ever) - [GitHub Repo](https://github.com/alexcode4ever/competee) - [Project Details](https://dev.to/alexcode4ever/competee-an-online-competition-platform-to-unleash-hidden-talents-nci)

### Librify - Modern Library Management

The system enables librarians to add, modify, and remove books from the library catalog.

**Author**: [Joel Janison](https://github.com/JoelJaison394) - [GitHub Repo](https://github.com/JoelJaison394/Librify) - [Project Details](https://dev.to/joeljaison394/librify-modern-library-management-with-refine-42bg)

### Dev-Gym - Test your skills with AI assistance

Dev-Gym is a testing platform with a hacker-inspired design, designed to assist programmers in refining their skills using AI-powered hints.

**Author**: [Pawel Ciosek](https://github.com/pavelee) - [GitHub Repo](https://github.com/pavelee/dev-gym) - [Project Details](https://dev.to/pavelee/test-your-skills-with-ai-assistance-n06)

### Stream discovery - find a streamer

With Stream Discovery, you can easily discover, create, and rate Twitch streamers to enhance your streaming experience!

**Author**: [Ondra Šimanovský](https://twitter.com/OndraSimanovsky) - [GitHub Repo](https://github.com/JustOndra/stream-discovery) - [Project Details](https://dev.to/simanovskyondrej/stream-discovery-find-a-streamer-5eoh)

### GTFC: Municipality's Monitoring

This platform is a product of the LOG (Local Open GovLab) project, which is an innovative initiative under the AfricTivists Strategic Program. Its primary goal is to support, empower, train, and assist local administrations in incorporating digital tools for budget transparency, open and inclusive governance, information accessibility, and collaborative citizen engagement.

**Author**: [NioulBoy](https://twitter.com/mbayedione10) - [GitHub Repo](https://github.com/localopengovlab/gtfc-admin) - [Project Details](https://dev.to/mbayedione10/transparent-and-organized-governance-gtfc-municipalitys-monitoring-and-evaluation-platform-e61)

### Keronote UI: Create Animations

A simple, but fun animated canvas, with several tools and others features in web.

**Author**: [Media-Collab](https://twitter.com/Media__Collab)- [GitHub Repo](https://github.com/Media-Collab/keronoteui) - [Project Details](https://dev.to/gregoryinnovo/keronote-ui-30in)

### React-Analytics

A library that tracks the analytics of your react-website. Easy to use with a single line of code.

**Author**: [Jatin Rawat](https://www.linkedin.com/in/rawat-jatin/) - [GitHub Repo](https://github.com/Kaku-g/react-analytics) - [Project Details](https://dev.to/kakug/react-analytics-20fd)

##  🎟️ Hackathon Participant Ticket Raffle Winners

Below are the raffle winners who generated hackathon participant tickets. The prizes include a Refine cap and coaster set.

- Rishabh Raj Kumar - rajrishabh377@gmail.com - https://github.com/Rishabh-raj-kumar
- Leonel Pech - jleonelpm@hotmail.com - https://github.com/jleonelpm
- Harsh Singh - harshsinghcs01@gmail.com - https://github.com/harshsinghcs
- Muhammed Nazeem - nazeemnob18@gmail.com - https://github.com/n4ze3m
- Maaz Khan - maaz.masood@inaequostudios.com - https://github.com/maazkhan2023
- Gokul nath - gokulnath634@gmail.com - https://github.com/grroott
- Marvel Ken-Anele - marvelken2000@gmail.com - https://github.com/marvelken
- Teri Eyenike - teyenike1@gmail.com - https://github.com/Terieyenike
- Arpan Chowdhury - arpanchowdhury003@gmail.com - https://github.com/apu52
- astitva - astitv87@gmail.com - https://github.com/astitva0011

<br/>

## Hackathon Details

We're back with another exciting event for the open-source community - the 2nd Refine Open Source Hackathon!

As with the first one, this Hackathon is about showcasing your skills, creativity, and innovation using refine.

**[Refine](https://github.com/refinedev/refine)** is a React-based framework for the rapid ✨ development of CRUD web applications. It eliminates the repetitive tasks demanded by CRUD operations and provides industry-standard solutions for critical parts like authentication, access control, routing, networking, state management, and i18n. Refine shines on data-intensive applications like admin panels, dashboards, internal tools, and storefronts.

⏰ The Hackathon will kick off on June 21, and we're proud to host it in collaboration with the [DEV](https://dev.to/refine) platform. All the other hackathon details and submission process will be announced on the official launch day on [DEV](https://dev.to/).

🚀 The prizel pool is **$10,000** in total and a special gifts along with **limited edition** swag kits!

🔔 To stay updated on the official start of the Hackathon, please join us on our [Discord](https://discord.gg/refine) and [Twitter](https://twitter.com/refine_dev).

We can't wait to see what unique projects the participants will build projects using **Refine**.

## Get your hackathon participation ticket 🎟️

We are organizing a raffle for those who create a ticket and share it on Twitter. As a gift, we are giving away a Refine [cap](https://store.refine.dev/product/refine-cap) and a [coaster](https://store.refine.dev/product/coaster) set valued at $60.

### 🔗 [Generate participation ticket ](https://hackathon.refine.dev)

[![ticket](https://refine.ams3.cdn.digitaloceanspaces.com/hackathon-2/hackathon_ticket.jpeg)](https://hackathon.refine.dev)

## Together with Open Source Community

Refine draws its strength from the open-source community, and we are grateful to have the support of [Supabase](https://supabase.com/) and [MUI](https://mui.com/material-ui/getting-started/overview/), which has significant contributions to the community. We're proud to host our second Hackathon in collaboration with the [DEV](https://dev.to/refine) platform.

It's worth noting that Refine has built-in [data provider support](https://refine.dev/docs/packages/documentation/data-providers/supabase) for Supabase and [UI framework integration](https://refine.dev/docs/api-reference/mui/) for Material UI. So we believe they will be excellent backend and UI solutions for your hackathon project.

Supabase and MUI will also be providing swag kits for the winners.

![sponsors](https://refine.ams3.cdn.digitaloceanspaces.com/hackathon-2/sponsor_banner.png)

## Hackathon Key Facts

- You have 4 weeks to build a cool Open Source project using **Refine**.
- Build a **Refine** app. It can be anything like the CRUD app, admin panel, internal tool, forms, storefront, or dashboard. Also you can build a library, data provider, auth provider or live provider etc. for refine.
- 🔥 You can use [Refine browser tool](https://refine.dev/?playground=true) to create a complete Refine CRUD app in 10 seconds and built your hackathon project on top of it.

## Details

### Schedule

- The Hackathon begins on Wednesday, 21th June 2023
- Work on your project any time for the next four weeks
- Submission deadline (Monday, July 20, 2023)
- The winners will be announced on Monday, July 26, 2023

### Prizes 🎁

The total prize pool amount is **$10,000**. The distribution of prizes will be announced on the [DEV](https://dev.to/) platform on the launch day. There are five categories in which participants can win, and prizes will be awarded for each category.

#### Main Prize Categories

- **Best Overall Project**
- **Most Visually Pleasing**
- **Most Technically Impressive**

You can use any data provider or UI framework in the Refine app for the three main prize categories above.

#### Sponsor's special prize categories

- **Best Project built using [Supabase](https://supabase.com/)**
  - The project must use Supabase as a data provider in the Refine app
- **Best Project built using [Material UI](https://mui.com/material-ui/getting-started/overview/)**
  - The project must use Material UI as the UI framework in the Refine app

#### Runner-up

- There will be ten runner-up prizes.

⚡ Also, the winners will get [Refine Special Swag Kit](https://store.refine.dev/product/hackathon-swag-kit) + Swag Kits from **Supabase** and **MUI**.

<br/>

![swag_kits](https://refine.ams3.cdn.digitaloceanspaces.com/hackathon-2/swag_kit.jpeg)

## Submission

- Submissions activated on [DEV](https://dev.to/) platform on 21th of June.
- All detailed information on submissions will be explained on the DEV Hackathon Launch day.

## Rules

- All code for your project must be created during the hackathon event.
- All entries must be Open Source.
- The apps must be built using **Refine** framework.
- Team size 1-5 (you cannot be in multiple teams).
- One submission per team.

## Community

The **Refine** team will be taking part in the Hackathon, and you'll find us live building in our Discord all week.

- Join us in our [Discord](https://discord.gg/refine) to get help, ask questions, and share your progress. You can also find a potential teammate on the Discord hackathon channel.
  - Forum channel: **Hackathon**
- Follow us on [Twitter](https://twitter.com/refine_dev) for updates and announcements.
- [Refer to Refine GitHub repository](https://github.com/refinedev/refine)

## FAQ

### What kind of projects can I submit?

- You must build an app using Refine framework. It can be anything like the CRUD app, admin panel, internal tool, forms, storefront, and dashboard. Also, you can build a library, data provider, auth provider or live provider etc. for refine.
- For the **Best Refine Project built using Supabase** category, you need to use Supabase as a data provider in the Refine app.
- For the **Best Refine Project built using Material UI** category, you need to use Material UI as the UI framework in the Refine app.

### How are the prizes given?

- Prizes will be distributed by the DEV platform.

### What are the judging criteria?

- The Judges will be senior staff from the Refine DevRel, Marketing, and Engineering Teams.
- Judging criteria:
  - Quality: It is evaluated based on its creativity and originality.
  - Design: The design of the idea is judged based on its user experience and visual appeal.
  - The technical implementation: It is assessed how well the idea was executed by the developer and how effectively Refine was used in the submission.

### How are the prize and swag kits given if the teams project wins?

- Only one prize and one swag kit will be given per winner project. You can distribute the prize to your team.

## Useful resources

- You can step up to complete CRUD app tutorials to learn **Refine** and how it works.
  - https://refine.dev/tutorial
- You can look at a real use case example projects built with **Refine** to get inspiration.
  - https://refine.dev/examples/
- Check out the Refine Supabase integration docs:
  - https://refine.dev/docs/packages/documentation/data-providers/supabase/
- Check out the Material UI docs on Refine
  - https://refine.dev/docs/api-reference/mui/
- [Refer to Supabase Docs](https://supabase.com/docs)
- [Refer to Material UI Docs](https://mui.com/material-ui/getting-started/overview/)
- [Refine 7/24 Discord Support Channel](https://discord.gg/refine)
