---
title: refine.new - Introducing the Fastest Way to Create Refine Apps
description: Discover how refine.new and the Refine framework are transforming the way developers create front-end applications in the React ecosystem
slug: what-is-refine-new
authors: necati
tags: [community, Refine]
image: https://refine.ams3.cdn.digitaloceanspaces.com/blog/2023-05-10-what-is-refine-new/social.png
hide_table_of_contents: false
---

## Introduction

I would like to introduce our new open source browser tool - [refine.new](https://refine.new/) for creating Refine apps and how its transforming the way developers create web applications in the React ecosystem.

Let's recap the Refine architecture first 💙

As you know, [Refine](https://github.com/refinedev/refine) is an open-source React-based framework designed to simplify and accelerate the development of web applications with SSR support with [Next.js](https://nextjs.org/) or [Remix](https://remix.run/).  
It is specifically tailored for data-intensive applications like admin panels, dashboards, and internal tools, but can also power customer-facing applications like storefronts and any type of CRUD apps.

 <div className="centered-image"  >
  <a href="https://github.com/refinedev/refine">
  <img style={{alignSelf:"center", width:"600px"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/website/static/img/diagram.png
" alt="refine banner" />
</a>
</div>

<br/>

It eliminates repetitive tasks in CRUD operations and provides industry-standard solutions for critical project components like **authentication**, **access control**, **routing**, **networking**, **state management**, and **i18n**.

The Refine is **headless by design**, offering unlimited styling and customization options. Moreover, Refine ships with ready-made integrations for [Ant Design](https://ant.design/), [Material UI](https://mui.com/material-ui/getting-started/overview/), [Mantine](https://mantine.dev/), and [Chakra UI](https://chakra-ui.com/) for convenience.

Refine has connectors for 15+ backend services, including REST API, [GraphQL](https://graphql.org/), and popular services like [Airtable](https://www.airtable.com/), [Strapi](https://strapi.io/), [Supabase](https://supabase.com/), [Firebase](https://firebase.google.com/), and [Directus](https://directus.io/)

[Refer to documentation for more info about Refine&#8594](https://refine.dev/docs/)
[Step up to Refine tutorials &#8594](https://refine.dev/tutorial)

✨ With the introduction of [refine.new](https://refine.new/), developers can now create Refine apps in just **15 seconds**.

## What is refine.new?

[refine.new](https://refine.new/) is an innovative browser-based tool that lets you create a new Refine application in just 15 seconds by making step-by-step selections directly in your browser.

<br/>

 <div className="centered-image"  >
  <a href="https://refine.new/">
  <img   src="https://refine.ams3.cdn.digitaloceanspaces.com/website/static/img/quick-start.gif" alt="refine banner" />
</a>
</div>

<br/>

The tool allows you to create a wide range of project variations by selecting your desired

- React platform ([Vite.js](https://vitejs.dev/), [Next.js](https://nextjs.org/) or [Remix](https://remix.run/)),
- UI framework ( [Ant Design](https://ant.design/), [Material UI](https://mui.com/material-ui/getting-started/overview/), [Mantine](https://mantine.dev/), and [Chakra UI](https://chakra-ui.com/), or headless UI option),
- Backend service (REST API, [Supabase](https://supabase.com/), [Strapi](https://strapi.io/), [NestJs](https://nestjs.com/), [Appwrite](https://appwrite.io/), or [Airtable](https://www.airtable.com/)),
- Authentication provider (Google Auth, Keycloak, Auth0, Supabase, Appwrite, Strapi, custom auth).

Once you make your selections, [refine.new](https://refine.new/) creates a complete CRUD app tailored to your specifications in just 2 seconds.

The generated application comes with fully working authentication, CRUD operation components, and pages with fully functional code. You can change the theme color, logo, preview the app, and test CRUD actions and pages.

Considering the build step options provided by refine.new, there are numerous possible project variations. With three React platforms, five UI frameworks, six backend services, and eight authentication providers to choose from, you can create 720 different combinations, each tailored to your specific project needs.

You can download the complete project code and use as a starting point for your project.

💥 Yes, it's fully open source and free to use.

View the example Refine app built using refine.new from [this link](https://refine.new/preview/8606c751-2ea8-47cd-a8fe-b8a01b4a0951).

 <div className="centered-image"  >
<a href="https://refine.new/preview/8606c751-2ea8-47cd-a8fe-b8a01b4a0951">
  <img style={{alignSelf:"center"}}  src="https://refine.ams3.cdn.digitaloceanspaces.com/website/static/tutorial/antd-intro.png" alt="tutorial antd" />
  </a>
</div>

## Why do developers need Refine?

[Refine](https://github.com/refinedev/refine) and [refine.new](https://refine.new/) are game-changers in the React ecosystem, making it incredibly easy for developers to build complete CRUD applications in no time. Here's how these tools make developers' lives easier:

### Time-saving and easy-to-use

[refine.new](https://refine.new/) allows developers to create complete applications with interactive UI in just 15 seconds, eliminating the need for complex configurations or setups. Refine also offers a zero-config, one-minute setup with a single CLI command, making it easy to get started on projects quickly

### Consistent and high-quality code

[refine.new](https://refine.new/) produce consistent, high-quality code that adheres to industry best practices. This helps maintain a high standard across projects and ensures that developers spend less time debugging and more time focusing on their application's core features.

### Enterprise-grade applications

[Refine](https://github.com/refinedev/refine) are designed for building large-scale projects, making it an ideal choice for developers who work on enterprise-grade applications. With full test coverage and a robust, future-proof architecture, you can trust that your application will be reliable and scalable.

### Open-source and free

Both Refine and refine.new are open-source and free, allowing developers to access and modify the complete code base as needed. This empowers developers to contribute to the project, learn from the source code, and create custom solutions tailored to their requirements.

### Reduced development time

By automating repetitive tasks and providing built-in solutions for critical project components, Refine and refine.new significantly reduce development time. This allows developers to focus on implementing unique features that set their application apart from the competition.

## Conclusion

Refine and refine.new are transforming the React.js ecosystem by making it easier than ever for developers to build high-quality, data-intensive applications in record time. With an extensive range of project variations, enterprise-grade features, and a streamlined development process, these tools are poised to become the go-to choice for developers working on CRUD applications in the React.js ecosystem.

Experience the power of Refine and refine.new for yourself and see how they can revolutionize your development process!
