---
title: Become a Refine guest technical writer
description: Guideline and tips for writing technical articles for Refine
slug: refine-writer-program
authors: necati
tags: [community]
image: https://refine.ams3.cdn.digitaloceanspaces.com/blog/2022-07-20-refine-writer-program/social.jpg
hide_table_of_contents: false
---

## Refine technical writer program

Refine technical writer program's aim is to support the open source community by providing high-quality technical articles about React and JS technologies.

As a technical article writer, your work will be instrumental in helping developers keep abreast of the latest industry trends. Your articles will allow developers from all around the world to discover new industry standard best practices, techniques, solutions and tutorials about the JS ecosystem.

<!--truncate-->

### What will Refine do for you?

- We'll promote your article on our official dev.to account, LinkedIn, Discord, and Twitter channels.
- You'll get a byline with your name and link so readers can find more about you.
- We'll give Refine's full swag kit as a gift.

### What kind of articles do we want?

We pay attention to the following when determining what will be included in an article:

- First of all, you must have expertise in the subject you are writing about.
- The topic may contain your solution to a real problem you have encountered.
- Is the solution you found suitable for industry best practices? Did you come up with the exact same solution as other articles on the same topic on the web, or is it more original?
- Does the topic have a real use case?
- From the reader's perspective, what kind of content would you like to find while searching for the topic on Google? What topics and contents would satisfy you?
- React, Javascript, Typescript, NodeJS, GraphQL, Next.js and CSS are the basic topics we want articles about.
- There may be topics that include front end development best practices, design patterns and highly-demand front end development tools.

Please check if there are enough articles on other blog sites about the same topic you are about to write by looking at their archives. If you find any original or your own experiences, then go ahead with them.

#### Article types we publish

- How to..: Solutions for a real use case problem
- Tutorials: Whether it is getting started with a technology or building project from scratch in React or front end ecosystem technologies.
- Guides: The perfect resource for those who want to use the article as a guide.
- Case Studies: Practical examples which will be useful to other developers.
- Opinion: If have a strong opinion on high demand tools or frameworks in our front end industry.
- Comparison: Comparing 2 similar technologies, framework or patterns in depth.
- Best practices & concepts & design patterns & developer tools usage.

### Post Structure

Developers, as you all probably know, telling a story is one of the most important aspects of writing a great post. It engages the reader and makes them interested in what you have to say.

In this blog post, we are going to talk about some tips on how to structure your story so that it's interesting and easy to follow.

#### Introduction

The introduction serves as an essential motivator for the reader, helping them to see the value in investing their time in reading the rest of the article.

This is where we will persuade the reader to read the article.

A nice introduction provides information about the rest of the article.
Our focus should be on the problem it solved, rather than on the technology to be used.

- What is it about?
- What will it give me?
- Are they building an app and deploying it or adding E2E tests to existing code? Be specific, as this provides the motivation readers need and gets them excited about the topic.

In order to motivate the reader and get them excited about your topic don't use phrases like “you will learn how to”, use phrases like “you will build” or “you will deploy”. This motivates the reader and get them excited more about your topic.

The steps in the article should be given as a linked bullet list in the introduction.

#### Prerequisites

If needed, the required development environment needs to be listed if you write a tutorial article:

- The node version
- Platform that needed to be registered(For example you need a Heroku account for deployment stuff)
- The concepts needed to be known will be listed before starting reading the article.

If the concepts mentioned in the article need to be understood well, you can give links to external sources as references.

#### Logical content flow

Your post should have a strong logical flow between sections. Each should build on previous ones.

Summarize the content of each part with a sentence, if you put these sentences one after another and it has a meaningful flow, then it means you have a good structure. We provide all the details and necessary explanations for the readers to understand the articles well. The goal is for our readers to learn the concepts, not just copy and paste code and commands.

We use an official documentation explanation if we are using specific tech terms for the first time.

A detailed explanation of every command should be provided, including options and flags as necessary

By the time the reader has finished the article, they should have successfully built everything necessary from start to finish. The example you provided should work correctly.

#### Conclusion

This is where we wrap things up. You can summarize what the reader learns from the article as bullet points or with sentences.
We give suggestions to reader that they can ask questions on comments.

We encourage readers so that they can ask questions in the comments.
If any questions or comments from readers about your article, you need to help them out.

### We use motivational language

We write articles in formal but friendly tone. Articles do not include jargon, memes, slang and emojis.
Don't use first person word, instead use second person phares

For example Instead of using " I will ..." use "You will.."
Avoid words like "simple,” , “easy,” “simply,” “obviously,” to describe something.

We prefer to use patterns like "In this tutorial you will install ..." instead of "You will learn how to install .."

### Copyright

Quoting someone else is a great way to add originality and insights into your work. Cite them, and provide the link so readers can check out what you were referring to as well as how it related back in some way

At Refine, we take plagiarism seriously. All of our writers are expected to produce original content, and we run plagiarism checks on every article that we publish. If the plagiarism rate is above a certain level, we will ask the writer to rewrite the article.

If you're using a stock image, add an author name or link below to the image

### Submission process

We ask for an outline before start writing your post. In the outline you need to explain:

- Who is your target audience?
- What will the reader learn from the article?
- The outline needs to include the main headings or sections of the article, along with an explanation of what will be taught in that section.

A good outline is a key tool for the submission process. It helps to organize thoughts and ensure that all the important points are covered.

When your outline is checked and approved by our editors, we want you to write your first draft.
If necessary, we would ask you to make edits to your draft.

We ask you to keep the article exclusive to us for the first 2 months due to SEO purposes. Then you can publish it on your own platform.

If you have any article ideas that you think would be a good fit for us, please send us an email with your LinkedIn, GitHub profile, and your other published articles links. We would love to hear from you and react to any new ideas you may have.

Thank you for your interest in writing for us!

Reach us by
[Discord Community](https://discord.gg/refine)
or
**info@refine.dev**
