/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.component;

/**
 * Name constants of the attributes of the Tobago components.
 */
//from http://grepcode.com/file_/repo1.maven.org/maven2/org.apache.myfaces.tobago/tobago-core/2.0.8/org/apache/myfaces/tobago/component/Attributes.java/?v=source
public final class Attributes {

    public static final String ACCESS_KEY = "accessKey";
    public static final String ACTION = "action";
    public static final String ACTION_LISTENER = "actionListener";
    public static final String ALIGN = "align";
    public static final String ALT = "alt";
    public static final String APPLICATION_ICON = "applicationIcon";
    public static final String AUTO_RELOAD = "autoReload";
    public static final String BODY_CONTENT = "bodyContent";
    public static final String BORDER = "border";
    /** Used by a layout manager */
    public static final String BORDER_BOTTOM = "borderBottom";
    /** Used by a layout manager */
    public static final String BORDER_LEFT = "borderLeft";
    /** Used by a layout manager */
    public static final String BORDER_RIGHT = "borderRight";
    /** Used by a layout manager */
    public static final String BORDER_TOP = "borderTop";
    public static final String CHARSET = "charset";
    /** @deprecated */
    @Deprecated
    public static final String CELLSPACING = "cellspacing";
    public static final String CLIENT_PROPERTIES = "clientProperties";
    public static final String COLUMN_SPAN = "columnSpan";
    public static final String COLUMN_SPACING = "columnSpacing";
    public static final String COLUMNS = "columns";
    public static final String CONVERTER = "converter";
    public static final String CREATE_SPAN = "createSpan";
    public static final String CSS_CLASSES_BLOCKS = "cssClassesBlocks";
    /** @deprecated since 2.0.0 */
    @Deprecated
    public static final String DATE_INPUT_ID = "dateInputId";
    public static final String DATE_STYLE = "dateStyle";
    public static final String DEFAULT_COMMAND = "defaultCommand";
    public static final String DELAY = "delay";
    public static final String DIRECT_LINK_COUNT = "directLinkCount";
    public static final String DISABLED = "disabled";
    public static final String ENCTYPE = "enctype";
    public static final String ESCAPE = "escape";
    public static final String EXPANDED = "expanded";
    public static final String EXECUTE = "execute";
    public static final String EVENT = "event";
    public static final String FIELD_ID = "fieldId";
    public static final String FIRST = "first";
    public static final String FREQUENCY = "frequency";
    public static final String FOCUS = "focus";
    public static final String FOCUS_ID = "focusId";
    public static final String FORCE_VERTICAL_SCROLLBAR = "forceVerticalScrollbar";
    public static final String FORMAT_PATTERN = "formatPattern";
    public static final String FOR = "for";
    public static final String GLOBAL_ONLY = "globalOnly";
    public static final String HEIGHT = "height";
    public static final String HIDDEN = "hidden";
    public static final String HOVER = "hover";
    public static final String I18N = "i18n";
    public static final String ICON_SIZE = "iconSize";
    public static final String ID = "id";
    public static final String IMMEDIATE = "immediate";
    public static final String IMAGE = "image";
    public static final String INLINE = "inline";
    /** @deprecated */
    @Deprecated
    public static final String INNER_HEIGHT = "innerHeight";
    /** @deprecated */
    @Deprecated
    public static final String INNER_WIDTH = "innerWidth";
    public static final String ITEM_DESCRIPTION = "itemDescription";
    public static final String ITEM_DISABLED = "itemDisabled";
    public static final String ITEM_LABEL = "itemLabel";
    public static final String ITEM_IMAGE = "itemImage";
    public static final String ITEM_VALUE = "itemValue";
    public static final String JSF_RESOURCE = "jsfResource";
    public static final String LABEL = "label";
    public static final String LABEL_POSITION = "labelPosition";
    public static final String LABEL_WIDTH = "labelWidth";
    public static final String LAYOUT_HEIGHT = "layoutHeight";
    public static final String LAYOUT_ORDER = "layoutOrder";
    public static final String LAYOUT_WIDTH = "layoutWidth";
    public static final String LEFT = "left";
    public static final String LINK = "link";
    /** @deprecated */
    @Deprecated
    public static final String MARGIN = "margin";
    /** Used by a layout manager */
    public static final String MARGIN_BOTTOM = "marginBottom";
    /** Used by a layout manager */
    public static final String MARGIN_LEFT = "marginLeft";
    /** Used by a layout manager */
    public static final String MARGIN_RIGHT = "marginRight";
    /** Used by a layout manager */
    public static final String MARGIN_TOP = "marginTop";
    public static final String MARKED = "marked";
    public static final String MARKUP = "markup";
    public static final String MAX = "max";
    public static final String MAX_SEVERITY = "maxSeverity";
    public static final String MAX_NUMBER = "maxNumber";
    public static final String MAXIMUM_HEIGHT = "maximumHeight";
    public static final String MAXIMUM_WIDTH = "maximumWidth";
    public static final String METHOD = "method";
    public static final String MIN = "min";
    public static final String MIN_SEVERITY = "minSeverity";
    public static final String MINIMUM_HEIGHT = "minimumHeight";
    public static final String MINIMUM_WIDTH = "minimumWidth";
    public static final String MODAL = "modal";
    public static final String MODE = "mode";
    public static final String MUTABLE = "mutable";
    public static final String NAME = "name";
    public static final String NAVIGATE = "navigate";
    public static final String NUMBER_STYLE = "numberStyle";
    public static final String OMIT = "omit";
    /** @deprecated Since 2.0.0. This attribute work not with SCP */
    @Deprecated
    public static final String ONCHANGE = "onchange";
    /** @deprecated Since 2.0.0. This attribute work not with SCP */
    @Deprecated
    public static final String ONCLICK = "onclick";
    public static final String ORDER_BY = "orderBy";
    public static final String ORIENTATION = "orientation";
    /** Used by a layout manager */
    public static final String PADDING_BOTTOM = "paddingBottom";
    /** Used by a layout manager */
    public static final String PADDING_LEFT = "paddingLeft";
    /** Used by a layout manager */
    public static final String PADDING_RIGHT = "paddingRight";
    /** Used by a layout manager */
    public static final String PADDING_TOP = "paddingTop";
    /** @deprecated Since 2.0.6. No longer needed. */
    @Deprecated
    public static final String PAGE_MENU = "pageMenu";
    public static final String PASSWORD = "password";
    public static final String POPUP_CLOSE = "popupClose";
    public static final String POPUP_LIST = "popupList";
    public static final String POPUP_RESET = "popupReset";
    public static final String POPUP_CALENDAR_ID = "popupCalendarId";
    public static final String PREFERRED_HEIGHT = "preferredHeight";
    public static final String PREFERRED_WIDTH = "preferredWidth";
    public static final String PREFORMATED = "preformated";
    public static final String READONLY = "readonly";
    public static final String REFERENCE = "reference";
    public static final String RELATIVE = "relative";
    public static final String RENDERED = "rendered";
    public static final String RENDERED_PARTIALLY = "renderedPartially";
    public static final String RENDERER_TYPE = "rendererType";
    public static final String RENDER_AS = "renderAs";
    public static final String RENDER_RANGE = "renderRange";
    public static final String RENDER_RANGE_EXTERN = "renderRangeExtern";
    public static final String REQUIRED = "required";
    public static final String RESIZABLE = "resizable";
    public static final String RESOURCE = "resource";
    public static final String ROW_ID = "rowId";
    public static final String ROW_SPAN = "rowSpan";
    public static final String ROW_SPACING = "rowSpacing";
    public static final String ROWS = "rows";
    public static final String SCRIPT_FILES = "scriptFiles";
    public static final String SCROLLBAR_HEIGHT = "scrollbarHeight";
    public static final String SCROLLBARS = "scrollbars";
    // Attribute name could not be the same as the method name
    // this cause an infinite loop on attribute map
    public static final String SCROLL_POSITION = "attrScrollPosition";
    public static final String SELECTED_INDEX = "selectedIndex";
    public static final String SELECTED_LIST_STRING = "selectedListString";
    public static final String SORTABLE = "sortable";
    public static final String SELECTABLE = "selectable";
    public static final String SHOW_DIRECT_LINKS = "showDirectLinks";
    public static final String SHOW_HEADER = "showHeader";
    public static final String SHOW_JUNCTIONS = "showJunctions";
    public static final String SHOW_NAVIGATION_BAR = "showNavigationBar";
    public static final String SHOW_PAGE_RANGE = "showPageRange";
    public static final String SHOW_ROOT = "showRoot";
    public static final String SHOW_ROOT_JUNCTION = "showRootJunction";
    public static final String SHOW_ROW_RANGE = "showRowRange";
    public static final String SHOW_SUMMARY = "showSummary";
    public static final String SHOW_DETAIL = "showDetail";
    public static final String SPAN_X = "spanX";
    public static final String SPAN_Y = "spanY";
    public static final String SRC = "src";
    public static final String STATE = "state";
    public static final String STATE_PREVIEW = "statePreview";
    public static final String STYLE = "style";
    /** @deprecated */
    @Deprecated
    public static final String STYLE_CLASS = "styleClass";
    public static final String SUPPRESS_TOOLBAR_CONTAINER = "suppressToolbarContainer";
    public static final String SWITCH_TYPE = "switchType";
    public static final String TAB_INDEX = "tabIndex";
    public static final String TARGET = "target";
    public static final String TIME_STYLE = "timeStyle";
    public static final String TEXT_ALIGN = "textAlign";
    public static final String TIMEZONE = "timezone";
    public static final String TITLE = "title";
    public static final String TIP = "tip";
    public static final String TOP = "top";
    public static final String TRANSITION = "transition";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String VALUE_CHANGE_LISTENER = "valueChangeListener";
    public static final String VAR = "var";
    public static final String UNIT = "unit";
    public static final String UPDATE = "update";
    public static final String VALIDATOR = "validator";
    public static final String WIDTH = "width";
    public static final String WIDTH_LIST = "widthList";
    public static final String WIDTH_LIST_STRING = "widthListString";
    public static final String Z_INDEX = "zIndex";
}