# Generated by Django 4.1.2 on 2022-12-30 19:35

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_celery_results', '0011_taskresult_periodic_task_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the dataset', max_length=50, verbose_name='Name')),
                ('file_name', models.CharField(help_text='File name of the dataset', max_length=50, verbose_name='File Name')),
                ('features', models.IntegerField(help_text='Number of features of the dataset', verbose_name='Features')),
                ('samples', models.IntegerField(default=1, help_text='Number of samples of the dataset', verbose_name='Samples')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Function',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('short_name', models.CharField(help_text='Short name for the function', max_length=50, verbose_name='Short Name')),
                ('name', models.CharField(help_text='Name of the function', max_length=50, verbose_name='Name')),
                ('latex_expression', models.CharField(help_text='Latex expression for the function', max_length=255, verbose_name='Latex Expression')),
                ('bound', models.TextField(help_text='JSON representation of the bound', verbose_name='Bound')),
                ('optimal', models.TextField(help_text='JSON representation of the optimal result', verbose_name='Optimal Result')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Optimizer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('acronym', models.CharField(help_text='Short name for the optimizer', max_length=10, verbose_name='Acronym')),
                ('name', models.CharField(help_text='Name of the optimizer', max_length=50, verbose_name='Name')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='TransferFunction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the Transfer Function', max_length=50, verbose_name='Name')),
                ('latex_expression', models.CharField(help_text='Latex expression for the transfer function', max_length=255, verbose_name='Latex Expression')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='UserTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='django_celery_results.taskresult')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-task__date_created',),
            },
        ),
    ]
