import getPaginatedResponse from "@reactioncommerce/api-utils/graphql/getPaginatedResponse.js";
import wasFieldRequested from "@reactioncommerce/api-utils/graphql/wasFieldRequested.js";
import isOpaqueId from "@reactioncommerce/api-utils/isOpaqueId.js";
import { decodeGroupOpaqueId } from "../../xforms/id.js";

/**
 * @name Query/accounts
 * @method
 * @memberof Accounts/GraphQL
 * @summary query the Accounts collection and return a list of accounts
 * @param {Object} _ - unused
 * @param {Object} args - an object of all arguments that were sent by the client
 * @param {String} [args.groupIds] - Array of group IDs
 * @param {Boolean} [args.notInAnyGroups] - Return accounts that aren't part of any groups
 * @param {Object} context - an object containing the per-request state
 * @param {Object} info Info about the GraphQL request
 * @returns {Promise<Object>} Promise containing queried accounts
 */
export default async function accounts(_, args, context, info) {
  const { groupIds: opaqueGroupIds, notInAnyGroups, ...connectionArgs } = args;

  let groupIds;
  if (opaqueGroupIds) {
    groupIds = opaqueGroupIds.map((opaqueGroupId) => (isOpaqueId(opaqueGroupId) ? decodeGroupOpaqueId(opaqueGroupId) : opaqueGroupId));
  }

  const query = await context.queries.accounts(context, { groupIds, notInAnyGroups });

  return getPaginatedResponse(query, connectionArgs, {
    includeHasNextPage: wasFieldRequested("pageInfo.hasNextPage", info),
    includeHasPreviousPage: wasFieldRequested("pageInfo.hasPreviousPage", info),
    includeTotalCount: wasFieldRequested("totalCount", info)
  });
}
