// tslint:disable:max-line-length

import type { Value_v0 } from '@react-page/editor';

const contents: Value_v0[] = [
  {
    id: '1',
    cells: [
      {
        id: '5ac89ec4-7536-4120-a072-8eedad0a48ff',

        size: 12,
        rows: [
          {
            id: 'd813d094-215a-43ec-bcdd-d5fd6258b915',
            cells: [
              {
                id: '3fde7b92-fbfe-4b2d-85b3-bad431939df6',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-ONE',
                        children: [
                          {
                            text: 'ReactPage',
                          },
                        ],
                      },
                      {
                        data: {
                          align: 'left',
                        },
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: '',
                          },
                          {
                            data: {
                              href: 'https://www.ory.sh/',
                            },
                            type: 'LINK/LINK',
                            children: [
                              {
                                text: 'ORY',
                              },
                            ],
                          },
                          {
                            text: ' is a company building and maintaining developer tools for a safer, more accessible web. You might also like our other ',
                          },
                          {
                            data: {
                              href: 'https://github.com/ory',
                            },
                            type: 'LINK/LINK',
                            children: [
                              {
                                text: 'Open Source',
                              },
                            ],
                          },
                          {
                            text: ' tools! ReactPage is a smart, extensible and modern editor ("WYSIWYG") for the web written in React.',
                          },
                        ],
                      },
                      {
                        data: {
                          align: 'left',
                        },
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'ReactPage was written because we urgently needed a robust and modern content editing solution for our open education platform ',
                          },
                          {
                            data: {
                              href: 'https://en.serlo.org/serlo',
                            },
                            type: 'LINK/LINK',
                            children: [
                              {
                                text: 'serlo.org',
                              },
                            ],
                          },
                          {
                            text: '. Serlo is the largest open education platform in Germany, works like the Wikipedia and is used by millions every year.',
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'c15959de-4767-41b7-9814-71626d6cbcdb',
            cells: [
              {
                id: '33c58cda-94b5-4c2e-9232-9aa27a4aff8d',

                size: 6,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'left',
                        },
                        type: 'HEADINGS/HEADING-THREE',
                        children: [
                          {
                            text: 'ORY Sites',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'ORY Sites is an ',
                          },
                          {
                            text: 'next-gen',
                            'EMPHASIZE/STRONG': true,
                          },
                          {
                            text: ' ',
                          },
                          {
                            text: 'open source static site generator',
                            'EMPHASIZE/STRONG': true,
                          },
                          {
                            text: ' based on ReactPage. Create stunning websites, write your own designs and plugins, and be done with databases, application servers, and security updates.',
                          },
                        ],
                      },
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-FIVE',
                        children: [
                          {
                            text: '',
                          },
                          {
                            data: {
                              href: 'https://www.ory.sh/sites?utm_source=github&utm_medium=link&utm_campaign=editor_demo',
                            },
                            type: 'LINK/LINK',
                            children: [
                              {
                                text: 'Learn more about ORY Sites!',
                              },
                            ],
                          },
                          {
                            text: '',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: '',
                          },
                        ],
                      },
                    ],
                  },
                },
              },
              {
                id: 'd5e4efbe-66f0-4344-9df0-f0720b5d1f5d',

                size: 6,
                content: {
                  plugin: {
                    name: 'ory/sites/plugin/content/html5-video',
                    version: '0.0.1',
                  },
                  state: {
                    url: 'images/app-preview.mp4',
                  },
                },
              },
            ],
          },
          {
            id: '5f33bca6-4ab3-4429-a38f-4d02fb5a16e6',
            cells: [
              {
                id: '640485f1-04d4-4579-81e0-5d8aa1dbfe24',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-TWO',
                        children: [
                          {
                            text: "What's the problem?",
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: '09c5e133-ef5c-40ce-965f-a14200e4f162',
            cells: [
              {
                id: '5e813953-98b7-41aa-b077-42923cc0d2c6',
                inline: 'right',
                size: 5,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/image',
                    version: '0.0.1',
                  },
                  state: {
                    src: '/images/front.png',
                  },
                },
              },
              {
                id: '2fff5d50-f252-478b-b354-181300e21419',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'We had to realize that existing open source content editing solutions had one of the three flaws:\r',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'LISTS/UNORDERED-LIST',
                        children: [
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'The produced markup was horrific, a lot of sanitation had to take place and XSS is always a threat.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'The author must learn special mark up, like markdown, before being able to produce content. These text-based solutions are usually unable to specify a layout and complex data structures like tables are annoying to edit.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'Promising libraries potentially solving the above where abandoned by their maintainers, because it started as a special use case, or a free-time project.\r',
                              },
                            ],
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'da7ba725-44a0-4be5-9e5d-53db76950b15',
            cells: [
              {
                id: 'ede254d9-f54f-47c1-85c3-e0e09e816264',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-TWO',
                        children: [
                          {
                            text: "So what's different?",
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'de26482c-ba8a-42b3-bdfc-b4f0761e2dad',
            cells: [
              {
                id: 'b2332df1-94c4-4136-867f-14c93e1efe48',

                size: 4,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/video',
                    version: '0.0.1',
                  },
                  state: {
                    src: 'https://www.youtube.com/watch?v=dkc65_l0Kfc',
                  },
                },
              },
              {
                id: '71d9437b-38ef-40f9-be8b-0a5517734922',

                size: 8,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'We concluded that a solution must meet the following principles:\r',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'LISTS/UNORDERED-LIST',
                        children: [
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'The state is a normalized JSON object, no HTML involved.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'It is a visual editor that does not require programming experience or special training.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'It is built by a company, reducing the likelihood of abandonment.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'Based on reusable React Components, it gives developers, authors and designers new ways of working together and creating better and richer experiences more easily.\r',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'It works on mobile and touch devices.\r',
                              },
                            ],
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'With these principles in mind, we went out and implemented ReactPage, which you are looking at right now.',
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'b3c394b2-f99c-4286-a348-0dc5c4592f05',
            cells: [
              {
                id: 'af4d6d7b-57ac-43f2-aff6-6b141dfcf98e',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/spacer',
                    version: '0.0.1',
                  },
                  state: {
                    height: 48,
                  },
                },
              },
            ],
          },
          {
            id: '338463af-5dfb-4e53-a53d-a47855247269',
            cells: [
              {
                id: 'f9a5c347-8e5f-464f-8af9-b130ec2dd3bb',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-TWO',
                        children: [
                          {
                            text: 'Feature Spotlight',
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: '111f3e10-e62f-483c-8937-9b95ca05c48d',
            cells: [
              {
                id: '9e726399-4a2c-4ea7-b0f3-7742d430a861',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/divider',
                    version: '0.0.1',
                  },
                  state: {},
                },
              },
            ],
          },
          {
            id: '76814458-ee0c-49c4-b011-937ce7e883fc',
            cells: [
              {
                id: '4825fda3-916f-44f9-ac02-3be553bcd871',

                size: 8,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'HEADINGS/HEADING-THREE',
                        children: [
                          {
                            text: 'Rich Inline Editing',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'Presentation and modification happen in the same canvas, at the same time. Now you always know what your content looks like on desktop, tablet and mobile, in real-time!',
                          },
                        ],
                      },
                    ],
                  },
                },
              },
              {
                id: '76d7587b-d978-4958-b54f-91ccb1e3d0a2',

                size: 4,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/image',
                    version: '0.0.1',
                  },
                  state: {
                    src: '/images/create-content.png',
                  },
                },
              },
            ],
          },
          {
            id: '2e1d1ba8-cdbe-4175-9990-26cdc15fce5c',
            cells: [
              {
                id: '412e3261-1fb8-474f-965e-39cbc5a16d18',

                size: 4,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/image',
                    version: '0.0.1',
                  },
                  state: {
                    src: '/images/responsive.png',
                  },
                },
              },
              {
                id: '02125c61-3120-49ef-9b50-70ae79409bea',

                size: 8,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'HEADINGS/HEADING-THREE',
                        children: [
                          {
                            text: 'Responsive Layouts',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: "Today's content is more than a monolithic blob of text. ReactPage allows you to define your own layout blocks, and create content that looks good on all devices.",
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'ec4474f6-a418-4628-831b-03a7e64fd500',
            cells: [
              {
                id: '78269a8f-7b29-4703-b107-b399eac3e365',

                size: 8,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'HEADINGS/HEADING-THREE',
                        children: [
                          {
                            text: 'Sane mark-up',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: "Most web editors work on top of the DOM. This is dangerous (XSS), hard to maintain and difficult to parse. ReactPage uses JSON only - everywhere! It's sane, tested, clean and minimal.",
                          },
                        ],
                      },
                    ],
                  },
                },
              },
              {
                id: 'e8c5696c-4769-483c-a962-2fd5f4727c0c',

                size: 4,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/image',
                    version: '0.0.1',
                  },
                  state: {
                    src: '/images/sane-markup.png',
                  },
                },
              },
            ],
          },
          {
            id: '6f226a6b-e4e8-405a-a0f8-6f370dc05763',
            cells: [
              {
                id: '6c11a0d6-6857-4917-9692-eae056fd9500',

                size: 12,
                layout: {
                  plugin: {
                    name: 'ory/editor/core/layout/background',
                    version: '0.0.1',
                  },
                  state: {
                    background: '/images/sea-bg.jpg',
                  },
                },
                rows: [
                  {
                    id: 'c9d1ff2a-f7d1-410c-b275-9dd6200114c5',
                    cells: [
                      {
                        id: 'fa87ac49-73b9-4202-9034-f752fa83273c',

                        size: 4,
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/image',
                            version: '0.0.1',
                          },
                          state: {
                            src: '/images/react.png',
                          },
                        },
                      },
                      {
                        id: '491d3370-e551-4b05-be4f-c926d52ee08b',

                        size: 8,
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/slate',
                            version: '0.0.4',
                          },
                          state: {
                            slate: [
                              {
                                data: {},
                                type: 'HEADINGS/HEADING-THREE',
                                children: [
                                  {
                                    text: 'React Plugin API',
                                  },
                                ],
                              },
                              {
                                data: {},
                                type: 'PARAGRAPH/PARAGRAPH',
                                children: [
                                  {
                                    text: "You don't like our rich text solution, require custom layout components, need a twitter feed, want to contribute or even sell plugins? No problem with our easy-to-use React Plugin API!",
                                  },
                                ],
                              },
                              {
                                data: {},
                                type: 'PARAGRAPH/PARAGRAPH',
                                children: [
                                  {
                                    text: 'In fact, this section is rendered on top of an exemplary layout plugin!',
                                  },
                                ],
                              },
                            ],
                          },
                        },
                      },
                    ],
                  },
                ],
              },
            ],
          },
          {
            id: 'f35a9eea-602d-448f-a1ec-c1b2357b28d5',
            cells: [
              {
                id: '4e04678e-e51a-4883-8732-b8218f55fd24',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        type: 'HEADINGS/HEADING-THREE',
                        children: [
                          {
                            text: 'Extend beyond text!',
                          },
                        ],
                      },
                      {
                        children: [
                          {
                            text: 'The built in rich text editor is extendable as well! ',
                          },
                        ],
                      },
                      {
                        children: [
                          {
                            text: 'You like ',
                          },
                          {
                            text: 'colors? ',
                            SetColor: {
                              color: 'blue',
                            },
                          },
                          {
                            text: 'write a color ',
                            SetColor: {
                              color: 'green',
                            },
                          },
                          {
                            text: 'plugin.',
                            SetColor: {
                              color: 'red',
                            },
                          },
                        ],
                      },
                      {
                        children: [
                          {
                            text: 'You are into math? How about a ',
                          },
                          {
                            type: 'LINK/LINK',
                            children: [
                              {
                                text: 'katex',
                              },
                            ],
                            data: {
                              href: 'https://github.com/talyssonoc/react-katex/',
                              openInNewWindow: true,
                            },
                          },
                          {
                            text: ' plugin?',
                          },
                        ],
                      },
                      {
                        children: [
                          {
                            text: '',
                          },
                          {
                            type: 'Katex',
                            children: [
                              {
                                text: 'f(x) = ax^2 + bx +c ',
                              },
                            ],
                            data: null,
                          },
                          {
                            text: '',
                          },
                          {
                            type: 'LINK/LINK',
                            data: {
                              href: 'https://github.com/talyssonoc/react-katex/',
                              openInNewWindow: false,
                            },
                            children: [
                              {
                                text: '',
                              },
                            ],
                          },
                          {
                            text: '',
                          },
                        ],
                        data: {
                          align: 'center',
                        },
                      },
                      {
                        children: [
                          {
                            text: 'or even more complex formulas:',
                          },
                          {
                            type: 'LINK/LINK',
                            data: {
                              href: 'https://github.com/talyssonoc/react-katex/',
                              openInNewWindow: false,
                            },
                            children: [
                              {
                                text: '',
                              },
                            ],
                          },
                          {
                            text: '',
                          },
                        ],
                        data: {
                          align: 'center',
                        },
                      },
                      {
                        children: [
                          {
                            text: '',
                          },
                          {
                            type: 'Katex',
                            children: [
                              {
                                text: 'f(x) = \\int_{-\\infty}^\\infty\\hat f(\\xi)\\,e^{2 \\pi i \\xi x}\\,d\\xi ',
                              },
                            ],
                            data: null,
                          },
                          {
                            text: '',
                          },
                        ],
                        data: {
                          align: 'center',
                        },
                      },
                      {
                        children: [
                          {
                            text: '',
                          },
                        ],
                        data: {
                          align: 'center',
                        },
                      },
                      {
                        children: [
                          {
                            text: 'These plugins are not shipped, but the example project shows you how you can create these plugins.',
                          },
                        ],
                        data: {
                          align: 'left',
                        },
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: '5db554dd-6b14-46c6-8dd4-3de3aee946a9',
            cells: [
              {
                id: '246945c0-f677-4942-b067-ecfef5624911',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {
                          align: 'center',
                        },
                        type: 'HEADINGS/HEADING-TWO',
                        children: [
                          {
                            text: "That's all?",
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
          {
            id: 'ba89fcb0-6657-4826-abc0-1ad006dac05c',
            cells: [
              {
                id: 'b368328c-86fd-4949-b0c8-7277da6c7d6d',

                size: 12,
                content: {
                  plugin: {
                    name: 'ory/editor/core/content/slate',
                    version: '0.0.4',
                  },
                  state: {
                    slate: [
                      {
                        data: {},
                        type: 'PARAGRAPH/PARAGRAPH',
                        children: [
                          {
                            text: 'No, of course not! We are very proud of these ones as well:',
                          },
                        ],
                      },
                      {
                        data: {},
                        type: 'LISTS/UNORDERED-LIST',
                        children: [
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'global un-/redo with ',
                              },
                              {
                                text: 'ctrl+z',
                                'EMPHASIZE/EM': true,
                              },
                              {
                                text: ' / ',
                              },
                              {
                                text: 'ctrl+y',
                                'EMPHASIZE/EM': true,
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'editing shortcuts, for example ',
                              },
                              {
                                text: 'ctrl+b',
                                'EMPHASIZE/STRONG': true,
                              },
                              {
                                text: ',',
                              },
                              {
                                text: ' ',
                                'EMPHASIZE/STRONG': true,
                              },
                              {
                                text: 'ctrl+i, ',
                                'EMPHASIZE/EM': true,
                              },
                              {
                                text: 'ctrl+u',
                                'EMPHASIZE/U': true,
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: 'collaborative editing',
                              },
                            ],
                          },
                          {
                            data: {},
                            type: 'LISTS/LIST-ITEM',
                            children: [
                              {
                                text: '... and more things to come',
                              },
                            ],
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
          },
        ],
      },
    ],
  },
  {
    id: '2',
    cells: [
      {
        rows: [
          {
            cells: [
              {
                rows: [
                  {
                    cells: [
                      {
                        inline: 'right',
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/image',
                            version: '0.0.1',
                          },
                          state: {
                            src: '/images/grass-header.jpg',
                          },
                        },
                        id: 'c3fab3ee-c086-4faf-8a88-e8f321d425c2',
                      },
                      {
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/slate',
                            version: '0.0.2',
                          },
                          state: {
                            importFromHtml:
                              '<h1>Hello world</h1><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. </p><h3 style="text-align: center">Stet clita kasd gubergren</h3><p>No sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>',
                          },
                        },
                        id: '254233b6-4bf3-4d0a-8c86-ab7b88f4283c',
                      },
                    ],
                    id: 'f32b324e-2d17-4658-8941-93c7380d51d8',
                  },
                  {
                    cells: [
                      {
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/slate',
                            version: '0.0.2',
                          },
                          state: {
                            importFromHtml:
                              '<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.</p>',
                          },
                        },
                        id: 'c5d411d5-595c-4ff2-ac11-0d0079a814ef',
                      },
                    ],
                    id: '25d9f081-28b6-45f0-bff0-5a11bc5db071',
                  },
                  {
                    cells: [
                      {
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/slate',
                            version: '0.0.2',
                          },
                          state: {
                            importFromHtml:
                              '<p>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>',
                          },
                        },
                        id: '42cd103b-9b14-4674-a895-50c629183a00',
                      },
                    ],
                    id: 'c969431c-aa25-4b81-a5e5-752751517309',
                  },
                  {
                    cells: [
                      {
                        content: {
                          plugin: {
                            name: 'ory/editor/core/content/slate',
                            version: '0.0.2',
                          },
                          state: {
                            importFromHtml:
                              '<p>Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>',
                          },
                        },
                        id: '15ab9e7d-70e2-4a6b-9f99-3a849a31ac59',
                      },
                    ],
                    id: '83c94e3c-2fd5-4e2a-8384-4f31841dab27',
                  },
                ],
                id: '9a7d26ec-ead5-429f-a596-b53935642f4b',
              },
            ],
            id: '8c16dbe4-96e3-41fd-8012-6c37233d86f6',
          },
        ],
        id: '15efd3c3-b683-4da6-b107-16d8d0c8cd26',
      },
    ],
  },
];
export default contents;
