# Usage with Internet Explorer 11

IE11 is supported in _readonly_ mode, but depending on your runtime (webpack, nextjs, etc.), you might need additional configuration.

## transpiling additional node_modules

react-page uses slate, which is currently not shipped in legacy ecmascript anymore, so you need to transpile it first.
There are other modules as well that needs transpiling:

- slate
- slate-hyperscript
- slate-react
- uniforms
- uniforms-material
- uniforms-bridge-simple-schema-2

in `nextjs` you can do it with:

`yarn add next-transpile-modules` / `npm install --save next-transpile-modules`

and then in your `next.config.js`:

```typescript
const withTM = require('next-transpile-modules')([
  'slate',
  'slate-hyperscript',
  'slate-react',
  'uniforms',
  'uniforms-material',
  'uniforms-bridge-simple-schema-2',
]);

module.exports = withTM({
  // rest of your config
});
```

## Polyfills

you might also need some polyfils, the easiest way is to use this:

```html
<script src="https://polyfill.io/v3/polyfill.min.js?features=String.prototype.repeat%2CString.prototype.startsWith%2CString.prototype.endsWith%2CSet%2CMap%2CURLSearchParams%2CArray.from" />
```
