---
title: Reference - React Auth Kit
description: Reference for React Auth Kit library
---

# Reference

<div data-ea-publisher="authkitarkadipme" data-ea-type="text" id="ref_index"></div>

## react-auth-kit

React Auth Kit Core Library

- [AuthProvider](./react-auth-kit/authprovider.md) - Auth Provider for react auth kit
- [createStore](./react-auth-kit/createStore.md) - Create auth store with create the store
- [createRefresh](./react-auth-kit/createRefresh.md) - Create the refresh token system
- [Hooks](./react-auth-kit/hooks/index.md) - React Auth Kit hooks to interact with the library
- [Higher Order Component](./react-auth-kit/hoc/index.md) - Higher Order Components to interact with the library

## @auth-kit/react-router

React Auth Kit Plugin to interact with React Router.

- [AuthOutlet](./react-router/authoutlet.md) - Private Route for multiple components at once
- [RequireAuth](./react-router/requireauth.md) - Private Route one component

## @auth-kit/next

Raact Auth Kit Plugin to interact with Next.

- [NextAuth](./next/next-auth.md) - Private Route integration for Next Js Pages or Layout

---

<p align="center">&mdash; 🔑  &mdash;</p>
<p align="center"><i>React Auth Kit is <a href="https://github.com/react-auth-kit/react-auth-kit/blob/master/LICENSE">MIT License</a> code</i></p>
