---
title: Getting Started - React Auth Kit
description: Add Authentication in React Js, Next Js, Remix Js Application using React Auth Kit
---

# Getting Started with React Auth Kit

<h3 align="center">
👋 Welcome!
</h3>
<p align="center">
Manage authentication with ease on your React-based projects using React Auth Kit.
</p>

<div data-ea-publisher="authkitarkadipme" data-ea-type="text" id="getting_started"></div>

---

## :material-cloud-download: Installation

React-Auth-Kit and all it's plugins are available as a npm package.

<div class="grid cards" markdown>

-   :simple-react:{ .lg .middle .label-color} __React Auth Kit__{ .label-color }

    ---

    Core library to integrate React Auth Kit

    === ":simple-npm: npm"

        ```bash
        npm install react-auth-kit
        ```

    === ":simple-yarn: yarn"

        ```bash
        yarn add react-auth-kit
        ```
    
    === ":simple-pnpm: pnpm"

        ```bash
        pnpm install react-auth-kit
        ```

-   :simple-nextdotjs:{ .lg .middle .label-color } __@auth-kit/next__{ .label-color }

    ---

    Plugin to use the NextJs router

    === ":simple-npm: npm"

        ```bash
        npm install @auth-kit/next
        ```

    === ":simple-yarn: yarn"

        ```bash
        yarn add @auth-kit/next
        ```
    
    === ":simple-pnpm: pnpm"

        ```bash
        pnpm install @auth-kit/next
        ```

-   :simple-reactrouter:{ .lg .middle .label-color } __@auth-kit/react-router__{ .label-color }

    ---

    Plugin to use the React router

    === ":simple-npm: npm"

        ```bash
        npm install @auth-kit/react-router
        ```

    === ":simple-yarn: yarn"

        ```bash
        yarn add @auth-kit/react-router
        ```
    
    === ":simple-pnpm: pnpm"

        ```bash
        pnpm install @auth-kit/react-router
        ```

- :rocket:{ .lg .middle } _More Plugins are brewing Up!!_{ .lg .middle }

</div>


## :material-attachment: Integration
Integrate React Auth Kit into your application easily

<div class="grid cards" markdown>

- [:simple-react: **Integration with CRA and Vite**](./integration/react-app.md) - Integrate and unleash the power.
- [:simple-nextdotjs: **Integration with Next. Js**](./integration/next-app-router.md) - Integrate and unleash the power.

</div>

## :material-function: Functionalities

Add up multiple functions to your application
hl_lines="2 5 9"
<div class="grid cards" markdown>

- [:material-location-enter: **Sign In**](./signin.md) - Perform the Login or Signin Operation.
- [:material-exit-run: **Sign Out**](./signout.md) - Perform the Logout or Singout Operation.
- [:material-information: **User Data**](./authdata.md) - Get the current user's data in your app.
- [:material-ip-network: **Auth Header**](./authheader.md) - Get the Auth Header for Network request in your app.
- [:material-list-status: **Auth Status**](./checkauth.md) - Get the Auth Status (boolean value) in your components before rendering.
- [:material-refresh: **Refresh Token**](./refreshtoken.md) - Refresh the Access Token using the Refresh token

</div>

## :material-door-closed-lock: Private Routing

React Auth Kit supports various various routering frameworks to handle Private Routing and Redirection

<div class="grid cards" markdown>

- [:simple-reactrouter: **React Router**](./privateroute/react-router.md) - Integrate Private Route with React Router and React Router Dom
- [:simple-nextdotjs: **Next Js App Router**](./privateroute/next-app.md) - Integrate Private Route with Next Js App Router

</div>
---

<p align="center">&mdash; 🔑  &mdash;</p>
<p align="center"><i>React Auth Kit is <a href="https://github.com/react-auth-kit/react-auth-kit/blob/master/LICENSE">
MIT License</a> code</i></p>
