﻿/**
 * Copyright 2023 Comcast Cable Communications Management, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import { getMaxRoundRadius } from '../../utils';
import Base from '../Base';
import * as styles from './Surface.styles';
import lng from '@lightningjs/core';

export default class Surface extends Base {
  static _template() {
    return {
      Background: {}
    };
  }

  static get __componentName() {
    return 'Surface';
  }

  static get __themeStyle() {
    return styles;
  }

  static get properties() {
    return [];
  }

  static get tags() {
    return ['Background'];
  }

  get innerH() {
    return this.h;
  }

  get innerW() {
    return this.w;
  }

  get _radius() {
    return getMaxRoundRadius(this.style.radius, this.w, this.h);
  }

  _update() {
    this._updateLayout();
    this._updateScale();
  }

  _updateLayout() {
    this._Background.patch({
      texture: lng.Tools.getRoundRect(
        this.innerW - 2, // Reference the underscored values here in cause the h or w getters need to be overwritten for alignment - see Tile
        this.innerH - 2,
        this._radius,
        0,
        null,
        true,
        this.style.backgroundColor
      )
    });
  }

  _updateScale() {
    const scale = this._isFocusedMode
      ? this.getFocusScale(this.w, this.h)
      : this.getUnfocusScale(this.w, this.h);

    this.applySmooth(this, { scale }, { scale: [scale, this.style.animation] });
  }
}
