﻿/**
 * Copyright 2023 Comcast Cable Communications Management, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

export default {
  name: 'Base Lightning TV',
  alpha: {
    primary: 1,
    secondary: 0.7,
    tertiary: 0.1,
    inactive: 0.5,
    full: 1,
    none: 0,
    alpha1: 0.1,
    alpha2: 0.3,
    alpha3: 0.5,
    alpha4: 0.7,
    alpha5: 0.9
  },
  animation: {
    duration: {
      none: 0,
      xfast: 0.1,
      fast: 0.25,
      normal: 0.5,
      slow: 0.75,
      xslow: 0.9
    },
    delay: {
      none: 0,
      xfast: 0.01,
      fast: 0.025,
      normal: 0.05,
      slow: 0.075,
      xslow: 0.09
    },
    expressive: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    expressiveEntrance: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    expressiveExit: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    standard: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    standardEntrance: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    standardExit: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    utility: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    utilityEntrance: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    },
    utilityExit: {
      timingFunction: 'cubic-bezier(0, 0, 1, 1)',
      delay: 0,
      duration: 0.25
    }
  },
  asset: {
    arrowLeft:
      'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAERlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAA6ABAAMAAAABAAEAAKACAAQAAAABAAAAGKADAAQAAAABAAAAGAAAAADiNXWtAAAAi0lEQVRIDWNgGAWjIfD//38JID5Fk5AAGqwKxPeA+D/VLQCaaQLEr0CGgwBVLQCa5wbEn0EGwwDVLAAaGA3Ev2AGw2iqWAA0rBiI/8EMRaYptgBoWDeygehsci1gIlcjWfqArqZdEMFcBLSEdpGMZAntkimSJbTLaEiW0K6oQLKEdoUdzJJRemiHAAD4n+yzPWCs7QAAAABJRU5ErkJggg==',
    arrowRight:
      'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAERlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAA6ABAAMAAAABAAEAAKACAAQAAAABAAAAGKADAAQAAAABAAAAGAAAAADiNXWtAAAAg0lEQVRIDWNgGAWjIYArBP7//38KiCVwyVMsDjQcBO4BsSrFhmEzAGw8hHgFpEywqaFIDMkCEPMzELtRZCC6ZjQLQNxfQByNro5sPhYLQEL/gLiYbEORNeKwACbcDVPLBGMMOhrmVDSapkFE00imaTKlaUajaVFB28Ju0CXrUQfhDAEAEgHss6NhpLQAAAAASUVORK5CYII=',
    backspaceOutline:
      'data:image/png;base64,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',
    check:
      'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAAOCAYAAAAi2ky3AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAACtSURBVHgBvdPdDcIgEAfwoy8Nb45QN3AGF2s36Ahu4gpuIDoBfSgfpdoTlCbEWEMh6T8hFzjyg5AAkBHOcQe5UWqspRx435sDpMYj6IYQwwVSEiJ2MKVUBWuzLSLl2HL+uxmNCGFO8yaL7RHxve6qRZoAuS4hxac8735elWVx7jrtMKL1o0Gcat9jhExHSukN/kUIFZ7MpDRtzE1isDRkAUtDvrA8ZI597FUf8gWH9P0b4gko9wAAAABJRU5ErkJggg=='
  },
  color: {
    white: ['#ffffff', 1],
    black: ['#000000', 1],
    grey: ['#929096', 1],
    red: ['#e74c3c', 1],
    orange: ['#dc7633', 1],
    yellow: ['#f7dc6f', 1],
    green: ['#2Ecc71', 1],
    blue: ['#93a9fd', 1],
    purple: ['#663399', 1],
    palette: {
      'grey-05': ['#f8f7fa', 1],
      'grey-40': ['#929096', 1],
      'grey-70': ['#48474b', 1],
      'grey-90': ['#181819', 1],
      'blue-20': ['#becffe', 1],
      'blue-40': ['#93a9fd', 1],
      'blue-90': ['#000033', 1]
    },
    material: ['#181819', 1],
    materialBrand: ['#000033', 1],
    overlay: ['#181819', 0.7],
    textNeutral: ['#f8f7fa', 1],
    textNeutralSecondary: ['#f8f7fa', 0.7],
    textNeutralTertiary: ['#f8f7fa', 0.1],
    textNeutralDisabled: ['#f8f7fa', 0.5],
    textInverse: ['#181819', 1],
    textInverseSecondary: ['#181819', 0.7],
    textInverseTertiary: ['#181819', 0.1],
    textInverseDisabled: ['#181819', 0.5],
    textBrand: ['#93a9fd', 1],
    textBrandSecondary: ['#93a9fd', 0.7],
    textBrandTertiary: ['#93a9fd', 0.1],
    textBrandDisabled: ['#93a9fd', 0.5],
    textPositive: ['#2Ecc71', 1],
    textNegative: ['#e74c3c', 1],
    textInfo: ['#93a9fd', 1],
    textCaution: ['#dc7633', 1],
    fillTransparent: ['#ffffff', 0],
    fillNeutral: ['#f8f7fa', 1],
    fillNeutralSecondary: ['#f8f7fa', 0.7],
    fillNeutralTertiary: ['#f8f7fa', 0.1],
    fillNeutralDisabled: ['#f8f7fa', 0.5],
    fillInverse: ['#181819', 1],
    fillInverseSecondary: ['#181819', 0.7],
    fillInverseTertiary: ['#181819', 0.1],
    fillInverseDisabled: ['#181819', 0.5],
    fillBrand: ['#93a9fd', 1],
    fillBrandSecondary: ['#93a9fd', 0.7],
    fillBrandTertiary: ['#93a9fd', 0.1],
    fillBrandDisabled: ['#93a9fd', 0.5],
    fillPositive: ['#2Ecc71', 1],
    fillNegative: ['#e74c3c', 1],
    fillInfo: ['#93a9fd', 1],
    fillCaution: ['#dc7633', 1],
    strokeNeutral: ['#f8f7fa', 1],
    strokeNeutralSecondary: ['#f8f7fa', 0.7],
    strokeNeutralTertiary: ['#f8f7fa', 0.1],
    strokeNeutralDisabled: ['#f8f7fa', 0.5],
    strokeInverse: ['#181819', 1],
    strokeInverseSecondary: ['#181819', 0.7],
    strokeInverseTertiary: ['#181819', 0.1],
    strokeInverseDisabled: ['#181819', 0.5],
    strokeBrand: ['#93a9fd', 1],
    strokeBrandSecondary: ['#93a9fd', 0.7],
    strokeBrandTertiary: ['#93a9fd', 0.1],
    strokeBrandDisabled: ['#93a9fd', 0.5],
    strokePositive: ['#2Ecc71', 1],
    strokeNegative: ['#e74c3c', 1],
    strokeInfo: ['#93a9fd', 1],
    strokeCaution: ['#dc7633', 1],
    interactiveNeutral: ['#ffffff', 0.1],
    interactiveNeutralFocus: ['#ffffff', 1],
    interactiveNeutralFocusSoft: ['#ffffff', 0.1],
    interactiveInverse: ['#48474b', undefined],
    interactiveInverseFocus: ['#48474b', 1],
    interactiveInverseFocusSoft: ['#48474b', 0.1],
    interactiveBrand: ['#becffe', 0.1],
    interactiveBrandFocus: ['#becffe', 1],
    interactiveBrandFocusSoft: ['#becffe', 0.1],
    shadowNeutral: ['#000000', 0.7],
    shadowNeutralFocus: ['#000000', 0.7],
    shadowNeutralFocusSoft: ['#000000', 0.7],
    shadowNeutralText: ['#000000', 1],
    shadowInverse: ['#000000', 0.7],
    shadowInverseFocus: ['#000000', 0.7],
    shadowInverseFocusSoft: ['#000000', 0.7],
    shadowInverseText: ['#000000', 1],
    shadowBrand: ['#000000', 0.7],
    shadowBrandFocus: ['#000000', 0.7],
    shadowBrandFocusSoft: ['#000000', 0.7],
    shadowBrandText: ['#000000', 1]
  },
  componentConfig: {
    Keyboard: {
      style: {
        keyProps: {
          delete: {
            title: null,
            icon: 'data:image/png;base64,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'
          }
        }
      }
    }
  },
  font: [],
  layout: {
    columnCount: 10,
    focusScale: 1.2,
    gutterX: 20,
    gutterY: 20,
    marginX: 150,
    marginY: 150,
    safe: 50,
    screenW: 1920,
    screenH: 1080
  },
  radius: { none: 0, xs: 2, sm: 4, md: 8, lg: 16, xl: 24 },
  spacer: {
    none: 0,
    xxs: 2,
    xs: 4,
    sm: 8,
    md: 10,
    lg: 20,
    xl: 30,
    xxl: 40,
    xxxl: 50
  },
  stroke: { none: 0, sm: 2, md: 4, lg: 6, xl: 8 },
  typography: {
    display1: {
      fontFamily: 'Arial',
      fontSize: 75,
      lineHeight: 85,
      fontStyle: '500',
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    display2: {
      fontFamily: 'Arial',
      fontSize: 50,
      lineHeight: 60,
      fontStyle: '500',
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    headline1: {
      fontFamily: 'Arial',
      fontSize: 35,
      fontStyle: '500',
      lineHeight: 48,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    headline2: {
      fontFamily: 'Arial',
      fontSize: 30,
      fontStyle: '500',
      lineHeight: 40,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    headline3: {
      fontFamily: 'Arial',
      fontSize: 25,
      fontStyle: '500',
      lineHeight: 36,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    body1: {
      fontFamily: 'Arial',
      fontSize: 25,
      fontStyle: '300',
      lineHeight: 40,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    body2: {
      fontFamily: 'Arial',
      fontSize: 22,
      fontStyle: '300',
      lineHeight: 32,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    body3: {
      fontFamily: 'Arial',
      fontSize: 20,
      fontStyle: '300',
      lineHeight: 32,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    button1: {
      fontFamily: 'Arial',
      fontSize: 25,
      fontStyle: '500',
      lineHeight: 32,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    button2: {
      fontFamily: 'Arial',
      fontSize: 20,
      fontStyle: '500',
      lineHeight: 32,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    callout1: {
      fontFamily: 'Arial',
      fontSize: 20,
      fontStyle: '500',
      lineHeight: 32,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    caption1: {
      fontFamily: 'Arial',
      fontSize: 15,
      fontStyle: '500',
      lineHeight: 24,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    tag1: {
      fontFamily: 'Arial',
      fontSize: 20,
      fontStyle: '500',
      lineHeight: 24,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    },
    footnote1: {
      fontFamily: 'Arial',
      fontSize: 22,
      fontStyle: '300',
      lineHeight: 30,
      verticalAlign: 'middle',
      textBaseline: 'bottom'
    }
  }
};
