import Avatar from '../components/avatar.js';
import DateFormatter from '../components/date-formatter.js';
import CoverImage from '../components/cover-image.js';
import PostTitle from '../components/post-title.js';

export default function PostHeader({
  title,
  coverImage,
  date,
  author,
  authorPicture,
}) {
  return (
    <>
      <PostTitle>{title}</PostTitle>
      <div className="hidden md:block md:mb-12">
        <Avatar name={author} picture={authorPicture} />
      </div>
      <div className="mb-8 md:mb-16 sm:mx-0">
        <CoverImage title={title} src={coverImage} height={620} width={1240} />
      </div>
      <div className="max-w-2xl mx-auto">
        <div className="block md:hidden mb-6">
          <Avatar name={author} picture={authorPicture} />
        </div>
        <div className="mb-6 text-lg">
          <DateFormatter dateString={date} />
        </div>
      </div>
    </>
  );
}
