# Bump Version

This GitHub Actions, get the value of tag, and pass to the application, replacing the static version in `package.json`, automatically, without create a new commit and manually change the version.

This action, **works only** with push event of type **tags**

Example:

```yml
on:
  push:
    tags:
      - 'v[0-9]+.[0-9]+.[0-9]+'
```

If you use this action with a worflow that run without this trigger, this step will break.

## Supported Languages

At the moment, just support `package.json` that need exist in root folder

## Examples

```yml
name: Deploy Package to NPM

on:
  push:
    tags:
      - 'v[0-9]+.[0-9]+.[0-9]+'

jobs:
  publish_npm:
    name: Publishing to NPM

    runs-on: ubuntu-latest

    permissions:
      actions: write
      contents: write

    steps:
      - uses: actions/checkout@v3

      - name: Setup NodeJs
        uses: actions/setup-node@v3
        with:
          node-version: x.y # Version that you want use here
          registry-url: https://registry.npmjs.org/

      - name: Install Packages
        run: yarn

      - name: Bump Version of package.json
        uses: ramonpaolo/bump-version@v2.3.1
        with:
          tag: ${{ github.ref_name }} # Accessing the context and get the reference_name, that in this case, is the tag that you created(ex: v1.0.0)
          commit: true
          branch_to_push: 'main'

      - name: Publish package to NPM
        run: npm publish
        env:
          NODE_AUTH_TOKEN: ${{ secrets.NPM_TOKEN }} # NPM Token necessary to deploy packages on pipelines CI/CD
```

## Input parameters

| Name           | Description                  | Required | Default          |
| :------------- | :--------------------------- | :------- | :--------------- |
| tag            | The tag created(v.\*.\*.\*)  | `true`   | "v1.0.0"         |
| commit         | Commit the bump              | `false`  | `false`          |
| branch_to_push | Which branch to push         | `false`  | "main"           |
| path           | The path of the package.json | `false`  | "./package.json" |

## Output parameters

| Name       | Description                   |
| :--------- | :---------------------------- |
| parsed-tag | v1.0.0(input) = 1.0.0(output) |
