/*
 * Copyright (c) 2005, Swedish Institute of Computer Science
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the Contiki operating system.
 *
 */
#ifndef HWCONF_H_
#define HWCONF_H_
#include "contiki.h"
#include "sys/cc.h"

#define HWCONF_PIN(name, port, bit)                                           \
static CC_INLINE void name##_SELECT() {P##port##SEL &= ~(1 << bit);}          \
static CC_INLINE void name##_SELECT_IO() {P##port##SEL &= ~(1 << bit);}       \
static CC_INLINE void name##_SELECT_PM() {P##port##SEL |= 1 << bit;}          \
static CC_INLINE void name##_SET() {P##port##OUT |= 1 << bit;}                \
static CC_INLINE void name##_CLEAR() {P##port##OUT &= ~(1 << bit);}           \
static CC_INLINE int  name##_READ() {return (P##port##IN & (1 << bit));}      \
static CC_INLINE void name##_MAKE_OUTPUT() {P##port##DIR |= 1 << bit;}        \
static CC_INLINE void name##_MAKE_INPUT() {P##port##DIR &= ~(1 << bit);}

#define HWCONF_PINx(name, port, bit, register)                                           \
static CC_INLINE void name##_SELECT() {P##port##SEL##register &= ~(1 << bit);}          \
static CC_INLINE void name##_SELECT_IO() {P##port##SEL##register &= ~(1 << bit);}       \
static CC_INLINE void name##_SELECT_PM() {P##port##SEL##register |= 1 << bit;}          \
static CC_INLINE void name##_SET() {P##port##OUT |= 1 << bit;}                \
static CC_INLINE void name##_CLEAR() {P##port##OUT &= ~(1 << bit);}           \
static CC_INLINE int  name##_READ() {return (P##port##IN & (1 << bit));}      \
static CC_INLINE void name##_MAKE_OUTPUT() {P##port##DIR |= 1 << bit;}        \
static CC_INLINE void name##_MAKE_INPUT() {P##port##DIR &= ~(1 << bit);}

#define HWCONF_IRQx(name, port, bit)                                           \
static CC_INLINE void name##_ENABLE_IRQ() {P##port##IE |= 1 << bit;}          \
static CC_INLINE void name##_DISABLE_IRQ() {P##port##IE &= ~(1 << bit);}      \
static CC_INLINE int  name##_IRQ_ENABLED() {return P##port##IE & (1 << bit);} \
static CC_INLINE void name##_IRQ_EDGE_SELECTD() {P##port##IES |= 1 << bit;}   \
static CC_INLINE void name##_IRQ_EDGE_SELECTU() {P##port##IES &= ~(1 << bit);}\
static CC_INLINE int  name##_CHECK_IRQ() {return P##port##IFG & (1 << bit);} \
static CC_INLINE int  name##_CLEAR_IRQ() {return P##port##IFG &= ~(1 << bit);} \
static CC_INLINE int  name##_ENABLE_PULLUP() {return P##port##REN |= 1 << bit;} \
static CC_INLINE int  name##_IRQ_PORT() {return port;}

#define HWCONF_IRQ(name, port, bit)                                           \
static CC_INLINE void name##_ENABLE_IRQ() {P##port##IE |= 1 << bit;}          \
static CC_INLINE void name##_DISABLE_IRQ() {P##port##IE &= ~(1 << bit);}      \
static CC_INLINE int  name##_IRQ_ENABLED() {return P##port##IE & (1 << bit);} \
static CC_INLINE void name##_IRQ_EDGE_SELECTD() {P##port##IES |= 1 << bit;}   \
static CC_INLINE void name##_IRQ_EDGE_SELECTU() {P##port##IES &= ~(1 << bit);}\
static CC_INLINE int  name##_CHECK_IRQ() {return P##port##IFG & (1 << bit);} \
static CC_INLINE int  name##_IRQ_PORT() {return port;}

#endif /* HWCONF_H_ */
