---
layout: guide
title: Remote Pairing For the Win!
description: "Continue working together and learning remotely after the Rails Girls event."
permalink: remote
---

# Rails Girls Remote Pairing Tutorial

*Originally created by Ed Drain, [@SoldierCoder](https://twitter.com/soldiercoder)*

## Why is Remote Pairing so great?

First things first, what is my motivation for sharing this?  If you are reading this, you are already aware of the power of [Rails Girls](https://railsgirls.com).  In case you did not know, let me give you a few facts.  Rails Girls is an organization that introduces women to web application development using Ruby on Rails.  For many women around the world, it is a **powerful, emotional experience** that shows them that they can create something new for the Web and that they have support of other women who extended their privilege to them.

I said "around the world", didn't I?  Indeed, Rails Girls is on **every continent** and in **130 \+ cities!**  I know this is true because, through the generosity of Ryan Bates ([@RBates](https://twitter.com/rbates)), I have had the honor of distributing coupons good for three months free of [RailsCasts.com](http://railscasts.com) to so many of those cities. So there is part of the promise of Rails Girls -- that women, around the world, who need some way of lifting themselves up out of possibly dire circumstances and thru study and application of what they have learned, get the pot of gold at the end of the rainbow -- a high paying job where they are **respected for their creations**.

## But seriously, why is Remote Pairing so great?

Remote-pairing is so great because people who can benefit from people who would coach them are not always near to them.  I know this because as a coach for [Rails Girls Summer of Code](https://railsgirlssummerofcode.org) who lived in Virginia, while the team I coached lived in London and Pennsylvania.  If it weren't for remote pairing, I'd have to get on a plane or drive twelve hours just to show how to write a "hello, world!" example app!

## Ok, I'm sold!  What do I need to remote pair?

* An Internet connection.
* One or more programming friends or mentors that want to remote pair with you.
* To communicate with each other you'll need a calling service like [Google Meet](https://apps.google.com/meet/), [Signal app](https://signal.org/), [Whereby](https://whereby.com/) or anything other app you're familiar with.
    - Ideally the app you're using to call can also share your screen so the other person can see your screen.
    - It's even better if the other person can also control your screen from their end. If this is not possible in the call app itself, you can use the Visual Studio Code Text Editor plugin Live Share to share your code in your editor. Learn about how to [install the Live Share extension](https://learn.microsoft.com/en-us/visualstudio/liveshare/use/install-live-share-visual-studio-code) and how to [share your project with Live Share](https://learn.microsoft.com/en-us/visualstudio/liveshare/use/share-project-join-session-visual-studio-code).

## Last thoughts

The Ruby community is such a great example of people helping others.  One has only to look at the folks nominated every year as [Ruby Heros](http://rubyheroes.com/) to see  this in action.

What a great and generous world this would be, if all of us extended some of our privilege to someone who has less.  It would be a world that reflects that most common of sayings that you probably hear at meetings of your local Ruby/Rails meet-up: "MINSWAN" -- Matz is nice, so we are nice!  Let's get started being nice to each other!
