---
layout: main_guide
title: Setup on Replit
description: "Prepare development of your app on the Replit service to develop your app in the cloud."
permalink: install/replit
---

# Using a Cloud Service

{% include main-guide-intro.html %}

Instead of installing Ruby on Rails and an editor on your computer, you can use a webservice for development. All you need is a browser and an internet connection. This guide explains how to get started with [replit.com]. If you're using a different service, they may use a different wording, but the process is usually pretty similar.

## _1._ Create an account

Go to [replit.com] and sign up for free.

You will need to confirm your email and then fill in your details.

![Log in screen](/images/replit/create-account.png)

## _2._ Create a Ruby on Rails Repl

The Ruby on Rails Repl has all the software we need for the workshop already preinstalled.

<video width="100%" preload="auto" muted controls>
	<source src="/images/replit/replit-rails.mp4" type="video/mp4">
</video>

To create one, log into [replit.com] and click on 'Create'.

![Dashboard with the Create button pointed to by arrows](/images/replit/create-app.png)

In the field under Template, type in `rails`.

![Search dialog for Repl templates](/images/replit/search-rails.png)

1. Select the `Rails` option from Templates.
2. It generates a name for your Ruby on Rails app but you can change it in the Title field (maybe to "RailsGirls").
3. Click the `+ Create Repl` button

![Create the Rails Repl dialog](/images/replit/create-rails-repl.png)

## 3. Coding with your project

- On the left hand side, you find a file browser where you can navigate your directories and file.
- In the middle, you find the editor where you can modify your files.
- Click the `Run` bottom at the top to start up the freshly installed Ruby on Rails app.

![Run button highlighted to start the Rails app](/images/replit/run.png)

- You'll see a mini web browser to the top right showing you your fresh Rails app running the default homepage with the Rails logo.

![Rails app running](/images/replit/rails-running.png)

- At the bottom right, when you click the `Shell` button you'll find the terminal where you can run commands.

![Shell](/images/replit/shell.png)

## 4. Returning to your project

When you log out and log back in to [replit.com], you can find your RailsGirls app in the middle of the dashboard. Just click it to go back into the project.

![Dashboard showing button to return to Rails project](/images/replit/re-open.png)

[replit.com]: https://replit.com
