---
layout: guide
title: "After The Event: How To Continue With Programming"
description: "A guide to keep you going with learning how to program."
permalink: how-to-continue-with-programming
---

# After The Event: How To Continue With Programming

*Created and edited for general use by Daniel Puglisi, [@danielpuglisi](https://twitter.com/danielpuglisi).*

*This guide was originally written for the [Rails Girls Basel](https://railsgirls.com/basel) event
and was published on
[Daniel Puglisi's personal blog](http://danielpuglisi.com/articles/2013/04/rails-girls-after-the-event-how-to-continue-with-programming) (link is no longer working 2023-02-12).*

## How To Continue With Programming

Unfortunately (!) the event is over. We'll hope this guide will help you find the best way to keep going with learning on how to program!

There are 4 steps which Daniel has come up with and he encourage you to really take them to your heart and do them.

## 1. Keep on Coding

Mastering a craft requires constant repeating and perseverance.
This also applies to programming. I encourage you to repeat the Rails
Girls tutorial which we did at the event and try to play around with
it some more.

After that here are some free and paid resources which will help you
to take things to the next level:

### Courses

* [Rails for Zombies](https://www.pluralsight.com/courses/code-school-rails-for-zombies) - A Rails Screencast which you can try for free. Pluralsight also provides a series of paid [Ruby and Rails](https://www.pluralsight.com/paths/ruby-language-fundamentals) courses which are awesome. You should really try them!
* [Codecademy](https://www.codecademy.com/) - The world isn't just created with Ruby and Rails. There are also plenty of other languages like HTML/CSS, JavaScript, Python and so on. Try them out!

### Books

* [Rails Tutorial](https://www.railstutorial.org/) - A awesome book which has a free HTML version and a paid print version. The book provides you with a lot of great material which we couldn't cover at the Rails Girls workshop.

### Screencasts & Videos

* Confreaks - Talks from conferences all over the world. There are playlists for RubyConf and RailsConf on the [Confreaks YouTube channel](https://www.youtube.com/user/Confreaks/playlists). Learn about the latest in the Ruby!
* [Richard Schneems Screencasts](https://www.youtube.com/user/schneems/videos) on YouTube.
* [Railscasts](http://railscasts.com/) - Short and simple screencasts about Rails by Ryan Bates. (Note: Ryan is no longer updating RailsCasts.)

### Even more!

* [Thoughtbot Trail-Map](https://github.com/thoughtbot/trail-map) - Guides to different topics.

If you have any other good resources, please add them by [contributing](/contributing) to this guide.

## 2. Build something real

Build something real means you should try to create something which is actually needed in the end.
The hardest part will be to find a real project.
If you have no idea, try to think of something that really upsets you.
Do you have to use something in your daily life that pisses you off?
Write an application for it and try to solve that pain.
This way you will be more motivated than by just following tutorials.

And don't forget to show your application to your friends and the world.
Ask for feedback and keep on learning.

If you still have trouble finding something you can work on I have an idea for you:
Build a Rails Girls website for your country or city if there isn't one already. (Ask your organizers!)

## 3. Get in touch

Its always easier when you have someone you can ask.
With this in mind, go out and find someone who you can talk to.
Now is the best time for it,
because you just got to know a lot of like minded people which have more or less the same level as you.
There are a lot of ways to communicate nowadays,
e.g. attend a local meetup group, create Facebook Groups or write a good ol' letter :)

From my experience, knowing some people who have the same interests as you is one of the most important parts.
Try to convince people, that programming is fun.
If you have a brother or a sister, show them what you've learned.
Or show it to your parents, children or friends.
Just try to build a circle of people with the same interest in programming and technology.

Also try to find someone that can be a mentor to you.
Programming can be really intimidating sometimes,
so it can help to know someone which has more experience and can help you with your problems.
For example: ask someone that was a coach at the workshop you attended.

One of the girls at the Rails Girls Basel event (thanks [Helena](https://twitter.com/HBobbiRo)!) had the great idea
that we could put up a list with all the attendees, coaches and organizers of the event.
We created this list and it's on [GitHub](https://github.com/RailsGirlsSwitzerland/attendees) now, [check out the website](https://railsgirlsswitzerland.github.io/attendees/site/2013_04_basel.html).
Feel free to fork the repository and adjust it to the needs of your Rails Girls event.

Try to setup such a list for your event too, this way its a lot easier to stay in contact with everyone than just
with the people who sat around the same table as you did.
If you don't know how, ask someone of the organizers of the event if she or he could do it.

## 4. Have fun

Last but not least, have fun.
If you don't enjoy programming it is probably not the right thing for you.
But thats the same story for every profession or hobby.
Not only for technology related topics.
But if you just read this I think you are perfectly made for programming,
otherwise you wouldn't be here in the first place ;)

So, if you liked the workshop and the event - you're in the right spot.

If you have any further questions, don't hesitate to ask.
You can do this via [Twitter](https://twitter.com/railsgirls) or email.
Ask the organizers and coaches of your event for their email addresses and if they would like to help you.

Thats it, keep on coding and let's build the future!

## 5. More resources

- [8 ways to enable workshop attendees to keep learning](https://pragtob.wordpress.com/2013/06/14/8-ways-to-enable-workshop-attendees-to-keep-learning/)
