---
layout: guide
title: Host your own Rails Girls event
descriptive: "Want to organize your own Rails Girls workshop? Follow this guide to learn how."
permalink: guide
---

# The How to Guide

## Hosting your first Rails Girls event

Our aim is to give tools for women to understand technology. The Rails Girls events do this by providing a great first experience on building the Internet.

Rails Girls was founded in end of 2010 in Helsinki. Originally intended as a onetime event, we never thought we'd see so many local chapters all around the world! This guide has been put together to help you get started.

If you want to organize an event, start by filling out <https://railsgirls.com/inyourcity> and you'll receive more instructions.

A list of upcoming events can be viewed at [railsgirls.com](https://railsgirls.com).

You are also welcome to join our [organizers' Slack discussion forum](https://rails-girls-slack.herokuapp.com/).

### The Basics
Rails Girls events are non-profit. We don’t charge the participants and do not pay for coaches or speakers. Participants don’t need any previous knowledge about programming and there are no age-limitations. All the participants need is a laptop and some curiosity.

The two-day event includes a lot of small group working and short focused talks on programming, design and web. No panel discussions or podium-talks - the spirit should be informal and hands-on. The more you can remove abstractions and add inclusivity the better.

#### Rails Girls philosophy

* Show spark, personality and keep in mind the big picture. Explain, repeat and always tie what you're telling into a larger context.
* Internet was made by people and it doesn’t break by a little tinkering. Continuously show the human side: encourage coaches to talk about open source communities, their programming idols and their aspirations.
* Copy-pasting rules. Programming per se isn’t central - you can't really learn to speak Chinese in one day, in a similar manner you can only learn the basic vocabulary and expressions in coding. The goal of every event is to make something visible!
* Girls run this world! But also women, ladies, even boys are allowed in. More than semantics we're interested in a mindset. Both founders were born in the Spice Girls era, they don't see the word girl as condescending or cutesy-cute.

#### Codes of Conduct

Rails Girls events are inclusive, friendly and safe environments. They have zero tolerance of harassment or bullying. You can include a Code of Conduct to your event. Below are examples:

* [Rails Girls Summer of Code Code of Conduct](https://railsgirlssummerofcode.org/about/code-of-conduct/)
* [PyLadies Code of Conduct](https://www.pyladies.com/CodeOfConduct/)
* [Geek Feminism Wiki Anti Harassment example](https://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy)
* [Conf Code of Conduct](https://confcodeofconduct.com/)
* [Rails Girls DC Code of Conduct](https://docs.google.com/document/d/1XEnFI3R30IiGXOpC4idb0ku3pw8OoJcBpG9mg3iKiAo/edit)
* [Rails Girls NZ Code of Conduct](https://docs.google.com/document/d/1EiTZ-__VDuXpN1OqgVKnYr2Km_N3fD9WWN3g5cv5hAA/edit)

### Example Program

Every Rails Girls event starts with an installation-fest where the setup is pre-installed to the girl's computers. See [the install guide](/install) for readymade instructions. The installation-fest can include short talks, but the main point is to offer some sparkling wine, get everything set for the next day and the women to know each other. The timeframe is tentative - you know your audience and what suits them best. We've hosted events both during weekend and weekdays. Also, doing two evenings (4PM - 22 PM) might be a more suitable solution for your community needs.

#### Learning objectives of the workshop:

* Understanding the difference between a dynamic and static web page.
* Vocabulary of the web: developing a basic understanding of what components make a web application. Understanding the ABCs of coding: strings, methods, variables, arrays, exclamations, chaining, hashed, symbols, blocks.. as well as the tools (terminal, browser, text editor). Creating a conceptual understanding of the web's building blocks: programming languages, frameworks, databases, infrastructure.
* Have an idea of how to move forward in the programming world: both online and offline.

#### Friday evening: Installation

19:00 - 21:00 Installations and getting to know each other
*Hint*: Have a coach table where problematic computers can be brought.

Some installations will fail: be prepared to set women up in pairs, don't use endless amounts of time.

Decorate the place with balloons and posters. Put a fun <a href="https://open.spotify.com/playlist/1fgkUFCFDrSn621kf4iHhr">playlist</a> together for the evening.

Come up with activities to break the ice: ask the girls to write why they are attending the event on post-its or to draw and describe their dream web app.

Remember to do a #FridayHug!

21:00 -> Coach dinner (optional)
Go through the application with the coaches during dinner.


#### Saturday: Workshop

09:00 - 10:00 Registration and coffee
*Hint* Reserve enough time for people to mingle and to solve any problems there might be with installations. Give out workbooks, collect acronyms for the Bento exercise.

10:00 - 10:10 Welcoming words
*Hint* Mention sponsors, show what we'll build, tell what programming is.

10:30 - 11:00 UX workshop

11:00 - 11:30 Introduction to programming
*Hint* Ask one of the coaches to do this. Explain why learning Ruby basics is important even though they'll be using Rails.

Themes to cover:

+ The difference between dynamic and static websites: what are web apps?
+ What are programming languages? What is Rails?
+ The tools we’ll be using: browser, terminal, code editor, folder structure

Show & tell with <a href="https://ruby.github.io/TryRuby/">TryRuby</a>, first three-four exercises all together.

11:30 - 13:00 Workshop time
Going (slowly!) through the curriculum at <a href="/app">guides.railsgirls.com/app</a>. Stop to explain what you’re doing and what the different concepts mean.

Try to aim for simple explanations even with the cost of accuracy. You don’t need to talk about all underlying concepts. Just try to answer questions when they arise, or move on if they’re too hard or out of scope. You are not here to teach perfect coding skills but to show how to get stuff done. One has to learn how to build web apps before learning how to do it well.

Concepts to cover:
+ Rails Generators
+ Scaffolds: Rails App Structure
+ Gem Management
+ MVC, REST/Resources
+ Models and Active Record
+ Controllers and ActionController
+ Views and ERB

*Tips:* Coaches are people too. They are doing this for the first time too. Teaching might be hard and intimidating, so remember to be available to help coaches or groups with difficult situations or just provide support and encouragement.

13:00 - 14:00 Lunch

14:00 - 14:30 Bentobox exercise
Putting technical jargon into a context with a conceptual model called Bentobox.

Two exercises: 1) Going through the 10 technical concepts with the physical Bentobox boards.  2) Going through the words the women have themselves submitted with the coaches.

+ [Bentobox slidedeck](https://speakerdeck.com/railsgirls/rails-girls-bentobox-exercise)
+ [Instruction video](https://vimeo.com/39049632)

14:30 - 18:00 Workshop time.

Time to continue working on the applications. Monitor the situation: when it seems like people have a hard time concentrating, have the coaches or other speakers give quick lightning talks.

Example topics for lighting talks:

+ Real (female) programmers telling what their career has been like.
+ Design: UX & UI. Making mockups together either with paper or computer.
+ Fun ways of explaining technical concepts and recent frameworks: what is CoffeeScript explained in 80s pop songs? How would you describe GitHub? What coding and creative writing have in common?
+ Show us something real: don’t speak in abstractions, be specific and tell stories.

Once everyone has finished their app, there is time to extend the application by modifying the CSS, implementing commenting systems etc. Allow enough time for experimentation.

19:00 After party  
*Hint:*
Invite everyone, also the local developers, boys, those who weren't accepted, to join!

[Fork this project on GitHub][github], add yourself, and send us a pull request.

[github]: https://github.com/railsgirls/railsgirls.github.com "Fork on GitHub"

#### Materials

+ [Download materials](https://speakerdeck.com/railsgirls)

### Promotion of Rails Girls

Every Rails Girls workshop will get a custom website at railsgirls.com/city where the information is collected and then stored. For past cities, see <https://railsgirls.com/events.html>

You can also set up your own Facebook and X page (remember to add links to your workshop's page!) or whatever service is popular in your community. Promoting the event through social media can go a long way these days, but make sure you have somebody to take care of the chosen channels. Some tips:

* Keep the tone of posts friendly, positive and welcoming. Be direct in inviting fans/followers to share the event with their friends.
* Photos are especially powerful messengers. Create your own graphics (*some ideas: "I'm a Rails Girl" Facebook cover for the event, word cloud with first names of women who signed up, an infographic of applications*) or promote photos from other workshops if this is your event. Follow other Rails Girls pages and account to get ideas for content and pass it along to your community.
* Try various pitches for events to attract different types of women; some will be in it for the fun and meeting new people, some to learn new things, some will be fueled by the desire to show guys that women can do anything. No need to focus on just one group!
* Don't be afraid to publicly thank women, coaches, blogs, media and other supporters who help you spread the word about your workshop for their support.
* If your language supports it, use feminine forms when addressing women.

While the event is underway, remember to take pictures, collect tweets and ask questions of the participants. You'll be thankful for all of that for your next event. We love to write blog posts about the speaker and participant experiences. A list of the coaches is also required.

+ [Download materials](https://speakerdeck.com/railsgirls)

#### Website
E-mail contact(a)railsgirls.com and ask to be included in the repo. Look for readme.txt for further instructions! Before making a site you should have at least two coaches and one sponsor onboard.


+ [Counter for the site](https://github.com/ys/rails-girls-count#readme)

#### How to find local developers?

* Google. Almost every country has some sort of a Rails or Ruby community (sometimes called Ruby Brigade or Ruby Tuesday). Look for [Hackernews](https://news.ycombinator.com) meetups, [GitHub](https://www.github.com) contributors or [Dribbble](https://dribbble) draftees. Find the local open source scene. Surf the technology conferences of [Ruby-themed ones](https://rubyconferences.org/), but others are cool too) and meetups at [meetup.com](https://www.meetup.com). Call software development houses, big and small. Don't forget IRC and podcasts!

* Check out hashtags like #rails #ruby and #opensource from [Twitter search](https://twitter.com/#!/search-home). To find people from, say, close to NYC, use the following search operators "near:NYC within:15mi". Some countries have specific hashtags like #Rubysur and #RubyArg they use, remember to ask!

* Startup community. Startup Digest is a good beginning point for events and communities.

* Often there are one or two key people who will be able to introduce you further. The technology world is surprisingly connected.

#### How to find participants?

* Use social media: Facebook, X & local networks such as Weibo. Friends, girlfriends, co-workers!

* Local [Girls in Tech](https://twitter.com/#!/gitweet), [DevChix](http://www.devchix.com/), [Geek Girl](https://www.geekgirlmeetup.com/) chapters etc. Check out also [Meetup.com](https://www.meetup.com/). X lists like @anitaborg's [Tech Women Programs](https://twitter.com/#!/anitaborg_org/tech-women-programs) and similar.

* Think outside the box: universities, book clubs, music stores, design agencies, [Etsy](https://www.etsy.com). We want women who are interested in technology, but they can still have very varied backgrounds.

#### How to get press?

One of the big aims of Rails Girls is to make it more mainstream for women to build the web. That’s why we like to engage the local press and highlight the participants and their enthusiasm. We’d be happy to help prepare a press-release for the media. Check out [railsgirls.com/press](https://railsgirls.com/press) for more. If you're working with a big company as a sponsor, their PR department might be able to help you spread the message about the workshop.

Send the press release to local blogs, find contact at various media outlets. The more doors you knock on, the greater you chance of getting through. Make a list of journalists and bloggers you contact, mark those that respond to your emails, so they can be the first ones to receive your next press release. You can also write a press release after the event that includes photos and statements from satisfied participants.

### Sponsorships

Rails Girls talks to a demographic that might be hard to reach other ways: women who have an interest in technology, who are possible users, employees or partners of the sponsoring company.

We are looking for sponsors who are active participants in the local technology scene, whether it’s a startup or a big corporation, a non-profit or a government organization.

Also non-traditional technology companies can be approached: kids stores, universities, women's magazines, beverage brands etc. They all should however have some affiliation or interest in technology.

Rails Girls should always be kept non-profit: if there's money left, it should be used to support the future activities of the attendees. Don’t forget that you don’t need that much funding and even a two-person startup could be very willing to chip in.

We advice against having only one sponsor (cannabilize the event) or having a SPONSOR NAME edition of the Rails Girls workshop. The Rails Girls brand is not meant for the commercial advancement of a single company.

### Example letter for sponsors

Dear xxx,

We are organizing a Rails Girls programming workshop in (insert city) on (insert dates).

Rails Girls is a two-day non-profit event for women of all ages to give them a great first experience in software craftsmanship. We aim to give the tools to understand technology along with the community and inspiration to get started.

Rails Girls is not just about programming, it’s about building things. During the workshop, we’ll build an application and also have inspiring lightning talks and exercises.

For a closer look, please see www.railsgirls.com for past events and coverage. Here’s also a short video on the Berlin event held in April 2012: <https://vimeo.com/40852182>

We are now looking for sponsors to help us realize this all.
We’d love to have your support!

Yours, name



### How much does it cost?

The costs below are estimated for 30 participants, 10 coaches - but they may vary a lot. It's easiest to try to get a local sponsor to pay the bills directly or partner with someone who has a set account to handle money. These calculations are done in Finland, in €, where food & alcohol is very expensive, but spaces are often free. All in all you should be able to organise an event easily for a little over a thousand euros.

+ **Sparkling wine + cups** for the installation festival. 6 bottles, 6 euros a bottle. 36 euros.

+ **Breakfast Coffee**, pastry. 40 times around 5 euros. 200 euros

+ **Lunch.** Catered lunch can be around 15 euros, but you can do with a lot less by cooking yourself.  Add some water and coffee (50 euros). 650 euros.

+ **Marketing materials.** Printing workbooks, ordering stickers, posters and other swag. Again, varies a lot, maybe you can use someones printer, but at least around 200 should be reserved.

+ **Coach dinner.** At a restaurant or homemade. A way to say thank you to the coaches for their volunteer work. Around 20 euros per head. 200 euros.

+ **Space.** Try to get this one sponsored/free, they can be really expensive. Often startups are co-operative and can offer their space for use (esp. on weekends).	0 - XXXX euros.

+ **Afterparty.** It's nice if you can throw a good party with free beverages, but can also be done low-key in a local bar or on set in the park!	0 - XXXX euros.

+ **Travel expenses.**	If you don't have any RG-team members in your country, consider inviting us over. We don't need fancy hotels, promise! Same if you want to invite speakers to your event. 	0 - XXX

+ *Total 1286 euros*.

__What do sponsors get?__

* Logo on event website
* Table space at event, opportunity to distribute handouts and/or swag
* A chance to speak to attendees for 5 minutes
* In most events there are official pictures taken that the sponsors can use afterwards

Don’t give out the participant info, but sponsors are free to hang out at the event and be sure to include a short message to the sponsor in a thank-you note. Sponsor swag may be included in the goodie bag to an extent, but it should be something tasteful, not trashy and/or related to women.



---

## FAQ

#### Who can organise a Rails Girls workshop?

Anyone. What we look for is a group of people dedicated in making this a stellar first experience in the world of web making for women. What we hope to see is some (not all) of the following:

* Contacts to the local developer scene. We are pretty technology agnostic, so it doesn’t have to be purely Ruby & Rails people. In practice every event needs 5 or more coaches (the number of coaches depends on the number of women you're planning to accept) that have basic knowledge of Rails and two days to contribute. In general the events have been around 25 - 40 people strong.
* Event organisation know-how. Not heaps, but some practicalities under the belt.
* An inkling of an idea where to look for women interested in technology. University, literature, arts, sports - we try to look for people who are interested in Internet, but do not have experience in coding.
* Willingness to guide the women in the future if they have questions or want to organize their own events or find local developer gatherings.

Start by filling out <https://railsgirls.com/inyourcity> and someone from our team will be in contact

#### Where can I find all the materials for posters, nametags, sample presentations and such?
Check out below, and let us know if something is missing!

+ [Download materials](https://speakerdeck.com/railsgirls)

#### What kind of venue is needed?

We recommend choosing a venue with a built-in infrastructure for around 30-50 persons. For a programming event, this means:

* High-speed, tested Internet. There’s going to be over 30 computers online all the time. Add to that mobilephones, streaming music, funny videos and you get the picture!
* Space for 4-6 person groups to gather together: chairs and tables, sometimes big pillows will do! This doesn’t have to be in the same room.
* Possibility to set up extension chords and a projector.
* Enough electric outlets to spare. Some women might have older laptops that will need to be plugged in at all times.
* Location for food and beverage setup - lunch space for catering or a nearby lunch venue.
* External monitors for teams are encouraged but not mandatory, helps the coaches show what is happening in the code.
* Whiteboards can be helpful for coaches to explain more abstract concepts. Alternatively, paper and pen work just fine. Just have something at hand people can draw on.

Ask where local developer meetings are usually hosted. Often co-working spaces are also willing to negotiate deals to gain some visibility among new people.

#### What is expected from the coaches?

Rails Girls events are organized around small groups, maximum of 4-5 persons per one coach. If possible, try to have groups of 3 women for each coach. For instance, if you're doing an event for 30 women, aim for having 10 coaches (a few more for backup don't hurt). We know this isn't always possible, but do try not to have groups of more than 5 women, so the coach can still answer all questions in the group.

The coaches don’t need to be hardcore experts on Rails - basic knowledge and willingness to explain trumps expertise. So, if your local Rails community isn't very strong, do expand your search. You can have a mix of Rails experts and people with web development expertise in other frameworks. We are looking for people who like answering questions and can keep an upbeat and positive atmosphere through a period of 8 hours!

You can get to know the curriculum by checking out [the guides index](/). There is also always a pre-event coach dinner where we’ll go through some pedagogical suggestions and check everyone knows what is happening. Avoid jargon, tie examples to what your doing, encourage asking questions. The installation instructions can be found in [the install guide](/install). We also understand that coaches are human and that for most of the people this is the first time teaching something. Worry not - the women have always been really happy with whatever they learn and just the chance to ask questions is enough.


We hope the coaches are ok with having their name and twitter-id/github/some mean of contact on railsgirls.com so the women always have a local face to answer their questions.

In addition, we encourage coaches to come up with additional exercises for the group. After completing the ideation app many women will want to try tweaking the look & feel of the site, implementing commenting, Facebook sharing, pushing the app to Heroku, etc.

#### How to find coaches?

Ask around, ask sponsors (tech companies), ask anyone to help you out. Once you do get some coaches on board, they can help you out with their own contacts. Influential bloggers or X users in your local dev community can help you out by broadcasting a call for coaches. *Hint: You can also thank coaches for their help by providing a spot at the workshop for their girlfriends ;)*

##### Sample letter for potential coaches

"Dear community member,

We wish to invite you to take part in the Rails Girls event on (insert date). The event is aimed for women of all ages with no previous programming experience, but a lot of passion to building things. Rails Girls is an international non-profit, volunteer-based workshop. We've had events in Shanghai, Berlin, Helsinki, and Singapore. We expect to receive around a 100 applications.

In addition to giving a safe and fun first experience to coding for the women we want to engage them with local developers, open source, and the startup scene. We've attached some information on what coaching requires in practice. In addition, we have room for small lightning talks on technical subjects. If you have something you'd like to speak about, let us know.

For more information about the non-profit event, check railsgirls.com or guides.railsgirls.com

(You can also include the chapter "What is expected from the coaches" to the mail)"

---



#### What materials do I get?

Each Rails Girls event gets a specific webpage.

In addition we’ll help you out with the goodie bags, poster templates, workbooks and other swag like stickers, reflectors and so forward. All of the materials can be found on this site. You can also ask the sponsors to include some sponsor materials if they wish. We are always looking for creative outlets for the Rails Girls brand, if you have ideas, let us know!

So far we've had

* Stickers
* Reflectors
* Tattoos

Also, check out:

+ [Download materials](https://speakerdeck.com/railsgirls)

#### How do I choose attendees?

In the form we ask only two questions: do you have any previous background in coding and why would you be a good participant for Rails Girls

Rails Girls is intended for anyone and we want to keep it flexible enough for learners any age. However, make clear to the attendees what to expect: Rails Girls won’t make anyone into a coder, so people looking for i.e career change will be disappointed. On the other hand we like people with very diverse backgrounds and loads of enthusiasm.

After selecting participants we generally split them into three groups:

1. people with no previous programming experience
2. people with some front-end experience (HTML, CSS, Javascript) and
3. people with a little experience in programming or a background in computer sciences. You can use the different name-tags for each group if you want to (rubies, foxes, octocats, rails..)


##### Sample letter of acceptance

Title: Rails Girls workshop - welcome!

Dear attendee,

Congratulations! We’re happy to invite you to join in on the  Rails Girls workshop in (insert city). We hope that this workshop will provide you a great first experience on building web apps.

What happens next?

(Insert date for installation fest) starts at (insert time) with an installation fest - so please bring your laptop with you! You should also try to pre-install Rails with instructions from </install>

We will hold the event in (insert address)

On (insert date) we’ll dive into development. We’ll work in small groups with four to six person teams. Your team members will have about the same experience level as you. We'll be all developing a simple listing application. We'll wrap the day around (insert time). There's also going to be an evening party.

We have a lot of people wanting to get to the class, so if you can’t make it this time, let us know as soon as possible!

If you have any questions, please don't hesitate to contact me. We'll also be updating the website at (insert address)!

Best,

(Signature)

##### Sample letter of not being accepted

Title: Rails Girls - not accepted this time

Dear applicant,

Unfortunately we couldn’t fit you in the workshop this time. To be able to give personal guidance to each participant, we could only take a fraction of the applicants. This time we prioritized women with no previous programming experience.

However, you're warmly welcome to the official afterparty. (Insert details).

We'll also be most likely organizing more events in your city. Follow twitter.com/railsgirls or facebook.com/railsgirls for more information.

There's always cancellations and we fill all available places, so we might still be taking in a couple of people!

Best,

(Signature)

##### Sample thank you letter for participants

Dear Rails Girls,

Thank you for taking part in the Rails Girls event. We truly felt lucky to have such a talented & enthusiastic crowd of people with us and hope many of you will continue working with Rails in the future - you have the tools, now build something cool!

(Say a few words about the sponsors and coaches - thank you for the community)

Three things we want to share:
in
Workshop Materials
(Almost all) materials can be found in the guides section at <https://guides.railsgirls.com>. You can find presentations, materials and instructions from the workshop. If you took pictures or blogged about the event - let us know! We'll be publishing regularly on railsgirls.tumblr.com

Make Rails Girls better - give us feedback!
We want to hear from you! Give us feedback about the workshop or how we can make the event better – it’s really quick, and it’ll help us improve our workshop at railsgirls.com/feedback

Keep on coding!
We realize there was quite a lot of stuff in todays lecture and for most of you it all felt a little overwhelming. We strongly recommend trying out [Rails for Zombies exercise](https://www.pluralsight.com/codeschool) latest by next weekend, it'll refreshen all you've learned so far and teach you some more.

Two things to keep you going:
- (Insert here a couple of community events that the participants should take part in)

There was a LOT of interest in doing follow-up events. If you have ideas for this or want to volunteer for the organizing team, let us know and sign up for the group e-mailing list at http://groups.google.com/group/rails-girls-team!

And that’s all for now,
Your Rails Girls team





#### What happens after the event?

Inviting real developers to coach is Rails Girls sessions not only gives the participants a chance for hands-on education, but also makes the barrier to enter the technology world lower. How to keep the women coding?

* Encourage them to continue practicing by trying different exercises like Codecademy and such.
* Mention at least two forthcoming developer events where the local coaches will be. Try to get the women to attend actual developer meetups.
* Invite everyone to the Facebook Group where they can ask questions.
* Invite the women together again within a month. You can host these meetups at the Rails Girls global meetup page <https://www.meetup.com/Rails-Girls/> - we’ll be happy to promote events. However, it doesn't matter under which brand you want to continue meeting - the important thing'
* Write about your event for railsgirls.tumblr.com by [submitting a story](https://railsgirls.tumblr.com/submit)



---

## Checklist

This is a small checklist for your event. Rails Girls can be thrown together in a matter of weeks, but to truly have time to make a good event, prepare at least two months. Not all of these steps are of course mandatory and they are here just to help you remember.

### Before the event:

* Fill in the [application](https://railsgirls.com/inyourcity) and the team will contact you!
* Start working with the project plan template on Google Docs
* Decide dates and set a venue
* Reach out for the local coaches - try finding five people who commit to taking part
* Release the website: write the copy and suggest a theme
  1. Dates and location.
  2. Application deadlines.
  3. Short introductory text, around 200 characters. Check out the past events for inspiration!
  4. Speakers of the day
  5. Partners - a two-paragraph sentence and a logo (100 x 100px or 250 x 90px and in png format)
  6. Coaches with twitter-handle

* Start marketing the event, you can use materials from [here](https://speakerdeck.com/railsgirls)
* Start looking for sponsors
* Reach out for press and write a pre-event story
* E-mail accepted participants and non-accepted applicants
* E-mail installation instructions and last minute event details
* Set a date for coach dinner and send them instructions
* Check if there are other events taking place the same weekend

#### During the event

* Tweet!
* Remember to take photos
* Interview participants and speakers about their experiences
* Do a Friday Hug! Take a picture with everyone and share it on social media with the hashtag #FridayHug!
* Have a Skype with other Rails Girls chapters hosting events at the same time

#### After the event

* Update website to include pictures and blogposts
* Collect slides from the speakers and add them to the [Rails Girls presentation](https://github.com/railsgirls/presentations) repo
* Upload your photos to our [official Flickr group](https://www.flickr.com/groups/railsgirls/) (preferably under a [Creative Commons](https://www.flickr.com/groups/railsgirls/discuss/72157634650757777/) licence!)
* Invite active participants to [global e-mail list](https://groups.google.com/group/rails-girls-team)
* Send a thank you note to participants and ask for [feedback](https://railsgirls.com/feedback) (you can also create your own feedback form in your local language)
* Send a thank you note to coaches
* Send a thank you note for organizers
* Share the numbers of your event by filling out this short [Questionaire](https://railsgirls.wufoo.eu/forms/rails-girls-events-all-the-numbers/)
* Write a blogpost to the global blog by [submitting your story](https://railsgirls.tumblr.com/submit) - or ask one of the participants or coaches to write one!
