use super::device::*;
use super::*;

pub fn test() {
    let mut data = device().data.lock_irq();

    data.send_test();
}

impl E1000Data {
    fn send_test(&mut self) {
        // sample ARP broadcast packet
        let a = &[
            0xffu8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x21, 0xcc, 0xc0, 0x6b, 0x9b, 0x08, 0x06,
            0x00, 0x01, 0x08, 0x00, 0x06, 0x04, 0x00, 0x01, 0x00, 0x21, 0xcc, 0xc0, 0x6b, 0x9b,
            0xc0, 0xa8, 0x01, 0x71, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xa8, 0x01, 0x71,
        ];

        let p = self.alloc_packet(a.len());

        unsafe {
            a.as_ptr().copy_to(p.addr.0 as *mut u8, a.len());
        }

        self.send(p);
    }
}
