import { SESEventRecord } from 'aws-lambda'
import { reportError } from '@lib/lambda/reportError'
import { getEmailFromStorage } from './getEmailFromStorage'
import { formatEmail } from './formatEmail'
import { getEnvVar } from './getEnvVar'
import { forwardEmail } from './forwardEmail'

export const processSesEventRecord = async (record: SESEventRecord) => {
  console.log('Processing SES event record', { record })
  try {
    const {
      mail,
      receipt: { recipients },
    } = record.ses
    const message = await getEmailFromStorage(mail.messageId)
    if (recipients.length > 1) {
      throw new Error('Multiple recipients are not supported')
    }

    const [recipient] = recipients

    const formattedEmail = formatEmail({
      message,
      recipient,
      forwardTo: getEnvVar('FORWARD_TO'),
    })

    return forwardEmail({
      forwardTo: getEnvVar('FORWARD_TO'),
      message: formattedEmail,
      sendFrom: recipient,
    })
  } catch (err) {
    reportError(err, { record, msg: 'Error processing SES event record' })
  }
}
