// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const VaFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-va"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#fff" d="M320 0h320v480H320z" />
    <path fill="#ffe000" d="M0 0h320v480H0z" />
    <g stroke="#000" strokeLinejoin="round" strokeWidth={3.2}>
      <g
        fill="#ce9d09"
        strokeLinecap="round"
        transform="translate(123) scale(.192)"
      >
        <g id="va-a">
          <path
            fill="#fff"
            d="m1781 990.3 16.2 3.8 25.6 4.2 11.8 1.3-2 50s-2.9 33-7.8 48.9c-3.6 11.7-15.7 33.2-15.7 33.2l-7.7 11.7-45.4-39.3s7.8-11 10.6-17c3.5-7.5 7.7-23.8 7.7-23.8l4.4-26 2.4-32.7zm-57 151.5 41.4 36s-8.4 7.4-13.4 9.7a73.6 73.6 0 0 1-31.6 7.3 58 58 0 0 1-22.3-6.2c-15.7-7.2-33-14.7-43.2-28.7-3.6-5-5-11.6-4.9-17.7.2-7 6.3-19.9 6.3-19.9s2.4 8.7 5.1 12a49.2 49.2 0 0 0 17.6 12.4 42.5 42.5 0 0 0 36.2 1.1c3.3-1.3 8.9-6 8.9-6z"
          />
          <path
            fill="#fff"
            d="M1658.7 877.7s3.2 6.6 4.2 10.1c1.8 6 3 12.3 3 18.6a78.8 78.8 0 0 1-3.2 18.6 171 171 0 0 1-10.3 26.3c-2.6 5.4-6 10.3-8.6 15.8-4.1 8.7-7 18-10.6 26.8-3 7.5-6.9 14.7-9.2 22.4-3 10.2-4.5 20.9-6 31.4a230 230 0 0 0-2.3 27.5c0 11 .3 22 2.3 32.6 2 10.6 5 21.2 9.8 31a79.1 79.1 0 0 0 31.8 34.8c5.5 3.4 11.9 5.3 18 7.8 8.3 3.3 25.4 9.3 25.4 9.3s-23.6-11.6-31.8-21.4a68.4 68.4 0 0 1-12.8-28.9 112.3 112.3 0 0 1-1.2-36.6 196 196 0 0 1 9.2-38.3c4.2-13.2 10-25.9 15.4-38.6 3.9-9.3 8.3-18.2 12-27.5 4.5-11 8.8-22 12.4-33.2 2.1-6.9 4.8-13.7 5.4-20.9a76 76 0 0 0-2.2-23.4 89 89 0 0 0-11.8-30.6 41.1 41.1 0 0 0-14.8-13.2c-5.7-2.9-12.5-5.4-18.9-4.1-2 .4-5.2 3.7-5.2 3.7z"
          />
          <path
            fill="#fff"
            d="M1711.6 945.6s4.4-18 5.2-27.2c.6-7.9.2-15.8-.6-23.7-1-8.7-1.5-17.8-4.9-25.9a68.3 68.3 0 0 0-38.2-37 92.2 92.2 0 0 0-28-4.8 130 130 0 0 0-38 4c-4 1.4-11.7 5.7-11.7 5.7l30 49s9.3-5.6 14.5-7a54.7 54.7 0 0 1 17-1.2c5.8.4 11.7 1 17 3.3a57 57 0 0 1 17.6 13.3 73.9 73.9 0 0 1 15 22c3 7.5 3.5 16 4.6 24.2.3 1.7.5 5.3.5 5.3z"
          />
          <path d="M1717 906.7s-5.3-16.6-10.3-23.5a63.8 63.8 0 0 0-22.3-19.8c-9.4-4.7-31-6.2-31-6.2l11.4 21-20-.4-10.3-17.4-19.3 8.7-9.5-15.7 20.4-9.4-9.4-15.2 20.4-2 8.9 14.7s15.9 0 23.6 1.7a58.2 58.2 0 0 1 27.5 14.4 68 68 0 0 1 12 14.2c3 5.1 6.5 16.7 6.5 16.7z" />
          <path d="m1581.7 845 31.8 46.7m-18-54.8-15 8.8-14.3 11 31 47.1 13.7-10.6 14.1-8.2zm58.3 199 17.9-37 19.1 7.7 7.8-19-19-9 9.8-21.3-14-6.3-10.6 20.5-19.2-8-8.4 20 18.6 7.7-17.2 36.7zm143.2-11.1 18.1-.4v21l17.6.9-3 21.4-16.4-1s-2.7 12.5-5.1 18.4c-2.5 6.2-9.7 17.4-9.7 17.4l-19.4-4.8s7-11 9.7-17c2.4-5.4 5.7-16.6 5.7-16.6l-20-2.5 3.5-20.2 18.1 1.2z" />
        </g>
        <use xlinkHref="#va-a" transform="matrix(-1 0 0 1 3717.8 0)" />
        <path
          fill="#fff"
          d="m1756.7 735.6-27.5 29.4 17 51 9.6 35.8-27.7 25.8 50.7 71-17.4 19.9a12.2 12.2 0 0 0-2.1 8.6c.3 2.7 1.6 5.4 3.6 7.3 4.5 4.1 11.3 5.1 17.3 6.7 21 5.6 42.9 8 64.6 9.7 4.7.4 14 0 14 0s9.4.4 14.1 0c21.8-1.6 43.6-4.1 64.7-9.7 6-1.6 12.7-2.6 17.3-6.7a12.2 12.2 0 0 0 1.4-15.9l-16.3-36 51.8-55.4-19.7-17.9-.5-43.2 17-51-25.5-25.7-23-61.2s-4.7-17.1-8.8-25c-2.4-4.6-5.8-8.7-9.2-12.8-4-4.9-8-9.9-12.8-13.9a85 85 0 0 0-14.6-9c-5.5-2.9-11-6-16.9-7.5-6.1-1.5-19-1.5-19-1.5s-12.7 0-18.9 1.5c-6 1.6-11.4 4.6-16.8 7.5a85 85 0 0 0-14.6 9c-4.9 4-8.9 9-12.9 13.9-3.3 4-6.7 8.2-9.1 12.9-4.1 7.8-8.9 24.9-8.9 24.9z"
        />
        <path d="M1963.3 933.1s-3.2-2.8-5-4a64.5 64.5 0 0 0-12-6c-5.5-2.2-11.5-3.3-17.3-4.7a196.8 196.8 0 0 0-44.3-5.7c-8.6 0-25.8 1.3-25.8 1.3s-17.2-1.3-25.8-1.3a195.2 195.2 0 0 0-44.3 5.7c-5.9 1.4-11.8 2.5-17.4 4.7a64.5 64.5 0 0 0-12 6c-1.7 1.2-5 4-5 4m218.8-42.7s-5.2-5.2-8.6-5.9a9 9 0 0 0-6.6 1.5 13.1 13.1 0 0 0-4 15.2c.8 2 2 4.3 4.1 5.2 4.8 1.9 15.4-2 15.4-2zm5.1-3.6c5.8.2 8 3.2 9.5 6.5m-243.2-2.9-.3 14s10.5 3.9 15.3 2c2-.9 3.4-3.1 4.2-5.2a13.1 13.1 0 0 0-4-15.2 8.9 8.9 0 0 0-6.6-1.5c-3.5.7-8.6 6-8.6 6zm-5.2-3.6c-5.8.2-8 3.2-9.4 6.5m198.1 1.4-8.4-1m-130 1 8.4-1m76 .8c-2.9-.4-7.6-4.2-7.6-4.2m-22.8 4.2c2.8-.4 7.6-4.2 7.6-4.2m141-19.3s-4.3 3.3-7.4 3.8l-1.2.7s-2 5.7-3.6 8.2a44.7 44.7 0 0 1-6.5 6.2s-4.8-4.1-7.7-5c-2-.5-4.2-.5-6 .3a11 11 0 0 0-4.8 4.3c-1.4 2-2.7 4.6-2.6 7 .1 3 3.9 8.3 3.9 8.3l-2.6 4.5-3.7 2.3a90.3 90.3 0 0 1-19-7.5 18.9 18.9 0 0 1-4.4-9s4.5-2.7 5.6-5c1.2-2.5 1.6-6 .2-8.4-1.6-2.6-5.3-4-8.4-4a8.8 8.8 0 0 0-6.3 2.7c-1.6 1.8-3 4.5-2.5 7 .4 2.4 4.7 5.7 4.7 5.7s-1.8 4.6-3.8 5.5c-6 2.5-10 4-15.3 4.8a39 39 0 0 1-16.3 0 17 17 0 0 1-9-5.5c-.6-.9-.8-3-.8-3s6.5-1.7 9-3.7c2.6-2 5.3-4.6 5.9-7.8.5-3.2-1.2-6.6-3-9.2a18 18 0 0 0-7.6-6c-1.3-.6-4.3-.7-4.3-.7l-1 .9a14.6 14.6 0 0 1-4.7 3.8h-.1l-.2.1-1.1.6-.8.1-2.4.8s3.8 1.2 5 2.8c.6.9.9 2 1 3.3l.2 2c0 1.2-.3 2.3-.7 3.4a9 9 0 0 1-1.7 3.5c-.4.6-1 1-1.6 1.4 0 0 0 0 0 0l-.2.1c-1 .7-2.2 1.2-3.3 1.5-1.4.4-4.2.1-4.3.1 0 0 5.5 0 7.6-1.6l.2-.1a10.7 10.7 0 0 0 3.8-7.2v-3c-.3-1.6-1-3.2-2.2-4.2-2.4-2.1-9.3-2.4-9.4-2.4-.1 0-7 .3-9.4 2.4a7.6 7.6 0 0 0-2.3 4.2v3.1l.5 2.3c.7 2 1.8 3.7 3.3 4.9l.2.1c2.2 1.6 7.6 1.6 7.7 1.6-.1 0-3 .3-4.3 0-1.2-.4-2.4-.9-3.4-1.6h-.1v-.1c-.7-.4-1.2-.8-1.7-1.4a9 9 0 0 1-1.7-3.5c-.3-1-.6-2.2-.7-3.3l.2-2.1c.2-1.2.5-2.4 1.1-3.3 1.1-1.6 5-2.8 5-2.8l-2.5-.8-.7-.1-1.2-.6h-.1l-.1-.1a15 15 0 0 1-4.8-3.8l-1-.9s-3 0-4.2.7a18 18 0 0 0-7.6 6c-1.8 2.6-3.5 6-3 9.2.5 3.2 3.3 5.8 5.8 7.8 2.6 2 9 3.7 9 3.7s-.2 2.1-.8 3a17 17 0 0 1-9 5.5 39 39 0 0 1-16.3 0 59 59 0 0 1-15.2-4.8c-2-1-3.9-5.5-3.9-5.5s4.4-3.3 4.8-5.8c.4-2.4-1-5-2.6-6.9a8.8 8.8 0 0 0-6.2-2.8c-3.1 0-6.8 1.5-8.4 4.1-1.5 2.4-1 5.9.2 8.4 1 2.3 5.6 5 5.6 5a18.9 18.9 0 0 1-4.5 9 88.5 88.5 0 0 1-19 7.5l-3.6-2.3-2.6-4.5s3.7-5.2 3.8-8.2c.2-2.5-1.1-5-2.5-7.1a11.2 11.2 0 0 0-4.8-4.3c-1.8-.8-4-.8-6-.2-3 .8-7.7 4.9-7.7 4.9s-4.8-3.8-6.5-6.2a48.7 48.7 0 0 1-3.7-8.2l-1.2-.7c-3-.5-7.3-3.8-7.3-3.8l-4.4 1s-4.1 2.1-4.2 4c0 2.8 3.8 4 5.5 6 1.4 1.9 2.8 3.7 4.1 5.7 1.2 1.8 2.9 3.4 3.5 5.5.6 2.3-1 5 0 7.2 1.2 2.7 3.7 5.4 6.7 6 2.6.5 7.6-2.6 7.6-2.6l-.2 19.9 10.3 9.3 9.7 20.3-3.8 5.2 1.1 10c7.5-9.6 20.5-13.8 32.2-17.2 15.7-4.5 44.6-4.8 58-4.7l7.3.1s44.3-1.4 65.2 4.6c11.7 3.4 24.7 7.6 32.2 17.2l1.2-10-3.9-5.2 9.7-20.3 10.3-9.3-.1-19.9s5 3.1 7.6 2.6c3-.6 5.5-3.3 6.7-6 1-2.2-.7-4.9 0-7.2.6-2 2.2-3.7 3.4-5.5 1.3-2 2.7-3.8 4.2-5.6 1.7-2.1 5.5-3.3 5.4-6 0-2-4.1-4.2-4.1-4.2l-4.5-1zm-148.4-2.6c1 1 3 2.8 4.8 3.8l.2.1c.5.3 1.2.5 2 .7 2.8.8 7.8.3 8 .3h0c.1 0 5.1.5 8-.3l2-.7.2-.1c1.7-1 3.7-2.9 4.8-3.8.5-.7 1-1.4 1.3-2.2 1.1-2.7 1-6.1-.2-8.7-1.6-3-5.2-4.5-8.1-6.3-2.5-1.5-8-3.7-8-3.7a69 69 0 0 0-8 3.7c-3 1.8-6.6 3.3-8.1 6.3-1.3 2.6-1.4 6-.2 8.7.3.8.8 1.5 1.3 2.2z" />
        <path d="M1980.8 829.8s-11-5-16.6-6.9c-10.4-3.3-21.3-5.2-32-7.3-12.5-2.4-25.2-3-37.6-6-3.9-.8-7.5-2.7-11.5-3.5-5.4-1.1-11-2.9-16.4-1.7-3 .6-7.8 4.6-7.8 4.6s-4.9-4-7.8-4.6c-5.4-1.2-11.1.6-16.5 1.7-4 .8-7.6 2.7-11.4 3.6-12.4 2.9-25.2 3.5-37.7 6-10.7 2-21.5 3.9-32 7.2-5.6 1.8-16.5 6.9-16.5 6.9m197.4-45.1s5.4-2.9 7.3-5a9.5 9.5 0 0 0 2.7-5.3 9 9 0 0 0-2.3-6.5 9 9 0 0 0-6.2-2.2c-1.9 0-3.9.6-5.3 1.8a9.1 9.1 0 0 0-3 5.6c-.3 1.8.5 3.7 1.3 5.3a33 33 0 0 0 5.5 6.3zm-151 0s4.1-3.8 5.4-6.3a9.4 9.4 0 0 0 1.4-5.3 9.1 9.1 0 0 0-3-5.6 8.2 8.2 0 0 0-5.3-1.8 9 9 0 0 0-6.3 2.2 8.7 8.7 0 0 0-2.2 6.5c.1 2 1.3 3.7 2.6 5.2 2 2.2 7.3 5 7.3 5zm-41.2 18-11.9 15.6s0 4 .8 5.8a24 24 0 0 0 5.9 5.7l.8 21.4-11.3 19.6-1 .2 7.3 3.8 1 .1c4.4-.3 7-5.2 10.9-7.4 4.8-2.8 10-5 15.2-7.2a239.8 239.8 0 0 1 50-15.1 141.8 141.8 0 0 1 29.5-1.2c6.6.5 19.4 3.4 19.5 3.4 0 0 12.9-3 19.5-3.4a140.7 140.7 0 0 1 57.8 8.3 239.8 239.8 0 0 1 36.9 15.2c3.8 2.2 6.5 7 10.8 7.4h1l7.3-4-1-.1-11.3-19.6.9-21.4s4.6-3.3 5.8-5.7c1-1.7.8-5.8.8-5.8l-11.9-15.6s-6 6-9.9 7.3c-2 .6-4.4.6-6.5 0-2.5-.8-4.4-2.9-6.5-4.5a84 84 0 0 1-12.9-12.1 70.2 70.2 0 0 1-5.3-8.7s-12.9 10.1-20.6 12.1c-7.6 2-16 1.6-23.5-.6-1.9-.6-5-3-5-3a42 42 0 0 0-26.4-8 42 42 0 0 0-26.4 8s-3.2 2.4-5 3a44.8 44.8 0 0 1-23.6.6 82.4 82.4 0 0 1-20.6-12.1s-3.1 6-5.3 8.7a84 84 0 0 1-12.9 12.1c-2 1.6-4 3.7-6.5 4.5-2 .6-4.4.6-6.4 0a37 37 0 0 1-10-7.3z" />
        <path d="M1985.9 796.4s.4-5.7-.2-8.5a21 21 0 0 0-3.1-7c-1.5-2.3-5.7-6-5.7-6m-1.4 27.8s3.4.1 4.9-.6c2.6-1.3 6-6.3 6-6.3s6.7 4.6 10.4 4c1.8-.2 3.2-1.8 4.2-3.4a8 8 0 0 0 1.2-5.7c-.3-1.5-1.6-2.6-2.8-3.6-2.3-2-6.4-1.7-7.9-4.2-1.2-2-.5-4.9.2-7.1 1.4-4.8 4.7-8.7 7.5-12.8 1.7-2.6 5.3-4.4 5.6-7.5.2-1.6-2-4.6-2-4.6s-5.2-.1-7.7.6c-4 1.2-8.3 3-11.2 6.1-2.4 2.6-3 6.4-4.3 9.7-1 2.5-2.5 7.7-2.5 7.7s-6 0-8.7 1.2a17.1 17.1 0 0 0-8.7 7.7c-1.2 2.7-1 6.2 0 9 1.1 3 3.5 5.3 6.1 7 2.9 1.8 9.7 2.8 9.7 2.8zM1740.8 775s-4.1 3.6-5.6 5.8a21 21 0 0 0-3.2 7.1c-.6 2.8-.1 8.5-.1 8.5m-17-45.5s-2.2 3-2 4.6c.4 3.1 4 5 5.7 7.5 2.7 4.1 6 8 7.5 12.8.6 2.2 1.3 5 .1 7-1.4 2.6-5.6 2.4-7.8 4.3-1.2 1-2.5 2.1-2.9 3.6a8 8 0 0 0 1.2 5.7c1 1.6 2.5 3.2 4.3 3.4 3.6.6 10.3-4 10.3-4s3.5 5 6 6.3c1.5.7 5 .6 5 .6s6.8-1 9.7-2.9c2.5-1.6 5-4 6-6.8 1-2.9 1.3-6.4 0-9.1a16.8 16.8 0 0 0-8.7-7.7c-2.6-1.3-8.7-1.2-8.7-1.2s-1.4-5.2-2.4-7.7c-1.3-3.3-2-7.1-4.4-9.7a24.7 24.7 0 0 0-11.2-6.1c-2.5-.7-7.7-.6-7.7-.6zm135.6 14.3 8.4-2.4 8.3 2.4m-14.5 20s-6.5-5.8-7.7-9.8a8 8 0 0 1 .4-5.5c1.2-2.2 5.9-4.7 5.9-4.7s-7.1-3.4-9-6.6a8.6 8.6 0 0 1-.5-6.3 17 17 0 0 1 5.8-8c3.2-2.7 11.3-5.4 11.3-5.4s8 2.7 11.2 5.3a17 17 0 0 1 5.9 8.1c.5 2 .4 4.4-.6 6.3-1.9 3.2-9 6.6-9 6.6s4.8 2.5 6 4.7c.8 1.6.9 3.7.3 5.5-1.2 4-7.7 9.9-7.7 9.9l-6.1.4zm22.7-26.8s13.4 5.7 18 11.1c1.2 1.5 2.3 3.5 2.2 5.5-.5 7-10.3 18.2-10.3 18.2l-20-8.3h-12.9l-20 8.3s-9.8-11.3-10.2-18.2c-.2-2 1-4 2.2-5.5 4.5-5.4 18-11.1 18-11.1" />
        <path d="m1844.4 669.2 8-6.2 6.5.2-6.6-.2s-3.6-2.4-4.6-4.2a9 9 0 0 1-1-6c.5-2.7 2-5.5 4.4-6.9 2.3-1.3 7.8-.5 7.8-.5s5.5-.8 7.7.5c2.4 1.4 3.9 4.2 4.5 6.8.4 2 0 4.3-1 6-1 1.9-4.6 4.3-4.6 4.3l-6.7.2 6.5-.2 8 6.2m52.7 5.1-2.7 4.7m32.6-20-7.5 1m8.5 8.8-11.5.6m-1.5-13.8c1.5 1 4.2 2.9 4.6 4.6a10 10 0 0 1-3.1 9.2c-2.4 2-9.3 1.5-9.3 1.5m-181.7 33.6 17-4.2c8-2 16-4.2 24.2-5.7 9.3-1.6 18.7-2.8 28-3.5 11.8-.9 35.3-.6 35.3-.6s23.5-.3 35.2.6c9.4.7 18.7 1.9 28 3.5 8.2 1.5 16.2 3.8 24.3 5.7l17 4.2m-171.6-30.2 2.7 4.7m-32.7-20 7.5 1m-8.5 8.8 11.5.6m-6.4 16s12.5-3.2 18.8-4.5c7-1.4 14-2.8 21-3.7 8-1 16.1-1.5 24.3-2 9.6-.4 28.9-.3 28.9-.3s19.2 0 28.9.4a284.2 284.2 0 0 1 45.2 5.6c6.3 1.3 18.9 4.5 18.9 4.5M1781.6 671s-6.8.5-9.2-1.5c-2.5-2-4-6-3.2-9.2.7-2.4 5.6-5.2 5.6-5.2m63.1 74c-12 .8-24 1.5-35.8 3.7a220.2 220.2 0 0 0-36.2 9.7c-11.1 4-22.9 22.6-32 15.2-2-1.6.7-5 1.6-7.4a43 43 0 0 1 7.8-12.6c2.4-2.7 8-3 8.5-6.6.5-2.6-3.4-4-4.3-6.6a17 17 0 0 1-.5-10c1.2-4.1 6.5-6.2 7.7-10.3 1-3.6-2.5-7.8-.9-11.2 2.2-4.2 11.4-2.7 12-7.4.4-2.3-3.8-3-4.5-5.1-.6-1.6.3-3.3.3-5 0-2.1.4-4.5-.6-6.5-.9-1.7-3.7-2.1-4.3-4a5.5 5.5 0 0 1 1.1-5.4c1-1 3.7.4 4.3-.9 1.4-2.6-2.5-5.3-3.7-8-1.4-3.2-3.2-6.3-4-9.7-.6-2.7-3-7-.6-8.3 2.8-1.6 5.5 3.2 8 5.1 3.4 2.5 7.2 4.8 9.5 8.3 1.7 2.5.7 6.5 3 8.6 2.6 2.5 7.7.5 10.4 2.9 2.4 2 4.5 5.5 3.8 8.5-.7 3-7.6 2.9-7 5.8.9 3.4 7 3.2 10.4 2.5 2-.3 3.5-2.2 5.1-3.4 1.4-1 2.4-2.2 4-2.8 1.6-.8 5.3-1 5.3-1l-2.1-.5s-3.2-2.5-3.5-4.3a6 6 0 0 1 1.6-5 7.7 7.7 0 0 1 5.5-2.2c1.7 0 3.5.7 4.6 1.9a6.3 6.3 0 0 1 1.7 4.8 6 6 0 0 1-2.3 3.7 13 13 0 0 1-4.6 1.5l2.3.6 6.1 8.5 26.6-1.5s3.3-3.3 2.6-5.2c-.7-1.9-2.5-2.6-5.7-2.5-8.5.4-10.3-6.8-10-12 .3-4.4 5.5-7.3 9.5-9 4-1.5 10.8 3.7 12.6-.1 1.5-3.3-5.8-5-7-8.5-.5-1.5-.5-3.4.2-4.8 1.8-3.6 5.7-6 9.4-7.7 1.6-.7 5-.8 5-.8s3.6.1 5.1.8c3.7 1.7 7.6 4.1 9.4 7.7.7 1.4.7 3.3.2 4.8-1.1 3.5-8.5 5.2-7 8.5 1.8 3.8 8.7-1.4 12.6.2 4 1.6 9.2 4.5 9.5 8.9.3 5.2-1.4 12.4-10 12-3.2-.1-5 .6-5.7 2.5-.6 1.9 2.7 5.2 2.7 5.2l26.5 1.5 6.1-8.5 2.3-.6s-3.3-.5-4.5-1.5a6 6 0 0 1-2.3-3.7c-.2-1.7.5-3.6 1.6-4.8 1.1-1.2 3-1.9 4.6-1.9 2 0 4.1.7 5.5 2.2 1.2 1.2 2 3.2 1.6 5-.3 1.8-3.5 4.3-3.5 4.3l-2.1.5s3.7.2 5.4 1c1.5.6 2.6 1.9 3.9 2.8 1.7 1.2 3.1 3 5.1 3.4 3.5.7 9.6 1 10.3-2.5.7-3-6.1-2.9-6.8-5.8-.7-3 1.3-6.5 3.7-8.5 2.7-2.4 7.9-.4 10.5-2.9 2.2-2 1.3-6 3-8.6 2.3-3.5 6-5.8 9.4-8.3 2.5-1.9 5.3-6.7 8-5.1 2.4 1.4 0 5.6-.6 8.3-.8 3.4-2.6 6.5-4 9.7-1.2 2.7-5 5.4-3.7 8 .7 1.3 3.3-.2 4.3.9a5.5 5.5 0 0 1 1.1 5.4c-.6 1.9-3.4 2.3-4.3 4-1 2-.5 4.4-.5 6.6 0 1.6.8 3.3.3 4.9-.8 2.1-5 2.8-4.6 5.1.7 4.7 9.9 3.2 12 7.4 1.7 3.4-1.9 7.6-.9 11.2 1.2 4.1 6.5 6.2 7.8 10.3 1 3.2.4 6.8-.6 10-.8 2.5-4.7 4-4.3 6.6.6 3.6 6.2 3.9 8.6 6.6 3.3 3.6 5.8 8 7.7 12.6 1 2.3 3.7 5.8 1.7 7.4-9.2 7.4-21-11.1-32-15.2a220.2 220.2 0 0 0-72-13.4c-7-.4-21-.4-21-.4s-14 0-21 .4zm31.1-133.7-10.1.1-10.2-.1m17-33.9c2.6-5.6-2-9.7-6.8-13.8-4.8 4-9.4 8.2-6.8 13.8m14.1 46.8c3.9.2 8.6 4.2 11.6 1.7 1.3-1.2.7-3.7 0-5.3-1.6-3.8-8.4-4.7-8.7-8.8-.3-3.5 5.1-5.2 6.3-8.5.5-1.7.6-3.7 0-5.3-2.8-6.6-14.5-7-16.6-13.7-.9-3 6-6.5 6.8-6.9 4.4-1.9 9.7 2.7 14 .8 3-1.2 6.1-4.1 6-7.3 0-3.4-3.6-6.3-6.8-7.7-6.1-2.6-16.2 6-20 .5-3.4-5.1 8.7-11.1 7-17-.7-2.9-7-5.3-7-5.3s-6.1 2.4-6.9 5.3c-1.6 5.9 10.5 11.9 7 17-3.7 5.5-13.8-3.1-20-.5-3.1 1.4-6.8 4.3-6.8 7.7 0 3.2 3.1 6 6 7.3 4.3 1.9 9.7-2.7 14-.8.9.4 7.7 4 6.8 6.9-2 6.7-13.7 7-16.5 13.7a7.8 7.8 0 0 0 0 5.3c1.1 3.3 6.6 5 6.3 8.5-.3 4.1-7.2 5-8.7 8.8-.7 1.6-1.4 4.1 0 5.3 3 2.5 7.7-1.5 11.6-1.7 2.4-.2 7.3 0 7.3 0s4.8-.2 7.3 0z" />
        <path
          fill="none"
          d="M1953.7 953.5s-7.1-3-10.8-4.3a258 258 0 0 0-20-6.5c-6.6-1.8-13.2-3.7-20-4.5-14.6-1.6-44-.2-44-.2s-29.4-1.4-44 .2c-6.8.8-13.5 2.7-20 4.5a258 258 0 0 0-30.9 10.8M1966 731s-12-4.8-18.1-6.9c-5.1-1.7-10.2-3.5-15.5-4.8-6.4-1.6-12.9-2.6-19.4-3.5a387.1 387.1 0 0 0-54.1-3.4s-17.2.1-25.8.6a376.5 376.5 0 0 0-47.8 6.3c-5.2 1.3-10.3 3-15.4 4.8-6.1 2.1-18 6.9-18 6.9m-14.2 120.4s17.5-6 26.4-8.7c9.1-2.8 18.2-6 27.5-8 11.2-2.5 22.6-3.7 34-5 11-1.1 33.3-2.3 33.3-2.3s22.2 1.2 33.3 2.4c11.3 1.2 22.8 2.4 34 4.8 9.3 2 18.3 5.3 27.5 8.1l26.4 8.7"
        />
      </g>
      <g fill="#ccc" transform="translate(123) scale(.192)">
        <g id="va-b">
          <path d="m1533.3 904 101.2 86.8s-5.2 11.2-7.3 17a142.6 142.6 0 0 0-9.3 41l-118-108c1.7-24.7 15.6-33.5 33.4-36.8z" />
          <path d="m1519 958.2-24.3 27.2 15.2 14.6-23.5 22.8-15.2-15.1-25.5 27.2-.2 33.7 58 45.5 20.1-14.9-1.1-32.3 15.4 8.6 15.5-9.4.8 29.1-12.6-9.1-13.7 18-1.4 32 43.7 39 53-47.1-4-14.1-2.2-12.7-1.3-25.1 2-27.5z" />
          <path d="m1494.7 985.4-.6 30 15.6-15.3z" />
          <path
            fill="none"
            d="m1572 1140.4-1.9 34.3m-18.6-139.7.6 31.8m-14.8-17.3.9 25.8m-14.5-36.3.6 29m-21.4 15.2.3 30.6m24.7-9.7 44 37 45.1-39.6m-171-66.9 57.6 49.2 18.9-16.9-15-12.6 16.7-15.7 12.9 11.1 14.5-14.8 19 18.3-17.2 13.4 16 14.6-15.2 14"
          />
          <path d="m1901.3 1229.3 48.7 44.6 10.7 31.5-62.6-6.7-35.7-35.3-38-35.2-164-142.1s3.5-13.1 5.6-19.5c3.2-9.3 6.9-18.4 10.6-27.5l3-6.8 183 162.3z" />
          <path d="M1942.7 1236c27 38 72.7 73.7 86.5 90.9 13.9 17.2 22.8 33.5 2.6 55.5s-43 9.5-61.1-2.6c-18.1-12-49.6-51.3-94.8-81.3z" />
          <path d="m1926.7 1299.8-35.2-16m41-38.2c2.4 8 .5 16.8 3.6 24.4 3 7.6 14 20 14 20s-7 1-10.3 2.2c-4.7 1.9-12 2.7-13.1 7.7-1 4.3 4 8 7 11.2 3 3.1 6.7 5.4 10.4 7.6 6.1 3.6 12.4 7.6 19.4 8.9 8.7 1.6 25.1-10.8 26.6-2 .6 3.6-7.4 1.3-10.7 3-7.8 3.8-11.6 12-4.8 17.8 4.4 3.7 11.3 2.4 17 2.9 5.5.4 11.7-2.8 16.5 0 5.6 3.2 12.7 11 9.7 16.8-3 6-14.5 5.8-20 2-4-3-2.9-9.5-3.5-14.4v-4.4" />
          <circle cx={2154.7} cy={1480.1} r={129.7} />
          <path
            fill="#fff"
            d="M2106.1 1485.7a40.5 40.5 0 1 0 40.5 40.4l14-.6a40.5 40.5 0 1 0 40.5-40.5l.6-7.9a40.5 40.5 0 1 0-40.5-40.5l-14-1.2a40.5 40.5 0 1 0-40.5 40.5z"
          />
          <circle cx={2154.7} cy={1446.1} r={14.6} />
          <circle cx={2189.4} cy={1480.1} r={14.6} />
          <circle cx={2155.3} cy={1511.2} r={14.6} />
          <circle cx={2119.3} cy={1480.1} r={14.6} />
          <path
            fill="#fff"
            d="M2152.2 1558.4c-5.3 11-12.6 16-21.9 22a63.2 63.2 0 0 0 43.8 0 54 54 0 0 1-21.9-22zm-76.5-80.2c-11-5.3-16-12.6-22-22a63.2 63.2 0 0 0 0 44 53 53 0 0 1 22-22zm159.2 3.6c11-5.3 16-12.6 22-21.9a63.2 63.2 0 0 1 0 43.9c-4.7-9.3-12-16-22-22zm-78.4-80.8c-5.3-11-12.6-16-22-22a63.2 63.2 0 0 1 44 0 53 53 0 0 0-22 22z"
          />
        </g>
        <g fill="#ce9d09">
          <g id="va-c">
            <path d="M1533.5 903.8s.7-5 0-7.4a22.6 22.6 0 0 0-6.6-10.2 19.6 19.6 0 0 0-9.2-4.6 24.5 24.5 0 0 0-17.7 4.2l-15 6.2-5.5 17.7s-3.2 5.6-4 8.7a23 23 0 0 0-.5 10.1c1 3.9 3.2 7.6 6.3 10.2a19 19 0 0 0 10.3 4 28 28 0 0 0 8.3-1.9c1.6-18.6 9.9-32.8 33.5-36.9z" />
            <path d="m1500.3 885.6-38.8-17-3.1 3 21 38.2s6-8.7 9.4-12.7c3.6-4.1 11.5-11.5 11.5-11.5z" />
            <circle cx={1457.3} cy={865.3} r={16} />
            <path d="M1566.2 932.3c3.4 28 7.3 55.9 16 83.8l31 28.5c-6.5-29.3-18.4-58.5-18.3-87.7z" />
            <path d="m1613 972.4-85.4-6.4 27.2 25 78 3.3 1.2-4zm105.4 94.6a61.9 61.9 0 0 0-37.9 37c-6.4.7-12.3.7-14.4-4a58.5 58.5 0 0 1 35.7-47.8c15-2.8 12.2 8.9 16.6 14.7zm27.5 25.8a61.9 61.9 0 0 0-37.9 37.2c-6.3.5-12.3.6-14.4-4.1a58.5 58.5 0 0 1 35.8-47.8c15-2.8 12.1 8.9 16.5 14.7zm312.8 261.9a72 72 0 0 0-15.1 1.5c.3 8-3 16.6-11.8 26.2a33.4 33.4 0 0 1-23.7 12s-2.8 17.7 2.6 23.3c6.3 6.6 27.1 3.9 27.1 3.9l1.8-1.1a129.7 129.7 0 0 1 31.9-39.8l.3-1.3s3-16.5-2.1-21.5c-2.4-2.3-6.6-3-11 0z" />
            <circle cx={2254.5} cy={1375.4} r={17.7} />
            <circle cx={2260.6} cy={1580} r={17.7} />
            <circle cx={2062.1} cy={1591.6} r={17.7} />
          </g>
        </g>
      </g>
      <g fill="#ce9d09" transform="matrix(-.192 0 0 .192 837 0)">
        <use xlinkHref="#va-b" />
        <use xlinkHref="#va-c" fill="#ccc" />
      </g>
      <g fill="#fa0204" transform="translate(123) scale(.192)">
        <path
          id="va-d"
          d="M1869.2 1175.8c0 5.4-4.5 7.4-13.3 7.4-8.7 0-12.7-2.5-12.7-7.9s4-6.7 12.7-6.7c8.8 0 13.3 1.8 13.3 7.2z"
        />
        <use xlinkHref="#va-d" x={6.4} y={14.3} />
        <path d="M1877.3 1208.7c-1.7 5-6.7 5.6-15 2.7-8.2-3-11.2-6.6-9.4-11.7 1.8-5 6-5 14.3-2.1 8.2 2.9 12 6 10.1 11z" />
        <path
          id="va-e"
          d="M1877.5 1222.5c-1 5.3-5.9 6.4-14.4 4.7-8.6-1.7-12-5-11-10.3 1-5.3 5.3-5.8 13.8-4 8.6 1.7 12.7 4.3 11.6 9.6z"
        />
        <use xlinkHref="#va-e" x={4} y={16.1} />
        <path d="M1921.7 1216.2c-2.6-.7-2.3-5.3-1.6-7.9 1.2-4 8.4-9.1 8.4-9.1s1.8 5.6 1 8.2c-1.2 3.7-4 9.8-7.8 8.8z" />
        <path d="M1912.3 1224.4c-2.8-.6-3.2-5.5-2.5-8.3 1.2-4.3 9.7-9.3 9.7-9.3s1.5 6 .5 8.8c-1.3 3.7-3.9 9.7-7.7 8.8zm-10.8 15.6c-4.3-1.1-3.8-8.8-2.6-13 1-3.6 3.7-9.2 7.2-8.3 4.2 1 4.2 8.3 3.1 12.5-.9 3.8-4 9.8-7.7 8.8z" />
        <path d="M1888.7 1252.2c-4.2-1-6-7.6-5.1-11.9.9-4.4 5.3-10.4 9.7-9.4 4.5 1 6 8.3 5 12.8-1 4.1-5.4 9.4-9.6 8.5zm-2.2 7.4c-1 5-7.5 6.8-11.5 5.5-4.1-1.3-9.5-7.1-8.4-12.5 1.2-5.4 8.2-6.8 12.3-5.2 3.9 1.5 8.7 7.2 7.6 12.2zm-85-49.3s5.1 2.5 7.3 4.8c2.3 2.4 5.1 3.3 3.7 6.9-1.4 3.6-5.8 2.4-8.1-.2-2.1-2.3-3-11.5-3-11.5zm25.3 8.7c5.3 1.1 5.1 7.2 2.5 11-2.8 3.8-10.9 8.9-16.4 7.8-5.5-1.1-4.8-7.8-1.8-11.7 2.9-3.6 10.6-8 15.7-7z" />
        <path
          id="va-f"
          d="M1844.3 1230.5c4.8 2.2 3.4 8.1 0 11.2-3.6 3.2-12.6 6.3-17.7 4-5.2-2.2-3-8.6.8-11.7 3.6-3 12-5.6 16.9-3.5z"
        />
        <use xlinkHref="#va-f" x={14} y={10.7} />
        <path d="M1863 1250.7c4.8.7 6 7.4 4.6 11.7-1.6 4.5-7.5 10.6-12.5 9.8-5.1-.8-6-8-4.2-12.6 1.6-4.2 7.3-9.7 12-9z" />
        <path d="M1875.1 1265.3c4 2.3 3 9.6.4 13.6-2.7 4.1-9.8 8.6-14 6.2-4.2-2.5-2.7-10.3.2-14.4 2.8-3.8 9.5-7.6 13.4-5.4zm-86.1-39.9c4.3-.3 7.2 6 7.1 10.6 0 4.9-3.3 12.4-7.7 12.8-4.5.4-7.3-6.7-7-11.6.1-4.6 3.4-11.4 7.6-11.8z" />
        <path d="M1803 1237.7c4 .9 5 7.8 3.5 12.2-1.6 4.6-7 10.8-11.3 9.8-4.4-1-5-8.6-3.2-13.2 1.6-4.3 6.8-9.8 11-8.9z" />
        <path d="M1815.8 1246.2c5 1.2 6 9.8 4.2 15.3-1.8 5.7-8.2 13.4-13.4 12.2-5.2-1.3-5.8-10.7-3.7-16.5 1.9-5.3 8-12.1 12.9-11z" />
        <path d="M1826.2 1256.8c5-.6 9 7 9.3 12.8.3 6-3 15.4-8.2 16-5.3.7-9.2-7.9-9.3-14-.1-5.6 3.3-14.2 8.2-14.8z" />
        <path
          id="va-g"
          d="M1838.6 1265.7c4.5-.6 8.2 5.8 8.4 10.5.3 5-2.7 12.8-7.4 13.4-4.9.6-8.4-6.6-8.5-11.6 0-4.7 3-11.8 7.5-12.3z"
        />
        <use xlinkHref="#va-g" x={12.8} y={10.4} />
        <path
          id="va-h"
          d="M1929.3 1250.9c-3.3 2.8-9.7.3-12.6-2.9-3.1-3.3-5.3-10.5-1.8-13.5 3.4-3 10.2.2 13.2 3.6 2.7 3.3 4.4 10 1.2 12.8z"
        />
        <use xlinkHref="#va-h" x={-7} y={12.8} />
        <use xlinkHref="#va-h" x={-19.5} y={23.5} />
        <path d="M1905.2 1281.2c-1.1 4.1-8 5.6-12.1 4.5-4.4-1-10.2-5.8-9-10.2 1.3-4.4 8.7-5.6 13-4.3 4.2 1.2 9.2 5.9 8 10z" />
        <path d="M1887.2 1278.2c3.6 2.5 2.8 10.5.4 14.9-2.6 4.5-9 9.5-12.9 6.8-3.9-2.7-2.5-11.3.2-15.8 2.5-4.2 8.7-8.4 12.3-6z" />
        <path d="M1869.6 1287.5c4 2.4 3 9.6.4 13.6-2.7 4.1-9.8 8.6-14 6.2-4.2-2.5-2.7-10.3.2-14.4 2.8-3.8 9.5-7.6 13.4-5.4z" />
        <path
          id="va-i"
          d="M1831.3 1313c-3.4 3.1-.7 11.2 2.8 15.2 3.7 4.2 11.8 8.1 15.4 4.7 3.5-3.4.3-12-3.6-16.1-3.7-3.9-11.2-7-14.6-3.9z"
        />
        <use xlinkHref="#va-i" x={-7.3} y={13.8} />
        <path
          id="va-j"
          d="M1820.8 1339.5c-4.3 1.8-4.8 10.2-3 15.3 1.8 5.3 7.9 11.9 12.5 10 4.6-1.8 4.7-11 2.6-16.3-2-4.9-7.8-10.7-12-9z"
        />
        <use xlinkHref="#va-j" x={-10.5} y={14.9} />
        <path
          id="va-k"
          d="M1802.7 1371c-4.6 1-6.5 9.3-5.5 14.6 1 5.5 6 13 10.8 11.9 4.8-1.1 6.4-10.2 5.2-15.7-1.2-5.1-6-11.8-10.5-10.8z"
        />
        <use xlinkHref="#va-k" x={-10.1} y={15.9} />
        <path
          id="va-l"
          d="M1784 1403.3c-4.6.2-8 8-8 13.3 0 5.6 3.5 13.9 8.4 13.7 5-.2 8.2-8.8 8-14.5-.2-5.3-3.7-12.7-8.3-12.5z"
        />
        <use xlinkHref="#va-l" x={-10.3} y={19.2} />
        <use xlinkHref="#va-l" x={-22.4} y={37} />
        <use xlinkHref="#va-l" x={-34.9} y={52.3} />
        <use xlinkHref="#va-l" x={-47.8} y={66.5} />
        <use xlinkHref="#va-l" x={-62} y={78.1} />
        <use xlinkHref="#va-l" x={-75.6} y={90.6} />
        <path d="m1692.8 1500.2-5.3 20.6s3 7.3 6 7c5.5-.6 7-9 8-14.5 1-8.4-8.7-13.1-8.7-13.1zm324.4 13.1c1.6 6 15.3 11.3 15.3 11.3l-6.7-27.8c-5.7.2-9.5 12.4-8.6 16.4z" />
        <path d="M2016 1491c-4.3-1.8-10.5 4-12.7 8.9-2.3 5.1-2.4 14 2.2 15.9 4.6 1.8 11-4.8 13.1-10 2-5 1.7-13.1-2.6-14.9z" />
        <path
          id="va-m"
          d="M2000.8 1478.7c-4.7-.3-8.7 7.2-9.2 12.5-.5 5.6 2.2 14.1 7.1 14.4 5 .2 9-8 9.3-13.7.3-5.3-2.6-13-7.2-13.2z"
        />
        <use xlinkHref="#va-m" x={-13.4} y={-13.7} />
        <use xlinkHref="#va-m" x={-25.9} y={-29.2} />
        <use xlinkHref="#va-m" x={-38.7} y={-42.3} />
        <use xlinkHref="#va-m" x={-49} y={-60.3} />
        <use xlinkHref="#va-m" x={-60.3} y={-76.4} />
        <use xlinkHref="#va-m" x={-70.6} y={-93.5} />
        <use xlinkHref="#va-m" x={-79.8} y={-113.3} />
        <use xlinkHref="#va-m" x={-89.8} y={-131.2} />
        <use xlinkHref="#va-m" x={-98} y={-152.5} />
        <path d="M1883.8 1304.6s-1.6 26.6 8 28.3c6.1 1.1 10.9-14.9 10.9-14.9z" />
        <path
          id="va-n"
          d="M1862 1610.8c-2.9 3.6 1 11.2 5 14.7 4.3 3.6 12.9 6.2 15.9 2.3 3-3.9-1.5-11.9-6-15.4-4-3.2-12-5.3-14.9-1.6z"
        />
        <use xlinkHref="#va-n" x={18.3} y={-2.2} />
        <use xlinkHref="#va-n" x={36.8} y={-5.8} />
        <path
          id="va-o"
          d="M1916.2 1603.8c-2.3 4 2.6 11 7.1 13.8 4.8 3 13.7 4.3 16 0 2.5-4.4-3.2-11.6-8.1-14.4-4.6-2.6-12.8-3.4-15 .6z"
        />
        <use xlinkHref="#va-o" x={20} y={-3.2} />
        <path
          id="va-p"
          d="M1953.5 1595.4c-2 4.3 3.6 10.7 8.4 13.1 5 2.5 14 3 16-1.5s-4.4-11.2-9.5-13.5c-4.8-2.2-13-2.3-15 2z"
        />
        <use xlinkHref="#va-p" x={18.9} y={-5.6} />
        <path
          id="va-q"
          d="M1991.3 1583.9c-1.7 4.4 4.2 10.5 9.1 12.5 5.2 2.2 14.2 2.2 15.9-2.4 1.7-4.7-5-11-10.3-13-5-1.8-13.1-1.4-14.7 2.9z"
        />
        <use xlinkHref="#va-q" x={19.2} y={-6.2} />
        <use xlinkHref="#va-q" x={37.7} y={-14} />
        <use xlinkHref="#va-q" x={57.5} y={-22.2} />
        <use xlinkHref="#va-q" x={77.5} y={-28.6} />
        <use xlinkHref="#va-q" x={79.9} y={-44.3} />
        <path d="M2066.7 1534.9s13.6 2 14.8-2.9c1.6-6.5-15.4-12.7-15.4-12.7z" />
        <path
          id="va-r"
          d="M1701.6 1575.6c-4 2.5-3 10.9-.4 15.5 2.7 4.9 9.8 10.4 14 7.8 4.2-2.6 2.8-11.7-.2-16.5-2.7-4.5-9.4-9.2-13.4-6.8z"
        />
        <use xlinkHref="#va-r" x={18.9} y={7.8} />
        <use xlinkHref="#va-r" x={37} y={10.6} />
        <use xlinkHref="#va-r" x={56.8} y={15.5} />
        <use xlinkHref="#va-r" x={74.7} y={18.1} />
        <use xlinkHref="#va-r" x={92.3} y={21.7} />
        <use xlinkHref="#va-r" x={110.4} y={26.7} />
        <use xlinkHref="#va-r" x={128.3} y={29.9} />
        <use xlinkHref="#va-r" x={146.6} y={32.7} />
        <path d="M1648.2 1517.5c-4.2-2.1-11 3-13.6 7.6-2.7 5-3.8 13.8.6 16 4.4 2.3 11.5-3.6 14-8.6 2.5-4.7 3-12.9-1-15z" />
        <path d="M1642 1534.4c-4.4-1.6-10.4 4.4-12.4 9.4-2 5.2-2 14.1 2.7 15.8 4.7 1.6 10.9-5.2 12.8-10.5 1.8-5 1.3-13.1-3-14.7z" />
        <path d="M1647.7 1550c-4.5-1.2-10 5.3-11.5 10.4-1.6 5.4-.6 14.3 4.2 15.5 4.8 1.2 10.3-6.1 11.8-11.6 1.3-5.1 0-13.2-4.5-14.4z" />
        <path d="M1662.4 1556.3c-4.5-1.3-10.2 5-11.9 10-1.7 5.4-1 14.3 3.7 15.7 4.7 1.4 10.5-5.8 12.1-11.2 1.5-5 .5-13.2-4-14.5z" />
        <path
          id="va-s"
          d="M1672 1558.8c-4.6 1.1-6.3 9.4-5.2 14.7 1.1 5.5 6.2 12.8 11 11.6 4.8-1.2 6.2-10.3 4.8-15.8-1.2-5-6.2-11.6-10.7-10.5z"
        />
        <use xlinkHref="#va-s" x={16.8} y={6.2} />
        <use xlinkHref="#va-i" x={8.6} y={-11.2} />
        <use xlinkHref="#va-i" x={4.7} y={6.5} />
        <use xlinkHref="#va-i" x={4.9} y={26.7} />
        <use xlinkHref="#va-i" x={4.7} y={47.9} />
        <use xlinkHref="#va-i" x={5.6} y={68.6} />
        <use xlinkHref="#va-i" x={2.2} y={87.7} />
        <use xlinkHref="#va-i" x={4.7} y={109.1} />
        <use xlinkHref="#va-i" x={2.2} y={126.4} />
        <use xlinkHref="#va-i" x={4.7} y={143.5} />
        <use xlinkHref="#va-i" x={4.7} y={163.9} />
        <use xlinkHref="#va-i" x={3.4} y={183.9} />
        <use xlinkHref="#va-i" x={3.7} y={203.1} />
        <use xlinkHref="#va-i" x={4.4} y={223.5} />
        <use xlinkHref="#va-i" x={4.4} y={243.3} />
        <use xlinkHref="#va-i" x={3.7} y={263.1} />
        <use xlinkHref="#va-i" x={2.5} y={283.2} />
        <use xlinkHref="#va-i" x={2.5} y={305.1} />
        <use xlinkHref="#va-i" x={1.9} y={327.9} />
        <use xlinkHref="#va-i" x={1.9} y={349.3} />
        <use xlinkHref="#va-i" x={1.9} y={369} />
        <use xlinkHref="#va-i" x={1.3} y={391.3} />
        <path
          id="va-t"
          d="M1882.2 1303.2c2.5 3.7-1.3 10.8-5.1 14-4 3.2-12 5.4-14.5 1.5-2.6-4 1.9-11.4 6-14.6 4-3 11.2-4.6 13.6-1z"
        />
        <use xlinkHref="#va-t" x={2.7} y={16.1} />
        <use xlinkHref="#va-t" x={2.4} y={34.1} />
        <use xlinkHref="#va-t" x={2.1} y={52.4} />
        <use xlinkHref="#va-t" x={1.8} y={69.1} />
        <use xlinkHref="#va-t" x={2.7} y={87.1} />
        <use xlinkHref="#va-t" x={1.5} y={104.4} />
        <path d="M1883.3 1426c2.6 3.9-1.5 11.3-5.7 14.5-4.5 3.4-13.2 5.7-16 1.6-2.9-4 2-11.8 6.6-15 4.4-3.1 12.4-4.8 15-1z" />
        <path
          id="va-u"
          d="M1882 1443.6c3.5 3.2.8 11.3-2.7 15.3-3.7 4.2-11.8 8-15.3 4.7-3.6-3.5-.3-12 3.6-16.2 3.6-3.8 11.1-7 14.5-3.8z"
        />
        <use xlinkHref="#va-u" x={0.6} y={20.4} />
        <use xlinkHref="#va-u" x={0.9} y={40.5} />
        <use xlinkHref="#va-u" x={0.3} y={62.1} />
        <use xlinkHref="#va-u" x={0.9} y={82.2} />
        <use xlinkHref="#va-u" x={0.3} y={102.6} />
        <use xlinkHref="#va-u" x={0.6} y={123} />
        <use xlinkHref="#va-u" x={0.6} y={143.7} />
        <use xlinkHref="#va-u" x={-0.3} y={164.4} />
        <use xlinkHref="#va-u" x={0.9} y={183.3} />
        <use xlinkHref="#va-u" x={0.9} y={203.1} />
        <use xlinkHref="#va-u" x={0.3} y={224.4} />
        <use xlinkHref="#va-u" x={0.3} y={245.4} />
      </g>
      <g transform="translate(123) scale(.192)">
        <path fill="#fa0204" d="M1849.6 1848.3a77 77 0 0 0 48.3.4l-17.5-28" />
        <path
          fill="#ce9d09"
          d="m1888.3 1776.2-31.7-8.2s.4-35.2 20.4-32.1c16.6 2.5 12 40.3 11.3 40.3z"
        />
        <circle cx={1872.9} cy={1723} r={12.9} fill="#ce9d09" />
        <path
          fill="#fa0204"
          d="M1885.4 1791.9c7 17.8 11.3 33.2 4.7 53.3m7.6 3.5c-10.2-8.3-36.6-5.9-48-.4-4.4 0-16.4-83.2 25.7-81.2 38.8 2 25 82 22.3 81.6z"
        />
      </g>
      <g transform="translate(123) scale(.192)">
        <path fill="#fa0204" d="M1815.2 1866.3a47 47 0 0 0 54.2.5l-40.2-42" />
        <circle cx={1843.4} cy={1738.3} r={12.9} fill="#ce9d09" />
        <path
          fill="#ce9d09"
          d="m1859.3 1780-32.7-.6s-4.2-26.6 16.2-27.8c16.9-1 17.2 28.4 16.5 28.4z"
        />
        <path
          fill="#fa0204"
          d="M1843.6 1860.7c-6.3-13.9-6.9-31-5.2-49.5m-9.4 50.4c-7.7-13.2-9.1-30-3-51.2m43.4 56.6c-5-6.2-40.3-8.8-54.1-.4-5 0-18.6-93.8 29-91.5 43.6 2.1 28 92.3 25 91.9z"
        />
      </g>
    </g>
  </svg>
)

export default VaFlag
