// This file is generated by @lib/ui/country/codegen/generateFlags.ts
import { SvgIconProps } from '@lib/ui/icons/SvgIconProps'

const SvFlag = (props: SvgIconProps) => (
  <svg
    width="1em"
    height="0.75em"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    id="flag-icons-sv"
    viewBox="0 0 640 480"
    {...props}
  >
    <path fill="#0f47af" d="M0 0h640v480H0z" />
    <path fill="#fff" d="M0 160h640v160H0z" />
    <g transform="matrix(.8 0 0 .8 -92.7 0)">
      <g fill="#fff" fillRule="evenodd" stroke="#000" strokeWidth={0.3}>
        <path d="M515 353.4c1.5 0 3.2 0 10.1-1.7 7-1.7 12.7-5.9 14-6.5 1.4-.6 3.3-.4 3.3-.4a8.4 8.4 0 0 0-5.8-2.8c-3 0-1.9 0-4.4 1.1-2.6 1-8 4.3-17 4.3h-.1c-9 0-14.7-3.2-17.2-4.3-2.6-1-1.4-1-4.4-1-3 0-5.1 1.9-6 2.7 0 0 2-.2 3.4.4 1.4.6 7.1 4.8 14 6.5 7 1.7 8.6 1.7 10.1 1.7z" />
        <path d="M488.4 347.4c.7-.4-.2-1.6-.2-1.6l2.7-.6c-1.3-.6-3.3-.4-3.3-.4-.5.4-.4.9-.5 1.3 0 .4 0 1 .2 1.3.3.3 1 0 1 0z" />
        <path d="m491 345.2-2.8.6s.9 1.2.2 1.7l4.8-1-2.3-1.3zm50.7 2.2c-.7-.4.1-1.6.1-1.6l-2.7-.6c1.4-.6 3.3-.4 3.3-.4.6.4.5.9.6 1.3 0 .4 0 1-.3 1.3-.3.3-1 0-1 0z" />
        <path d="m539.1 345.2 2.7.6s-.8 1.2-.1 1.7l-4.8-1 2.2-1.3z" />
      </g>
      <path d="m495.8 343.3-1.2 3 .6.3c.9.3 1.8.1 2.2-.9.4-1-.1-1.8-1-2.1l-.6-.3zm.3.6c.8.4 1.2.9.9 1.7-.3.8-1 .8-1.7.5h-.1l.9-2.2z" />
      <path fillRule="evenodd" d="m497.6 347.6-.4-.1 1.4-3 .3.1-1.3 3z" />
      <path d="M500.2 345.3c-.6 0-1.2.4-1.5 1-.4 1 0 1.9.8 2.3.8.3 1.8 0 2.2-1a1.7 1.7 0 0 0-.9-2.2 1.5 1.5 0 0 0-.6-.1zm0 .5h.5c.6.3.8 1 .5 1.6-.2.6-1 1-1.5.7-.5-.3-.8-1-.5-1.6.2-.4.5-.7 1-.7z" />
      <path
        fillRule="evenodd"
        d="M503.8 347.4c0-.3-.1-.4-.3-.5-.3-.1-.6 0-.7.2l.2.6.3.2c.3.3.5.7.3 1.2a1 1 0 0 1-1.3.6 1 1 0 0 1-.6-1.2h.4c-.1.4 0 .7.4.9.3 0 .6-.1.7-.4.2-.4 0-.6-.2-.8l-.2-.2c-.3-.2-.5-.5-.3-1 .1-.5.7-.6 1-.5.4.2.6.4.7.8h-.4zm2.4.1-.5 1.9c-.1.5-.1 1 .4 1.2.6.1.9-.3 1-.8l.6-1.9.3.2-.5 1.9c-.2.7-.8 1.1-1.5 1-.7-.3-1-1-.7-1.6l.6-2 .3.1zm4.4 4.5-1.8-3-.5 2.4h-.4l.7-3.4 1.8 3 .4-2.4h.4zm.8 0 .4-3.2h.3l-.4 3.2z"
      />
      <path d="M514.2 348.9a1.6 1.6 0 0 0-1.7 1.6c0 1 .7 1.7 1.6 1.8.8 0 1.6-.7 1.6-1.7 0-.9-.7-1.7-1.5-1.7zm0 .5c.6 0 1 .6 1 1.2a1.1 1.1 0 0 1-1.1 1.2c-.6 0-1.1-.6-1.1-1.3 0-.6.5-1.2 1.1-1.2z" />
      <path
        fillRule="evenodd"
        d="m519 352.1-2.4-2.3.1 2.4h-.4l-.2-3.4 2.5 2.4-.2-2.4h.4zm2.1-.5-.6-3.2h.4l.6 2.8.9-.2v.4zm1.8-.3-.8-3.2h.4l.7 3.1z"
      />
      <path d="M523.9 347.7h-.4l-.4.2.9 3.1.7-.1c.5-.2 1-.6.8-1.2-.1-.4-.4-.7-.8-.6l.1-.8c-.2-.5-.5-.6-1-.6zm0 .4c.2 0 .4 0 .5.4.2.4-.1.5-.4.6h-.1l-.3-1h.1a1 1 0 0 1 .2 0zm.5 1.3c.3 0 .6 0 .6.4.2.4-.1.5-.4.6l-.3.1-.3-1h.4z" />
      <path
        fillRule="evenodd"
        d="m527.2 348 .2.3-1.2.4.4 1.2 1.2-.5.1.4-1.5.6-1.1-3.1 1.6-.6v.3l-1.1.5.3.8z"
      />
      <path d="M528.6 346.2c-.3 0-.5 0-.8.2l-.4.1 1.2 3h.3l-.4-1.4 1.4.9.5-.1-1.5-1c.4-.2.6-.7.4-1.1a.9.9 0 0 0-.7-.6zm0 .4.3.3c.2.5-.2.7-.5.8l-.5-1h.1l.5-.1z" />
      <path
        fillRule="evenodd"
        d="m529.2 345.8 1.7-.8.2.3-.7.3 1.2 2.7-.3.1-1.2-2.6-.7.3z"
      />
      <path d="m532.2 344.2.2 3.7.4-.2v-.8l1.3-.7.6.6.4-.3-2.9-2.3zm.4.9 1 .8-.8.5-.1-1.3zm2.7-2.2-1 .3-.5.3 1.7 2.8.5-.3c.9-.5 1.3-1.4.7-2.3-.4-.6-.9-.8-1.4-.8zm.2.5c.3 0 .6.2.8.5.4.8 0 1.3-.6 1.7l-1.3-1.9h.1l1-.3z" />
      <g id="sv-a" stroke="#000" strokeMiterlimit={2.6}>
        <path
          fill="#e60000"
          fillRule="evenodd"
          strokeWidth={0.1}
          d="M485 355.2c.6 0 1-.4 1-1a.9.9 0 0 0-1-.8c-.4 0-.8.4-.8.9s.4.9.9.9zm-5 6.3c.5 0 .9-.4.9-1a1 1 0 0 0-1-.8 1 1 0 0 0-.9.9c0 .5.5.9 1 .9zm-12-19.9c.5 0 1-.4 1-.9a1 1 0 0 0-1-.9.9.9 0 0 0-.8 1c0 .4.3.8.9.8zm-7.3 3.7c.5 0 1-.4 1-1 0-.5-.5-1-1-1a1 1 0 0 0-1 1c0 .6.4 1 1 1zm-1.4-22.3a1 1 0 0 0 1-1c0-.5-.4-1-1-1a1 1 0 0 0-1 1 1 1 0 0 0 1 1zm-6.2 1.8a1 1 0 0 0 1-1 1 1 0 0 0-1-1 1 1 0 0 0-1 1 1 1 0 0 0 1 1zm3.2-19.8a1 1 0 0 0 1-1 1 1 0 0 0-1-1 1 1 0 0 0-1 1c0 .5.4 1 1 1zm-5.5-18.3c.5 0 1-.4 1-1a1 1 0 0 0-1-1 1 1 0 0 0-1 1c0 .6.4 1 1 1zm7 1.8a1 1 0 0 0 1-1c0-.5-.4-1-1-1a1 1 0 0 0-1 1 1 1 0 0 0 1 1zm7-15.2c.5 0 1-.4 1-1 0-.5-.5-1-1-1a1 1 0 1 0 0 2zm-5.3-4.2a1 1 0 0 0 1-1 1 1 0 0 0-1-1 1 1 0 0 0-1 1 1 1 0 0 0 1 1zm10.5-10.3a1 1 0 0 0 1-1 1 1 0 0 0-1-1 1 1 0 0 0-1 1 1 1 0 0 0 1 1zm-21.5 46.3c.6 0 1-.4 1-1s-.4-1-1-1a1 1 0 0 0-1 1c0 .6.5 1 1 1z"
        />
        <path
          fill="none"
          strokeWidth={0.3}
          d="M486 358.9s-.8-3.2-.7-3.9l.8-.6m-1.4 5.7s-2.8.1-3.7.4l-.3.8m-13.4-15.5s-.2-3.8.6-4c0 0 .7-.4 1.2-1m-4.7 3.8s-2.1-.3-2.7 0c0 0-.2.6-.6.8m-.8-23-.7.5c-.8.3-2.3 4-2.3 4s-2.4-1.9-3.4-2h-1.1m-4.8-20.2s.6.6 1.2.3c0 0 3 2 3.1 2.7 0 0 3.2-3.2 3.8-2.9 0 0 .3.5 1-.1m-5.8-18.6s.3.5.9.8c0 0 1.4 2 1.4 3.5 0 0 2.5-2.3 3.3-2.1 0 0 .9.3 1.5 0m.3-19.5s.6.8 1 .2c0 0 1.8 2.2.8 4 0 0 2.5-.7 3.3-.3 0 0 .3 1 1.2.5"
        />
        <g fill="#1f601a" fillRule="evenodd" strokeWidth={0.3}>
          <path d="m532.8 378.3-4.5-.3c-.6 0-2-2.7-2.6-3.1-.6-.5-10.8-5.5-17.5-6.5a95 95 0 0 1-19-6 88 88 0 0 1-26-19.2c-2.9-4.2-6-14-7.2-19.2-.7-2.5-4-12.4-4-19.2a84 84 0 0 1 2.2-19.4 111 111 0 0 1 15.3-26.8s-12 18.7-14.2 25.9a81 81 0 0 0-2.5 21.5c.1 4.2 3.6 19.6 8.7 30.9 4.1 9 7.7 10.2 14 15.2 3 2.4 8.8 6.2 13.6 8.6 4.8 2.4 15 5.5 17.8 5.9 2.7.5 16.4 4.5 18.2 5.4 1.8 1 6.5 5 7.7 6.3z" />
          <path d="M464.1 343.4c.3-1.4.4-2.4 1-2.8a14 14 0 0 0 2.2-3.5c.3-1.2 0-2.2 0-2.8l.4-2.7s-.7-2.5-1.3-3c-.6-.4-2.2-2.6-2.5-3.2 0 0 .2 1.3-.3 1.9a7 7 0 0 0-.6 3c0 .9.3 3 0 4-.3 1.2-.7 2.2-.4 3.5l1.5 5.6zm-.5-1.5s-3.4-4.4-3.4-6.2c0-1.8-.3-2.9-.6-3.3-.3-.4-2.3-2.7-.5-5.6.8-1.2 1-1 1.4-2.4.6-1.6 1.8-1.6 2-3.3 0 0 .4 2 .5 3.6.2 1.7-.1 2.3-.2 3.2-.2.9.4 2 .4 3.3 0 1.4-.2 1.9-.2 2.7 0 .4-.5 6.2.6 8zm38.6 23.5-4-.5c-.7 0-2.5-.5-3.5-.9a10 10 0 0 1-4-2.8c-2.8-3-2.5-4.5-3-4.6-1-.2 1.5-.4 2.8-.3 1.1.2 2.8 1 3.8 2 1.2 1.1 3 2.3 3.5 2.7.6.5 1 .7 1.7 1.5.7 1 .6 1.5 2.7 3z" />
          <path d="M506.2 367.5s-7.2-3.2-8-3.8a25 25 0 0 1-2.8-2.6c-.7-.8-3.8-2.4-4.3-3.4-.3-.7-2.3-3.3-3.4-5.4-.5-1 4.9.3 4.9.3 4.4 1.8 2.4.6 4.8 2.4 1.5 1.1 2.5 2 2.9 2.9.6 1.3 1.2 3.5 1.9 4.7.6 1.2 1.7 2.7 4 5z" />
          <path d="M510.2 368.4s-6-1.5-8.8-5.2c-2-2.6-2-1.8-2.7-2.7-1-1-2.6-2.3-4-4.5.2.3-1.6-5.9-1.6-6.6 0-.4 2.3.3 4.2 1 1.5.7 2.4 2 3.8 2.8 1.6 1 1.8 3.7 2.5 4.9 1 1.8 1.2 2.7 1.2 3.5 0 1.4.8 1.8 1.2 3 .5 1.3 2.1 1 4.2 3.8zm-9.6-2-5.9-2.4c-.8-.1-1-.6-2.1-.9-.9-.2-1.7-.9-3.8-.4-.9.2-4.6 1-5.5.6-1-.5 1.3 2.5 2.3 3.1 1.1.7 2.9 1 4.4.8h4.4c.7 0 1.2.2 2.3-.1 1-.3 1.3-.8 3.9-.7z" />
          <path d="M504 366.4s-5.7-1.4-6.7-1.4l-4.8.4c-1 .2-4.5-.2-5.5.4-1 .4-5.6 1-6.8.8-1.2-.3 2.4 3.2 3.9 3.6 4.6 1.3 3.2 1.1 6.2.4 1.8-.5 4.4-.6 5.4-.8.9-.1.7-.7 2-1.2 1.1-.5 3.2-1.8 6.3-2.2z" />
          <path d="M508.7 368.8s-5.7-2.4-10.2-1.1l-4.2 1c-1.4.1-2.6-.6-5 .4-1.2.4-6.2 2.5-7.5 2.4-1.3-.1 4 3.3 5.4 3.1 4.6-.6 9 1 11 0l4-1.5c1-.4 1.5-1.2 2.1-1.7.6-.4 1-1.6 4.4-2.6zm-30.6-13.1s-3.3-3.6-4-4.1l-3-2.4c-.6-.6-1.3-2-3.4-2.5-1-.2-3.1-.6-3.8-1.4-.6-.8.1 3 .8 4a8.1 8.1 0 0 0 3.6 2.5c1.5.5 3.3 1.5 4 1.9.6.3 1 .6 2 .8 1.1.2 1.6 0 3.8 1.2z" />
          <path d="M481.3 357.2s-5.7-4-6.5-4.4l-3.5-1.3c-1.1-.3-4-2.3-5-2.3-1.2 0-3.3-.1-4.3-.8-1-.8-.1 2.7 1 3.7 3.6 3.2 1.1 2.2 4.1 2.8l5.1 1.7c1 .3 1-.3 2.3-.2 1.3 0 3.8-.2 6.8.8z" />
          <path d="M482.6 358.3s-2.3-1.6-6.9-2.4c-3-.5-3-.6-4.1-1-1.4-.4-1.7-.4-4.3-.5-1.2-.1-6.2 1.5-7.4.8-1-.6 1.3 1.5 2.6 2 2 .8 1.8 2 4 2.8 2.2.7 4.7 1.6 6 1.4 1-.2 1.8-.7 3.3-.8 1.4-.2 4-2.3 6.8-2.4zm.5-1.2s1.1-5.5.1-6.8a5.2 5.2 0 0 1-1.2-2.9 11 11 0 0 0-1.6-4.3c-.6-.8-1.8-4.2-1.5-5.1 0 0-3.2 3.1-3 5.1v2.4c-.2.9.7 3.9 1.3 4.8.6 1 .3 3.6 1 4.2.5.6 4.1 3 4.9 2.6z" />
          <path d="M482.6 358.3c.3.1-2-1.8-3-2.3-1-.4-5.3-1.6-5.6-2.7-.3-1-3.7-4.6-3.9-5.6 0-.6-.7-2-.6-2.8.2-.7.5-2.6 1-3.6.4-1.1 1.4-3.6 2.5-4l1.2 3.8c.3 1 .6 2.3 1 2.9.5.6 2 3.4 2.1 4.5l1.1 5.3c.1.7 3 3.8 4.2 4.4zM464 343.4c.1.8-2.3-.8-3.5-.8-1.2 0-4.8.5-5.7-.4-.9-1-2.2-2.6-2.7-2.9-.5-.3-2.1-3-2.6-4.5-.4-1.5-3.6-4.2-4-4.5 0 0 4.3-.9 7 .9s3 1.4 3.5 1.6c.6.3 5.3 4.3 5.6 5.8.3 1.5 2.2 4 2.4 4.8z" />
          <path d="M464.1 343.4s-3.9-2.7-4.8-2.6c-1 .2-5.2-3-5.4-5-.2-1-2.2-2.5-2.6-3.1-1-1.8-1.7-5.9-3.2-7l5.2 1.3c2 .3 3.6.6 4.3 2.2.8 1.7 1.4 3 2 3.2.6.2 1.5 2.3 1.8 4.4a32 32 0 0 0 2.7 6.6zm-7.4-20.5c.7 1 .6-6 .9-6.8a11.3 11.3 0 0 1 1.7-2.8c.6-.6.6-2.7.9-3.3.3-.6.1-4.7-.3-5.8L458 306c-.6.7-1.7 1-2 2-.3.8-.9.8-1.3 1.8a5.6 5.6 0 0 0-.6 3.6c.3 1.2.1 1.6.1 2.7 0 1 1.5 5.6 2.4 6.9z" />
          <path d="M456.9 323.5s-.3-2 .4-2.7c.8-.8 1.5-.8 1.8-1.2.3-.5.2-1 .5-1.7.3-.6 1-1.6 1-2 .3-1.7 1.3-3.6.5-5.3 0 0-1.7.5-2.1.8-.5.3-1.8 1.6-2 2.8-.1 1.3-.3 1.5-.7 2.2-.5.8-1 3-.3 4.4a7.4 7.4 0 0 1 .9 2.7zm-4.4-23s-.3-4.4.9-5.8c1.2-1.3 1.5-3.9 4.2-5.3v1.9c.2.7.5 2.8 0 3.6-.4.7-2 2-2 2.7 0 .6-1 2.1-1.7 2.4l-1.4.5z" />
          <path d="M452.5 302.8s0-3 .9-4c.9-.9 1.4-1.4 1.8-2 .5-.5 1-2 2-2.7 1-.6 2.8-2.1 3-2.7 0 0 .4 3.8-.6 5.8s-1 3-2.3 3.4c-1.2.5-1.4.8-1.8 1-.5.4-1.2.8-1.8.8-.6 0-1.2.4-1.2.4zm3.5 20.6c.1.8.7-2-2.4-2-3.2 0-5.8-1.2-6.8-2.3l-2.1-2.3a9 9 0 0 1-1.8-3.1c-.2-.9-1-4.2-1-4.8 0 0 1.7.3 2.5.9.7.6 2 .6 2.8 1 .8.5 1.4 1.7 1.9 2.1.4.5 1.7.5 2.3 1.4.6.9 1.7 2.9 1.9 3.8 0 .9 1.2 1.8 2 2.2.6.5.5 2.3.6 3z" />
          <path d="M455.6 322.1s-2-2.5-3.1-2.5c-1 0-3.8-2.7-4-4 0-1.1-1-3.4-1.6-3.9a3.6 3.6 0 0 1-1.5-3.3c.2-1.8.2-4.8.2-4.8s.6 1.8 1.5 2.3c.9.4 2.5 1 2.8 1.6.3.6 1.5.6 2 2.5.5 1.7.5 1.6.8 2.2.3.6 1 1.4 1.3 2.6.3 1.2 2 4.3 1.7 7.3zm-3-16.6c-.2.8 1.1-1.6-1.7-2.4a9.6 9.6 0 0 1-5.6-4l-1.3-2.6a9 9 0 0 1-.7-3.4c0-.9.2-4.1.5-4.6 0 0 1.4.7 2 1.4.4.8 1.7 1.2 2.3 1.8.5.6.7 1.9 1 2.5.3.5 1.5.9 1.8 1.8.3 1 .7 3.1.6 4-.1.8.6 2 1.2 2.6.5.6-.1 2.2-.2 3z" />
          <path d="M452.6 304.3s-1.3-2.9-2.2-3.2c-1-.3-2.5-2.7-2.6-3.9-.1-1.2-.3-3.4-.7-4-.5-.6-1.3-2.4-.6-4l1.6-3.7 1.3 2.1c.8 1.6 1.6 1.7 1.7 2.3.1.7 1 1 1.4 2.3.5 1.7 0 1.6 0 2.3.2.6.7 1.5.6 2.7 0 1.1.6 4.5-.5 7.1zm2.3-18.2c.1-.4 1-.9 2.1-1.2 1-.3 2.7-2.7 3.5-3.3.7-.6 1-1.6 2-2.1.9-.5 1.4-2.4 1.7-4.2l-3.3.7a7.2 7.2 0 0 0-2.8 1.8c-.6.8-1.2 2-1.9 2.3-.6.3-1.3 2.1-1.3 3.3v2.7z" />
          <path d="m454.8 284.8-.2-2.6c0-.9-.6-3.3.7-5.3 1-1.3 4.3-3.9 5.2-4 0 0 .6 2.4.4 3.1-.1.8-1 3.8-1.6 4.1-.7.3-2.4 3.9-4.5 4.7z" />
          <path d="M454 286.1c-.4.7-.1-2.2-1-3-1-.7-1-1.8-1-3s.2-2 .3-2.9c.2-.7 2.5-3.9 2.3-4.8l1.7 3.8c.4 1-.3 2.1-.2 3 .2.9.9 2.6.3 3.5L454 286zm8-15.5s.2-.4 1.5-.4 3.3-.1 3.9-.8c.6-.6 1.6-1.4 2.3-1.7a5.2 5.2 0 0 0 1.8-2.2c.1-.6 1.2-1.8 1.6-1.8 0 0-1.6-.2-3.4.3-1.8.5-4.4 1.4-5 2.6-.6 1.2-2.7 4-2.7 4z" />
          <path d="M462.5 270.3c.3 1 2.8-1 3.4-1.8l1.5-2 1.8-2.4c1-1.6.7-4.6.3-4.3a31 31 0 0 1-2.5 1.4c-.5 0-1.4.4-1.7 1.1-.3.8-.6 1.8-1 2.3-.5.5-3.2 2-1.8 5.7z" />
          <path d="M461.6 270.3s2-1.5 2.8-2.3c1-.8.5-2 1-2.6.3-.6 1.4-2 1.1-3l-.9-3.4-1.8 1.8c-.8.8-.9 1.4-1.2 2.3-.3.9-1 1.5-1.2 2.2-.3.8 0 2.3.2 3.2v1.8z" />
        </g>
        <g fill="none" strokeWidth={0.1}>
          <path d="M494.8 365.2s-10-.1-10.8-1.3m16.6 2.6s-6.5 1.7-10 1.3c-3.5-.4-5.1.3-5.9.3-.7 0-4.5-1.5-4.5-1.5m27 2.2-6 1.3c-1 .3-6.2 2.2-7.7 2.2h-5a18 18 0 0 1-6.3-.4m6.2-15s3.7 2.3 4.4 3c.5.8 3.8 3.5 4.5 3.5m-9-11.1s6.5 5.6 7.6 6.3c1 .8 7.4 7 8.1 7.8M493.6 350s5.1 4 5.7 5.7c.6 1.7 2.2 3.6 2.2 3.6s2 4.2 2.8 4.8c.8.6 2.3 2.2 4.1 3.4m-44-21.3s5.4 4.6 6.9 5.4m-9.1-2.5s5.4 3.7 7.8 4.6c2.4 1 4.4 1.7 9.6 2.4m2.1 2.2s-6-.3-7 0-5.8-.8-7-1.1l-6.6-1.4m11.4-17.9s-.3 3.3.2 4.7c.4 1.3 2.6 5.3 2.4 6.2-.1.9 1.2 5 2.4 5.7m1.2-16s-1 3.3-.6 4.4c.5 1 1.2 3 1.2 4.2 0 1.2.8 3 1 3.8.4.7-.1 3.3.7 4l1.6 2.2m-36.1-26.3s4.8 1.9 5.4 3c.6 1.3 1.5 1.6 2 2.2m10.3-9.7s1.3 4.9 1 6c-.3 1.2-.3 3.7-.3 4.6 0 .9-1.4 4.5-1.3 5m-1.3-19.6-.6 4c-.1 1.2 0 3.2-.3 4-.3.7-.8 4.8 0 6.6M449 326.2l4.8 4.2c.9 1 5 5.3 5.1 6.4.1 1 3 4.3 3.9 5m-20.5-32.5s4 4 4.2 4.9c.3.9 2 2.3 2.8 2.8m11.4-6s-1.5 2.3-1.5 3c0 .8-.6 2.7-1.2 3.5-.4.5-1.7 2.7-1.5 4m3-16.8-1 3.6c-.2 1.5-1 3-1.3 4-.3.8-1.5 5.2-1 7.9m-10.4-15.7s.4 2.1 1.5 3.2c1 1 2.7 2.6 2.8 3.4.2 1 1.6 5.4 3 7a5.4 5.4 0 0 1 1.7 3m-10.5-32s.4 2.6.7 3.4c.3.7 1.5 4 2.7 5.1m9.5-7.7-.9 3c-.1 1-1 2-1.2 2.4l-.7 2m5.5-5.3c-.1.9-1.8 3.6-2 4-.1.5-1 2.6-1.9 3.2-.9.6-3.6 2.6-3.4 3.4m-4.4-16.5s-.2 3.3.4 4.5a37.2 37.2 0 0 1 1.7 4c.3.9.3 2.4.4 3.4.2 1.1.6 3 1.2 3.8m11.8-25.9-3.2 3.5c-1 1-4.8 5-5 5.8m4.6-11.6s-2.1 4.7-2.6 5.4l-.9 2m-2-7.5s.2 3.6 0 4.5a7.9 7.9 0 0 0 0 2.9c.2.4-.4 3.7-.5 4.5m18-21.3s-4.8 2.9-5.5 3.6m2.7-7.3-3.3 4.8-.8 1.4m.3-6.7s-1 2.6-1.2 3.6a36 36 0 0 1-2.2 5.6" />
          <path strokeWidth={0.3} d="M469.2 258s-.4 1 1.4.7" />
        </g>
      </g>
      <use xlinkHref="#sv-a" transform="matrix(-1 0 0 1 1030 0)" />
      <path
        fill="#00209f"
        fillRule="evenodd"
        d="M514.6 366.1s.7-1.8 2.2-.1c0 0 1.9 4.2.5 4.3-1.4.2-2.7.5-2.9-.3-.1-.7.2-3.9.2-3.9z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        d="M516.5 365.5s.5-6.4 1.4-6.7c.9-.3 3.6-1.8 5.3-.5 1.6 1.4 0 8-.5 8.7-.6.6-1.5 2.5-5 2l-.4-1.6s1.8-.2 3-.8c1.2-.6 1.6-1.2 1.5-1.8-.2-.9 0-4.2-1-4.5l-2.3-.8-1.7 6.5-.3-.5z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M514.4 370s-6.2 3.7-3 9l-2.1-1.3s-1.2 2.2-.1 3.4c0 0-4.3-3.8-1-8.3 3.4-4.6 6-4.3 6-4.3l.2 1.5z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M514.4 367s-2.7-1.8-6.6-.7c0 0-1.7-5.6-1-7.4.2-.8.8-.9.8-.9s-2-1.2-1.3 4c.6 5.4 1.6 6.8 1.6 6.8s5.2.3 6.4-.3l.1-1.4z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M514.4 367s-5.4-9-6.8-9c0 0-1.5-.2 2-.6 1.2-.1 3.2 0 4 1.7 1 1.6 1.7 5.5 2 6.1 0 0-1 .3-1.2 1.9z"
      />
      <path
        fill="#011322"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M514.4 367s-3.6-1.6-4-2c-.5-.5-1.2-5.6-.8-5.3 0 0-1.5-1.7-2-1.7-.3 0-1.3.8-1 2.6.3 1.8.7 4.5 1.2 5.7 0 0 2.9-1.2 6.6.8z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M517.7 370s2 1.3 2 3.5c0 2.3.9 6.4 2.7 7.3 0 0 .5-1.7 1-2 0 0 1.9 2.1 2.5 2.1 0 0-1-2-1-2.9 0-.9-1-4.3-2-5.2-.8-1-2.6-3-5.2-3.8v1z"
      />
      <path
        fill="#011322"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="m518.5 359.5-1.7 6.5.5 1.4s.6-.2.9-1c.3-.7 1.2-6.3 1.7-6.5l-1.4-.4z"
      />
      <path
        fill="#011d33"
        fillRule="evenodd"
        d="M514.4 369.3s-3 1-4.1 3.2c0 0-.4-1.5 4-3.6v.4zm3.4 0s2 .8 2.6 2l-2.6-1.5v-.5zm-3.4-1.7s-4.6.7-5.6.5c0 0 1.3.3 5.6 0v-.5zm7.4-2.8s.5 2.3.9 2.2c.4-.2 1.2-3.9 1.2-5.6 0-1.7-.7-2.1-1.4-2-.7 0-1 1.5-1 2.2a49 49 0 0 0 .3 3.2z"
      />
      <path
        fill="#011d33"
        fillRule="evenodd"
        d="M516.8 366s1.9 4.1.5 4.4c-1.4.2.6.1-.4-2.7-.4-1.1-1-2.5-1.3-2.5 0 0 1.1.4 1.2.8z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M514.6 366.1s.7-1.8 2.2-.1c0 0 1.9 4.2.5 4.3-1.4.2-2.7.5-2.9-.3-.1-.7.2-3.9.2-3.9z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="M516.5 365.5s.5-6.4 1.4-6.7c.9-.3 3.6-1.8 5.3-.5 1.6 1.4 0 8-.5 8.7-.6.6-1.5 2.5-5 2l-.4-1.6s1.8-.2 3-.8c1.2-.6 1.6-1.2 1.5-1.8-.2-.9 0-4.2-1-4.5l-2.3-.8-1.7 6.5-.3-.5z"
      />
    </g>
    <g transform="matrix(.8 0 0 .8 -92.7 0)">
      <path
        fill="#00209f"
        fillRule="evenodd"
        d="M509.8 255.9c-.4-1-.4-7.4-.4-8.4a68 68 0 0 1 3.8-11.2c.6-1 .5-1.2.7-1.8l.9-1.2a10.9 10.9 0 0 1 1.3 4.1s-.6 4.1-1.1 6c-.4 1.7-1.6 4.3-1.8 4.8-.6 1.2-.5 2.4-.2 2.5l-3.2 5.2z"
      />
      <path
        fill="#fff"
        fillRule="evenodd"
        d="m515 247.3.5.6c1.3-1.5 1.4-4.5 1.4-4.5l-.9-6s-.5 4-1 6c-.4 1.7-1.6 4.3-1.8 4.8-.9 2.2-.2 2.4-.2 2.5l2-3.3z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        d="M515.5 247.9c1.3-1.5 1.4-4.5 1.4-4.5s1 5 .4 6c-.5 1-.5.7-.4 1.3l-1.4-2.8z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.3}
        d="M517 250.7c-.2-.6-.2-.3.3-1.3s-.4-6-.4-6l-.9-6c0-1.3-.6-3-1.2-4.1l-.9 1.2c-.2.6 0 .8-.7 1.8-.6 1-3.6 9.5-3.8 11.2 0 1 0 7.5.4 8.4"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="m515 234.1-.2-1.3c0-.2.6.9 1 .7.9.3 1.9 1.5 2.1 1.8-.4.5-1.3 1.6-2 1.4-.5-.2-.4-1-.5-1.5-.1-.3-.4-.6-.4-1z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="m515 233.3.4.4c.2.2.4 0 .7.2.6.4.9.8 1.6 1.5m-2-1.4c.8.4 1.2 1 1.8 1.7"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="m514 233.4 1.3-.6c.1 0-.7.8-.4 1.2 0 .9-.7 2.2-1 2.5-.6-.1-1.2-.1-1.8-1.1-.2-.4.4-.8.8-1.1.2-.2.7-.8 1.2-.9z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="m514.9 233.2-.3.5.1.7c-.2.7-.5 1-.9 2"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="M514.4 234c0 .9-.5 1.5-1 2.3h.2"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="M515.4 232.8c.6-.7 1.7-1.4 2.3-1l.6.6c.2.3.2.5 0 .8-.3.8-1.4.4-2 0-.2 0-.6-.4-.8-.3l-.3.1.3.1 1.8.9c.5.2 1.5-.5 1.4-1 0-.5-.9-1.5-1.3-1.5-1 0-1.8.6-2.5 1.4.2-.2.4 0 .5 0z"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="M514.9 232.8c-.6-.7-1.7-1.4-2.2-1l-.6.6c-.3.3-.3.5-.1.8.3.8 1.4.4 2 0 .2 0 .6-.4.8-.3l.4.1-.4.1-1.8.9c-.5.2-1.4-.5-1.4-1 0-.6 1-1.5 1.4-1.5 1 0 1.7.6 2.4 1.4-.1-.2-.4 0-.5 0z"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="M515 232.4c-.2-.1-.5.1-.6.3 0 .2.1.6.4.6.3.2.8 0 .9-.3 0-.4-.3-.5-.6-.6z"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        d="M515 226.3s.4 2.4 1.6 4c1.2 1.8-1.4 1.6-1.6 2.2 0 0-.8-1.7-1.6-2.2 0 0 1.3-2 1.6-4z"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="M515 226.3s.4 2.4 1.6 4c0 0-1.4 1.6-1.6 2.2 0 0-.8-1.7-1.6-2.2 0 0 1.3-2 1.6-4"
      />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.1}
        d="m515 228.8.7 1.8s-.6.4-.7.7c0 0-.3-.8-.6-1 0 0 .6-.8.6-1.5z"
      />
      <path
        fill="#fff"
        fillRule="evenodd"
        d="m515 344.5-.3-.2c-.4-.2-1.2-.2-1.3-.5-1-1.1-.4-3.4 0-4.8 1-2.6 1-5 1.6-7.4.6 2.4.7 4.8 1.6 7.4.4 1.4 1.1 3.7.1 4.8-.2.3-.9.3-1.3.5l-.4.2z"
      />
      <path
        fill="#00209f"
        fillRule="evenodd"
        d="M515 331.5c.6 2.5.7 5 1.6 7.6.4 1.3 1 3.4.3 4.5.4 0 .7-.1 1-.3.2 0 .3 0 .4-.2l.4-.5c.3-.2.6 0 .9-.2l.1-.2c.6-.3 1-.6 1.3-1.1.1-.4.2-.9 0-1.3 0-.3 0-.5-.2-.8l-.5-1.1-.6-1.2a2.4 2.4 0 0 0-.3-.5l-.3-.6-.4-.4-.4-.3s-.3-.1-.2-.2l-.3-.1-1-2a3 3 0 0 1-.2-1.1H515zm0 0c-.5 2.5-.7 5-1.6 7.6-.3 1.3-1 3.4-.2 4.5-.4 0-.7-.1-1.1-.3-.1 0-.3 0-.3-.2a1.4 1.4 0 0 0-.5-.5c-.2-.2-.5 0-.8-.2l-.2-.2c-.5-.3-1-.6-1.2-1.1a2.5 2.5 0 0 1-.1-1.3l.2-.8.6-1.1.6-1.2c0-.2.1-.4.3-.5l.3-.6.4-.4.4-.3.2-.2.2-.1 1-2c.2-.2.2-.8.2-1.1h1.6z"
      />
      <g id="sv-b" fill="none" strokeMiterlimit={2.6} strokeWidth={0.2}>
        <path stroke="#011322" d="M514.3 331.6s-1 4-1.6 5c-.6 1.1-3 3-1.4 6" />
        <path
          stroke="#011d33"
          d="M514.4 331.6s-1 4-1.6 5.1c-.6 1.1-3 3-1.4 6"
        />
        <path
          stroke="#022743"
          d="M514.5 331.6s-1 4.1-1.6 5.2c-.6 1-2.9 3.1-1.3 6"
        />
        <path
          stroke="#033054"
          d="M514.6 331.6s-1 4.2-1.6 5.3c-.6 1-2.9 3-1.2 6.1"
        />
        <path
          stroke="#053a65"
          d="M514.7 331.6s-1 4.3-1.6 5.3c-.6 1-2.8 3.2-1.2 6.3"
        />
        <path stroke="#011d33" d="M514.2 331.6s-1 4-1.6 5c-.6 1.1-3 3-1.4 6" />
        <path stroke="#022743" d="M514 331.6s-.9 3.8-1.6 5c-.6 1-3 3-1.4 5.9" />
        <path stroke="#033054" d="M514 331.6s-1 3.7-1.7 5c-.5 1-3 3-1.4 5.9" />
        <path
          stroke="#053a65"
          d="M513.8 331.6s-.8 3.6-1.6 5c-.6 1-3 3-1.4 5.9"
        />
        <path
          stroke="#00209f"
          d="M513.8 331.6s-.9 3.4-1.7 5c-.6 1-3 2.9-1.4 5.8"
        />
        <path
          stroke="#00209f"
          d="M514.8 331.6s-1 4.3-1.6 5.4c-.6 1-2.8 3.3-1.1 6.3"
        />
      </g>
      <use xlinkHref="#sv-b" transform="matrix(-1 0 0 1 1030 0)" />
      <path
        fill="none"
        stroke="#000"
        strokeMiterlimit={2.6}
        strokeWidth={0.2}
        d="m518.6 335.2.5.5.3.5.3.5.6 1.2.5 1.1.3.8a2.5 2.5 0 0 1-.1 1.3c-.2.5-.8.8-1.3 1.1l-.1.2c-.3.2-.6 0-.9.2a1.9 1.9 0 0 0-.4.5l-.3.2c-.4.2-.7.3-1.1.3l-.2.3c-.2.2-1 .2-1.3.4l-.4.2-.3-.2c-.4-.2-1.2-.2-1.3-.4a.7.7 0 0 1-.2-.3l-1.2-.3s-.2 0-.3-.2a1.4 1.4 0 0 0-.4-.5c-.3-.2-.6 0-.8-.2l-.2-.2c-.6-.3-1-.6-1.2-1.1a2.5 2.5 0 0 1-.1-1.3l.2-.8.5-1.1.7-1.2c0-.2.1-.4.3-.5 0-.2.1-.4.3-.5 0-.2.3-.3.4-.5"
      />
      <g id="sv-c">
        <g fillRule="evenodd">
          <path
            fill="#fff"
            d="M487.4 293.6c-1.5-3.7-3-11.3-3-13 .3-7.1.2-9.3.9-16.5l7.3 8.3c-.2 2.8-.2 3.7 0 5.5.1.7.5 3.9 1 5.1l-6.2 10.6z"
          />
          <path
            fill="#00209f"
            d="M493.6 283c-.5-1.3-.9-4.5-1-5.1-.2-1.8-.2-2.7 0-5.5l4.5 5-3.5 5.6zm-18.6 7a75.6 75.6 0 0 1-.3-4.4c0-5.1-.6-8 0-13.4.4-4.2 1.5-9.8 1.3-14.4-.1-1.3.1-2.6.2-3.9l9 10.1c-.6 7.3-.5 9.5-.8 16.6 0 1.7 1.5 9.3 3 13l-2 3.2-10.4-6.9zm6.3 13.7c-.6-1-1-3.9-1.2-4.5-.3-1.5-.3-2.3-.2-5l5 3.3-3.6 6.2zm-14.3 24a5.2 5.2 0 0 1-1.8-2.2c-.7-1.8-.5-1.7-1-3.6-.2-1.1-.2-2.3-.5-3.4-.2-1.2-1.8-4.8-1.8-6.2-.2-4.8-1.8-8-1.4-13.2.3-4 1.2-9.4.7-13.5l.1-3.6 10.3 6.7c-.4 6.8-.2 8.8-.2 15.4 0 1.6 1.3 8.1 3 11l-7.4 12.6zm17 3.8c1.9 1.7 5.4 2.6 6 3 1.2 1 3 2.3 6.3 2.4 2.3.2 3.3-.4 5.7-.7 2.8-.3-.3.1 2.3-.5 1.4-.3 1.4-.5 3.2-1 1.3-.3 2.7-.6 3.5-1.8.3-.4.6-.7.6-1.4h1.8c.2.5-.3 1.5-.5 1.8l-.5.7c-.2.6-.2.4-.7.9l-.8.6c-.4.3-.7.6-1.1.7-1.8.3-2.5.7-4.2 1.1-1.6.5-.7.4-2 .7l-2.4.7-2.4.6c-2.9.7-5.7.5-8.6.3-1.1 0-4-.7-5-1.4-1.8-1.2-5.7-1.7-7.4-2.9-.3-.2-1.4-.7-1.6-1-1.7-1.3-3-1.7-4.8-2.8H484z"
          />
          <path
            fill="#00209f"
            d="M497.7 331.5h14c-.1.7-.4 1-.7 1.5-.8 1-2.2 1.4-3.5 1.7-1.4.4-2.9-.4-4.4-.4-3.7-1.1-4.1-2.3-5.4-2.8z"
          />
          <path
            fill="#fff"
            d="M497.7 331.5c1.3.6 2 1.7 5.4 2.8 1.3 0 2.8.6 4 .6-1.5.3-1.5.5-2.8.8-2.6.6.5.2-2.3.5-2.4.3-3.4 1-5.7.8a11 11 0 0 1-6.3-2.5c-.6-.4-4.1-1.3-6-3h13.7z"
          />
        </g>
        <g fill="none" strokeMiterlimit={2.6} strokeWidth={0.2}>
          <path stroke="#022743" d="M476.6 259.7s1.7 15 7.5 14.4" />
          <path
            stroke="#022847"
            d="M484.2 274c-3 .2-4.9-3.5-6-7a46.3 46.3 0 0 1-1.5-7.3"
          />
          <path
            stroke="#032b4c"
            d="M484.2 274c-3-.1-4.9-3.8-5.8-7a43.6 43.6 0 0 1-1.7-7.4"
          />
          <path
            stroke="#032d4f"
            d="M484.2 274c-2.9-.3-4.9-4.1-5.8-7.2a48.2 48.2 0 0 1-1.7-7.2"
          />
          <path
            stroke="#032f53"
            d="M484.2 273.9c-2.9-.5-4.9-4.4-5.8-7.2a43 43 0 0 1-1.7-7.2"
          />
          <path
            stroke="#043258"
            d="M484.2 273.8c-3-.6-4.9-4.6-5.7-7.1-1.1-3.2-1.8-7.1-1.9-7.2"
          />
          <path
            stroke="#04345b"
            d="M484.2 273.8c-2.9-.9-4.9-4.9-5.6-7.2a46 46 0 0 1-2-7.2"
          />
          <path
            stroke="#04365e"
            d="M484.3 273.7c-3-1-5-5-5.7-7.3a48.7 48.7 0 0 1-1.9-7"
          />
          <path
            stroke="#043862"
            d="M484.3 273.7c-3-1.2-5-5.4-5.6-7.3a47.5 47.5 0 0 1-2-7.1"
          />
          <path
            stroke="#053b67"
            d="M484.3 273.6c-3-1.3-5-5.6-5.6-7.3-1-2.8-2-6.8-2-7"
          />
          <path
            stroke="#053d6a"
            d="M484.3 273.6c-3-1.6-5-6-5.5-7.4a50.3 50.3 0 0 1-2.1-7"
          />
          <path
            stroke="#053f6e"
            d="M484.3 273.5c-3-1.7-5-6.2-5.4-7.4a45.7 45.7 0 0 1-2.2-7"
          />
          <path
            stroke="#064172"
            d="M484.4 273.5c-3-2-5-6.4-5.5-7.5a66 66 0 0 1-2.2-7"
          />
          <path
            stroke="#00209f"
            d="M476.7 259a47 47 0 0 0 2.3 6.9c.3.8 2.4 5.4 5.4 7.5"
          />
          <path stroke="#022743" d="M476.9 256.3s4.8 12 8 10.6" />
          <path
            stroke="#022a49"
            d="M484.8 266.9c-1.3.5-3.3-1.8-5-4.6a65.2 65.2 0 0 1-3-6"
          />
          <path
            stroke="#032d4f"
            d="M484.8 266.8c-1.2.5-3.2-1.8-4.9-4.6a86 86 0 0 1-3-6"
          />
          <path
            stroke="#033054"
            d="M484.8 266.8c-1 .4-3.2-1.7-4.9-4.7a91.5 91.5 0 0 1-3-5.9"
          />
          <path
            stroke="#043359"
            d="M484.8 266.8c-.8.3-3.1-1.7-4.8-4.8-2-3.4-3-5.8-3-5.8"
          />
          <path
            stroke="#043760"
            d="M484.9 266.7c-.7.3-3.1-1.7-4.8-4.8l-3.1-5.8"
          />
          <path
            stroke="#053a65"
            d="M484.9 266.7c-.6.3-3-1.7-4.8-4.9a749.5 749.5 0 0 0-3.2-5.8"
          />
          <path
            stroke="#053d6a"
            d="M484.9 266.7c-.4.2-3-1.6-4.7-5a281 281 0 0 0-3.2-5.7"
          />
          <path stroke="#064171" d="M484.9 266.7c-.2 0-2.9-1.6-4.7-5L477 256" />
          <path
            stroke="#00209f"
            d="M477 255.9s1 1.4 3.3 5.7a13.6 13.6 0 0 0 4.5 5m8 12.1 3.8-.7m-4-3.1 4.1 2.2"
          />
          <path stroke="#064171" d="m492.5 275 4.2 2" />
          <path stroke="#053e6c" d="m492.5 275.2 4.2 2" />
          <path stroke="#053b67" d="m492.5 275.4 4.2 1.8" />
          <path stroke="#043862" d="m492.6 275.6 4.2 1.6" />
          <path stroke="#04355c" d="m492.6 275.8 4.2 1.4" />
          <path stroke="#043258" d="m492.6 276 4.3 1.2" />
          <path stroke="#032f53" d="m492.6 276.1 4.3 1.2" />
          <path stroke="#032c4d" d="m492.6 276.3 4.4 1" />
          <path stroke="#022a49" d="m492.6 276.5 4.4.9" />
          <path stroke="#064171" d="m492.8 278.5 3.9-.5" />
          <path stroke="#053e6c" d="m492.8 278.3 4-.4" />
          <path stroke="#053b67" d="m492.8 278.1 4-.3" />
          <path stroke="#043862" d="m492.8 278 4-.2" />
          <path stroke="#04355c" d="M492.8 277.7h4" />
          <path stroke="#043258" d="m492.8 277.5 4.1.2" />
          <path stroke="#032f53" d="m492.8 277.3 4.2.3" />
          <path stroke="#032c4d" d="m492.7 277.1 4.3.4" />
          <path stroke="#022a49" d="m492.7 276.9 4.4.6" />
          <path
            stroke="#022743"
            d="m492.7 276.7 4.4.7m-22.1.4s.2 3.2.9 4.5c1 1.9 3.9 4.7 7.2 6.8"
          />
          <path
            stroke="#022847"
            d="M483.2 289.1a27.2 27.2 0 0 1-5.5-4.6 13.7 13.7 0 0 1-1.7-2.3c-.7-1.4-1-4.5-1-4.5"
          />
          <path
            stroke="#032b4c"
            d="M483.3 289.1a27.2 27.2 0 0 1-5.4-4.7 9.3 9.3 0 0 1-1.7-2.3c-.8-1.4-1.2-4.5-1.2-4.5"
          />
          <path
            stroke="#032d4f"
            d="M483.3 289.1a31.3 31.3 0 0 1-5.3-4.7 12 12 0 0 1-1.7-2.4c-.8-1.5-1.3-4.5-1.3-4.5"
          />
          <path
            stroke="#032f53"
            d="M483.4 289a31.3 31.3 0 0 1-5.3-4.7 13.6 13.6 0 0 1-1.7-2.4c-.8-1.5-1.4-4.4-1.4-4.4"
          />
          <path
            stroke="#043258"
            d="M483.5 289c-2.1-1.3-4-3.5-5.3-4.8a10 10 0 0 1-1.6-2.4c-1-1.5-1.6-4.4-1.6-4.4"
          />
          <path
            stroke="#04345b"
            d="M483.6 289c-2.1-1.4-4-3.6-5.3-4.9a15.1 15.1 0 0 1-1.6-2.3 21.4 21.4 0 0 1-1.7-4.5"
          />
          <path
            stroke="#04365e"
            d="M483.6 289c-2-1.4-4-3.7-5.1-5a14 14 0 0 1-1.7-2.3c-1-1.7-1.8-4.5-1.8-4.5"
          />
          <path
            stroke="#043862"
            d="M483.7 289c-2-1.4-4-3.8-5.1-5a15 15 0 0 1-1.6-2.4 26 26 0 0 1-2-4.5"
          />
          <path
            stroke="#053b67"
            d="M483.8 289c-2-1.5-4-4-5-5.1a13.8 13.8 0 0 1-1.7-2.4c-1.1-1.8-2-4.5-2-4.5"
          />
          <path
            stroke="#053d6a"
            d="M483.9 289c-2-1.5-4-4-5-5.2a16.8 16.8 0 0 1-1.7-2.4c-1-1.8-2.1-4.5-2.1-4.5"
          />
          <path
            stroke="#053f6e"
            d="M484 289c-2-1.5-4-4.2-5-5.3a18.7 18.7 0 0 1-1.7-2.4l-2.2-4.4"
          />
          <path
            stroke="#064172"
            d="M484 289c-2-1.6-3.9-4.3-4.9-5.4a16.1 16.1 0 0 1-1.6-2.4l-2.4-4.4"
          />
          <path
            stroke="#00209f"
            d="M475 276.7s3 5.3 4.3 6.8c1 1 2.8 4 4.8 5.5"
          />
          <path stroke="#011d33" d="m475.2 290 10.2 6.6 2-3-1-2.7" />
          <path
            stroke="#011e34"
            d="m475.2 289.9 10.2 6.5h.1l1.7-3s0-.3-.3-.7l-.6-1.7"
          />
          <path
            stroke="#022037"
            d="M475.2 289.9c2.9 1.9 4.1 2.7 10.2 6.4l.1-.1 1.6-2.9-.2-.7a18.1 18.1 0 0 1-.6-1.6"
          />
          <path
            stroke="#022139"
            d="M475.2 289.9c2.8 1.8 4.3 2.8 10.2 6.3l.1-.1 1.5-2.9-.2-.7-.5-1.5"
          />
          <path
            stroke="#02223b"
            d="M475.2 289.8c2.7 1.8 4.5 2.9 10.2 6.3l.1-.2 1.4-2.8-.1-.7a8.2 8.2 0 0 1-.5-1.4"
          />
          <path
            stroke="#02233d"
            d="M475.3 289.8c2.5 1.7 4.6 3 10.1 6.1h.1c0-.3 1.3-2.9 1.3-3l-.1-.5a9.6 9.6 0 0 1-.4-1.5"
          />
          <path
            stroke="#022540"
            d="M475.3 289.8c2.4 1.6 4.7 3 10.2 6v-.1l1.2-2.8v-.6a5 5 0 0 1-.4-1.3"
          />
          <path
            stroke="#022541"
            d="M475.3 289.8c2.3 1.6 5 3 10.2 5.9v-.2l1.1-2.8v-.5a4.8 4.8 0 0 1-.4-1.3"
          />
          <path
            stroke="#022743"
            d="M475.3 289.8a110 110 0 0 0 10.2 5.8v-.2l1-2.8v-.5a4.1 4.1 0 0 1-.3-1.2"
          />
          <path
            stroke="#022847"
            d="M475.3 289.7a92.6 92.6 0 0 0 10.2 5.8v-.2c0-.3 1-2.8 1-2.8v-.5c-.3-.3-.3-.7-.3-1"
          />
          <path
            stroke="#022a49"
            d="M475.3 289.7a80.5 80.5 0 0 0 10.2 5.6.3.3 0 0 0 0-.1c0-.4.8-2.8.8-2.8s.2-.1 0-.4v-1"
          />
          <path
            stroke="#032a4a"
            d="M475.3 289.7a80 80 0 0 0 10.2 5.5v-.2l.7-2.7s.2-.1 0-.4v-1"
          />
          <path
            stroke="#032b4c"
            d="M475.4 289.7a67.8 67.8 0 0 0 10 5.4l.2-.2.5-2.7s.2-.1.1-.4c-.1-.3 0-.5 0-.8"
          />
          <path
            stroke="#032d4f"
            d="M475.4 289.7a62.4 62.4 0 0 0 10 5.3l.2-.2.4-2.8s.3 0 .2-.3c-.2-.3 0-.4 0-.7"
          />
          <path
            stroke="#032e50"
            d="M475.4 289.7c1.7 1 6 3.6 10.1 5.2v-.2l.4-2.7s.3 0 .2-.3c-.1-.3 0-.3.1-.7"
          />
          <path
            stroke="#032f53"
            d="M475.4 289.6a54.3 54.3 0 0 0 10.1 5.1.5.5 0 0 0 0-.2l.3-2.7.2-.2c-.1-.3 0-.3.2-.6"
          />
          <path
            stroke="#033156"
            d="M475.4 289.6c1.5 1 6.3 3.8 10.1 5a.5.5 0 0 0 0-.2l.2-2.7s.4 0 .3-.2c-.2-.3 0-.2.1-.6"
          />
          <path
            stroke="#043258"
            d="M475.4 289.6a45 45 0 0 0 10.1 4.9l.1-.2v-2.7s.4 0 .3-.2c-.1-.2.1-.1.3-.4"
          />
          <path
            stroke="#043359"
            d="M475.4 289.6c1.3.9 6.7 4 10.1 4.7l.1-.2-.1-2.6s.4 0 .3-.1c0-.3.2-.1.3-.4"
          />
          <path
            stroke="#04355c"
            d="M475.4 289.6c1.2.8 6.8 4 10.1 4.6l.1-.2-.3-2.6.5-.1c-.1-.3.2 0 .3-.4"
          />
          <path
            stroke="#04365e"
            d="M475.4 289.6c1.1.7 7 4 10.1 4.5l.1-.2c0-.7-.3-2.6-.4-2.6h.5c0-.3.2 0 .4-.3"
          />
          <path
            stroke="#043760"
            d="M475.4 289.6c1 .6 7.2 4.1 10.1 4.4l.1-.3c0-.6-.4-2.5-.5-2.6 0 0 .6.2.5 0 0-.1.3.2.5-.1"
          />
          <path
            stroke="#043862"
            d="M475.4 289.6c1 .5 7.3 4.2 10.1 4.3l.2-.3a12.5 12.5 0 0 0-.7-2.6s.6.2.5 0c0-.1.4.3.6 0"
          />
          <path
            stroke="#053a65"
            d="M475.5 289.5c.8.5 7.4 4.3 10 4.2l.2-.2c0-.8-.7-2.6-.8-2.6s.6.2.6 0c0 0 .3.4.6 0"
          />
          <path
            stroke="#053b67"
            d="M475.5 289.5c.7.5 7.6 4.4 10 4.1l.2-.3c0-.7-.8-2.4-.9-2.5l.6.1c0-.1.5.3.7 0"
          />
          <path
            stroke="#053c68"
            d="M475.5 289.5c.6.4 7.8 4.4 10 4l.2-.3a6 6 0 0 0-1-2.5l.7.1c0-.1.4.4.7.1"
          />
          <path
            stroke="#053e6c"
            d="M475.5 289.5c.5.3 8 4.5 10 3.9a.5.5 0 0 0 .2-.3c0-.8-1-2.5-1.1-2.5l.7.1s.5.6.8.3"
          />
          <path
            stroke="#053f6e"
            d="M475.5 289.5c.4.2 8 4.6 10 3.8l.2-.4c0-.8-1.1-2.4-1.2-2.5l.7.3s.6.6.9.2"
          />
          <path
            stroke="#053f6f"
            d="M475.5 289.5c.3.2 8.2 4.6 10 3.6l.2-.3c0-.9-1.2-2.4-1.3-2.5l.7.3s.6.6 1 .4"
          />
          <path
            stroke="#064171"
            d="M475.5 289.4c.2.2 8.4 4.8 10 3.6a.7.7 0 0 0 .2-.3c0-1-1.3-2.4-1.4-2.5l.8.3s.6.7 1 .4"
          />
          <path
            stroke="#064374"
            d="M475.5 289.4c.1 0 8.6 4.9 10 3.5l.2-.3c0-1-1.4-2.4-1.6-2.5l1 .3s.6.8 1 .6"
          />
          <path
            stroke="#00209f"
            d="M475.6 289.4s9.7 5.5 10.1 3c0-1-1.6-2.4-1.6-2.4l.9.3s.6 1 1 .6"
          />
          <path
            stroke="#011d33"
            d="m474.4 315.1-7.5 12.6a5.2 5.2 0 0 1-1.8-2.2c-.6-1.7-.5-1.7-1-3.6l-.4-3.4c-.3-1.2-1.9-4.8-2-6.2"
          />
          <path
            stroke="#011d33"
            d="M461.8 312.3c0 1.4 1.6 5 1.9 6 .2 1.2.2 2.4.5 3.5.4 1.9.3 1.8 1 3.6a5.2 5.2 0 0 0 1.7 2.2l7.5-12.5"
          />
          <path
            stroke="#011e34"
            d="M461.8 312.3c0 1.4 1.6 5 1.8 6 .3 1.2.3 2.3.6 3.4.4 1.8.3 1.8 1 3.6.2.8 1.2 1.8 1.7 2.1l7.5-12.3"
          />
          <path
            stroke="#011e34"
            d="M461.8 312.3c0 1.4 1.6 4.9 1.8 6 .3 1 .3 2.2.6 3.3.4 1.8.3 1.8 1 3.5a5.5 5.5 0 0 0 1.7 2.2l7.5-12.2"
          />
          <path
            stroke="#011f36"
            d="M461.8 312.3c0 1.3 1.6 4.8 1.8 5.9.3 1.1.3 2.3.6 3.3.4 1.8.3 1.8 1 3.5a5.5 5.5 0 0 0 1.7 2.1l7.5-12"
          />
          <path
            stroke="#011f36"
            d="M461.8 312.3c0 1.3 1.6 4.8 1.8 5.9.3 1 .3 2.2.6 3.3.4 1.7.3 1.7 1 3.4.2.8 1.2 1.8 1.7 2.1l7.5-11.9"
          />
          <path
            stroke="#022037"
            d="M461.8 312.3c0 1.3 1.5 4.7 1.8 5.8.3 1 .3 2.2.6 3.3.4 1.7.3 1.7 1 3.4.2.8 1.2 1.7 1.7 2 .2.1 7.4-11.6 7.5-11.7"
          />
          <path
            stroke="#022037"
            d="M461.8 312.3c0 1.3 1.5 4.6 1.8 5.7l.6 3.3c.4 1.7.4 1.7 1 3.3.2.8 1.2 1.8 1.7 2.1.2 0 7.3-11.5 7.5-11.6"
          />
          <path
            stroke="#022139"
            d="M461.8 312.3c0 1.3 1.5 4.6 1.8 5.7.3 1 .3 2.2.6 3.2.4 1.7.4 1.7 1 3.3.3.8 1.2 1.7 1.7 2 .2.1 7.3-11.3 7.5-11.4"
          />
          <path
            stroke="#022139"
            d="M461.8 312.3c0 1.3 1.5 4.6 1.8 5.6.3 1 .3 2.2.6 3.2.4 1.7.4 1.7 1 3.3a5.4 5.4 0 0 0 1.7 2c.3 0 7.3-11.2 7.5-11.3"
          />
          <path
            stroke="#022139"
            d="M461.8 312.3c0 1.3 1.5 4.5 1.8 5.6.3 1 .3 2 .6 3.1.5 1.7.4 1.7 1 3.3.3.8 1.2 1.7 1.7 2 .3 0 7.2-11 7.5-11.2"
          />
          <path
            stroke="#02223b"
            d="M461.8 312.3c0 1.3 1.5 4.4 1.8 5.5.3 1 .3 2.1.6 3 .5 1.8.4 1.8 1 3.3a5 5 0 0 0 1.7 2c.3.1 7.2-10.9 7.5-11"
          />
          <path
            stroke="#02223b"
            d="M461.8 312.3c0 1.2 1.5 4.4 1.8 5.4.3 1 .3 2.2.6 3.1.5 1.7.4 1.7 1 3.2a5.2 5.2 0 0 0 1.7 2c.3.1 7.2-10.8 7.5-10.9"
          />
          <path
            stroke="#02233d"
            d="M461.8 312.3c0 1.2 1.5 4.3 1.8 5.4l.6 3c.5 1.7.4 1.7 1 3.2a5.1 5.1 0 0 0 1.8 2c.3 0 7-10.6 7.4-10.8"
          />
          <path
            stroke="#02233d"
            d="M461.8 312.3c0 1.2 1.4 4.3 1.8 5.3l.6 3 1 3.2a7 7 0 0 0 1.8 2c.3 0 7-10.6 7.4-10.7"
          />
          <path
            stroke="#02233e"
            d="M461.8 312.3c0 1.2 1.4 4.3 1.8 5.3l.6 3 1 3a6 6 0 0 0 1.8 2c.3.1 7-10.3 7.4-10.5"
          />
          <path
            stroke="#02233e"
            d="M461.8 312.3c0 1.1 1.4 4.2 1.8 5.2l.6 3 1 3a5 5 0 0 0 1.8 2c.4 0 7-10.3 7.4-10.4"
          />
          <path
            stroke="#022540"
            d="M461.8 312.2c0 1.2 1.4 4.2 1.8 5.3l.6 2.9 1 3a5.2 5.2 0 0 0 1.8 2c.4 0 7-10.1 7.4-10.3"
          />
          <path
            stroke="#022540"
            d="M461.8 312.2c0 1.2 1.4 4.2 1.8 5.2l.6 2.9 1 3c.4.7 1.3 1.5 1.8 1.8.4.2 7-9.8 7.4-10"
          />
          <path
            stroke="#022540"
            d="M461.8 312.2c0 1.2 1.4 4.1 1.8 5.1l.7 2.9c.4 1.5.4 1.6 1 3a5 5 0 0 0 1.7 1.8c.4.1 7-9.7 7.4-9.9"
          />
          <path
            stroke="#022541"
            d="M461.8 312.2c0 1.2 1.4 4 1.8 5l.7 3 1 2.9a5.2 5.2 0 0 0 1.7 1.8c.4.1 6.9-9.6 7.4-9.8"
          />
          <path
            stroke="#022541"
            d="M461.8 312.2c0 1.1 1.4 4 1.8 5l.7 2.8 1 3c.3.6 1.2 1.5 1.7 1.8.5 0 6.9-9.5 7.4-9.7"
          />
          <path
            stroke="#022743"
            d="M461.8 312.2c0 1.1 1.4 4 1.8 5l.7 2.7c.4 1.5.5 1.5 1 2.9a6 6 0 0 0 1.7 1.8c.5.1 6.8-9.3 7.4-9.5"
          />
          <path
            stroke="#022743"
            d="M461.8 312.2c0 1.1 1.4 4 1.8 5l.7 2.6 1 3a5 5 0 0 0 1.7 1.6c.5.2 6.8-9 7.4-9.3"
          />
          <path
            stroke="#022845"
            d="M461.8 312.2c0 1.1 1.4 3.9 1.8 4.8l.7 2.8 1 2.8a4.9 4.9 0 0 0 1.7 1.7c.6.2 6.8-9 7.4-9.2"
          />
          <path
            stroke="#022845"
            d="M461.8 312.2c0 1.1 1.4 3.8 1.8 4.8l.7 2.7c.4 1.4.5 1.4 1 2.7a5.3 5.3 0 0 0 1.7 1.8c.6.2 6.7-8.9 7.4-9"
          />
          <path
            stroke="#022847"
            d="M461.8 312.2c0 1 1.3 3.7 1.8 4.7l.7 2.7 1 2.7a4.8 4.8 0 0 0 1.7 1.7c.6.2 6.7-8.7 7.4-8.9"
          />
          <path
            stroke="#022847"
            d="M461.8 312.2c0 1 1.3 3.7 1.8 4.6l.7 2.7 1.1 2.7a5 5 0 0 0 1.6 1.7c.7.2 6.7-8.6 7.4-8.8"
          />
          <path
            stroke="#022847"
            d="M461.8 312.2c0 1 1.3 3.7 1.8 4.6l.7 2.6 1.1 2.7a5 5 0 0 0 1.6 1.7c.7.1 6.7-8.4 7.4-8.7"
          />
          <path
            stroke="#022a49"
            d="M461.8 312.2c0 1 1.3 3.6 1.8 4.6l.7 2.5 1.1 2.7c.4.6 1.1 1.3 1.7 1.6.6.2 6.6-8.2 7.3-8.5"
          />
          <path
            stroke="#022a49"
            d="M461.8 312.2c0 1 1.3 3.5 1.8 4.5l.7 2.5 1.1 2.6c.4.6 1.1 1.4 1.7 1.6.7.3 6.5-8 7.3-8.3"
          />
          <path
            stroke="#032a4a"
            d="M461.8 312.2c0 1 1.3 3.5 1.8 4.4l.7 2.5c.5 1.3.5 1.4 1.2 2.6.3.6 1 1.4 1.6 1.6.7.2 6.5-8 7.3-8.2"
          />
          <path
            stroke="#032a4a"
            d="M461.8 312.2c0 1 1.3 3.4 1.7 4.4l.8 2.4 1.2 2.6a5 5 0 0 0 1.6 1.6c.7.2 6.5-7.8 7.3-8.1"
          />
          <path
            stroke="#032b4c"
            d="M461.8 312.2c0 1 1.2 3.4 1.7 4.3.4.8.5 1.7.8 2.4l1.2 2.6c.3.6 1 1.2 1.6 1.5.7.3 6.4-7.6 7.3-8"
          />
          <path
            stroke="#032b4c"
            d="M461.8 312.2c0 1 1.2 3.3 1.7 4.3.4.7.5 1.6.8 2.3l1.2 2.6c.3.5 1 1.2 1.6 1.5.8.2 6.4-7.5 7.3-7.8"
          />
          <path
            stroke="#032c4d"
            d="M461.8 312.2c0 1 1.2 3.3 1.7 4.2.4.8.5 1.6.8 2.4l1.2 2.4c.3.6 1 1.3 1.6 1.6.8.2 6.4-7.4 7.3-7.7"
          />
          <path
            stroke="#032c4d"
            d="M461.8 312.2c0 .9 1.2 3.2 1.7 4.1l.9 2.4c.4 1.2.5 1.3 1.1 2.4a5.2 5.2 0 0 0 1.6 1.5c.8.3 6.3-7.2 7.3-7.5"
          />
          <path
            stroke="#032c4d"
            d="M461.8 312.2a13 13 0 0 0 1.7 4l.9 2.4c.4 1.2.5 1.2 1.1 2.4a4.7 4.7 0 0 0 1.6 1.4c.9.4 6.3-7 7.3-7.3"
          />
          <path
            stroke="#032d4f"
            d="M461.8 312.2c0 .9 1.2 3.1 1.7 4 .4.8.5 1.6.9 2.3.4 1.2.5 1.3 1.1 2.3.3.6 1 1.3 1.6 1.5.9.3 6.3-6.8 7.3-7.2"
          />
          <path
            stroke="#032d4f"
            d="M461.8 312.2c0 .8 1.2 3 1.7 4 .4.7.5 1.5.9 2.2.4 1.2.6 1.2 1.1 2.4a5 5 0 0 0 1.6 1.4c1 .3 6.3-6.7 7.3-7.1"
          />
          <path
            stroke="#032e50"
            d="M461.8 312.2c0 .8 1.2 3 1.7 4 .4.6.5 1.4.9 2.1.4 1.2.6 1.2 1.1 2.3a5.4 5.4 0 0 0 1.6 1.5c1 .2 6.3-6.6 7.3-7"
          />
          <path
            stroke="#032e50"
            d="M461.8 312.2c0 .8 1.1 3 1.7 3.8.4.8.5 1.5.9 2.2.4 1.2.6 1.3 1.1 2.3a4.8 4.8 0 0 0 1.6 1.4c1 .3 6.2-6.4 7.3-6.8"
          />
          <path
            stroke="#032f53"
            d="M461.8 312.2c0 .8 1.1 3 1.7 3.8.4.7.5 1.5.9 2.1.4 1.1.6 1.2 1.2 2.3a5 5 0 0 0 1.5 1.4c1 .3 6.2-6.3 7.3-6.7"
          />
          <path
            stroke="#032f53"
            d="M461.8 312.2a11 11 0 0 0 1.7 3.7c.4.7.5 1.5.9 2.2l1.2 2.1a5 5 0 0 0 1.5 1.4c1 .3 6.2-6 7.3-6.5"
          />
          <path
            stroke="#033054"
            d="M461.8 312.2a12 12 0 0 0 1.7 3.7c.4.6.5 1.4.9 2l1.2 2.2a5.1 5.1 0 0 0 1.6 1.4c1 .3 6-6 7.2-6.4"
          />
          <path
            stroke="#033054"
            d="M461.8 312.2c0 .7 1 2.7 1.7 3.6.4.7.5 1.4 1 2l1 2.2a4.5 4.5 0 0 0 1.7 1.3c1 .4 6-5.8 7.2-6.2"
          />
          <path
            stroke="#033054"
            d="M461.8 312.2c0 .7 1 2.7 1.7 3.6l1 2c.4 1 .6 1.1 1.1 2a5.4 5.4 0 0 0 1.6 1.4c1 .3 6-5.7 7.2-6.1"
          />
          <path
            stroke="#033156"
            d="M461.8 312.2c0 .7 1 2.7 1.7 3.5l1 2c.3 1 .6 1.1 1.1 2a5.4 5.4 0 0 0 1.5 1.4c1.1.3 6-5.6 7.3-6"
          />
          <path
            stroke="#033156"
            d="M461.8 312.2c0 .7 1 2.6 1.7 3.4l1 2c.3 1 .6 1.1 1.1 2a5.4 5.4 0 0 0 1.5 1.3c1.2.3 6-5.3 7.3-5.8"
          />
          <path
            stroke="#043258"
            d="M461.8 312.2c0 .7 1 2.6 1.7 3.4l1 1.9c.3 1 .6 1 1.2 2 .3.5 1 1 1.4 1.3 1.2.3 6-5.2 7.3-5.7"
          />
          <path
            stroke="#043258"
            d="M461.8 312.2a8 8 0 0 0 1.7 3.3l1 2c.3.9.6 1 1.2 2 .3.4 1 1 1.4 1.1 1.2.4 6-5 7.3-5.5"
          />
          <path
            stroke="#043359"
            d="M461.8 312.2c0 .6 1 2.4 1.7 3.3l1 1.8c.4 1 .6 1.1 1.2 2 .3.5 1 1 1.4 1.2 1.3.3 6-5 7.3-5.4"
          />
          <path
            stroke="#043359"
            d="M461.8 312.2c0 .6 1 2.4 1.7 3.2l1 1.9c.4.8.6 1 1.2 1.8.4.5 1 1 1.5 1.2 1.2.4 5.8-4.7 7.2-5.2"
          />
          <path
            stroke="#04345b"
            d="M461.8 312.2c0 .6 1 2.4 1.7 3.1l1 1.9c.4.9.7 1 1.2 1.8.4.5 1 1 1.5 1.2 1.2.4 5.8-4.6 7.2-5.1"
          />
          <path
            stroke="#04345b"
            d="M461.8 312.2c0 .6 1 2.3 1.7 3l1 1.9c.4.8.7 1 1.2 1.8.4.5 1 1 1.5 1.2 1.3.4 5.8-4.5 7.2-5"
          />
          <path
            stroke="#04345b"
            d="M461.8 312.2c0 .6 1 2.2 1.7 3l1 1.8c.4.9.7 1 1.2 1.8.4.4 1 1 1.5 1.1 1.3.4 5.8-4.3 7.2-4.8"
          />
          <path
            stroke="#04355c"
            d="M461.8 312.2c0 .5 1 2.2 1.7 3l1 1.7c.4.8.7 1 1.2 1.8.4.4 1 .9 1.5 1 1.3.5 5.7-4.1 7.2-4.6"
          />
          <path
            stroke="#04355c"
            d="M461.8 312.2c0 .5 1 2.1 1.7 3l1 1.6c.4.8.7 1 1.3 1.7.3.5 1 1 1.4 1.1 1.3.5 5.7-4 7.2-4.5"
          />
          <path
            stroke="#04365e"
            d="M461.8 312.2c0 .5 1 2.1 1.7 2.9l1 1.6c.4.9.7 1 1.3 1.7.3.5 1 .9 1.4 1.1 1.4.4 5.7-3.9 7.2-4.4"
          />
          <path
            stroke="#04365e"
            d="M461.8 312.2c0 .5 1 2 1.7 2.8l1 1.6c.4.8.7 1 1.3 1.7.3.4 1 .9 1.4 1 1.4.5 5.6-3.7 7.2-4.2"
          />
          <path
            stroke="#043760"
            d="M461.8 312.2c0 .5 1 2 1.7 2.8l1 1.5c.4.8.7 1 1.3 1.7.3.4 1 .8 1.4 1 1.4.4 5.6-3.6 7.2-4.1"
          />
          <path
            stroke="#043760"
            d="M461.8 312.2c0 .5 1 2 1.7 2.7l1 1.6c.4.7.7.8 1.3 1.6.3.4 1 .8 1.4 1 1.5.4 5.6-3.5 7.2-4"
          />
          <path
            stroke="#043862"
            d="M461.8 312.2c0 .5 1 1.9 1.7 2.6l1 1.6c.4.7.7.9 1.3 1.5.3.4 1 .8 1.4 1 1.5.5 5.5-3.3 7.2-3.9"
          />
          <path
            stroke="#043862"
            d="M461.8 312.2c0 .4 1 1.8 1.7 2.6l1 1.5c.4.7.7.9 1.3 1.5l1.4 1c1.5.4 5.5-3.2 7.2-3.8"
          />
          <path
            stroke="#043862"
            d="M461.8 312.2c0 .4.9 1.8 1.7 2.5l1 1.5c.4.7.8.8 1.3 1.5l1.4 1c1.5.4 5.5-3 7.2-3.7"
          />
          <path
            stroke="#043963"
            d="M461.8 312.2c0 .4.9 1.7 1.7 2.4l1 1.5c.4.7.8.8 1.3 1.5l1.4.9c1.5.5 5.5-2.8 7.2-3.5"
          />
          <path
            stroke="#043963"
            d="M461.8 312.2c0 .4.9 1.7 1.7 2.4l1 1.4c.4.7.8.8 1.3 1.5l1.4.9c1.6.5 5.5-2.7 7.2-3.4"
          />
          <path
            stroke="#053a65"
            d="M461.8 312.2c0 .4.9 1.6 1.7 2.3l1 1.4 1.3 1.4 1.4 1c1.6.4 5.4-2.6 7.2-3.3"
          />
          <path
            stroke="#053a65"
            d="M461.8 312.2c0 .3.8 1.6 1.7 2.3l1 1.3c.5.7.8.8 1.4 1.4.3.4.9.7 1.4.9 1.6.5 5.3-2.4 7.1-3"
          />
          <path
            stroke="#053b67"
            d="M461.8 312.2c0 .3.8 1.5 1.7 2.2l1 1.3 1.4 1.4c.4.3.9.7 1.4.8 1.6.5 5.3-2.2 7.1-2.9"
          />
          <path
            stroke="#053b67"
            d="M461.8 312.2c0 .3.8 1.5 1.7 2.1.3.5.6 1 1 1.3.5.7.8.8 1.4 1.4l1.4.8c1.6.5 5.2-2 7.1-2.8"
          />
          <path
            stroke="#053c68"
            d="M461.8 312.2c0 .3.8 1.4 1.7 2.1l1 1.3 1.4 1.3c.4.3.9.6 1.4.7 1.7.6 5.2-1.9 7.1-2.6"
          />
          <path
            stroke="#053c68"
            d="M461.8 312.2c0 .3.8 1.4 1.7 2l1 1.3 1.4 1.2 1.4.8c1.7.5 5.2-1.8 7.1-2.5"
          />
          <path
            stroke="#053c68"
            d="M461.8 312.2a6 6 0 0 0 1.7 2l1 1.2 1.4 1.2a6 6 0 0 0 1.4.8c1.7.5 5.1-1.7 7.1-2.4"
          />
          <path
            stroke="#053d6a"
            d="M461.8 312.2c0 .2.8 1.2 1.7 2l1 1 1.4 1.3a6 6 0 0 0 1.4.8c1.8.5 5.1-1.5 7.1-2.3"
          />
          <path
            stroke="#053d6a"
            d="M461.8 312.2a6 6 0 0 0 1.7 1.9l1 1.1 1.4 1.1 1.4.8c1.8.5 5.1-1.3 7.1-2"
          />
          <path
            stroke="#053e6c"
            d="M461.8 312.2c0 .2.7 1.1 1.7 1.8l1 1.1c.5.5 1 .7 1.5 1.1l1.3.8c1.8.5 5.1-1.2 7.1-2"
          />
          <path
            stroke="#053e6c"
            d="M461.8 312.2c0 .2.7 1.1 1.6 1.8l1.1 1c.5.5 1 .7 1.5 1.1l1.3.7c1.8.6 5-1 7.1-1.8"
          />
          <path
            stroke="#053f6e"
            d="M461.8 312.2c0 .1.7 1 1.6 1.7l1.1 1c.5.5 1 .7 1.5 1 .4.4.8.6 1.3.8 1.8.6 5-1 7.1-1.7"
          />
          <path
            stroke="#053f6e"
            d="M461.8 312.2c0 .1.7 1 1.6 1.6a14.2 14.2 0 0 0 1.2 1c.4.5.9.7 1.4 1 .4.3.9.6 1.3.7 1.9.6 5-.7 7.1-1.5"
          />
          <path
            stroke="#053f6f"
            d="M461.8 312.2c0 .1.7 1 1.6 1.6l1.2 1 1.4 1 1.3.6c2 .5 5-.6 7.1-1.4"
          />
          <path
            stroke="#053f6f"
            d="M461.8 312.2c0 .1.7.9 1.6 1.5l1.2 1 1.4 1 1.3.6c2 .5 5-.5 7.1-1.3"
          />
          <path
            stroke="#053f6f"
            d="M461.8 312.2c0 .1.7.8 1.6 1.5l1.2.9 1.4 1 1.3.5c2 .6 5-.3 7.1-1"
          />
          <path
            stroke="#064171"
            d="M461.8 312.2s.7.8 1.6 1.4l1.2.9 1.5.9 1.2.6c2 .6 4.9-.2 7.1-1"
          />
          <path
            stroke="#064171"
            d="m461.8 312.2 1.6 1.4 1.2.8 1.5.9 1.3.5c2 .6 4.8 0 7-.8"
          />
          <path
            stroke="#064172"
            d="M461.8 312.2s.7.7 1.6 1.3l1.2.8 1.5.8 1.3.6c2 .6 4.7.2 7-.7"
          />
          <path
            stroke="#064172"
            d="M461.8 312.1c0 .1.7.7 1.6 1.3l1.2.8 1.5.8 1.3.6c2 .6 4.7.3 7-.6"
          />
          <path
            stroke="#064374"
            d="M461.8 312.1c0 .1.6.7 1.6 1.3l1.2.7a12.7 12.7 0 0 0 2.8 1.3c2 .6 4.7.5 7-.4"
          />
          <path
            stroke="#064374"
            d="M461.8 312.1s.6.6 1.6 1.2l1.2.7a15.7 15.7 0 0 0 2.8 1.3c2 .6 4.7.6 7-.3"
          />
          <path
            stroke="#00209f"
            d="m461.8 312.1 1.6 1.2 1.2.7 1.5.6a12 12 0 0 0 8.3.4m-12.6-2.9s6.5 5.1 12.6 3"
          />
          <path
            stroke="#022743"
            d="M461.6 292.2s1.2 8 1.7 9.3c.4 1 3 5.6 6.9 6.7"
          />
          <path
            stroke="#022a49"
            d="M461.6 292.2s1.3 8 1.8 9.2c.5 1 2.8 5.4 6.8 6.8"
          />
          <path
            stroke="#032b4c"
            d="M461.6 292.1s1.4 8 1.9 9.2a14 14 0 0 0 6.7 6.9"
          />
          <path
            stroke="#032e50"
            d="M461.6 292.1s1.5 8 2 9.1c.5 1 2.5 5 6.6 7"
          />
          <path
            stroke="#033054"
            d="M461.6 292.1s1.6 7.9 2 9a15.2 15.2 0 0 0 6.7 7"
          />
          <path
            stroke="#043359"
            d="M461.6 292.1s1.6 7.8 2.2 9a15.8 15.8 0 0 0 6.5 7"
          />
          <path
            stroke="#04355c"
            d="M461.6 292s1.7 7.8 2.3 9c.5 1.1 2 4.3 6.4 7"
          />
          <path
            stroke="#043760"
            d="M461.7 292s1.7 7.8 2.3 9c.5 1 1.9 4 6.3 7"
          />
          <path
            stroke="#053a65"
            d="M461.7 292s1.8 7.7 2.4 8.9c.5 1 1.7 3.8 6.2 7.1"
          />
          <path
            stroke="#053c68"
            d="M461.7 292s1.9 7.7 2.5 8.8c.6 1.1 1.6 3.5 6.1 7.2"
          />
          <path
            stroke="#053f6e"
            d="M461.7 292s2 7.6 2.6 8.8c.5 1 1.4 3.2 6 7.2"
          />
          <path
            stroke="#064172"
            d="M461.8 292s2 7.5 2.6 8.7c.6 1.1 1.3 3 6 7.2"
          />
          <path
            stroke="#00209f"
            d="M461.8 292s2.1 7.5 2.7 8.6c.6 1.1 1.1 2.8 5.9 7.3"
          />
          <path stroke="#022743" d="M462 287.2s1.1 11.4 9.3 14.6" />
          <path
            stroke="#022a49"
            d="M462 287.2c.1 0 .5 3.7 2.2 7.2 1.3 2.8 3.5 5.9 7 7.4"
          />
          <path
            stroke="#032b4c"
            d="M462.1 287.2s.5 3.8 2.2 7.2a15 15 0 0 0 7 7.4"
          />
          <path
            stroke="#032e50"
            d="M462.1 287.2s.7 3.9 2.3 7.1c1.1 2.3 3.3 5.7 6.9 7.4"
          />
          <path
            stroke="#033054"
            d="M462.2 287.2s.7 4 2.3 7c1 2.2 3.2 5.7 6.8 7.5"
          />
          <path
            stroke="#043359"
            d="M462.2 287.2c0 .1.8 4 2.4 7 1 2 3.1 5.6 6.7 7.5"
          />
          <path
            stroke="#04355c"
            d="M462.2 287.2c0 .1 1 4.2 2.5 7a18 18 0 0 0 6.6 7.4"
          />
          <path
            stroke="#043760"
            d="M462.2 287.1c0 .3 1 4.4 2.6 7 .8 1.5 3 5.4 6.5 7.5"
          />
          <path
            stroke="#053a65"
            d="M462.2 287.1a30 30 0 0 0 2.6 6.9c.8 1.4 3 5.4 6.5 7.5"
          />
          <path
            stroke="#053c68"
            d="M462.3 287.1c0 .3 1.2 4.5 2.6 6.8.7 1.3 2.8 5.4 6.4 7.7"
          />
          <path
            stroke="#053f6e"
            d="M462.3 287.1a30 30 0 0 0 2.8 6.8c.6 1 2.6 5.2 6.2 7.6"
          />
          <path
            stroke="#064172"
            d="M462.3 287.1a31 31 0 0 0 2.9 6.7c.5.8 2.5 5.2 6 7.7"
          />
          <path
            stroke="#00209f"
            d="M462.3 287.1c0 .3 1.6 4.9 3 6.6.4.7 2.4 5.2 6 7.8"
          />
          <path stroke="#022743" d="M462.2 284s2.4 9.2 9 11.5" />
          <path
            stroke="#022847"
            d="M462.2 284s.9 3.3 3 6.4c1.5 2.2 3.6 4.2 6 5"
          />
          <path
            stroke="#032a4a"
            d="M462.2 284s1 3.2 3 6.4c1.6 2.1 3.7 4.3 6 5"
          />
          <path
            stroke="#032c4d"
            d="M462.2 284s1 3.1 3.2 6.3c1.5 2.2 3.7 4.4 5.8 5.1"
          />
          <path
            stroke="#032f53"
            d="M462.2 283.9s1 3.1 3.3 6.3a15 15 0 0 0 5.7 5.2"
          />
          <path
            stroke="#033156"
            d="M462.2 283.9s1 3 3.3 6.2c1.7 2.3 4 4.7 5.7 5.3"
          />
          <path
            stroke="#043359"
            d="M462.2 283.8s1 3 3.4 6.2a17 17 0 0 0 5.6 5.4"
          />
          <path stroke="#04355c" d="M462.2 283.8a27.1 27.1 0 0 0 9 11.6" />
          <path
            stroke="#043760"
            d="M462.3 283.8s1 2.9 3.5 6.1a21 21 0 0 0 5.4 5.4"
          />
          <path
            stroke="#043963"
            d="M462.3 283.8s1 2.8 3.5 6a23 23 0 0 0 5.4 5.5"
          />
          <path
            stroke="#053b67"
            d="M462.3 283.7s1.1 2.8 3.6 6a28 28 0 0 0 5.3 5.6"
          />
          <path
            stroke="#053e6c"
            d="M462.3 283.7s1.2 2.7 3.7 6a39 39 0 0 0 5.2 5.6"
          />
          <path
            stroke="#053f6f"
            d="M462.3 283.7s1.2 2.7 3.8 5.9a44 44 0 0 0 5.1 5.7"
          />
          <path
            stroke="#064172"
            d="M462.3 283.6s1.3 2.7 3.9 6c2 2.5 4.9 5.6 5 5.7"
          />
          <path
            stroke="#00209f"
            d="M462.3 283.6s1.3 2.6 3.9 5.8c2.1 2.7 5 5.9 5 5.9m8.7 1.3 4.6.8m-4.1 2.6 4-1.7"
          />
          <path stroke="#064171" d="m479.9 296.7 4.5.7" />
          <path stroke="#053e6c" d="m479.9 296.9 4.6.5" />
          <path stroke="#053b67" d="m479.9 297 4.6.4" />
          <path stroke="#043862" d="m479.9 297.2 4.7.3" />
          <path stroke="#04355c" d="M479.9 297.4h4.7" />
          <path stroke="#043258" d="M480 297.6h4.6" />
          <path stroke="#032f53" d="m480 297.7 4.7-.2" />
          <path stroke="#032c4d" d="m480 297.9 4.7-.3" />
          <path stroke="#022a49" d="m480 298 4.8-.5" />
          <path stroke="#064171" d="m480.3 299.8 4.2-1.6" />
          <path stroke="#053e6c" d="m480.3 299.6 4.3-1.5" />
          <path stroke="#053b67" d="m480.3 299.5 4.3-1.4" />
          <path stroke="#043862" d="m480.3 299.3 4.3-1.3" />
          <path stroke="#04355c" d="m480.2 299.1 4.5-1.2" />
          <path stroke="#043258" d="m480.2 299 4.5-1.2" />
          <path stroke="#032f53" d="m480.2 298.7 4.6-.9" />
          <path stroke="#032c4d" d="m480.1 298.6 4.7-.9" />
          <path stroke="#022a49" d="m480.1 298.4 4.7-.7" />
          <path stroke="#022743" d="m480 298.2 4.9-.6" />
          <path stroke="#032b4c" d="m484.2 331.6-2.6.2-9.9-.2" />
          <path stroke="#032e50" d="m484.3 331.6-2.7.3-9.8-.2" />
          <path stroke="#033054" d="m484.3 331.6-2.8.4c-.5.1-9.6-.3-9.6-.3" />
          <path stroke="#043359" d="m484.3 331.7-2.8.5c-.7.1-9.6-.5-9.6-.5" />
          <path stroke="#04355c" d="m484.3 331.7-3 .6c-.7.2-9.3-.5-9.3-.5" />
          <path stroke="#043760" d="m484.3 331.7-3 .7c-.8.3-9.2-.6-9.2-.6" />
          <path stroke="#053a65" d="m484.4 331.8-3.1.8c-1 .2-9.1-.7-9.1-.7" />
          <path stroke="#053c68" d="m484.4 331.8-3.1 1c-1.2.2-9-.8-9-.8" />
          <path stroke="#053f6e" d="m484.4 331.9-3.2 1c-1.2.3-8.9-.9-8.9-.9" />
          <path
            stroke="#064172"
            d="M484.4 332s-1.8.7-3.2 1c-1.4.3-8.8-1-8.8-1"
          />
          <path
            stroke="#00209f"
            d="M472.5 332s7.1 1.4 8.6 1.1c1.5-.3 3.3-1.1 3.3-1.1"
          />
          <path stroke="#022a49" d="m486 337 4.8.7 2.7-.2 2.2-.5" />
          <path stroke="#032d4f" d="M485.8 337s4.7.7 5 .6l2.7-.1 2-.5" />
          <path stroke="#033054" d="M485.5 336.9s4.9.8 5.3.7l2.6-.2 2-.4" />
          <path
            stroke="#043359"
            d="M485.3 336.7s4.9.9 5.6.8a56.9 56.9 0 0 1 2.5-.2l1.7-.3"
          />
          <path stroke="#043760" d="M485 336.6s5 1 5.9.8l2.5-.2 1.5-.3" />
          <path stroke="#053a65" d="M484.8 336.5s5.1 1 6.1.8l2.4-.2 1.4-.2" />
          <path
            stroke="#053d6a"
            d="M484.5 336.4s5.3 1 6.4.9c.7-.2 2-.3 2.4-.3a24.4 24.4 0 0 0 1.2-.2"
          />
          <path
            stroke="#064171"
            d="M484.2 336.3s5.4 1.1 6.8.9c.7-.2 1.7-.3 2.2-.3h1.1"
          />
          <path stroke="#022743" d="m486.3 337.2 4.4.6 2.9-.1 2.4-.6" />
          <path
            stroke="#00209f"
            d="M484 336.2s5.5 1.2 7 .9c1.5-.3 3-.3 3-.3m11.8 0 4.3-1.6c2.6-1 3-3.6 3-3.6"
          />
          <path
            stroke="#00209f"
            d="m505.5 336 3.1-1.3c3.8-1.4 3.4-3.2 3.4-3.2"
          />
          <path
            stroke="#053e6c"
            d="m505.2 336.1 3.4-1.3 1.8-.8c.5-.3 1.2-1 1.3-1.2.4-.5.4-1.3.4-1.3"
          />
          <path
            stroke="#043862"
            d="m505 336.3 3.6-1.4 1.8-.7 1.4-1.2c.3-.5.4-1.5.4-1.5"
          />
          <path
            stroke="#043258"
            d="m504.7 336.5 4-1.5 1.6-.7a6 6 0 0 0 1.5-1.2c.2-.3.5-1.6.5-1.6"
          />
          <path
            stroke="#032c4d"
            d="m504.4 336.7 4.2-1.5 1.7-.7 1.6-1.3.6-1.6"
          />
          <path
            stroke="#053e6c"
            d="m505.5 336.9 4.6-1.8c.8-.3 1.7-1 2-1.5.6-.9.9-2 .9-2"
          />
          <path
            stroke="#043862"
            d="m505.1 336.9 5-2c.6-.1 1.7-1 2-1.4.4-.6.7-2 .7-2"
          />
          <path
            stroke="#043258"
            d="m504.8 336.9 5.4-2a8.1 8.1 0 0 0 1.9-1.4c.3-.5.6-2 .6-2"
          />
          <path stroke="#032c4d" d="m504.5 336.9 5.7-2.1 1.8-1.4.7-1.8" />
          <path stroke="#022743" d="m504.2 336.9 6-2.3 1.7-1.2.6-1.8" />
          <path stroke="#032b4c" d="m511.3 331.6-2.8.2-10.3-.2" />
          <path stroke="#032e50" d="m511.3 331.6-2.8.3-10.2-.2" />
          <path stroke="#033054" d="m511.3 331.6-2.9.4c-.5.1-10-.3-10-.3" />
          <path stroke="#043359" d="m511.3 331.7-3 .5c-.6.1-9.8-.5-9.8-.5" />
          <path stroke="#04355c" d="m511.4 331.7-3 .6c-.9.2-9.8-.5-9.8-.5" />
          <path stroke="#043760" d="m511.4 331.7-3.1.7c-1 .3-9.7-.6-9.7-.6" />
          <path stroke="#053a65" d="m511.4 331.8-3.2.8c-1 .2-9.5-.7-9.5-.7" />
          <path stroke="#053c68" d="m511.4 331.8-3.3 1c-1.1.2-9.3-.8-9.3-.8" />
          <path stroke="#053f6e" d="m511.4 331.9-3.3 1c-1.3.2-9.2-.9-9.2-.9" />
          <path
            stroke="#064172"
            d="M511.4 332s-1.9.7-3.3 1c-1.5.3-9.2-1-9.2-1"
          />
          <path
            stroke="#00209f"
            d="M499 332s7.5 1.4 9 1.1c1.6-.3 3.5-1.1 3.5-1.1"
          />
        </g>
        <path
          fill="none"
          stroke="#000"
          strokeMiterlimit={2.6}
          strokeWidth={0.2}
          d="M475 290a34 34 0 0 1-.2-3.3c0-5.2-.7-9-.1-14.5.4-4.2 1.5-9.8 1.3-14.4-.1-1.3.1-2.6.2-3.9l21 23.5M467 327.7a5.2 5.2 0 0 1-1.9-2.2c-.6-1.7-.4-1.7-.9-3.6-.2-1.1-.2-2.3-.5-3.4-.2-1.2-1.8-4.8-1.9-6.2-.1-4.8-1.7-8-1.3-13.1.3-4 1.2-9.5.7-13.6l.1-3.6 23.6 15.6m28.5 33.9c.2.5-.3 1.5-.5 1.9l-.5.6c-.2.6-.2.4-.7.9l-.8.6c-.4.3-.7.6-1.1.7-1.8.3-2.5.7-4.2 1.1-1.6.5-.8.4-2 .7l-2.4.7-2.4.6c-2.9.7-5.7.5-8.6.3-1.1 0-4-.7-5-1.4-1.8-1.2-5.7-1.7-7.4-2.9-.3-.2-1.4-.7-1.6-1-1.7-1.3-3-1.7-4.8-2.8"
        />
        <g stroke="#000" strokeMiterlimit={2.6} strokeWidth={0.1}>
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="m484.9 297.6.6-.8-24-15.6-.4.6zm-23.7-16.7c-.2-1 0-2.1.7-2.3 0 0 .5-.1.8 0 .4 0 .5 0 .7.4.3.8-.7 1.3-1.4 1.6-.2 0-.6.1-.7.3l-.1.4.3-.3 1.7-.7c.6-.3.7-1.4.3-1.7-.4-.4-1.8-.3-2 0-.7.7-.8 1.7-.6 2.7 0-.2.3-.1.3-.4z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M460.8 281.3c-1 0-2.1.4-2.2 1v.9c0 .4.2.5.6.6.8.2 1.2-.8 1.4-1.6 0-.1 0-.6.2-.7l.4-.2-.3.3-.5 1.9c-.2.6-1.3.8-1.6.4-.5-.3-.6-1.7-.3-2 .7-.7 1.7-1 2.7-1-.2.1-.2.5-.4.4z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M460.6 281c-.3 0-.3.4-.1.6 0 .2.5.3.6.2.4-.2.6-.6.4-1-.2-.3-.6 0-.9.1z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M455.6 277.8s2.5 1 4.5 1c0 0 .1 1.8.5 2.3 0 0-1.8-.3-2.6 0 0 0-1.1-2.4-2.4-3.3z"
          />
          <path
            fill="none"
            d="M457.6 279s1 .4 1.8.4c0 0 0 .8.2 1 0 0-.7-.2-1 0 0 0-.4-1-1-1.4z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="m460.8 282.9.6-1.1c0-.2 0 1 .4 1 .5.8.7 2.3.7 2.7-.7.2-1.3.6-2.3.2-.3-.3 0-1 0-1.4.2-.3.3-1 .6-1.4z"
          />
          <path
            fill="none"
            d="M461.3 282.2v.6c0-.2.3.2.3.3.3.7.5 1.1.6 2.4m-.7-2.2c.2 1 .4 1 .4 2.4v-.1m-.5-1.4.2 1.4-.3.2"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="m497.1 277.4.7-.6-21.4-23.7-.4.5z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M476.6 253c0-.9.6-2 1.2-2l.9.1c.3.1.4.3.5.6.1.9-1 1.2-1.7 1.3l-.8.1-.2.3.3-.1c.6-.2 1.2-.2 2-.3.5-.1.9-1.3.6-1.6-.3-.5-1.6-.8-2-.5-.8.5-1 1.5-1.2 2.5 0-.2.4-.1.4-.3z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M476.1 253.4c-.9-.3-2.1-.2-2.3.5l-.2.8c0 .4 0 .5.4.7.7.4 1.4-.5 1.7-1.2 0-.2.2-.6.4-.7h.4l-.3.2-1 1.7c-.2.5-1.4.5-1.7 0-.3-.4 0-1.7.3-2 .8-.6 1.8-.5 2.8-.2-.2 0-.3.3-.5.2z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M476 253c-.3 0-.3.4-.3.6 0 .2.4.4.6.3.4-.1.7-.4.6-.8-.1-.4-.6-.2-.9-.1z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="M472 248.7s2 1.6 4 2c0 0-.3 1.9 0 2.4 0 0-1.7-.7-2.6-.5 0 0-.4-2.6-1.5-4z"
          />
          <path
            fill="none"
            d="M473.6 250.4s.8.6 1.6.9v.9s-.7-.3-1-.2c0 0-.2-1-.6-1.6z"
          />
          <path
            fill="#fc0"
            fillRule="evenodd"
            d="m475.7 254.9 1-1c0-.1-.4 1 0 1.3.4.8.1 2.3 0 2.7-.7 0-1.3.3-2-.4-.4-.3 0-.9.3-1.3 0-.3.4-1 .7-1.3z"
          />
          <path
            fill="none"
            d="M476.4 254.4v.5l.2.7v2.2m-.3-2.5c.2.9 0 1.6-.1 2.5m0-1c-.2.4-.2.6-.2 1h-.3"
          />
        </g>
      </g>
      <use xlinkHref="#sv-c" transform="matrix(-1 0 0 1 1030 0)" />
    </g>
    <path
      fill="#fc0"
      stroke="#000"
      strokeMiterlimit={2.6}
      strokeWidth={0.3}
      d="m319.3 197.9-40.2 67.3h80.5z"
    />
    <path
      fill="#fff"
      stroke="#fff"
      strokeMiterlimit={2.6}
      strokeWidth={0.1}
      d="M319.3 202.3 283 263h72.7z"
    />
    <path
      fill="#007e93"
      stroke="#007e93"
      strokeMiterlimit={2.6}
      strokeWidth={0.2}
      d="M293.8 245 283 263h72.7l-10.9-18z"
    />
    <g fill="none" strokeMiterlimit={2.6} strokeWidth={0.1}>
      <path
        stroke="#086aad"
        d="M313 212.9a9 9 0 0 1 6.2-2.2h.2c2.3 0 4.7.6 6.3 2.2"
      />
      <path
        stroke="#0863aa"
        d="M313 213a9 9 0 0 1 6.2-2.2h.2c2.4 0 4.8.5 6.3 2.2"
      />
      <path
        stroke="#095fa8"
        d="M313 213a8.8 8.8 0 0 1 6.2-2.2h.2c2.4 0 4.9.6 6.4 2.3"
      />
      <path
        stroke="#0a58a5"
        d="M312.9 213.1a8.7 8.7 0 0 1 6.3-2.2h.2c2.5 0 5 .6 6.5 2.3"
      />
      <path
        stroke="#0a52a2"
        d="M312.8 213.2c1.6-1.7 4-2.3 6.5-2.3h.1c2.6 0 5 .7 6.5 2.4"
      />
      <path
        stroke="#0b4d9f"
        d="M312.8 213.3c1.6-1.7 4-2.3 6.5-2.3h.2c2.5 0 5 .6 6.5 2.4"
      />
      <path
        stroke="#0c479d"
        d="M312.7 213.4c1.6-1.8 4-2.4 6.6-2.4h.2c2.6 0 5 .7 6.6 2.5"
      />
      <path
        stroke="#270a7f"
        d="M312.3 214c1.9-2 4.2-2.5 7-2.5h.2c3.1 0 5.7 1 7.3 3.2"
      />
      <path
        stroke="#241183"
        d="M312.3 214c1.9-2 4.2-2.6 7-2.6h.2c3 0 5.6 1 7.2 3.2"
      />
      <path
        stroke="#221786"
        d="M312.4 214c1.8-2 4.1-2.6 7-2.6 3 0 5.7 1 7.2 3"
      />
      <path
        stroke="#1f1f8a"
        d="M312.4 213.8c1.8-1.9 4.2-2.5 6.9-2.5h.1c3 0 5.6 1 7.2 3"
      />
      <path
        stroke="#1a258d"
        d="M312.5 213.7c1.7-1.8 4-2.4 6.8-2.4h.1c3 0 5.5.8 7 2.9"
      />
      <path
        stroke="#172d91"
        d="M312.5 213.7c1.7-1.9 4.1-2.5 6.7-2.5h.2c2.9 0 5.4.8 7 2.8"
      />
      <path
        stroke="#143393"
        d="M312.5 213.6c1.7-1.8 4-2.4 6.7-2.4h.2c2.8 0 5.3.7 7 2.7"
      />
      <path
        stroke="#113b97"
        d="M312.6 213.5c1.6-1.8 4-2.4 6.6-2.4h.1c2.8 0 5.4.7 7 2.7"
      />
      <path
        stroke="#ff0a00"
        d="M315.3 209a6.5 6.5 0 0 1 4-1.2c1.5 0 2.8.3 4 1"
      />
      <path stroke="#f10" d="M315.3 209a6.6 6.6 0 0 1 4-1 7 7 0 0 1 4 1" />
      <path stroke="#ff1500" d="M315.3 209a6.8 6.8 0 0 1 4-1c1.5 0 2.9.2 4 1" />
      <path
        stroke="#ff1a00"
        d="M315.2 209.2a6.6 6.6 0 0 1 4.1-1.2c1.5 0 3 .3 4.1 1"
      />
      <path
        stroke="#ff2000"
        d="M315.2 209.2a6.7 6.7 0 0 1 4.1-1.1c1.5 0 3 .3 4.1 1"
      />
      <path
        stroke="#ff2700"
        d="M315.1 209.3a6.8 6.8 0 0 1 4.2-1.2c1.5 0 3 .3 4.2 1.1"
      />
      <path
        stroke="#ff2f00"
        d="M315.1 209.4a6.9 6.9 0 0 1 4.2-1.2c1.5 0 3 .3 4.2 1"
      />
      <path
        stroke="#f30"
        d="M315 209.4a6.8 6.8 0 0 1 4.3-1.1 7.7 7.7 0 0 1 4.3 1"
      />
      <path
        stroke="#ff3c00"
        d="M315 209.5a6.9 6.9 0 0 1 4.3-1.2c1.6 0 3.1.3 4.3 1.1"
      />
      <path
        stroke="#ff4100"
        d="M315 209.6a7 7 0 0 1 4.3-1.2 8 8 0 0 1 4.3 1.1"
      />
      <path
        stroke="#ff4600"
        d="M315 209.7a7 7 0 0 1 4.3-1.3 8 8 0 0 1 4.4 1.2"
      />
      <path stroke="#fff500" d="M314 211.2a9.7 9.7 0 0 1 10.7 0" />
      <path
        stroke="#ffeb00"
        d="M314.1 211.1a9 9 0 0 1 5.2-1.5c2 0 4 .5 5.3 1.6"
      />
      <path
        stroke="#ffe000"
        d="M314.1 211a9 9 0 0 1 5.2-1.5c1.9 0 4 .5 5.3 1.6"
      />
      <path
        stroke="#ffd600"
        d="M314.2 211a9 9 0 0 1 5.1-1.6c1.9 0 3.9.5 5.2 1.6"
      />
      <path
        stroke="#ffcf00"
        d="M314.2 210.9a9 9 0 0 1 5.1-1.5 9 9 0 0 1 5.2 1.5"
      />
      <path
        stroke="#ffc400"
        d="M314.3 210.8c1.3-1 3.3-1.5 5-1.5a8 8 0 0 1 5.1 1.5"
      />
      <path stroke="#ffba00" d="M314.3 210.7c1.4-1 3.3-1.5 5-1.5s3.7.5 5 1.5" />
      <path
        stroke="#ffb000"
        d="M314.4 210.6a8.4 8.4 0 0 1 5-1.4c1.7 0 3.6.4 5 1.4"
      />
      <path
        stroke="#ffa600"
        d="M314.4 210.5a8.1 8.1 0 0 1 5-1.4 8 8 0 0 1 4.8 1.4"
      />
      <path
        stroke="#ff9c00"
        d="M314.5 210.4a8 8 0 0 1 4.8-1.4c1.7 0 3.6.4 4.9 1.4"
      />
      <path
        stroke="#ff9100"
        d="M314.6 210.3a8 8 0 0 1 4.7-1.4c1.7 0 3.5.5 4.8 1.4"
      />
      <path
        stroke="#ff8700"
        d="M314.6 210.2a8 8 0 0 1 4.7-1.3c1.7 0 3.5.4 4.8 1.3"
      />
      <path
        stroke="#ff7d00"
        d="M314.6 210.2a7.7 7.7 0 0 1 4.7-1.4c1.7 0 3.4.4 4.7 1.3"
      />
      <path
        stroke="#ff7500"
        d="M314.7 210a7.6 7.6 0 0 1 4.6-1.2c1.7 0 3.4.4 4.7 1.2"
      />
      <path
        stroke="#ff6b00"
        d="M314.8 210a7.6 7.6 0 0 1 4.5-1.3 8 8 0 0 1 4.6 1.2"
      />
      <path
        stroke="#ff6100"
        d="M314.8 209.9a7.3 7.3 0 0 1 4.5-1.3c1.6 0 3.3.4 4.6 1.3"
      />
      <path
        stroke="#ff5700"
        d="M314.9 209.8a7.3 7.3 0 0 1 4.4-1.3 8 8 0 0 1 4.5 1.3"
      />
      <path
        stroke="#ebf605"
        d="M313.9 211.4a9.5 9.5 0 0 1 5.4-1.7c2 0 4.1.6 5.5 1.7"
      />
      <path
        stroke="#d6ec09"
        d="M313.8 211.5a9.1 9.1 0 0 1 5.5-1.7c2 0 4.2.6 5.6 1.7"
      />
      <path
        stroke="#c2e30e"
        d="M313.8 211.6a9 9 0 0 1 5.5-1.7c2 0 4.2.5 5.6 1.7"
      />
      <path
        stroke="#add912"
        d="M313.7 211.7a8.8 8.8 0 0 1 5.6-1.8c2 0 4.2.6 5.6 1.8"
      />
      <path
        stroke="#99cf16"
        d="M313.6 211.8a8.8 8.8 0 0 1 5.7-1.8c2 0 4.3.6 5.7 1.8"
      />
      <path
        stroke="#85c61a"
        d="M313.6 211.9a8.7 8.7 0 0 1 5.7-1.9c2 0 4.3.7 5.7 1.9"
      />
      <path
        stroke="#70bc1f"
        d="M313.5 212a8.4 8.4 0 0 1 5.8-1.9c2 0 4.4.6 5.8 1.8"
      />
      <path
        stroke="#5cb323"
        d="M313.5 212.1a8.4 8.4 0 0 1 5.8-2c2.1 0 4.4.7 5.8 2"
      />
      <path
        stroke="#47a928"
        d="M313.4 212.2a8.4 8.4 0 0 1 5.9-2c2.1 0 4.4.7 5.9 1.9"
      />
      <path
        stroke="#0d74a4"
        d="M313.1 212.7a8.8 8.8 0 0 1 6.2-2 9 9 0 0 1 6.3 2"
      />
      <path
        stroke="#127a97"
        d="M313.1 212.7a8.7 8.7 0 0 1 6.2-2.2 9 9 0 0 1 6.2 2.1"
      />
      <path
        stroke="#17808b"
        d="M313.2 212.6a8.7 8.7 0 0 1 6.2-2 9 9 0 0 1 6 2"
      />
      <path
        stroke="#1a847d"
        d="M313.2 212.6a8.7 8.7 0 0 1 6.1-2.1 9 9 0 0 1 6.1 2"
      />
      <path
        stroke="#1e8a6d"
        d="M313.2 212.5a8.5 8.5 0 0 1 6.1-2c2.3 0 4.6.6 6 2"
      />
      <path
        stroke="#238f5e"
        d="M313.3 212.5a8.5 8.5 0 0 1 6-2.1c2.2 0 4.6.6 6 2"
      />
      <path
        stroke="#2b944e"
        d="M313.3 212.4a8.3 8.3 0 0 1 6-2c2.2 0 4.6.6 6 2"
      />
      <path stroke="#2f9b3e" d="M313.3 212.3c2-1.6 3.7-2 6-2 2.2 0 4.5.7 6 2" />
      <path
        stroke="red"
        d="M323.2 208.8a6.8 6.8 0 0 0-3.9-1 6.6 6.6 0 0 0-4 1"
      />
      <path
        stroke="#2a007c"
        d="M326.9 214.9c-1.6-2.3-4.3-3.4-7.5-3.4-3 0-5.2.7-7.2 2.7"
      />
      <path
        stroke="#0671b0"
        d="M325.6 212.7c-1.5-1.5-4-2-6.3-2a9 9 0 0 0-6.2 2.1"
      />
      <path
        stroke="#0c419a"
        d="M326.2 213.7c-1.6-2-4.1-2.6-6.9-2.6-2.6 0-5 .6-6.7 2.3"
      />
      <path
        stroke="#ff0"
        d="M324.8 211.3a9.1 9.1 0 0 0-5.5-1.6c-1.8 0-4 .5-5.4 1.6"
      />
      <path
        stroke="#ff4d00"
        d="M323.7 209.7a8.1 8.1 0 0 0-4.4-1.2 7 7 0 0 0-4.4 1.2"
      />
      <path
        stroke="#33a02c"
        d="M325.2 212.2a9.5 9.5 0 0 0-5.9-2 8.3 8.3 0 0 0-6 2"
      />
    </g>
    <g fill="none" strokeMiterlimit={2.6} strokeWidth={0.1}>
      <path
        stroke="#fef2ec"
        d="M312 214.5a16.3 16.3 0 0 1 7.3-1.8c2.6 0 5.4 1 7.6 2.1l7.7 13a15.3 15.3 0 0 1-30.6 0l8-13.3z"
      />
      <path
        stroke="#fef2ea"
        d="M319.3 212.9c2.6 0 5.3 1 7.5 2.1l7.6 12.7c0 8.3-6.8 15.2-15 15.2-8.4 0-15.1-6.7-15.2-15.1l7.9-13a15.8 15.8 0 0 1 7.2-2z"
      />
      <path
        stroke="#fef0e6"
        d="M319.3 213.3c2.5 0 5.2 1 7.3 2l7.4 12.4c0 8.1-6.6 14.9-14.7 14.9a14.7 14.7 0 0 1-14.7-14.8l7.6-12.7a15.6 15.6 0 0 1 7-1.8z"
      />
      <path
        stroke="#feede3"
        d="M319.3 213.7c2.4 0 5 .9 7 2 .2 0 7.3 11.9 7.3 12a14.4 14.4 0 0 1-14.3 14.4c-7.9 0-14.2-6.3-14.3-14.3 0-.2 7.3-12.3 7.4-12.4a16 16 0 0 1 6.9-1.7z"
      />
      <path
        stroke="#fee8dc"
        d="M319.3 214.3c2.3 0 4.8.9 6.8 2 .2 0 6.8 11.2 6.8 11.5 0 7.5-6.1 13.7-13.6 13.7s-13.6-6-13.7-13.7c0-.3 6.9-11.7 7.1-11.8 2-1 4.2-1.7 6.6-1.7z"
      />
      <path
        stroke="#fee6d5"
        d="M319.3 214.7c2.3 0 4.7.8 6.6 1.9.2.2 6.6 10.8 6.6 11.2 0 7.3-6 13.3-13.2 13.3s-13.2-6-13.2-13.3c0-.4 6.5-11.3 6.8-11.5 2-1 4-1.6 6.4-1.6z"
      />
      <path
        stroke="#fee3cf"
        d="M319.3 215.3c2.2 0 4.5.8 6.2 1.8.4.2 6.4 10.2 6.4 10.7 0 7-5.7 12.7-12.6 12.7-7 0-12.6-5.6-12.7-12.7 0-.4 6.2-10.7 6.6-11a13.3 13.3 0 0 1 6-1.5z"
      />
      <path
        stroke="#fee0cc"
        d="M319.3 215.7c2.1 0 4.3.8 6 1.8a76 76 0 0 1 6.2 10.3c0 6.7-5.5 12.3-12.2 12.3a12.2 12.2 0 0 1-12.3-12.3c0-.5 6-10.3 6.4-10.6 1.8-1 3.7-1.5 5.9-1.5z"
      />
      <path
        stroke="#fedec6"
        d="M319.3 216.1c2 0 4.2.8 5.9 1.7.4.3 6 9.4 6 10a12 12 0 0 1-12 11.9 11.8 11.8 0 0 1-11.7-11.9c0-.6 5.6-10 6-10.2a12.5 12.5 0 0 1 5.8-1.5z"
      />
      <path
        stroke="#fdcdaa"
        d="M319.3 218.8c1.6 0 3.2.5 4.5 1.3.9.5 4.6 6.7 4.6 7.7a9.2 9.2 0 0 1-9.1 9.2 9.2 9.2 0 0 1-9.2-9.2c0-1 3.9-7.4 4.7-8a9.6 9.6 0 0 1 4.5-1z"
      />
      <path
        stroke="#fdcdaa"
        d="M319.3 219a9 9 0 0 1 4.4 1.2c1 .6 4.5 6.6 4.5 7.6a9 9 0 1 1-17.9 0c0-1 3.7-7.2 4.6-7.7a9.2 9.2 0 0 1 4.4-1.1z"
      />
      <path
        stroke="#fdc59e"
        d="M319.3 220a8 8 0 0 1 4 1.1c1 .6 4 5.5 4 6.7a8 8 0 0 1-8 8 8 8 0 0 1-8-8c0-1.2 3-6.3 4.1-6.8 1.2-.7 2.5-1 3.9-1z"
      />
      <path
        stroke="#fdc59e"
        d="M319.3 220.2a7.8 7.8 0 0 1 3.9 1 16 16 0 0 1 3.8 6.6 7.8 7.8 0 0 1-7.7 7.8 7.7 7.7 0 0 1-7.8-7.7c0-1.4 3-6.1 4-6.8a7.9 7.9 0 0 1 3.8-1z"
      />
      <path
        stroke="#fef0e9"
        d="M319.3 213c2.5 0 5.2 1 7.4 2.2l7.5 12.5a15 15 0 0 1-14.9 15 15 15 0 0 1-14.9-14.9l7.7-13a15.6 15.6 0 0 1 7.2-1.7z"
      />
      <path
        stroke="#feede3"
        d="M319.3 213.5c2.5 0 5.1 1 7.1 2 .2.1 7.4 12.1 7.4 12.3a14.5 14.5 0 0 1-29 0l7.5-12.6a15.1 15.1 0 0 1 7-1.7z"
      />
      <path
        stroke="#feebdf"
        d="M319.3 214c2.4 0 5 .8 7 1.9.1 0 7 11.6 7 11.9 0 7.7-6.3 14.1-14 14.1s-14-6.3-14-14.1c0-.2 7-12.1 7.2-12.2a14.9 14.9 0 0 1 6.8-1.7z"
      />
      <path
        stroke="#feebdd"
        d="M319.3 214c2.4 0 4.9 1 6.9 2 .1.2 7 11.5 7 11.8a14 14 0 0 1-14 14 14 14 0 0 1-13.8-14c0-.2 7-11.9 7.2-12 2-1 4.2-1.7 6.7-1.7z"
      />
      <path
        stroke="#fee8d9"
        d="M319.3 214.5c2.3 0 4.8.9 6.7 2 .2 0 6.7 11 6.7 11.3 0 7.4-6 13.5-13.4 13.5s-13.4-6-13.5-13.5c0-.3 6.7-11.5 7-11.7 2-1 4.1-1.6 6.5-1.6z"
      />
      <path
        stroke="#fee6d3"
        d="M319.3 215c2.2 0 4.6.7 6.5 1.8.3.1 6.5 10.6 6.5 11 0 7.1-5.9 13.1-13 13.1a13.1 13.1 0 0 1-13-13c0-.5 6.4-11.3 6.7-11.4a13.8 13.8 0 0 1 6.3-1.6z"
      />
      <path
        stroke="#fee3d2"
        d="M319.3 215.1c2.2 0 4.5.8 6.4 1.8.3.2 6.4 10.5 6.4 10.9 0 7-5.8 13-12.8 13a13 13 0 0 1-12.9-13c0-.4 6.3-11 6.7-11.1a13.8 13.8 0 0 1 6.2-1.6z"
      />
      <path
        stroke="#fee0cc"
        d="M319.3 215.5c2.2 0 4.4.8 6.1 1.8.5.2 6.3 10 6.3 10.5 0 6.8-5.6 12.5-12.4 12.5a12.5 12.5 0 0 1-12.5-12.5c0-.5 6-10.6 6.5-10.8a13 13 0 0 1 6-1.5z"
      />
      <path
        stroke="#fedec8"
        d="M319.3 216c2 0 4.2.7 6 1.6.4.3 6 9.6 6 10.2a12 12 0 0 1-12 12 12 12 0 0 1-12-12 88 88 0 0 1 6.2-10.4c1.7-1 3.6-1.5 5.8-1.5z"
      />
      <path
        stroke="#fddbc5"
        d="M319.3 216.3c2 0 4.1.8 5.8 1.7a87 87 0 0 1 5.8 9.8c0 6.4-5.2 11.7-11.6 11.7-6.4 0-11.6-5.2-11.6-11.7 0-.6 5.5-9.7 6-10a12.1 12.1 0 0 1 5.6-1.5z"
      />
      <path
        stroke="#fddbc2"
        d="M319.3 216.5c2 0 4 .8 5.7 1.7.5.3 5.7 9 5.7 9.6 0 6.3-5.1 11.5-11.4 11.5s-11.4-5.1-11.5-11.5c0-.7 5.4-9.6 6-9.9a12 12 0 0 1 5.5-1.4z"
      />
      <path
        stroke="#fdd9bf"
        d="M319.3 216.7c2 0 4 .7 5.6 1.6.5.4 5.6 8.8 5.6 9.5a11.2 11.2 0 0 1-22.4 0c0-.7 5.2-9.4 5.8-9.7a11.9 11.9 0 0 1 5.4-1.4z"
      />
      <path
        stroke="#fdd9bf"
        d="M319.3 217c2 0 3.9.6 5.4 1.5a55 55 0 0 1 5.6 9.3c0 6-5 11-11 11s-11-4.8-11-11c0-.7 5-9.2 5.7-9.5a11.5 11.5 0 0 1 5.3-1.4z"
      />
      <path
        stroke="#fdd6bc"
        d="M319.3 217.1c1.9 0 3.8.7 5.3 1.6.7.3 5.5 8.3 5.5 9.1 0 6-4.9 10.9-10.8 10.9a10.8 10.8 0 0 1-10.8-10.9c0-.8 5-9 5.6-9.3a11 11 0 0 1 5.2-1.4z"
      />
      <path
        stroke="#fdd6b9"
        d="M319.3 217.3c1.8 0 3.7.7 5.2 1.5.7.4 5.3 8.2 5.3 9 0 5.8-4.7 10.7-10.5 10.7a10.6 10.6 0 0 1-10.6-10.7c0-.8 4.8-8.8 5.5-9.2a11 11 0 0 1 5-1.3z"
      />
      <path
        stroke="#fdd4b8"
        d="M319.3 217.6c1.8 0 3.7.6 5.2 1.4.6.4 5.2 8 5.2 8.8 0 5.7-4.7 10.5-10.4 10.5s-10.4-4.7-10.4-10.5c0-.8 4.6-8.6 5.3-9a10.8 10.8 0 0 1 5-1.2z"
      />
      <path
        stroke="#fdd4b6"
        d="M319.3 217.7c1.8 0 3.6.7 5 1.5.8.4 5.2 7.7 5.2 8.6 0 5.6-4.6 10.3-10.2 10.3a10.2 10.2 0 0 1-10.2-10.3c0-.9 4.5-8.4 5.2-8.8a10.8 10.8 0 0 1 5-1.3z"
      />
      <path
        stroke="#fdd2b2"
        d="M319.3 218c1.7 0 3.5.6 5 1.4.7.4 5 7.5 5 8.4 0 5.5-4.6 10-10 10s-10-4.4-10-10a39 39 0 0 1 5.1-8.6 10.7 10.7 0 0 1 4.9-1.3z"
      />
      <path
        stroke="#fdd1b0"
        d="M319.3 218.2c1.7 0 3.5.6 4.9 1.4.7.4 4.9 7.3 4.9 8.2 0 5.4-4.5 9.9-9.8 9.9s-9.8-4.4-9.8-9.9c0-.9 4.2-8 5-8.4a9.8 9.8 0 0 1 4.8-1.3z"
      />
      <path
        stroke="#fdd0b0"
        d="M319.3 218.4c1.7 0 3.4.6 4.8 1.3.8.5 4.7 7.1 4.7 8.1a9.5 9.5 0 1 1-19.1 0c0-1 4.1-7.8 5-8.3a9.8 9.8 0 0 1 4.6-1.1z"
      />
      <path
        stroke="#fdd0ad"
        d="M319.3 218.6a9.8 9.8 0 0 1 4.7 1.3c.8.5 4.6 7 4.6 8 0 5-4.2 9.3-9.3 9.3s-9.4-4.1-9.4-9.4c0-1 4-7.6 4.8-8a9.6 9.6 0 0 1 4.6-1.2z"
      />
      <path
        stroke="#fdcaa6"
        d="M319.3 219.2c1.5 0 3 .5 4.4 1.2.9.5 4.3 6.3 4.3 7.4a8.8 8.8 0 0 1-8.7 8.8 8.8 8.8 0 0 1-8.8-8.7c0-1.2 3.6-7.1 4.5-7.7a9.1 9.1 0 0 1 4.3-1z"
      />
      <path
        stroke="#fdcaa4"
        d="M319.3 219.4a9.1 9.1 0 0 1 4.3 1.2c.9.5 4.2 6 4.2 7.2a8.6 8.6 0 0 1-8.5 8.6 8.6 8.6 0 0 1-8.6-8.5c0-1.2 3.5-7 4.4-7.5a9 9 0 0 1 4.2-1z"
      />
      <path
        stroke="#fdc8a4"
        d="M319.3 219.6c1.5 0 3 .5 4.2 1.2a19 19 0 0 1 4.1 7 8.4 8.4 0 0 1-16.7.1c0-1.2 3.3-6.7 4.3-7.3a8.5 8.5 0 0 1 4-1z"
      />
      <path
        stroke="#fdc8a1"
        d="M319.3 219.8c1.4 0 2.9.5 4 1.1 1 .6 4.1 5.7 4.1 7a8.2 8.2 0 0 1-8.1 8.1 8.2 8.2 0 0 1-8.2-8.1c0-1.3 3.2-6.6 4.2-7.1 1.2-.6 2.5-1 4-1z"
      />
      <path
        stroke="#fdc39b"
        d="M319.3 220.4c1.3 0 2.7.4 3.7 1a15 15 0 0 1 3.8 6.4 7.5 7.5 0 0 1-7.5 7.6 7.5 7.5 0 0 1-7.6-7.5c0-1.4 2.8-6 3.9-6.6a7.7 7.7 0 0 1 3.7-1z"
      />
      <path
        stroke="#fdc398"
        d="M319.3 220.6c1.3 0 2.6.4 3.6 1a13 13 0 0 1 3.7 6.3c0 4-3.3 7.3-7.3 7.3a7.3 7.3 0 0 1-7.4-7.3 14 14 0 0 1 3.8-6.4 7.7 7.7 0 0 1 3.6-1z"
      />
      <path
        stroke="#fdc097"
        d="M319.3 220.8a7.5 7.5 0 0 1 3.6 1 13 13 0 0 1 3.5 6c0 4-3.2 7.2-7.1 7.2a7.1 7.1 0 0 1-7.2-7.1c0-1.5 2.5-5.6 3.7-6.3a7.3 7.3 0 0 1 3.5-.8z"
      />
      <path
        stroke="#fdc095"
        d="M319.3 221a7 7 0 0 1 3.5 1c1.1.7 3.4 4.4 3.4 5.9a7 7 0 0 1-7 7 7 7 0 0 1-6.9-7c0-1.5 2.4-5.4 3.6-6a6.8 6.8 0 0 1 3.4-.9z"
      />
      <path
        stroke="#fdbe92"
        d="M319.3 221.2a7 7 0 0 1 3.4 1c1.1.6 3.3 4.2 3.3 5.7a6.7 6.7 0 1 1-13.5 0c0-1.5 2.3-5.2 3.5-5.9 1-.5 2-.8 3.3-.8z"
      />
      <path
        stroke="#fdbe90"
        d="M319.3 221.4c1.1 0 2.3.4 3.3 1 1.1.6 3.2 4 3.2 5.5a6.5 6.5 0 0 1-6.5 6.5 6.5 6.5 0 0 1-6.6-6.5c0-1.6 2.1-5 3.4-5.7a6.6 6.6 0 0 1 3.2-.8z"
      />
      <path
        stroke="#fdbb8f"
        d="M319.3 221.6c1.1 0 2.2.3 3.2.9 1.2.7 3 3.8 3 5.4a6.3 6.3 0 0 1-6.2 6.3 6.3 6.3 0 0 1-6.4-6.3 9 9 0 0 1 3.3-5.5c1-.5 2-.8 3-.8z"
      />
      <path
        stroke="#fdbb8d"
        d="M319.3 221.8c1 0 2.2.3 3 .9a8 8 0 0 1 3 5.2 6.1 6.1 0 0 1-6 6 6.1 6.1 0 0 1-6.1-6c0-1.6 1.8-4.6 3-5.3a6 6 0 0 1 3-.8z"
      />
      <path
        stroke="#fdb98a"
        d="M319.3 222a5.8 5.8 0 0 1 3 .8c1.2.8 2.9 3.5 2.9 5a6 6 0 0 1-6 6 6 6 0 0 1-5.8-6c0-1.6 1.6-4.3 3-5a6 6 0 0 1 2.9-.8z"
      />
      <path
        stroke="#fdb98a"
        d="M319.3 222.2a5.8 5.8 0 0 1 2.8.8 7 7 0 0 1 2.9 4.9 5.7 5.7 0 0 1-11.4 0 7 7 0 0 1 2.9-5 5.5 5.5 0 0 1 2.8-.7z"
      />
      <path
        stroke="#fcb687"
        d="M319.3 222.4c1 0 2 .3 2.8.8a6.5 6.5 0 0 1 2.6 4.7 5.5 5.5 0 1 1-11 0c0-1.7 1.5-4 2.9-4.8a6 6 0 0 1 2.7-.7z"
      />
      <path
        stroke="#fcb685"
        d="M319.3 222.6c1 0 1.9.3 2.7.8a5.9 5.9 0 0 1 2.5 4.5 5.3 5.3 0 0 1-5.2 5.3 5.3 5.3 0 0 1-5.3-5.3 5.9 5.9 0 0 1 2.7-4.6 5 5 0 0 1 2.6-.7z"
      />
      <path
        stroke="#fcb485"
        d="M319.3 222.8c1 0 1.8.3 2.6.7a5.3 5.3 0 0 1 2.4 4.4 5 5 0 1 1-10.1 0c0-1.8 1.1-3.6 2.6-4.4a5 5 0 0 1 2.5-.7z"
      />
      <path
        stroke="#fcb482"
        d="M319.3 232.8a4.9 4.9 0 0 0 4.8-4.9c0-2.7-2.2-4.9-4.8-4.9a4.9 4.9 0 0 0-5 4.9 4.9 4.9 0 0 0 5 4.9z"
      />
    </g>
    <path
      fill="#fff"
      fillRule="evenodd"
      stroke="#fff"
      strokeMiterlimit={2.6}
      strokeWidth={0.1}
      d="M319.3 232.8a4.9 4.9 0 0 0 4.9-4.9 4.9 4.9 0 0 0-4.9-4.8 4.9 4.9 0 0 0-4.9 4.8 4.9 4.9 0 0 0 5 4.9z"
    />
    <g stroke="#000" strokeWidth={0.1}>
      <path
        fill="none"
        d="m320.4 223.1.5-2.6m-1 2.6.2-2.7m-.8 2.6v-2.6m-.5 2.7-.3-2.7m-.2 2.7-.6-2.6m.1 2.8-.8-2.6m.3 2.7-1-2.4m.6 2.6-1.4-2.3m1 2.6-1.6-2.1m1.2 2.5-1.9-2m1.5 2.3-2-1.8m1.7 2.2-2.2-1.5m1.8 2-2.2-1.4m2 1.8-2.4-1m2.2 1.5-2.5-.9m2.4 1.4-2.6-.6m2.5 1-2.6-.2m2.6.8h-2.7m2.7.5-2.6.3m2.7.2-2.6.6m2.7-.1-2.5.8m2.7-.3-2.4 1m2.6-.6-2.8 1.8m3.1-1.3-5.7 4m6-3.6-6.1 5.4m6.5-5-5.1 5.6m5.5-5.3-3.9 5.1m4.3-4.8-4 7m4.5-6.8-2.3 5m2.7-4.8-2.2 7m2.7-6.9-1 4.7m1.6-4.6-.7 7.2m1.7-7.2.2 2.6m.3-2.7 1.5 6.8m-1-7 1.3 4.1m-.8-4.2 3 6.7m-2.6-7 3.3 5.8m-2.8-6 4.7 6.2m-4.3-6.5 4.1 4.8m-3.8-5.2 6.2 5.7m-5.9-6 3.4 2.4m-3-2.9 2.2 1.3m-2-1.7 2.4 1m-2.2-1.5 2.5.8M324 229l2.6.5m-2.5-1 2.6.2m-2.6-.8h2.6m-2.6-.5 2.6-.2m-2.7-.3 2.6-.5m-2.7 0 2.5-.8m-2.7.4 2.4-1.1m-2.6.6 2.3-1.3m-2.6.9 2.1-1.6m-2.4 1.1 2-1.7m-2.4 1.4 1.8-2m-2.2 1.6 1.6-2m-2 1.8 1.3-2.3m-1.8 2 1.1-2.4m-1.6 2.3.9-2.5m-2.4-4v-2M317 217l-.4-2m-1.8 2.7-.8-1.8m-1.2 3-1.2-1.7m-.5 3.2-1.6-1.3m.2 3.2-1.8-1m.8 3.2-2-.7m1.5 3-2-.3m2 2.5-2 .2m2.5 2.1-2 .7m22.2 1.5 1.8 1m-.8-3.1 1.9.6m-1.5-2.9 2 .2m-2-2.5 2-.2m-2.4-2.1 2-.6m-3-1.5 1.8-1m-3.1-.9 1.5-1.4m-3.2-.2 1.2-1.6m-3.2.5.8-1.9m-3 1.1.4-2"
      />
      <path
        fill="#e60000"
        fillRule="evenodd"
        strokeMiterlimit={2.6}
        d="M322.1 230.2s-.7-.4-1-.4l-3 .1c-.5.1-.8.5-.8.5s.5.5 1.4.6c1 0 1.7 0 2.2-.2l1.2-.6z"
      />
      <path
        fill="#e60000"
        fillRule="evenodd"
        strokeMiterlimit={2.6}
        d="M317.4 229.5s.1-1.4 1-3l-.4.8s-.6.3-.9 0c-.3-.4-.1-.5.1-1 .2-.4.2-.8.5-1 .2-.3.4-.3 1-.3.7 0 1.2 0 1.7.8l1 1.7c.6.8.6 1.9.6 1.9l.2.8s-.7-.4-1.1-.4l-3 .1-.8.5s-.3-.6.1-1z"
      />
      <path
        fill="none"
        strokeMiterlimit={2.6}
        d="M317.4 229.5s.6-.3 2.3-.3c2 0 2.1.2 2.3.3"
      />
      <path
        fill="#fc0"
        fillRule="evenodd"
        strokeMiterlimit={2.6}
        d="M319.2 237.1v-7.2s.2-.2.8 0v7.1s.2 5.5-.4 5.5c-.7 0-.4-1.3-.4-5.4z"
      />
    </g>
    <g fill="#e60000">
      <path
        fillRule="evenodd"
        d="m311.8 231 .1.3-1.4.6.2.5h-.2c-.1-.2-.2-.3-.6-.3v-.2l1.9-.8zm-1.5-.5a.6.6 0 0 1-.3-.4c0-.4.1-.7.6-.8.2-.1.7-.1.9.5 0 .3 0 .7-.5.8v-.2c.2-.1.3-.3.2-.6 0-.2-.3-.3-.6-.3-.3.1-.4.3-.3.6a.5.5 0 0 0 .3.3v.2l-1.2.1-.2-1h.3l.2.8h.6zm-.6-4c-.3 0-.5.3-.5.6 0 .2 0 .5.3.5s.3-.1.4-.2l.2-.6c0-.3.2-.5.6-.5.5 0 .6.6.5 1l-.2.6c-.2.1-.4.2-.6.1v-.2c.4 0 .6-.3.6-.6 0-.2 0-.5-.3-.6-.3 0-.3 0-.4.4l-.2.5c0 .1-.1.4-.5.4s-.7-.3-.6-.8c0-.8.5-.8.7-.8v.3zm0-1.3.5.2.4-1.1h.3l-.4 1.2.7.3.4-1.3h.2l-.4 1.6-2.1-.7.5-1.5.2.1z"
      />
      <path d="M311 222a.7.7 0 0 0-.4.4l-.5.8 1.9 1.1.1-.2-.8-.5.4-.6c.2-.4 0-.7-.2-.9a.6.6 0 0 0-.5 0zm.2.4a.4.4 0 0 1 .1 0c.2.2.2.3.1.6l-.3.4-.6-.3.3-.5c.1-.2.2-.3.4-.2z" />
      <path
        fillRule="evenodd"
        d="m313.6 222.1-.2.2-1.4-1.3-.5.5-.2-.1 1.2-1.3.2.2-.5.5zm.7-.6-1.3-1.7.2-.2 1.3 1.7zm0-2.3.3.6 1-.5.2.2-1 .6.2.6 1.2-.6.1.2-1.4.8-1-2 1.4-.7.1.2zm4 .6-.3-1.2v-.6l-.3 2h-.3l-1-1.6.2.5.2 1.3h-.2l-.5-2.1h.4l1 1.6.2-2h.4l.5 2-.3.1z"
      />
      <path d="M319 217.6v2.2h.8c.5 0 .8-.2.8-.6 0-.3-.2-.4-.4-.5.3-.1.3-.3.3-.5 0-.3-.1-.5-.5-.6h-1zm.3.3h.5c.3 0 .4.2.4.4s-.1.3-.4.2h-.5v-.6zm0 .9h.5c.2 0 .5.1.5.4 0 .2-.2.4-.5.4l-.5-.1v-.7zm2.1-1-.5 2.1.2.1.3-.9.7.2c.3.1.3.3.2.5v.5l.3.1v-.7c.1-.2 0-.3 0-.4 0 0 .3-.1.3-.4.2-.5-.1-.7-.5-.8l-1-.3zm.3.4.6.2c.2 0 .4 0 .3.4 0 .3-.3.3-.5.2l-.6-.1.2-.7z" />
      <path
        fillRule="evenodd"
        d="m324 219-.3.6 1 .6-.1.2-1-.5-.4.6 1.1.6-.1.2-1.4-.8 1-1.8 1.5.8-.2.2z"
      />
      <path d="M326.6 220.7 325 222l.6.7c.4.5 1 .3 1.4 0 .5-.4.6-1 .2-1.4l-.5-.7zm0 .4.3.4c.3.3.3.6-.1 1-.4.3-.8.3-1 0l-.3-.4 1.1-1z" />
      <path
        fillRule="evenodd"
        d="m328.2 223-.7.4.6 1-.3.2-.5-1.1-.6.3.6 1.2h-.3l-.7-1.3 2-1 .7 1.4-.3.1zm-.8 4v-.3l1.5-.2-.1-.5h.2c0 .3.1.4.5.5v.2l-2.1.3z"
      />
      <path d="m328 227.6-.4.2a.9.9 0 0 0-.2.5c0 .5.3.8.6.8.2 0 .4 0 .6-.3 0 0 .1.2.4.2.3 0 .6 0 .6-.6 0-.5-.3-.7-.6-.7-.2 0-.3.1-.4.4 0-.3-.3-.4-.5-.5zm0 .4c.2 0 .4.1.4.4 0 .2-.1.4-.4.4-.3 0-.3-.3-.3-.5 0-.3.2-.3.4-.3zm1 0c.2 0 .3.1.3.4 0 .3-.2.4-.3.4a.4.4 0 0 1-.3-.4c0-.2.1-.3.3-.3z" />
      <path
        fillRule="evenodd"
        d="M328.7 229.5c.7.2.6.7.6 1-.1.3-.4.5-.8.4-.4 0-.5-.3-.6-.7v-.2c0-.4-.2-.5-.3-.5l-.3 1.1h-.3l.4-1.4c.4.1.6.3.7.7v.3c.2.2.2.4.5.5.1 0 .4 0 .5-.4 0-.3-.3-.4-.4-.5v-.3zm-2.1 2.1.1-.3 1.4.7.2-.5.2.1c-.1.4-.2.5.1.7v.2l-2-.9z"
      />
    </g>
    <path
      fill="none"
      stroke="#000"
      strokeMiterlimit={2.6}
      strokeWidth={0.2}
      d="M319.3 202.3 283 263h72.7z"
    />
    <g fill="none" strokeMiterlimit={2.6}>
      <path
        stroke="#000"
        strokeWidth={0.1}
        d="M321.3 255.5a6.3 6.3 0 0 0 3.2 0c1.5-.3 3-1.2 4.8-1 1.4 0 3.2 1.2 5.3 1.2 2.2 0 3-.7 4.8-1.1 1.3-.3 2-.2 3.4.2 1.6.3 2.5 1.2 5.2 1"
      />
      <path
        stroke="#fff"
        strokeWidth={0.4}
        d="M293.2 258.1c1.3-1 3.4-1.3 5-1 2.2.5 3.1 1 5.4 1 1.7 0 3.2-1.1 5-1.1 2.8 0 2.9.6 5.4 1a5.6 5.6 0 0 0 2.2 0 9.5 9.5 0 0 0 2.5-.8c.8-.4 2.8-.4 3.8-.3 1.8.2 2.6.9 3 1 1 .2 2 .4 3.2 0 1.5-.4 3-1.4 4.9-1.2 1.3.2 3 1.4 5.2 1.4s3-.8 4.8-1.2c1.4-.3 2-.2 3.4.1 1.6.4 2.5 1.5 5.2 1.2"
      />
      <path
        stroke="#fff"
        strokeWidth={0.3}
        d="M289.1 256a7.6 7.6 0 0 1 5-.8c2.2.4 3.1 1 5.4 1 1.7-.1 3.2-1.1 5-1.1 2.8 0 2.9.5 5.4 1h2.2a9.4 9.4 0 0 0 2.5-.9c.8-.3 2.8-.3 3.8-.2 1.8.2 2.6.8 3 .9 1 .2 2 .3 3.2 0 1.5-.4 3-1.2 4.9-1 1.3 0 3.1 1.2 5.2 1.2 2.2 0 3-.8 4.8-1.1 1.4-.3 2-.1 3.4.1 1.6.4 2.5 1.3 5.2 1"
      />
      <path
        stroke="#fff"
        strokeWidth={0.5}
        d="M285.4 262a6.3 6.3 0 0 1 5-1c2.1.5 3 1.1 5.4 1 1.7 0 3.2-1.3 4.9-1.3 2.9 0 3 .7 5.5 1.3a5.8 5.8 0 0 0 2.2 0 8.4 8.4 0 0 0 2.5-1c.8-.5 2.8-.4 3.8-.3 1.8.2 2.5 1 2.9 1 1 .3 2 .5 3.3.2 1.5-.6 3-1.6 4.8-1.4 1.3.1 3.1 1.6 5.3 1.6 2.1 0 3-1 4.7-1.5 1.4-.3 2-.1 3.5.2 1.6.4 2.5 1.6 5.2 1.3"
      />
      <path
        stroke="#fff"
        strokeWidth={0.3}
        d="M286.4 258.6c1.2-.9 3.4-1.2 5-.9 2.1.5 3 1 5.4 1 .7 0 1.4-.3 2.2-.5"
      />
      <path
        stroke="#000"
        strokeWidth={0.2}
        d="M297.4 255c.3 0 1.3-.5 2.8-.5 2.9 0 1 0 3.6.5.7 0 2.5 0 3-.4m25.4 8.2c1-.2 1.8-.5 2.6-.8.7-.3 2.7-.3 3.8-.2 1.8.2 2.5.8 2.9.8a6.3 6.3 0 0 0 3.2 0c1.6-.3 3-1.2 5-1 1.2.1 3 1.3 5.2 1.3"
      />
      <path
        stroke="#fff"
        strokeWidth={0.3}
        d="M336.7 254.8c2.1 0 2.9-.8 4.8-1.2 1.3-.2 2 0 3.3.2 1.7.3 2.5 1.3 5.2 1"
      />
      <path
        stroke="#000"
        strokeWidth={0.1}
        d="M285.5 262.2a7.7 7.7 0 0 1 5-.8c2.2.4 3.1.9 5.4.9 1.7 0 3.2-1.1 5-1.1 2.8 0 2.9.6 5.4 1a7.5 7.5 0 0 0 2.2 0 9.8 9.8 0 0 0 2.5-.8c.8-.4 2.8-.3 3.8-.2 1.8.1 2.5.7 3 .8"
      />
      <path
        stroke="#000"
        strokeWidth={0.5}
        d="M290 259.6c1.3-.9 3.5-1.2 5.1-.9 2.2.4 3.1 1 5.4.9 1.7 0 3.1-1 4.8-1 3 0 3 .5 5.6 1a7.4 7.4 0 0 0 2.2 0 11.3 11.3 0 0 0 2.5-.9c.7-.3 2.8-.3 3.8-.2 1.8.2 2.5.8 3 .9.9.2 2 .3 3.2 0 1.5-.4 3-1.3 4.8-1 1.5 0 3.3 1.2 5.3 1.2 2.2 0 3-.8 4.8-1.2 1.3-.2 2 0 3.4.2 1.6.3 2.5 1.3 5.2 1"
      />
    </g>
    <g fill="#fc0" fillRule="evenodd" stroke="#000" strokeWidth={0.2}>
      <path d="M291 249.5c.4 0 1.2-.6 1.5-.8.3-.2.5-.7.8-1l1.5-1a10.8 10.8 0 0 0 3.5-3.1 17.8 17.8 0 0 1 5.7-5.2c.8-.4 1.9-.3 2.7 0l.8.7c1 .7 2.3 1.3 3.9 1.8 1.5.4 1.9 1.4 3 2.5.7.5 1.3 1 2 1.3l.4.4 2 1.4a67 67 0 0 1 3.2 3.1l.4.7c.8.7 1.6 1.5 2.6 2l2.7 1.6c-9.2.4-17.7-.2-27 0H299l-1.8.1h-8.8l2.7-4.5z" />
      <path d="m327.3 253.7-2.3-1.4c-1-.5-1.8-1.3-2.6-2l-.4-.7a67 67 0 0 0-3.2-3.1l-2-1.4-.3-.4a8.5 8.5 0 0 1-2-1.3l-1.9-2a7.5 7.5 0 0 1 1.3-.7c.6-.4 1.5-.3 2.2 0l.7.5c.8.7 1.9 1.1 3.2 1.5 1.3.4 1.6 1.2 2.6 2.1.5.5 1 .8 1.6 1.1l.3.3 1.7 1.3 2.7 2.5.3.6c.7.6 1.3 1.3 2.1 1.6l2.3 1.4h-6.2z" />
      <path d="m319.1 242.4.9.3c1.3.4 1.6 1.2 2.6 2.1.5.5 1 .8 1.6 1.1l.3.3 1.7 1.3a63 63 0 0 1 2.7 2.5l.3.6c.7.6 1.3 1.3 2.1 1.6.7.3 1.3.8 2 1.2l5-.1c-.6-.4-1.2-1-2-1.3-.7-.3-1.3-1-1.9-1.5l-.3-.5-2.4-2.3-1.6-1.1-.2-.3a6.2 6.2 0 0 1-1.5-1c-1-.8-1.2-1.6-2.4-2a9 9 0 0 1-2.9-1.3c-.2-.1-.4-.4-.6-.4-.6-.3-1.5-.4-2 0a9.8 9.8 0 0 0-1.4.8z" />
      <path d="m327.6 244.4.8.9 1.5 1 .2.3 1.6 1 2.4 2.4.3.5c.6.6 1.2 1.2 2 1.5l1.3.8h6c-.6-.4-1-.8-1.7-1l-1.5-1.3-.3-.4a93.8 93.8 0 0 0-2-1.9l-1.2-.9-.2-.2a5 5 0 0 1-1.2-.8c-.7-.7-1-1.3-1.9-1.6a7.3 7.3 0 0 1-2.4-1l-.4-.4c-.6-.2-1.2-.3-1.7 0a9.5 9.5 0 0 0-1.6 1v.1z" />
      <path d="M343.3 252.5a7.4 7.4 0 0 0-1.3-.8l-1.5-1.2-.3-.4c-.6-.7-1.2-1.3-2-1.9l-1.2-.9-.2-.2a5.7 5.7 0 0 1-1.2-.8c-.6-.6-.9-1-1.5-1.4a6.3 6.3 0 0 1 1-.7c.5-.2 1 0 1.5 0l.4.4c.5.4 1.2.7 2 1 .9.2 1 .7 1.7 1.3.3.2.6.5 1 .6l.2.3 1 .7 1.7 1.6.2.4 1.3 1 1.5.9h-4.3z" />
    </g>
    <path
      fill="none"
      stroke="#00633b"
      strokeWidth={0.1}
      d="M303.2 239c.4 0 .2-.2.6 0m-1.5.5c.5 0 .7-.4 1 0m-1.4.3c.2 0 .3-.2 1 .2m-1.5.4h1m-1.6.4c.5-.1.7.2 1.3.1m-1.9.5h1.4m-2 .6h.7c.5 0 .4.1.8 0m-1.9.5c.7 0 1 0 1.4.2m-2.3 1.1h1.4m-11 10c1.8-.4 4 0 6-.3m3.8-10.3c.5-.2.4 0 1 0h.7m-2.4 1.1c.5-.2 1 0 1.5 0m-.3.5c-.5-.1-1 0-1.6 0m1.2.6a2.9 2.9 0 0 0-1.7 0m-.8.4c.7 0 1.4-.2 2.1 0m-2.6.6c.7-.3 1.4 0 2.2 0m-3 .4h2.3c.1 0 .4-.2.5 0m-.2.4c-1.2.2-2.3 0-3.5.1m2.8.5c-.3 0-1 .2-1.5.1h-.3a4.2 4.2 0 0 0-1.7.1m-.2.4a1 1 0 0 1 .7 0h2.1l.6.3m-3.9 0h1.6l2 .4m-4 0c.5 0 1 0 1.6.2l2.1.1m-4.4 0c.7.3 1.5 0 2.2.2l2.1.2m-4.8.2c1.1 0 2.2 0 3.4.2.3 0 .8.2 1.2.1m-5 .2c1.1.2 2.2 0 3.3.3l1.5.2m-5.2.3.3-.1h2.6c.7 0 1.5 0 2.2.2m-5.5.5c1.7-.2 3.5 0 5.2 0m-5.5.5c1.8.2 3.7 0 5.5.1m-5.8.4c.8.2 1.6 0 2.4.1.6.1 1.1.2 1.7.1h1.5m7.4-7.6h.2m-.4.2h.2m-.4.3h.4m-.5.2h.4m-.8.3.8.1m-1 .4 1-.1h-.1m-1.3.5h1.3m-1.6.4h1.4m-1.6.4h1.6m-2 .5 1 .2c.3.1.6 0 .8 0m-1.8.2 1.6.2m-2 .2c.5 0 1 0 1.4.2h.6m-2.5.4c.5-.2 1.2 0 1.8.1h.6m-2.5.4c.6-.2 1.3-.2 2 0h.3m-2.7.5c.8.1 1.7-.1 2.6.1m-2.9.2c.7.3 1.5 0 2.2.2.3.1.5.1.8 0m-3.5.4c.3-.1.7-.2 1-.1.8.2 1.6.1 2.3.2m-3.6.4c.1 0 .3.1.4 0h3.2m-4 .4c1 .3 1.8 0 2.7.3h1.2m-4.1.3c1.3 0 2.5 0 4 .2m3.3-7.5h.3m-.5.3h.5m-.6.4h.6m-.8.5h.8m-1 .5 1-.1m-1.1.4h1m-1.2.6h1.3m-1.3.4h1.4m-1.6.6h1.5m-1.7.5c.2 0 .4-.2.6-.1h1m-1.7.6c.6-.2 1.2.2 1.8-.2m-2 .8h2m-2 .5c.6-.2 1.4 0 2 0m-2.5.5 2.8-.2m-2.7.7c1-.2 2 0 3.1-.1m-3.3.7c1 .1 1.3 0 2.3-.1l1.2-.2h.6m-4 .6c1.5-.2 3 .1 4.6-.3m-11.3 0h1.2m4.7.3c.2 0 .3-.1.4 0m5.4-.1c1.3-.2 2.5.2 3.8 0m-4.4-.5c.8-.2 1.5 0 2.3.1l.1.2h2m-8.9-.3h-.8m-4.1-.2-1.7.1m12.1-11.8h.3m-.2.3h.3m-.2.6.4-.1m-.3.4h.6m0 .4h-.5m.3.6a.8.8 0 0 1 .5-.1m.3.4h-.8m.2.4.8-.1m.2.6h-.9m.2.6c.4 0 .7 0 1-.2m0 .3-.9.2m.2.6c.4-.2.9 0 1.2-.2m.1.5h-.9l-.3.1m.2.8c.3-.1.5-.3.8-.3h.6m.2.4-1.4.2m.1.6 1.6-.3m-1.5 1 1.8-.4m.4.4c-.7.1-1.4 0-2 .3m.2.6s.1.1.2 0a4 4 0 0 1 2-.3m0 .4c-.5.4-1.3.2-2 .3h-.2m.2.5 2.3-.2m.5.5h-1.8c-.3 0-.5.2-.8.3m0 .5h.4c.8-.5 1.6-.4 2.5-.4m.2.5c-.7 0-1.4-.2-2.1 0-.3.1-.5.3-.8.3m.3.5 1-.3h2.4m0 .4c-.4-.1-1-.2-1.3 0-.7.1-1.3.3-2 .3m.4.4c.5 0 1-.3 1.6-.4h1.3m-3 .7c1-.1 1.7 0 2.6-.3h.9m0-.3c1.4.1 2.8-.1 4.1.2m-3.8.3.4-.1h3.4m-.4-2.9h.2m-.1.4c.1 0 .2-.2.4 0m-.3.4h.7m-.5.6c.2-.3.6 0 .8-.2m-.6.8c.3-.3.7 0 1-.3m-1 .7c.5-.2 1 0 1.4-.3m-1.2.7c.7-.3 1.5.1 2.1-.4m-2 .7c.8-.2 1.7 0 2.6 0m.6 0h4.6m-5.3-.6c1.4.2 3.4 0 5.1.2m-12.6-10.6 1.1-.2m-.8.4 1.2-.1m-.7.6.8-.2h.4m-.9.4h1.5m.2.3-1.2.1m.8.5 1-.2m.5.4h-1.2m.6.5 1-.2m.6.5h-1m.5.5 1.2-.1m.4.2-1 .2m.5.5c.3-.2.9 0 1.3-.2m.4.5h-1l-.4.1m2.6.8-1.5.1m.5.6c.5-.2 1.1-.2 1.6-.3m-.4 1.7h.8c.8-.2 1-.4 1.7-.3m.5.4-2.2.2-.4.1m.4.4c.8-.2 2-.1 2.7-.3m.8.5-2 .1-1 .1m.7.5h.3c.6-.4 1.7-.4 2.6-.4m.5.5h-1.9l-.9.2m.8.5c.8-.2 2.3-.3 1.4-.3h1.9m.2.3a4.3 4.3 0 0 0-1.5 0c-.4.2-.3.3-1.4.3m.4.2 1.2-.1 1.5-.1m-2.4.4h2.7m-16.2-11h.7c0-.2.2 0 .3-.2h.3m-1.7-.2h.8c-.1-.2.2 0 .2-.1h.4m5.5 6c.2-.1.2-.2.6-.1-.1-.2.3 0 .4-.1h.5m0 1.5c.5 0 1.2 0 1.7-.3m.8.6c-.6.1-1.6 0-2.1.3m-8-8.4c-.6 0-.7.2-1.1.2m8 1.6 1-.2m-.7.5c.4-.1.7 0 1-.2m-.7.5.7-.1h.4m-.7.4h1.2m.3.2a4 4 0 0 0-1.2.2m.4.4 1.3-.2m.5.3-1.3.1m.4.4c.3 0 1.2 0 1.3-.2m.5.5h-1.2m.4.4 1.3-.1m.4.2c-.2.2-.9.2-1.1.3m.6.4c.3-.2.8 0 1.2-.2m.4.4h-1c0 .1-.1.2-.3.1m2.4.8-1.4.1m.5.5c.4-.2 1-.2 1.5-.3m-.3 1.7.6-.1c.8-.1.9-.3 1.6-.3m.4.4-2 .2-.4.1m.4.3c.7 0 1.8 0 2.5-.2m.7.4-1.7.1-1 .2m.6.4h.3c.6-.4 1.5-.3 2.4-.3m.5.4H332l-.9.2m.6.4 1.5-.2h1.7m.2.3h-1.4c-.2 0-.3.2-1.5.2m.4.3 1.3-.2h1.4m-2.1.4 1.7-.1h.7m-15-10.1c.3-.1.2-.2.5-.1l.5-.1h.3m-1.7 0c.2-.2.2-.3.6-.2l.4-.1h.4m5.2 5.5c.2-.1 0-.2.4-.1-.1-.2.3 0 .4-.1h.5m0 1.5 1.5-.4m.8.6c-.6.1-1.4 0-1.8.2m-7.5-7.6a2.3 2.3 0 0 0-1.4.5m8.6 2.5.9-.1m-.7.3 1-.1m-.7.4.7-.1h.3m-.7.3h1.1m.2.2h-.9m.5.4.8-.2m.4.3h-1m.3.4 1-.2m.4.4h-1m.4.3 1-.1m.3.2-.9.2m.3.3 1.1-.1m.3.3h-1m1.9.7-1.2.1m.4.3 1.2-.2m-.3 1.2h.6l1.2-.2m.3.3-1.5.2h-.4m.3.3 2-.2m.6.3H336a7.3 7.3 0 0 1-.9.2m.5.4.6-.2 1.6-.1m.3.3H337l-.9.3m.6.2 1.2-.2h1.3m.2.2h-1c-.3.1-.5.2-1.3.2m.3.2 1-.1 1.1-.1m-1.7.4h1.4l.5-.1m-11.5-7.7c.2 0 .2-.2.5-.2h.6m-1.4 0c.2-.1.2-.2.5-.2h.6m3.8 4.2.5-.1h.3c0-.1.3 0 .4 0m0 1c.3 0 .8 0 1.1-.2m.6.4c-.4.1-1 0-1.5.2m-5.6-5.9c-.4 0-.5.2-.8.4m7 .9 1-.1m-.7.3.9-.1m-.6.4.6-.1h.3m-.6.4 1-.2m.2.2c-.2 0-1 0-1 .2m.4.2s.7-.2.9-.1m.4.2-1 .1m.3.2 1-.1m.3.3-1 .1m.4.3 1-.1m.3.1-1 .2m.4.3 1-.1m.3.3h-1m1.8.6-1 .1m.2.3 1.3-.2m-.4 1.2.5-.1c.6 0 .7-.2 1.2-.1m.2.2a12.4 12.4 0 0 1-1.7.2m.2.3a36.3 36.3 0 0 1 1.9-.2m.5.3H342l-.8.2m.4.3.5-.1 1.5-.2m.4.3h-1.2l-1 .2m.6.3 1.2-.2h1.2m.2.2a3 3 0 0 0-1 0 3 3 0 0 1-1.2.2m.3.1 1-.1h1m-1.7.3h1.3l.5-.1m-10.6-7.1.4-.1h.6m-1.3-.1c.2 0 .2-.2.4-.1h.4l.2-.1m3.6 3.9h.4c0-.2.2 0 .3-.1h.3m0 1c.3 0 .8 0 1.1-.2m.6.4-1.5.1m-5-5.4c-.5 0-.6.2-.9.3"
    />
    <g fill="#fc0">
      <path d="m287.6 298.6.6 4.5c-1.1-.4-2.2.2-2.7 1.2-.9 1.7-.1 3 1.5 3.7l2.1 1.2 4-7.8-1.6-.8-1.6 3.1-.4-4.1-1.9-1zm.6 5.9.9.3h.1l-1 2.2-.3-.1c-.7-.4-1.2-.9-.8-1.7.3-.6.7-.8 1.1-.7z" />
      <path
        fillRule="evenodd"
        d="m280.7 302.7 1-1.6-2.3-1.6.8-1.2 2.3 1.6 1.4-2-2.5-1.6.9-1.3 3.8 2.7-4.8 7.2-3.9-2.6.8-1.2z"
      />
      <path d="m279 292.5-2 2.5-.7-.6c-1.4-1.2-2.8-1.2-4 .2-1.3 1.5-.8 2.9.6 4.1l1.9 1.6 5.6-6.7-1.3-1.1zm-4.4 2.8c.3 0 .7.3 1 .6l.3.2-1.6 1.8-.2-.2c-.7-.6-1-1-.4-1.9.4-.4.6-.5 1-.5z" />
      <path
        fillRule="evenodd"
        d="m268.4 294.6-1.2-1.3 3.6-3.3c.8-.7 1.9-1.8.9-3-1-1-2.3 0-3 .6L265 291l-1.2-1.3 3.9-3.5c1.6-1.4 3.4-1.8 5 0 1.7 1.8 1.1 3.6-.5 5l-3.8 3.5z"
      />
      <path d="M265.1 278.1c-.5 0-1 .1-1.5.5-.8.5-1.4 1.5-.9 2.5-.6-.3-1.3 0-1.9.3-1.4 1-1.4 2.2-.4 3.6l1.3 1.8 7.2-5-1.6-2.2c-.6-.8-1.3-1.4-2.2-1.5zm0 1.9c.5 0 1 .4 1.3.9l.2.3-1.8 1.2-.2-.2c-.4-.6-.9-1.4 0-2l.5-.2zm-2.5 2.5c.3 0 .6.2.8.6l.1.2-1.7 1.2v-.2c-.5-.6-.6-1 .1-1.5l.7-.3z" />
      <path
        fillRule="evenodd"
        d="m264.6 275.3-7.7 4.2-.8-1.6 6.3-3.4-1.1-2.2 1.2-.7zm-11.4-3.5 8-3.5.6 1.6-8 3.5zm-1-9.5a2.7 2.7 0 0 0-.3 2.2c.6 1.5 2.3 2 3.7 1.5 1.4-.4 2.5-1.8 2-3.4a2.8 2.8 0 0 0-1.5-1.6l1.9-.6c.5.5 1 1 1.1 1.8a4.5 4.5 0 0 1-2.9 5.6c-2.4.7-5-.3-5.8-2.8a4.7 4.7 0 0 1-.2-2.1l2-.6z"
      />
      <path d="m256.4 250.6-8.2 5 .2 1.3 9.4 2-.3-1.9-2-.4-.5-3.1 1.7-1-.3-1.9zm-2.7 3.6.4 2.1-3.3-.4 2.9-1.7zm-2-19.9c-2.2 0-4 1.6-4.2 4l-.2 2.6 8.7.7.2-2.5a4.3 4.3 0 0 0-4-4.8h-.4zm-.3 2a3 3 0 0 1 .6 0c1.6.1 2.6 1 2.4 3v.2l-5.2-.4v-.3c.1-1.6.9-2.4 2.2-2.5z" />
      <path
        fillRule="evenodd"
        d="m250.2 229.5 1.9.4.6-2.8 1.4.3-.6 2.8 2.3.5.6-2.9 1.5.3-1 4.6-8.5-1.8 1-4.6 1.4.3zm3.3-11.4 1.8.6 1-2.6 1.4.6-1 2.6 2.2.8 1-2.7 1.4.5-1.7 4.4-8.1-3.1 1.7-4.4 1.4.5zm8.9-2.3-7.8-4 .8-1.5 6.4 3.3 1.2-2.2 1.3.6zm1.9-15.9c-.6 0-1 .2-1.4.7a1 1 0 0 0 0 1.5c1.3.8 3-2.4 5.3-.7 1.4 1 1.7 2.7.6 4.2-.8 1-1.9 1.3-3 1.2l-.2-1.6c.7.3 1.5.1 2-.5.4-.6.2-1.3-.4-1.7-.7-.5-1.4 0-2 .4-1 .7-2 1-3.1.2a2.6 2.6 0 0 1-.6-3.6 3.9 3.9 0 0 1 2.3-1.5l.5 1.4z"
      />
      <path d="m268.1 192.3-1 1 4 8.7 1.3-1.4-.7-1.7 2.1-2.3 1.8.8 1.3-1.4-8.7-3.8zm1.4 2.4 2.8 1.3-1.4 1.4-1.4-2.7z" />
      <path
        fillRule="evenodd"
        d="m278.3 195-5.5-6.8 1.4-1.1 4.5 5.6 2-1.6 1 1.2zm4.5-14 1.6-1 1.8 9.5-.8.5-7.8-5.7 1.6-1 5 3.8z"
      />
      <path d="m290.6 176.8-1.3.6.5 9.6 1.7-.7v-2l2.8-1.4 1.4 1.4 1.7-.7-6.8-6.8zm.3 2.9 2.2 2.2-1.8.8-.3-3zm9.4-6-1.4.3-2.4.7 2.5 8.3 2.4-.6a4.3 4.3 0 0 0 3-5.5c-.6-1.9-2.1-3.1-4-3.1zm0 1.9c1 0 1.8.7 2.2 2 .4 1.4 0 2.7-2 3.2l-.2.1-1.5-5 .3-.1 1.2-.2zm10.5-4.3h-.5a4.4 4.4 0 0 0-3.8 5.1 4.4 4.4 0 0 0 5 4 4.5 4.5 0 0 0 3.9-5.1 4.5 4.5 0 0 0-4.6-4zm-.2 1.9c1.4-.2 2.5 1 2.7 2.3.2 1.1-.7 2.8-2 3-1.4.1-2.6-1.2-2.8-2.4-.1-1.3.7-2.7 2.1-2.9zm7.4-2.4v8.8h1.7V176l2.2 3.5h2.1l-2.5-3.7c1.2-.1 1.9-1.2 1.9-2.4 0-1.8-1.2-2.6-3-2.6H318zm1.8 1.6h.3c.8 0 1.5.2 1.4 1.2 0 1-.6 1.2-1.5 1.2h-.2v-2.4z" />
      <path
        fillRule="evenodd"
        d="m336.6 174.3-.5 2 2.7.6-.3 1.4-2.8-.7-.5 2.3 2.8.8-.4 1.4-4.5-1.2 2.1-8.4 4.5 1.1-.3 1.5zm6.6 0 1.2.5 2.1 7.5 2.2-5.5 1.7.7-3.3 8.3-1.2-.5-2.2-7.5-2.2 5.5-1.6-.6zm9.3 14.3 4.7-7.4 1.5 1-3.9 6 2.1 1.4-.8 1.2z"
      />
      <path d="m365.4 186.6-8.4 4.7 1.4 1.2 1.8-1 2.4 2-.6 2 1.5 1.1 3-9.1-1.1-.9zm-1.3 2.5-1 3-1.6-1.3 2.6-1.7zm14.3 11.2-9.2 2.3 1 1.5 2-.4 1.8 2.5-1 1.7 1 1.5 5.3-8-.9-1.2zm-1.8 2-1.8 2.6-1.1-1.6 2.9-1z" />
      <path
        fillRule="evenodd"
        d="m375.4 211.9-.8-1.6 8.7-2.7.6 1.1-4.1 4.6 6-.6.6 1.1-7.3 5.3-.9-1.6 4.6-3.1-6 .6-.2-.5 4-4.3zm11.6 8.3-1.8.6 1 2.7-1.5.5-.9-2.7-2.2.7 1 2.8-1.5.5-1.5-4.5 8.3-2.7 1.5 4.4-1.4.5z"
      />
      <path d="m390.3 225.7-8.6 1.8.4 1.8 3.4-.8-3 3 .6 2 3-3.2a2.2 2.2 0 0 0 2.7 1.2c1.9-.3 2.4-1.7 2-3.4l-.5-2.4zm-1.1 2.1v.2c.2.9.1 1.6-.8 1.7-1 .3-1.3-.3-1.5-1.2v-.2l2.3-.5z" />
      <path
        fillRule="evenodd"
        d="m392 236-8.6 1-.2-1.7 8.7-1zm-1.8 9.5a3 3 0 0 0 .8-2c0-1.7-1.5-2.7-3-2.6-1.5 0-3 1-2.9 2.6 0 .8.4 1.5 1 2h-2a4.8 4.8 0 0 1-.6-2 4.5 4.5 0 0 1 4.4-4.5c2.5 0 4.7 1.7 4.8 4.4a4.4 4.4 0 0 1-.5 2h-2z"
      />
      <path d="m383.7 247.1-.2 1.9 1.8.9-.4 3.1-2 .5-.2 1.8 9.3-2.2.2-1.4-8.5-4.6zm3 3.6 2.7 1.2-3 .7.3-2z" />
      <path
        fillRule="evenodd"
        d="M384 272.1a2.8 2.8 0 0 0 1.6-1.5c.7-1.6-.4-3-1.8-3.6-1.3-.5-3-.1-3.7 1.4a2.8 2.8 0 0 0 .2 2.2l-2-.7a4.9 4.9 0 0 1 .3-2.1 4.5 4.5 0 0 1 5.8-2.5c2.4.9 3.7 3.4 2.8 5.9a4.6 4.6 0 0 1-1.3 1.7l-1.9-.8zm-1.4 4.7-1.7-.9-1.3 2.5-1.3-.7 1.3-2.5-2-1.1-1.5 2.6-1.3-.7 2.3-4.2 7.6 4.2-2.2 4.1-1.3-.7zm-1.7 6.4-.7 1-7.7.3 4.7 3.5-1 1.4-7.3-5.2.8-1 7.7-.3-4.8-3.5 1.1-1.4zm-9 8.7 1.2-1.3 1 1-3.7 4-1-1 1.2-1.4-5.2-5 1.2-1.3z"
      />
      <path d="m362.8 290.7-1.4 1.1 2.3 2.8-4-1.3-1.6 1.4 4.3 1.1c-.8 1-.6 2.2.2 3 1.1 1.5 2.6 1.3 4 .2l1.8-1.6-5.6-6.7zm1.7 5 1.5 1.8-.2.1c-.6.5-1.2.8-1.8 0-.7-.7-.3-1.3.4-1.8l.1-.2zm-7.1-.4-1.6 1 .3 1.9-2.7 1.6-1.5-1.1-1.6 1 7.7 5.7 1.1-.7-1.7-9.5zm-1 4.5.8 3h-.1l-2.4-2 1.7-1z" />
      <path
        fillRule="evenodd"
        d="m348.7 300.3 3.8 8-1.6.7-3-6.5-2.4 1-.6-1.3z"
      />
    </g>
  </svg>
)

export default SvFlag
